/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerMutationQuotaManager$;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.QuotaType$ControllerMutation$;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]v!\u0002\u000f\u001e\u0011\u0003\u0011c!\u0002\u0013\u001e\u0011\u0003)\u0003\"\u0002\u0017\u0002\t\u0003i\u0003b\u0002\u0018\u0002\u0005\u0004%\ta\f\u0005\u0007g\u0005\u0001\u000b\u0011\u0002\u0019\t\u000bQ\nA\u0011A\u001b\u0007\t\u0011j\u0002A\u0013\u0005\t\u001d\u001a\u0011)\u0019!C\u0005\u001f\"A1K\u0002B\u0001B\u0003%\u0001\u000b\u0003\u0005?\r\t\u0015\r\u0011\"\u0003U\u0011!AfA!A!\u0002\u0013)\u0006\u0002C-\u0007\u0005\u000b\u0007I\u0011\u000b.\t\u0013\u00054!\u0011!Q\u0001\nm\u0013\u0007\u0002C2\u0007\u0005\u000b\u0007I\u0011\u00023\t\u0011A4!\u0011!Q\u0001\n\u0015D\u0001\"\u001d\u0004\u0003\u0006\u0004%IA\u001d\u0005\t{\u001a\u0011\t\u0011)A\u0005g\")AF\u0002C\u0001}\"9\u00111\u0002\u0004\u0005R\u00055\u0001bBA\u0011\r\u0011%\u00111\u0005\u0005\b\u0003O1A\u0011KA\u0015\u0011\u001d\t\tE\u0002C!\u0003\u0007Bq!a\u0013\u0007\t\u0003\ni\u0005C\u0004\u0002~\u0019!\t!a \t\u000f\u0005ud\u0001\"\u0001\u0002\f\"9\u00111\u0014\u0004\u0005\u0002\u0005u\u0005bBAN\r\u0011\u0005\u00111\u0015\u0005\b\u0003O3A\u0011AAU\u0003y\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'O\u0003\u0002\u001f?\u000511/\u001a:wKJT\u0011\u0001I\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0019\u0013!D\u0001\u001e\u0005y\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'o\u0005\u0002\u0002MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0012\u0002=E+x\u000e^1D_:$(o\u001c7mKJlU\u000f^1uS>tG)\u001a4bk2$X#\u0001\u0019\u0011\u0005\u001d\n\u0014B\u0001\u001a)\u0005\u0019!u.\u001e2mK\u0006y\u0012+^8uC\u000e{g\u000e\u001e:pY2,'/T;uCRLwN\u001c#fM\u0006,H\u000e\u001e\u0011\u0002\u001dQD'o\u001c;uY\u0016$\u0016.\\3NgR\u0019a'\u000f%\u0011\u0005\u001d:\u0014B\u0001\u001d)\u0005\u0011auN\\4\t\u000bi*\u0001\u0019A\u001e\u0002\u0003\u0015\u0004\"\u0001\u0010$\u000e\u0003uR!AP \u0002\u000f5,GO]5dg*\u0011\u0001)Q\u0001\u0007G>lWn\u001c8\u000b\u0005\u0001\u0012%BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001eL!aR\u001f\u0003/E+x\u000e^1WS>d\u0017\r^5p]\u0016C8-\u001a9uS>t\u0007\"B%\u0006\u0001\u00041\u0014A\u0002;j[\u0016l5o\u0005\u0002\u0007\u0017B\u00111\u0005T\u0005\u0003\u001bv\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000611m\u001c8gS\u001e,\u0012\u0001\u0015\t\u0003GEK!AU\u000f\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0016\u0003U\u0003\"\u0001\u0010,\n\u0005]k$aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010@\u0003\u0015)H/\u001b7t\u0013\t\u0001WL\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013BA-M\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001f!\t1WN\u0004\u0002hWB\u0011\u0001\u000eK\u0007\u0002S*\u0011!.I\u0001\u0007yI|w\u000e\u001e \n\u00051D\u0013A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\u001c\u0015\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%A\u0007rk>$\u0018mQ1mY\n\f7m[\u000b\u0002gB\u0019q\u0005\u001e<\n\u0005UD#AB(qi&|g\u000e\u0005\u0002xw6\t\u0001P\u0003\u0002zu\u0006)\u0011/^8uC*\u0011a$Q\u0005\u0003yb\u00141c\u00117jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\fa\"];pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0005F\u0006\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u0001CA\u0012\u0007\u0011\u0015q\u0015\u00031\u0001Q\u0011\u0015q\u0014\u00031\u0001V\u0011\u0015I\u0016\u00031\u0001\\\u0011\u0015\u0019\u0017\u00031\u0001f\u0011\u0015\t\u0018\u00031\u0001t\u0003U\u0019G.[3oiF+x\u000e^1NKR\u0014\u0018n\u0019(b[\u0016$B!a\u0004\u0002\u0018A!\u0011\u0011CA\n\u001b\u0005y\u0014bAA\u000b\u007f\tQQ*\u001a;sS\u000et\u0015-\\3\t\u000f\u0005e!\u00031\u0001\u0002\u001c\u0005y\u0011/^8uC6+GO]5d)\u0006<7\u000fE\u0003g\u0003;)W-C\u0002\u0002 =\u00141!T1q\u0003Q\u0019G.[3oiJ\u000bG/Z'fiJL7MT1nKR!\u0011qBA\u0013\u0011\u001d\tIb\u0005a\u0001\u00037\tAC]3hSN$XM])v_R\fW*\u001a;sS\u000e\u001cH\u0003BA\u0016\u0003{!B!!\f\u00024A\u0019q%a\f\n\u0007\u0005E\u0002F\u0001\u0003V]&$\bbBA\u001b)\u0001\u0007\u0011qG\u0001\u0007g\u0016t7o\u001c:\u0011\u0007q\nI$C\u0002\u0002<u\u0012aaU3og>\u0014\bbBA )\u0001\u0007\u00111D\u0001\u000b[\u0016$(/[2UC\u001e\u001c\u0018a\u00052bG.\u0004(/Z:tkJ,WI\\1cY\u0016$WCAA#!\r9\u0013qI\u0005\u0004\u0003\u0013B#a\u0002\"p_2,\u0017M\\\u0001\u001be\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u000b\u0003\u001f\n)&a\u001d\u0002x\u0005m\u0004cA\u0014\u0002R%\u0019\u00111\u000b\u0015\u0003\u0007%sG\u000fC\u0004\u0002XY\u0001\r!!\u0017\u0002\u000fM,7o]5p]B!\u00111LA7\u001d\u0011\ti&a\u001a\u000f\t\u0005}\u00131\r\b\u0004Q\u0006\u0005\u0014\"\u0001\u0011\n\u0007\u0005\u0015t$A\u0004oKR<xN]6\n\t\u0005%\u00141N\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0015\r\t)gH\u0005\u0005\u0003_\n\tHA\u0004TKN\u001c\u0018n\u001c8\u000b\t\u0005%\u00141\u000e\u0005\u0007\u0003k2\u0002\u0019A3\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Da!!\u001f\u0017\u0001\u0004\u0001\u0014!\u0002<bYV,\u0007\"B%\u0017\u0001\u00041\u0014!\u00058foN#(/[2u#V|G/\u0019$peR1\u0011\u0011QAD\u0003\u0013\u00032aIAB\u0013\r\t))\b\u0002\u0018\u0007>tGO]8mY\u0016\u0014X*\u001e;bi&|g.U;pi\u0006Dq!a\u0016\u0018\u0001\u0004\tI\u0006\u0003\u0004\u0002v]\u0001\r!\u001a\u000b\u0005\u0003\u0003\u000bi\tC\u0004\u0002\u0010b\u0001\r!!%\u0002\u000fI,\u0017/^3tiB!\u00111SAL\u001d\u0011\t)*a\u001a\u000e\u0005\u0005-\u0014\u0002BAM\u0003c\u0012qAU3rk\u0016\u001cH/A\u000boK^\u0004VM]7jgNLg/Z)v_R\fgi\u001c:\u0015\r\u0005\u0005\u0015qTAQ\u0011\u001d\t9&\u0007a\u0001\u00033Ba!!\u001e\u001a\u0001\u0004)G\u0003BAA\u0003KCq!a$\u001b\u0001\u0004\t\t*A\u0006oK^\fVo\u001c;b\r>\u0014HCBAA\u0003W\u000bi\u000bC\u0004\u0002\u0010n\u0001\r!!%\t\u000f\u0005=6\u00041\u0001\u00022\u0006\u00112\u000f\u001e:jGR\u001c\u0016N\\2f-\u0016\u00148/[8o!\r9\u00131W\u0005\u0004\u0003kC#!B*i_J$\b")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;

    public static long throttleTimeMs(QuotaViolationException quotaViolationException, long l) {
        return ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(quotaViolationException, l);
    }

    public static double QuotaControllerMutationDefault() {
        return ControllerMutationQuotaManager$.MODULE$.QuotaControllerMutationDefault();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("tokens", QuotaType$ControllerMutation$.MODULE$.toString(), "Tracking remaining tokens in the token bucket per user/client-id", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", QuotaType$ControllerMutation$.MODULE$.toString(), "Tracking mutation-rate per user/client-id", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    @Override
    public void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        sensor.add(this.clientRateMetricName(metricTags), (MeasurableStat)new Rate());
        sensor.add(this.clientQuotaMetricName(metricTags), (MeasurableStat)new TokenBucket(), this.getQuotaMetricConfig(metricTags));
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(RequestChannel.Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e, timeMs);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Quota violated for sensor (").append(quotaSensor.name()).append("). Delay time: (").append(throttleTimeMs).append(")").toString());
            return throttleTimeMs;
        }
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$ControllerMutation$.MODULE$, time, threadNamePrefix, quotaCallback, ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
    }
}

