/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\n\u0015\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000bM\u0003A\u0011\u0001+\t\u000bm\u0003A\u0011\u0001/\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\tY\u000f\u0001C\u0005\u0003[Dq!!@\u0001\t\u0013\ty\u0010C\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e!9!\u0011\u0005\u0001\u0005\n\t\r\u0002b\u0002B'\u0001\u0011%!q\n\u0002\r\u0007>tg-[4IK2\u0004XM\u001d\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\tC%D\u0001#\u0015\t\u0019c#A\u0003vi&d7/\u0003\u0002&E\t9Aj\\4hS:<\u0017!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002)S5\tA#\u0003\u0002+)\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\faaY8oM&<\u0007C\u0001\u0015.\u0013\tqCCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001E2p]\u001aLwMU3q_NLGo\u001c:z!\t\tD'D\u00013\u0015\t\u0019D#\u0001\u0005nKR\fG-\u0019;b\u0013\t)$G\u0001\tD_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0011\u0007mA$(\u0003\u0002:9\t1q\n\u001d;j_:\u0004\"a\u000f#\u000e\u0003qR!!\u0010 \u0002\rA|G.[2z\u0015\t)rH\u0003\u0002\u0018\u0001*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0013\t)EHA\tBYR,'oQ8oM&<\u0007k\u001c7jGf\f!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\t\u0001\n\u0005\u0002J\u001f:\u0011!*T\u0007\u0002\u0017*\u0011A\nF\u0001\u0005Y&t7.\u0003\u0002O\u0017\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\t\u0001\u0016KA\u0006MS:\\W*\u00198bO\u0016\u0014(B\u0001(L\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Q1QKV,Y3j\u0003\"\u0001\u000b\u0001\t\u000b\u0019:\u0001\u0019A\u0014\t\u000b-:\u0001\u0019\u0001\u0017\t\u000b=:\u0001\u0019\u0001\u0019\t\u000bY:\u0001\u0019A\u001c\t\u000b\u0019;\u0001\u0019\u0001%\u0002\u001f\u0011,7o\u0019:jE\u0016\u001cuN\u001c4jON$\u0002\"X;\u0002\u0014\u0005u\u0011\u0011\u0007\t\u0004=\u001aLgBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011\u0007$\u0001\u0004=e>|GOP\u0005\u0002;%\u0011Q\rH\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007N\u0001\u0003MSN$(BA3\u001d!\tQ'O\u0004\u0002la6\tAN\u0003\u0002n]\u00069Q.Z:tC\u001e,'BA8@\u0003\u0019\u0019w.\\7p]&\u0011\u0011\u000f\\\u0001\u001c\t\u0016\u001c8M]5cK\u000e{gNZ5hgJ+7\u000f]8og\u0016$\u0015\r^1\n\u0005M$(!\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN,H\u000e\u001e\u0006\u0003c2DQA\u001e\u0005A\u0002]\fQC]3t_V\u00148-\u001a+p\u0007>tg-[4OC6,7\u000fE\u0002_Mb\u00042!_A\u0007\u001d\rQ\u0018\u0011\u0002\b\u0004w\u0006\u001dab\u0001?\u0002\u00069\u0019Q0a\u0001\u000f\u0007y\f\tA\u0004\u0002a\u007f&\t1)\u0003\u0002B\u0005&\u0011q\u0003Q\u0005\u0003_~J!!\u001c8\n\u0007\u0005-A.\u0001\u000eEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002\u0010\u0005E!a\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN|WO]2f\u0015\r\tY\u0001\u001c\u0005\b\u0003+A\u0001\u0019AA\f\u0003=Ign\u00197vI\u0016\u001c\u0016P\\8os6\u001c\bcA\u000e\u0002\u001a%\u0019\u00111\u0004\u000f\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0004\u0005A\u0002\u0005\u0005\u0012!\u00039sS:\u001c\u0017\u000e]1m!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tA!Y;uQ*\u0019\u00111\u00068\u0002\u0011M,7-\u001e:jifLA!a\f\u0002&\tq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0007bBA\u001a\u0011\u0001\u0007\u0011qC\u0001\u0015S:\u001cG.\u001e3f\t>\u001cW/\\3oi\u0006$\u0018n\u001c8\u0002-\r\u0014X-\u0019;f)>\u0004\u0018nY\"p]\u001aLw-\u00128uef$\"\"!\u000f\u0002`\u0005=\u00141QAC)\u0019\tY$!\u0011\u0002VA\u0019!.!\u0010\n\u0007\u0005}BOA\u000fEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001cx.\u001e:dKJ+7/\u001e7u\u0011\u001d\t\u0019%\u0003a\u0001\u0003\u000b\nAA\\1nKB!\u0011qIA(\u001d\u0011\tI%a\u0013\u0011\u0005\u0001d\u0012bAA'9\u00051\u0001K]3eK\u001aLA!!\u0015\u0002T\t11\u000b\u001e:j]\u001eT1!!\u0014\u001d\u0011\u001d\t9&\u0003a\u0001\u00033\nQA^1mk\u0016\u00042aGA.\u0013\r\ti\u0006\b\u0002\u0004\u0003:L\bbBA1\u0013\u0001\u0007\u00111M\u0001\nY><7i\u001c8gS\u001e\u0004B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003S2\u0012a\u00017pO&!\u0011QNA4\u0005%aunZ\"p]\u001aLw\rC\u0004\u0002r%\u0001\r!a\u001d\u0002\u0015Q|\u0007/[2Qe>\u00048\u000f\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003{\nAA[1wC&!\u0011\u0011QA<\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003+I\u0001\u0019AA\f\u0011\u001d\t\u0019$\u0003a\u0001\u0003/\t!CZ5mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5hgR1\u00111RAQ\u0003[\u0003b!!$\u0002\u0018\u0006mUBAAH\u0015\u0011\t\t*a%\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u0013\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\u0006=%A\u0002\"vM\u001a,'\u000fE\u0004\u001c\u0003;\u000b)%!\u0017\n\u0007\u0005}ED\u0001\u0004UkBdWM\r\u0005\b\u0003GS\u0001\u0019AAS\u0003\u001d\u0019wN\u001c4jON\u0004\u0002\"a*\u0002*\u0006\u0015\u0013\u0011L\u0007\u0003\u0003'KA!a+\u0002\u0014\n\u0019Q*\u00199\t\u000f\u0005=&\u00021\u0001\u00022\u0006Y1m\u001c8gS\u001et\u0015-\\3t!\u0011Y\u0002(a-\u0011\r\u0005\u001d\u0016QWA#\u0013\u0011\t9,a%\u0003\u0007M+G/\u0001\u000bwC2LG-\u0019;f\u0007>tg-[4Q_2L7-\u001f\u000b\t\u0003{\u000b\u0019-!5\u0002XB\u00191$a0\n\u0007\u0005\u0005GD\u0001\u0003V]&$\bbBAc\u0017\u0001\u0007\u0011qY\u0001\te\u0016\u001cx.\u001e:dKB!\u0011\u0011ZAg\u001b\t\tYM\u0003\u0002,]&!\u0011qZAf\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016Dq!a5\f\u0001\u0004\t).\u0001\td_:4\u0017nZ#oiJLWm]'baBA\u0011qUAU\u0003\u000b\n)\u0005C\u0004\u0002 -\u0001\r!!\t\u0002/\r\u0014X-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ#oiJLH\u0003CAo\u0003G\f9/!;\u0015\r\u0005m\u0012q\\Aq\u0011\u001d\t\u0019\u0005\u0004a\u0001\u0003\u000bBq!a\u0016\r\u0001\u0004\tI\u0006C\u0004\u0002f2\u0001\r!a\u0006\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001eDq!!\u0006\r\u0001\u0004\t9\u0002C\u0004\u000241\u0001\r!a\u0006\u00029\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7nQ8oM&<WI\u001c;ssR!\u0011q^A{)\u0019\tY$!=\u0002t\"9\u00111I\u0007A\u0002\u0005\u0015\u0003bBA,\u001b\u0001\u0007\u0011\u0011\f\u0005\u0007W5\u0001\r!a>\u0011\t\u0005%\u0017\u0011`\u0005\u0005\u0003w\fYM\u0001\bBEN$(/Y2u\u0007>tg-[4\u0002\u001d\r|gNZ5h'ftwN\\=ngRA!\u0011\u0001B\u0005\u0005\u0017\u0011\t\u0002\u0005\u0003_M\n\r\u0001c\u00016\u0003\u0006%\u0019!q\u0001;\u0003-\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u001c\u0016P\\8os6Dq!a\u0011\u000f\u0001\u0004\t)\u0005C\u0004\u0003\u000e9\u0001\rAa\u0004\u0002\u0011MLhn\u001c8z[N\u0004BA\u00184\u0002F!9!1\u0003\bA\u0002\u0005]\u0011aC5t'\u0016t7/\u001b;jm\u0016\faB\u0019:pW\u0016\u00148+\u001f8p]fl7\u000f\u0006\u0003\u0003\u0010\te\u0001bBA\"\u001f\u0001\u0007\u0011QI\u0001\u0014EJ|7.\u001a:E_\u000e,X.\u001a8uCRLwN\u001c\u000b\u0005\u0003\u000b\u0012y\u0002C\u0004\u0002DA\u0001\r!!\u0012\u0002%\r|gNZ5h%\u0016\u001c\bo\u001c8tKRK\b/\u001a\u000b\u0005\u0005K\u0011I\u0004\u0005\u0003\u0003(\tMb\u0002\u0002B\u0015\u0005_i!Aa\u000b\u000b\u0007\t5b.\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011\tDa\u000b\u0002/\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm\u001d9p]N,\u0017\u0002\u0002B\u001b\u0005o\u0011!bQ8oM&<G+\u001f9f\u0015\u0011\u0011\tDa\u000b\t\u000f\tm\u0012\u00031\u0001\u0003>\u0005Q1m\u001c8gS\u001e$\u0016\u0010]3\u0011\tmA$q\b\t\u0005\u0005\u0003\u00129E\u0004\u0003\u0002J\n\r\u0013\u0002\u0002B#\u0003\u0017\f\u0011bQ8oM&<G)\u001a4\n\t\t%#1\n\u0002\u0005)f\u0004XM\u0003\u0003\u0003F\u0005-\u0017A\u0006:fg>,(oY3OC6,Gk\u001c\"s_.,'/\u00133\u0015\t\tE#q\u000b\t\u00047\tM\u0013b\u0001B+9\t\u0019\u0011J\u001c;\t\u000f\te#\u00031\u0001\u0002F\u0005a!/Z:pkJ\u001cWMT1nK\u0002")
public class ConfigHelper
implements Logging {
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ConfigRepository configRepository;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public List<DescribeConfigsResponseData.DescribeConfigsResult> describeConfigs(List<DescribeConfigsRequestData.DescribeConfigsResource> resourceToConfigNames, boolean includeSynonyms, KafkaPrincipal principal, boolean includeDocumentation) {
        return (List)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            try {
                DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult;
                ConfigResource.Type type = ConfigResource.Type.forId((byte)x0$1.resourceType());
                if (ConfigResource.Type.TOPIC.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult2;
                    String topic = x0$1.resourceName();
                    Topic.validate((String)topic);
                    if ($this.metadataCache.contains(topic)) {
                        void createResponseConfig$1_createConfigEntry;
                        Properties topicProps = $this.configRepository.topicConfig(topic);
                        LogConfig logConfig = LogConfig$.MODULE$.fromProps(LogConfig$.MODULE$.extractLogConfigMap($this.config), topicProps);
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map createResponseConfig$1_configs = ConfigHelper.allConfigs$1(logConfig);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$5((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult2 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else {
                        describeConfigsResult2 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setConfigs(Collections.emptyList());
                    }
                    describeConfigsResult = describeConfigsResult2;
                } else if (ConfigResource.Type.BROKER.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult3;
                    if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                        void createResponseConfig$1_createConfigEntry;
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value);
                        Map<String, String> createResponseConfig$1_configs = $this.config.dynamicConfig().currentDynamicDefaultConfigs();
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs(createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$5((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult3 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else if (this.resourceNameToBrokerId(x0$1.resourceName()) == $this.config.brokerId()) {
                        void createResponseConfig$1_createConfigEntry;
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map createResponseConfig$1_configs = ConfigHelper.allConfigs$1($this.config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$5((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult3 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else {
                        throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" or empty string, but received ").append(x0$1.resourceName()).toString());
                    }
                    describeConfigsResult = describeConfigsResult3;
                } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                    void createResponseConfig$1_createConfigEntry;
                    if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                        throw new InvalidRequestException("Broker id must not be empty");
                    }
                    if (this.resourceNameToBrokerId(x0$1.resourceName()) != $this.config.brokerId()) {
                        throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" but received ").append(x0$1.resourceName()).toString());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)x0$1.resourceType()), x0$1.resourceName());
                    this.validateConfigPolicy(configResource, (Map<String, String>)Map$.MODULE$.empty(), principal);
                    Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
                    scala.collection.mutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                    Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$5((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                    describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                } else if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
                    void createResponseConfig$1_createConfigEntry;
                    String linkName = x0$1.resourceName();
                    if (linkName == null || linkName.isEmpty()) {
                        throw new InvalidRequestException("Cluster link name must not be empty");
                    }
                    UUID linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
                    this.clusterLinkManager().ensureClusterLinkExists(linkId);
                    Properties persistentProps = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
                    ClusterLinkConfig config = this.clusterLinkManager().configEncoder().clusterLinkConfig(persistentProps);
                    Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createClusterLinkConfigEntry(config, (String)name, value);
                    scala.collection.mutable.Map createResponseConfig$1_configs = ConfigHelper.allConfigs$1(config);
                    Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$5((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                    describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                } else {
                    throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                }
                return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
            }
            catch (Throwable e) {
                String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(x0$1).toString();
                if (e instanceof ApiException) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                } else {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                ApiError err = ApiError.fromThrowable((Throwable)e);
                return new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType()).setErrorMessage(err.message()).setErrorCode(err.error().code()).setConfigs(Collections.emptyList());
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        Option<ConfigDef.Type> configEntryType = LogConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull(Predef$.MODULE$.$conforms())));
        List list2 = (List)LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name).map((Function1 & Serializable & scala.Serializable)s -> this.configSynonyms((String)s, this.brokerSynonyms((String)s), isSensitive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym, List$.MODULE$.canBuildFrom());
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public Buffer<Tuple2<String, Object>> filterTopicConfigs(Map<String, Object> configs, Option<Set<String>> configNames) {
        return ((MapLike)configs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$filterTopicConfigs$1(configNames, x0$1)))).toBuffer();
    }

    public void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy;
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava(), principal));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        String string;
        List<String> allNames = this.brokerSynonyms(name);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            String string2 = value instanceof String ? (String)value : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull(Predef$.MODULE$.$conforms())));
            string = string2;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$6)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(readOnly).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createClusterLinkConfigEntry(AbstractConfig config, String name, Object value) {
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = config.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        new DescribeConfigsResponse.ConfigEntry(name, valueAsString, DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG, isSensitive, false, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG.id()).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
    }

    private List<DescribeConfigsResponseData.DescribeConfigsSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config.dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$2$adapted(dynamicConfig.currentDynamicBrokerConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$3$adapted(dynamicConfig.currentDynamicDefaultConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config.documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = (ConfigDef.Type)configType.get();
        DescribeConfigsResponse.ConfigType configType2 = ConfigDef.Type.BOOLEAN.equals(type) ? DescribeConfigsResponse.ConfigType.BOOLEAN : (ConfigDef.Type.STRING.equals(type) ? DescribeConfigsResponse.ConfigType.STRING : (ConfigDef.Type.INT.equals(type) ? DescribeConfigsResponse.ConfigType.INT : (ConfigDef.Type.SHORT.equals(type) ? DescribeConfigsResponse.ConfigType.SHORT : (ConfigDef.Type.LONG.equals(type) ? DescribeConfigsResponse.ConfigType.LONG : (ConfigDef.Type.DOUBLE.equals(type) ? DescribeConfigsResponse.ConfigType.DOUBLE : (ConfigDef.Type.LIST.equals(type) ? DescribeConfigsResponse.ConfigType.LIST : (ConfigDef.Type.CLASS.equals(type) ? DescribeConfigsResponse.ConfigType.CLASS : (ConfigDef.Type.PASSWORD.equals(type) ? DescribeConfigsResponse.ConfigType.PASSWORD : DescribeConfigsResponse.ConfigType.UNKNOWN))))))));
        return configType2;
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$1) {
        return x$1._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return ((scala.collection.mutable.MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$describeConfigs$2(x$1)))).$plus$plus((GenTraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.nonInternalValues()).asScala());
    }

    private final DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig$1(Map configs, Function2 createConfigEntry, DescribeConfigsRequestData.DescribeConfigsResource x1$1) {
        Buffer configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x1$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            Object value = x0$1._2();
            DescribeConfigsResponseData.DescribeConfigsResourceResult describeConfigsResourceResult = (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply((Object)name, value);
            return describeConfigsResourceResult;
        }, Buffer$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$filterTopicConfigs$1(Option configNames$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String configName = (String)x0$1._1();
        boolean recordInterceptorCheck = !configName.equals(LogConfig$.MODULE$.AppendRecordInterceptorClassesProp());
        boolean schemaRegistryUrlCheck = !configName.equals("confluent.schema.registry.url");
        boolean schemaValidatorInterceptorClassCheck = !configName.equals("confluent.schema.validator.interceptor.class");
        boolean multitenantSchemaValidationEnabledCheck = !configName.equals("confluent.schema.validator.multitenant.enable");
        boolean basicAuthCredentialsSourceCheck = !configName.equals("confluent.basic.auth.credentials.source");
        boolean userInfoCheck = !configName.equals("confluent.basic.auth.user.info");
        boolean bearerAuthCredentialsCheck = !configName.equals("confluent.bearer.auth.credentials.source");
        boolean bearerAuthTokenCheck = !configName.equals("confluent.bearer.auth.token");
        boolean sslProtocolCheck = !configName.equals("confluent.ssl.protocol");
        boolean sslKeystoreTypeCheck = !configName.equals("confluent.ssl.keystore.type");
        boolean sslKeystoreLocationCheck = !configName.equals("confluent.ssl.keystore.location");
        boolean sslKeystorePasswordCheck = !configName.equals("confluent.ssl.keystore.password");
        boolean sslKeyPasswordCheck = !configName.equals("confluent.ssl.key.password");
        boolean sslTruststoreTypeCheck = !configName.equals("confluent.ssl.truststore.type");
        boolean sslTruststoreLocationCheck = !configName.equals("confluent.ssl.truststore.location");
        boolean sslTruststorePasswordCheck = !configName.equals("confluent.ssl.truststore.password");
        boolean bl = basicAuthCredentialsSourceCheck && userInfoCheck && bearerAuthCredentialsCheck && bearerAuthTokenCheck && recordInterceptorCheck && schemaRegistryUrlCheck && schemaValidatorInterceptorClassCheck && multitenantSchemaValidationEnabledCheck && sslProtocolCheck && sslKeystoreTypeCheck && sslKeystoreLocationCheck && sslKeystorePasswordCheck && sslKeyPasswordCheck && sslTruststoreTypeCheck && sslTruststoreLocationCheck && sslTruststorePasswordCheck && configNames$1.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((Object)configName)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponseData.DescribeConfigsSynonym x$6) {
        return perBrokerConfig$1 || x$6.source() == DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG.id();
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$2, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable & scala.Serializable)value -> {
            String configValue = isSensitive$2 ? null : value;
            return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(configValue).setSource(source.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponseData.DescribeConfigsSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public ConfigHelper(MetadataCache metadataCache, KafkaConfig config, ConfigRepository configRepository, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.configRepository = configRepository;
        this.alterConfigPolicy = alterConfigPolicy;
        this.clusterLinkManager = clusterLinkManager;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }
}

