/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh!B\u0011#\u0003\u00039\u0003\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011\u0001\u001f\t\u0011!\u0003!\u0011!Q\u0001\nuB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003V\u0001\u0011\u0005a\u000b\u0003\u0005i\u0001\t\u0007I\u0011\u0001\u0012j\u0011\u0019\u0019\b\u0001)A\u0005U\"9A\u000f\u0001b\u0001\n#)\bB\u0002@\u0001A\u0003%a\u000f\u0003\u0005\u0000\u0001\u0001\u0007I\u0011BA\u0001\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\u0012\u0001\u0001\u000b\u0015B&\t\u0013\u0005M\u0001A1A\u0005\u0002\u0005U\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0006\t\u0013\u0005}\u0001A1A\u0005\n\u0005\u0005\u0002\u0002CA\u0015\u0001\u0001\u0006I!a\t\t\u0011\u0005-\u0002\u0001\"\u0001#\u0003\u0003Aq!!\f\u0001\t\u0003\ty\u0003\u0003\u0005\u00026\u0001!\tAIA\u001c\u0011!\tI\u0006\u0001C\u0001E\u0005m\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003g\u0002a\u0011AA;\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!a'\u0001\t#\ti\nC\u0004\u0002(\u0002!\t!!+\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005}v!CAbE\u0005\u0005\t\u0012AAc\r!\t#%!A\t\u0002\u0005\u001d\u0007BB+\u001f\t\u0003\tI\rC\u0005\u0002Lz\t\n\u0011\"\u0001\u0002N\n1\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'O\u0003\u0002$I\u000511/\u001a:wKJT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001+\tA3l\u0005\u0003\u0001S=*\u0004C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021g5\t\u0011G\u0003\u00023I\u0005)Q\u000f^5mg&\u0011A'\r\u0002\b\u0019><w-\u001b8h!\t1\u0014(D\u00018\u0015\tAD%A\u0004nKR\u0014\u0018nY:\n\u0005i:$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006!a.Y7f+\u0005i\u0004C\u0001 F\u001d\ty4\t\u0005\u0002AW5\t\u0011I\u0003\u0002CM\u00051AH]8pizJ!\u0001R\u0016\u0002\rA\u0013X\rZ3g\u0013\t1uI\u0001\u0004TiJLgn\u001a\u0006\u0003\t.\nQA\\1nK\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\f]Vlg)\u001a;dQ\u0016\u00148\u000f\u0005\u0002+\u0019&\u0011Qj\u000b\u0002\u0004\u0013:$\u0018aD3yiJ\fW*\u001a;sS\u000e$\u0016mZ:\u0011\tA\u001bV(P\u0007\u0002#*\u0011!kK\u0001\u000bG>dG.Z2uS>t\u0017B\u0001+R\u0005\ri\u0015\r]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b]#WMZ4\u0011\u0007a\u0003\u0011,D\u0001#!\tQ6\f\u0004\u0001\u0005\u000bq\u0003!\u0019A/\u0003\u0003Q\u000b\"AX1\u0011\u0005)z\u0016B\u00011,\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u00172\n\u0005\r\u0014#!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\u0006w\u0019\u0001\r!\u0010\u0005\u0006\u0013\u001a\u0001\r!\u0010\u0005\u0006\u0015\u001a\u0001\ra\u0013\u0005\b\u001d\u001a\u0001\n\u00111\u0001P\u0003A1W\r^2iKJ$\u0006N]3bI6\u000b\u0007/F\u0001k!\u0011Yg\u000e]-\u000e\u00031T!!\\)\u0002\u000f5,H/\u00192mK&\u0011q\u000e\u001c\u0002\b\u0011\u0006\u001c\b.T1q!\tA\u0016/\u0003\u0002sE\t!\"I]8lKJLE-\u00118e\r\u0016$8\r[3s\u0013\u0012\f\u0011CZ3uG\",'\u000f\u00165sK\u0006$W*\u00199!\u0003\u0011awnY6\u0016\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\t1\fgn\u001a\u0006\u0002w\u0006!!.\u0019<b\u0013\ti\bP\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\u0015]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:\u0016\u0003-\u000b\u0001D\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014x\fJ3r)\u0011\t9!!\u0004\u0011\u0007)\nI!C\u0002\u0002\f-\u0012A!\u00168ji\"A\u0011q\u0002\u0007\u0002\u0002\u0003\u00071*A\u0002yIE\nQC\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014\b%\u0001\tgC&dW\r\u001a)beRLG/[8ogV\u0011\u0011q\u0003\t\u00041\u0006e\u0011bAA\u000eE\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0012M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u0002;bON,\"!a\t\u0011\u000bA\u001b\u0016QE\u001f\u0011\u0007]\f9#\u0003\u0002Gq\u0006)A/Y4tA\u0005yA-Z1e)\"\u0014X-\u00193D_VtG/\u0001\tsKNL'0\u001a+ie\u0016\fG\rU8pYR!\u0011qAA\u0019\u0011\u0019\t\u0019d\u0005a\u0001\u0017\u00069a.Z<TSj,\u0017AC4fi\u001a+Go\u00195feR!\u0011\u0011HA !\u0011Q\u00131H-\n\u0007\u0005u2F\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u0003\"\u0002\u0019AA\"\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!\u0012\u0002V5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0004d_6lwN\u001c\u0006\u0004K\u00055#\u0002BA(\u0003#\na!\u00199bG\",'BAA*\u0003\ry'oZ\u0005\u0005\u0003/\n9E\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0019\u001d,GOR3uG\",'/\u00133\u0015\u0007-\u000bi\u0006C\u0004\u0002BU\u0001\r!a\u0011\u000275\f'o\u001b)beRLG/[8og\u001a{'\u000f\u0016:v]\u000e\fG/[8o)!\t9!a\u0019\u0002h\u0005%\u0004BBA3-\u0001\u00071*\u0001\u0005ce>\\WM]%e\u0011\u001d\t\tE\u0006a\u0001\u0003\u0007Bq!a\u001b\u0017\u0001\u0004\ti'\u0001\tueVt7-\u0019;j_:|eMZ:fiB\u0019!&a\u001c\n\u0007\u0005E4F\u0001\u0003M_:<\u0017aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$G#B-\u0002x\u0005m\u0004BBA=/\u0001\u00071*A\u0005gKR\u001c\u0007.\u001a:JI\"9\u0011QP\fA\u0002\u0005}\u0014\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\b\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015E%A\u0004dYV\u001cH/\u001a:\n\t\u0005%\u00151\u0011\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0003]\tG\r\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002\b\u0005=\u0005bBAI1\u0001\u0007\u00111S\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000eZ(gMN,Go\u001d\t\u0007!N\u000b\u0019%!&\u0011\u0007a\u000b9*C\u0002\u0002\u001a\n\u0012\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0003q\tG\r\u001a)beRLG/[8ogR{g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$b!a\u0002\u0002 \u0006\r\u0006BBAQ3\u0001\u0007\u0011,A\u0007gKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\b\u0003KK\u0002\u0019AAJ\u0003YIg.\u001b;jC2|eMZ:fi\u0006sG-\u00129pG\"\u001c\u0018A\u0007:f[>4XMR3uG\",'OR8s!\u0006\u0014H/\u001b;j_:\u001cH\u0003BAV\u0003g\u0003b\u0001U*\u0002D\u00055\u0006c\u0001-\u00020&\u0019\u0011\u0011\u0017\u0012\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\u0005U&\u00041\u0001\u00028\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u000bA\u000bI,a\u0011\n\u0007\u0005m\u0016KA\u0002TKR\f!d\u001d5vi\u0012|wO\\%eY\u00164U\r^2iKJ$\u0006N]3bIN$\"!a\u0002\u0002!\rdwn]3BY24U\r^2iKJ\u001c\u0018AF!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0011\u0005as2C\u0001\u0010*)\t\t)-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0005\u0003\u001f\f)/\u0006\u0002\u0002R*\u001aq*a5,\u0005\u0005U\u0007\u0003BAl\u0003Cl!!!7\u000b\t\u0005m\u0017Q\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a8,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\fINA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$Q\u0001\u0018\u0011C\u0002u\u0003")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends AbstractFetcherThread> Map<String, String> $lessinit$greater$default$4() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    public Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            }).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Added fetcher to broker ").append(fetcherThread.sourceBroker().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        void var2_2;
        scala.collection.mutable.Map fetchStates = Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return var2_2;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BoxedUnit boxedUnit;
                if (x$4 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)x$4._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$4._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError(null);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$5)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$6);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return scala.math.package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ double $anonfun$new$5(AbstractFetcherThread x$1) {
        return x$1.fetcherStats().requestRate().oneMinuteRate();
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        double headRate = BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$5(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$8() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$9() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, BrokerIdAndFetcherId id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = $this.removeFetcherForPartitions(thread.partitions());
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        Map fetchStates = (Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            PartitionFetchState currentFetchState = (PartitionFetchState)x0$1._2();
            InitialFetchState initialFetchState = new InitialFetchState(thread.sourceBroker(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)initialFetchState);
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        $this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)fetchStates);
    }

    /*
     * WARNING - void declaration
     */
    private final void migratePartitions$1(int newSize) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, id, thread);
            return BoxedUnit.UNIT;
        };
        Map<BrokerIdAndFetcherId, T> map = Implicits$.MODULE$.MapExtensionMethods(this.fetcherThreadMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$3) {
        block6: {
            if (x$3 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$3._1();
            initialFetchOffsets = (Map)x$3._2();
            brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
            var6_5 = false;
            var7_6 = null;
            var8_7 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Some)var8_7;
            currentFetcherThread = (AbstractFetcherThread)var7_6.value();
            v0 = currentFetcherThread.sourceBroker();
            var10_9 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                var2_10 = currentFetcherThread;
            } else if (var6_5) {
                ((AbstractFetcherThread)var7_6.value()).shutdown();
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else if (None$.MODULE$.equals(var8_7)) {
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else {
                throw new MatchError((Object)var8_7);
            }
            $this.addPartitionsToFetcherThread(var2_10, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$5) {
        if (x$5 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractFetcherThread)x$5._2()).initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$6) {
        if (x$6 != null) {
            ((AbstractFetcherThread)x$6._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers, Map<String, String> extraMetricTags) {
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = ((MapLike)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))).$plus$plus(extraMetricTags);
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
    }
}

