/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin$RaftLeader$;
import kafka.log.LogAppendInfo;
import kafka.log.LogOffsetSnapshot;
import kafka.log.SnapshotGenerated$;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.SegmentPosition;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001B\u0012%\u0005%B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0019!\u0007\u0001)Q\u0005K\")\u0011\u000e\u0001C!U\")\u0001\u0010\u0001C!s\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\u000b\u0001\t\u0003\ni\u0003\u0003\u0004p\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005u\u0003\u0001\"\u0011\u0002.!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA2\u0001\u0011\u0005\u0013Q\u0007\u0005\u0007\u001d\u0002!\t%!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u00111\u0010\u0001\u0005B\u0005u\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\u0007I\u0002!\t%a#\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u00111\u0013\u0001\u0005B\u0005U\u0005bBAN\u0001\u0011\u0005\u0013\u0011M\u0004\b\u0003;#\u0003\u0012AAP\r\u0019\u0019C\u0005#\u0001\u0002\"\"1Al\bC\u0001\u0003SCq!a+ \t\u0003\ti\u000bC\u0004\u0002t~!I!!>\u0003!-\u000bgm[1NKR\fG-\u0019;b\u0019><'BA\u0013'\u0003\u0011\u0011\u0018M\u001a;\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001UI\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\t1\fgn\u001a\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDF\u0001\u0004PE*,7\r\u001e\t\u0003gij\u0011\u0001\u000e\u0006\u0003KUR!a\n\u001c\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0005\u0003wQ\u0012QBU3qY&\u001c\u0017\r^3e\u0019><\u0017a\u00017pOB\u0011a\bQ\u0007\u0002\u007f)\u0011AHJ\u0005\u0003\u0003~\u00121\"\u00112tiJ\f7\r\u001e'pO\u0006Y1O\\1qg\"|G/\u00133t!\r!\u0015jS\u0007\u0002\u000b*\u0011aiR\u0001\u000bG>t7-\u001e:sK:$(B\u0001%/\u0003\u0011)H/\u001b7\n\u0005)+%!F\"p]\u000e,(O]3oiN[\u0017\u000e\u001d'jgR\u001cV\r\u001e\t\u0003g1K!!\u0014\u001b\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007C\u0001)T\u001b\u0005\t&B\u0001*6\u0003\u0019\u0019w.\\7p]&\u0011A+\u0015\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003Mi\u0017\r\u001f$fi\u000eD7+\u001b>f\u0013:\u0014\u0015\u0010^3t!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000by\u0003\u0017MY2\u0011\u0005}\u0003Q\"\u0001\u0013\t\u000bq*\u0001\u0019A\u001f\t\u000b\t+\u0001\u0019A\"\t\u000b9+\u0001\u0019A(\t\u000bU+\u0001\u0019\u0001,\u0002!=dG-Z:u':\f\u0007o\u001d5pi&#\u0007c\u00014h\u00176\tq)\u0003\u0002i\u000f\nAq\n\u001d;j_:\fG.\u0001\u0003sK\u0006$GcA6ogB\u00111\u0007\\\u0005\u0003[R\u0012A\u0002T8h\r\u0016$8\r[%oM>DQa\\\u0004A\u0002A\f1b\u001d;beR|eMZ:fiB\u0011q+]\u0005\u0003eb\u0013A\u0001T8oO\")Ao\u0002a\u0001k\u0006i!/Z1e\u0013N|G.\u0019;j_:\u0004\"a\r<\n\u0005]$$!C%t_2\fG/[8o\u00039\t\u0007\u000f]3oI\u0006\u001bH*Z1eKJ$BA_?\u0002\fA\u00111g_\u0005\u0003yR\u0012Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007\"\u0002@\t\u0001\u0004y\u0018a\u0002:fG>\u0014Hm\u001d\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA)\u0002\rI,7m\u001c:e\u0013\u0011\tI!a\u0001\u0003\u000fI+7m\u001c:eg\"1\u0011Q\u0002\u0005A\u0002Y\u000bQ!\u001a9pG\"\f\u0001#\u00199qK:$\u0017i\u001d$pY2|w/\u001a:\u0015\u0007i\f\u0019\u0002C\u0003\u007f\u0013\u0001\u0007q0A\u000fiC:$G.Z!oI\u000e{gN^3si2{w-\u00119qK:$\u0017J\u001c4p)\rQ\u0018\u0011\u0004\u0005\b\u00037Q\u0001\u0019AA\u000f\u0003)\t\u0007\u000f]3oI&sgm\u001c\t\u0004}\u0005}\u0011B\u0001?@\u0003Aa\u0017m\u001d;GKR\u001c\u0007.\u001a3Fa>\u001c\u0007\u000eF\u0001W\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0004\u0017\u0006%\u0002BBA\u0007\u0019\u0001\u0007a+A\u0005f]\u0012|eMZ:fiR\u0011\u0011q\u0006\t\u0004g\u0005E\u0012bAA\u001ai\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0015\u0003A\f!\u0002\u001e:v]\u000e\fG/\u001a+p)\u0011\tY$!\u0011\u0011\u0007]\u000bi$C\u0002\u0002@a\u0013A!\u00168ji\"1\u00111I\bA\u0002A\faa\u001c4gg\u0016$\u0018\u0001\u0007;sk:\u001c\u0017\r^3U_2\u000bG/Z:u':\f\u0007o\u001d5piR\u0011\u0011\u0011\n\t\u0004/\u0006-\u0013bAA'1\n9!i\\8mK\u0006t\u0017!F5oSRL\u0017\r\\5{K2+\u0017\rZ3s\u000bB|7\r\u001b\u000b\u0005\u0003w\t\u0019\u0006\u0003\u0004\u0002\u000eE\u0001\rAV\u0001\u0014kB$\u0017\r^3IS\u001eDw+\u0019;fe6\f'o\u001b\u000b\u0005\u0003w\tI\u0006C\u0004\u0002\\I\u0001\r!a\f\u0002\u001d=4gm]3u\u001b\u0016$\u0018\rZ1uC\u0006i\u0001.[4i/\u0006$XM]7be.\fQA\u001a7vg\"$\"!a\u000f\u0002#1\f7\u000f\u001e$mkNDW\rZ(gMN,G\u000fF\u0001P\u00039\u0019'/Z1uKNs\u0017\r]:i_R$B!a\u001b\u0002xA!\u0011QNA:\u001b\t\tyGC\u0002\u0002rU\n\u0001b\u001d8baNDw\u000e^\u0005\u0005\u0003k\nyGA\tSC^\u001cf.\u00199tQ>$xK]5uKJDa!!\u001f\u0018\u0001\u0004Y\u0015AC:oCB\u001c\bn\u001c;JI\u0006a!/Z1e':\f\u0007o\u001d5piR!\u0011qPAD!\u00111w-!!\u0011\t\u00055\u00141Q\u0005\u0005\u0003\u000b\u000byGA\tSC^\u001cf.\u00199tQ>$(+Z1eKJDa!!\u001f\u0019\u0001\u0004Y\u0015\u0001\u00057bi\u0016\u001cHo\u00158baNDw\u000e^%e)\u0005)\u0017\u0001E8o':\f\u0007o\u001d5pi\u001a\u0013xN_3o)\u0011\tY$!%\t\r\u0005e4\u00041\u0001L\u0003Q!W\r\\3uK\n+gm\u001c:f':\f\u0007o\u001d5piR!\u0011\u0011JAL\u0011\u0019\tI\n\ba\u0001\u0017\u0006\u0011Bn\\4Ti\u0006\u0014Ho\u00158baNDw\u000e^%e\u0003\u0015\u0019Gn\\:f\u0003AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\r\u0005\u0002`?M\u0019q$a)\u0011\u0007]\u000b)+C\u0002\u0002(b\u0013a!\u00118z%\u00164GCAAP\u0003\u0015\t\u0007\u000f\u001d7z)=q\u0016qVAY\u0003\u0003\fy-a8\u0002n\u0006E\b\"\u0002(\"\u0001\u0004y\u0005bBAZC\u0001\u0007\u0011QW\u0001\bI\u0006$\u0018\rR5s!\u0011\t9,!0\u000e\u0005\u0005e&bAA^]\u0005\u0011\u0011n\\\u0005\u0005\u0003\u007f\u000bIL\u0001\u0003GS2,\u0007bBAbC\u0001\u0007\u0011QY\u0001\b[\u0016$(/[2t!\u0011\t9-a3\u000e\u0005\u0005%'bAAb#&!\u0011QZAe\u0005\u001diU\r\u001e:jGNDq!!5\"\u0001\u0004\t\u0019.\u0001\u0003uS6,\u0007\u0003BAk\u00037l!!a6\u000b\u0007\u0005e\u0017+A\u0003vi&d7/\u0003\u0003\u0002^\u0006]'\u0001\u0002+j[\u0016Dq!!9\"\u0001\u0004\t\u0019/A\u0005tG\",G-\u001e7feB!\u0011Q]Au\u001b\t\t9OC\u0002\u0002Z\u001aJA!a;\u0002h\nI1k\u00195fIVdWM\u001d\u0005\u0007\u0003_\f\u0003\u0019\u0001,\u0002'5\f\u0007PQ1uG\"\u001c\u0016N_3J]\nKH/Z:\t\u000bU\u000b\u0003\u0019\u0001,\u0002!I,7m\u001c<feNs\u0017\r]:i_R\u001cHcA\"\u0002x\")AH\ta\u0001{\u0001")
public final class KafkaMetadataLog
implements ReplicatedLog {
    private final AbstractLog log;
    private final ConcurrentSkipListSet<OffsetAndEpoch> snapshotIds;
    private final TopicPartition topicPartition;
    private final int maxFetchSizeInBytes;
    private Optional<OffsetAndEpoch> oldestSnapshotId;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, File file, Metrics metrics, Time time, Scheduler scheduler, int n, int n2) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, file, metrics, time, scheduler, n, n2);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        Product product;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            product = FetchHighWatermark$.MODULE$;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            product = FetchLogEnd$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        AbstractFetchDataInfo abstractFetchDataInfo = this.log.read(startOffset, this.maxFetchSizeInBytes, (FetchIsolation)product, true, false);
        if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
            throw new IllegalStateException("Raft log should not have fetched tiered data");
        }
        FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
        return new LogFetchInfo(fetchDataInfo.records(), new org.apache.kafka.raft.LogOffsetMetadata(fetchDataInfo.fetchOffsetMetadata().messageOffset(), Optional.of(new SegmentPosition(fetchDataInfo.fetchOffsetMetadata().segmentBaseOffset(), fetchDataInfo.fetchOffsetMetadata().relativePositionInSegment()))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log.appendAsLeader((MemoryRecords)records, epoch, AppendOrigin$RaftLeader$.MODULE$, this.log.appendAsLeader$default$4(), this.log.appendAsLeader$default$5()));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log.appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        LogOffsetMetadata firstOffset;
        Option<LogOffsetMetadata> option = appendInfo.firstOffset();
        if (option instanceof Some) {
            firstOffset = (LogOffsetMetadata)((Some)option).value();
            if (firstOffset.relativePositionInSegment() == 0) {
                this.log.deleteOldSegments();
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new KafkaException(new StringBuilder(28).append("Append failed unexpectedly: ").append(appendInfo.errorMessage()).toString());
            }
            throw new MatchError(option);
        }
        org.apache.kafka.raft.LogAppendInfo logAppendInfo = new org.apache.kafka.raft.LogAppendInfo(firstOffset.messageOffset(), appendInfo.lastOffset());
        return logAppendInfo;
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log.latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option<kafka.server.OffsetAndEpoch> option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.oldestSnapshotId));
        Option<kafka.server.OffsetAndEpoch> option3 = this.log.endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option3, (Object)option2);
        Option<kafka.server.OffsetAndEpoch> option4 = option3;
        Option option5 = option2;
        if (option4 instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option4).value();
            if (option5 instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option5).value();
                if (offsetAndEpoch.offset() == snapshotId.offset && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset, snapshotId.epoch);
                }
            }
        }
        if ((option = option3) instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option<kafka.server.OffsetAndEpoch> option6 = option3;
        if (!None$.MODULE$.equals(option6)) throw new MatchError((Object)tuple2);
        return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
    }

    public org.apache.kafka.raft.LogOffsetMetadata endOffset() {
        LogOffsetMetadata endOffsetMetadata = this.log.logEndOffsetMetadata();
        return new org.apache.kafka.raft.LogOffsetMetadata(endOffsetMetadata.messageOffset(), Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset(), endOffsetMetadata.relativePositionInSegment())));
    }

    public long startOffset() {
        return this.log.localLogStartOffset();
    }

    public void truncateTo(long offset) {
        this.log.truncateTo(offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean truncateToLatestSnapshot() {
        int latestEpoch = BoxesRunTime.unboxToInt((Object)this.log.latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (!(option instanceof Some)) return false;
        OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
        if (snapshotId.epoch <= latestEpoch) {
            if (snapshotId.epoch != latestEpoch) return false;
            if (snapshotId.offset <= this.endOffset().offset) return false;
        }
        this.log.truncateFullyAndStartAt(snapshotId.offset);
        this.oldestSnapshotId = this.latestSnapshotId();
        return true;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log.maybeAssignEpochStartOffset(epoch, this.log.logEndOffset());
    }

    public void updateHighWatermark(org.apache.kafka.raft.LogOffsetMetadata offsetMetadata) {
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            this.log.updateHighWatermark(new LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
            return;
        }
        this.log.updateHighWatermark(offsetMetadata.offset);
    }

    /*
     * WARNING - void declaration
     */
    public org.apache.kafka.raft.LogOffsetMetadata highWatermark() {
        void var2_2;
        LogOffsetSnapshot logOffsetSnapshot = this.log.fetchOffsetSnapshot();
        if (logOffsetSnapshot == null) {
            throw new MatchError(null);
        }
        LogOffsetMetadata hwm = logOffsetSnapshot.highWatermark();
        Optional segmentPosition = var2_2.messageOffsetOnly() ? Optional.of(new SegmentPosition(var2_2.segmentBaseOffset(), var2_2.relativePositionInSegment())) : Optional.empty();
        return new org.apache.kafka.raft.LogOffsetMetadata(var2_2.messageOffset(), segmentPosition);
    }

    public void flush() {
        this.log.flush();
    }

    public long lastFlushedOffset() {
        return this.log.recoveryPoint();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public RawSnapshotWriter createSnapshot(OffsetAndEpoch snapshotId) {
        this.latestSnapshotId().ifPresent(latest -> {
            if (latest.epoch > snapshotId$1.epoch || latest.offset > snapshotId$1.offset) {
                throw new IllegalArgumentException(new StringBuilder(81).append("Attemting to create a snapshot (").append(snapshotId).append(") that is not greater than the latest snapshot (").append(latest).append(")").toString());
            }
        });
        return FileRawSnapshotWriter.create((Path)this.log.dir().toPath(), (OffsetAndEpoch)snapshotId, Optional.of(this));
    }

    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        Optional<RawSnapshotReader> optional;
        try {
            if (!this.snapshotIds.contains(snapshotId)) {
                return Optional.empty();
            }
            optional = Optional.of(FileRawSnapshotReader.open((Path)this.log.dir().toPath(), (OffsetAndEpoch)snapshotId));
        }
        catch (NoSuchFileException noSuchFileException) {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        try {
            return Optional.of(this.snapshotIds.last());
        }
        catch (NoSuchElementException noSuchElementException) {
            return Optional.empty();
        }
    }

    public Optional<OffsetAndEpoch> oldestSnapshotId() {
        return this.oldestSnapshotId;
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        this.snapshotIds.add(snapshotId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteBeforeSnapshot(OffsetAndEpoch logStartSnapshotId) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (!(option instanceof Some)) return false;
        OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
        if (!this.snapshotIds.contains(logStartSnapshotId)) return false;
        if (this.startOffset() >= logStartSnapshotId.offset) return false;
        if (logStartSnapshotId.offset > snapshotId.offset) return false;
        if (!this.log.maybeIncrementLogStartOffset(logStartSnapshotId.offset, SnapshotGenerated$.MODULE$)) return false;
        this.log.deleteOldSegments();
        this.oldestSnapshotId = Optional.of(logStartSnapshotId);
        return true;
    }

    public void close() {
        this.log.close();
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset == $this.startOffset() && snapshotId.offset == logEndOffset) {
            return snapshotId.epoch;
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public KafkaMetadataLog(AbstractLog log, ConcurrentSkipListSet<OffsetAndEpoch> snapshotIds, TopicPartition topicPartition, int maxFetchSizeInBytes) {
        this.log = log;
        this.snapshotIds = snapshotIds;
        this.topicPartition = topicPartition;
        this.maxFetchSizeInBytes = maxFetchSizeInBytes;
        this.oldestSnapshotId = snapshotIds.stream().filter(x$1 -> x$1.offset == this.startOffset()).findAny();
    }
}

