/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r]d!B'O\u0001A\u0013\u0006\u0002C/\u0001\u0005\u000b\u0007I\u0011A0\t\u0011\u0019\u0004!\u0011!Q\u0001\n\u0001D\u0001b\u001a\u0001\u0003\u0006\u0004%\t\u0001\u001b\u0005\t_\u0002\u0011\t\u0011)A\u0005S\"A\u0001\u000f\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003j\u0011!\u0011\bA!A!\u0002\u0013I\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011i\u0003!\u0011!Q\u0001\n]D!\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011)\ty\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0005\u0005\u000b\u0003[\u0001!\u0011!Q\u0001\n\u0005%\u0001bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"a\u0018\u0001A\u0003%\u00111\n\u0005\n\u0003C\u0002!\u0019!C\u0001\u0003GB\u0001\"a\u001b\u0001A\u0003%\u0011Q\r\u0005\n\u0003[\u0002!\u0019!C\u0005\u0003_B\u0001\"a\"\u0001A\u0003%\u0011\u0011\u000f\u0005\n\u0003\u0013\u0003!\u0019!C\u0005\u0003\u0017C\u0001\"!)\u0001A\u0003%\u0011Q\u0012\u0005\n\u0003G\u0003!\u0019!C\u0005\u0003KC\u0001\"!0\u0001A\u0003%\u0011q\u0015\u0005\n\u0003\u007f\u0003!\u0019!C\u0005\u0003KC\u0001\"!1\u0001A\u0003%\u0011q\u0015\u0005\n\u0003\u0007\u0004!\u0019!C\u0005\u0003\u000bD\u0001\"!4\u0001A\u0003%\u0011q\u0019\u0005\t\u0003\u001f\u0004\u0001\u0019!C\u0005Q\"I\u0011\u0011\u001b\u0001A\u0002\u0013%\u00111\u001b\u0005\b\u0003?\u0004\u0001\u0015)\u0003j\u0011)\t\t\u000f\u0001b\u0001\n\u0003q\u00151\u001d\u0005\t\u0005K\u0003\u0001\u0015!\u0003\u0002f\u001a9\u0011q\u001e\u0001A\u001d\u0006E\bB\u0003B\fC\tU\r\u0011\"\u0001\u0003\u001a!Q!\u0011E\u0011\u0003\u0012\u0003\u0006IAa\u0007\t\u0015\t\r\u0012E!f\u0001\n\u0003\u0011)\u0003\u0003\u0006\u0003.\u0005\u0012\t\u0012)A\u0005\u0005OAq!a\f\"\t\u0003\u0011y\u0003C\u0004\u00036\u0005\"\tEa\u000e\t\u0013\tu\u0012%!A\u0005\u0002\t}\u0002\"\u0003B#CE\u0005I\u0011\u0001B$\u0011%\u0011i&II\u0001\n\u0003\u0011y\u0006C\u0005\u0003d\u0005\n\t\u0011\"\u0011\u0003f!A!\u0011O\u0011\u0002\u0002\u0013\u0005\u0001\u000eC\u0005\u0003t\u0005\n\t\u0011\"\u0001\u0003v!I!qP\u0011\u0002\u0002\u0013\u0005#\u0011\u0011\u0005\n\u0005\u0017\u000b\u0013\u0011!C\u0001\u0005\u001bC\u0011Ba&\"\u0003\u0003%\tE!'\t\u0013\tm\u0015%!A\u0005B\tu\u0005\"\u0003BPC\u0005\u0005I\u0011\tBQ\u000f)\u00119\u000bAA\u0001\u0012\u0003q%\u0011\u0016\u0004\u000b\u0003_\u0004\u0011\u0011!E\u0001\u001d\n-\u0006bBA\u0018i\u0011\u0005!\u0011\u0018\u0005\n\u00057#\u0014\u0011!C#\u0005;C\u0011Ba/5\u0003\u0003%\tI!0\t\u0013\t\rG'!A\u0005\u0002\n\u0015\u0007\u0002\u0003Bl\u0001\u0011\u0005aJ!7\t\u0011\t%\b\u0001\"\u0001O\u0005WDqA!;\u0001\t\u0013\u0011y\u000f\u0003\u0005\u0003|\u0002!\tA\u0014B\u007f\u0011\u001d\u0019i\u0001\u0001C!\u0007\u001fAqa!\u0005\u0001\t\u0003\u001ay\u0001C\u0004\u0004\u0014\u0001!\taa\u0004\t\u000f\rU\u0001\u0001\"\u0003\u0004\u0018!A1\u0011\u0004\u0001\u0005\u00029\u001bY\u0002C\u0004\u0004,\u0001!Ia!\f\t\u000f\r]\u0002\u0001\"\u0003\u0004\u0010!91\u0011\b\u0001\u0005\n\rm\u0002bBB%\u0001\u0011%1q\u0002\u0005\b\u0007\u0017\u0002A\u0011BB'\u0011\u001d\u0019Y\u0006\u0001C\u0005\u0007;Bqaa\u0018\u0001\t\u0003\u0019ya\u0002\u0006\u0004j9\u000b\t\u0011#\u0001Q\u0007W2\u0011\"\u0014(\u0002\u0002#\u0005\u0001k!\u001c\t\u000f\u0005=\"\n\"\u0001\u0004p!I1\u0011\u000f&\u0012\u0002\u0013\u000511\u000f\u0002\t\u0003\u000e\u001cW\r\u001d;pe*\u0011q\nU\u0001\b]\u0016$xo\u001c:l\u0015\u0005\t\u0016!B6bM.\f7c\u0001\u0001T/B\u0011A+V\u0007\u0002\u001d&\u0011aK\u0014\u0002\u0015\u0003\n\u001cHO]1diN+'O^3s)\"\u0014X-\u00193\u0011\u0005a[V\"A-\u000b\u0005i\u0003\u0016aB7fiJL7m]\u0005\u00039f\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003!)g\u000e\u001a)pS:$8\u0001A\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111\rU\u0001\bG2,8\u000f^3s\u0013\t)'M\u0001\u0005F]\u0012\u0004v.\u001b8u\u0003%)g\u000e\u001a)pS:$\b%\u0001\btK:$')\u001e4gKJ\u001c\u0016N_3\u0016\u0003%\u0004\"A[7\u000e\u0003-T\u0011\u0001\\\u0001\u0006g\u000e\fG.Y\u0005\u0003].\u00141!\u00138u\u0003=\u0019XM\u001c3Ck\u001a4WM]*ju\u0016\u0004\u0013A\u0004:fGZ\u0014UO\u001a4feNK'0Z\u0001\u0010e\u0016\u001cgOQ;gM\u0016\u00148+\u001b>fA\u00051an\u001c3f\u0013\u0012\f\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0011\u0005Q+\u0018B\u0001<O\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7\u000fE\u0002y\u0003\u0007i\u0011!\u001f\u0006\u00035jT!a\u001f?\u0002\r\r|W.\\8o\u0015\t\tVP\u0003\u0002\u007f\u007f\u00061\u0011\r]1dQ\u0016T!!!\u0001\u0002\u0007=\u0014x-C\u0002\u0002\u0006e\u0014q!T3ue&\u001c7/\u0001\u0007nKR\u0014\u0018n\u0019)sK\u001aL\u0007\u0010\u0005\u0003\u0002\f\u0005ea\u0002BA\u0007\u0003+\u00012!a\u0004l\u001b\t\t\tBC\u0002\u0002\u0014y\u000ba\u0001\u0010:p_Rt\u0014bAA\fW\u00061\u0001K]3eK\u001aLA!a\u0007\u0002\u001e\t11\u000b\u001e:j]\u001eT1!a\u0006l\u0003\u0011!\u0018.\\3\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n{\u0003\u0015)H/\u001b7t\u0013\u0011\tY#!\n\u0003\tQKW.Z\u0001\nY><\u0007K]3gSb\fa\u0001P5oSRtD\u0003FA\u001a\u0003k\t9$!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\n)\u0005\u0005\u0002U\u0001!)Q,\u0004a\u0001A\")q-\u0004a\u0001S\")\u0001/\u0004a\u0001S\")!/\u0004a\u0001S\")1/\u0004a\u0001i\")!,\u0004a\u0001o\"9\u0011qA\u0007A\u0002\u0005%\u0001bBA\u0010\u001b\u0001\u0007\u0011\u0011\u0005\u0005\n\u0003[i\u0001\u0013!a\u0001\u0003\u0013\t1B\\5p'\u0016dWm\u0019;peV\u0011\u00111\n\t\u0005\u0003\u001b\nY&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BA+\u0003/\n1A\\5p\u0015\t\tI&\u0001\u0003kCZ\f\u0017\u0002BA/\u0003\u001f\u0012\u0001bU3mK\u000e$xN]\u0001\r]&|7+\u001a7fGR|'\u000fI\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0005\u0005\u0015\u0004\u0003BA'\u0003OJA!!\u001b\u0002P\t\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006q1/\u001a:wKJ\u001c\u0005.\u00198oK2\u0004\u0013A\u00039s_\u000e,7o]8sgV\u0011\u0011\u0011\u000f\t\u0007\u0003g\ni(!!\u000e\u0005\u0005U$\u0002BA<\u0003s\nq!\\;uC\ndWMC\u0002\u0002|-\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty(!\u001e\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004)\u0006\r\u0015bAAC\u001d\nI\u0001K]8dKN\u001cxN]\u0001\faJ|7-Z:t_J\u001c\b%A\tqe>\u001cWm]:peN\u001cF/\u0019:uK\u0012,\"!!$\u0011\t\u0005=\u0015QT\u0007\u0003\u0003#SA!a%\u0002\u0016\u00061\u0011\r^8nS\u000eTA!a&\u0002\u001a\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005m\u0015qK\u0001\u0005kRLG.\u0003\u0003\u0002 \u0006E%!D!u_6L7MQ8pY\u0016\fg.\u0001\nqe>\u001cWm]:peN\u001cF/\u0019:uK\u0012\u0004\u0013a\u00052m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014XCAAT!\u0011\tI+!/\u000e\u0005\u0005-&\u0002BAW\u0003_\u000bAaY8sK*\u0019!,!-\u000b\t\u0005M\u0016QW\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005]\u0016aA2p[&!\u00111XAV\u0005\u0015iU\r^3s\u0003Q\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3sA\u0005!\u0012mY2faR\u0014\u0015\r^2i)&lW-T3uKJ\fQ#Y2dKB$()\u0019;dQRKW.Z'fi\u0016\u0014\b%\u0001\u000foKR<xN]6UQJ,\u0017\rZ:DCB\f7-\u001b;z'\u0016t7o\u001c:\u0016\u0005\u0005\u001d\u0007c\u0001=\u0002J&\u0019\u00111Z=\u0003\rM+gn]8s\u0003uqW\r^<pe.$\u0006N]3bIN\u001c\u0015\r]1dSRL8+\u001a8t_J\u0004\u0013!F2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r_\u0001\u001aGV\u0014(/\u001a8u!J|7-Z:t_JLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0003\u0002V\u0006m\u0007c\u00016\u0002X&\u0019\u0011\u0011\\6\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003;l\u0012\u0011!a\u0001S\u0006\u0019\u0001\u0010J\u0019\u0002-\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fq\u0002\n\u0001\u0003\u001e5s_R$H.\u001a3T_\u000e\\W\r^:\u0016\u0005\u0005\u0015\bCBA:\u0003O\fY/\u0003\u0003\u0002j\u0006U$!\u0004)sS>\u0014\u0018\u000e^=Rk\u0016,X\rE\u0002\u0002n\u0006j\u0011\u0001\u0001\u0002\u0013\t\u0016d\u0017-_3e\u00072|7/Z*pG.,GoE\u0005\"\u0003g\fIPa\u0003\u0003\u0012A\u0019!.!>\n\u0007\u0005]8N\u0001\u0004B]f\u0014VM\u001a\t\u0007\u0003w\u0014)!a;\u000f\t\u0005u(\u0011\u0001\b\u0005\u0003\u001f\ty0C\u0001m\u0013\r\u0011\u0019a[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119A!\u0003\u0003\u000f=\u0013H-\u001a:fI*\u0019!1A6\u0011\u0007)\u0014i!C\u0002\u0003\u0010-\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002k\u0005'I1A!\u0006l\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0019xnY6fiV\u0011!1\u0004\t\u0005\u0003\u001b\u0012i\"\u0003\u0003\u0003 \u0005=#!D*pG.,Go\u00115b]:,G.A\u0004t_\u000e\\W\r\u001e\u0011\u0002#\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5/\u0006\u0002\u0003(A\u0019!N!\u000b\n\u0007\t-2N\u0001\u0003M_:<\u0017AE3oIRC'o\u001c;uY\u0016$\u0016.\\3Ng\u0002\"b!a;\u00032\tM\u0002b\u0002B\fM\u0001\u0007!1\u0004\u0005\b\u0005G1\u0003\u0019\u0001B\u0014\u0003\u001d\u0019w.\u001c9be\u0016$2!\u001bB\u001d\u0011\u001d\u0011Yd\na\u0001\u0003W\fA\u0001\u001e5bi\u0006!1m\u001c9z)\u0019\tYO!\u0011\u0003D!I!q\u0003\u0015\u0011\u0002\u0003\u0007!1\u0004\u0005\n\u0005GA\u0003\u0013!a\u0001\u0005O\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003J)\"!1\u0004B&W\t\u0011i\u0005\u0005\u0003\u0003P\teSB\u0001B)\u0015\u0011\u0011\u0019F!\u0016\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B,W\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm#\u0011\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005CRCAa\n\u0003L\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\u001a\u0011\t\t%$qN\u0007\u0003\u0005WRAA!\u001c\u0002X\u0005!A.\u00198h\u0013\u0011\tYBa\u001b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u000fB?!\rQ'\u0011P\u0005\u0004\u0005wZ'aA!os\"A\u0011Q\\\u0017\u0002\u0002\u0003\u0007\u0011.A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\t\u0005\u0004\u0003\u0006\n\u001d%qO\u0007\u0003\u0003sJAA!#\u0002z\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011yI!&\u0011\u0007)\u0014\t*C\u0002\u0003\u0014.\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002^>\n\t\u00111\u0001\u0003x\u0005A\u0001.Y:i\u0007>$W\rF\u0001j\u0003!!xn\u0015;sS:<GC\u0001B4\u0003\u0019)\u0017/^1mgR!!q\u0012BR\u0011%\tiNMA\u0001\u0002\u0004\u00119(A\tuQJ|G\u000f\u001e7fIN{7m[3ug\u0002\n!\u0003R3mCf,Gm\u00117pg\u0016\u001cvnY6fiB\u0019\u0011Q\u001e\u001b\u0014\u000bQ\u0012iK!\u0005\u0011\u0015\t=&Q\u0017B\u000e\u0005O\tY/\u0004\u0002\u00032*\u0019!1W6\u0002\u000fI,h\u000e^5nK&!!q\u0017BY\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005S\u000bQ!\u00199qYf$b!a;\u0003@\n\u0005\u0007b\u0002B\fo\u0001\u0007!1\u0004\u0005\b\u0005G9\u0004\u0019\u0001B\u0014\u0003\u001d)h.\u00199qYf$BAa2\u0003TB)!N!3\u0003N&\u0019!1Z6\u0003\r=\u0003H/[8o!\u001dQ'q\u001aB\u000e\u0005OI1A!5l\u0005\u0019!V\u000f\u001d7fe!I!Q\u001b\u001d\u0002\u0002\u0003\u0007\u00111^\u0001\u0004q\u0012\u0002\u0014!D1eIB\u0013xnY3tg>\u00148\u000f\u0006\u0004\u0002V\nm'Q\u001d\u0005\b\u0005;L\u0004\u0019\u0001Bp\u00035qWm\u001e)s_\u000e,7o]8sgB1\u00111\u000fBq\u0003\u0003KAAa9\u0002v\t1!)\u001e4gKJDqAa::\u0001\u0004\tI!A\u000bqe>\u001cWm]:peRC'/Z1e!J,g-\u001b=\u0002\u001fM$\u0018M\u001d;Qe>\u001cWm]:peN$B!!6\u0003n\"9!q\u001d\u001eA\u0002\u0005%ACBAk\u0005c\u0014I\u0010C\u0004\u0002nm\u0002\rAa=\u0011\r\t\u0015%Q_AA\u0013\u0011\u001190!\u001f\u0003\u0007M+\u0017\u000fC\u0004\u0003hn\u0002\r!!\u0003\u0002!I,Wn\u001c<f!J|7-Z:t_J\u001cHCBAk\u0005\u007f\u001c\u0019\u0001\u0003\u0004\u0004\u0002q\u0002\r![\u0001\fe\u0016lwN^3D_VtG\u000fC\u0004\u0004\u0006q\u0002\raa\u0002\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u0019Ak!\u0003\n\u0007\r-aJ\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAAk\u00035\tw/Y5u'\",H\u000fZ8x]\u0006\u0019!/\u001e8\u0002\u001b9,\u0007\u0010\u001e)s_\u000e,7o]8s+\t\t\t)A\u0007sKZ,'o]3B]\u0012\fE\r\u001a\u000b\u0005\u0003+\u001ci\u0002C\u0004\u0004 \u0005\u0003\ra!\t\u0002\u001dI,g/\u001a:tK\u000eC\u0017M\u001c8fYB!11EB\u0014\u001b\t\u0019)C\u0003\u0002Pu&!1\u0011FB\u0013\u00059\u0011VM^3sg\u0016\u001c\u0005.\u00198oK2\f\u0001c\u001c9f]N+'O^3s'>\u001c7.\u001a;\u0015\r\u0005\u00154qFB\u001a\u0011\u001d\u0019\tD\u0011a\u0001\u0003\u0013\tA\u0001[8ti\"11Q\u0007\"A\u0002%\fA\u0001]8si\u0006!\u0012mY2faRtUm^\"p]:,7\r^5p]N\fa!Y2dKB$H\u0003BB\u001f\u0007\u007f\u0001RA\u001bBe\u00057Aqa!\u0011E\u0001\u0004\u0019\u0019%A\u0002lKf\u0004B!!\u0014\u0004F%!1qIA(\u00051\u0019V\r\\3di&|gnS3z\u0003e\u0019Gn\\:f)\"\u0014x\u000e\u001e;mK\u0012\u001cuN\u001c8fGRLwN\\:\u0002'\u0005\u001c8/[4o\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0011\t=5qJB*\u0007/Bqa!\u0015G\u0001\u0004\u0011Y\"A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b\u0007+2\u0005\u0019AAA\u0003%\u0001(o\\2fgN|'\u000fC\u0004\u0004Z\u0019\u0003\rAa$\u0002\u00115\f\u0017P\u00117pG.\f!e\u0019:fCR,g*\u001a;x_J\\G\u000b\u001b:fC\u0012\u001c8)\u00199bG&$\u0018pU3og>\u0014HCAAd\u0003\u00199\u0018m[3va\"\u001a\u0001ja\u0019\u0011\t\t%4QM\u0005\u0005\u0007O\u0012YG\u0001\u0005Pm\u0016\u0014(/\u001b3f\u0003!\t5mY3qi>\u0014\bC\u0001+K'\rQ\u00151\u001f\u000b\u0003\u0007W\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012JTCAB;U\u0011\tIAa\u0013")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Metrics metrics;
    private final String metricPrefix;
    private final Time time;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;
    private final Meter acceptBatchTimeMeter;
    private final Sensor networkThreadsCapacitySensor;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;

    public static String $lessinit$greater$default$9() {
        return Acceptor$.MODULE$.$lessinit$greater$default$9();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private Meter acceptBatchTimeMeter() {
        return this.acceptBatchTimeMeter;
    }

    private Sensor networkThreadsCapacitySensor() {
        return this.networkThreadsCapacitySensor;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            x$16.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                x$17.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
                x$18.awaitShutdown();
                return BoxedUnit.UNIT;
            });
        }
        this.removeMetric(new StringBuilder(22).append(this.metricPrefix).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.endPoint().listenerName().value())}))));
        this.removeMetric(new StringBuilder(20).append(this.metricPrefix).append("AcceptBatchTimeNanos").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.endPoint().listenerName().value())}))));
        this.metrics.removeSensor(this.networkThreadsCapacitySensor().name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable & scala.Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Processor nextProcessor() {
        void var1_1;
        this.currentProcessorIndex_$eq(this.currentProcessorIndex() % this.processors().length());
        Processor processor = (Processor)this.processors().apply(this.currentProcessorIndex());
        this.currentProcessorIndex_$eq(this.currentProcessorIndex() + 1);
        return var1_1;
    }

    public void reverseAndAdd(ReverseChannel reverseChannel) {
        this.connectionQuotas.inc(this.endPoint().listenerName(), reverseChannel.channel().socketAddress(), this.blockedPercentMeter());
        this.nextProcessor().reverseAndAdd(reverseChannel);
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            long startNanos = this.time.nanoseconds();
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable & scala.Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            this.acceptBatchTimeMeter().mark(this.time.nanoseconds() - startNanos);
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$19)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor createNetworkThreadsCapacitySensor() {
        void var2_2;
        String listenerName = this.endPoint().listenerName().value();
        Sensor networkThreadsCapacitySensor = this.metrics.sensor(new StringBuilder(30).append("TotalNetworkThreadsPercentage-").append(listenerName).toString());
        networkThreadsCapacitySensor.add(ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics, listenerName), (MeasurableStat)new Value());
        return var2_2;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        while (!$this.assignNewConnection(socketChannel, processor = $this.nextProcessor(), --retriesLeft == 0)) {
        }
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$19) {
        return x$19.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int nodeId, ConnectionQuotas connectionQuotas, Metrics metrics, String metricPrefix, Time time, String logPrefix) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.metrics = metrics;
        this.metricPrefix = metricPrefix;
        this.time = time;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.acceptBatchTimeMeter = this.newMeter(new StringBuilder(20).append(metricPrefix).append("AcceptBatchTimeNanos").toString(), "processing and blocked time for a batch of new connections", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.networkThreadsCapacitySensor = this.createNetworkThreadsCapacitySensor();
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    scala.Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof DelayedCloseSocket)) return false;
            if (((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() != this.kafka$network$Acceptor$DelayedCloseSocket$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
            SocketChannel socketChannel = this.socket();
            SocketChannel socketChannel2 = delayedCloseSocket.socket();
            if (socketChannel == null) {
                if (socketChannel2 != null) {
                    return false;
                }
            } else if (!socketChannel.equals(socketChannel2)) return false;
            if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) return false;
            if (!delayedCloseSocket.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

