/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\f\u0019\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\ta\u0001\u0011)\u0019!C\u0001c!Aq\b\u0001B\u0001B\u0003%!\u0007\u0003\u0005A\u0001\t\u0015\r\u0011\"\u0001B\u0011!A\u0005A!A!\u0002\u0013\u0011\u0005\"B%\u0001\t\u0003Q\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u00079\u0002\u0001\u000b\u0011\u0002*\t\u000fu\u0003!\u0019!C\u0005=\"1!\r\u0001Q\u0001\n}Cqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0003_\u0011\u0019Q\u0007\u0001)A\u0005?\"9\u0011\u0004\u0001b\u0001\n\u0003Y\u0007B\u0002:\u0001A\u0003%A\u000eC\u0004t\u0001\t\u0007I\u0011\u0002;\t\ru\u0004\u0001\u0015!\u0003v\u0011\u001dq\bA1A\u0005\n}D\u0001\"a\u0007\u0001A\u0003%\u0011\u0011\u0001\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\u0011\u0011\u0004T5okb$\u0015n]6NKR\u0014\u0018nY:D_2dWm\u0019;pe*\u0011\u0011DG\u0001\b[\u0016$(/[2t\u0015\u0005Y\u0012!B6bM.\f7\u0001A\n\u0003\u0001y\u0001\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0017\u0001\u00039s_\u000e\u0014vn\u001c;\u0011\u0005\u0019jcBA\u0014,!\tA\u0003%D\u0001*\u0015\tQC$\u0001\u0004=e>|GOP\u0005\u0003Y\u0001\na\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011A\u0006I\u0001\u0005i&lW-F\u00013!\t\u0019T(D\u00015\u0015\t)d'A\u0003vi&d7O\u0003\u00028q\u000511m\\7n_:T!aG\u001d\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0005\u0003}Q\u0012A\u0001V5nK\u0006)A/[7fA\u00051An\\4hKJ,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bn\nQa\u001d7gi)L!a\u0012#\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\na\u0001P5oSRtD\u0003B&N\u001d>\u0003\"\u0001\u0014\u0001\u000e\u0003aAQ\u0001\n\u0004A\u0002\u0015BQ\u0001\r\u0004A\u0002IBQ\u0001\u0011\u0004A\u0002\t\u000b\u0001b\u001d;biB\u000bG\u000f[\u000b\u0002%B\u00111KW\u0007\u0002)*\u0011QKV\u0001\u0005M&dWM\u0003\u0002X1\u0006\u0019a.[8\u000b\u0003e\u000bAA[1wC&\u00111\f\u0016\u0002\u0005!\u0006$\b.A\u0005ti\u0006$\b+\u0019;iA\u0005!B)\u0012,J\u0007\u0016{f*Q'F?\u001aKU\t\u0014#`\u0013\u0012+\u0012a\u0018\t\u0003?\u0001L!!\u0019\u0011\u0003\u0007%sG/A\u000bE\u000bZK5)R0O\u00036+uLR%F\u0019\u0012{\u0016\n\u0012\u0011\u0002\u000f\u0011,g/[2fgV\tQ\rE\u0002 M\u0016J!a\u001a\u0011\u0003\u000b\u0005\u0013(/Y=\u0002\u0011\u0011,g/[2fg\u0002\n!\"\\1y\r&,G\u000eZ%e\u0003-i\u0017\r\u001f$jK2$\u0017\n\u001a\u0011\u0016\u00031\u00042a\b4n!\tq\u0017/D\u0001p\u0015\t\u0001\b,\u0001\u0003mC:<\u0017B\u0001\u0018p\u0003!iW\r\u001e:jGN\u0004\u0013A\u00053je\u0016\u001cGOU3ukJtg)[3mIN,\u0012!\u001e\t\u0004mn|V\"A<\u000b\u0005aL\u0018!C5n[V$\u0018M\u00197f\u0015\tQ\b%\u0001\u0006d_2dWm\u0019;j_:L!\u0001`<\u0003\u0007M+G/A\neSJ,7\r\u001e*fiV\u0014hNR5fY\u0012\u001c\b%A\u0005qe\u001648\u000b^1uKV\u0011\u0011\u0011\u0001\t\b\u0003\u0007\tI!JA\u0007\u001b\t\t)AC\u0002\u0002\be\fq!\\;uC\ndW-\u0003\u0003\u0002\f\u0005\u0015!aA'baB!qDZA\b!\u001dy\u0012\u0011CA\u000b\u0003+I1!a\u0005!\u0005\u0019!V\u000f\u001d7feA\u0019q$a\u0006\n\u0007\u0005e\u0001E\u0001\u0003M_:<\u0017A\u00039sKZ\u001cF/\u0019;fA\u0005QQ.\u001a;sS\u000e\u0014\u0016\r^3\u0015\r\u0005\u0005\u0012qEA\u0016!\ry\u00121E\u0005\u0004\u0003K\u0001#A\u0002#pk\ndW\r\u0003\u0004\u0002*U\u0001\r!J\u0001\u0007I\u00164\u0018nY3\t\r\u00055R\u00031\u0001`\u0003\u0015Ig\u000eZ3y\u0003\u0019)8/\u00192mKR\u0011\u00111\u0007\t\u0004?\u0005U\u0012bAA\u001cA\t9!i\\8mK\u0006t\u0007")
public class LinuxDiskMetricsCollector {
    private final Time time;
    private final Logger logger;
    private final Path statPath;
    private final int DEVICE_NAME_FIELD_ID;
    private final String[] devices;
    private final int maxFieldId;
    private final String[] metrics;
    private final Set<Object> directReturnFields;
    private final Map<String, Tuple2<Object, Object>[]> prevState;

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    private Path statPath() {
        return this.statPath;
    }

    private int DEVICE_NAME_FIELD_ID() {
        return this.DEVICE_NAME_FIELD_ID;
    }

    public String[] devices() {
        return this.devices;
    }

    private int maxFieldId() {
        return this.maxFieldId;
    }

    public String[] metrics() {
        return this.metrics;
    }

    private Set<Object> directReturnFields() {
        return this.directReturnFields;
    }

    private Map<String, Tuple2<Object, Object>[]> prevState() {
        return this.prevState;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized double metricRate(String device, int index) {
        if (!this.prevState().contains((Object)device) || index >= this.metrics().length || index < 0) {
            return -1.0;
        }
        try {
            void var11_8;
            void var9_7;
            Buffer validLines = (Buffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).map((Function1 & Serializable & scala.Serializable)line -> line.trim().split("\\s+"), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)fields -> BoxesRunTime.boxToBoolean((boolean)LinuxDiskMetricsCollector.$anonfun$metricRate$2(this, index, device, fields)));
            if (validLines.isEmpty()) {
                return -1.0;
            }
            long now = this.time().milliseconds();
            long value = new StringOps(Predef$.MODULE$.augmentString(((String[])validLines.head())[index + this.DEVICE_NAME_FIELD_ID() + 1])).toLong();
            if (this.directReturnFields().contains((Object)BoxesRunTime.boxToInteger((int)index))) {
                return value;
            }
            Tuple2 tuple2 = ((Tuple2[])this.prevState().apply((Object)device))[index];
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long prevTime = tuple2._1$mcJ$sp();
            long prevValue = tuple2._2$mcJ$sp();
            if (var9_7 == 0L) {
                ((Tuple2[])this.prevState().apply((Object)device))[index] = new Tuple2.mcJJ.sp(now, value);
                return 0.0;
            }
            long windowTime = now - var9_7;
            if (windowTime <= 0L) {
                return -1.0;
            }
            long windowValue = value - var11_8;
            ((Tuple2[])this.prevState().apply((Object)device))[index] = new Tuple2.mcJJ.sp(now, value);
            return (double)windowValue / ((double)windowTime / (double)1000);
        }
        catch (Throwable t) {
            this.logger().warn("Unable to retrieve disk metrics", t);
            return -1.0;
        }
    }

    public boolean usable() {
        return this.statPath().toFile().exists() && ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$devices$2(LinuxDiskMetricsCollector $this, String[] fields) {
        return fields.length > $this.DEVICE_NAME_FIELD_ID();
    }

    public static final /* synthetic */ void $anonfun$new$1(LinuxDiskMetricsCollector $this, String device) {
        $this.prevState().update((Object)device, Array$.MODULE$.fill($this.metrics().length, (Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L), ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public static final /* synthetic */ boolean $anonfun$metricRate$2(LinuxDiskMetricsCollector $this, int index$1, String device$1, String[] fields) {
        return fields.length > index$1 + $this.DEVICE_NAME_FIELD_ID() + 1 && fields[$this.DEVICE_NAME_FIELD_ID()].equals(device$1);
    }

    public LinuxDiskMetricsCollector(String procRoot, Time time, Logger logger) {
        this.time = time;
        this.logger = logger;
        this.statPath = Paths.get(procRoot, "diskstats");
        this.DEVICE_NAME_FIELD_ID = 2;
        this.devices = this.usable() ? (String[])((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).map((Function1 & Serializable & scala.Serializable)line -> line.trim().split("\\s+"), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)fields -> BoxesRunTime.boxToBoolean((boolean)LinuxDiskMetricsCollector.$anonfun$devices$2(this, fields)))).map((Function1 & Serializable & scala.Serializable)fields -> fields[this.DEVICE_NAME_FIELD_ID()], Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)) : new String[]{};
        this.maxFieldId = this.usable() ? ((String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).head()).trim().split("\\s+").length - this.DEVICE_NAME_FIELD_ID() - 1 : 0;
        this.metrics = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"reads-completed", "reads-merged", "sectors-read", "time-spent-reading-ms", "writes-completed", "writes-merged", "sectors-written", "time-spent-writing-ms", "IOs-currently-in-progress", "time-spent-doing-IOs-ms", "weighted-time-spent-doing-IOs-ms", "discards-completed", "discards-merged", "sectors-discarded", "time-spent-discarding-ms", "flush-requests-completed", "time-spent-flushing-ms"})).slice(0, this.maxFieldId());
        this.directReturnFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8}));
        this.prevState = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.devices())).foreach((Function1 & Serializable & scala.Serializable)device -> {
            LinuxDiskMetricsCollector.$anonfun$new$1(this, device);
            return BoxedUnit.UNIT;
        });
    }
}

