/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rw!B2e\u0011\u0003Ig!B6e\u0011\u0003a\u0007\"B:\u0002\t\u0003!\bbB;\u0002\u0005\u0004%IA\u001e\u0005\u0007u\u0006\u0001\u000b\u0011B<\t\u000fm\f!\u0019!C\u0005y\"9\u00111B\u0001!\u0002\u0013i\b\u0002CA\u0007\u0003\t\u0007I\u0011\u0002?\t\u000f\u0005=\u0011\u0001)A\u0005{\"A\u0011\u0011C\u0001C\u0002\u0013%A\u0010C\u0004\u0002\u0014\u0005\u0001\u000b\u0011B?\t\u0011\u0005U\u0011A1A\u0005\nqDq!a\u0006\u0002A\u0003%Q\u0010\u0003\u0005\u0002\u001a\u0005\u0011\r\u0011\"\u0003}\u0011\u001d\tY\"\u0001Q\u0001\nuD\u0001\"!\b\u0002\u0005\u0004%I\u0001 \u0005\b\u0003?\t\u0001\u0015!\u0003~\u0011!\t\t#\u0001b\u0001\n\u0013a\bbBA\u0012\u0003\u0001\u0006I! \u0005\t\u0003K\t!\u0019!C\u0005y\"9\u0011qE\u0001!\u0002\u0013i\b\u0002CA\u0015\u0003\t\u0007I\u0011\u0002?\t\u000f\u0005-\u0012\u0001)A\u0005{\"A\u0011QF\u0001C\u0002\u0013%A\u0010C\u0004\u00020\u0005\u0001\u000b\u0011B?\t\u0011\u0005E\u0012A1A\u0005\nqDq!a\r\u0002A\u0003%Q\u0010C\u0005\u00026\u0005\u0011\r\u0011\"\u0003\u00028!A\u0011qH\u0001!\u0002\u0013\tI\u0004C\u0005\u0002B\u0005\u0011\r\u0011\"\u0003\u00028!A\u00111I\u0001!\u0002\u0013\tI\u0004C\u0005\u0002F\u0005\u0011\r\u0011\"\u0003\u00028!A\u0011qI\u0001!\u0002\u0013\tI\u0004C\u0005\u0002J\u0005\u0011\r\u0011\"\u0001\u0002L!A\u00111N\u0001!\u0002\u0013\ti\u0005C\u0005\u0002n\u0005\u0011\r\u0011\"\u0001\u0002L!A\u0011qN\u0001!\u0002\u0013\ti\u0005C\u0004\u0002r\u0005!\t!a\u001d\t\u000f\u0005E\u0014\u0001\"\u0001\u0002$\"9\u0011QW\u0001\u0005\n\u0005]\u0006bBAn\u0003\u0011%\u0011Q\u001c\u0005\b\u0003O\fA\u0011AAu\u0011%\tY0AI\u0001\n\u0003\tiPB\u0003lI\u0002\u0011\u0019\u0002\u0003\u0006\u0003\"-\u0012)\u0019!C\u0001\u0005GA!B!\f,\u0005\u0003\u0005\u000b\u0011\u0002B\u0013\u0011)\u0011yc\u000bBA\u0002\u0013\u0005!\u0011\u0007\u0005\u000b\u0005gY#\u00111A\u0005\u0002\tU\u0002B\u0003B\u001eW\t\u0005\t\u0015)\u0003\u0002\u0018\"Q!QI\u0016\u0003\u0006\u0004%\t!a\u000e\t\u0015\t\u001d3F!A!\u0002\u0013\tI\u0004\u0003\u0004tW\u0011\u0005!\u0011\n\u0005\n\u0005'Z\u0003\u0019!C\u0005\u0005+B\u0011Ba\u001b,\u0001\u0004%IA!\u001c\t\u0011\tE4\u0006)Q\u0005\u0005/B\u0011Ba\u001d,\u0005\u0004%IA!\u001e\t\u0011\t]4\u0006)A\u0005\u0003\u000bD\u0011B!\u001f,\u0001\u0004%IAa\u001f\t\u0013\tu4\u00061A\u0005\n\t}\u0004\u0002\u0003BBW\u0001\u0006K!!6\t\u0013\t\u00155\u00061A\u0005\n\tm\u0004\"\u0003BDW\u0001\u0007I\u0011\u0002BE\u0011!\u0011ii\u000bQ!\n\u0005U\u0007\"\u0003BHW\t\u0007I\u0011\u0002BI\u0011!\u0011\tk\u000bQ\u0001\n\tM\u0005\"\u0003BRW\t\u0007I\u0011\u0002BI\u0011!\u0011)k\u000bQ\u0001\n\tM\u0005b\u0002BTW\u0011%!\u0011\u0016\u0005\t\u0005W[C\u0011\u00013\u0003.\"9!QW\u0016\u0005\u0002\t]\u0006b\u0002BfW\u0011\u0005!Q\u001a\u0005\t\u0005'\\C\u0011\u00013\u0003V\"9!\u0011\\\u0016\u0005\u0002\tm\u0004b\u0002BnW\u0011\u0005!Q\u001c\u0005\b\u0005S\\C\u0011\u0001Bv\u0011\u001d\u0011io\u000bC\u0005\u0005_D\u0001B!?,\t\u0003!'1 \u0005\b\u0007\u0003YC\u0011BB\u0002\u0011\u001d\u0019ia\u000bC\u0001\u0007\u001fAqaa\u0005,\t\u0003\u0019)\u0002C\u0004\u0004 -\"\ta!\t\t\u000f\r=2\u0006\"\u0001\u00042!91qI\u0016\u0005\u0002\r%\u0003bBB(W\u0011\u00051\u0011\u000b\u0005\b\u0007/ZC\u0011AB-\u0011\u001d\u0019yf\u000bC\u0001\u0007CBqaa\u0019,\t\u0003\u0019)\u0007C\u0004\u0004l-\"\tA!6\t\u000f\r54\u0006\"\u0001\u0003V\"91qN\u0016\u0005\u0002\rE\u0004bBB;W\u0011%1q\u000f\u0005\b\u0007{ZC\u0011AB@\u0011\u001d\u0019\u0019i\u000bC\u0001\u0007\u000bCqa!%,\t\u0003\u0019\u0019\nC\u0004\u0004\u0018.\"\ta!'\t\u000f\r\u00156\u0006\"\u0003\u0004(\"911V\u0016\u0005\n\r\u001d\u0006bBBWW\u0011\u00051q\u0016\u0005\t\u0007k[C\u0011\u00013\u00048\u0006!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJT!!\u001a4\u0002\u00071|wMC\u0001h\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"A[\u0001\u000e\u0003\u0011\u0014A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148CA\u0001n!\tq\u0017/D\u0001p\u0015\u0005\u0001\u0018!B:dC2\f\u0017B\u0001:p\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012![\u0001\u0018!J|G-^2feNs\u0017\r]:i_R4VM]:j_:,\u0012a\u001e\t\u0003]bL!!_8\u0003\u000bMCwN\u001d;\u00021A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$h+\u001a:tS>t\u0007%\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005\u0019\u0019FO]5oO\u0006ia+\u001a:tS>tg)[3mI\u0002\n\u0001b\u0011:d\r&,G\u000eZ\u0001\n\u0007J\u001cg)[3mI\u0002\nq\u0002\u0015:pIV\u001cWM]%e\r&,G\u000eZ\u0001\u0011!J|G-^2fe&#g)[3mI\u0002\n\u0011\u0003T1tiN+\u0017/^3oG\u00164\u0015.\u001a7e\u0003Ia\u0015m\u001d;TKF,XM\\2f\r&,G\u000e\u001a\u0011\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000eZ\u0001\u0014!J|G-^2fe\u0016\u0003xn\u00195GS\u0016dG\rI\u0001\u0010\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0006\u0001B*Y:u\u001f\u001a47/\u001a;GS\u0016dG\rI\u0001\u0011\u001f\u001a47/\u001a;EK2$\u0018MR5fY\u0012\f\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u00039!\u0016.\\3ti\u0006l\u0007OR5fY\u0012\fq\u0002V5nKN$\u0018-\u001c9GS\u0016dG\rI\u0001\u0015!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN4\u0015.\u001a7eA\u0005)2i\\8sI&t\u0017\r^8s\u000bB|7\r\u001b$jK2$\u0017AF\"p_J$\u0017N\\1u_J,\u0005o\\2i\r&,G\u000e\u001a\u0011\u00025\r+(O]3oiRChNR5sgR|eMZ:fi\u001aKW\r\u001c3\u00027\r+(O]3oiRChNR5sgR|eMZ:fi\u001aKW\r\u001c3!\u000351VM]:j_:|eMZ:fiV\u0011\u0011\u0011\b\t\u0004]\u0006m\u0012bAA\u001f_\n\u0019\u0011J\u001c;\u0002\u001dY+'o]5p]>3gm]3uA\u0005I1I]2PM\u001a\u001cX\r^\u0001\u000b\u0007J\u001cwJ\u001a4tKR\u0004\u0013!\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:PM\u001a\u001cX\r^\u0001\u0017!J|G-^2fe\u0016sGO]5fg>3gm]3uA\u0005Y\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006,\"!!\u0014\u0011\t\u0005=\u0013qM\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005)A/\u001f9fg*!\u0011qKA-\u0003!\u0001(o\u001c;pG>d'\u0002BA.\u0003;\naaY8n[>t'bA4\u0002`)!\u0011\u0011MA2\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QM\u0001\u0004_J<\u0017\u0002BA5\u0003#\u0012aaU2iK6\f\u0017\u0001\b)s_\u0012,8-\u001a:T]\u0006\u00048\u000f[8u\u000b:$(/_*dQ\u0016l\u0017\rI\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\u0002+AKGm\u00158baNDw\u000e^'baN\u001b\u0007.Z7bA\u0005a!/Z1e':\f\u0007o\u001d5piR!\u0011QOAJ!\u0019\t9(a\"\u0002\u000e:!\u0011\u0011PAB\u001d\u0011\tY(!!\u000e\u0005\u0005u$bAA@Q\u00061AH]8pizJ\u0011\u0001]\u0005\u0004\u0003\u000b{\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\u000bYI\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t)i\u001c\t\u0004U\u0006=\u0015bAAII\n\u0011\u0002K]8ek\u000e,'o\u0015;bi\u0016,e\u000e\u001e:z\u0011\u001d\t)*\na\u0001\u0003/\u000bAAZ5mKB!\u0011\u0011TAP\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006\r\u0011AA5p\u0013\u0011\t\t+a'\u0003\t\u0019KG.\u001a\u000b\u0005\u0003k\n)\u000bC\u0004\u0002(\u001a\u0002\r!!+\u0002\r\t,hMZ3s!\u0011\tY+!-\u000e\u0005\u00055&\u0002BAX\u0003\u0007\t1A\\5p\u0013\u0011\t\u0019,!,\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0007xe&$Xm\u00158baNDw\u000e\u001e\u000b\u0007\u0003s\u000by,!1\u0011\u00079\fY,C\u0002\u0002>>\u0014A!\u00168ji\"9\u0011QS\u0014A\u0002\u0005]\u0005bBAbO\u0001\u0007\u0011QY\u0001\bK:$(/[3t!!\t9-!5\u0002V\u00065UBAAe\u0015\u0011\tY-!4\u0002\u000f5,H/\u00192mK*\u0019\u0011qZ8\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u0006%'aA'baB\u0019a.a6\n\u0007\u0005ewN\u0001\u0003M_:<\u0017AD5t':\f\u0007o\u001d5pi\u001aKG.\u001a\u000b\u0005\u0003?\f)\u000fE\u0002o\u0003CL1!a9p\u0005\u001d\u0011un\u001c7fC:Dq!!&)\u0001\u0004\t9*A\tmSN$8K\\1qg\"|GOR5mKN$B!a;\u0002xB1\u0011qOAw\u0003cLA!a<\u0002\f\n\u00191+Z9\u0011\u0007)\f\u00190C\u0002\u0002v\u0012\u0014Ab\u00158baNDw\u000e\u001e$jY\u0016Dq!!?*\u0001\u0004\t9*A\u0002eSJ\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA\u0000U\u0011\tID!\u0001,\u0005\t\r\u0001\u0003\u0002B\u0003\u0005\u001fi!Aa\u0002\u000b\t\t%!1B\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0004p\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005#\u00119AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u001cBaK7\u0003\u0016A!!q\u0003B\u000f\u001b\t\u0011IBC\u0002\u0003\u001c\u0019\fQ!\u001e;jYNLAAa\b\u0003\u001a\t9Aj\\4hS:<\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0005K\u0001BAa\n\u0003*5\u0011\u0011\u0011L\u0005\u0005\u0005W\tIF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nqa\u00187pO\u0012K'/\u0006\u0002\u0002\u0018\u0006Yq\f\\8h\t&\u0014x\fJ3r)\u0011\tILa\u000e\t\u0013\ter&!AA\u0002\u0005]\u0015a\u0001=%c\u0005Aq\f\\8h\t&\u0014\b\u0005K\u00021\u0005\u007f\u00012A\u001cB!\u0013\r\u0011\u0019e\u001c\u0002\tm>d\u0017\r^5mK\u0006IR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'t\u0003ii\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:!)!\u0011YE!\u0014\u0003P\tE\u0003C\u00016,\u0011\u001d\u0011\tc\ra\u0001\u0005KAqAa\f4\u0001\u0004\t9\nC\u0005\u0003FM\u0002\n\u00111\u0001\u0002:\u0005I1O\\1qg\"|Go]\u000b\u0003\u0005/\u0002\u0002B!\u0017\u0003d\t\u001d\u0014\u0011_\u0007\u0003\u00057RAA!\u0018\u0003`\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t\u0005\u00141A\u0001\u0005kRLG.\u0003\u0003\u0003f\tm#!F\"p]\u000e,(O]3oiN[\u0017\u000e\u001d'jgRl\u0015\r\u001d\t\u0004}\n%\u0014bAAm\u007f\u0006i1O\\1qg\"|Go]0%KF$B!!/\u0003p!I!\u0011H\u001b\u0002\u0002\u0003\u0007!qK\u0001\u000bg:\f\u0007o\u001d5piN\u0004\u0013!\u00039s_\u0012,8-\u001a:t+\t\t)-\u0001\u0006qe>$WoY3sg\u0002\nQ\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$XCAAk\u0003Ea\u0017m\u001d;NCB|eMZ:fi~#S-\u001d\u000b\u0005\u0003s\u0013\t\tC\u0005\u0003:i\n\t\u00111\u0001\u0002V\u0006qA.Y:u\u001b\u0006\u0004xJ\u001a4tKR\u0004\u0013A\u00047bgR\u001cf.\u00199PM\u001a\u001cX\r^\u0001\u0013Y\u0006\u001cHo\u00158ba>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002:\n-\u0005\"\u0003B\u001d{\u0005\u0005\t\u0019AAk\u0003=a\u0017m\u001d;T]\u0006\u0004xJ\u001a4tKR\u0004\u0013aC8oO>Lgn\u001a+y]N,\"Aa%\u0011\u0011\tU%qSAk\u00057k!Aa\u0018\n\t\te%q\f\u0002\b)J,W-T1q!\rQ'QT\u0005\u0004\u0005?#'a\u0003+y]6+G/\u00193bi\u0006\fAb\u001c8h_&tw\r\u0016=og\u0002\n\u0001#\u001e8sKBd\u0017nY1uK\u0012$\u0006P\\:\u0002#Ut'/\u001a9mS\u000e\fG/\u001a3Uq:\u001c\b%A\u0007m_\u0006$7K\\1qg\"|Go\u001d\u000b\u0003\u0005/\nAC]3n_Z,7\u000b\u001e:bsNs\u0017\r]:i_R\u001cH\u0003BA]\u0005_CqA!-E\u0001\u0004\u0011\u0019,\u0001\ntK\u001elWM\u001c;CCN,wJ\u001a4tKR\u001c\bCBA<\u0003[\f).A\ngSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G/\u0006\u0002\u0003:B)aNa/\u0003@&\u0019!QX8\u0003\r=\u0003H/[8o!\u0011\u0011\tMa2\u000e\u0005\t\r'b\u0001BcM\u000611/\u001a:wKJLAA!3\u0003D\n\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0002-=t\u0007*[4i/\u0006$XM]7be.,\u0006\u000fZ1uK\u0012$B!!/\u0003P\"9!\u0011\u001b$A\u0002\u0005U\u0017!\u00045jO\"<\u0016\r^3s[\u0006\u00148.\u0001\u000bgSJ\u001cH/\u00168eK\u000eLG-\u001a3PM\u001a\u001cX\r^\u000b\u0003\u0005/\u0004RA\u001cB^\u0003+\fA\"\\1q\u000b:$wJ\u001a4tKR\fq\"Y2uSZ,\u0007K]8ek\u000e,'o]\u000b\u0003\u0005?\u0004\u0002B!9\u0003h\u0006U\u0017QR\u0007\u0003\u0005GTAA!:\u0002N\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003'\u0014\u0019/A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005}\u0017\u0001\u00057pC\u00124%o\\7T]\u0006\u00048\u000f[8u)\u0019\tIL!=\u0003v\"9!1_&A\u0002\u0005U\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005o\\\u0005\u0019AAk\u0003-\u0019WO\u001d:f]R$\u0016.\\3\u0002#1|\u0017\r\u001a)s_\u0012,8-\u001a:F]R\u0014\u0018\u0010\u0006\u0003\u0002:\nu\bb\u0002B\u0000\u0019\u0002\u0007\u0011QR\u0001\u0006K:$(/_\u0001\u0012SN\u0004&o\u001c3vG\u0016\u0014X\t\u001f9je\u0016$GCBAp\u0007\u000b\u0019I\u0001C\u0004\u0004\b5\u0003\r!!6\u0002\u001b\r,(O]3oiRKW.Z't\u0011\u001d\u0019Y!\u0014a\u0001\u0003\u001b\u000bQ\u0002\u001d:pIV\u001cWM]*uCR,\u0017A\u0006:f[>4X-\u0012=qSJ,G\r\u0015:pIV\u001cWM]:\u0015\t\u0005e6\u0011\u0003\u0005\b\u0007\u000fq\u0005\u0019AAk\u0003E!(/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a\u000b\t\u0003s\u001b9b!\u0007\u0004\u001e!9!1_(A\u0002\u0005U\u0007bBB\u000e\u001f\u0002\u0007\u0011Q[\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0007\u000fy\u0005\u0019AAk\u0003a\u0011X\r\\8bI\u001a\u0013x.\u001c+jKJ,Gm\u00158baNDw\u000e\u001e\u000b\u000b\u0003s\u001b\u0019c!\n\u0004(\r-\u0002b\u0002Bz!\u0002\u0007\u0011Q\u001b\u0005\b\u0005o\u0004\u0006\u0019AAk\u0011\u001d\u0019I\u0003\u0015a\u0001\u0003S\u000bab\u001d8baNDw\u000e\u001e\"vM\u001a,'\u000fC\u0004\u0004.A\u0003\r!!6\u0002\u001dMt\u0017\r]:i_R|eMZ:fi\u0006i\u0001O]3qCJ,W\u000b\u001d3bi\u0016$baa\r\u0004:\ru\u0002c\u00016\u00046%\u00191q\u00073\u0003%A\u0013x\u000eZ;dKJ\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0007w\t\u0006\u0019AAk\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\b\u0007\u007f\t\u0006\u0019AB!\u0003\u0019y'/[4j]B\u0019!na\u0011\n\u0007\r\u0015CM\u0001\u0007BaB,g\u000eZ(sS\u001eLg.\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003s\u001bY\u0005C\u0004\u0004NI\u0003\raa\r\u0002\u0015\u0005\u0004\b/\u001a8e\u0013:4w.\u0001\nva\u0012\fG/Z'ba\u0016sGm\u00144gg\u0016$H\u0003BA]\u0007'Bqa!\u0016T\u0001\u0004\t).\u0001\u0006mCN$xJ\u001a4tKR\f\u0011\u0002\\1ti\u0016sGO]=\u0015\t\rm3Q\f\t\u0006]\nm\u0016Q\u0012\u0005\b\u0007w!\u0006\u0019AAk\u00031!\u0018m[3T]\u0006\u00048\u000f[8u)\t\tI,A\bva\u0012\fG/\u001a)be\u0016tG\u000fR5s)\u0011\tIla\u001a\t\u000f\r%d\u000b1\u0001\u0002\u0018\u0006I\u0001/\u0019:f]R$\u0015N]\u0001\u0015Y\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\u0002)=dG-Z:u':\f\u0007o\u001d5pi>3gm]3u\u0003myg\u000eT8h'R\f'\u000f^(gMN,G/\u00138de\u0016lWM\u001c;fIR!\u0011\u0011XB:\u0011\u001d\u0011\u00190\u0017a\u0001\u0003+\faD]3n_Z,WK\u001c:fa2L7-\u0019;fIR\u0013\u0018M\\:bGRLwN\\:\u0015\t\u0005e6\u0011\u0010\u0005\b\u0007wR\u0006\u0019AAk\u0003\u0019ygMZ:fi\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0005\u0003s\u001b\t\tC\u0004\u0004|m\u0003\r!!6\u0002!1\f7\u000f^*uC\ndWm\u00144gg\u0016$H\u0003BAk\u0007\u000fCqa!#]\u0001\u0004\u0019Y)\u0001\u0007d_6\u0004H.\u001a;fIRCh\u000eE\u0002k\u0007\u001bK1aa$e\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0003-\u0019w.\u001c9mKR,G\u000b\u001f8\u0015\t\u0005e6Q\u0013\u0005\b\u0007\u0013k\u0006\u0019ABF\u0003U!W\r\\3uKNs\u0017\r]:i_R\u001c()\u001a4pe\u0016$B!!/\u0004\u001c\"911\u00100A\u0002\u0005U\u0007f\u00010\u0004 B!!qCBQ\u0013\u0011\u0019\u0019K!\u0007\u0003\u0015QD'/Z1eg\u00064W-\u0001\npY\u0012,7\u000f^*oCB\u001c\bn\u001c;GS2,WCABU!\u0015q'1XAy\u0003Ia\u0017\r^3tiNs\u0017\r]:i_R4\u0015\u000e\\3\u0002+Mt\u0017\r]:i_R4\u0015\u000e\\3G_J|eMZ:fiR!1\u0011WBZ!\u0015q'1XAL\u0011\u001d\u0019Y(\u0019a\u0001\u0003+\fqC]3n_Z,\u0017I\u001c3EK2,G/Z*oCB\u001c\bn\u001c;\u0015\t\u0005e6\u0011\u0018\u0005\b\u0007[\u0011\u0007\u0019AAkQ\rY3Q\u0018\t\u0005\u0005/\u0019y,\u0003\u0003\u0004B\ne!!\u00048p]RD'/Z1eg\u00064W\r")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File _logDir;
    private final int maxProducerIdExpirationMs;
    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<SnapshotFile> listSnapshotFiles(File file) {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(file);
    }

    public static Iterable<ProducerStateEntry> readSnapshot(ByteBuffer byteBuffer) {
        return ProducerStateManager$.MODULE$.readSnapshot(byteBuffer);
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File _logDir() {
        return this._logDir;
    }

    public void _logDir_$eq(File x$1) {
        this._logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots() {
        return this.snapshots;
    }

    private void snapshots_$eq(ConcurrentSkipListMap<Long, SnapshotFile> x$1) {
        this.snapshots = x$1;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    private ConcurrentSkipListMap<Long, SnapshotFile> loadSnapshots() {
        void var1_1;
        ConcurrentSkipListMap tm = new ConcurrentSkipListMap();
        ProducerStateManager$.MODULE$.listSnapshotFiles(this._logDir()).foreach((Function1 & Serializable & scala.Serializable)f -> tm.put(Predef$.MODULE$.long2Long(f.offset()), f));
        return var1_1;
    }

    public void removeStraySnapshots(Seq<Object> segmentBaseOffsets) {
        None$ maxSegmentBaseOffset = segmentBaseOffsets.isEmpty() ? None$.MODULE$ : new Some(segmentBaseOffsets.max((Ordering)Ordering.Long$.MODULE$));
        Set baseOffsets = segmentBaseOffsets.toSet();
        ObjectRef latestStraySnapshot = ObjectRef.create((Object)None$.MODULE$);
        ConcurrentSkipListMap<Long, SnapshotFile> ss = this.loadSnapshots();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ss.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$removeStraySnapshots$1(latestStraySnapshot, baseOffsets, ss, snapshot);
            return BoxedUnit.UNIT;
        });
        ((Option)latestStraySnapshot.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())).foreach((Function1)((JFunction1.mcVJ.sp & Serializable & scala.Serializable)arg_0 -> ProducerStateManager.$anonfun$removeStraySnapshots$3((Option)maxSegmentBaseOffset, ss, arg_0)));
        this.snapshots_$eq(ss);
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        if (unreplicatedFirstOffset.isEmpty()) {
            return undecidedFirstOffset;
        }
        if (undecidedFirstOffset.isEmpty()) {
            return unreplicatedFirstOffset;
        }
        if (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset()) {
            return undecidedFirstOffset;
        }
        return var1_1;
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        Option<SnapshotFile> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            SnapshotFile snapshot = (SnapshotFile)((Some)option).value();
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(snapshot).append("'").toString());
                ((Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshot.file()).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTime, producerEntry)))).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    this.loadProducerEntry(entry);
                    return BoxedUnit.UNIT;
                });
                this.lastSnapOffset_$eq(snapshot.offset());
                this.lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(snapshot.file()).append("': ").append(e.getMessage()).toString());
                this.removeAndDeleteSnapshot(snapshot.offset());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().$minus$minus$eq((TraversableOnce)((MapLike)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, x0$1)))).keySet());
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$truncateAndReload$1(this, logEndOffset, logStartOffset, snapshot);
            return BoxedUnit.UNIT;
        });
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
            return;
        }
        this.onLogStartOffsetIncremented(logStartOffset);
    }

    public void reloadFromTieredSnapshot(long logStartOffset, long currentTime, ByteBuffer snapshotBuffer, long snapshotOffset) {
        if (this.activeProducers().nonEmpty()) {
            throw new IllegalStateException("expected producer state to be fully truncated before reloading tiered snapshot");
        }
        try {
            Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshotBuffer).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$reloadFromTieredSnapshot$1(this, currentTime, producerEntry)));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("restored state for ").append(loadedProducers.size()).append(" producers from tiered storage").toString());
            loadedProducers.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                this.loadProducerEntry(entry);
                return BoxedUnit.UNIT;
            });
            this.lastMapOffset_$eq(snapshotOffset);
            return;
        }
        catch (CorruptSnapshotException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to load producer snapshot from buffer: ").append(e.getMessage()).toString());
            throw e;
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin) {
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append("for partition ").append(this.topicPartition()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            ((ProducerStateEntry)((Some)option).value()).update(updatedEntry);
        } else if (None$.MODULE$.equals(option)) {
            this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.lastMapOffset() > this.lastSnapOffset()) {
            SnapshotFile snapshotFile = SnapshotFile$.MODULE$.apply(Log$.MODULE$.producerSnapshotFile(this._logDir(), this.lastMapOffset()));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Writing producer snapshot at offset ").append(this.lastMapOffset()).toString());
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile.file(), this.producers());
            this.snapshots().put(Predef$.MODULE$.long2Long(snapshotFile.offset()), snapshotFile);
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public void updateParentDir(File parentDir) {
        this._logDir_$eq(parentDir);
        this.snapshots().forEach((x$7, s) -> s.updateParentDir(parentDir));
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.offset()));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.offset()));
    }

    public void onLogStartOffsetIncremented(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().lastOffset().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$10 -> x$10 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncateFullyAndStartAt(long offset) {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(offset);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        return BoxesRunTime.unboxToLong((Object)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.ongoingTxns().values()).asScala()).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$11))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$2(x$12))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().subMap((Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(offset)).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
    }

    private Option<SnapshotFile> oldestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$13 -> (SnapshotFile)x$13.getValue());
    }

    private Option<SnapshotFile> latestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().lastEntry()).map((Function1 & Serializable & scala.Serializable)x$14 -> (SnapshotFile)x$14.getValue());
    }

    public Option<File> snapshotFileForOffset(long offset) {
        return Option$.MODULE$.apply((Object)this.snapshots().get(BoxesRunTime.boxToLong((long)offset))).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.file());
    }

    public void removeAndDeleteSnapshot(long snapshotOffset) {
        Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).foreach((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.deleteIfExists()));
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$1(ObjectRef latestStraySnapshot$1, Set baseOffsets$1, ConcurrentSkipListMap ss$1, SnapshotFile snapshot) {
        long key = snapshot.offset();
        Option option = (Option)latestStraySnapshot$1.elem;
        if (option instanceof Some) {
            SnapshotFile prev = (SnapshotFile)((Some)option).value();
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                prev.deleteIfExists();
                ss$1.remove(BoxesRunTime.boxToLong((long)prev.offset()));
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else if (None$.MODULE$.equals(option)) {
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$3(Option maxSegmentBaseOffset$1, ConcurrentSkipListMap ss$1, long strayOffset) {
        maxSegmentBaseOffset$1.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)maxOffset -> {
            if (strayOffset < maxOffset) {
                Option$.MODULE$.apply(ss$1.remove(BoxesRunTime.boxToLong((long)strayOffset))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.deleteIfExists()));
            }
        });
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTime$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)x0$1._2();
        boolean bl = $this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateAndReload$1(ProducerStateManager $this, long logEndOffset$1, long logStartOffset$1, SnapshotFile snapshot) {
        if (snapshot.offset() > logEndOffset$1 || snapshot.offset() <= logStartOffset$1) {
            $this.removeAndDeleteSnapshot(snapshot.offset());
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadFromTieredSnapshot$1(ProducerStateManager $this, long currentTime$2, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$2, producerEntry);
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$11) {
        return x$11.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$12) {
        return x$12.firstOffset().messageOffset();
    }

    public ProducerStateManager(TopicPartition topicPartition, File _logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this._logDir = _logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.snapshots = (ConcurrentSkipListMap)Predef$.MODULE$.locally(this.loadSnapshots());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

