/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.FetchedTimestampAndOffset$;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LazyIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.SegmentStats$;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011eb\u0001\u00020`\u0001\u0011D\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t!\u001d\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005e\"Q\u0011\u0011\u0001\u0001\u0003\u0006\u0004%\t!a\u0001\t\u0015\u0005M\u0001A!A!\u0002\u0013\t)\u0001\u0003\u0006\u0002\u0016\u0001\u0011)\u0019!C\u0001\u0003/A!\"!\t\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t\u0019\u0003\u0001BC\u0002\u0013\u0005\u0011Q\u0005\u0005\u000b\u0003[\u0001!\u0011!Q\u0001\n\u0005\u001d\u0002BCA\u0018\u0001\t\u0015\r\u0011\"\u0001\u00022!Q\u0011\u0011\b\u0001\u0003\u0002\u0003\u0006I!a\r\t\u0015\u0005m\u0002A!b\u0001\n\u0003\ti\u0004\u0003\u0006\u0002F\u0001\u0011\t\u0011)A\u0005\u0003\u007fA!\"a\u0012\u0001\u0005\u000b\u0007I\u0011AA\u0019\u0011)\tI\u0005\u0001B\u0001B\u0003%\u00111\u0007\u0005\u000b\u0003\u0017\u0002!Q1A\u0005\u0002\u00055\u0003BCA-\u0001\t\u0005\t\u0015!\u0003\u0002P!A\u00111\f\u0001\u0005\u0002}\u000bi\u0006C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u00037\u0003A\u0011AAO\u0011%\t\u0019\u000b\u0001a\u0001\n\u0013\t\t\u0004C\u0005\u0002&\u0002\u0001\r\u0011\"\u0003\u0002(\"A\u0011Q\u0016\u0001!B\u0013\t\u0019\u0004C\u0005\u00020\u0002\u0001\r\u0011\"\u0003\u0002>!I\u0011\u0011\u0017\u0001A\u0002\u0013%\u00111\u0017\u0005\t\u0003o\u0003\u0001\u0015)\u0003\u0002@!I\u0011\u0011\u0018\u0001A\u0002\u0013%\u00111\u0018\u0005\n\u0003\u0007\u0004\u0001\u0019!C\u0005\u0003\u000bD\u0001\"!3\u0001A\u0003&\u0011Q\u0018\u0005\n\u0003'\u0004\u0001\u0019!C\u0005\u0003wC\u0011\"!6\u0001\u0001\u0004%I!a6\t\u0011\u0005m\u0007\u0001)Q\u0005\u0003{Cq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002h\u0002!\t!!\r\t\u0013\u0005%\b\u00011A\u0005\n\u0005m\u0006\"CAv\u0001\u0001\u0007I\u0011BAw\u0011!\t\t\u0010\u0001Q!\n\u0005u\u0006bBA{\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0003{\u0004A\u0011AA\u0019\u0011\u001d\tI\n\u0001C\u0001\u0003{Aq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\u0006\u0001!\tAa\u0002\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!9!Q\u0006\u0001\u0005\n\t=\u0002b\u0002B!\u0001\u0011\u0005!1\t\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005CB\u0001Ba\u001e\u0001\t\u0003y&\u0011\u0010\u0005\u000b\u0005c\u0003\u0011\u0013!C\u0001?\nM\u0006b\u0002Be\u0001\u0011\u0005!1\u001a\u0005\n\u0005W\u0004\u0011\u0013!C\u0001\u0005[D\u0011B!=\u0001#\u0003%\tAa=\t\u000f\t]\b\u0001\"\u0001\u0003z\"91\u0011\u0002\u0001\u0005\u0002\r-\u0001\"CB\u0012\u0001E\u0005I\u0011AB\u0013\u0011\u001d\u0019I\u0003\u0001C\u0005\u0007WAqa!\f\u0001\t\u0003\u0019y\u0003C\u0004\u00042\u0001!\taa\r\t\u000f\r\r\u0003\u0001\"\u0011\u0004F!91q\u000b\u0001\u0005\u0002\re\u0003bBB0\u0001\u0011%1\u0011\r\u0005\t\u0007G\u0002\u0001\u0015!\u0003\u0004f!91Q\u0010\u0001\u0005\u0002\u0005E\u0002bBBA\u0001\u0011\u000511\u0006\u0005\b\u0007\u000b\u0003A\u0011ABD\u0011\u001d\u0019I\n\u0001C\u0001\u00077Cqa!*\u0001\t\u0003\u0019Y\u0003C\u0004\u0004(\u0002!Iaa\u000b\t\u000f\r%\u0006\u0001\"\u0001\u0004,\"91Q\u0017\u0001\u0005\u0002\r\u0005\u0004bBB\\\u0001\u0011\u00051\u0011\u0018\u0005\n\u0007\u001b\u0004\u0011\u0013!C\u0001\u0005[Dqaa4\u0001\t\u0003\u0019Y\u0003C\u0004\u0004R\u0002!\taa\u000b\t\u000f\rM\u0007\u0001\"\u0001\u0004,!91Q\u001b\u0001\u0005\u0002\u0005E\u0002bBBl\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005\u001f\u0001A\u0011AA\u0019\u0011\u001d\u0019I\u000e\u0001C\u0001\u00077<qaa=`\u0011\u0003\u0019)P\u0002\u0004_?\"\u00051q\u001f\u0005\b\u00037\u001aF\u0011AB}\u0011%\u0019Yp\u0015b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0004~N\u0003\u000b\u0011BA\u001a\u0011\u001d\u0019yp\u0015C\u0001\t\u0003A\u0011\u0002b\tT#\u0003%\tAa=\t\u0013\u0011\u00152+%A\u0005\u0002\tM\u0006\"\u0003C\u0014'F\u0005I\u0011\u0001Bz\u0011%!IcUI\u0001\n\u0003!Y\u0003C\u0004\u0004TN#\t\u0001b\f\t\u0013\u0011]2+%A\u0005\u0002\u0011-\"A\u0003'pON+w-\\3oi*\u0011\u0001-Y\u0001\u0004Y><'\"\u00012\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!Z6\u0011\u0005\u0019LW\"A4\u000b\u0003!\fQa]2bY\u0006L!A[4\u0003\r\u0005s\u0017PU3g!\taw.D\u0001n\u0015\tq\u0017-A\u0003vi&d7/\u0003\u0002q[\n9Aj\\4hS:<W#\u0001:\u0011\u0005MlX\"\u0001;\u000b\u0005U4\u0018A\u0002:fG>\u0014HM\u0003\u0002xq\u000611m\\7n_:T!AY=\u000b\u0005i\\\u0018AB1qC\u000eDWMC\u0001}\u0003\ry'oZ\u0005\u0003}R\u00141BR5mKJ+7m\u001c:eg\u0006!An\\4!\u0003=a\u0017M_=PM\u001a\u001cX\r^%oI\u0016DXCAA\u0003!\u0019\t9!!\u0003\u0002\u000e5\tq,C\u0002\u0002\f}\u0013\u0011\u0002T1{s&sG-\u001a=\u0011\t\u0005\u001d\u0011qB\u0005\u0004\u0003#y&aC(gMN,G/\u00138eKb\f\u0001\u0003\\1{s>3gm]3u\u0013:$W\r\u001f\u0011\u0002\u001b1\f'0\u001f+j[\u0016Le\u000eZ3y+\t\tI\u0002\u0005\u0004\u0002\b\u0005%\u00111\u0004\t\u0005\u0003\u000f\ti\"C\u0002\u0002 }\u0013\u0011\u0002V5nK&sG-\u001a=\u0002\u001d1\f'0\u001f+j[\u0016Le\u000eZ3yA\u0005AA\u000f\u001f8J]\u0012,\u00070\u0006\u0002\u0002(A!\u0011qAA\u0015\u0013\r\tYc\u0018\u0002\u0011)J\fgn]1di&|g.\u00138eKb\f\u0011\u0002\u001e=o\u0013:$W\r\u001f\u0011\u0002\u0015\t\f7/Z(gMN,G/\u0006\u0002\u00024A\u0019a-!\u000e\n\u0007\u0005]rM\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\n!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgV\u0011\u0011q\b\t\u0004M\u0006\u0005\u0013bAA\"O\n\u0019\u0011J\u001c;\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\u0002\u0019I|G\u000e\u001c&jiR,'/T:\u0002\u001bI|G\u000e\u001c&jiR,'/T:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005=\u0003\u0003BA)\u0003+j!!a\u0015\u000b\u000594\u0018\u0002BA,\u0003'\u0012A\u0001V5nK\u0006)A/[7fA\u00051A(\u001b8jiz\"\"#a\u0018\u0002b\u0005\r\u0014QMA4\u0003S\nY'!\u001c\u0002pA\u0019\u0011q\u0001\u0001\t\u000b\u0001\f\u0002\u0019\u0001:\t\u000f\u0005\u0005\u0011\u00031\u0001\u0002\u0006!9\u0011QC\tA\u0002\u0005e\u0001bBA\u0012#\u0001\u0007\u0011q\u0005\u0005\b\u0003_\t\u0002\u0019AA\u001a\u0011\u001d\tY$\u0005a\u0001\u0003\u007fAq!a\u0012\u0012\u0001\u0004\t\u0019\u0004C\u0004\u0002LE\u0001\r!a\u0014\u0002\u0017=4gm]3u\u0013:$W\r_\u000b\u0003\u0003\u001b\t\u0011\u0002^5nK&sG-\u001a=\u0016\u0005\u0005m\u0011AC:i_VdGMU8mYR!\u0011QPAB!\r1\u0017qP\u0005\u0004\u0003\u0003;'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000b#\u0002\u0019AAD\u0003)\u0011x\u000e\u001c7QCJ\fWn\u001d\t\u0005\u0003\u000f\tI)C\u0002\u0002\f~\u0013!BU8mYB\u000b'/Y7t\u00035\u0011Xm]5{K&sG-\u001a=fgR!\u0011\u0011SAL!\r1\u00171S\u0005\u0004\u0003+;'\u0001B+oSRDq!!'\u0016\u0001\u0004\ty$\u0001\u0003tSj,\u0017aC:b]&$\u0018p\u00115fG.$B!!%\u0002 \"9\u0011\u0011\u0015\fA\u0002\u0005u\u0014!\u0007;j[\u0016Le\u000eZ3y\r&dWMT3xYf\u001c%/Z1uK\u0012\fqa\u0019:fCR,G-A\u0006de\u0016\fG/\u001a3`I\u0015\fH\u0003BAI\u0003SC\u0011\"a+\u0019\u0003\u0003\u0005\r!a\r\u0002\u0007a$\u0013'\u0001\u0005de\u0016\fG/\u001a3!\u0003a\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/_\u0001\u001dEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJLx\fJ3r)\u0011\t\t*!.\t\u0013\u0005-6$!AA\u0002\u0005}\u0012!\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\u0002\nQC]8mY&twMQ1tK\u0012$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002>B)a-a0\u00024%\u0019\u0011\u0011Y4\u0003\r=\u0003H/[8o\u0003e\u0011x\u000e\u001c7j]\u001e\u0014\u0015m]3e)&lWm\u001d;b[B|F%Z9\u0015\t\u0005E\u0015q\u0019\u0005\n\u0003Ws\u0012\u0011!a\u0001\u0003{\u000baC]8mY&twMQ1tK\u0012$\u0016.\\3ti\u0006l\u0007\u000f\t\u0015\u0004?\u00055\u0007c\u00014\u0002P&\u0019\u0011\u0011[4\u0003\u0011Y|G.\u0019;jY\u0016\f!cX7bqRKW.Z:uC6\u00048k\u001c$be\u00061r,\\1y)&lWm\u001d;b[B\u001cvNR1s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u0006e\u0007\"CAVC\u0005\u0005\t\u0019AA_\u0003MyV.\u0019=US6,7\u000f^1naN{g)\u0019:!Q\r\u0011\u0013QZ\u0001\u0016[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014x\fJ3r)\u0011\t\t*a9\t\u000f\u0005\u00158\u00051\u0001\u00024\u0005IA/[7fgR\fW\u000e]\u0001\u0012[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014\u0018AG0pM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014\u0018AH0pM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014x\fJ3r)\u0011\t\t*a<\t\u0013\u0005-f%!AA\u0002\u0005u\u0016aG0pM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014\b\u0005K\u0002(\u0003\u001b\fQd\u001c4gg\u0016$xJZ'bqRKW.Z:uC6\u00048k\u001c$be~#S-\u001d\u000b\u0005\u0003#\u000bI\u0010C\u0004\u0002|\"\u0002\r!a\r\u0002\r=4gm]3u\u0003eygMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:\u00025\r\fgnQ8om\u0016\u0014H\u000fV8SK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\t\u0005u$1\u0001\u0005\b\u0003w\\\u0003\u0019AA\u001a\u0003\u0019\t\u0007\u000f]3oIRQ\u0011\u0011\u0013B\u0005\u0005\u001b\u0011\tB!\u0006\t\u000f\t-A\u00061\u0001\u00024\u0005iA.\u0019:hKN$xJ\u001a4tKRDqAa\u0004-\u0001\u0004\t\u0019$\u0001\tmCJ<Wm\u001d;US6,7\u000f^1na\"9!1\u0003\u0017A\u0002\u0005M\u0012aG:iC2dwn^(gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0003\u00181\u0002\rA!\u0007\u0002\u000fI,7m\u001c:egB\u00191Oa\u0007\n\u0007\tuAOA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0015\u0004Y\t\u0005\u0002c\u00017\u0003$%\u0019!QE7\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0003M)gn];sK>3gm]3u\u0013:\u0014\u0016M\\4f)\u0011\t\tJa\u000b\t\u000f\u0005mX\u00061\u0001\u00024\u0005\u0019\u0012\r\u001d9f]\u0012\u001c\u0005.\u001e8l\rJ|WNR5mKRA\u0011q\bB\u0019\u0005g\u00119\u0004\u0003\u0004\u0003\u00189\u0002\rA\u001d\u0005\b\u0005kq\u0003\u0019AA \u0003!\u0001xn]5uS>t\u0007b\u0002B\u001d]\u0001\u0007!1H\u0001\u000fEV4g-\u001a:TkB\u0004H.[3s!\u0011\t\tF!\u0010\n\t\t}\u00121\u000b\u0002\u000f\u0005V4g-\u001a:TkB\u0004H.[3s\u00039\t\u0007\u000f]3oI\u001a\u0013x.\u001c$jY\u0016$b!a\u0010\u0003F\t\u001d\u0003B\u0002B\f_\u0001\u0007!\u000fC\u0004\u0003J=\u0002\r!a\u0010\u0002\u000bM$\u0018M\u001d;\u0002\u001dU\u0004H-\u0019;f)bt\u0017J\u001c3fqR1\u0011\u0011\u0013B(\u00053BqA!\u00151\u0001\u0004\u0011\u0019&\u0001\u0007d_6\u0004H.\u001a;fIRCh\u000e\u0005\u0003\u0002\b\tU\u0013b\u0001B,?\na1i\\7qY\u0016$X\r\u001a+y]\"9!1\f\u0019A\u0002\u0005M\u0012\u0001\u00057bgR\u001cF/\u00192mK>3gm]3uQ\r\u0001$\u0011E\u0001\u0014kB$\u0017\r^3Qe>$WoY3s'R\fG/\u001a\u000b\u0007\u0003#\u0013\u0019G!\u001c\t\u000f\t\u0015\u0014\u00071\u0001\u0003h\u0005!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u0004B!a\u0002\u0003j%\u0019!1N0\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0011\u001d\u0011y'\ra\u0001\u0005c\nQAY1uG\"\u00042a\u001dB:\u0013\r\u0011)\b\u001e\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007.A\bue\u0006t7\u000f\\1uK>3gm]3u)\u0019\u0011YHa)\u0003&B!!Q\u0010BO\u001d\u0011\u0011yH!'\u000f\t\t\u0005%q\u0013\b\u0005\u0005\u0007\u0013)J\u0004\u0003\u0003\u0006\nMe\u0002\u0002BD\u0005#sAA!#\u0003\u00106\u0011!1\u0012\u0006\u0004\u0005\u001b\u001b\u0017A\u0002\u001fs_>$h(C\u0001}\u0013\tQ80\u0003\u0002cs&\u0011q\u000f_\u0005\u0003kZL1Aa'u\u0003-1\u0015\u000e\\3SK\u000e|'\u000fZ:\n\t\t}%\u0011\u0015\u0002\u0012\u0019><wJ\u001a4tKR\u0004vn]5uS>t'b\u0001BNi\"9\u00111 \u001aA\u0002\u0005M\u0002\"\u0003BTeA\u0005\t\u0019AA \u0003Q\u0019H/\u0019:uS:<g)\u001b7f!>\u001c\u0018\u000e^5p]\"\u001a!Ga+\u0011\u00071\u0014i+C\u0002\u000306\u0014!\u0002\u001e5sK\u0006$7/\u00194f\u0003e!(/\u00198tY\u0006$Xm\u00144gg\u0016$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tU&\u0006BA \u0005o[#A!/\u0011\t\tm&QY\u0007\u0003\u0005{SAAa0\u0003B\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0007<\u0017AC1o]>$\u0018\r^5p]&!!q\u0019B_\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0005e\u0016\fG\r\u0006\u0006\u0003N\ne'Q\u001cBq\u0005K\u0004BAa4\u0003V6\u0011!\u0011\u001b\u0006\u0004\u0005'\f\u0017AB:feZ,'/\u0003\u0003\u0003X\nE'!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000eC\u0004\u0003\\R\u0002\r!a\r\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005?$\u0004\u0019AA \u0003\u001di\u0017\r_*ju\u0016D\u0011Ba95!\u0003\u0005\r!a\r\u0002\u00175\f\u0007\u0010U8tSRLwN\u001c\u0005\n\u0005O$\u0004\u0013!a\u0001\u0003{\nQ\"\\5o\u001f:,W*Z:tC\u001e,\u0007f\u0001\u001b\u0003,\u0006q!/Z1eI\u0011,g-Y;mi\u0012\u001aTC\u0001BxU\u0011\t\u0019Da.\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u001f\u0016\u0005\u0003{\u00129,A\u000bgKR\u001c\u0007.\u00169qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\u0015\r\u0005u&1`B\u0003\u0011\u001d\u0011ip\u000ea\u0001\u0005\u007f\f1c\u001d;beR|eMZ:fiB{7/\u001b;j_:\u0004B!a\u0002\u0004\u0002%\u001911A0\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"91qA\u001cA\u0002\u0005}\u0012!\u00034fi\u000eD7+\u001b>f\u0003\u001d\u0011XmY8wKJ$b!a\u0010\u0004\u000e\r=\u0001b\u0002B3q\u0001\u0007!q\r\u0005\n\u0007#A\u0004\u0013!a\u0001\u0007'\t\u0001\u0003\\3bI\u0016\u0014X\t]8dQ\u000e\u000b7\r[3\u0011\u000b\u0019\fyl!\u0006\u0011\t\r]1QD\u0007\u0003\u00073QAaa\u0007\u0003R\u0006)Q\r]8dQ&!1qDB\r\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\"\u001a\u0001H!\t\u0002#I,7m\u001c<fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004()\"11\u0003B\\\u0003Qaw.\u00193MCJ<Wm\u001d;US6,7\u000f^1naR\u0011\u0011\u0011S\u0001\fQ\u0006\u001cxJ^3sM2|w/\u0006\u0002\u0002~\u0005\u00112m\u001c7mK\u000e$\u0018IY8si\u0016$G\u000b\u001f8t)\u0019\u0019)da\u000f\u0004@A!\u0011qAB\u001c\u0013\r\u0019Id\u0018\u0002\u0015)bt\u0017J\u001c3fqN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u000f\ruB\b1\u0001\u00024\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\u0019\t\u0005\u0010a\u0001\u0003g\t\u0001#\u001e9qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"aa\u0012\u0011\t\r%3\u0011\u000b\b\u0005\u0007\u0017\u001ai\u0005E\u0002\u0003\n\u001eL1aa\u0014h\u0003\u0019\u0001&/\u001a3fM&!11KB+\u0005\u0019\u0019FO]5oO*\u00191qJ4\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u0002@\rm\u0003bBA~}\u0001\u0007\u00111\u0007\u0015\u0004}\t\u0005\u0012AD:dC:tU\r\u001f;PM\u001a\u001cX\r\u001e\u000b\u0003\u0003g\t\u0011\u0003\\1tiN+w-\\3oi>3gm]3u!\u0011\u00199g!\u001f\u000e\u0005\r%$\u0002BB6\u0007[\na!\u0019;p[&\u001c'\u0002BB8\u0007c\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0019\u0019h!\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0007o\nAA[1wC&!11PB5\u0005)\tEo\\7jG2{gnZ\u0001\u000fe\u0016\fGMT3yi>3gm]3uQ\r\t%1V\u0001\u0006M2,8\u000f\u001b\u0015\u0004\u0005\n-\u0016aD;qI\u0006$X\rU1sK:$H)\u001b:\u0015\t\u0005E5\u0011\u0012\u0005\b\u0007\u0017\u001b\u0005\u0019ABG\u0003\r!\u0017N\u001d\t\u0005\u0007\u001f\u001b)*\u0004\u0002\u0004\u0012*!11SB;\u0003\tIw.\u0003\u0003\u0004\u0018\u000eE%\u0001\u0002$jY\u0016\f!c\u00195b]\u001e,g)\u001b7f'V4g-\u001b=fgR1\u0011\u0011SBO\u0007CCqaa(E\u0001\u0004\u00199%A\u0005pY\u0012\u001cVO\u001a4jq\"911\u0015#A\u0002\r\u001d\u0013!\u00038foN+hMZ5y\u0003]ygNQ3d_6,\u0017J\\1di&4XmU3h[\u0016tG/A\fm_\u0006$g)\u001b:ti\n\u000bGo\u00195US6,7\u000f^1na\u0006\tB/[7f/\u0006LG/\u001a3G_J\u0014v\u000e\u001c7\u0015\r\u0005M2QVBY\u0011\u001d\u0019yk\u0012a\u0001\u0003g\t1A\\8x\u0011\u001d\u0019\u0019l\u0012a\u0001\u0003g\t\u0001#\\3tg\u0006<W\rV5nKN$\u0018-\u001c9\u0002-\u001d,GOR5sgR\u0014\u0015\r^2i)&lWm\u001d;b[B\fQCZ5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0004\u0004<\u000e\u001d7\u0011\u001a\t\u0006M\u0006}6Q\u0018\t\u0005\u0007\u007f\u001b\u0019-\u0004\u0002\u0004B*\u0011q/Y\u0005\u0005\u0007\u000b\u001c\tMA\rGKR\u001c\u0007.\u001a3US6,7\u000f^1na\u0006sGm\u00144gg\u0016$\bbBAs\u0013\u0002\u0007\u00111\u0007\u0005\n\u0007\u0017L\u0005\u0013!a\u0001\u0003g\tab\u001d;beRLgnZ(gMN,G/A\u0010gS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9%I\u00164\u0017-\u001e7uII\nQa\u00197pg\u0016\fQb\u00197pg\u0016D\u0015M\u001c3mKJ\u001c\u0018A\u00043fY\u0016$X-\u00134Fq&\u001cHo]\u0001\rY\u0006\u001cH/T8eS\u001aLW\rZ\u0001\u0017Y\u0006\u0014x-Z:u%\u0016\u001cwN\u001d3US6,7\u000f^1na\u0006\u0001B.Y:u\u001b>$\u0017NZ5fI~#S-\u001d\u000b\u0005\u0007;\u001ci\u000f\u0005\u0003\u0004`\u000e%XBABq\u0015\u0011\u0019\u0019o!:\u0002\t\u0019LG.\u001a\u0006\u0005\u0007O\u001c)(A\u0002oS>LAaa;\u0004b\n!\u0001+\u0019;i\u0011\u001d\u0019y/\u0015a\u0001\u0003g\t!!\\:)\u0007\u0001\u0011\t#\u0001\u0006M_\u001e\u001cVmZ7f]R\u00042!a\u0002T'\t\u0019V\r\u0006\u0002\u0004v\u0006\tRK\\6o_^tG*Y:u\u001f\u001a47/\u001a;\u0002%Us7N\\8x]2\u000b7\u000f^(gMN,G\u000fI\u0001\u0005_B,g\u000e\u0006\n\u0002`\u0011\rAQ\u0001C\u0004\t#!\u0019\u0002b\u0006\u0005\u001c\u0011}\u0001bBBF/\u0002\u00071Q\u0012\u0005\b\u0003_9\u0006\u0019AA\u001a\u0011\u001d!Ia\u0016a\u0001\t\u0017\taaY8oM&<\u0007\u0003BA\u0004\t\u001bI1\u0001b\u0004`\u0005%aunZ\"p]\u001aLw\rC\u0004\u0002L]\u0003\r!a\u0014\t\u0013\u0011Uq\u000b%AA\u0002\u0005u\u0014!\u00054jY\u0016\fEN]3bIf,\u00050[:ug\"IA\u0011D,\u0011\u0002\u0003\u0007\u0011qH\u0001\rS:LGOR5mKNK'0\u001a\u0005\n\t;9\u0006\u0013!a\u0001\u0003{\n1\u0002\u001d:fC2dwnY1uK\"IA\u0011E,\u0011\u0002\u0003\u00071qI\u0001\u000bM&dWmU;gM&D\u0018AD8qK:$C-\u001a4bk2$H%N\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u00039y\u0007/\u001a8%I\u00164\u0017-\u001e7uI]\nab\u001c9f]\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0005.)\"1q\tB\\)!\t\t\n\"\r\u00054\u0011U\u0002bBBF9\u0002\u00071Q\u0012\u0005\b\u0003_a\u0006\u0019AA\u001a\u0011%!\t\u0003\u0018I\u0001\u0002\u0004\u00199%\u0001\reK2,G/Z%g\u000bbL7\u000f^:%I\u00164\u0017-\u001e7uIM\u0002")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> _maxTimestampSoFar;
    private volatile Option<Object> _offsetOfMaxTimestampSoFar;
    private final AtomicLong lastSegmentOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated) {
                this.timeIndex().resize(0);
            }
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private Option<Object> _maxTimestampSoFar() {
        return this._maxTimestampSoFar;
    }

    private void _maxTimestampSoFar_$eq(Option<Object> x$1) {
        this._maxTimestampSoFar = x$1;
    }

    public void maxTimestampSoFar_$eq(long timestamp) {
        this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
    }

    public long maxTimestampSoFar() {
        if (this._maxTimestampSoFar().isEmpty()) {
            this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.timeIndex().lastEntry().timestamp())));
        }
        return BoxesRunTime.unboxToLong((Object)this._maxTimestampSoFar().get());
    }

    private Option<Object> _offsetOfMaxTimestampSoFar() {
        return this._offsetOfMaxTimestampSoFar;
    }

    private void _offsetOfMaxTimestampSoFar_$eq(Option<Object> x$1) {
        this._offsetOfMaxTimestampSoFar = x$1;
    }

    public void offsetOfMaxTimestampSoFar_$eq(long offset) {
        this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    public long offsetOfMaxTimestampSoFar() {
        if (this._offsetOfMaxTimestampSoFar().isEmpty()) {
            this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.timeIndex().lastEntry().offset())));
        }
        return BoxesRunTime.unboxToLong((Object)this._offsetOfMaxTimestampSoFar().get());
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = BoxesRunTime.unboxToInt(SegmentStats$.MODULE$.segmentAppendTimeMs().time((JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.log().append(records)));
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            this.lastSegmentOffset.set(largestOffset);
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestampSoFar_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                SegmentStats$.MODULE$.offsetIndexAppendTimeMs().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().append(largestOffset, physicalPosition));
                SegmentStats$.MODULE$.timestampIndexAppendTimeMs().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    TimeIndex qual$1 = this.timeIndex();
                    long x$1 = this.maxTimestampSoFar();
                    long x$2 = this.offsetOfMaxTimestampSoFar();
                    boolean x$3 = qual$1.maybeAppend$default$3();
                    qual$1.maybeAppend(x$1, x$2, x$3);
                });
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator().takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin$Replication$.MODULE$);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, (Option<LogOffsetMetadata>)None$.MODULE$);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        }
        int fetchSize = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException;
            if (bl) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.offsetOfMaxTimestampSoFar_$eq(lastTimeIndexEntry.offset());
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.FileTimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.txnIndex().truncateTo(offset);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
        return bytesTruncated;
    }

    private long scanNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        if (fetchData == null) {
            return this.baseOffset();
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.baseOffset()));
    }

    /*
     * WARNING - void declaration
     */
    public long readNextOffset() {
        void var3_2;
        long scannedNextOffset;
        this.lastSegmentOffset.get();
        do {
            long cachedLastSegmentOffset;
            if ((cachedLastSegmentOffset = this.lastSegmentOffset.get()) != LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset()) {
                return cachedLastSegmentOffset + 1L;
            }
            scannedNextOffset = this.scanNextOffset();
        } while (!this.lastSegmentOffset.compareAndSet(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset(), scannedNextOffset - 1L));
        return (long)var3_2;
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateParentDir(File dir) {
        this.log().updateParentDir(dir);
        this.lazyOffsetIndex().updateParentDir(dir);
        this.lazyTimeIndex().updateParentDir(dir);
        this.txnIndex().updateParentDir(dir);
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.lazyOffsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.lazyTimeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FetchedTimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset)).map((Function1 & Serializable & scala.Serializable)found -> {
            if (found.exception == null) {
                return FetchedTimestampAndOffset$.MODULE$.apply(found.timestamp, found.offset, (Option<Object>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(found.leaderEpoch)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4))));
            }
            return FetchedTimestampAndOffset$.MODULE$.apply(found.exception);
        });
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        if (this._maxTimestampSoFar().nonEmpty() || this._offsetOfMaxTimestampSoFar().nonEmpty()) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyOffsetIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyTimeIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyOffsetIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyTimeIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().closeHandlers(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.log().file();
            String delete$1_fileType = "log";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$4(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyOffsetIndex().file();
            String delete$1_fileType = "offset index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$6(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyTimeIndex().file();
            String delete$1_fileType = "time index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$8(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            File delete$1_file = this.txnIndex().file();
            String delete$1_fileType = "transaction index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$10(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)Nil$.MODULE$)))));
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.maxTimestampSoFar()));
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.lastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0 && cache.latestEpoch().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) {
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.ensureOffsetInRange(batch.lastOffset());
        if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
            $this.maxTimestampSoFar_$eq(batch.maxTimestamp());
            $this.offsetOfMaxTimestampSoFar_$eq(batch.lastOffset());
        }
        if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
            $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
            TimeIndex qual$1 = $this.timeIndex();
            long x$1 = $this.maxTimestampSoFar();
            long x$2 = $this.offsetOfMaxTimestampSoFar();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
            lastIndexEntry$1.elem = validBytes$1.elem;
        }
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            leaderEpochCache$1.foreach((Function1 & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch);
        }
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$4(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$6(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$8(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$10(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampSoFar = None$.MODULE$;
        this._offsetOfMaxTimestampSoFar = None$.MODULE$;
        this.lastSegmentOffset = new AtomicLong(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }
}

