/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Future;
import kafka.log.CleanerConfig;
import kafka.log.LogCleaner$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.LogDirFailureChannel;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.KafkaScheduler;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class LogManager$ {
    public static LogManager$ MODULE$;
    private final String RecoveryPointCheckpointFile;
    private final String LogStartOffsetCheckpointFile;
    private final int ProducerIdExpirationCheckIntervalMs;
    private final Set<String> ReconfigurableConfigs;

    static {
        new LogManager$();
    }

    public boolean waitForAllToComplete(Seq<Future<?>> jobs, Function1<Throwable, BoxedUnit> callback) {
        return jobs.count((Function1 & Serializable & scala.Serializable)future -> {
            boolean bl;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> future.get());
            if (try_ instanceof Success) {
                bl = false;
            } else if (try_ instanceof Failure) {
                Throwable $anonfun$waitForAllToComplete$1_e = ((Failure)try_).exception();
                callback.apply((Object)$anonfun$waitForAllToComplete$1_e);
                bl = true;
            } else {
                throw new MatchError((Object)try_);
            }
            return BoxesRunTime.boxToBoolean((boolean)bl);
        }) == 0;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LogStartOffsetCheckpointFile() {
        return this.LogStartOffsetCheckpointFile;
    }

    public int ProducerIdExpirationCheckIntervalMs() {
        return this.ProducerIdExpirationCheckIntervalMs;
    }

    public Set<String> ReconfigurableConfigs() {
        return this.ReconfigurableConfigs;
    }

    public LogManager apply(KafkaConfig config, Seq<String> initialOfflineDirs, ConfigRepository configRepository, KafkaScheduler kafkaScheduler, Time time, BrokerTopicStats brokerTopicStats, Metrics metrics, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean keepPartitionMetadataFile) {
        Map<String, Object> defaultProps = LogConfig$.MODULE$.extractLogConfigMap(config);
        KafkaServer$.MODULE$.augmentWithKafkaConfig(defaultProps, config);
        LogConfig$.MODULE$.validateValues(defaultProps);
        LogConfig defaultLogConfig = new LogConfig(defaultProps, LogConfig$.MODULE$.apply$default$2());
        CleanerConfig cleanerConfig = LogCleaner$.MODULE$.cleanerConfig(config);
        return new LogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$27 -> new File((String)x$27).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom())), (Seq<File>)((Seq)initialOfflineDirs.map((Function1 & Serializable & scala.Serializable)x$28 -> new File((String)x$28).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom())), configRepository, defaultLogConfig, cleanerConfig, Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir()), Predef$.MODULE$.Long2long(config.logFlushSchedulerIntervalMs()), config.logFlushOffsetCheckpointIntervalMs(), config.logFlushStartOffsetCheckpointIntervalMs(), Predef$.MODULE$.Integer2int(config.tierPartitionStateCommitIntervalMs()), Predef$.MODULE$.Long2long(config.logCleanupIntervalMs()), Predef$.MODULE$.Integer2int(config.logDeletionMaxSegmentsPerRun()), Predef$.MODULE$.Integer2int(config.transactionalIdExpirationMs()), kafkaScheduler, brokerTopicStats, metrics, logDirFailureChannel, tierLogComponents, time, keepPartitionMetadataFile);
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllToComplete$1(Function1 callback$1, Future future) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> future.get());
        if (try_ instanceof Success) {
            bl = false;
        } else if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            callback$1.apply((Object)e);
            bl = true;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    private LogManager$() {
        MODULE$ = this;
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LogStartOffsetCheckpointFile = "log-start-offset-checkpoint";
        this.ProducerIdExpirationCheckIntervalMs = 600000;
        this.ReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()}));
    }
}

