/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersionValidator$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.common.TopicPlacement;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.message.BrokerCompressionCodec$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Implicits$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfluentTopicConfig;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LogConfig$
implements scala.Serializable {
    public static LogConfig$ MODULE$;
    private final String SegmentBytesProp;
    private final String SegmentMsProp;
    private final String SegmentJitterMsProp;
    private final String SegmentIndexBytesProp;
    private final String FlushMessagesProp;
    private final String FlushMsProp;
    private final String RetentionBytesProp;
    private final String RetentionMsProp;
    private final String MaxMessageBytesProp;
    private final String IndexIntervalBytesProp;
    private final String DeleteRetentionMsProp;
    private final String MinCompactionLagMsProp;
    private final String MaxCompactionLagMsProp;
    private final String FileDeleteDelayMsProp;
    private final String MinCleanableDirtyRatioProp;
    private final String CleanupPolicyProp;
    private final String Delete;
    private final String Compact;
    private final String UncleanLeaderElectionEnableProp;
    private final String MinInSyncReplicasProp;
    private final String CompressionTypeProp;
    private final String PreAllocateEnableProp;
    private final String MessageFormatVersionProp;
    private final String MessageTimestampTypeProp;
    private final String MessageTimestampDifferenceMaxMsProp;
    private final String MessageDownConversionEnableProp;
    private final String TierEnableProp;
    private final String TierLocalHotsetBytesProp;
    private final String TierLocalHotsetMsProp;
    private final String TierSegmentHotsetRollMinBytesProp;
    private final String PreferTierFetchMsProp;
    private final String AppendRecordInterceptorClassesProp;
    private final String KeySchemaValidationEnableProp;
    private final String ValueSchemaValidationEnableProp;
    private final String KeySchemaValidationStrategyProp;
    private final String ValueSchemaValidationStrategyProp;
    private final String TopicPlacementConstraintsProp;
    private final String SegmentSpeculativePrefetchEnableProp;
    private final String SegmentSizeDoc;
    private final String SegmentMsDoc;
    private final String SegmentJitterMsDoc;
    private final String MaxIndexSizeDoc;
    private final String FlushIntervalDoc;
    private final String FlushMsDoc;
    private final String RetentionSizeDoc;
    private final String RetentionMsDoc;
    private final String MaxMessageSizeDoc;
    private final String IndexIntervalDoc;
    private final String FileDeleteDelayMsDoc;
    private final String DeleteRetentionMsDoc;
    private final String MinCompactionLagMsDoc;
    private final String MaxCompactionLagMsDoc;
    private final String MinCleanableRatioDoc;
    private final String CompactDoc;
    private final String UncleanLeaderElectionEnableDoc;
    private final String MinInSyncReplicasDoc;
    private final String CompressionTypeDoc;
    private final String PreAllocateEnableDoc;
    private final String MessageFormatVersionDoc;
    private final String MessageTimestampTypeDoc;
    private final String MessageTimestampDifferenceMaxMsDoc;
    private final String MessageDownConversionEnableDoc;
    private final String TierEnableDoc;
    private final String TierLocalHotsetBytesDoc;
    private final String TierLocalHotsetMsDoc;
    private final String TierSegmentHotsetRollMinBytesDoc;
    private final String PreferTierFetchMsDoc;
    private final String AppendRecordInterceptorClassesDoc;
    private final String TopicPlacementConstraintsDoc;
    private final String SegmentSpeculativePrefetchEnableDoc;
    private final String LeaderReplicationThrottledReplicasDoc;
    private final String FollowerReplicationThrottledReplicasDoc;
    private final String ServerDefaultHeaderName;
    private final LogConfig.LogConfigDef kafka$log$LogConfig$$configDef;
    private final Map<String, String> TopicConfigSynonyms;

    static {
        new LogConfig$();
    }

    public Set<String> $lessinit$greater$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public void main(String[] args) {
        Predef$.MODULE$.println((Object)this.kafka$log$LogConfig$$configDef().toHtml(4, config -> new StringBuilder(13).append("topicconfigs_").append((String)config).toString()));
    }

    public String SegmentBytesProp() {
        return this.SegmentBytesProp;
    }

    public String SegmentMsProp() {
        return this.SegmentMsProp;
    }

    public String SegmentJitterMsProp() {
        return this.SegmentJitterMsProp;
    }

    public String SegmentIndexBytesProp() {
        return this.SegmentIndexBytesProp;
    }

    public String FlushMessagesProp() {
        return this.FlushMessagesProp;
    }

    public String FlushMsProp() {
        return this.FlushMsProp;
    }

    public String RetentionBytesProp() {
        return this.RetentionBytesProp;
    }

    public String RetentionMsProp() {
        return this.RetentionMsProp;
    }

    public String MaxMessageBytesProp() {
        return this.MaxMessageBytesProp;
    }

    public String IndexIntervalBytesProp() {
        return this.IndexIntervalBytesProp;
    }

    public String DeleteRetentionMsProp() {
        return this.DeleteRetentionMsProp;
    }

    public String MinCompactionLagMsProp() {
        return this.MinCompactionLagMsProp;
    }

    public String MaxCompactionLagMsProp() {
        return this.MaxCompactionLagMsProp;
    }

    public String FileDeleteDelayMsProp() {
        return this.FileDeleteDelayMsProp;
    }

    public String MinCleanableDirtyRatioProp() {
        return this.MinCleanableDirtyRatioProp;
    }

    public String CleanupPolicyProp() {
        return this.CleanupPolicyProp;
    }

    public String Delete() {
        return this.Delete;
    }

    public String Compact() {
        return this.Compact;
    }

    public String UncleanLeaderElectionEnableProp() {
        return this.UncleanLeaderElectionEnableProp;
    }

    public String MinInSyncReplicasProp() {
        return this.MinInSyncReplicasProp;
    }

    public String CompressionTypeProp() {
        return this.CompressionTypeProp;
    }

    public String PreAllocateEnableProp() {
        return this.PreAllocateEnableProp;
    }

    public String MessageFormatVersionProp() {
        return this.MessageFormatVersionProp;
    }

    public String MessageTimestampTypeProp() {
        return this.MessageTimestampTypeProp;
    }

    public String MessageTimestampDifferenceMaxMsProp() {
        return this.MessageTimestampDifferenceMaxMsProp;
    }

    public String MessageDownConversionEnableProp() {
        return this.MessageDownConversionEnableProp;
    }

    public String TierEnableProp() {
        return this.TierEnableProp;
    }

    public String TierLocalHotsetBytesProp() {
        return this.TierLocalHotsetBytesProp;
    }

    public String TierLocalHotsetMsProp() {
        return this.TierLocalHotsetMsProp;
    }

    public String TierSegmentHotsetRollMinBytesProp() {
        return this.TierSegmentHotsetRollMinBytesProp;
    }

    public String PreferTierFetchMsProp() {
        return this.PreferTierFetchMsProp;
    }

    public String AppendRecordInterceptorClassesProp() {
        return this.AppendRecordInterceptorClassesProp;
    }

    public String KeySchemaValidationEnableProp() {
        return this.KeySchemaValidationEnableProp;
    }

    public String ValueSchemaValidationEnableProp() {
        return this.ValueSchemaValidationEnableProp;
    }

    public String KeySchemaValidationStrategyProp() {
        return this.KeySchemaValidationStrategyProp;
    }

    public String ValueSchemaValidationStrategyProp() {
        return this.ValueSchemaValidationStrategyProp;
    }

    public String TopicPlacementConstraintsProp() {
        return this.TopicPlacementConstraintsProp;
    }

    public String SegmentSpeculativePrefetchEnableProp() {
        return this.SegmentSpeculativePrefetchEnableProp;
    }

    public String SegmentSizeDoc() {
        return this.SegmentSizeDoc;
    }

    public String SegmentMsDoc() {
        return this.SegmentMsDoc;
    }

    public String SegmentJitterMsDoc() {
        return this.SegmentJitterMsDoc;
    }

    public String MaxIndexSizeDoc() {
        return this.MaxIndexSizeDoc;
    }

    public String FlushIntervalDoc() {
        return this.FlushIntervalDoc;
    }

    public String FlushMsDoc() {
        return this.FlushMsDoc;
    }

    public String RetentionSizeDoc() {
        return this.RetentionSizeDoc;
    }

    public String RetentionMsDoc() {
        return this.RetentionMsDoc;
    }

    public String MaxMessageSizeDoc() {
        return this.MaxMessageSizeDoc;
    }

    public String IndexIntervalDoc() {
        return this.IndexIntervalDoc;
    }

    public String FileDeleteDelayMsDoc() {
        return this.FileDeleteDelayMsDoc;
    }

    public String DeleteRetentionMsDoc() {
        return this.DeleteRetentionMsDoc;
    }

    public String MinCompactionLagMsDoc() {
        return this.MinCompactionLagMsDoc;
    }

    public String MaxCompactionLagMsDoc() {
        return this.MaxCompactionLagMsDoc;
    }

    public String MinCleanableRatioDoc() {
        return this.MinCleanableRatioDoc;
    }

    public String CompactDoc() {
        return this.CompactDoc;
    }

    public String UncleanLeaderElectionEnableDoc() {
        return this.UncleanLeaderElectionEnableDoc;
    }

    public String MinInSyncReplicasDoc() {
        return this.MinInSyncReplicasDoc;
    }

    public String CompressionTypeDoc() {
        return this.CompressionTypeDoc;
    }

    public String PreAllocateEnableDoc() {
        return this.PreAllocateEnableDoc;
    }

    public String MessageFormatVersionDoc() {
        return this.MessageFormatVersionDoc;
    }

    public String MessageTimestampTypeDoc() {
        return this.MessageTimestampTypeDoc;
    }

    public String MessageTimestampDifferenceMaxMsDoc() {
        return this.MessageTimestampDifferenceMaxMsDoc;
    }

    public String MessageDownConversionEnableDoc() {
        return this.MessageDownConversionEnableDoc;
    }

    public String TierEnableDoc() {
        return this.TierEnableDoc;
    }

    public String TierLocalHotsetBytesDoc() {
        return this.TierLocalHotsetBytesDoc;
    }

    public String TierLocalHotsetMsDoc() {
        return this.TierLocalHotsetMsDoc;
    }

    public String TierSegmentHotsetRollMinBytesDoc() {
        return this.TierSegmentHotsetRollMinBytesDoc;
    }

    public String PreferTierFetchMsDoc() {
        return this.PreferTierFetchMsDoc;
    }

    public String AppendRecordInterceptorClassesDoc() {
        return this.AppendRecordInterceptorClassesDoc;
    }

    public String TopicPlacementConstraintsDoc() {
        return this.TopicPlacementConstraintsDoc;
    }

    public String SegmentSpeculativePrefetchEnableDoc() {
        return this.SegmentSpeculativePrefetchEnableDoc;
    }

    public String LeaderReplicationThrottledReplicasDoc() {
        return this.LeaderReplicationThrottledReplicasDoc;
    }

    public String FollowerReplicationThrottledReplicasDoc() {
        return this.FollowerReplicationThrottledReplicasDoc;
    }

    public String ServerDefaultHeaderName() {
        return this.ServerDefaultHeaderName;
    }

    public LogConfig.LogConfigDef configDefCopy() {
        return new LogConfig.LogConfigDef(this.kafka$log$LogConfig$$configDef());
    }

    public LogConfig.LogConfigDef kafka$log$LogConfig$$configDef() {
        return this.kafka$log$LogConfig$$configDef;
    }

    public LogConfig apply() {
        return new LogConfig(new Properties(), this.apply$default$2());
    }

    public Set<String> apply$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public Seq<String> configNames() {
        return (Seq)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.kafka$log$LogConfig$$configDef().names()).asScala()).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Option<String> serverConfigName(String configName) {
        return this.kafka$log$LogConfig$$configDef().serverConfigName(configName);
    }

    public Option<ConfigDef.Type> configType(String configName) {
        return Option$.MODULE$.apply(this.kafka$log$LogConfig$$configDef().configKeys().get(configName)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.type);
    }

    public LogConfig fromProps(java.util.Map<?, ?> defaults, Properties overrides) {
        Properties props = new Properties();
        defaults.forEach((k, v) -> props.put(k, v));
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(overrides);
        Set overriddenKeys = ((TraversableOnce)((scala.collection.SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(overrides.keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7, Set$.MODULE$.canBuildFrom())).toSet();
        return new LogConfig(props, (Set<String>)overriddenKeys);
    }

    public void validateNames(Properties props) {
        Seq<String> names = this.configNames();
        ((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)name -> {
            LogConfig$.$anonfun$validateNames$1(names, name);
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, ConfigDef.ConfigKey> configKeys() {
        return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.kafka$log$LogConfig$$configDef().configKeys()).asScala();
    }

    public void validateValues(java.util.Map<?, ?> props) {
        long maxCompactionLag;
        long minCompactionLag = BoxesRunTime.unboxToLong(props.get(this.MinCompactionLagMsProp()));
        if (minCompactionLag > (maxCompactionLag = BoxesRunTime.unboxToLong(props.get(this.MaxCompactionLagMsProp())))) {
            throw new InvalidConfigurationException(new StringBuilder(39).append("conflict topic config setting ").append(this.MinCompactionLagMsProp()).append(" ").append("(").append(minCompactionLag).append(") > ").append(this.MaxCompactionLagMsProp()).append(" (").append(maxCompactionLag).append(")").toString());
        }
    }

    public void validate(Properties props) {
        this.validateNames(props);
        java.util.Map valueMaps = this.kafka$log$LogConfig$$configDef().parse(props);
        this.validateValues(valueMaps);
    }

    public void validateChange(LogConfig current, LogConfig proposed, ApiVersion interBrokerProtocolVersion, boolean tierFeatureEnabled) {
        if (tierFeatureEnabled && !current.compact() && proposed.compact()) {
            throw new InvalidConfigurationException(new StringBuilder(140).append("Altering topic configuration from `").append("delete").append("` ").append("to `").append("compact").append("` is not supported. Please create a new topic with ").append("`").append("compact").append("` policy specified instead.").toString());
        }
        if (interBrokerProtocolVersion.$less(KAFKA_2_4_IV1$.MODULE$) && proposed.topicPlacementConstraints().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.hasObserverConstraints()))) {
            throw new InvalidConfigurationException(new StringBuilder(106).append("Observer constraints are not allowed with current ").append("`inter.broker.protocol.version=").append(interBrokerProtocolVersion).append("` (must be 2.4 or higher)").toString());
        }
    }

    public Map<String, String> TopicConfigSynonyms() {
        return this.TopicConfigSynonyms;
    }

    private void extractPasswordConfig(KafkaConfig kafkaConfig, String config, HashMap<String, Object> logProps) {
        Option password = Option$.MODULE$.apply((Object)kafkaConfig.getPassword(config));
        if (password instanceof Some) {
            Password x = (Password)((Some)password).value();
            logProps.computeIfAbsent(config, x$9 -> x.value());
            return;
        }
        if (None$.MODULE$.equals(password)) {
            logProps.computeIfAbsent(config, x$10 -> null);
            return;
        }
        throw new MatchError((Object)password);
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> extractLogConfigMap(KafkaConfig kafkaConfig) {
        void var2_2;
        HashMap<String, Object> logProps = new HashMap<String, Object>();
        logProps.put(this.SegmentBytesProp(), kafkaConfig.logSegmentBytes());
        logProps.put(this.SegmentMsProp(), kafkaConfig.logRollTimeMillis());
        logProps.put(this.SegmentJitterMsProp(), kafkaConfig.logRollTimeJitterMillis());
        logProps.put(this.SegmentIndexBytesProp(), kafkaConfig.logIndexSizeMaxBytes());
        logProps.put(this.FlushMessagesProp(), kafkaConfig.logFlushIntervalMessages());
        logProps.put(this.FlushMsProp(), kafkaConfig.logFlushIntervalMs());
        logProps.put(this.RetentionBytesProp(), kafkaConfig.logRetentionBytes());
        logProps.put(this.RetentionMsProp(), Predef$.MODULE$.long2Long(kafkaConfig.logRetentionTimeMillis()));
        logProps.put(this.MaxMessageBytesProp(), kafkaConfig.messageMaxBytes());
        logProps.put(this.IndexIntervalBytesProp(), kafkaConfig.logIndexIntervalBytes());
        logProps.put(this.DeleteRetentionMsProp(), kafkaConfig.logCleanerDeleteRetentionMs());
        logProps.put(this.MinCompactionLagMsProp(), kafkaConfig.logCleanerMinCompactionLagMs());
        logProps.put(this.MaxCompactionLagMsProp(), kafkaConfig.logCleanerMaxCompactionLagMs());
        logProps.put(this.FileDeleteDelayMsProp(), kafkaConfig.logDeleteDelayMs());
        logProps.put(this.MinCleanableDirtyRatioProp(), kafkaConfig.logCleanerMinCleanRatio());
        logProps.put(this.CleanupPolicyProp(), kafkaConfig.logCleanupPolicy());
        logProps.put(this.MinInSyncReplicasProp(), kafkaConfig.minInSyncReplicas());
        logProps.put(this.CompressionTypeProp(), kafkaConfig.compressionType());
        logProps.put(this.UncleanLeaderElectionEnableProp(), kafkaConfig.uncleanLeaderElectionEnable());
        logProps.put(this.PreAllocateEnableProp(), kafkaConfig.logPreAllocateEnable());
        logProps.put(this.MessageFormatVersionProp(), kafkaConfig.logMessageFormatVersion().version());
        logProps.put(this.MessageTimestampTypeProp(), kafkaConfig.logMessageTimestampType().name);
        logProps.put(this.MessageTimestampDifferenceMaxMsProp(), Predef$.MODULE$.long2Long(kafkaConfig.logMessageTimestampDifferenceMaxMs()));
        logProps.put(this.MessageDownConversionEnableProp(), Predef$.MODULE$.boolean2Boolean(kafkaConfig.logMessageDownConversionEnable()));
        logProps.put(this.TierEnableProp(), kafkaConfig.tierEnable());
        logProps.put(this.TierLocalHotsetBytesProp(), kafkaConfig.tierLocalHotsetBytes());
        logProps.put(this.TierLocalHotsetMsProp(), kafkaConfig.tierLocalHotsetMs());
        logProps.put(this.TierSegmentHotsetRollMinBytesProp(), kafkaConfig.tierSegmentHotsetRollMinBytes());
        logProps.put(this.PreferTierFetchMsProp(), kafkaConfig.preferTierFetchMs());
        logProps.put(this.SegmentSpeculativePrefetchEnableProp(), kafkaConfig.segmentSpeculativePrefetchEnable());
        logProps.put(this.AppendRecordInterceptorClassesProp(), kafkaConfig.getList(KafkaConfig$.MODULE$.AppendRecordInterceptorClassesProp()));
        logProps.computeIfAbsent("confluent.schema.registry.url", x$11 -> kafkaConfig.getString("confluent.schema.registry.url"));
        logProps.computeIfAbsent("confluent.schema.validator.interceptor.class", x$12 -> kafkaConfig.getString("confluent.schema.validator.interceptor.class"));
        logProps.computeIfAbsent("confluent.schema.validator.multitenant.enable", x$13 -> kafkaConfig.getBoolean("confluent.schema.validator.multitenant.enable"));
        logProps.computeIfAbsent("confluent.basic.auth.credentials.source", x$14 -> kafkaConfig.getString("confluent.basic.auth.credentials.source"));
        this.extractPasswordConfig(kafkaConfig, "confluent.basic.auth.user.info", logProps);
        logProps.computeIfAbsent("confluent.bearer.auth.credentials.source", x$15 -> kafkaConfig.getString("confluent.bearer.auth.credentials.source"));
        this.extractPasswordConfig(kafkaConfig, "confluent.bearer.auth.token", logProps);
        logProps.computeIfAbsent("confluent.ssl.protocol", x$16 -> kafkaConfig.getString("confluent.ssl.protocol"));
        logProps.computeIfAbsent("confluent.ssl.keystore.type", x$17 -> kafkaConfig.getString("confluent.ssl.keystore.type"));
        logProps.computeIfAbsent("confluent.ssl.keystore.location", x$18 -> kafkaConfig.getString("confluent.ssl.keystore.location"));
        this.extractPasswordConfig(kafkaConfig, "confluent.ssl.keystore.password", logProps);
        this.extractPasswordConfig(kafkaConfig, "confluent.ssl.key.password", logProps);
        logProps.computeIfAbsent("confluent.ssl.truststore.type", x$19 -> kafkaConfig.getString("confluent.ssl.truststore.type"));
        logProps.computeIfAbsent("confluent.ssl.truststore.location", x$20 -> kafkaConfig.getString("confluent.ssl.truststore.location"));
        this.extractPasswordConfig(kafkaConfig, "confluent.ssl.truststore.password", logProps);
        return var2_2;
    }

    public LogConfig apply(java.util.Map<?, ?> topicAndBrokerDefaultProps, Set<String> overriddenConfigs) {
        return new LogConfig(topicAndBrokerDefaultProps, overriddenConfigs);
    }

    public Option<Tuple2<java.util.Map<?, ?>, Set<String>>> unapply(LogConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.topicAndBrokerDefaultProps(), x$0.overriddenConfigs()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$validateNames$1(Seq names$1, String name) {
        if (!names$1.contains((Object)name)) {
            throw new InvalidConfigurationException(new StringBuilder(27).append("Unknown topic config name: ").append(name).toString());
        }
    }

    private LogConfig$() {
        MODULE$ = this;
        this.SegmentBytesProp = "segment.bytes";
        this.SegmentMsProp = "segment.ms";
        this.SegmentJitterMsProp = "segment.jitter.ms";
        this.SegmentIndexBytesProp = "segment.index.bytes";
        this.FlushMessagesProp = "flush.messages";
        this.FlushMsProp = "flush.ms";
        this.RetentionBytesProp = "retention.bytes";
        this.RetentionMsProp = "retention.ms";
        this.MaxMessageBytesProp = "max.message.bytes";
        this.IndexIntervalBytesProp = "index.interval.bytes";
        this.DeleteRetentionMsProp = "delete.retention.ms";
        this.MinCompactionLagMsProp = "min.compaction.lag.ms";
        this.MaxCompactionLagMsProp = "max.compaction.lag.ms";
        this.FileDeleteDelayMsProp = "file.delete.delay.ms";
        this.MinCleanableDirtyRatioProp = "min.cleanable.dirty.ratio";
        this.CleanupPolicyProp = "cleanup.policy";
        this.Delete = "delete";
        this.Compact = "compact";
        this.UncleanLeaderElectionEnableProp = "unclean.leader.election.enable";
        this.MinInSyncReplicasProp = "min.insync.replicas";
        this.CompressionTypeProp = "compression.type";
        this.PreAllocateEnableProp = "preallocate";
        this.MessageFormatVersionProp = "message.format.version";
        this.MessageTimestampTypeProp = "message.timestamp.type";
        this.MessageTimestampDifferenceMaxMsProp = "message.timestamp.difference.max.ms";
        this.MessageDownConversionEnableProp = "message.downconversion.enable";
        this.TierEnableProp = "confluent.tier.enable";
        this.TierLocalHotsetBytesProp = "confluent.tier.local.hotset.bytes";
        this.TierLocalHotsetMsProp = "confluent.tier.local.hotset.ms";
        this.TierSegmentHotsetRollMinBytesProp = "confluent.tier.segment.hotset.roll.min.bytes";
        this.PreferTierFetchMsProp = "confluent.prefer.tier.fetch.ms";
        this.AppendRecordInterceptorClassesProp = "confluent.append.record.interceptor.classes";
        this.KeySchemaValidationEnableProp = "confluent.key.schema.validation";
        this.ValueSchemaValidationEnableProp = "confluent.value.schema.validation";
        this.KeySchemaValidationStrategyProp = "confluent.key.subject.name.strategy";
        this.ValueSchemaValidationStrategyProp = "confluent.value.subject.name.strategy";
        this.TopicPlacementConstraintsProp = "confluent.placement.constraints";
        this.SegmentSpeculativePrefetchEnableProp = "confluent.segment.speculative.prefetch.enable";
        this.SegmentSizeDoc = "This configuration controls the segment file size for the log. Retention and cleaning is always done a file at a time so a larger segment size means fewer files but less granular control over retention.";
        this.SegmentMsDoc = "This configuration controls the period of time after which Kafka will force the log to roll even if the segment file isn't full to ensure that retention can delete or compact old data.";
        this.SegmentJitterMsDoc = "The maximum random jitter subtracted from the scheduled segment roll time to avoid thundering herds of segment rolling";
        this.MaxIndexSizeDoc = "This configuration controls the size of the index that maps offsets to file positions. We preallocate this index file and shrink it only after log rolls. You generally should not need to change this setting.";
        this.FlushIntervalDoc = "This setting allows specifying an interval at which we will force an fsync of data written to the log. For example if this was set to 1 we would fsync after every message; if it were 5 we would fsync after every five messages. In general we recommend you not set this and use replication for durability and allow the operating system's background flush capabilities as it is more efficient. This setting can be overridden on a per-topic basis (see <a href=\"#topicconfigs\">the per-topic configuration section</a>).";
        this.FlushMsDoc = "This setting allows specifying a time interval at which we will force an fsync of data written to the log. For example if this was set to 1000 we would fsync after 1000 ms had passed. In general we recommend you not set this and use replication for durability and allow the operating system's background flush capabilities as it is more efficient.";
        this.RetentionSizeDoc = "This configuration controls the maximum size a partition (which consists of log segments) can grow to before we will discard old log segments to free up space if we are using the \"delete\" retention policy. By default there is no size limit only a time limit. Since this limit is enforced at the partition level, multiply it by the number of partitions to compute the topic retention in bytes.";
        this.RetentionMsDoc = "This configuration controls the maximum time we will retain a log before we will discard old log segments to free up space if we are using the \"delete\" retention policy. This represents an SLA on how soon consumers must read their data. If set to -1, no time limit is applied.";
        this.MaxMessageSizeDoc = "The largest record batch size allowed by Kafka (after compression if compression is enabled). If this is increased and there are consumers older than 0.10.2, the consumers' fetch size must also be increased so that they can fetch record batches this large. In the latest message format version, records are always grouped into batches for efficiency. In previous message format versions, uncompressed records are not grouped into batches and this limit only applies to a single record in that case.";
        this.IndexIntervalDoc = "This setting controls how frequently Kafka adds an index entry to its offset index. The default setting ensures that we index a message roughly every 4096 bytes. More indexing allows reads to jump closer to the exact position in the log but makes the index larger. You probably don't need to change this.";
        this.FileDeleteDelayMsDoc = "The time to wait before deleting a file from the filesystem";
        this.DeleteRetentionMsDoc = "The amount of time to retain delete tombstone markers for <a href=\"#compaction\">log compacted</a> topics. This setting also gives a bound on the time in which a consumer must complete a read if they begin from offset 0 to ensure that they get a valid snapshot of the final stage (otherwise delete tombstones may be collected before they complete their scan).";
        this.MinCompactionLagMsDoc = "The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.";
        this.MaxCompactionLagMsDoc = "The maximum time a message will remain ineligible for compaction in the log. Only applicable for logs that are being compacted.";
        this.MinCleanableRatioDoc = "This configuration controls how frequently the log compactor will attempt to clean the log (assuming <a href=\"#compaction\">log compaction</a> is enabled). By default we will avoid cleaning a log where more than 50% of the log has been compacted. This ratio bounds the maximum space wasted in the log by duplicates (at 50% at most 50% of the log could be duplicates). A higher ratio will mean fewer, more efficient cleanings but will mean more wasted space in the log. If the max.compaction.lag.ms or the min.compaction.lag.ms configurations are also specified, then the log compactor considers the log to be eligible for compaction as soon as either: (i) the dirty ratio threshold has been met and the log has had dirty (uncompacted) records for at least the min.compaction.lag.ms duration, or (ii) if the log has had dirty (uncompacted) records for at most the max.compaction.lag.ms period.";
        this.CompactDoc = "A string that is either \"delete\" or \"compact\" or both. This string designates the retention policy to use on old log segments. The default policy (\"delete\") will discard old segments when their retention time or size limit has been reached. The \"compact\" setting will enable <a href=\"#compaction\">log compaction</a> on the topic.";
        this.UncleanLeaderElectionEnableDoc = "Indicates whether to enable replicas not in the ISR set to be elected as leader as a last resort, even though doing so may result in data loss.";
        this.MinInSyncReplicasDoc = "When a producer sets acks to \"all\" (or \"-1\"), this configuration specifies the minimum number of replicas that must acknowledge a write for the write to be considered successful. If this minimum cannot be met, then the producer will raise an exception (either NotEnoughReplicas or NotEnoughReplicasAfterAppend).<br>When used together, <code>min.insync.replicas</code> and <code>acks</code> allow you to enforce greater durability guarantees. A typical scenario would be to create a topic with a replication factor of 3, set <code>min.insync.replicas</code> to 2, and produce with <code>acks</code> of \"all\". This will ensure that the producer raises an exception if a majority of replicas do not receive a write.";
        this.CompressionTypeDoc = "Specify the final compression type for a given topic. This configuration accepts the standard compression codecs ('gzip', 'snappy', 'lz4', 'zstd'). It additionally accepts 'uncompressed' which is equivalent to no compression; and 'producer' which means retain the original compression codec set by the producer.";
        this.PreAllocateEnableDoc = "True if we should preallocate the file on disk when creating a new log segment.";
        this.MessageFormatVersionDoc = "Specify the message format version the broker will use to append messages to the logs. The value should be a valid ApiVersion. Some examples are: 0.8.2, 0.9.0.0, 0.10.0, check ApiVersion for more details. By setting a particular message format version, the user is certifying that all the existing messages on disk are smaller or equal than the specified version. Setting this value incorrectly will cause consumers with older versions to break as they will receive messages with a format that they don't understand.";
        this.MessageTimestampTypeDoc = "Define whether the timestamp in the message is message create time or log append time. The value should be either `CreateTime` or `LogAppendTime`";
        this.MessageTimestampDifferenceMaxMsDoc = "The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message. If message.timestamp.type=CreateTime, a message will be rejected if the difference in timestamp exceeds this threshold. This configuration is ignored if message.timestamp.type=LogAppendTime.";
        this.MessageDownConversionEnableDoc = "This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests. When set to <code>false</code>, broker will not perform down-conversion for consumers expecting an older message format. The broker responds with <code>UNSUPPORTED_VERSION</code> error for consume requests from such older clients. This configurationdoes not apply to any message format conversion that might be required for replication to followers.";
        this.TierEnableDoc = "Allow tiering for topic(s). This enables tiering and fetching of data to and from the configured remote storage.";
        this.TierLocalHotsetBytesDoc = "When tiering is enabled, this configuration controls the maximum size a partition (which consists of log segments) can grow to on broker-local storage before we will discard old log segments to free up space. Log segments retained on broker-local storage is referred as the \"hotset\". Segments discarded from local store could continue to exist in tiered storage and remain available for fetches depending on retention configurations. By default there is no size limit only a time limit. Since this limit is enforced at the partition level, multiply it by the number of partitions to compute the topic hotset in bytes.";
        this.TierLocalHotsetMsDoc = "When tiering is enabled, this configuration controls the maximum time we will retain a log segment on broker-local storage before we will discard it to free up space. Segments discarded from local store could continue to exist in tiered storage and remain available for fetches depending on retention configurations. If set to -1, no time limit is applied.";
        this.TierSegmentHotsetRollMinBytesDoc = "When tiering is enabled, this configuration allows a segment roll to be forced if the active segment is larger than the configured bytes and if all records in the segment are ready for eviction from the hotset. Rolling the segment ensures that it can be tiered and the segment can then be deleted from the hotset. A minimum size is enforced to ensure efficient tiering and consumption.";
        this.PreferTierFetchMsDoc = "For a topic with tiering enabled, this configuration sets preference for data to be fetched from tiered storage, even if it is available on broker-local storage through the configured hotset retention. Data will be preferentially fetched from tiered storage if present when the configured amount of time has elapsed since data was appended to the log.";
        this.AppendRecordInterceptorClassesDoc = "A list of classes to use as interceptors. Implementing the <code>RecordInterceptor</code> interface allows you to intercept and possibly reject the records before they are appended from the produce request to the log at the Kafka broker. By default, there are no interceptors.";
        this.TopicPlacementConstraintsDoc = ConfluentTopicConfig.TOPIC_PLACEMENT_CONSTRAINTS_DOC;
        this.SegmentSpeculativePrefetchEnableDoc = "If <code>true</code>, reads to log segments may be prefetched from disk if they're predicted to not be resident in memory. This can reduce latency and mitigate pipeline stalls when fetching from older log segments, at the expense of potentially increased memory usage, which may have adverse affects on other cached data. If <code>false</code>, no explicit prefetching is performed.";
        this.LeaderReplicationThrottledReplicasDoc = "A list of replicas for which log replication should be throttled on the leader side. The list should describe a set of replicas in the form [PartitionId]:[BrokerId],[PartitionId]:[BrokerId]:... or alternatively the wildcard '*' can be used to throttle all replicas for this topic.";
        this.FollowerReplicationThrottledReplicasDoc = "A list of replicas for which log replication should be throttled on the follower side. The list should describe a set of replicas in the form [PartitionId]:[BrokerId],[PartitionId]:[BrokerId]:... or alternatively the wildcard '*' can be used to throttle all replicas for this topic.";
        this.ServerDefaultHeaderName = "Server Default Property";
        this.kafka$log$LogConfig$$configDef = new LogConfig.LogConfigDef().define(this.SegmentBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.SegmentSize()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(14)), ConfigDef.Importance.MEDIUM, this.SegmentSizeDoc(), KafkaConfig$.MODULE$.LogSegmentBytesProp()).define(this.SegmentMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.SegmentMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.MEDIUM, this.SegmentMsDoc(), KafkaConfig$.MODULE$.LogRollTimeMillisProp()).define(this.SegmentJitterMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.SegmentJitterMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.SegmentJitterMsDoc(), KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp()).define(this.SegmentIndexBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MaxIndexSize()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MaxIndexSizeDoc(), KafkaConfig$.MODULE$.LogIndexSizeMaxBytesProp()).define(this.FlushMessagesProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.FlushInterval()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FlushIntervalDoc(), KafkaConfig$.MODULE$.LogFlushIntervalMessagesProp()).define(this.FlushMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.FlushMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FlushMsDoc(), KafkaConfig$.MODULE$.LogFlushIntervalMsProp()).define(this.RetentionBytesProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.RetentionSize()), ConfigDef.Importance.MEDIUM, this.RetentionSizeDoc(), KafkaConfig$.MODULE$.LogRetentionBytesProp()).define(this.RetentionMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.RetentionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(-1)), ConfigDef.Importance.MEDIUM, this.RetentionMsDoc(), KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()).define(this.MaxMessageBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MaxMessageSize()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MaxMessageSizeDoc(), KafkaConfig$.MODULE$.MessageMaxBytesProp()).define(this.IndexIntervalBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.IndexInterval()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.IndexIntervalDoc(), KafkaConfig$.MODULE$.LogIndexIntervalBytesProp()).define(this.DeleteRetentionMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.DeleteRetentionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.DeleteRetentionMsDoc(), KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp()).define(this.MinCompactionLagMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.MinCompactionLagMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MinCompactionLagMsDoc(), KafkaConfig$.MODULE$.LogCleanerMinCompactionLagMsProp()).define(this.MaxCompactionLagMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.MaxCompactionLagMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.MEDIUM, this.MaxCompactionLagMsDoc(), KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp()).define(this.FileDeleteDelayMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.FileDeleteDelayMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FileDeleteDelayMsDoc(), KafkaConfig$.MODULE$.LogDeleteDelayMsProp()).define(this.MinCleanableDirtyRatioProp(), ConfigDef.Type.DOUBLE, BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.MinCleanableDirtyRatio()), (ConfigDef.Validator)ConfigDef.Range.between((Number)Predef$.MODULE$.int2Integer(0), (Number)Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.MEDIUM, this.MinCleanableRatioDoc(), KafkaConfig$.MODULE$.LogCleanerMinCleanRatioProp()).define(this.CleanupPolicyProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.CleanupPolicy(), (ConfigDef.Validator)ConfigDef.ValidList.in((String[])new String[]{this.Compact(), this.Delete()}), ConfigDef.Importance.MEDIUM, this.CompactDoc(), KafkaConfig$.MODULE$.LogCleanupPolicyProp()).define(this.UncleanLeaderElectionEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)Defaults$.MODULE$.UncleanLeaderElectionEnable()), ConfigDef.Importance.MEDIUM, this.UncleanLeaderElectionEnableDoc(), KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()).define(this.MinInSyncReplicasProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.MEDIUM, this.MinInSyncReplicasDoc(), KafkaConfig$.MODULE$.MinInSyncReplicasProp()).define(this.CompressionTypeProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.CompressionType(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])BrokerCompressionCodec$.MODULE$.brokerCompressionOptions().toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.MEDIUM, this.CompressionTypeDoc(), KafkaConfig$.MODULE$.CompressionTypeProp()).define(this.PreAllocateEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)Defaults$.MODULE$.PreAllocateEnable()), ConfigDef.Importance.MEDIUM, this.PreAllocateEnableDoc(), KafkaConfig$.MODULE$.LogPreAllocateProp()).define(this.MessageFormatVersionProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.MessageFormatVersion(), ApiVersionValidator$.MODULE$, ConfigDef.Importance.MEDIUM, this.MessageFormatVersionDoc(), KafkaConfig$.MODULE$.LogMessageFormatVersionProp()).define(this.MessageTimestampTypeProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.MessageTimestampType(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"CreateTime", "LogAppendTime"}), ConfigDef.Importance.MEDIUM, this.MessageTimestampTypeDoc(), KafkaConfig$.MODULE$.LogMessageTimestampTypeProp()).define(this.MessageTimestampDifferenceMaxMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.MessageTimestampDifferenceMaxMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MessageTimestampDifferenceMaxMsDoc(), KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp()).define(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.LeaderReplicationThrottledReplicas(), ThrottledReplicaListValidator$.MODULE$, ConfigDef.Importance.MEDIUM, this.LeaderReplicationThrottledReplicasDoc(), KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()).define(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.FollowerReplicationThrottledReplicas(), ThrottledReplicaListValidator$.MODULE$, ConfigDef.Importance.MEDIUM, this.FollowerReplicationThrottledReplicasDoc(), KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()).define(this.MessageDownConversionEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)Defaults$.MODULE$.MessageDownConversionEnable()), ConfigDef.Importance.LOW, this.MessageDownConversionEnableDoc(), KafkaConfig$.MODULE$.LogMessageDownConversionEnableProp()).defineTopicOnly(this.TopicPlacementConstraintsProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.TopicPlacementConstraints(), TopicPlacement.VALIDATOR, ConfigDef.Importance.LOW, this.TopicPlacementConstraintsDoc()).defineTopicOnly(this.KeySchemaValidationEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)false), null, ConfigDef.Importance.MEDIUM, "True if schema validation at record key is enabled for this topic.").defineTopicOnly(this.ValueSchemaValidationEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)false), null, ConfigDef.Importance.MEDIUM, "True if schema validation at record value is enabled for this topic.").defineTopicOnly(this.KeySchemaValidationStrategyProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.TopicNameStrategy(), null, ConfigDef.Importance.MEDIUM, "Determines how to construct the subject name under which the key schema is registered with the schema registry. By default, TopicNameStrategy is used").defineTopicOnly(this.ValueSchemaValidationStrategyProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.TopicNameStrategy(), null, ConfigDef.Importance.MEDIUM, "Determines how to construct the subject name under which the value schema is registered with the schema registry. By default, TopicNameStrategy is used").define(this.TierEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)Defaults$.MODULE$.TierEnable()), ConfigDef.Importance.MEDIUM, this.TierEnableDoc(), KafkaConfig$.MODULE$.TierEnableProp()).define(this.TierLocalHotsetBytesProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.TierLocalHotsetBytes()), ConfigDef.Importance.MEDIUM, this.TierLocalHotsetBytesDoc(), KafkaConfig$.MODULE$.TierLocalHotsetBytesProp()).define(this.TierLocalHotsetMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.TierLocalHotsetMs()), ConfigDef.Importance.MEDIUM, this.TierLocalHotsetMsDoc(), KafkaConfig$.MODULE$.TierLocalHotsetMsProp()).defineInternal(this.TierSegmentHotsetRollMinBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.TierSegmentHotsetRollMinBytes()), ConfigDef.Importance.MEDIUM, this.TierSegmentHotsetRollMinBytesDoc(), KafkaConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp()).defineInternal(this.PreferTierFetchMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.PreferTierFetchMs()), ConfigDef.Importance.LOW, this.PreferTierFetchMsDoc(), KafkaConfig$.MODULE$.PreferTierFetchMsProp()).defineInternal(this.AppendRecordInterceptorClassesProp(), ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, this.AppendRecordInterceptorClassesDoc(), this.AppendRecordInterceptorClassesProp()).defineInternal(this.SegmentSpeculativePrefetchEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)Defaults$.MODULE$.SegmentSpeculativePrefetchEnable()), ConfigDef.Importance.LOW, this.SegmentSpeculativePrefetchEnableDoc(), KafkaConfig$.MODULE$.SegmentSpeculativePrefetchEnableProp());
        this.TopicConfigSynonyms = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SegmentBytesProp()), (Object)KafkaConfig$.MODULE$.LogSegmentBytesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SegmentMsProp()), (Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SegmentJitterMsProp()), (Object)KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SegmentIndexBytesProp()), (Object)KafkaConfig$.MODULE$.LogIndexSizeMaxBytesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FlushMessagesProp()), (Object)KafkaConfig$.MODULE$.LogFlushIntervalMessagesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FlushMsProp()), (Object)KafkaConfig$.MODULE$.LogFlushIntervalMsProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RetentionBytesProp()), (Object)KafkaConfig$.MODULE$.LogRetentionBytesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RetentionMsProp()), (Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MaxMessageBytesProp()), (Object)KafkaConfig$.MODULE$.MessageMaxBytesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IndexIntervalBytesProp()), (Object)KafkaConfig$.MODULE$.LogIndexIntervalBytesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DeleteRetentionMsProp()), (Object)KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MinCompactionLagMsProp()), (Object)KafkaConfig$.MODULE$.LogCleanerMinCompactionLagMsProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MaxCompactionLagMsProp()), (Object)KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FileDeleteDelayMsProp()), (Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MinCleanableDirtyRatioProp()), (Object)KafkaConfig$.MODULE$.LogCleanerMinCleanRatioProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CleanupPolicyProp()), (Object)KafkaConfig$.MODULE$.LogCleanupPolicyProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.UncleanLeaderElectionEnableProp()), (Object)KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MinInSyncReplicasProp()), (Object)KafkaConfig$.MODULE$.MinInSyncReplicasProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CompressionTypeProp()), (Object)KafkaConfig$.MODULE$.CompressionTypeProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PreAllocateEnableProp()), (Object)KafkaConfig$.MODULE$.LogPreAllocateProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MessageFormatVersionProp()), (Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MessageTimestampTypeProp()), (Object)KafkaConfig$.MODULE$.LogMessageTimestampTypeProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MessageTimestampDifferenceMaxMsProp()), (Object)KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MessageDownConversionEnableProp()), (Object)KafkaConfig$.MODULE$.LogMessageDownConversionEnableProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TierEnableProp()), (Object)KafkaConfig$.MODULE$.TierEnableProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TierLocalHotsetBytesProp()), (Object)KafkaConfig$.MODULE$.TierLocalHotsetBytesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TierLocalHotsetMsProp()), (Object)KafkaConfig$.MODULE$.TierLocalHotsetMsProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TierSegmentHotsetRollMinBytesProp()), (Object)KafkaConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PreferTierFetchMsProp()), (Object)KafkaConfig$.MODULE$.PreferTierFetchMsProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.AppendRecordInterceptorClassesProp()), (Object)KafkaConfig$.MODULE$.AppendRecordInterceptorClassesProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SegmentSpeculativePrefetchEnableProp()), (Object)KafkaConfig$.MODULE$.SegmentSpeculativePrefetchEnableProp())}));
    }
}

