/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.regex.Pattern;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class Log$ {
    public static Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String ProducerSnapshotFileSuffix;
    private final String TxnIndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String CleanShutdownFile;
    private final String DeleteDirSuffix;
    private final String FutureDirSuffix;
    private final String TierStateSuffix;
    private final Pattern DeleteDirPattern;
    private final Pattern FutureDirPattern;
    private final long UnknownOffset;

    static {
        new Log$();
    }

    public Function1<Object, BoxedUnit> $lessinit$greater$default$13() {
        return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$5 -> {};
    }

    public Function0<Object> $lessinit$greater$default$14() {
        return (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L;
    }

    public boolean $lessinit$greater$default$15() {
        return true;
    }

    public boolean $lessinit$greater$default$16() {
        return true;
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String ProducerSnapshotFileSuffix() {
        return this.ProducerSnapshotFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return this.TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return this.FutureDirSuffix;
    }

    public String TierStateSuffix() {
        return this.TierStateSuffix;
    }

    public Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return this.FutureDirPattern;
    }

    public long UnknownOffset() {
        return this.UnknownOffset;
    }

    public MergedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Metrics metrics, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, Option<TierLogComponents> tierLogComponentsOpt, boolean lastShutdownClean) {
        TierLogComponents tierLogComponents = (TierLogComponents)tierLogComponentsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> TierLogComponents$.MODULE$.EMPTY());
        return MergedLog$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, metrics, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, logDirFailureChannel, tierLogComponents, lastShutdownClean, MergedLog$.MODULE$.apply$default$14());
    }

    public Time apply$default$8() {
        return Time.SYSTEM;
    }

    public Option<TierLogComponents> apply$default$12() {
        return None$.MODULE$;
    }

    public boolean apply$default$13() {
        return true;
    }

    public Log local(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Metrics metrics, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, boolean keepPartitionMetadataFile) {
        TopicPartition topicPartition = this.parseTopicPartitionName(dir);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxProducerIdExpirationMs);
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$13 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset;
        Function1<Object, BoxedUnit> x$16 = this.$lessinit$greater$default$13();
        return new Log(dir, config, recoveryPoint, scheduler, brokerTopicStats, metrics, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, topicPartition, producerStateManager, logDirFailureChannel, x$16, (Function0<Object>)x$13, lastShutdownClean, keepPartitionMetadataFile);
    }

    public Time local$default$8() {
        return Time.SYSTEM;
    }

    public boolean local$default$12() {
        return true;
    }

    public boolean local$default$13() {
        return true;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.LogFileSuffix()).append(suffix).toString());
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        String suffix = new StringBuilder(2).append("-").append(topicPartition.partition()).append(".").append(uniqueId).append(this.DeleteDirSuffix()).toString();
        int prefixLength = Math.min(new StringOps(Predef$.MODULE$.augmentString(topicPartition.topic())).size(), 255 - new StringOps(Predef$.MODULE$.augmentString(suffix)).size());
        return new StringBuilder(0).append(topicPartition.topic().substring(0, prefixLength)).append(suffix).toString();
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.FutureDirSuffix());
    }

    private String logDirNameWithSuffix(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringBuilder(1).append(this.logDirName(topicPartition)).append(".").append(uniqueId).append(suffix).toString();
    }

    public String logDirName(TopicPartition topicPartition) {
        return new StringBuilder(1).append(topicPartition.topic()).append("-").append(topicPartition.partition()).toString();
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.IndexFileSuffix()).append(suffix).toString());
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TimeIndexFileSuffix()).append(suffix).toString());
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public void deleteFileIfExists(File file, String suffix) {
        Files.deleteIfExists(new File(new StringBuilder(0).append(file.getPath()).append(suffix).toString()).toPath());
    }

    public String deleteFileIfExists$default$2() {
        return "";
    }

    public File producerSnapshotFile(File dir, long offset) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.ProducerSnapshotFileSuffix()).toString());
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TxnIndexFileSuffix()).append(suffix).toString());
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public File tierStateFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TierStateSuffix()).append(suffix).toString());
    }

    public String tierStateFile$default$3() {
        return "";
    }

    public long offsetFromFileName(String filename) {
        return new StringOps(Predef$.MODULE$.augmentString(filename.substring(0, filename.indexOf(46)))).toLong();
    }

    public long offsetFromFile(File file) {
        return this.offsetFromFileName(file.getName());
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$68 -> BoxesRunTime.boxToLong((long)x$68.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        int n;
        if (dir == null) {
            throw new KafkaException("dir should not be null");
        }
        String dirName = dir.getName();
        if (dirName == null || dirName.isEmpty() || !new StringOps(Predef$.MODULE$.augmentString(dirName)).contains((Object)BoxesRunTime.boxToCharacter((char)'-'))) {
            throw Log$.exception$1(dir);
        }
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches() || dirName.endsWith(this.FutureDirSuffix()) && !this.FutureDirPattern().matcher(dirName).matches()) {
            throw Log$.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) || dirName.endsWith(this.FutureDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw Log$.exception$1(dir);
        }
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw Log$.exception$1(dir);
        }
        int partition = n;
        return new TopicPartition(topic, partition);
    }

    public boolean kafka$log$Log$$isIndexFile(File file) {
        String filename = file.getName();
        return filename.endsWith(this.IndexFileSuffix()) || filename.endsWith(this.TimeIndexFileSuffix()) || filename.endsWith(this.TxnIndexFileSuffix());
    }

    public boolean kafka$log$Log$$isLogFile(File file) {
        return file.getPath().endsWith(this.LogFileSuffix());
    }

    public boolean isTierStateFile(File file) {
        return file.getPath().endsWith(this.TierStateSuffix());
    }

    public <A> ConcurrentNavigableMap<Long, A> logSegments(ConcurrentNavigableMap<Long, A> segments, long from, long to) {
        return (ConcurrentNavigableMap)Option$.MODULE$.apply((Object)segments.floorKey(Predef$.MODULE$.long2Long(from))).map((Function1 & Serializable & scala.Serializable)floor -> segments.subMap(floor, Predef$.MODULE$.long2Long(to))).getOrElse((Function0 & Serializable & scala.Serializable)() -> segments.headMap(Predef$.MODULE$.long2Long(to)));
    }

    /*
     * WARNING - void declaration
     */
    public Option<ByteBuffer> serializeAbortedTransactions(Seq<AbortedTxn> abortedTxnsList) {
        void var2_2;
        None$ maybeAbortedTxnsBuf = None$.MODULE$;
        if (abortedTxnsList.nonEmpty()) {
            ByteBuffer buf = ByteBuffer.allocate(abortedTxnsList.length() * AbortedTxn$.MODULE$.TotalSize());
            abortedTxnsList.foreach((Function1 & Serializable & scala.Serializable)abortedTxn -> buf.put(abortedTxn.buffer().duplicate()));
            buf.flip();
            maybeAbortedTxnsBuf = new Some((Object)buf);
        }
        return var2_2;
    }

    public void kafka$log$Log$$loadProducersFromRecords(ProducerStateManager producerStateManager, Records records) {
        Map loadedProducers = Map$.MODULE$.empty();
        ListBuffer completedTxns = (ListBuffer)ListBuffer$.MODULE$.empty();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                MODULE$.kafka$log$Log$$updateProducers(producerStateManager, (RecordBatch)batch, (Map<Object, ProducerAppendInfo>)loadedProducers, (Option<LogOffsetMetadata>)None$.MODULE$, AppendOrigin$Replication$.MODULE$).foreach((Function1 & Serializable & scala.Serializable)x$69 -> completedTxns.$plus$eq(x$69));
            }
        });
        loadedProducers.values().foreach((Function1 & Serializable & scala.Serializable)appendInfo -> {
            producerStateManager.update(appendInfo);
            return BoxedUnit.UNIT;
        });
        completedTxns.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
            producerStateManager.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CompletedTxn> kafka$log$Log$$updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Object, ProducerAppendInfo> producers, Option<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin) {
        long producerId = batch.producerId();
        return ((ProducerAppendInfo)producers.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable & scala.Serializable)() -> producerStateManager.prepareUpdate(producerId, origin))).append(batch, firstOffsetMetadata);
    }

    private static final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder(196).append("Found directory ").append(dir.getCanonicalPath()).append(", '").append(dir.getName()).append("' is not in the form of ").append("topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n").append("Kafka's log directories (and children) should only contain Kafka topic data.").toString());
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.TimeIndexFileSuffix = ".timeindex";
        this.ProducerSnapshotFileSuffix = ".snapshot";
        this.TxnIndexFileSuffix = ".txnindex";
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.CleanShutdownFile = ".kafka_cleanshutdown";
        this.DeleteDirSuffix = "-delete";
        this.FutureDirSuffix = "-future";
        this.TierStateSuffix = ".tierstate";
        this.DeleteDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(this.DeleteDirSuffix()).toString());
        this.FutureDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(this.FutureDirSuffix()).toString());
        this.UnknownOffset = -1L;
    }
}

