/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.durability.Utils;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.PartitionState;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.materialization.Validator$;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u000f\u001f\u0001\u0015B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011!!\u0005A!A!\u0002\u0013)\u0005\"B)\u0001\t\u0003\u0011\u0006\u0002\u0003-\u0001\u0005\u0004%\t\u0001I-\t\ru\u0003\u0001\u0015!\u0003[\u0011\u001dq\u0006A1A\u0005\neCaa\u0018\u0001!\u0002\u0013Q\u0006\"\u00021\u0001\t\u0003\t\u0007\u0002C@\u0001#\u0003%\t!!\u0001\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!A\u00111\u0005\u0001\u0005\u0002y\t)\u0003C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!!)\u0001\t\u0003\t\u0019\u000bC\u0004\u0002*\u0002!I!a+\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"A\u0011\u0011\u0019\u0001\u0005\u0002y\t\u0019mB\u0005\u0002Zz\t\t\u0011#\u0001\u0002\\\u001aAQDHA\u0001\u0012\u0003\ti\u000e\u0003\u0004R5\u0011\u0005\u0011q\u001c\u0005\n\u0003CT\u0012\u0013!C\u0001\u0003G\u0014\u0011BV1mS\u0012\fGo\u001c:\u000b\u0005}\u0001\u0013aD7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u0005\u0012\u0013A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00011C\u0006\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[Aj\u0011A\f\u0006\u0003_\t\nQ!\u001e;jYNL!!\r\u0018\u0003\u000f1{wmZ5oO\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]\u0012\u0013AB:feZ,'/\u0003\u0002:m\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0011I,\u0007o\u001c:uKJ,\u0012!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0002\nQ!Y;eSRL!AQ \u0003\u001b\u0005+H-\u001b;SKB|'\u000f^3s\u0003%\u0011X\r]8si\u0016\u0014\b%\u0001\u0003uS6,\u0007C\u0001$P\u001b\u00059%BA\u0018I\u0015\tI%*\u0001\u0004d_6lwN\u001c\u0006\u0003G-S!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO&\u0011\u0001k\u0012\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\u0005'V3v\u000b\u0005\u0002U\u00015\ta\u0004C\u00033\r\u0001\u0007A\u0007C\u0003<\r\u0001\u0007Q\bC\u0004E\rA\u0005\t\u0019A#\u00029I+G/\u001a8uS>tG+[7f\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:NgV\t!\f\u0005\u0002(7&\u0011A\f\u000b\u0002\u0004\u0013:$\u0018!\b*fi\u0016tG/[8o)&lW-T1sO&twJZ#se>\u0014Xj\u001d\u0011\u00025I+G/\u001a8uS>t7+\u001b>f\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:\u00027I+G/\u001a8uS>t7+\u001b>f\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:!\u0003]1\u0018\r\\5eCR,GI\u0011%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u0006\u0004cK.l'O\u001f\t\u0003O\rL!\u0001\u001a\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006M.\u0001\raZ\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\tA\u0017.D\u0001I\u0013\tQ\u0007J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b1\\\u0001\u0019\u0001.\u0002\u000b\u0015\u0004xn\u00195\t\u000b9\\\u0001\u0019A8\u0002\u0007!<X\u000e\u0005\u0002(a&\u0011\u0011\u000f\u000b\u0002\u0005\u0019>tw\rC\u0003t\u0017\u0001\u0007A/A\u0003ti\u0006$X\r\u0005\u0002vq6\taO\u0003\u0002xA\u0005\u0011AMY\u0005\u0003sZ\u0014a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004|\u0017A\u0005\t\u0019\u0001?\u0002\u001b%\u001cX\t]8dQ\u000eC\u0017M\\4f!\t9S0\u0003\u0002\u007fQ\t9!i\\8mK\u0006t\u0017!\t<bY&$\u0017\r^3E\u0005\"Kw\r[,bi\u0016\u0014X.\u0019:lI\u0011,g-Y;mi\u0012*TCAA\u0002U\ra\u0018QA\u0016\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0003\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0005-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Ib/\u00197jI\u0006$X\rT8dC2dunZ#oI>3gm]3u)%\u0011\u00171DA\u000f\u0003?\t\t\u0003C\u0003g\u001b\u0001\u0007q\rC\u0003m\u001b\u0001\u0007!\fC\u0003o\u001b\u0001\u0007q\u000eC\u0003t\u001b\u0001\u0007A/A\thKR\u0014V\r^3oi&|gNV1mk\u0016$\u0002\"a\n\u0002.\u0005=\u0012\u0011\u0007\t\u0005O\u0005%r.C\u0002\u0002,!\u0012aa\u00149uS>t\u0007\"\u00024\u000f\u0001\u00049\u0007\"B:\u000f\u0001\u0004!\bbBA\u001a\u001d\u0001\u0007\u0011QG\u0001\u000ee\u0016$XM\u001c;j_:$\u0016\u0010]3\u0011\t\u0005]\u00121\u000b\b\u0005\u0003s\tiE\u0004\u0003\u0002<\u0005%c\u0002BA\u001f\u0003\u000frA!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\"\u0013A\u0002\u001fs_>$h(C\u0001$\u0013\t\t#%C\u0002\u0002L\u0001\na!\u001a<f]R\u001c\u0018\u0002BA(\u0003#\nQBU3uK:$\u0018n\u001c8UsB,'bAA&A%!\u0011QKA,\u00055\u0011V\r^3oi&|g\u000eV=qK*!\u0011qJA)\u0003a1\u0018\r\\5eCR,GI\u0011'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0006E\u0006u\u0013\u0011\u000e\u0005\b\u0003?z\u0001\u0019AA1\u0003\u0015)g/\u001a8u!\u0011\t\u0019'!\u001a\u000e\u0005\u0005E\u0013\u0002BA4\u0003#\u0012ac\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\u0006g>\u0001\r\u0001^\u0001\u0015g&TX\rT1qg\u0016\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u000fq\fy'!\u001d\u0002t!9\u0011q\f\tA\u0002\u0005\u0005\u0004\"B:\u0011\u0001\u0004!\bBBA;!\u0001\u0007q.\u0001\bsKR,g\u000e^5p]Z\u000bG.^3\u0002)QLW.\u001a'baN,7)\u00197dk2\fG/[8o)\u001da\u00181PA?\u0003\u007fBq!a\u0018\u0012\u0001\u0004\t\t\u0007C\u0003t#\u0001\u0007A\u000f\u0003\u0004\u0002vE\u0001\ra\\\u0001\u001cm\u0006d\u0017\u000eZ1uK2{7-\u00197M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\u000b\t\f))a\"\t\u000b\u0019\u0014\u0002\u0019A4\t\r\u0005%%\u00031\u0001p\u00031aW-\u00193fe>3gm]3u\u0003U1\u0018\r\\5eCR,GIQ#q_\u000eD7\t[1oO\u0016$RAYAH\u00033Cq!!%\u0014\u0001\u0004\t\u0019*\u0001\tfa>\u001c\u0007n\u00115b]\u001e,WI^3oiB!\u00111MAK\u0013\u0011\t9*!\u0015\u0003!\u0015\u0003xn\u00195DQ\u0006tw-Z#wK:$\b\"B:\u0014\u0001\u0004!\u0018\u0001\b<bY&$\u0017\r^3Fa>\u001c\u0007n\u00115b]\u001e,w+\u001b;i\u0019>\u001c\u0017\r\u001c\u000b\u0004E\u0006}\u0005bBAI)\u0001\u0007\u00111S\u0001\u001cm\u0006d\u0017\u000eZ1uK\u0016\u0003xn\u00195DQ\u0006LgnV5uQ2{7-\u00197\u0015\u000b\t\f)+a*\t\u000b\u0019,\u0002\u0019A4\t\u000bM,\u0002\u0019\u0001;\u0002K]LG\u000f[5o\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:G_J$\u0016.\\3NgJ+G/\u001a8uS>tG#\u0002?\u0002.\u0006E\u0006BBAX-\u0001\u0007q.\u0001\u0004uS6,Wj\u001d\u0005\u0007\u0003g3\u0002\u0019A8\u0002\u0017I,G/\u001a8uS>tWj]\u0001$o&$\b.\u001b8NCJ<\u0017N\\(g\u000bJ\u0014xN\u001d$peNK'0\u001a*fi\u0016tG/[8o)\u0015a\u0018\u0011XA_\u0011\u0019\tYl\u0006a\u0001_\u0006!1/\u001b>f\u0011\u0019\tyl\u0006a\u0001_\u0006i!/\u001a;f]RLwN\\*ju\u0016\f\u0001\"[:J]NKhn\u0019\u000b\u0004y\u0006\u0015\u0007bBAd1\u0001\u0007\u0011\u0011Z\u0001\u0004SN\u0014\b#BAf\u0003'Tf\u0002BAg\u0003\u001f\u00042!a\u0010)\u0013\r\t\t\u000eK\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0017q\u001b\u0002\u0004'\u0016$(bAAiQ\u0005Ia+\u00197jI\u0006$xN\u001d\t\u0003)j\u0019\"A\u0007\u0014\u0015\u0005\u0005m\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002f*\u001aQ)!\u0002")
public class Validator
implements Logging {
    private final ReplicaManager replicaManager;
    private final AuditReporter reporter;
    private final Time time;
    private final int RetentionTimeMarginOfErrorMs;
    private final int RetentionSizeMarginOfError;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$3() {
        return Validator$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public AuditReporter reporter() {
        return this.reporter;
    }

    public int RetentionTimeMarginOfErrorMs() {
        return this.RetentionTimeMarginOfErrorMs;
    }

    private int RetentionSizeMarginOfError() {
        return this.RetentionSizeMarginOfError;
    }

    public void validateDBHighWatermark(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, boolean isEpochChange) {
        if (state.highWatermark() > hwm && !isEpochChange) {
            String msg = new StringBuilder(192).append("Durability lapse on validation with db hwm. For partition ").append(topicPartition).append(", high water mark").append(" decreased from previous committed value. The db state is ").append(state).append(" whereas the new high watermark state change").append(" is ").append(hwm).append(" at epoch ").append(epoch).append(".").toString();
            this.reporter().reportDurabilityLapse(topicPartition, hwm, state.highWatermark() - hwm, msg, this.reporter().reportDurabilityLapse$default$5());
        }
    }

    public boolean validateDBHighWatermark$default$5() {
        return false;
    }

    public void validateLocalLogEndOffset(TopicPartition topicPartition, int epoch, long hwm, PartitionState state) {
        long localEndOffset;
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), topicPartition);
        if (option instanceof Some && (localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value())) < hwm) {
            String msg = new StringBuilder(204).append("Durability lapse on validation with local log end offset. For partition ").append(topicPartition).append(",").append(" high water mark(").append(hwm).append(") is found to be more than local end offset(").append(localEndOffset).append("), where the local replica").append(" is at epoch ").append(state.latestLocalEpoch()).append(" compares to event's epoch of ").append(epoch).append(".").toString();
            this.reporter().reportDurabilityLapse(topicPartition, localEndOffset, 1L, msg, false);
            return;
        }
    }

    public Option<Object> getRetentionValue(TopicPartition topicPartition, PartitionState state, Enumeration.Value retentionType) {
        Object object;
        Enumeration.Value value = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value != null ? !value.equals(retentionType) : retentionType != null)) {
            object = state.retentionMs() != -1L ? new Some((Object)BoxesRunTime.boxToLong((long)state.retentionMs())) : Utils$.MODULE$.getLocalLogRetentionMs(this.replicaManager(), topicPartition);
        } else {
            Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
            object = !(value2 != null ? !value2.equals(retentionType) : retentionType != null) ? (state.retentionMs() != -1L ? new Some((Object)BoxesRunTime.boxToLong((long)state.retentionSz())) : Utils$.MODULE$.getLocalLogRetentionSize(this.replicaManager(), topicPartition)) : None$.MODULE$;
        }
        return object;
    }

    public void validateDBLogStartOffset(StartOffsetChangeEvent event, PartitionState state) {
        block14: {
            block13: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block12: {
                    Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
                    Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
                    if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                        this.sizeLapseCalculation(event, state, event.retentionValue());
                        return;
                    }
                    Enumeration.Value value5 = RetentionType$.MODULE$.apply(event.retentionType());
                    Enumeration.Value value6 = RetentionType$.MODULE$.TimeBasedRetention();
                    if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                        this.timeLapseCalculation(event, state, event.retentionValue());
                        return;
                    }
                    value2 = RetentionType$.MODULE$.apply(event.retentionType());
                    value = RetentionType$.MODULE$.Other();
                    if (value2 != null) break block12;
                    if (value != null) {
                        return;
                    }
                    break block13;
                }
                if (!value2.equals(value)) break block14;
            }
            Option<Object> option = this.getRetentionValue(event.topicPartition(), state, RetentionType$.MODULE$.TimeBasedRetention());
            Option<Object> option2 = this.getRetentionValue(event.topicPartition(), state, RetentionType$.MODULE$.SizeBasedRetention());
            Option<Object> option3 = option;
            if (option2 instanceof Some) {
                long retentionSz = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                if (option3 instanceof Some) {
                    long retentionMs = BoxesRunTime.unboxToLong((Object)((Some)option3).value());
                    Option<Object> estimatedSize = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicPartition(), event.logStartOffset());
                    Option<Utils.MaxTimestampWithSize> prevSegInfo = Utils$.MODULE$.getImmediatePreviousTierSegmentInfo(this.replicaManager(), event.topicPartition(), event.logStartOffset());
                    Option<Object> option4 = estimatedSize;
                    Option<Utils.MaxTimestampWithSize> option5 = prevSegInfo;
                    if (option4 instanceof Some) {
                        long estimatedSize2 = BoxesRunTime.unboxToLong((Object)((Some)option4).value());
                        if (option5 instanceof Some) {
                            Utils.MaxTimestampWithSize prevSegInfo2 = (Utils.MaxTimestampWithSize)((Some)option5).value();
                            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize2, retentionSz) && !this.withinMarginOfErrorForTimeMsRetention(prevSegInfo2.maxTimestamp(), retentionMs)) {
                                String msg = new StringBuilder(377).append("Durability lapse on validation with db log start offset. For partition").append(" ").append(event.topicPartition()).append(" the startOffset from durability event ").append(event).append(", is more than expected retention").append(" window time with current db state as ").append(state).append(". The maxTimestamp in previous deleted segment is").append(" ").append(prevSegInfo2.maxTimestamp()).append(" with retention of ").append(retentionMs).append(" and margin of error as").append(" ").append(this.RetentionTimeMarginOfErrorMs()).append(". For size based lapse, size including previous segment is").append(" ").append(estimatedSize2).append(" with retention of ").append(retentionSz).append(" and margin of error as ").append(this.RetentionSizeMarginOfError()).append(".").toString();
                                this.reporter().reportDurabilityLapse(event.topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), msg, this.reporter().reportDurabilityLapse$default$5());
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean sizeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue) {
        boolean bl;
        Option<Object> option = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicPartition(), event.logStartOffset());
        if (option instanceof Some) {
            boolean bl2;
            long estimatedSize = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize, retentionValue)) {
                String msg = new StringBuilder(224).append("Durability lapse based on size lapse. For partition ").append(event.topicPartition()).append(" the startOffset").append(" from durability event ").append(event).append(", is more than expected retention window size with current db state as ").append(state).append(".").append(" The estimated size ").append(estimatedSize).append(" retentionValue ").append(retentionValue).append(" with margin of error as ").append(this.RetentionSizeMarginOfError()).toString();
                this.reporter().reportDurabilityLapse(event.topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), msg, this.reporter().reportDurabilityLapse$default$5());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean timeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue) {
        boolean bl;
        Option<Utils.MaxTimestampWithSize> option = Utils$.MODULE$.getImmediatePreviousTierSegmentInfo(this.replicaManager(), event.topicPartition(), event.logStartOffset());
        if (option instanceof Some) {
            boolean bl2;
            Utils.MaxTimestampWithSize prevMs = (Utils.MaxTimestampWithSize)((Some)option).value();
            if (!this.withinMarginOfErrorForTimeMsRetention(prevMs.maxTimestamp(), retentionValue)) {
                String msg = new StringBuilder(252).append("Durability lapse based on time lapse. For partition ").append(event.topicPartition()).append(" the startOffset").append(" from durability event ").append(event).append(", is more than expected retention window time with current db state as ").append(state).append(".").append(" The maxTimestamp in previous deleted segment is ").append(prevMs.maxTimestamp()).append(" retentionValue ").append(retentionValue).append(" and").append(" margin of error is ").append(this.RetentionTimeMarginOfErrorMs()).toString();
                this.reporter().reportDurabilityLapse(event.topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), msg, this.reporter().reportDurabilityLapse$default$5());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public void validateLocalLogStartOffset(TopicPartition topicPartition, long leaderOffset) {
        Utils.MaxTimestampWithSize prevSegmentState;
        Option<Utils.MaxTimestampWithSize> option;
        AbstractLog log;
        Option<AbstractLog> option2 = this.replicaManager().logManager().getLog(topicPartition, this.replicaManager().logManager().getLog$default$2());
        if (option2 instanceof Some && (log = (AbstractLog)((Some)option2).value()) != null && log.logStartOffset() > leaderOffset && (option = Utils$.MODULE$.getImmediatePreviousTierSegmentInfo(this.replicaManager(), topicPartition, log.logStartOffset())) instanceof Some && !this.withinMarginOfErrorForTimeMsRetention((prevSegmentState = (Utils.MaxTimestampWithSize)((Some)option).value()).maxTimestamp(), Predef$.MODULE$.Long2long(log.config().retentionMs())) && !this.withinMarginOfErrorForSizeRetention(log.size() + prevSegmentState.size(), Predef$.MODULE$.Long2long(log.config().retentionSize()))) {
            String msg = new StringBuilder(187).append("Durability lapse on validation with local log start offset. For local start offset").append(" of ").append(topicPartition).append(" on ").append(Utils$.MODULE$.getBrokerId(this.replicaManager())).append(". The previous maxTimestamp is").append(" ").append(prevSegmentState.maxTimestamp()).append(" with retention ").append(log.config().retentionMs()).append(", the logSize is ").append(log.size()).append(" prevSegmentSize ").append(prevSegmentState.size()).append(" with retention ").append(log.config().retentionSize()).toString();
            this.reporter().reportDurabilityLapse(topicPartition, log.logStartOffset(), Math.max(log.logStartOffset() - leaderOffset, 1L), msg, false);
            return;
        }
    }

    public void validateDBEpochChange(EpochChangeEvent epochChangeEvent, PartitionState state) {
        if (epochChangeEvent.firstOffset() < state.highWatermark() || epochChangeEvent.epoch() < state.latestEpoch()) {
            String msg = new StringBuilder(142).append("Durability lapse on epoch change event ").append(epochChangeEvent).append(" state ").append(state).append(". First offset").append(" ").append(epochChangeEvent.firstOffset()).append(" for new epoch ").append(epochChangeEvent.epoch()).append(" is less than previous recorded high watermark").append(" ").append(state.highWatermark()).append(". Event: ").append(epochChangeEvent).append(" DbState: ").append(state).toString();
            this.reporter().reportDurabilityLapse(epochChangeEvent.topicPartition(), epochChangeEvent.firstOffset(), Math.max(state.highWatermark() - epochChangeEvent.firstOffset(), 1L), msg, this.reporter().reportDurabilityLapse$default$5());
        }
    }

    public void validateEpochChangeWithLocal(EpochChangeEvent epochChangeEvent) {
        if (this.isInSync(epochChangeEvent.isr())) {
            Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), epochChangeEvent.topicPartition());
            Option<Object> option2 = Utils$.MODULE$.getLatestEpoch(this.replicaManager(), epochChangeEvent.topicPartition());
            Option<Object> option3 = option;
            if (option2 instanceof Some) {
                int epoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                if (option3 instanceof Some) {
                    long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option3).value());
                    if (epoch >= epochChangeEvent.epoch() && localEndOffset < epochChangeEvent.firstOffset()) {
                        String msg = new StringBuilder(188).append("Durability lapse on validation of epoch change with local. For in-sync partition").append(" ").append(epochChangeEvent.topicPartition()).append(", the local end offset ").append(localEndOffset).append(" at local epoch ").append(epoch).append(", is").append(" less than the first offset of the new epoch. The event detail: ").append(epochChangeEvent).toString();
                        this.reporter().reportDurabilityLapse(epochChangeEvent.topicPartition(), localEndOffset, 1L, msg, false);
                    } else if (localEndOffset < epochChangeEvent.highWatermark()) {
                        String msg = new StringBuilder(203).append("Durability lapse on validation of epoch change with local. For in-sync partition").append(" ").append(epochChangeEvent.topicPartition()).append(", the local end offset ").append(localEndOffset).append(" at local epoch ").append(epoch).append(", is").append(" less than the high watermark of the new epoch change event. The event detail: ").append(epochChangeEvent).toString();
                        this.reporter().reportDurabilityLapse(epochChangeEvent.topicPartition(), localEndOffset, 1L, msg, false);
                    }
                }
            }
            Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), epochChangeEvent.topicPartition(), epochChangeEvent.epoch());
            Option<AbstractLog> log = this.replicaManager().logManager().getLog(epochChangeEvent.topicPartition(), this.replicaManager().logManager().getLog$default$2());
            Option<Object> option4 = localOffset;
            Option<AbstractLog> option5 = log;
            if (option4 instanceof Some) {
                long firstOffset = BoxesRunTime.unboxToLong((Object)((Some)option4).value());
                if (option5 instanceof Some) {
                    AbstractLog localLog = (AbstractLog)((Some)option5).value();
                    if (firstOffset != -1L && firstOffset != epochChangeEvent.firstOffset() && (firstOffset < epochChangeEvent.firstOffset() || firstOffset > localLog.logStartOffset()) && Utils$.MODULE$.isNonCompacted(this.replicaManager(), epochChangeEvent.topicPartition())) {
                        String msg = new StringBuilder(172).append("Durability lapse on validation of epoch change with local. For in-sync partition").append(" ").append(epochChangeEvent.topicPartition()).append(", the local first offset ").append(localOffset).append(" is not equal to first offset").append(" of the new epoch. The event detail: ").append(epochChangeEvent).toString();
                        this.reporter().reportDurabilityLapse(epochChangeEvent.topicPartition(), firstOffset, 1L, msg, false);
                        return;
                    }
                }
            }
        }
    }

    public void validateEpochChainWithLocal(TopicPartition topicPartition, PartitionState state) {
        Object object = new Object();
        try {
            if (!Utils$.MODULE$.isNonCompacted(this.replicaManager(), topicPartition)) {
                return;
            }
            LongRef prevLocalEpochFirstOffset = LongRef.create((long)-1L);
            IntRef prevEpoch = IntRef.create((int)-1);
            ((List)state.epochChain().toList().sortWith((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)Validator.$anonfun$validateEpochChainWithLocal$1(x, y)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Validator.$anonfun$validateEpochChainWithLocal$2(this, topicPartition, prevLocalEpochFirstOffset, state, prevEpoch, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private boolean withinMarginOfErrorForTimeMsRetention(long timeMs, long retentionMs) {
        if (timeMs == -1L) {
            return true;
        }
        if (retentionMs == -1L) {
            return false;
        }
        long diff = this.time.milliseconds() - timeMs;
        return retentionMs - diff <= (long)this.RetentionTimeMarginOfErrorMs();
    }

    private boolean withinMarginOfErrorForSizeRetention(long size, long retentionSize) {
        if (size == -1L) {
            return true;
        }
        if (retentionSize == -1L) {
            return false;
        }
        return retentionSize - size <= (long)this.RetentionSizeMarginOfError();
    }

    public boolean isInSync(Set<Object> isr) {
        return isr.contains((Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    public static final /* synthetic */ boolean $anonfun$validateEpochChainWithLocal$1(Tuple2 x, Tuple2 y) {
        return x._1$mcI$sp() < y._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$validateEpochChainWithLocal$2(Validator $this, TopicPartition topicPartition$1, LongRef prevLocalEpochFirstOffset$1, PartitionState state$1, IntRef prevEpoch$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long localEpochFirstOffset;
            int dbEpoch = x0$1._1$mcI$sp();
            long dbEpochFirstOffset = x0$1._2$mcJ$sp();
            Option<Object> option = Utils$.MODULE$.getLocalStartOffsetForEpoch($this.replicaManager(), topicPartition$1, dbEpoch);
            if (option instanceof Some && (localEpochFirstOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value())) != -1L) {
                AbstractLog log;
                Option<AbstractLog> option2;
                if (dbEpochFirstOffset < prevLocalEpochFirstOffset$1.elem) {
                    String msg = new StringBuilder(176).append("Durability lapse on epoch chain validation for partition ").append(topicPartition$1).append(". The durability").append(" state ").append(state$1).append(" does not match at ").append(prevEpoch$1.elem).append(", the local first offset is ").append(prevLocalEpochFirstOffset$1.elem).append(" more than or equal to next epoch's first offset ").append(dbEpochFirstOffset).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, msg, false);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (localEpochFirstOffset != dbEpochFirstOffset && (option2 = $this.replicaManager().logManager().getLog(topicPartition$1, $this.replicaManager().logManager().getLog$default$2())) instanceof Some && ((log = (AbstractLog)((Some)option2).value()).logStartOffset() < localEpochFirstOffset || dbEpochFirstOffset > localEpochFirstOffset)) {
                    String msg = new StringBuilder(189).append("Durability lapse on epoch chain validation for partition ").append(topicPartition$1).append(". The durability").append(" state ").append(state$1).append(" does not match at ").append(dbEpoch).append(", the local first offset is ").append(localEpochFirstOffset).append(" is more than db local first offset and also log start offset ").append(log.logStartOffset()).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, msg, false);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                prevLocalEpochFirstOffset$1.elem = localEpochFirstOffset;
                prevEpoch$1.elem = dbEpoch;
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public Validator(ReplicaManager replicaManager, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.reporter = reporter;
        this.time = time;
        Logging.$init$(this);
        this.RetentionTimeMarginOfErrorMs = 3600000;
        this.RetentionSizeMarginOfError = 0x100000;
    }
}

