/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.OffsetChangeEvent;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.Validator;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u000b\u0017\u0001uA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011)\u0019!C\u0001e!A\u0001\b\u0001B\u0001B\u0003%1\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\"B'\u0001\t\u0003q\u0005\u0002C+\u0001\u0005\u0004%\tA\u0006,\t\ri\u0003\u0001\u0015!\u0003X\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0019\u0001\b\u0001\"\u0001\u0017c\"9q\u0010\u0001C\u0001-\u0005\u0005\u0001\u0002CA\b\u0001\u0011\u0005a#!\u0005\t\u0015\u0005e\u0003!%A\u0005\u0002Y\tY\u0006C\u0004\u0002r\u0001!I!a\u001d\t\u0013\u0005%\u0005!%A\u0005\n\u0005-\u0005\u0002CAH\u0001\u0011\u0005a#!%\t\u0015\u0005m\u0005!%A\u0005\u0002Y\tY\u0006\u0003\u0005\u0002\u001e\u0002!\tAFAP\u0011!\ti\u000b\u0001C\u0001-\u0005=\u0006\u0002CA_\u0001\u0011\u0005a#a0\u00037\u0011+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u0015\t9\u0002$A\bnCR,'/[1mSj\fG/[8o\u0015\tI\"$\u0001\u0006ekJ\f'-\u001b7jifT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dR\u0012!B;uS2\u001c\u0018BA\u0015'\u0005\u001daunZ4j]\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002-_5\tQF\u0003\u0002/5\u000511/\u001a:wKJL!\u0001M\u0017\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011AMY\u000b\u0002gA\u0011AGN\u0007\u0002k)\u0011\u0011\u0007G\u0005\u0003oU\u0012A\u0002R;sC\nLG.\u001b;z\t\n\u000b1\u0001\u001a2!\u0003!\u0011X\r]8si\u0016\u0014\bCA\u001e?\u001b\u0005a$BA\u001f\u0019\u0003\u0015\tW\u000fZ5u\u0013\tyDHA\u0007Bk\u0012LGOU3q_J$XM]\u0001\u0005i&lW\r\u0005\u0002C\u00176\t1I\u0003\u0002(\t*\u0011QIR\u0001\u0007G>lWn\u001c8\u000b\u0005m9%B\u0001%J\u0003\u0019\t\u0007/Y2iK*\t!*A\u0002pe\u001eL!\u0001T\"\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b=\u000b&k\u0015+\u0011\u0005A\u0003Q\"\u0001\f\t\u000b)2\u0001\u0019A\u0016\t\u000bE2\u0001\u0019A\u001a\t\u000be2\u0001\u0019\u0001\u001e\t\u000b\u00013\u0001\u0019A!\u0002\u0013Y\fG.\u001b3bi>\u0014X#A,\u0011\u0005AC\u0016BA-\u0017\u0005%1\u0016\r\\5eCR|'/\u0001\u0006wC2LG-\u0019;pe\u0002\n1\"\\1uKJL\u0017\r\\5{KR\u0011Q\f\u0019\t\u0003?yK!a\u0018\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006C&\u0001\rAY\u0001\u0007e\u0016\u001cwN\u001d3\u0011\t\rD'N[\u0007\u0002I*\u0011QMZ\u0001\tG>t7/^7fe*\u0011qMR\u0001\bG2LWM\u001c;t\u0013\tIGM\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u0007}YW.\u0003\u0002mA\t)\u0011I\u001d:bsB\u0011qD\\\u0005\u0003_\u0002\u0012AAQ=uK\u0006aR.\u0019;fe&\fG.\u001b>f\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$HcA/su\")1O\u0003a\u0001i\u0006)QM^3oiB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fG\u0001\u0007KZ,g\u000e^:\n\u0005e4(!E(gMN,Go\u00115b]\u001e,WI^3oi\")1P\u0003a\u0001y\u0006)1\u000f^1uKB\u0011A'`\u0005\u0003}V\u0012a\u0002U1si&$\u0018n\u001c8Ti\u0006$X-\u0001\u000fnCR,'/[1mSj,G)\u001a7fi\u0016\u0014VmY8sI\u00163XM\u001c;\u0015\u000bu\u000b\u0019!!\u0004\t\u000f\u0005\u00151\u00021\u0001\u0002\b\u0005\u0011B-\u001a7fi\u0016\u0014VmY8sIN,e/\u001a8u!\r)\u0018\u0011B\u0005\u0004\u0003\u00171(A\u0005#fY\u0016$XMU3d_J$7/\u0012<f]RDQa_\u0006A\u0002q\fq$\\1uKJL\u0017\r\\5{K\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0007\"\fgnZ3t)5i\u00161CA\u0010\u0003S\t\u0019$!\u0014\u0002P!9\u0011Q\u0003\u0007A\u0002\u0005]\u0011A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u00033\tY\"D\u0001E\u0013\r\ti\u0002\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\t\u0003\u0004a\u0001\u0003G\tQ!\u001a9pG\"\u00042aHA\u0013\u0013\r\t9\u0003\t\u0002\u0004\u0013:$\bbBA\u0016\u0019\u0001\u0007\u0011QF\u0001\u0004Q^l\u0007cA\u0010\u00020%\u0019\u0011\u0011\u0007\u0011\u0003\t1{gn\u001a\u0005\b\u0003ka\u0001\u0019AA\u001c\u0003\rI7O\u001d\t\u0007\u0003s\t9%a\t\u000f\t\u0005m\u00121\t\t\u0004\u0003{\u0001SBAA \u0015\r\t\t\u0005H\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015\u0003%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\nYEA\u0002TKRT1!!\u0012!\u0011\u0015YH\u00021\u0001}\u0011%\t\t\u0006\u0004I\u0001\u0002\u0004\t\u0019&\u0001\fue&<w-\u001a:fI\nKX\t]8dQ\u000eC\u0017M\\4f!\ry\u0012QK\u0005\u0004\u0003/\u0002#a\u0002\"p_2,\u0017M\\\u0001*[\u0006$XM]5bY&TX\rS5hQ^\u000bG/\u001a:nCJ\\7\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005u#\u0006BA*\u0003?Z#!!\u0019\u0011\t\u0005\r\u0014QN\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003W\u0002\u0013AC1o]>$\u0018\r^5p]&!\u0011qNA3\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\"[\u0006\\WmR3oKJL7m\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\r\u0003k\nY(a \u0002\u0002\u0006\u0015\u0015q\u0011\t\u0004k\u0006]\u0014bAA=m\n12\u000b^1si>3gm]3u\u0007\"\fgnZ3Fm\u0016tG\u000fC\u0004\u0002~9\u0001\r!a\u0006\u0002\u0005%$\u0007bBA\u0011\u001d\u0001\u0007\u00111\u0005\u0005\b\u0003\u0007s\u0001\u0019AA\u0017\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\u0005-b\u00021\u0001\u0002.!I\u0011Q\u0007\b\u0011\u0002\u0003\u0007\u0011qG\u0001,[\u0006\\WmR3oKJL7m\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\u0012\u0016\u0005\u0003o\ty&\u0001\fnCR,'/[1mSj,7\u000b^1si>3gm]3u)\u001di\u00161SAK\u0003/Caa\u001d\tA\u0002\u0005U\u0004\"B>\u0011\u0001\u0004a\b\"CAM!A\u0005\t\u0019AA*\u0003-1\u0018\r\\5eCR,\u0007jV'\u0002A5\fG/\u001a:jC2L'0Z*uCJ$xJ\u001a4tKR$C-\u001a4bk2$HeM\u0001\u001c[\u0006$XM]5bY&TX-\u00129pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\u000bu\u000b\t+a+\t\u000f\u0005\r&\u00031\u0001\u0002&\u0006\u0001R\r]8dQ\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\t\u0004k\u0006\u001d\u0016bAAUm\n\u0001R\t]8dQ\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\u0006wJ\u0001\r\u0001`\u0001\u001a[\u0006$XM]5bY&TX-S*S\u000bb\u0004\u0018M\u001c3Fm\u0016tG\u000fF\u0003^\u0003c\u000bY\fC\u0004\u00024N\u0001\r!!.\u0002\u001d%\u001c(/\u0012=qC:$WI^3oiB\u0019Q/a.\n\u0007\u0005efO\u0001\bJgJ,\u0005\u0010]1oI\u00163XM\u001c;\t\u000bm\u001c\u0002\u0019\u0001?\u0002?5\fG/\u001a:jC2L'0\u001a*fi\u0016tG/[8o\u0007\"\fgnZ3Fm\u0016tG\u000fF\u0003^\u0003\u0003\fY\rC\u0004\u0002DR\u0001\r!!2\u0002)I,G/\u001a8uS>t7\t[1oO\u0016,e/\u001a8u!\r)\u0018qY\u0005\u0004\u0003\u00134(\u0001\u0006*fi\u0016tG/[8o\u0007\"\fgnZ3Fm\u0016tG\u000fC\u0003|)\u0001\u0007A\u0010")
public class DurabilityEventsMaterialize
implements Logging {
    private final ReplicaManager replicaManager;
    private final DurabilityDB db;
    private final Validator validator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public Validator validator() {
        return this.validator;
    }

    public synchronized void materialize(ConsumerRecord<byte[], byte[]> record) {
        AbstractDurabilityEvent event = Deserializer$.MODULE$.deserialize((byte[])((byte[])record.key()).clone(), (byte[])((byte[])record.value()).clone());
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicPartition());
        if (!stateOpt.isDefined()) {
            return;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (event.epoch() < state.latestEpoch()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Ignoring event ").append(event).append(" as it's from a lower epoch. Current epoch is ").append(state).append(".epoch").toString());
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).append(" for state: ").append(state).toString());
        if (event instanceof OffsetChangeEvent) {
            OffsetChangeEvent offsetChangeEvent = (OffsetChangeEvent)event;
            this.materializeOffsetChangeEvent(offsetChangeEvent, state);
        } else if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state);
        } else if (event instanceof EpochChangeEvent) {
            EpochChangeEvent epochChangeEvent = (EpochChangeEvent)event;
            this.materializeEpochChangeEvent(epochChangeEvent, state);
        } else if (event instanceof IsrExpandEvent) {
            IsrExpandEvent isrExpandEvent = (IsrExpandEvent)event;
            this.materializeISRExpandEvent(isrExpandEvent, state);
        } else if (event instanceof RetentionChangeEvent) {
            RetentionChangeEvent retentionChangeEvent = (RetentionChangeEvent)event;
            this.materializeRetentionChangeEvent(retentionChangeEvent, state);
        } else if (event instanceof StartOffsetChangeEvent) {
            StartOffsetChangeEvent startOffsetChangeEvent = (StartOffsetChangeEvent)event;
            this.materializeStartOffset(startOffsetChangeEvent, state, true);
        } else {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("DurabilityMaterialization: unexpected durability event type ").append(event).append(".eventType ").append(event).append(", ignoring").toString());
            return;
        }
        this.db().addPartition(event.topicPartition(), state);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
    }

    public void materializeOffsetChangeEvent(OffsetChangeEvent event, PartitionState state) {
        this.materializeHighWatermarkChanges(event.topicPartition(), event.epoch(), event.highWatermark(), event.isr(), state, this.materializeHighWatermarkChanges$default$6());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(event.topicPartition(), event.epoch(), event.logStartOffset(), event.highWatermark(), event.isr()), state, this.materializeStartOffset$default$3());
        state.latestEpoch_$eq(event.epoch());
    }

    public void materializeDeleteRecordEvent(DeleteRecordsEvent deleteRecordsEvent, PartitionState state) {
        state.committedStartOffset_$eq(deleteRecordsEvent.trimOffset());
        this.materializeHighWatermarkChanges(deleteRecordsEvent.topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.isr(), state, this.materializeHighWatermarkChanges$default$6());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(deleteRecordsEvent.topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.logStartOffset(), deleteRecordsEvent.highWatermark(), this.makeGenericStartOffsetChangeEvent$default$5()), state, this.materializeStartOffset$default$3());
    }

    public void materializeHighWatermarkChanges(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, boolean triggeredByEpochChange) {
        this.validator().validateDBHighWatermark(topicPartition, epoch, hwm, state, triggeredByEpochChange);
        if (this.validator().isInSync(isr)) {
            this.validator().validateLocalLogEndOffset(topicPartition, epoch, hwm, state);
        }
        state.highWatermark_$eq(hwm);
    }

    public boolean materializeHighWatermarkChanges$default$6() {
        return false;
    }

    private StartOffsetChangeEvent makeGenericStartOffsetChangeEvent(TopicPartition id, int epoch, long startOffset, long hwm, Set<Object> isr) {
        return StartOffsetChangeEvent$.MODULE$.apply(id, epoch, hwm, startOffset, (byte)RetentionType$.MODULE$.Other().id(), -1L, isr);
    }

    private Set<Object> makeGenericStartOffsetChangeEvent$default$5() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1}));
    }

    public void materializeStartOffset(StartOffsetChangeEvent event, PartitionState state, boolean validateHWM) {
        if (state.startOffset() <= 0L) {
            state.committedStartOffset_$eq(event.logStartOffset());
        } else if (this.validator().isInSync(event.isr()) && state.committedStartOffset() < event.logStartOffset()) {
            this.validator().validateDBLogStartOffset(event, state);
            this.validator().validateLocalLogStartOffset(event.topicPartition(), event.logStartOffset());
        }
        if (validateHWM) {
            this.materializeHighWatermarkChanges(event.topicPartition(), event.epoch(), event.highWatermark(), event.isr(), state, this.materializeHighWatermarkChanges$default$6());
        }
        state.startOffset_$eq(event.logStartOffset());
    }

    public boolean materializeStartOffset$default$3() {
        return false;
    }

    public void materializeEpochChangeEvent(EpochChangeEvent epochChangeEvent, PartitionState state) {
        this.validator().validateDBEpochChange(epochChangeEvent, state);
        this.materializeHighWatermarkChanges(epochChangeEvent.topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.highWatermark(), epochChangeEvent.isr(), state, true);
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(epochChangeEvent.topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.logStartOffset(), epochChangeEvent.highWatermark(), epochChangeEvent.isr()), state, this.materializeStartOffset$default$3());
        this.validator().validateEpochChangeWithLocal(epochChangeEvent);
        state.epochChain().put((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()), (Object)BoxesRunTime.boxToLong((long)epochChangeEvent.firstOffset()));
        state.latestEpoch_$eq(epochChangeEvent.epoch());
    }

    public void materializeISRExpandEvent(IsrExpandEvent isrExpandEvent, PartitionState state) {
        if (Utils$.MODULE$.getBrokerId(this.replicaManager) != isrExpandEvent.expandBrokerId()) {
            return;
        }
        this.validator().validateEpochChainWithLocal(isrExpandEvent.topicPartition(), state);
    }

    public void materializeRetentionChangeEvent(RetentionChangeEvent retentionChangeEvent, PartitionState state) {
        if (retentionChangeEvent.timeMs() != state.retentionMs() || retentionChangeEvent.size() != state.retentionSz()) {
            state.committedStartOffset_$eq(state.startOffset());
        }
        state.retentionSz_$eq(retentionChangeEvent.size());
        state.retentionMs_$eq(retentionChangeEvent.timeMs());
    }

    public DurabilityEventsMaterialize(ReplicaManager replicaManager, DurabilityDB db, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.db = db;
        Logging.$init$(this);
        this.validator = new Validator(replicaManager, reporter, time);
    }
}

