/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db.serdes;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.durability.db.serdes.EpochChain;

public final class PartitionInfo
extends Table {
    public static PartitionInfo getRootAsPartitionInfo(ByteBuffer _bb) {
        return PartitionInfo.getRootAsPartitionInfo(_bb, new PartitionInfo());
    }

    public static PartitionInfo getRootAsPartitionInfo(ByteBuffer _bb, PartitionInfo obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public PartitionInfo __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int partition() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public long startOffset() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long highWatermark() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long committedStartOffset() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long externalLostMessages() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long totalMessages() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long retentionTime() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long retentionSize() {
        int o = this.__offset(18);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public EpochChain epochChain(int j) {
        return this.epochChain(new EpochChain(), j);
    }

    public EpochChain epochChain(EpochChain obj, int j) {
        int o = this.__offset(20);
        return o != 0 ? obj.__assign(this.__vector(o) + j * 16, this.bb) : null;
    }

    public int epochChainLength() {
        int o = this.__offset(20);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public static int createPartitionInfo(FlatBufferBuilder builder, int partition, long startOffset, long highWatermark, long committedStartOffset, long externalLostMessages, long totalMessages, long retentionTime, long retentionSize, int epochChainOffset) {
        builder.startObject(9);
        PartitionInfo.addRetentionSize(builder, retentionSize);
        PartitionInfo.addRetentionTime(builder, retentionTime);
        PartitionInfo.addTotalMessages(builder, totalMessages);
        PartitionInfo.addExternalLostMessages(builder, externalLostMessages);
        PartitionInfo.addCommittedStartOffset(builder, committedStartOffset);
        PartitionInfo.addHighWatermark(builder, highWatermark);
        PartitionInfo.addStartOffset(builder, startOffset);
        PartitionInfo.addEpochChain(builder, epochChainOffset);
        PartitionInfo.addPartition(builder, partition);
        return PartitionInfo.endPartitionInfo(builder);
    }

    public static void startPartitionInfo(FlatBufferBuilder builder) {
        builder.startObject(9);
    }

    public static void addPartition(FlatBufferBuilder builder, int partition) {
        builder.addInt(0, partition, 0);
    }

    public static void addStartOffset(FlatBufferBuilder builder, long startOffset) {
        builder.addLong(1, startOffset, 0L);
    }

    public static void addHighWatermark(FlatBufferBuilder builder, long highWatermark) {
        builder.addLong(2, highWatermark, 0L);
    }

    public static void addCommittedStartOffset(FlatBufferBuilder builder, long committedStartOffset) {
        builder.addLong(3, committedStartOffset, 0L);
    }

    public static void addExternalLostMessages(FlatBufferBuilder builder, long externalLostMessages) {
        builder.addLong(4, externalLostMessages, 0L);
    }

    public static void addTotalMessages(FlatBufferBuilder builder, long totalMessages) {
        builder.addLong(5, totalMessages, 0L);
    }

    public static void addRetentionTime(FlatBufferBuilder builder, long retentionTime) {
        builder.addLong(6, retentionTime, 0L);
    }

    public static void addRetentionSize(FlatBufferBuilder builder, long retentionSize) {
        builder.addLong(7, retentionSize, 0L);
    }

    public static void addEpochChain(FlatBufferBuilder builder, int epochChainOffset) {
        builder.addOffset(8, epochChainOffset, 0);
    }

    public static void startEpochChainVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(16, numElems, 8);
    }

    public static int endPartitionInfo(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

