/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.DbTrait;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.TopicState;
import kafka.durability.db.serdes.Header;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.durability.exceptions.DurabilityObjectNotFoundException;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\r\u001a\u0001\u0001B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0007u\u0001!\t\u0001A\u001e\t\u0011y\u0002!\u0019!C\u00013}Ba\u0001\u0011\u0001!\u0002\u0013\u0011\u0004\u0002C!\u0001\u0005\u0004%\t!G \t\r\t\u0003\u0001\u0015!\u00033\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Ca\u0001\u0013\u0001!\u0002\u0013)\u0005\u0002C%\u0001\u0001\u0004%\t&\u0007&\t\u00119\u0003\u0001\u0019!C)3=Ca!\u0016\u0001!B\u0013Y\u0005\"\u0002,\u0001\t\u0003:\u0006\u0002CA\u0006\u0001\t\u0007I\u0011I \t\u000f\u00055\u0001\u0001)A\u0005e!1\u0011q\u0002\u0001\u0005B]Ca!!\b\u0001\t\u00139\u0006\u0002CA\u0010\u0001\u0011\u00053$!\t\t\u0011\u0005\u0015\u0003\u0001\"\u0011\u001c\u0003CAq!a\u0012\u0001\t\u0003\nIeB\u0004\u0002beA\t!a\u0019\u0007\raI\u0002\u0012AA3\u0011\u0019QT\u0003\"\u0001\u0002h!9\u0011\u0011N\u000b\u0005\u0002\u0005-$\u0001\u0004#ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013%B\u0001\u000e\u001c\u0003\t!'M\u0003\u0002\u001d;\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003y\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001C\u001dZ\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)S5\t\u0011$\u0003\u0002+3\t9AI\u0019+sC&$\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001e\u0003\u0015)H/\u001b7t\u0013\t\u0001TFA\u0004M_\u001e<\u0017N\\4\u0002\tA\fG\u000f\u001b\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n!![8\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0005\r&dW-\u0001\u0004=S:LGO\u0010\u000b\u0003yu\u0002\"\u0001\u000b\u0001\t\u000bE\u0012\u0001\u0019\u0001\u001a\u0002\r\u0011\u0014g)\u001b7f+\u0005\u0011\u0014a\u00023c\r&dW\rI\u0001\bi6\u0004h)\u001b7f\u0003!!X\u000e\u001d$jY\u0016\u0004\u0013a\u0002<feNLwN\\\u000b\u0002\u000bB\u0011!ER\u0005\u0003\u000f\u000e\u00121!\u00138u\u0003!1XM]:j_:\u0004\u0013A\u00025fC\u0012,'/F\u0001L!\tAC*\u0003\u0002N3\tAAI\u0019%fC\u0012,'/\u0001\u0006iK\u0006$WM]0%KF$\"\u0001U*\u0011\u0005\t\n\u0016B\u0001*$\u0005\u0011)f.\u001b;\t\u000fQS\u0011\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010J\u0019\u0002\u000f!,\u0017\rZ3sA\u0005Q1\r[3dWB|\u0017N\u001c;\u0015\u0003AC3\u0001D-`!\r\u0011#\fX\u0005\u00037\u000e\u0012a\u0001\u001e5s_^\u001c\bCA\u001a^\u0013\tqFGA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017'\u0002\u0010aW\u0006%\u0001CA1i\u001d\t\u0011g\r\u0005\u0002dG5\tAM\u0003\u0002f?\u00051AH]8pizJ!aZ\u0012\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003O\u000e\nTa\t7q\u007fF,\"!\u001c8\u0016\u0003\u0001$Qa\\\u0010C\u0002Q\u0014\u0011\u0001V\u0005\u0003cJ\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$BA:$\u0003\u0019!\bN]8xgF\u0011Q\u000f\u001f\t\u0003EYL!a^\u0012\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u0010 \b\u0003EiL!a_\u0012\u0002\u000fA\f7m[1hK&\u0011QP \u0002\n)\"\u0014xn^1cY\u0016T!a_\u00122\u0011\r\n\t!a\u0001\u0002\u0006Mt1AIA\u0002\u0013\t\u00198%M\u0003#E\r\n9AA\u0003tG\u0006d\u0017-\r\u0002'9\u0006\u0019A-\u001b:\u0002\t\u0011L'\u000fI\u0001\be\u0016\u001cwN^3sQ\u0011y\u0011,a\u00052\ry\u0001\u0017QCA\u000ec\u0019\u0019C\u000e]A\fcFB1%!\u0001\u0002\u0004\u0005e1/M\u0003#E\r\n9!\r\u0002'9\u00061\u0011N\\5u\t\n\u000b!dZ3u)>\u0004\u0018n\u0019)beRLG/[8og\u001a{'/Q;eSR,\"!a\t\u0011\r\u0005\u0015\u00121FA\u0018\u001d\r\t9C\u001f\b\u0004G\u0006%\u0012\"\u0001\u0013\n\u0007\u00055bPA\u0002TKF\u0004B!!\r\u0002B5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0004d_6lwN\u001c\u0006\u0004=\u0005e\"\u0002BA\u001e\u0003{\ta!\u00199bG\",'BAA \u0003\ry'oZ\u0005\u0005\u0003\u0007\n\u0019D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002!\u001d,G/\u00117m!\u0006\u0014H/\u001b;j_:\u001c\u0018\u0001\u00054fi\u000eDGk\u001c9jGN#\u0018\r^3t)\t\tY\u0005E\u0004\u0002N\u0005]\u0003-a\u0017\u000e\u0005\u0005=#\u0002BA)\u0003'\nq!\\;uC\ndWMC\u0002\u0002V\r\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI&a\u0014\u0003\u000f!\u000b7\u000f['baB\u0019\u0001&!\u0018\n\u0007\u0005}\u0013D\u0001\u0006U_BL7m\u0015;bi\u0016\fA\u0002R;sC\nLG.\u001b;z\t\n\u0003\"\u0001K\u000b\u0014\u0007U\t3\u0006\u0006\u0002\u0002d\u0005)\u0011\r\u001d9msR\u0019A(!\u001c\t\u000bE:\u0002\u0019\u0001\u001a)\u000b]\t\t(a \u0011\t\tR\u00161\u000f\t\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u001c\u0002\t1\fgnZ\u0005\u0005\u0003{\n9H\u0001\nJY2,w-\u00197BG\u000e,7o]#se>\u0014\u0018G\u0002\u0010a\u0003\u0003\u000b9)\r\u0004$YB\f\u0019)]\u0019\tG\u0005\u0005\u00111AACgF*!EI\u0012\u0002\bE\u001aa%a\u001d)\u000b]\tY)a%\u0011\t\tR\u0016Q\u0012\t\u0004g\u0005=\u0015bAAIi\t)b)\u001b7f\u001d>$hi\\;oI\u0016C8-\u001a9uS>t\u0017G\u0002\u0010a\u0003+\u000bY*\r\u0004$YB\f9*]\u0019\tG\u0005\u0005\u00111AAMgF*!EI\u0012\u0002\bE\u001aa%!$)\t]I\u0016qT\u0019\u0007=\u0001\f\t+a*2\r\rb\u0007/a)rc!\u0019\u0013\u0011AA\u0002\u0003K\u001b\u0018'\u0002\u0012#G\u0005\u001d\u0011G\u0001\u0014]\u0001")
public class DurabilityDB
implements DbTrait,
Logging {
    private final File dbFile;
    private final File tmpFile;
    private final int version;
    private DbHeader header;
    private final File dir;
    private Logger logger;
    private String logIdent;
    private final int kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH;
    private final int DURABILITY_EVENTS_TOPIC_PARTITION_COUNT;
    private volatile Enumeration.Value status;
    private final HashMap<String, TopicState> topicStates;
    private volatile boolean bitmap$0;

    public static DurabilityDB apply(File file) throws IOException, FileNotFoundException, IllegalAccessError {
        return DurabilityDB$.MODULE$.apply(file);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public DbHeader recoverHeader(Header hdr) {
        return DbTrait.recoverHeader$(this, hdr);
    }

    @Override
    public Option<PartitionState> fetchPartitionState(TopicPartition id) throws DurabilityDBNotReadyException {
        return DbTrait.fetchPartitionState$(this, id);
    }

    @Override
    public void deletePartition(TopicPartition id) {
        DbTrait.deletePartition$(this, id);
    }

    @Override
    public Option<PartitionState> addPartition(TopicPartition id, PartitionState state) throws DurabilityDBNotReadyException, DurabilityObjectNotFoundException {
        return DbTrait.addPartition$(this, id, state);
    }

    @Override
    public ByteBuffer serialize() {
        return DbTrait.serialize$(this);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        DbTrait.deserialize$(this, buffer);
    }

    @Override
    public boolean isOnline() {
        return DbTrait.isOnline$(this);
    }

    @Override
    public void updateDurabilityTopicPartitionOffset(int partition, long offset) throws DurabilityDBNotReadyException, IndexOutOfBoundsException {
        DbTrait.updateDurabilityTopicPartitionOffset$(this, partition, offset);
    }

    @Override
    public Seq<Object> getDurabilityTopicPartitionOffsets() {
        return DbTrait.getDurabilityTopicPartitionOffsets$(this);
    }

    @Override
    public void close() throws IOException {
        DbTrait.close$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH() {
        return this.kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH;
    }

    @Override
    public int DURABILITY_EVENTS_TOPIC_PARTITION_COUNT() {
        return this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT;
    }

    @Override
    public Enumeration.Value status() {
        return this.status;
    }

    @Override
    public void status_$eq(Enumeration.Value x$1) {
        this.status = x$1;
    }

    @Override
    public HashMap<String, TopicState> topicStates() {
        return this.topicStates;
    }

    @Override
    public final void kafka$durability$db$DbTrait$_setter_$kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH_$eq(int x$1) {
        this.kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH = x$1;
    }

    @Override
    public void kafka$durability$db$DbTrait$_setter_$DURABILITY_EVENTS_TOPIC_PARTITION_COUNT_$eq(int x$1) {
        this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT = x$1;
    }

    @Override
    public void kafka$durability$db$DbTrait$_setter_$topicStates_$eq(HashMap<String, TopicState> x$1) {
        this.topicStates = x$1;
    }

    public File dbFile() {
        return this.dbFile;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    private int version() {
        return this.version;
    }

    @Override
    public DbHeader header() {
        return this.header;
    }

    @Override
    public void header_$eq(DbHeader x$1) {
        this.header = x$1;
    }

    @Override
    public synchronized void checkpoint() throws IOException {
        FileChannel channel = FileChannel.open(this.tmpFile().toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        ByteBuffer buffer = this.serialize();
        Utils.writeFully((FileChannel)channel, (long)0L, (ByteBuffer)buffer);
        channel.force(true);
        Utils.atomicMoveWithFallback((Path)this.tmpFile().toPath(), (Path)this.dbFile().toPath());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Checkpoint durability db files with ").append(this.getAllPartitions().length()).append(" partitions").toString());
        channel.close();
    }

    @Override
    public File dir() {
        return this.dir;
    }

    @Override
    public synchronized void recover() throws IOException {
        block8: {
            try (AbstractInterruptibleChannel channel = null;){
                try {
                    channel = FileChannel.open(this.dbFile().toPath(), StandardOpenOption.READ);
                    ByteBuffer buffer = ByteBuffer.allocate((int)((FileChannel)channel).size()).order(ByteOrder.LITTLE_ENDIAN);
                    Utils.readFully((FileChannel)channel, (ByteBuffer)buffer, (long)0L);
                    buffer.flip();
                    this.deserialize(buffer);
                    this.status_$eq(DbStatus$.MODULE$.Online());
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Recovered Durability DB with ").append(this.getAllPartitions().length()).append(" partitions").toString());
                }
                catch (Throwable throwable) {
                    boolean bl = throwable instanceof FileNotFoundException ? true : throwable instanceof NoSuchFileException;
                    if (bl) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("No Durability db found at path ").append(this.dbFile().toPath()).toString());
                        this.initDB();
                        break block8;
                    }
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw throwable;
                }
            }
        }
    }

    private void initDB() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append(" Initializing new durability db at ").append(this.dbFile().toPath()).toString());
        this.header_$eq(new DbHeader(this.version(), 1, (long[])Array$.MODULE$.fill(this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long())));
        this.status_$eq(DbStatus$.MODULE$.Online());
        this.checkpoint();
    }

    @Override
    public synchronized Seq<TopicPartition> getTopicPartitionsForAudit() {
        if (this.isOnline()) {
            return (Seq)this.topicStates().toSeq().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$1._1();
                Seq seq = (Seq)((Seq)((TraversableLike)((TopicState)x0$1._2()).partitions().toSeq().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DurabilityDB.$anonfun$getTopicPartitionsForAudit$2(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)DurabilityDB.$anonfun$getTopicPartitionsForAudit$3(x0$3)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)partitionNum -> DurabilityDB.$anonfun$getTopicPartitionsForAudit$4(topicName, BoxesRunTime.unboxToInt((Object)partitionNum)), Seq$.MODULE$.canBuildFrom());
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
        }
        return Nil$.MODULE$;
    }

    @Override
    public synchronized Seq<TopicPartition> getAllPartitions() {
        if (this.isOnline()) {
            return (Seq)this.topicStates().toSeq().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$1._1();
                Seq seq = (Seq)((Seq)((TopicState)x0$1._2()).partitions().toSeq().map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)DurabilityDB.$anonfun$getAllPartitions$2(x0$2)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)partitionNum -> DurabilityDB.$anonfun$getAllPartitions$3(topicName, BoxesRunTime.unboxToInt((Object)partitionNum)), Seq$.MODULE$.canBuildFrom());
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
        }
        return Nil$.MODULE$;
    }

    @Override
    public HashMap<String, TopicState> fetchTopicStates() {
        return this.topicStates();
    }

    public static final /* synthetic */ boolean $anonfun$getTopicPartitionsForAudit$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((PartitionState)x0$2._2()).latestLocalEpoch() > -1;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$getTopicPartitionsForAudit$3(Tuple2 x0$3) {
        void var1_1;
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        int partition = x0$3._1$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ TopicPartition $anonfun$getTopicPartitionsForAudit$4(String topicName$1, int partitionNum) {
        return new TopicPartition(topicName$1, partitionNum);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$getAllPartitions$2(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int partition = x0$2._1$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$3(String topicName$2, int partitionNum) {
        return new TopicPartition(topicName$2, partitionNum);
    }

    public DurabilityDB(File path) {
        DbTrait.$init$(this);
        Logging.$init$(this);
        this.dbFile = new File(path, "durability.db");
        this.tmpFile = new File(path, "durability.db.tmp");
        this.version = 1;
        this.header = null;
        this.dir = path;
    }
}

