/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditJob;
import kafka.durability.audit.AuditManager$;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.DeleteMessagesRequest;
import kafka.durability.audit.DeletePartitionRequest;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.EpochChangeRequest;
import kafka.durability.audit.HighWatermarkUpdateRequest;
import kafka.durability.audit.ISRExpandRequest;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.RetentionConfigChangeRequest;
import kafka.durability.audit.StartOffsetChangeRequest;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.events.RetentionChangeEvent$;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.durability.topic.DurabilityTopicManager$;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t-g\u0001\u0002\"D\u0001)C\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t/\u0002\u0011\t\u0011)A\u0005'\"A\u0001\f\u0001BC\u0002\u0013\u0005\u0011\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003[\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002\u00039\u0001\u0005\u000b\u0007I\u0011A9\t\u0011y\u0004!\u0011!Q\u0001\nIDaa \u0001\u0005\u0002\u0005\u0005\u0001\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\ty\u0002\u0001Q\u0001\n\u0005E\u0001bCA\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0003GA1\"a\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.!Y\u0011\u0011\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0013\u0011)\tY\u0004\u0001a\u0001\n\u0003\u0019\u0015Q\b\u0005\u000b\u0003\u000b\u0002\u0001\u0019!C\u0001\u0007\u0006\u001d\u0003\u0002CA&\u0001\u0001\u0006K!a\u0010\t\u0015\u00055\u0003\u00011A\u0005\u0002\r\u000by\u0005\u0003\u0006\u0002b\u0001\u0001\r\u0011\"\u0001D\u0003GB\u0001\"a\u001a\u0001A\u0003&\u0011\u0011\u000b\u0005\u000b\u0003S\u0002!\u0019!C\u0001\u0007\u0006-\u0004\u0002CAA\u0001\u0001\u0006I!!\u001c\t\u0015\u0005\r\u0005A1A\u0005\u0002\r\u000b)\t\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0011BAD\u0011)\t)\n\u0001a\u0001\n\u0003\u0019\u0015q\u0013\u0005\u000b\u0003?\u0003\u0001\u0019!C\u0001\u0007\u0006\u0005\u0006\u0002CAS\u0001\u0001\u0006K!!'\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"I\u0011\u0011\u0018\u0001C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\u0003\u007f\u0003\u0001\u0015!\u0003\u00024\"I\u0011\u0011\u0019\u0001C\u0002\u0013\u0005\u00111\u0019\u0005\t\u0003\u001b\u0004\u0001\u0015!\u0003\u0002F\"I\u0011q\u001a\u0001C\u0002\u0013\u0005\u0011\u0011\u001b\u0005\t\u00033\u0004\u0001\u0015!\u0003\u0002T\"I\u00111\u001c\u0001C\u0002\u0013\u0005\u0011Q\u001c\u0005\t\u0003W\u0004\u0001\u0015!\u0003\u0002`\"Q\u0011Q\u001e\u0001C\u0002\u0013\u00051)a<\t\u0011\u0005u\b\u0001)A\u0005\u0003cDq!a@\u0001\t\u0003\u0011\t\u0001\u0003\u0006\u0003\n\u0001\u0011\r\u0011\"\u0001D\u0005\u0003A\u0001Ba\u0003\u0001A\u0003%!1\u0001\u0005\b\u0005\u001b\u0001A\u0011\tB\b\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005\u001fAqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u0003.\u0001!IAa\f\t\u0011\te\u0002\u0001\"\u0001D\u0005wAqA!\u0010\u0001\t\u0013\u0011y\u0001C\u0004\u0003@\u0001!IA!\u0011\t\u0011\t\r\u0003\u0001\"\u0001D\u0005\u000bB!Ba\u0015\u0001#\u0003%\ta\u0011B+\u0011)\u0011Y\u0007AI\u0001\n\u0003\u0019%Q\u000b\u0005\u000b\u0005[\u0002\u0011\u0013!C\u0001\u0007\nU\u0003b\u0002B8\u0001\u0011%!q\u0002\u0005\b\u0005c\u0002A\u0011\u0002B:\u0011!\u0011i\b\u0001C\u0001\u0007\n}\u0004B\u0003BD\u0001E\u0005I\u0011A\"\u0003V!9!\u0011\u0012\u0001\u0005\n\t-\u0005b\u0002BK\u0001\u0011%!q\u0013\u0005\b\u0005;\u0003A\u0011\u0002BP\u0011%\u0011\u0019\u000bAI\u0001\n\u0013\u0011)\u0006\u0003\u0005\u0003&\u0002!\ta\u0011B\b\u0011\u001d\u00119\u000b\u0001C\u0001\u0005S;qA!-D\u0011\u0003\u0011\u0019L\u0002\u0004C\u0007\"\u0005!Q\u0017\u0005\u0007\u007f~\"\tAa1\t\u000f\t\u0015w\b\"\u0003\u0003H\na\u0011)\u001e3ji6\u000bg.Y4fe*\u0011A)R\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003\r\u001e\u000b!\u0002Z;sC\nLG.\u001b;z\u0015\u0005A\u0015!B6bM.\f7\u0001A\n\u0003\u0001-\u0003\"\u0001T(\u000e\u00035S!AT$\u0002\u000bU$\u0018\u000e\\:\n\u0005Ak%AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\faaY8oM&<W#A*\u0011\u0005Q+V\"A\"\n\u0005Y\u001b%!\u0006#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;D_:4\u0017nZ\u0001\bG>tg-[4!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001e\u000baa]3sm\u0016\u0014\u0018BA0]\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0013i&,'o\u00142kK\u000e$8\u000b^8sK>\u0003H\u000fE\u0002dM\"l\u0011\u0001\u001a\u0006\u0002K\u0006)1oY1mC&\u0011q\r\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!B:u_J,'BA7H\u0003\u0011!\u0018.\u001a:\n\u0005=T'a\u0004+jKJ|%M[3diN#xN]3\u0002\tQLW.Z\u000b\u0002eB\u00111\u000f`\u0007\u0002i*\u0011a*\u001e\u0006\u0003m^\faaY8n[>t'B\u0001%y\u0015\tI(0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002w\u0006\u0019qN]4\n\u0005u$(\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0001P5oSRtDCCA\u0002\u0003\u000b\t9!!\u0003\u0002\fA\u0011A\u000b\u0001\u0005\u0006#\"\u0001\ra\u0015\u0005\u00061\"\u0001\rA\u0017\u0005\u0006C\"\u0001\rA\u0019\u0005\u0006a\"\u0001\rA]\u0001\rgR\f'\u000f^%ogR\fg\u000e^\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001c5\u0011\u0011Q\u0003\u0006\u0004a\u0006]!BAA\r\u0003\u0011Q\u0017M^1\n\t\u0005u\u0011Q\u0003\u0002\b\u0013:\u001cH/\u00198u\u00035\u0019H/\u0019:u\u0013:\u001cH/\u00198uA\u0005q\u0011-\u001e3ji*{'\r\u00165sK\u0006$WCAA\u0013!\r\u0019\u0018qE\u0005\u0004\u0003S!(aC&bM.\fG\u000b\u001b:fC\u0012\f!#Y;eSRTuN\u0019+ie\u0016\fGm\u0018\u0013fcR!\u0011qFA\u001b!\r\u0019\u0017\u0011G\u0005\u0004\u0003g!'\u0001B+oSRD\u0011\"a\u000e\r\u0003\u0003\u0005\r!!\n\u0002\u0007a$\u0013'A\bbk\u0012LGOS8c)\"\u0014X-\u00193!\u00031\u0019WO\u001d:f]RTuNY%e+\t\ty\u0004E\u0002d\u0003\u0003J1!a\u0011e\u0005\rIe\u000e^\u0001\u0011GV\u0014(/\u001a8u\u0015>\u0014\u0017\nZ0%KF$B!a\f\u0002J!I\u0011qG\b\u0002\u0002\u0003\u0007\u0011qH\u0001\u000eGV\u0014(/\u001a8u\u0015>\u0014\u0017\n\u001a\u0011\u0002-\u0005,H-\u001b;K_\n\u001cu.\u001e8uI><h\u000eT1uG\",\"!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005m\u0013qC\u0001\u0005kRLG.\u0003\u0003\u0002`\u0005U#AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u001bCV$\u0017\u000e\u001e&pE\u000e{WO\u001c;e_^tG*\u0019;dQ~#S-\u001d\u000b\u0005\u0003_\t)\u0007C\u0005\u00028I\t\t\u00111\u0001\u0002R\u00059\u0012-\u001e3ji*{'mQ8v]R$wn\u001e8MCR\u001c\u0007\u000eI\u0001\u001cQ&<\u0007nV1uKJl\u0017M]6Va\u0012\fG/\u001a*fcV,7\u000f^:\u0016\u0005\u00055\u0004\u0003CA*\u0003_\n\u0019(a\u001f\n\t\u0005E\u0014Q\u000b\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BA;\u0003oj\u0011!^\u0005\u0004\u0003s*(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004)\u0006u\u0014bAA@\u0007\nQ\u0002*[4i/\u0006$XM]7be.,\u0006\u000fZ1uKJ+\u0017/^3ti\u0006a\u0002.[4i/\u0006$XM]7be.,\u0006\u000fZ1uKJ+\u0017/^3tiN\u0004\u0013AE1vI&$(+Z9vKN$8/U;fk\u0016,\"!a\"\u0011\r\u0005M\u0013\u0011RAG\u0013\u0011\tY)!\u0016\u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\u0011\u0007Q\u000by)C\u0002\u0002\u0012\u000e\u00131#Q;eSRl\u0015M\\1hKJ\u0014V-];fgR\f1#Y;eSR\u0014V-];fgR\u001c\u0018+^3vK\u0002\n!\u0003\\1ti\n\u000bGo\u00195Fm\u0016tG\u000fV5nKV\u0011\u0011\u0011\u0014\t\u0004G\u0006m\u0015bAAOI\n!Aj\u001c8h\u0003Ya\u0017m\u001d;CCR\u001c\u0007.\u0012<f]R$\u0016.\\3`I\u0015\fH\u0003BA\u0018\u0003GC\u0011\"a\u000e\u001a\u0003\u0003\u0005\r!!'\u0002'1\f7\u000f\u001e\"bi\u000eDWI^3oiRKW.\u001a\u0011)\u0007i\tI\u000bE\u0002d\u0003WK1!!,e\u0005!1x\u000e\\1uS2,\u0017!B4fi\u0012\u0013UCAAZ!\u0011\t),a/\u000e\u0005\u0005]&bAA]\u000b\u0006\u0011AMY\u0005\u0005\u0003{\u000b9L\u0001\u0007EkJ\f'-\u001b7jif$%)A\u0002eE\u0002\na\"\\3ue&\u001c7/T1oC\u001e,'/\u0006\u0002\u0002FB!\u0011qYAe\u001b\u0005)\u0015bAAf\u000b\nAB)\u001e:bE&d\u0017\u000e^=NKR\u0014\u0018nY:NC:\fw-\u001a:\u0002\u001f5,GO]5dg6\u000bg.Y4fe\u0002\n\u0001B]3q_J$XM]\u000b\u0003\u0003'\u00042\u0001VAk\u0013\r\t9n\u0011\u0002\u000e\u0003V$\u0017\u000e\u001e*fa>\u0014H/\u001a:\u0002\u0013I,\u0007o\u001c:uKJ\u0004\u0013aC7bi\u0016\u0014\u0018.\u00197ju\u0016,\"!a8\u0011\t\u0005\u0005\u0018q]\u0007\u0003\u0003GT1!!:F\u0003=i\u0017\r^3sS\u0006d\u0017N_1uS>t\u0017\u0002BAu\u0003G\u00141\u0004R;sC\nLG.\u001b;z\u000bZ,g\u000e^:NCR,'/[1mSj,\u0017\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0004\u0013a\u0003;pa&\u001c7i\u001c8gS\u001e,\"!!=\u0011\t\u0005M\u0018\u0011`\u0007\u0003\u0003kT1!a>F\u0003\u0015!x\u000e]5d\u0013\u0011\tY0!>\u0003+\u0011+(/\u00192jY&$\u0018\u0010V8qS\u000e\u001cuN\u001c4jO\u0006aAo\u001c9jG\u000e{gNZ5hA\u0005yq-\u001a;U_BL7-T1oC\u001e,'/\u0006\u0002\u0003\u0004A!\u00111\u001fB\u0003\u0013\u0011\u00119!!>\u0003-\u0011+(/\u00192jY&$\u0018\u0010V8qS\u000el\u0015M\\1hKJ\fA\u0002^8qS\u000el\u0015M\\1hKJ\fQ\u0002^8qS\u000el\u0015M\\1hKJ\u0004\u0013a\u0001:v]R\u0011\u0011q\u0006\u0015\u0004S\tM\u0001\u0003\u0002B\u000b\u00057i!Aa\u0006\u000b\t\te\u0011qC\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u001e\t]!\u0001C(wKJ\u0014\u0018\u000eZ3\u0002\r\u0011|wk\u001c:lQ\rQ#1C\u0001\u0014g\u000eDW\rZ;mK:+w/Q;eSRTuN\u0019\u000b\u0003\u0005O\u00012\u0001\u0016B\u0015\u0013\r\u0011Yc\u0011\u0002\t\u0003V$\u0017\u000e\u001e&pE\u0006\u0001\u0012N\\5uS\u0006dG)\u001a7bs\u0012{g.\u001a\u000b\u0005\u0005c\u00119\u0004E\u0002d\u0005gI1A!\u000ee\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u001d\u0017A\u0002I\f\u0011d\u001d5pk2$7k\u00195fIVdWMT3x\u0003V$\u0017\u000e\u001e&pER\u0011!\u0011G\u0001\u0015gR|\u0007/\u0012=jgRLgnZ!vI&$(j\u001c2\u0002/M,g\u000eZ#wK:$()\u0019;dQRKW.Z\"iK\u000e\\WC\u0001B\u0019\u00031!wnV8sW\u0006\u001bG/^1m)!\tyCa\u0012\u0003L\t=\u0003\"\u0003B%aA\u0005\t\u0019\u0001B\u0019\u0003A\u00198\r[3ek2,\u0017)\u001e3ji*{'\rC\u0005\u0003NA\u0002\n\u00111\u0001\u00032\u0005Qa\r\\;tQ\n\u000bGo\u00195\t\u0013\tE\u0003\u0007%AA\u0002\tE\u0012aC;tK2{7-\u00197M_\u001e\fa\u0003Z8X_J\\\u0017i\u0019;vC2$C-\u001a4bk2$H%M\u000b\u0003\u0005/RCA!\r\u0003Z-\u0012!1\f\t\u0005\u0005;\u00129'\u0004\u0002\u0003`)!!\u0011\rB2\u0003%)hn\u00195fG.,GMC\u0002\u0003f\u0011\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IGa\u0018\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fe_^{'o[!diV\fG\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003Y!wnV8sW\u0006\u001bG/^1mI\u0011,g-Y;mi\u0012\u001a\u0014!\u00059s_\u000e,7o]#wK:$()\u0019;dQ\u0006a\u0011n\u001d*fO&\u001cH/\u001a:fIR1!\u0011\u0007B;\u0005sBqAa\u001e6\u0001\u0004\t\u0019(\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\tmT\u00071\u0001\u0002@\u0005)Q\r]8dQ\u0006I1/\u001a8e\u000bZ,g\u000e\u001e\u000b\u0007\u0005c\u0011\tI!\"\t\u000f\t\re\u00071\u0001\u0002\u000e\u00061!/Z2pe\u0012D\u0011B!\u00157!\u0003\u0005\rA!\r\u0002'M,g\u000eZ#wK:$H\u0005Z3gCVdG\u000f\n\u001a\u0002#I,w-[:uKJ\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u00020\t5\u0005b\u0002BBq\u0001\u0007!q\u0012\t\u0004)\nE\u0015b\u0001BJ\u0007\nA\"+Z4jgR,'\u000fU1si&$\u0018n\u001c8SKF,Xm\u001d;\u0002\u001f\u0011,G.\u001a;f!\u0006\u0014H/\u001b;j_:$B!a\f\u0003\u001a\"9!1T\u001dA\u0002\u00055\u0015a\u0002:fcV,7\u000f^\u0001\u0012M2,8\u000f\u001b*fG>\u0014Hm])vKV,G\u0003BA\u0018\u0005CC\u0011B!\u0015;!\u0003\u0005\rA!\r\u00027\u0019dWo\u001d5SK\u000e|'\u000fZ:Rk\u0016,X\r\n3fM\u0006,H\u000e\u001e\u00132\u0003\u001d\u0019G.Z1okB\fqbZ3u#V,W/\u001a3Fm\u0016tGo]\u000b\u0003\u0005W\u0003ra\u0019BW\u0003\u007f\tI*C\u0002\u00030\u0012\u0014a\u0001V;qY\u0016\u0014\u0014\u0001D!vI&$X*\u00198bO\u0016\u0014\bC\u0001+@'\u0015y$q\u0017B_!\r\u0019'\u0011X\u0005\u0004\u0005w#'AB!osJ+g\rE\u0002U\u0005\u007fK1A!1D\u0005E\tU\u000fZ5u\u001b\u0006t\u0017mZ3s)J\f\u0017\u000e\u001e\u000b\u0003\u0005g\u000bAbZ3u\t\u0006LxJZ-fCJ$B!a\u0010\u0003J\")\u0001/\u0011a\u0001e\u0002")
public class AuditManager
extends ShutdownableThread {
    private final DurabilityAuditConfig config;
    private final ReplicaManager replicaManager;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final Time time;
    private final Instant startInstant;
    private KafkaThread auditJobThread;
    private int currentJobId;
    private CountDownLatch auditJobCountdownLatch;
    private final ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests;
    private final LinkedBlockingQueue<AuditManagerRequest> auditRequestsQueue;
    private volatile long lastBatchEventTime;
    private final DurabilityDB db;
    private final DurabilityMetricsManager metricsManager;
    private final AuditReporter reporter;
    private final DurabilityEventsMaterialize materialize;
    private final DurabilityTopicConfig topicConfig;
    private final DurabilityTopicManager topicManager;

    public static void submitAuditRequest(AuditManagerRequest auditManagerRequest) {
        AuditManager$.MODULE$.submitAuditRequest(auditManagerRequest);
    }

    public static boolean stopAuditManager$default$1() {
        return AuditManager$.MODULE$.stopAuditManager$default$1();
    }

    public static void stopAuditManager(boolean bl) {
        AuditManager$.MODULE$.stopAuditManager(bl);
    }

    public static void startAuditManager() {
        AuditManager$.MODULE$.startAuditManager();
    }

    public static Option<AuditManager> initialize(DurabilityAuditConfig durabilityAuditConfig, ReplicaManager replicaManager, Option<TierObjectStore> option, Time time) {
        return AuditManager$.MODULE$.initialize(durabilityAuditConfig, replicaManager, option, time);
    }

    public static ConcurrentHashMap<TopicPartition, RegisterPartitionRequest> pendingRegistration() {
        return AuditManager$.MODULE$.pendingRegistration();
    }

    public static void instance_$eq(AuditManager auditManager) {
        AuditManager$.MODULE$.instance_$eq(auditManager);
    }

    public static AuditManager instance() {
        return AuditManager$.MODULE$.instance();
    }

    public DurabilityAuditConfig config() {
        return this.config;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Time time() {
        return this.time;
    }

    private Instant startInstant() {
        return this.startInstant;
    }

    private KafkaThread auditJobThread() {
        return this.auditJobThread;
    }

    private void auditJobThread_$eq(KafkaThread x$1) {
        this.auditJobThread = x$1;
    }

    public int currentJobId() {
        return this.currentJobId;
    }

    public void currentJobId_$eq(int x$1) {
        this.currentJobId = x$1;
    }

    public CountDownLatch auditJobCountdownLatch() {
        return this.auditJobCountdownLatch;
    }

    public void auditJobCountdownLatch_$eq(CountDownLatch x$1) {
        this.auditJobCountdownLatch = x$1;
    }

    public ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests() {
        return this.highWatermarkUpdateRequests;
    }

    public LinkedBlockingQueue<AuditManagerRequest> auditRequestsQueue() {
        return this.auditRequestsQueue;
    }

    public long lastBatchEventTime() {
        return this.lastBatchEventTime;
    }

    public void lastBatchEventTime_$eq(long x$1) {
        this.lastBatchEventTime = x$1;
    }

    public DurabilityDB getDB() {
        return DurabilityDB$.MODULE$.apply(this.config().dbPath());
    }

    public DurabilityDB db() {
        return this.db;
    }

    public DurabilityMetricsManager metricsManager() {
        return this.metricsManager;
    }

    public AuditReporter reporter() {
        return this.reporter;
    }

    public DurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    public DurabilityTopicConfig topicConfig() {
        return this.topicConfig;
    }

    public DurabilityTopicManager getTopicManager() {
        return new DurabilityTopicManager(this.topicConfig(), this.db(), this.materialize(), this.config().zkSupplier(), DurabilityTopicManager$.MODULE$.$lessinit$greater$default$5());
    }

    public DurabilityTopicManager topicManager() {
        return this.topicManager;
    }

    @Override
    public void run() {
        this.topicManager().start();
        super.run();
    }

    @Override
    public void doWork() {
        this.doWorkActual(true, this.doWorkActual$default$2(), this.doWorkActual$default$3());
        this.pause(DurabilityAuditConstants$.MODULE$.DURABILITY_JOB_LOOP_WAIT_MS(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private AuditJob scheduleNewAuditJob() {
        void var3_3;
        this.stopExistingAuditJob();
        int newJobId = AuditManager$.MODULE$.kafka$durability$audit$AuditManager$$getDayOfYear(this.time());
        int oldJobId = this.reporter().resetJob(newJobId);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Going to schedule new AuditJob, (").append(oldJobId).append(" -> ").append(newJobId).append(")").toString());
        this.auditJobCountdownLatch_$eq(new CountDownLatch(1));
        this.currentJobId_$eq(newJobId);
        AuditJob auditJob = new AuditJob(this.db().getTopicPartitionsForAudit(), this.replicaManager().logManager(), this.auditJobCountdownLatch(), this.reporter(), this.currentJobId(), this.tierObjectStoreOpt, this.time());
        this.auditJobThread_$eq(KafkaThread.nonDaemon((String)new StringBuilder(9).append("AuditJob-").append(this.currentJobId()).toString(), (Runnable)auditJob));
        this.auditJobThread().start();
        return var3_3;
    }

    private boolean initialDelayDone(Time time) {
        Instant now = Instant.ofEpochMilli(time.milliseconds());
        return Duration.between(this.startInstant(), now).toMillis() > (long)DurabilityAuditConstants$.MODULE$.INITIAL_AUDIT_JOB_DELAY_MS() && this.db().getTopicPartitionsForAudit().nonEmpty();
    }

    public boolean shouldScheduleNewAuditJob() {
        boolean bl;
        KafkaThread existingThread;
        Option option = Option$.MODULE$.apply((Object)this.auditJobThread());
        if (option instanceof Some && (existingThread = (KafkaThread)((Some)option).value()).isAlive() && !existingThread.isInterrupted()) {
            bl = false;
        } else {
            int currDay = AuditManager$.MODULE$.kafka$durability$audit$AuditManager$$getDayOfYear(this.time());
            bl = this.auditJobCountdownLatch().getCount() == 0L && (currDay > this.currentJobId() || currDay == 1 && this.currentJobId() >= 365) && this.initialDelayDone(this.time());
        }
        return bl;
    }

    private void stopExistingAuditJob() {
        if (this.auditJobThread() != null && this.auditJobThread().isAlive()) {
            this.auditJobCountdownLatch().countDown();
            this.auditJobThread().interrupt();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("AuditManager cancelled AuditJob with jobId: ").append(this.currentJobId()).toString());
        }
    }

    private boolean sendEventBatchTimeCheck() {
        long currentTimeMs = this.time().milliseconds();
        if (currentTimeMs - this.lastBatchEventTime() >= this.config().batchEventFlushFrequencyMs()) {
            this.lastBatchEventTime_$eq(currentTimeMs);
            return true;
        }
        return false;
    }

    public void doWorkActual(boolean scheduleAuditJob, boolean flushBatch, boolean useLocalLog) {
        if (scheduleAuditJob && this.shouldScheduleNewAuditJob()) {
            this.scheduleNewAuditJob();
        }
        if (this.sendEventBatchTimeCheck() || flushBatch) {
            this.processEventBatch();
            return;
        }
        this.flushRecordsQueue(useLocalLog);
    }

    public boolean doWorkActual$default$1() {
        return false;
    }

    public boolean doWorkActual$default$2() {
        return false;
    }

    public boolean doWorkActual$default$3() {
        return true;
    }

    private void processEventBatch() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Process batchedRequest, auditRequest queue size is ").append(this.highWatermarkUpdateRequests().size()).toString());
        HashMap<TopicPartition, HighWatermarkUpdateRequest> snapshot = new HashMap<TopicPartition, HighWatermarkUpdateRequest>(this.highWatermarkUpdateRequests());
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        for (int size = this.auditRequestsQueue().size(); size > 0 && record != null; --size) {
            if (this.sendEvent(record, this.sendEvent$default$2())) {
                snapshot.remove(record.topicPartition());
            }
            record = this.auditRequestsQueue().poll();
        }
        snapshot.forEach((x0$1, x1$1) -> {
            TopicPartition topicPartition = x0$1;
            HighWatermarkUpdateRequest record = x1$1;
            if (this.isRegistered(record.topicPartition(), record.epoch())) {
                this.topicManager().addDurabilityEvent(OffsetChangeEvent$.MODULE$.apply(topicPartition, record.epoch(), record.hwm(), record.startOffset(), record.isr()));
            }
            this.highWatermarkUpdateRequests().remove(topicPartition);
        });
        snapshot.clear();
        this.db().checkpoint();
    }

    private boolean isRegistered(TopicPartition topicPartition, int epoch) {
        PartitionState state;
        Option<PartitionState> option = this.db().fetchPartitionState(topicPartition);
        boolean bl = option instanceof Some && (state = (PartitionState)((Some)option).value()).isLeader() && (state.latestLocalEpoch() == epoch || epoch == -1);
        return bl;
    }

    public boolean sendEvent(AuditManagerRequest record, boolean useLocalLog) {
        boolean bl;
        DeleteMessagesRequest deleteMessagesRequest;
        ISRExpandRequest iSRExpandRequest;
        RetentionConfigChangeRequest retentionConfigChangeRequest;
        EpochChangeRequest epochChangeRequest;
        None$ none$;
        StartOffsetChangeRequest startOffsetChangeRequest;
        if (record instanceof StartOffsetChangeRequest && this.isRegistered((startOffsetChangeRequest = (StartOffsetChangeRequest)record).topicPartition(), startOffsetChangeRequest.epoch())) {
            Object object;
            Option<Set<Object>> option = Utils$.MODULE$.getIsrIfLeaderPartition(this.replicaManager(), startOffsetChangeRequest.topicPartition());
            if (option instanceof Some) {
                Set isr = (Set)((Some)option).value();
                object = new Some((Object)StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set<Object>)isr));
            } else {
                object = !useLocalLog ? new Some((Object)StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))))) : None$.MODULE$;
            }
            none$ = object;
        } else if (record instanceof EpochChangeRequest && this.isRegistered((epochChangeRequest = (EpochChangeRequest)record).topicPartition(), -1)) {
            none$ = new Some((Object)EpochChangeEvent$.MODULE$.apply(epochChangeRequest.topicPartition(), epochChangeRequest.firstOffset(), epochChangeRequest.epoch(), epochChangeRequest.highWaterMark(), epochChangeRequest.startOffset(), epochChangeRequest.isr()));
        } else if (record instanceof RetentionConfigChangeRequest && this.isRegistered((retentionConfigChangeRequest = (RetentionConfigChangeRequest)record).topicPartition(), retentionConfigChangeRequest.epoch())) {
            none$ = new Some((Object)RetentionChangeEvent$.MODULE$.apply(retentionConfigChangeRequest.topicPartition(), retentionConfigChangeRequest.retentionMs(), retentionConfigChangeRequest.retentionSz(), retentionConfigChangeRequest.epoch(), -1L, -1L));
        } else if (record instanceof ISRExpandRequest && this.isRegistered((iSRExpandRequest = (ISRExpandRequest)record).topicPartition(), iSRExpandRequest.epoch())) {
            none$ = new Some((Object)IsrExpandEvent$.MODULE$.apply(iSRExpandRequest.topicPartition(), iSRExpandRequest.brokerId(), iSRExpandRequest.epoch(), -1L, -1L));
        } else if (record instanceof DeleteMessagesRequest && this.isRegistered((deleteMessagesRequest = (DeleteMessagesRequest)record).topicPartition(), deleteMessagesRequest.epoch())) {
            none$ = new Some((Object)DeleteRecordsEvent$.MODULE$.apply(deleteMessagesRequest.topicPartition(), deleteMessagesRequest.startOffset(), deleteMessagesRequest.epoch(), deleteMessagesRequest.highWatermark(), deleteMessagesRequest.startOffset(), deleteMessagesRequest.isr()));
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Rejected record for sending as event ").append(record).append(", ignoring").toString());
            none$ = None$.MODULE$;
        }
        if (none$ instanceof Some) {
            AbstractDurabilityEvent e = (AbstractDurabilityEvent)((Some)none$).value();
            this.topicManager().addDurabilityEvent(e);
            this.highWatermarkUpdateRequests().remove(record.topicPartition());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean sendEvent$default$2() {
        return true;
    }

    private void registerPartition(RegisterPartitionRequest record) {
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicPartition());
        if (option instanceof Some) {
            PartitionState state = (PartitionState)((Some)option).value();
            if (state.latestLocalEpoch() >= record.epoch()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Durability Registration event from stale/registered replica for ").append(record.topicPartition()).append(" for ").append(record.epoch()).append(" with leader flag set to ").append(record.isLeader()).append(". The existing db state is ").append(state).toString());
                return;
            }
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        PartitionState state = (PartitionState)this.db().fetchPartitionState(record.topicPartition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> PartitionState$.MODULE$.apply(record.topicPartition().partition()));
        state.latestLocalEpoch_$eq(record.epoch());
        state.isLeader_$eq(record.isLeader());
        this.db().addPartition(record.topicPartition(), state);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Durability registration for ").append(record.topicPartition()).append(" ").append(record.epoch()).append(" ").append(record.isLeader()).append(" is done.").toString());
    }

    private void deletePartition(AuditManagerRequest request) {
        this.highWatermarkUpdateRequests().remove(request.topicPartition());
        this.db().deletePartition(request.topicPartition());
    }

    private void flushRecordsQueue(boolean useLocalLog) {
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        for (int count = 0; record != null && count < DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP(); ++count) {
            if (record instanceof RegisterPartitionRequest) {
                RegisterPartitionRequest registerPartitionRequest = (RegisterPartitionRequest)record;
                this.registerPartition(registerPartitionRequest);
            } else if (record instanceof DeletePartitionRequest) {
                DeletePartitionRequest deletePartitionRequest = (DeletePartitionRequest)record;
                this.deletePartition(deletePartitionRequest);
            } else {
                this.sendEvent(record, useLocalLog);
            }
            record = this.auditRequestsQueue().poll();
        }
    }

    private boolean flushRecordsQueue$default$1() {
        return true;
    }

    public void cleanup() {
        try {
            this.stopExistingAuditJob();
            this.processEventBatch();
            this.flushRecordsQueue(this.flushRecordsQueue$default$1());
            this.topicManager().shutdown();
            this.metricsManager().shutdown();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "AuditManager cleanup complete");
            return;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received error while cleaning up AuditManager", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public Tuple2<Object, Object> getQueuedEvents() {
        return new Tuple2.mcIJ.sp(this.auditRequestsQueue().size(), (long)this.highWatermarkUpdateRequests().size());
    }

    public AuditManager(DurabilityAuditConfig config, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        this.config = config;
        this.replicaManager = replicaManager;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.time = time;
        super("AuditManager", true);
        this.startInstant = Instant.ofEpochMilli(time.milliseconds());
        this.currentJobId = 0;
        this.auditJobCountdownLatch = new CountDownLatch(0);
        this.highWatermarkUpdateRequests = new ConcurrentHashMap();
        this.auditRequestsQueue = new LinkedBlockingQueue(DurabilityAuditConstants$.MODULE$.DurabilityRecordMaxQueueSize());
        this.lastBatchEventTime = time.milliseconds();
        this.db = this.getDB();
        this.metricsManager = DurabilityMetricsManager$.MODULE$.apply(Integer.toString(config.brokerId()), config.metrics(), time);
        this.reporter = AuditReporter$.MODULE$.apply(this.metricsManager());
        this.materialize = new DurabilityEventsMaterialize(replicaManager, this.db(), this.reporter(), time);
        this.topicConfig = new DurabilityTopicConfig(config.interBrokerClientConfigs(), DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), config.topicPartitionCount(), config.topicReplicationFactor(), config.brokerId(), config.clusterId(), DurabilityAuditConstants$.MODULE$.DURABILITY_CONSUMER_POLL_DURATION_MS(), Predef$.MODULE$.int2Integer(DurabilityAuditConstants$.MODULE$.DURABILITY_PRODUCER_REQUEST_TIMEOUT_MS()), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS());
        this.topicManager = this.getTopicManager();
    }
}

