/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r]v!B*U\u0011\u0003Yf!B/U\u0011\u0003q\u0006\"B3\u0002\t\u00031\u0007bB4\u0002\u0005\u0004%\t\u0001\u001b\u0005\u0007Y\u0006\u0001\u000b\u0011B5\t\u000f5\f!\u0019!C\u0001Q\"1a.\u0001Q\u0001\n%Dqa\\\u0001C\u0002\u0013\u0005\u0001\u000e\u0003\u0004q\u0003\u0001\u0006I!\u001b\u0005\bc\u0006\u0011\r\u0011\"\u0001i\u0011\u0019\u0011\u0018\u0001)A\u0005S\"91/\u0001b\u0001\n\u0003!\bbBA\u0001\u0003\u0001\u0006I!\u001e\u0005\t\u0003\u0007\t!\u0019!C\u0001i\"9\u0011QA\u0001!\u0002\u0013)\b\u0002CA\u0004\u0003\t\u0007I\u0011\u0001;\t\u000f\u0005%\u0011\u0001)A\u0005k\"A\u00111B\u0001C\u0002\u0013\u0005A\u000fC\u0004\u0002\u000e\u0005\u0001\u000b\u0011B;\u0007\u000bu#\u0006!a\u0004\t\u0013\u0005u1C!A!\u0002\u0013I\u0007BCA\u0010'\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011qE\n\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005U2C!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002>M\u0011\t\u0011)A\u0005\u0003\u007fA!\"a\u0016\u0014\u0005\u0003\u0005\u000b\u0011BA-\u0011\u0019)7\u0003\"\u0001\u0002d\u00151\u00111O\n\u0001\u0003kB\u0011\"!'\u0014\u0005\u0004%I!a'\t\u0011\u0005U6\u0003)A\u0005\u0003;C\u0011\"a.\u0014\u0005\u0004%I!!/\t\u0011\u0005\u001d7\u0003)A\u0005\u0003wC!\"!3\u0014\u0005\u0004%\t\u0001VAf\u0011!\t\u0019o\u0005Q\u0001\n\u00055\u0007BCAs'\t\u0007I\u0011\u0001+\u0002h\"A\u0011Q_\n!\u0002\u0013\tI\u000fC\u0006\u0002xN\u0001\r\u00111A\u0005\n\u0005e\bb\u0003B\u0001'\u0001\u0007\t\u0019!C\u0005\u0005\u0007A1B!\u0003\u0014\u0001\u0004\u0005\t\u0015)\u0003\u0002|\"Q!1B\nA\u0002\u0003\u0007I\u0011\u00025\t\u0017\t51\u00031AA\u0002\u0013%!q\u0002\u0005\u000b\u0005'\u0019\u0002\u0019!A!B\u0013I\u0007\"\u0003B\u000f'\t\u0007I\u0011\u0002B\u0010\u0011!\u00119c\u0005Q\u0001\n\t\u0005\u0002\"\u0003B\u0015'\t\u0007I\u0011\u0002B\u0016\u0011!\u0011)d\u0005Q\u0001\n\t5\u0002B\u0003B\u001c'\t\u0007I\u0011\u0001+\u0003 !A!\u0011H\n!\u0002\u0013\u0011\t\u0003C\u0005\u0003<M\u0011\r\u0011\"\u0003\u0003,!A!QH\n!\u0002\u0013\u0011i\u0003C\u0005\u0003@M\u0011\r\u0011\"\u0003\u0003,!A!\u0011I\n!\u0002\u0013\u0011i\u0003\u0003\u0006\u0003DM\u0011\r\u0011\"\u0001U\u0005?A\u0001B!\u0012\u0014A\u0003%!\u0011\u0005\u0005\n\u0005\u000f\u001a\"\u0019!C\u0005\u0005WA\u0001B!\u0013\u0014A\u0003%!Q\u0006\u0005\n\u0005\u0017\u001a\"\u0019!C\u0005\u0005WA\u0001B!\u0014\u0014A\u0003%!Q\u0006\u0005\t\u0005\u001f\u001aB\u0011\u0001+\u0003R!9!1L\n\u0005\u0002\tu\u0003b\u0002B<'\u0011%!\u0011\u0010\u0005\b\u0005\u0013\u001bB\u0011\u0002BF\u0011\u001d\u0011\tk\u0005C\u0005\u0005GC\u0001Ba\u001e\u0014\t\u0003!&\u0011\u0018\u0005\b\u0005w\u001bB\u0011\u0002B_\u0011\u001d\u00119n\u0005C\u0001\u0005sCqA!7\u0014\t\u0003\u0011Y\u000eC\u0004\u0003\u0000N!\ta!\u0001\t\u000f\r\u001d1\u0003\"\u0003\u0004\n!911C\n\u0005\u0002\rU\u0001bBB\u000e'\u0011\u00051Q\u0004\u0005\b\u0007O\u0019B\u0011AB\u0015\u0011\u001d\u0019ic\u0005C\u0005\u0007_A\u0001b!\u0010\u0014\t\u0003!6q\b\u0005\b\u0007\u0017\u001aB\u0011AB'\u0011\u001d\u0019Yf\u0005C\u0001\u0007;Bqaa\u0017\u0014\t\u0003\u0019\t\u0007C\u0004\u0004hM!IA!/\t\u000f\r%4\u0003\"\u0001\u0004l!I1qR\n\u0012\u0002\u0013\u00051\u0011\u0013\u0005\n\u0007O\u001b\u0012\u0013!C\u0001\u0007SCqa!,\u0014\t\u0003\u0019y\u000bC\u0004\u00046N!\tA!/\u0002/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014(BA+W\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005]C\u0016aC2p_J$\u0017N\\1u_JT\u0011!W\u0001\u0006W\u000647.Y\u0002\u0001!\ta\u0016!D\u0001U\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'o\u0005\u0002\u0002?B\u0011\u0001mY\u0007\u0002C*\t!-A\u0003tG\u0006d\u0017-\u0003\u0002eC\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A.\u0002?\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5/F\u0001j!\t\u0001'.\u0003\u0002lC\n\u0019\u0011J\u001c;\u0002A\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5\u000fI\u0001#\t\u00164\u0017-\u001e7u)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.T:\u0002G\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005QC)\u001a4bk2$\u0018IY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$XM\u001d<bY6\u001b\u0018a\u000b#fM\u0006,H\u000e^!c_J$H+[7fI>+H\u000f\u0016:b]N\f7\r^5p]NLe\u000e^3sm\u0006dWj\u001d\u0011\u0002]\u0011+g-Y;miJ+Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINLe\u000e^3sm\u0006dWj]\u00010\t\u00164\u0017-\u001e7u%\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg&sG/\u001a:wC2l5\u000fI\u0001\r\u001b\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0002kB\u0011a/ \b\u0003on\u0004\"\u0001_1\u000e\u0003eT!A\u001f.\u0002\rq\u0012xn\u001c;?\u0013\ta\u0018-\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001?b\u00035iU\r\u001e:jGN<%o\\;qA\u0005qAj\\1e)&lWmU3og>\u0014\u0018a\u0004'pC\u0012$\u0016.\\3TK:\u001cxN\u001d\u0011\u0002\u001bQKW.Z8viN+gn]8s\u00039!\u0016.\\3pkR\u001cVM\\:pe\u0002\n\u0001c\u0015;bi\u0016,%O]8s'\u0016t7o\u001c:\u0002#M#\u0018\r^3FeJ|'oU3og>\u0014\be\u0005\u0003\u0014?\u0006E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]\u0001,A\u0003vi&d7/\u0003\u0003\u0002\u001c\u0005U!a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JI\u0006I1o\u00195fIVdWM\u001d\t\u0005\u0003'\t\u0019#\u0003\u0003\u0002&\u0005U!!C*dQ\u0016$W\u000f\\3s\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_A\u0016AB:feZ,'/\u0003\u0003\u00024\u00055\"A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0007G>tg-[4\u0011\u0007q\u000bI$C\u0002\u0002<Q\u0013\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0003\u0011!\u0018.\\3\u0011\t\u0005\u0005\u00131K\u0007\u0003\u0003\u0007RA!a\u0006\u0002F)!\u0011qIA%\u0003\u0019\u0019w.\\7p]*\u0019\u0011,a\u0013\u000b\t\u00055\u0013qJ\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0013aA8sO&!\u0011QKA\"\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB!\u00111LA0\u001b\t\tiF\u0003\u0003\u0002X\u0005\u0015\u0013\u0002BA1\u0003;\u0012q!T3ue&\u001c7\u000f\u0006\b\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny'!\u001d\u0011\u0005q\u001b\u0002BBA\u000f5\u0001\u0007\u0011\u000eC\u0004\u0002 i\u0001\r!!\t\t\u000f\u0005\u001d\"\u00041\u0001\u0002*!9\u0011Q\u0007\u000eA\u0002\u0005]\u0002bBA\u001f5\u0001\u0007\u0011q\b\u0005\b\u0003/R\u0002\u0019AA-\u0005Y\u0019VM\u001c3Uq:l\u0015M]6feN\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003\u00041\u0002x%\fY(a\"\u0002\u000e\u0006M\u0015bAA=C\nIa)\u001e8di&|g\u000e\u000e\t\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)!\u0011\u0011QA#\u0003!\u0011X-];fgR\u001c\u0018\u0002BAC\u0003\u007f\u0012\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u!\ra\u0016\u0011R\u0005\u0004\u0003\u0017#&a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007c\u0001/\u0002\u0010&\u0019\u0011\u0011\u0013+\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\t\u0004A\u0006U\u0015bAALC\n!QK\\5u\u00031\u0019\b.\u001e;uS:<Gi\\<o+\t\ti\n\u0005\u0003\u0002 \u0006EVBAAQ\u0015\u0011\t\u0019+!*\u0002\r\u0005$x.\\5d\u0015\u0011\t9+!+\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002,\u00065\u0016\u0001B;uS2T!!a,\u0002\t)\fg/Y\u0005\u0005\u0003g\u000b\tKA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000eg\",H\u000f^5oO\u0012{wO\u001c\u0011\u0002\u0013M$\u0018\r^3M_\u000e\\WCAA^!\u0011\ti,a1\u000e\u0005\u0005}&\u0002BAa\u0003K\u000bQ\u0001\\8dWNLA!!2\u0002@\n1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7.\u0001\u0006ti\u0006$X\rT8dW\u0002\n\u0011\u0003\\8bI&tw\rU1si&$\u0018n\u001c8t+\t\ti\r\u0005\u0004\u0002P\u0006e\u0017Q\\\u0007\u0003\u0003#TA!a5\u0002V\u00069Q.\u001e;bE2,'bAAlC\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0017\u0011\u001b\u0002\u0004'\u0016$\bc\u0001/\u0002`&\u0019\u0011\u0011\u001d+\u0003EQ\u0013\u0018M\\:bGRLwN\u001c)beRLG/[8o\u0003:$G*Z1eKJ,\u0005o\\2i\u0003Iaw.\u00193j]\u001e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u00021Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1DC\u000eDW-\u0006\u0002\u0002jB9\u0011qZAvS\u0006=\u0018\u0002BAw\u0003#\u00141!T1q!\ra\u0016\u0011_\u0005\u0004\u0003g$&!\u0006+y]6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u000b:$(/_\u0001\u001aiJ\fgn]1di&|g.T3uC\u0012\fG/Y\"bG\",\u0007%\u0001\u0014sKR\u0014\u0018.\u001a<f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R,\"!a?\u0011\t\u0001\fi0[\u0005\u0004\u0003\u007f\f'!\u0003$v]\u000e$\u0018n\u001c81\u0003)\u0012X\r\u001e:jKZ,GK]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e^0%KF$B!a%\u0003\u0006!I!qA\u0013\u0002\u0002\u0003\u0007\u00111`\u0001\u0004q\u0012\n\u0014a\n:fiJLWM^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi\u0002\na\u0004\u001e:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0002EQ\u0014\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$x\fJ3r)\u0011\t\u0019J!\u0005\t\u0011\t\u001d\u0001&!AA\u0002%\fq\u0004\u001e:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;!Q\rI#q\u0003\t\u0004A\ne\u0011b\u0001B\u000eC\nAao\u001c7bi&dW-A\nqCJ$\u0018\u000e^5p]2{\u0017\rZ*f]N|'/\u0006\u0002\u0003\"A!\u00111\fB\u0012\u0013\u0011\u0011)#!\u0018\u0003\rM+gn]8s\u0003Q\u0001\u0018M\u001d;ji&|g\u000eT8bIN+gn]8sA\u0005AR.\u0019=Pa\u0016tG\u000b\u001f8US6,W*\u001a;sS\u000et\u0015-\\3\u0016\u0005\t5\u0002\u0003\u0002B\u0018\u0005ci!!!\u0012\n\t\tM\u0012Q\t\u0002\u000b\u001b\u0016$(/[2OC6,\u0017!G7bq>\u0003XM\u001c+y]RKW.Z'fiJL7MT1nK\u0002\n\u0001\u0004\u001e:b]N\f7\r^5p]RKW.Z8viN+gn]8s\u0003e!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;TK:\u001cxN\u001d\u0011\u0002+QLW.Z8viJ\u000bG/Z'fiJL7MT1nK\u00061B/[7f_V$(+\u0019;f\u001b\u0016$(/[2OC6,\u0007%\u0001\fuS6,w.\u001e;D_VtG/T3ue&\u001cg*Y7f\u0003]!\u0018.\\3pkR\u001cu.\u001e8u\u001b\u0016$(/[2OC6,\u0007%\u0001\tti\u0006$X-\u0012:s_J\u001cVM\\:pe\u0006\t2\u000f^1uK\u0016\u0013(o\u001c:TK:\u001cxN\u001d\u0011\u00021M$\u0018\r^3FeJ|'OU1uK6+GO]5d\u001d\u0006lW-A\rti\u0006$X-\u0012:s_J\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!G:uCR,WI\u001d:pe\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\f!d\u001d;bi\u0016,%O]8s\u0007>,h\u000e^'fiJL7MT1nK\u0002\n1#\u00193e\u0019>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:$b!a%\u0003T\t]\u0003B\u0002B+u\u0001\u0007\u0011.A\u0006qCJ$\u0018\u000e^5p]&#\u0007B\u0002B-u\u0001\u0007\u0011.\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006!B/[7fI>+H\u000f\u0016:b]N\f7\r^5p]N$\"Aa\u0018\u0011\r\t\u0005$1\u000eB9\u001d\u0011\u0011\u0019Ga\u001a\u000f\u0007a\u0014)'C\u0001c\u0013\r\u0011I'Y\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iGa\u001c\u0003\u0011%#XM]1cY\u0016T1A!\u001bb!\ra&1O\u0005\u0004\u0005k\"&!\t+sC:\u001c\u0018m\u0019;j_:\fG.\u00133B]\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#q_\u000eD\u0017!\b:f[>4X-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0015\r\u0005M%1\u0010BC\u0011\u001d\u0011i\b\u0010a\u0001\u0005\u007f\nA\u0003\u001e:b]N\f7\r^5p]B\u000b'\u000f^5uS>t\u0007\u0003\u0002B\u0018\u0005\u0003KAAa!\u0002F\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002BDy\u0001\u0007\u0011q^\u0001\u0016ibtW*\u001a;bI\u0006$\u0018mQ1dQ\u0016,e\u000e\u001e:z\u00031\u0019\bn\\;mI\u0016C\b/\u001b:f)\u0019\u0011iIa%\u0003\u0018B\u0019\u0001Ma$\n\u0007\tE\u0015MA\u0004C_>dW-\u00198\t\u000f\tUU\b1\u0001\u0002\b\u0006YA\u000f\u001f8NKR\fG-\u0019;b\u0011\u001d\u0011I*\u0010a\u0001\u00057\u000bQbY;se\u0016tG\u000fV5nK6\u001b\bc\u00011\u0003\u001e&\u0019!qT1\u0003\t1{gnZ\u0001\u0016[\u0006L(-Z!qa\u0016tG-\u0012=qSJ\fG/[8o)!\u0011iI!*\u0003(\n]\u0006b\u0002BK}\u0001\u0007\u0011q\u0011\u0005\b\u0005Ss\u0004\u0019\u0001BV\u00039\u0011XmY8sIN\u0014U/\u001b7eKJ\u0004BA!,\u000346\u0011!q\u0016\u0006\u0005\u0005c\u000b)%\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005k\u0013yK\u0001\u000bNK6|'/\u001f*fG>\u0014Hm\u001d\"vS2$WM\u001d\u0005\b\u00053s\u0004\u0019\u0001BN)\t\t\u0019*A\u0015xe&$X\rV8nEN$xN\\3t\r>\u0014X\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u000b\t\u0003'\u0013yL!1\u0003N\"9!Q\u0010!A\u0002\t}\u0004b\u0002Bb\u0001\u0002\u0007!QY\u0001\u0014Kb\u0004\u0018N]3e\r>\u0014\b+\u0019:uSRLwN\u001c\t\u0007\u0005C\u0012YGa2\u0011\u0007q\u0013I-C\u0002\u0003LR\u0013!\u0006\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ\"p_J$\u0017N\\1u_J,\u0005o\\2i\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003P\u0002\u0003\rA!5\u0002!Q|WNY:u_:,'+Z2pe\u0012\u001c\b\u0003\u0002BW\u0005'LAA!6\u00030\niQ*Z7pef\u0014VmY8sIN\fq$\u001a8bE2,GK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o\u0003M9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f)\u0011\u0011iNa?\u0011\u0011\t\u0005$q\u001cBr\u0005_LAA!9\u0003p\t1Q)\u001b;iKJ\u0004BA!:\u0003l6\u0011!q\u001d\u0006\u0005\u0005S\f)%\u0001\u0005qe>$xnY8m\u0013\u0011\u0011iOa:\u0003\r\u0015\u0013(o\u001c:t!\u0015\u0001'\u0011\u001fB{\u0013\r\u0011\u00190\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007q\u001390C\u0002\u0003zR\u0013adQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195B]\u0012$\u0006P\\'fi\u0006$\u0017\r^1\t\r\tu(\t1\u0001v\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017A\b9viR\u0013\u0018M\\:bGRLwN\\*uCR,\u0017J\u001a(pi\u0016C\u0018n\u001d;t)\u0011\u0019\u0019a!\u0002\u0011\u0011\t\u0005$q\u001cBr\u0005kDqA!&D\u0001\u0004\t9)\u0001\u0010hKR\fe\u000eZ'bs\n,\u0017\t\u001a3Ue\u0006t7/Y2uS>t7\u000b^1uKR1!Q\\B\u0006\u0007\u001bAaA!@E\u0001\u0004)\bbBB\b\t\u0002\u00071\u0011C\u0001\u0016GJ,\u0017\r^3e)btW*\u001a;bI\u0006$\u0018m\u00149u!\u0015\u0001'\u0011_AD\u0003q1\u0018\r\\5eCR,GK]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN$BA!$\u0004\u0018!11\u0011D#A\u0002%\fA\u0002\u001e=o)&lWm\\;u\u001bN\fq\u0003\u001e:b]N\f7\r^5p]R{\u0007/[2D_:4\u0017nZ:\u0016\u0005\r}\u0001\u0003BB\u0011\u0007Gi!!!+\n\t\r\u0015\u0012\u0011\u0016\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\u00049beRLG/[8o\r>\u0014HcA5\u0004,!1!Q`$A\u0002U\fq\u0003\\8bIR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\r\rE2qGB\u001e!\u001d\t\u0019ba\rv\u0003\u000fKAa!\u000e\u0002\u0016\t!\u0001k\\8m\u0011\u001d\u0019I\u0004\u0013a\u0001\u0005\u007f\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0003Z!\u0003\r![\u0001\u001dC\u0012$Gj\\1eK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t)>\u001c\u0015m\u00195f)!\t\u0019j!\u0011\u0004F\r\u001d\u0003BBB\"\u0013\u0002\u0007\u0011.A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:DaA!\u0017J\u0001\u0004I\u0007bBB%\u0013\u0002\u00071\u0011G\u0001\u0013Y>\fG-\u001a3Ue\u0006t7/Y2uS>t7/\u0001\u0013m_\u0006$GK]1og\u0006\u001cG/[8og\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)!\t\u0019ja\u0014\u0004R\rM\u0003B\u0002B+\u0015\u0002\u0007\u0011\u000e\u0003\u0004\u0003Z)\u0003\r!\u001b\u0005\b\u0007+R\u0005\u0019AB,\u00039\u0019XM\u001c3Uq:l\u0015M]6feN\u00042a!\u0017\u001c\u001b\u0005\u0019\u0012A\n:f[>4X\r\u0016:b]N\f7\r^5p]N4uN\u001d+y]R{\u0007/[2QCJ$\u0018\u000e^5p]R!\u00111SB0\u0011\u0019\u0011)f\u0013a\u0001SR1\u00111SB2\u0007KBaA!\u0016M\u0001\u0004I\u0007B\u0002B-\u0019\u0002\u0007\u0011.\u0001\u0018wC2LG-\u0019;f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RL5o\u0015;bE2,\u0017AF1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4\u0015\u001d\u0005M5QNB8\u0007c\u001a)ha \u0004\u0006\"1!Q (A\u0002UDaA!\u0017O\u0001\u0004I\u0007bBB:\u001d\u0002\u0007\u0011QR\u0001\f]\u0016<X*\u001a;bI\u0006$\u0018\rC\u0004\u0004x9\u0003\ra!\u001f\u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007c\u00021\u0004|\t\r\u00181S\u0005\u0004\u0007{\n'!\u0003$v]\u000e$\u0018n\u001c82\u0011%\u0019\tI\u0014I\u0001\u0002\u0004\u0019\u0019)\u0001\u0007sKR\u0014\u0018p\u00148FeJ|'\u000fE\u0004a\u0007w\u0012\u0019O!$\t\u0013\r\u001de\n%AA\u0002\r%\u0015A\u00042vM\u001a,'oU;qa2LWM\u001d\t\u0005\u0003\u0003\u001aY)\u0003\u0003\u0004\u000e\u0006\r#A\u0004\"vM\u001a,'oU;qa2LWM]\u0001!CB\u0004XM\u001c3Ue\u0006t7/Y2uS>tGk\u001c'pO\u0012\"WMZ1vYR$S'\u0006\u0002\u0004\u0014*\"11QBKW\t\u00199\n\u0005\u0003\u0004\u001a\u000e\rVBABN\u0015\u0011\u0019ija(\u0002\u0013Ut7\r[3dW\u0016$'bABQC\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001561\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001I1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4%I\u00164\u0017-\u001e7uIY*\"aa++\t\r%5QS\u0001\bgR\f'\u000f^;q)\u0019\t\u0019j!-\u00044\"9\u0011q_)A\u0002\u0005m\bb\u0002Bl#\u0002\u0007!QR\u0001\tg\",H\u000fZ8x]\u0002")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final Metrics metrics;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock kafka$coordinator$transaction$TransactionStateManager$$stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private final MetricName maxOpenTxnTimeMetricName;
    private final Sensor transactionTimeoutSensor;
    private final MetricName timeoutRateMetricName;
    private final MetricName timeoutCountMetricName;
    private final Sensor stateErrorSensor;
    private final MetricName stateErrorRateMetricName;
    private final MetricName stateErrorCountMetricName;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String StateErrorSensor() {
        return TransactionStateManager$.MODULE$.StateErrorSensor();
    }

    public static String TimeoutSensor() {
        return TransactionStateManager$.MODULE$.TimeoutSensor();
    }

    public static String LoadTimeSensor() {
        return TransactionStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return TransactionStateManager$.MODULE$.MetricsGroup();
    }

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    public ReentrantReadWriteLock kafka$coordinator$transaction$TransactionStateManager$$stateLock() {
        return this.kafka$coordinator$transaction$TransactionStateManager$$stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    private MetricName maxOpenTxnTimeMetricName() {
        return this.maxOpenTxnTimeMetricName;
    }

    public Sensor transactionTimeoutSensor() {
        return this.transactionTimeoutSensor;
    }

    private MetricName timeoutRateMetricName() {
        return this.timeoutRateMetricName;
    }

    private MetricName timeoutCountMetricName() {
        return this.timeoutCountMetricName;
    }

    public Sensor stateErrorSensor() {
        return this.stateErrorSensor;
    }

    private MetricName stateErrorRateMetricName() {
        return this.stateErrorRateMetricName;
    }

    private MetricName stateErrorCountMetricName() {
        return this.stateErrorCountMetricName;
    }

    /*
     * WARNING - void declaration
     */
    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        Iterable iterable;
        void inReadLock_lock;
        long now = this.time.milliseconds();
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void removeExpiredTransactionalIds() {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$7(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeExpiredTransactionalIds(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable & scala.Serializable)x$1 -> (CoordinatorEpochAndTxnMetadata)x$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(this.config.transactionLogSegmentBytes()));
        props.put(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), this.config.transactionLogPlacementConstraints());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    /*
     * WARNING - void declaration
     */
    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<AbstractLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    void inReadLock_lock;
                    ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
                    if (CoreUtils$.MODULE$ == null) {
                        throw null;
                    }
                    Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    if (!bl) break;
                    AbstractFetchDataInfo abstractFetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true, false);
                    if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                        throw new IllegalStateException("Unexpected tiered segment for __transaction_state topic");
                    }
                    FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(125).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions, currOffset, batch, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable & scala.Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void loadTransactions$1_inWriteLock_lock;
            long loadTransactions$1_schedulerTimeMs = $this.time.milliseconds() - scheduleStartMs;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition).append(" at epoch ").append(coordinatorEpoch).toString());
            this.validateTransactionTopicPartitionCountIsStable();
            Pool<String, TransactionMetadata> loadTransactions$1_loadedTransactions = this.loadTransactionMetadata(topicPartition, coordinatorEpoch);
            long loadTransactions$1_endTimeMs = $this.time.milliseconds();
            long loadTransactions$1_totalLoadingTimeMs = loadTransactions$1_endTimeMs - scheduleStartMs;
            this.partitionLoadSensor().record((double)loadTransactions$1_totalLoadingTimeMs, loadTransactions$1_endTimeMs, false);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("Finished loading ").append(loadTransactions$1_loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(loadTransactions$1_totalLoadingTimeMs).append(" milliseconds, of which ").append(loadTransactions$1_schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
            ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock loadTransactions$1_inWriteLock_inLock_lock = loadTransactions$1_inWriteLock_lock.writeLock();
            loadTransactions$1_inWriteLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$4(this, partitionAndLeaderEpoch, topicPartition, coordinatorEpoch, loadTransactions$1_loadedTransactions, sendTxnMarkers);
            }
            finally {
                loadTransactions$1_inWriteLock_inLock_lock.unlock();
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).toString());
        }, this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(previouslyDeterminedPartitionCount).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError, BufferSupplier bufferSupplier) {
        void inReadLock_lock;
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$appendTransactionToLog$13(this, transactionalId, responseCallback, coordinatorEpoch, newMetadata, recordsPerPartition, bufferSupplier, topicPartition, retryOnError);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$5));
    }

    public BufferSupplier appendTransactionToLog$default$6() {
        return BufferSupplier.NO_CACHING;
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
        }
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.metrics.removeMetric(this.maxOpenTxnTimeMetricName());
        this.metrics.removeSensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        this.metrics.removeSensor(TransactionStateManager$.MODULE$.TimeoutSensor());
        this.metrics.removeSensor(TransactionStateManager$.MODULE$.StateErrorSensor());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$2, Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$2 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$2) {
        return (Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Iterable iterable = (Iterable)((TraversableLike)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$2, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String txnId = (String)x0$3._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Object)((Some)option).value());
            long currentTimeMs = $this.time.milliseconds();
            Integer maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = (ListBuffer)ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(scala.math.package$.MODULE$.min(16384, Predef$.MODULE$.Integer2int(maxBatchSize))), (CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)Predef$.MODULE$.Integer2int(maxBatchSize));
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.flushRecordsBuilder$1(transactionPartition$1, expired, recordsBuilder);
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.flushRecordsBuilder$1(transactionPartition$1, expired, recordsBuilder);
                return;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(156).append("Transaction expiration for partition ").append(transactionPartition$1).append(" failed because the log ").append("config was not available, which likely means the partition is not online or is no longer local.").toString());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, int partitionId, TxnMetadataCacheEntry partitionCacheEntry) {
        TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
        $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(partitionId, partitionCacheEntry) -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, BoxesRunTime.unboxToInt((Object)partitionId), partitionCacheEntry);
            return BoxedUnit.UNIT;
        };
        Map<Object, TxnMetadataCacheEntry> map = Implicits$.MODULE$.MapExtensionMethods($this.transactionMetadataCache());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = $this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(responses);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$7(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        long x$1 = $this.config.requestTimeoutMs();
        short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
        boolean x$3 = true;
        AppendOrigin$Coordinator$ x$4 = AppendOrigin$Coordinator$.MODULE$;
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionPartition$2), (Object)tombstoneRecords$1)}));
        Function1 & Serializable & scala.Serializable x$6 = (Function1 & Serializable & scala.Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        };
        BufferSupplier x$7 = BufferSupplier.NO_CACHING;
        Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
        $this.replicaManager.appendRecords(x$1, x$2, x$3, x$4, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$7);
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$2) {
        return x$2.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        Left left;
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$2)))) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3)).orElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable & scala.Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId$3, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadata)));
            left = scala.package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable & scala.Serializable)x$3 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$3)));
        } else if (None$.MODULE$.equals(option)) {
            left = scala.package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable & scala.Serializable)() -> "Transaction state log's key should not be null");
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$7(Function4 sendTxnMarkers$1, TransactionalIdCoordinatorEpochAndTransitMetadata txnTransitMetadata) {
        sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                Object t = txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    TransactionState transactionState = txnMetadata.state();
                    Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                    return object;
                });
                return t;
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function4 sendTxnMarkers$1) {
        void inWriteLock_lock;
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition).append(" at epoch ").append(coordinatorEpoch).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("Finished loading ").append(loadTransactions$1_loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(loadTransactions$1_totalLoadingTimeMs).append(" milliseconds, of which ").append(loadTransactions$1_schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
        ReentrantReadWriteLock reentrantReadWriteLock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$4(this, partitionAndLeaderEpoch$2, topicPartition$3, coordinatorEpoch$3, loadedTransactions, sendTxnMarkers$1);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$2;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((TraversableOnce)$this.loadingPartitions().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$4))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2)).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").append("local partition deletion").toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$5).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$5).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(231).append("The cached coordinator epoch for ").append(transactionalId$5).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$5).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$5).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(254).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$5).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(159).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(187).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(173).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var14_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_9) == false : var14_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var15_10 = status.error;
                                var11_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_10) != false));
                                if (var11_11) {
                                    var8_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_13 = Errors.NOT_LEADER_OR_FOLLOWER.equals(var15_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_10) != false;
                                    if (var10_13) {
                                        var8_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_14 = Errors.MESSAGE_TOO_LARGE.equals(var15_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_10) != false;
                                        var8_12 = var9_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_10;
                                    }
                                }
                                v1 = var8_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var16_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_16) == false : var16_16 != null) break block13;
                            var17_17 = false;
                            var18_18 = null;
                            var19_19 = this.getTransactionState(transactionalId$5);
                            if (!(var19_19 instanceof Left)) break block14;
                            err = (Errors)((Left)var19_19).value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block15;
                        }
                        if (!(var19_19 instanceof Right)) break block16;
                        var17_17 = true;
                        var18_18 = (Right)var19_19;
                        var21_21 = (Option)var18_18.value();
                        if (!(var21_21 instanceof Some)) break block16;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_21).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var17_17 || !None$.MODULE$.equals(var24_24 = (Option)var18_18.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block15;
                }
                throw new MatchError(var19_19);
            }
            var25_25 = false;
            var26_26 = null;
            var27_27 = this.getTransactionState(transactionalId$5);
            if (!(var27_27 instanceof Right)) ** GOTO lbl-1000
            var25_25 = true;
            var26_26 = (Right)var27_27;
            var28_28 = (Option)var26_26.value();
            if (var28_28 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_28).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_25 && None$.MODULE$.equals(var31_31 = (Option)var26_26.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var27_27 instanceof Left) {
                error = (Errors)((Left)var27_27).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var27_27);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$appendTransactionToLog$15(TransactionStateManager $this, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = updateCacheCallback$1_status.error;
                            var14_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_9) == false : var14_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)updateCacheCallback$1_status));
                                var15_10 = updateCacheCallback$1_status.error;
                                var11_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_10) != false));
                                if (var11_11) {
                                    var8_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_13 = Errors.NOT_LEADER_OR_FOLLOWER.equals(var15_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_10) != false;
                                    if (var10_13) {
                                        var8_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_14 = Errors.MESSAGE_TOO_LARGE.equals(var15_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_10) != false;
                                        var8_12 = var9_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_10;
                                    }
                                }
                                v1 = var8_12;
                            }
                            updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)updateCacheCallback$1_responseError.elem;
                            var16_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_16) == false : var16_16 != null) break block13;
                            var17_17 = false;
                            var18_18 = null;
                            var19_19 = $this.getTransactionState(transactionalId$5);
                            if (!(var19_19 instanceof Left)) break block14;
                            updateCacheCallback$1_err = (Errors)((Left)var19_19).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)updateCacheCallback$1_err));
                            updateCacheCallback$1_responseError.elem = updateCacheCallback$1_err;
                            break block15;
                        }
                        if (!(var19_19 instanceof Right)) break block16;
                        var17_17 = true;
                        var18_18 = (Right)var19_19;
                        var21_21 = (Option)var18_18.value();
                        if (!(var21_21 instanceof Some)) break block16;
                        updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_21).value();
                        updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata));
                        break block15;
                    }
                    if (!var17_17 || !None$.MODULE$.equals(var24_24 = (Option)var18_18.value())) break block17;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block15;
                }
                throw new MatchError(var19_19);
            }
            var25_25 = false;
            var26_26 = null;
            var27_27 = $this.getTransactionState(transactionalId$5);
            if (!(var27_27 instanceof Right)) ** GOTO lbl-1000
            var25_25 = true;
            var26_26 = (Right)var27_27;
            var28_28 = (Option)var26_26.value();
            if (var28_28 instanceof Some) {
                updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_28).value();
                updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_25 && None$.MODULE$.equals(var31_31 = (Option)var26_26.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError));
            } else if (var27_27 instanceof Left) {
                updateCacheCallback$1_error = (Errors)((Left)var27_27).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (Errors)updateCacheCallback$1_error));
            } else {
                throw new MatchError(var27_27);
            }
        }
        responseCallback$1.apply((Object)((Errors)updateCacheCallback$1_responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, BufferSupplier bufferSupplier$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                long x$1 = newMetadata$1.txnTimeoutMs();
                short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                boolean x$3 = true;
                AppendOrigin$Coordinator$ x$4 = AppendOrigin$Coordinator$.MODULE$;
                Function1 & Serializable & scala.Serializable x$6 = arg_0 -> TransactionStateManager.$anonfun$appendTransactionToLog$15$adapted($this, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1, arg_0);
                Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
                Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
                $this.replicaManager.appendRecords(x$1, x$2, x$3, x$4, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, bufferSupplier$1);
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$5).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$5) {
        return false;
    }

    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.kafka$coordinator$transaction$TransactionStateManager$$stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionLoadSensor = metrics.sensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec"), (MeasurableStat)new Max());
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-avg", TransactionStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec"), (MeasurableStat)new Avg());
        this.maxOpenTxnTimeMetricName = metrics.metricName("active-transaction-total-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time a currently-open transaction has been open");
        metrics.addMetric(this.maxOpenTxnTimeMetricName(), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ TransactionStateManager $outer;

            /*
             * WARNING - void declaration
             */
            public long value(MetricConfig config, long now) {
                long l;
                void inReadLock_lock;
                ReentrantReadWriteLock reentrantReadWriteLock = this.$outer.kafka$coordinator$transaction$TransactionStateManager$$stateLock();
                if (CoreUtils$.MODULE$ == null) {
                    throw null;
                }
                Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
                inReadLock_inLock_lock.lock();
                try {
                    l = $anon$1.$anonfun$value$1(this, now);
                }
                finally {
                    inReadLock_inLock_lock.unlock();
                }
                return l;
            }

            public static final /* synthetic */ boolean $anonfun$value$3(Tuple2 x0$2) {
                boolean bl;
                if (x0$2 != null) {
                    TransactionState transactionState = ((TransactionMetadata)x0$2._2()).state();
                    boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : (PrepareCommit$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)));
                    bl = bl2;
                } else {
                    throw new MatchError(null);
                }
                return bl;
            }

            public static final /* synthetic */ long $anonfun$value$4(Tuple2 x0$3) {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                long l = ((TransactionMetadata)x0$3._2()).txnStartTimestamp();
                return l;
            }

            public static final /* synthetic */ long $anonfun$value$1($anon$1 $this, long now$1) {
                scala.collection.mutable.Iterable startTimestamps = (scala.collection.mutable.Iterable)$this.$outer.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Iterable iterable = (Iterable)((TraversableLike)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$value$3(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$4(x0$3)), Iterable$.MODULE$.canBuildFrom());
                    return iterable;
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
                if (startTimestamps.isEmpty()) {
                    return 0L;
                }
                return Math.max(0L, now$1 - BoxesRunTime.unboxToLong((Object)startTimestamps.min((Ordering)Ordering.Long$.MODULE$)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.coordinator.transaction.TransactionStateManager$$anon$1 long ), $anonfun$value$3$adapted(scala.Tuple2 ), $anonfun$value$4$adapted(scala.Tuple2 ), $anonfun$value$2(scala.Tuple2 )}, serializedLambda);
            }
        });
        this.transactionTimeoutSensor = metrics.sensor(TransactionStateManager$.MODULE$.TimeoutSensor());
        this.timeoutRateMetricName = metrics.metricName("transaction-timeout-rate", TransactionStateManager$.MODULE$.MetricsGroup(), "The rate at which transactions are timed out by the coordinator");
        this.timeoutCountMetricName = metrics.metricName("transaction-timeout-count", TransactionStateManager$.MODULE$.MetricsGroup(), "The total count of transactions timed out by the coordinator");
        this.transactionTimeoutSensor().add((CompoundStat)new Meter(this.timeoutRateMetricName(), this.timeoutCountMetricName()));
        this.stateErrorSensor = metrics.sensor(TransactionStateManager$.MODULE$.StateErrorSensor());
        this.stateErrorRateMetricName = metrics.metricName("transaction-state-error-rate", TransactionStateManager$.MODULE$.MetricsGroup(), "The rate at which state errors occur within the transaction coordinator");
        this.stateErrorCountMetricName = metrics.metricName("transaction-state-error-count", TransactionStateManager$.MODULE$.MetricsGroup(), "The total count of state errors that have occurred within the transaction coordinator");
        this.stateErrorSensor().add((CompoundStat)new Meter(this.stateErrorRateMetricName(), this.stateErrorCountMetricName()));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$appendTransactionToLog$15$adapted(TransactionStateManager $this, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                            var14_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_9) == false : var14_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_status));
                                var15_10 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                                var11_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_10) != false));
                                if (var11_11) {
                                    var8_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_13 = Errors.NOT_LEADER_OR_FOLLOWER.equals(var15_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_10) != false;
                                    if (var10_13) {
                                        var8_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_14 = Errors.MESSAGE_TOO_LARGE.equals(var15_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_10) != false;
                                        var8_12 = var9_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_10;
                                    }
                                }
                                v1 = var8_12;
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem;
                            var16_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_16) == false : var16_16 != null) break block13;
                            var17_17 = false;
                            var18_18 = null;
                            var19_19 = $this.getTransactionState(transactionalId$5);
                            if (!(var19_19 instanceof Left)) break block14;
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err = (Errors)((Left)var19_19).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_err));
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err;
                            break block15;
                        }
                        if (!(var19_19 instanceof Right)) break block16;
                        var17_17 = true;
                        var18_18 = (Right)var19_19;
                        var21_21 = (Option)var18_18.value();
                        if (!(var21_21 instanceof Some)) break block16;
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_21).value();
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata));
                        break block15;
                    }
                    if (!var17_17 || !None$.MODULE$.equals(var24_24 = (Option)var18_18.value())) break block17;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block15;
                }
                throw new MatchError(var19_19);
            }
            var25_25 = false;
            var26_26 = null;
            var27_27 = $this.getTransactionState(transactionalId$5);
            if (!(var27_27 instanceof Right)) ** GOTO lbl-1000
            var25_25 = true;
            var26_26 = (Right)var27_27;
            var28_28 = (Option)var26_26.value();
            if (var28_28 instanceof Some) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_28).value();
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_25 && None$.MODULE$.equals(var31_31 = (Option)var26_26.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError));
            } else if (var27_27 instanceof Left) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_error = (Errors)((Left)var27_27).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_error));
            } else {
                throw new MatchError(var27_27);
            }
        }
        responseCallback$1.apply((Object)((Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem));
        return BoxedUnit.UNIT;
    }
}

