/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r%tA\u0002%J\u0011\u0003IuJ\u0002\u0004R\u0013\"\u0005\u0011J\u0015\u0005\u00063\u0006!\ta\u0017\u0005\u00069\u0006!\t!\u0018\u0005\u00079\u0006!\taa\u0001\t\rq\u000bA\u0011AB\t\u0011\u001d\u0019\u0019#\u0001C\u0001\u0007KAqa!\r\u0002\t\u0003\u0019\u0019\u0004C\u0005\u0004<\u0005\u0011\r\u0011\"\u0003\u0004>!A1\u0011J\u0001!\u0002\u0013\u0019y\u0004C\u0004\u0004L\u0005!\ta!\u0014\t\u0013\rE\u0013!%A\u0005\u0002\rMc!B)J\u0001%{\u0006\u0002\u00034\r\u0005\u000b\u0007I\u0011A4\t\u0011Md!\u0011!Q\u0001\n!D\u0001\u0002\u001e\u0007\u0003\u0002\u0004%\t!\u001e\u0005\ts2\u0011\t\u0019!C\u0001u\"I\u0011\u0011\u0001\u0007\u0003\u0002\u0003\u0006KA\u001e\u0005\n\u0003\u0007a!\u00111A\u0005\u0002UD!\"!\u0002\r\u0005\u0003\u0007I\u0011AA\u0004\u0011%\tY\u0001\u0004B\u0001B\u0003&a\u000f\u0003\u0006\u0002\u000e1\u0011\t\u0019!C\u0001\u0003\u001fA!\"a\u0006\r\u0005\u0003\u0007I\u0011AA\r\u0011)\ti\u0002\u0004B\u0001B\u0003&\u0011\u0011\u0003\u0005\u000b\u0003?a!\u00111A\u0005\u0002\u0005=\u0001BCA\u0011\u0019\t\u0005\r\u0011\"\u0001\u0002$!Q\u0011q\u0005\u0007\u0003\u0002\u0003\u0006K!!\u0005\t\u0015\u0005%BB!a\u0001\n\u0003\tY\u0003\u0003\u0006\u000241\u0011\t\u0019!C\u0001\u0003kA!\"!\u000f\r\u0005\u0003\u0005\u000b\u0015BA\u0017\u0011)\tY\u0004\u0004BA\u0002\u0013\u0005\u0011Q\b\u0005\u000b\u0003\u000bb!\u00111A\u0005\u0002\u0005\u001d\u0003BCA&\u0019\t\u0005\t\u0015)\u0003\u0002@!Q\u0011Q\u000b\u0007\u0003\u0006\u0004%\t!a\u0016\t\u0015\u0005}DB!A!\u0002\u0013\tI\u0006C\u0005\u0002\u00022\u0011\t\u0019!C\u0001k\"Q\u00111\u0011\u0007\u0003\u0002\u0004%\t!!\"\t\u0013\u0005%EB!A!B\u00131\b\"CAG\u0019\t\u0005\r\u0011\"\u0001v\u0011)\ty\t\u0004BA\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003+c!\u0011!Q!\nYDa!\u0017\u0007\u0005\u0002\u0005e\u0005\"CAX\u0019\u0001\u0007I\u0011AAY\u0011%\tI\f\u0004a\u0001\n\u0003\tY\f\u0003\u0005\u0002@2\u0001\u000b\u0015BAZ\u0011%\t\u0019\r\u0004a\u0001\n\u0003\t)\rC\u0005\u0002N2\u0001\r\u0011\"\u0001\u0002P\"A\u00111\u001b\u0007!B\u0013\t9\r\u0003\u0006\u0002V2\u0011\r\u0011\"\u0001J\u0003/D\u0001\"!=\rA\u0003%\u0011\u0011\u001c\u0005\b\u0003gdA\u0011AA{\u0011\u001d\u0011I\u0002\u0004C\u0001\u00057AqAa\n\r\t\u0003\u0011I\u0003C\u0004\u000301!\tA!\r\t\u000f\teB\u0002\"\u0001\u00032!9!1\b\u0007\u0005\u0002\tu\u0002b\u0002B6\u0019\u0011\u0005!Q\u000e\u0005\b\u0005wbA\u0011\u0001B?\u0011\u001d\u0011y\t\u0004C\u0001\u0005#CqA!'\r\t\u0003\u0011Y\nC\u0004\u0003 2!\tA!\r\t\u000f\t\u0005F\u0002\"\u0001\u0002F\"9!1\u0015\u0007\u0005\n\u0005\u0015\u0007b\u0002BS\u0019\u0011%!q\u0015\u0005\b\u0005\u0003dA\u0011\u0001Bb\u0011\u001d\u0011I\r\u0004C\u0005\u0005\u0017DqAa4\r\t\u0013\u0011\t\u000eC\u0004\u0003V2!IAa6\t\u000f\tuG\u0002\"\u0001\u0002F\"9!q\u001c\u0007\u0005B\t\u0005\bb\u0002Br\u0019\u0011\u0005#Q\u001d\u0005\b\u0005WdA\u0011\tBw\u0003M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0015\tQ5*A\u0006ue\u0006t7/Y2uS>t'B\u0001'N\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u00039\u000bQa[1gW\u0006\u0004\"\u0001U\u0001\u000e\u0003%\u00131\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\"!A*\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0017y\u00139P!?\u0003|\nu(q \t\u0003!2\u00192\u0001D*a!\t\tG-D\u0001c\u0015\t\u0019W*A\u0003vi&d7/\u0003\u0002fE\n9Aj\\4hS:<\u0017a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0016\u0003!\u0004\"!\u001b9\u000f\u0005)t\u0007CA6V\u001b\u0005a'BA7[\u0003\u0019a$o\\8u}%\u0011q.V\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002p+\u0006\u0001BO]1og\u0006\u001cG/[8oC2LE\rI\u0001\u000baJ|G-^2fe&#W#\u0001<\u0011\u0005Q;\u0018B\u0001=V\u0005\u0011auN\\4\u0002\u001dA\u0014x\u000eZ;dKJLEm\u0018\u0013fcR\u00111P \t\u0003)rL!!`+\u0003\tUs\u0017\u000e\u001e\u0005\b\u007fB\t\t\u00111\u0001w\u0003\rAH%M\u0001\faJ|G-^2fe&#\u0007%\u0001\bmCN$\bK]8ek\u000e,'/\u00133\u0002%1\f7\u000f\u001e)s_\u0012,8-\u001a:JI~#S-\u001d\u000b\u0004w\u0006%\u0001bB@\u0014\u0003\u0003\u0005\rA^\u0001\u0010Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]%eA\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\"!!\u0005\u0011\u0007Q\u000b\u0019\"C\u0002\u0002\u0016U\u0013Qa\u00155peR\f\u0011\u0003\u001d:pIV\u001cWM]#q_\u000eDw\fJ3r)\rY\u00181\u0004\u0005\t\u007fZ\t\t\u00111\u0001\u0002\u0012\u0005q\u0001O]8ek\u000e,'/\u00129pG\"\u0004\u0013!\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0006)B.Y:u!J|G-^2fe\u0016\u0003xn\u00195`I\u0015\fHcA>\u0002&!Aq0GA\u0001\u0002\u0004\t\t\"\u0001\nmCN$\bK]8ek\u000e,'/\u00129pG\"\u0004\u0013\u0001\u0004;y]RKW.Z8vi6\u001bXCAA\u0017!\r!\u0016qF\u0005\u0004\u0003c)&aA%oi\u0006\u0001B\u000f\u001f8US6,w.\u001e;Ng~#S-\u001d\u000b\u0004w\u0006]\u0002\u0002C@\u001d\u0003\u0003\u0005\r!!\f\u0002\u001bQDh\u000eV5nK>,H/T:!\u0003\u0015\u0019H/\u0019;f+\t\ty\u0004E\u0002Q\u0003\u0003J1!a\u0011J\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-A\u0005ti\u0006$Xm\u0018\u0013fcR\u001910!\u0013\t\u0011}|\u0012\u0011!a\u0001\u0003\u007f\taa\u001d;bi\u0016\u0004\u0003f\u0001\u0011\u0002PA\u0019A+!\u0015\n\u0007\u0005MSK\u0001\u0005w_2\fG/\u001b7f\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cXCAA-!\u0019\tY&!\u001a\u0002j5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0004nkR\f'\r\\3\u000b\u0007\u0005\rT+\u0001\u0006d_2dWm\u0019;j_:LA!a\u001a\u0002^\t\u00191+\u001a;\u0011\t\u0005-\u00141P\u0007\u0003\u0003[RA!a\u001c\u0002r\u000511m\\7n_:T1ATA:\u0015\u0011\t)(a\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI(A\u0002pe\u001eLA!! \u0002n\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003E!\bP\\*uCJ$H+[7fgR\fW\u000e]\u0001\u0016ibt7\u000b^1siRKW.Z:uC6\u0004x\fJ3r)\rY\u0018q\u0011\u0005\b\u007f\u0012\n\t\u00111\u0001w\u0003I!\bP\\*uCJ$H+[7fgR\fW\u000e\u001d\u0011)\u0007\u0015\ny%\u0001\fuq:d\u0015m\u001d;Va\u0012\fG/\u001a+j[\u0016\u001cH/Y7q\u0003i!\bP\u001c'bgR,\u0006\u000fZ1uKRKW.Z:uC6\u0004x\fJ3r)\rY\u00181\u0013\u0005\b\u007f\u001e\n\t\u00111\u0001w\u0003]!\bP\u001c'bgR,\u0006\u000fZ1uKRKW.Z:uC6\u0004\b\u0005K\u0002)\u0003\u001f\"RCXAN\u0003;\u000by*!)\u0002$\u0006\u0015\u0016qUAU\u0003W\u000bi\u000bC\u0003gS\u0001\u0007\u0001\u000eC\u0003uS\u0001\u0007a\u000f\u0003\u0004\u0002\u0004%\u0002\rA\u001e\u0005\b\u0003\u001bI\u0003\u0019AA\t\u0011\u001d\ty\"\u000ba\u0001\u0003#Aq!!\u000b*\u0001\u0004\ti\u0003C\u0004\u0002<%\u0002\r!a\u0010\t\u000f\u0005U\u0013\u00061\u0001\u0002Z!A\u0011\u0011Q\u0015\u0011\u0002\u0003\u0007a\u000f\u0003\u0004\u0002\u000e&\u0002\rA^\u0001\ra\u0016tG-\u001b8h'R\fG/Z\u000b\u0003\u0003g\u0003R\u0001VA[\u0003\u007fI1!a.V\u0005\u0019y\u0005\u000f^5p]\u0006\u0001\u0002/\u001a8eS:<7\u000b^1uK~#S-\u001d\u000b\u0004w\u0006u\u0006\u0002C@,\u0003\u0003\u0005\r!a-\u0002\u001bA,g\u000eZ5oON#\u0018\r^3!Q\ra\u0013qJ\u0001\u0014Q\u0006\u001ch)Y5mK\u0012,\u0005o\\2i\r\u0016t7-Z\u000b\u0003\u0003\u000f\u00042\u0001VAe\u0013\r\tY-\u0016\u0002\b\u0005>|G.Z1o\u0003]A\u0017m\u001d$bS2,G-\u00129pG\"4UM\\2f?\u0012*\u0017\u000fF\u0002|\u0003#D\u0001b \u0018\u0002\u0002\u0003\u0007\u0011qY\u0001\u0015Q\u0006\u001ch)Y5mK\u0012,\u0005o\\2i\r\u0016t7-\u001a\u0011\u0002\t1|7m[\u000b\u0003\u00033\u0004B!a7\u0002n6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\t/A\u0003m_\u000e\\7O\u0003\u0003\u0002d\u0006\u0015\u0018AC2p]\u000e,(O]3oi*!\u0011q]Au\u0003\u0011)H/\u001b7\u000b\u0005\u0005-\u0018\u0001\u00026bm\u0006LA!a<\u0002^\ni!+Z3oiJ\fg\u000e\u001e'pG.\fQ\u0001\\8dW\u0002\na!\u001b8M_\u000e\\W\u0003BA|\u0003{$B!!?\u0003\u0010A!\u00111`A\u007f\u0019\u0001!q!a@3\u0005\u0004\u0011\tAA\u0001U#\u0011\u0011\u0019A!\u0003\u0011\u0007Q\u0013)!C\u0002\u0003\bU\u0013qAT8uQ&tw\rE\u0002U\u0005\u0017I1A!\u0004V\u0005\r\te.\u001f\u0005\t\u0005#\u0011D\u00111\u0001\u0003\u0014\u0005\u0019a-\u001e8\u0011\u000bQ\u0013)\"!?\n\u0007\t]QK\u0001\u0005=Eft\u0017-\\3?\u00035\tG\r\u001a)beRLG/[8ogR\u00191P!\b\t\u000f\t}1\u00071\u0001\u0003\"\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\r\t\r\"QEA5\u001b\t\t\t'\u0003\u0003\u0002h\u0005\u0005\u0014a\u0004:f[>4X\rU1si&$\u0018n\u001c8\u0015\u0007m\u0014Y\u0003C\u0004\u0003.Q\u0002\r!!\u001b\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001\u0002O]3qCJ,gj\u001c+sC:\u001c\u0018\u000e\u001e\u000b\u0003\u0005g\u00012\u0001\u0015B\u001b\u0013\r\u00119$\u0013\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018-A\rqe\u0016\u0004\u0018M]3GK:\u001cW\r\u0015:pIV\u001cWM]#q_\u000eD\u0017!\b9sKB\f'/Z%oGJ,W.\u001a8u!J|G-^2fe\u0016\u0003xn\u00195\u0015\u0011\t}\"Q\fB1\u0005O\u0002\u0002B!\u0011\u0003L\tE#1\u0007\b\u0005\u0005\u0007\u00129ED\u0002l\u0005\u000bJ\u0011AV\u0005\u0004\u0005\u0013*\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005\u001b\u0012yE\u0001\u0004FSRDWM\u001d\u0006\u0004\u0005\u0013*\u0006\u0003\u0002B*\u00053j!A!\u0016\u000b\t\t]\u0013QN\u0001\taJ|Go\\2pY&!!1\fB+\u0005\u0019)%O]8sg\"9!qL\u001cA\u0002\u00055\u0012a\u00048foRCh\u000eV5nK>,H/T:\t\u000f\t\rt\u00071\u0001\u0003f\u0005)R\r\u001f9fGR,G\r\u0015:pIV\u001cWM]#q_\u000eD\u0007#\u0002+\u00026\u0006E\u0001B\u0002B5o\u0001\u0007a/A\bva\u0012\fG/\u001a+j[\u0016\u001cH/Y7q\u0003e\u0001(/\u001a9be\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*pi\u0006$\u0018n\u001c8\u0015\u0015\tM\"q\u000eB:\u0005k\u00129\b\u0003\u0004\u0003ra\u0002\rA^\u0001\u000e]\u0016<\bK]8ek\u000e,'/\u00133\t\u000f\t}\u0003\b1\u0001\u0002.!1!\u0011\u000e\u001dA\u0002YDqA!\u001f9\u0001\u0004\t9-A\bsK\u000e|'\u000f\u001a'bgR,\u0005o\\2i\u0003Q\u0001(/\u001a9be\u0016\fE\r\u001a)beRLG/[8ogR1!1\u0007B@\u0005\u001bCqA!!:\u0001\u0004\u0011\u0019)\u0001\u000bbI\u0012,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0005\u000b\u0013Y)!\u001b\u000e\u0005\t\u001d%\u0002\u0002BE\u0003C\n\u0011\"[7nkR\f'\r\\3\n\t\u0005\u001d$q\u0011\u0005\u0007\u0005SJ\u0004\u0019\u0001<\u0002)A\u0014X\r]1sK\u0006\u0013wN\u001d;Pe\u000e{W.\\5u)\u0019\u0011\u0019Da%\u0003\u0018\"9!Q\u0013\u001eA\u0002\u0005}\u0012\u0001\u00038foN#\u0018\r^3\t\r\t%$\b1\u0001w\u0003=\u0001(/\u001a9be\u0016\u001cu.\u001c9mKR,G\u0003\u0002B\u001a\u0005;CaA!\u001b<\u0001\u00041\u0018a\u00039sKB\f'/\u001a#fC\u0012\f\u0001$[:Qe>$WoY3s\u000bB|7\r[#yQ\u0006,8\u000f^3e\u0003UA\u0017m\u001d)f]\u0012Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\f1\u0003\u001d:fa\u0006\u0014X\r\u0016:b]NLG/[8o)>$\"Ca\r\u0003*\n-&Q\u0016BY\u0005k\u00139La/\u0003@\"9!QS A\u0002\u0005}\u0002B\u0002B9\u007f\u0001\u0007a\u000fC\u0004\u00030~\u0002\r!!\u0005\u0002\u00119,w/\u00129pG\"DqAa-@\u0001\u0004\t\t\"\u0001\u0007oK^d\u0015m\u001d;Fa>\u001c\u0007\u000eC\u0004\u0003`}\u0002\r!!\f\t\u000f\tev\b1\u0001\u0003\u0004\u0006\u0011b.Z<U_BL7\rU1si&$\u0018n\u001c8t\u0011\u0019\u0011il\u0010a\u0001m\u0006!b.Z<Uq:\u001cF/\u0019:u)&lWm\u001d;b[BDaA!\u001b@\u0001\u00041\u0018\u0001F2p[BdW\r^3Ue\u0006t7/\u001b;j_:$v\u000eF\u0002|\u0005\u000bDqAa2A\u0001\u0004\u0011\u0019$A\bue\u0006t7/\u001b;NKR\fG-\u0019;b\u0003I1\u0018\r\\5e!J|G-^2fe\u0016\u0003xn\u00195\u0015\t\u0005\u001d'Q\u001a\u0005\b\u0005\u000f\f\u0005\u0019\u0001B\u001a\u0003Y1\u0018\r\\5e!J|G-^2fe\u0016\u0003xn\u00195Ck6\u0004H\u0003BAd\u0005'DqAa2C\u0001\u0004\u0011\u0019$A\u000euQJ|wo\u0015;bi\u0016$&/\u00198tSRLwN\u001c$bS2,(/\u001a\u000b\u0004w\ne\u0007b\u0002Bn\u0007\u0002\u0007!1G\u0001\u0013ibtGK]1og&$X*\u001a;bI\u0006$\u0018-A\u000eqK:$\u0017N\\4Ue\u0006t7/\u001b;j_:Le\u000e\u0015:pOJ,7o]\u0001\ti>\u001cFO]5oOR\t\u0001.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\u00149\u000fC\u0004\u0003j\u001a\u0003\rA!\u0003\u0002\tQD\u0017\r^\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u0006\u0015\u0004\u0019\tE\bcA1\u0003t&\u0019!Q\u001f2\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0011\u001517\u00011\u0001i\u0011\u0015!8\u00011\u0001w\u0011\u001d\tia\u0001a\u0001\u0003#Aq!!\u000b\u0004\u0001\u0004\ti\u0003\u0003\u0004\u0004\u0002\r\u0001\rA^\u0001\ni&lWm\u001d;b[B$RBXB\u0003\u0007\u000f\u0019Iaa\u0003\u0004\u000e\r=\u0001\"\u00024\u0005\u0001\u0004A\u0007\"\u0002;\u0005\u0001\u00041\bbBA\u0007\t\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003S!\u0001\u0019AA\u0017\u0011\u001d\tY\u0004\u0002a\u0001\u0003\u007fAaa!\u0001\u0005\u0001\u00041H#\u00050\u0004\u0014\rU1qCB\r\u00077\u0019iba\b\u0004\"!)a-\u0002a\u0001Q\")A/\u0002a\u0001m\"1\u00111A\u0003A\u0002YDq!!\u0004\u0006\u0001\u0004\t\t\u0002C\u0004\u0002 \u0015\u0001\r!!\u0005\t\u000f\u0005%R\u00011\u0001\u0002.!9\u00111H\u0003A\u0002\u0005}\u0002BBB\u0001\u000b\u0001\u0007a/A\u0006csR,Gk\\*uCR,G\u0003BA \u0007OAqa!\u000b\u0007\u0001\u0004\u0019Y#\u0001\u0003csR,\u0007c\u0001+\u0004.%\u00191qF+\u0003\t\tKH/Z\u0001\u0012SN4\u0016\r\\5e)J\fgn]5uS>tGCBAd\u0007k\u0019I\u0004C\u0004\u00048\u001d\u0001\r!a\u0010\u0002\u0011=dGm\u0015;bi\u0016DqA!&\b\u0001\u0004\ty$A\nwC2LG\r\u0015:fm&|Wo]*uCR,7/\u0006\u0002\u0004@A9\u0011n!\u0011\u0002@\r\u0015\u0013bAB\"e\n\u0019Q*\u00199\u0011\u000b%\u001c9%a\u0010\n\u0007\u0005\u001d$/\u0001\u000bwC2LG\r\u0015:fm&|Wo]*uCR,7\u000fI\u0001\u0011SN,\u0005o\\2i\u000bbD\u0017-^:uK\u0012$B!a2\u0004P!9\u0011Q\u0002\u0006A\u0002\u0005E\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0004V)\u001aaoa\u0016,\u0005\re\u0003\u0003BB.\u0007Kj!a!\u0018\u000b\t\r}3\u0011M\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u0019V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007O\u001aiFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long lastProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private volatile TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private volatile Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$9() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean isEpochExhausted(short s) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(s);
    }

    public static boolean isValidTransition(TransactionState transactionState, TransactionState transactionState2) {
        return TransactionMetadata$.MODULE$.isValidTransition(transactionState, transactionState2);
    }

    public static TransactionState byteToState(byte by) {
        return TransactionMetadata$.MODULE$.byteToState(by);
    }

    public static TransactionMetadata apply(String string, long l, long l2, short s, short s2, int n, TransactionState transactionState, long l3) {
        return TransactionMetadata$.MODULE$.apply(string, l, l2, s, s2, n, transactionState, l3);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long lastProducerId() {
        return this.lastProducerId;
    }

    public void lastProducerId_$eq(long x$1) {
        this.lastProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T inLock(Function0<T> fun) {
        Object object;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new StringBuilder(154).append("Transaction metadata's current state is ").append(this.state()).append(", and its pending state is ").append(this.pendingState()).append(" ").append("while trying to remove partitions whose txn marker has been sent, this is not expected").toString());
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.lastProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), bumpedEpoch, (short)-1, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Left left;
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringBuilder(56).append("Cannot allocate any more producer epochs for producerId ").append(this.producerId()).toString());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            Right right2;
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Expected producer epoch ").append(expectedEpoch).append(" does not match current ").append("producer epoch ").append(this.producerEpoch()).append(" or previous producer epoch ").append(this.lastProducerEpoch()).toString());
                right2 = package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
            }
            right = right2;
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        if (right instanceof Right && (tuple2 = (Tuple2)right.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            left = package$.MODULE$.Right().apply((Object)this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp));
        } else if (right instanceof Left) {
            Errors err = (Errors)((Left)right).value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)right);
        }
        return left;
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch() : (short)-1, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), l, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        this.hasFailedEpochFence_$eq(false);
        return this.prepareTransitionTo((TransactionState)newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, short newLastEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringBuilder(78).append("Preparing transaction state transition to ").append(newState).append(" ").append("while it already has pending state ").append(this.pendingState().get()).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Illegal new producer id ").append(newProducerId).toString());
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Illegal new producer epoch ").append(newEpoch).toString());
        }
        if (((SetLike)TransactionMetadata$.MODULE$.kafka$coordinator$transaction$TransactionMetadata$$validPreviousStates().apply((Object)newState)).contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, this.producerId(), newEpoch, newLastEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" prepare transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new StringBuilder(125).append("Preparing transaction state transition to ").append(newState).append(" failed since the target state").append(" ").append(newState).append(" is not a valid previous state of the current state ").append(this.state()).toString());
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)this.pendingState().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append(this).append("'s transition to ").append(transitMetadata).append(" failed since pendingState is not defined: this should not happen").toString());
            throw new IllegalStateException(new StringBuilder(95).append("TransactionalId ").append(this.transactionalId()).append(" ").append("completing transaction state transition while it does not have a pending state").toString());
        });
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
            return;
        }
        if (Empty$.MODULE$.equals(toState)) {
            if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                this.producerEpoch_$eq(transitMetadata.producerEpoch());
                this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                this.producerId_$eq(transitMetadata.producerId());
                this.lastProducerId_$eq(transitMetadata.lastProducerId());
            }
        } else if (Ongoing$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
            }
        } else {
            boolean bl = PrepareAbort$.MODULE$.equals(toState) ? true : PrepareCommit$.MODULE$.equals(toState);
            if (bl) {
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(toState) ? true : CompleteCommit$.MODULE$.equals(toState);
                if (bl2) {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                    } else {
                        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                        this.topicPartitions().clear();
                    }
                } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else {
                    if (Dead$.MODULE$.equals(toState)) {
                        throw new IllegalStateException(new StringBuilder(250).append("TransactionalId ").append(this.transactionalId()).append(" is trying to complete a transition to ").append(toState).append(". This means that the transactionalId was being expired, and the only acceptable completion of ").append("this operation is to remove the transaction metadata from the cache, not to persist the ").append(toState).append(" in the log.").toString());
                    }
                    throw new MatchError((Object)toState);
                }
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("TransactionalId ").append(this.transactionalId()).append(" complete transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append(this.toString()).append("'s transition to ").append(txnTransitMetadata).append(" failed: this should not happen").toString());
        throw new IllegalStateException(new StringBuilder(71).append("TransactionalId ").append(this.transactionalId()).append(" failed transition to state ").append(txnTransitMetadata).append(" ").append("due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return new StringBuilder(167).append("TransactionMetadata(").append("transactionalId=").append(this.transactionalId()).append(", ").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.producerEpoch()).append(", ").append("txnTimeoutMs=").append(this.txnTimeoutMs()).append(", ").append("state=").append(this.state()).append(", ").append("pendingState=").append(this.pendingState()).append(", ").append("topicPartitions=").append(this.topicPartitions()).append(", ").append("txnStartTimestamp=").append(this.txnStartTimestamp()).append(", ").append("txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp()).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)that;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.lastProducerEpoch() != transactionMetadata.lastProducerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public TransactionMetadata(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.lastProducerId = lastProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

