/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdGenerator;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\u001dr!\u0002\u0016,\u0011\u0003\u0011d!\u0002\u001b,\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003y\u0004bBB\u000e\u0003\u0011%1Q\u0004\u0005\b\u0007C\tA\u0011BB\u0012\r\u0011!4\u0006A!\t\u0011!3!\u0011!Q\u0001\n%C\u0001\u0002\u0014\u0004\u0003\u0002\u0003\u0006I!\u0014\u0005\t!\u001a\u0011\t\u0011)A\u0005#\"AAK\u0002B\u0001B\u0003%Q\u000b\u0003\u0005\\\r\t\u0005\t\u0015!\u0003]\u0011!yfA!A!\u0002\u0013\u0001\u0007\u0002C2\u0007\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011A4!\u0011!Q\u0001\nEDQ\u0001\u0010\u0004\u0005\u0002Q,A! \u0004\u0001}\u00161\u0011q\u0002\u0004\u0001\u0003#)a!a\b\u0007\u0001\u0005EQABA\u0011\r\u0001\t\u0019\u0003C\u0005\u0002T\u0019\u0011\r\u0011\"\u0003\u0002V!A\u0011q\u000e\u0004!\u0002\u0013\t9\u0006C\u0005\u0002r\u0019\u0011\r\u0011\"\u0001\u0002t!9\u0011Q\u000f\u0004!\u0002\u0013A\u0006bBA<\r\u0011\u0005\u0011\u0011\u0010\u0005\n\u0003k3\u0011\u0013!C\u0001\u0003oCq!!4\u0007\t\u0013\ty\rC\u0004\u0002t\u001a!\t!!>\t\u0013\t-b!%A\u0005\u0002\u0005]\u0006b\u0002B\u0017\r\u0011\u0005!q\u0006\u0005\b\u0005o1A\u0011\u0001B\u001d\u0011\u001d\u0011\tE\u0002C\u0005\u0005\u0007BqAa\u001b\u0007\t\u0003\u0011i\u0007C\u0005\u0003\u0000\u0019\t\n\u0011\"\u0001\u00028\"9!\u0011\u0011\u0004\u0005\n\t\r\u0005b\u0002BN\r\u0011\u0005!Q\u0014\u0005\b\u0005O3A\u0011\u0001BU\u0011\u001d\u0011iK\u0002C\u0005\u0005_C\u0001B!1\u0007\t\u0003Y#1\u0019\u0005\b\u0005\u00174A\u0011\u0001Bg\u0011%\u0011INBI\u0001\n\u0003\u0011Y\u000eC\u0004\u0003`\u001a!\tA!9\u0002-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_JT!\u0001L\u0017\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003]=\n1bY8pe\u0012Lg.\u0019;pe*\t\u0001'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005M\nQ\"A\u0016\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\u001c\"!\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!'A\u0003baBd\u0017\u0010F\bA\u0005G\u0014\u0019P!@\u0003\u0000\u000e\u00051qBB\r!\t\u0019daE\u0002\u0007m\t\u0003\"a\u0011$\u000e\u0003\u0011S!!R\u0018\u0002\u000bU$\u0018\u000e\\:\n\u0005\u001d#%a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JIB\u0011qGS\u0005\u0003\u0017b\u00121!\u00138u\u0003%!\bP\\\"p]\u001aLw\r\u0005\u00024\u001d&\u0011qj\u000b\u0002\u0012)J\fgn]1di&|gnQ8oM&<\u0017!C:dQ\u0016$W\u000f\\3s!\t\u0019%+\u0003\u0002T\t\nI1k\u00195fIVdWM]\u0001\u001aGJ,\u0017\r^3Qe>$WoY3s\u0013\u0012<UM\\3sCR|'\u000fE\u00028-bK!a\u0016\u001d\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA\u001aZ\u0013\tQ6FA\nQe>$WoY3s\u0013\u0012<UM\\3sCR|'/\u0001\u0006uq:l\u0015M\\1hKJ\u0004\"aM/\n\u0005y[#a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003]!\bP\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u00024C&\u0011!m\u000b\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"!\u001a8\u000e\u0003\u0019T!!R4\u000b\u0005!L\u0017AB2p[6|gN\u0003\u00021U*\u00111\u000e\\\u0001\u0007CB\f7\r[3\u000b\u00035\f1a\u001c:h\u0013\tygM\u0001\u0003US6,\u0017A\u00037pO\u000e{g\u000e^3yiB\u0011QM]\u0005\u0003g\u001a\u0014!\u0002T8h\u0007>tG/\u001a=u)%\u0001UO^<ysj\\H\u0010C\u0003I\u001f\u0001\u0007\u0011\nC\u0003M\u001f\u0001\u0007Q\nC\u0003Q\u001f\u0001\u0007\u0011\u000bC\u0003U\u001f\u0001\u0007Q\u000bC\u0003\\\u001f\u0001\u0007A\fC\u0003`\u001f\u0001\u0007\u0001\rC\u0003d\u001f\u0001\u0007A\rC\u0003q\u001f\u0001\u0007\u0011O\u0001\fJ]&$\bK]8ek\u000e,'/\u00133DC2d'-Y2l!\u00199t0a\u0001\u0002\n%\u0019\u0011\u0011\u0001\u001d\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u001a\u0002\u0006%\u0019\u0011qA\u0016\u0003)%s\u0017\u000e\u001e)s_\u0012,8-\u001a:JIJ+7/\u001e7u!\r9\u00141B\u0005\u0004\u0003\u001bA$\u0001B+oSR\u0014Q#\u00113e!\u0006\u0014H/\u001b;j_:\u001c8)\u00197mE\u0006\u001c7\u000e\u0005\u00048\u007f\u0006M\u0011\u0011\u0002\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D4\u0002\u0011A\u0014x\u000e^8d_2LA!!\b\u0002\u0018\t1QI\u001d:peN\u0014a\"\u00128e)bt7)\u00197mE\u0006\u001c7NA\u0005Ba&\u0014Vm];miV!\u0011QEA!!!\t9#a\u000e\u0002\u0014\u0005ub\u0002BA\u0015\u0003gqA!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_\t\u0014A\u0002\u001fs_>$h(C\u0001:\u0013\r\t)\u0004O\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI$a\u000f\u0003\r\u0015KG\u000f[3s\u0015\r\t)\u0004\u000f\t\u0005\u0003\u007f\t\t\u0005\u0004\u0001\u0005\u000f\u0005\r3C1\u0001\u0002F\t\tA+\u0005\u0003\u0002H\u00055\u0003cA\u001c\u0002J%\u0019\u00111\n\u001d\u0003\u000f9{G\u000f[5oOB\u0019q'a\u0014\n\u0007\u0005E\u0003HA\u0002B]f\f\u0001\"[:BGRLg/Z\u000b\u0003\u0003/\u0002B!!\u0017\u0002l5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003C\n\u0019'\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u001a\u0002h\u0005!Q\u000f^5m\u0015\t\tI'\u0001\u0003kCZ\f\u0017\u0002BA7\u00037\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!C5t\u0003\u000e$\u0018N^3!\u0003M\u0001(o\u001c3vG\u0016\u0014\u0018\nZ$f]\u0016\u0014\u0018\r^8s+\u0005A\u0016\u0001\u00069s_\u0012,8-\u001a:JI\u001e+g.\u001a:bi>\u0014\b%\u0001\u000biC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\r\u0003\u0013\tY(a$\u0002\u0014\u0006\r\u00161\u0016\u0005\b\u0003{B\u0002\u0019AA@\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007\u0003BAA\u0003\u0013sA!a!\u0002\u0006B\u0019\u00111\u0006\u001d\n\u0007\u0005\u001d\u0005(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\u000biI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000fC\u0004BBAI1\u0001\u0007\u0011*\u0001\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0005\b\u0003+C\u0002\u0019AAL\u0003i)\u0007\u0010]3di\u0016$\u0007K]8ek\u000e,'/\u00133B]\u0012,\u0005o\\2i!\u00159\u0014\u0011TAO\u0013\r\tY\n\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0015\fy*C\u0002\u0002\"\u001a\u0014!\u0003\u0015:pIV\u001cWM]%e\u0003:$W\t]8dQ\"9\u0011Q\u0015\rA\u0002\u0005\u001d\u0016\u0001\u0005:fgB|gn]3DC2d'-Y2l!\r\tI\u000bE\u0007\u0002\r!I\u0011Q\u0016\r\u0011\u0002\u0003\u0007\u0011qV\u0001\u000fEV4g-\u001a:TkB\u0004H.[3s!\r)\u0017\u0011W\u0005\u0004\u0003g3'A\u0004\"vM\u001a,'oU;qa2LWM]\u0001\u001fQ\u0006tG\r\\3J]&$\bK]8ek\u000e,'/\u00133%I\u00164\u0017-\u001e7uIU*\"!!/+\t\u0005=\u00161X\u0016\u0003\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0019\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0006\u0005'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a\u0002O]3qCJ,\u0017J\\5u!J|G-^2fe&#GK]1og&$H\u0003DAi\u0003?\f\t/a9\u0002h\u0006E\b#BAU'\u0005M\u0007CB\u001c\u0002V&\u000bI.C\u0002\u0002Xb\u0012a\u0001V;qY\u0016\u0014\u0004cA\u001a\u0002\\&\u0019\u0011Q\\\u0016\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\u0005\b\u0003{R\u0002\u0019AA@\u0011\u0019\t\tJ\u0007a\u0001\u0013\"1\u0011Q\u001d\u000eA\u0002%\u000b\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u000f\u0005%(\u00041\u0001\u0002l\u0006YA\u000f\u001f8NKR\fG-\u0019;b!\r\u0019\u0014Q^\u0005\u0004\u0003_\\#a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007bBAK5\u0001\u0007\u0011qS\u0001!Q\u0006tG\r\\3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)J\fgn]1di&|g\u000e\u0006\b\u0002\n\u0005]\u0018\u0011 B\u0002\u0005\u001b\u0011)C!\u000b\t\u000f\u0005u4\u00041\u0001\u0002\u0000!9\u00111`\u000eA\u0002\u0005u\u0018A\u00039s_\u0012,8-\u001a:JIB\u0019q'a@\n\u0007\t\u0005\u0001H\u0001\u0003M_:<\u0007b\u0002B\u00037\u0001\u0007!qA\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007]\u0012I!C\u0002\u0003\fa\u0012Qa\u00155peRDqAa\u0004\u001c\u0001\u0004\u0011\t\"\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004bAa\u0005\u0003\u001a\tuQB\u0001B\u000b\u0015\r\u00119\u0002O\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u000e\u0005+\u00111aU3u!\u0011\u0011yB!\t\u000e\u0003\u001dL1Aa\th\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!*\u001c\u0001\u0004\u00119\u0003E\u0002\u0002*FA\u0011\"!,\u001c!\u0003\u0005\r!a,\u0002U!\fg\u000e\u001a7f\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_R\u0013\u0018M\\:bGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%m\u0005QqN\\#mK\u000e$\u0018n\u001c8\u0015\r\u0005%!\u0011\u0007B\u001b\u0011\u0019\u0011\u0019$\ba\u0001\u0013\u0006\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8JI\"1\u0011Q]\u000fA\u0002%\u000bQb\u001c8SKNLwM\\1uS>tGCBA\u0005\u0005w\u0011i\u0004\u0003\u0004\u00034y\u0001\r!\u0013\u0005\b\u0003Kt\u0002\u0019\u0001B !\u00119\u0014\u0011T%\u0002O1|w-\u00138wC2LGm\u0015;bi\u0016$&/\u00198tSRLwN\\!oIJ+G/\u001e:o\u000bJ\u0014xN\u001d\u000b\t\u0005\u000b\u0012yE!\u0015\u0003\\AA!q\tB&\u0003'\t9%\u0004\u0002\u0003J)\u0019\u0011Q\r\u001d\n\t\t5#\u0011\n\u0002\u0005\u0019\u00164G\u000fC\u0004\u0002~}\u0001\r!a \t\u000f\tMs\u00041\u0001\u0003V\u0005\u0001BO]1og\u0006\u001cG/[8o'R\fG/\u001a\t\u0004g\t]\u0013b\u0001B-W\t\u0001BK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0005\b\u0005;z\u0002\u0019\u0001B0\u0003E!(/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\t\u0005\u0005C\u00129'\u0004\u0002\u0003d)\u0019!QM4\u0002\u0011I,\u0017/^3tiNLAA!\u001b\u0003d\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0002)!\fg\u000e\u001a7f\u000b:$GK]1og\u0006\u001cG/[8o)9\tIAa\u001c\u0003r\tM$Q\u000fB=\u0005{Bq!! !\u0001\u0004\ty\bC\u0004\u0002|\u0002\u0002\r!!@\t\u000f\t\u0015\u0001\u00051\u0001\u0003\b!9!q\u000f\u0011A\u0002\t}\u0013a\u0004;y]6\u000b'o[3s%\u0016\u001cX\u000f\u001c;\t\u000f\u0005\u0015\u0006\u00051\u0001\u0003|A\u0019\u0011\u0011\u0016\n\t\u0013\u00055\u0006\u0005%AA\u0002\u0005=\u0016A\b5b]\u0012dW-\u00128e)J\fgn]1di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u00039)g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$\u0002#!\u0003\u0003\u0006\n\u001d%\u0011\u0012BF\u0005\u001b\u00139J!'\t\u000f\u0005u$\u00051\u0001\u0002\u0000!9\u00111 \u0012A\u0002\u0005u\bb\u0002B\u0003E\u0001\u0007!q\u0001\u0005\b\u0005o\u0012\u0003\u0019\u0001B0\u0011\u001d\u0011yI\ta\u0001\u0005#\u000bA\"[:Ge>l7\t\\5f]R\u00042a\u000eBJ\u0013\r\u0011)\n\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\t)K\ta\u0001\u0005wBq!!,#\u0001\u0004\ty+A\fue\u0006t7/Y2uS>tGk\u001c9jG\u000e{gNZ5hgV\u0011!q\u0014\t\u0005\u0005C\u0013\u0019+\u0004\u0002\u0002d%!!QUA2\u0005)\u0001&o\u001c9feRLWm]\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004\u0013\n-\u0006bBA?I\u0001\u0007\u0011qP\u0001\u0019_:,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\u001cu.\u001c9mKR,G\u0003\u0002BY\u0005o#B!!\u0003\u00034\"9!QW\u0013A\u0002\u0005M\u0011!B3se>\u0014\bb\u0002B]K\u0001\u0007!1X\u0001\u0011ibt\u0017\nZ!oIBKG-\u00129pG\"\u00042a\rB_\u0013\r\u0011yl\u000b\u0002\")J\fgn]1di&|g.\u00197JI\u0006sG\r\u0015:pIV\u001cWM]%e\u000bB|7\r[\u0001\u001aC\n|'\u000f\u001e+j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u0002\n\t\u0015\u0007b\u0002BdM\u0001\u0007!\u0011Z\u0001\u000b_:\u001cu.\u001c9mKR,\u0007CB\u001c\u0000\u0005w\u0013Y(A\u0004ti\u0006\u0014H/\u001e9\u0015\r\u0005%!q\u001aBk\u0011\u001d\u0011\tn\na\u0001\u0005'\faE]3ue&,g/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u!\r9d+\u0013\u0005\n\u0005/<\u0003\u0013!a\u0001\u0005#\u000bq$\u001a8bE2,GK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o\u0003E\u0019H/\u0019:ukB$C-\u001a4bk2$HEM\u000b\u0003\u0005;TCA!%\u0002<\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002\n!9!Q]\u0002A\u0002\t\u001d\u0018AB2p]\u001aLw\r\u0005\u0003\u0003j\n=XB\u0001Bv\u0015\r\u0011ioL\u0001\u0007g\u0016\u0014h/\u001a:\n\t\tE(1\u001e\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0004\u0003v\u000e\u0001\rAa>\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!!\u0011\u001eB}\u0013\u0011\u0011YPa;\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\")\u0001k\u0001a\u0001#\")Ak\u0001a\u0001+\"911A\u0002A\u0002\r\u0015\u0011aB7fiJL7m\u001d\t\u0005\u0007\u000f\u0019Y!\u0004\u0002\u0004\n)\u001911A4\n\t\r51\u0011\u0002\u0002\b\u001b\u0016$(/[2t\u0011\u001d\u0019\tb\u0001a\u0001\u0007'\tQ\"\\3uC\u0012\fG/Y\"bG\",\u0007\u0003\u0002Bu\u0007+IAaa\u0006\u0003l\niQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016DQaY\u0002A\u0002\u0011\fA#\u001b8jiR\u0013\u0018M\\:bGRLwN\\#se>\u0014H\u0003BA\u0002\u0007?AqA!.\u0005\u0001\u0004\t\u0019\"A\fj]&$HK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR!\u00111AB\u0013\u0011\u001d\tI/\u0002a\u0001\u00033\u0004")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final ProducerIdGenerator producerIdGenerator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdGenerator> function0, Metrics metrics, MetadataCache metadataCache, Time time) {
        if (TransactionCoordinator$.MODULE$ == null) {
            throw null;
        }
        TransactionConfig apply_txnConfig = new TransactionConfig(Predef$.MODULE$.Integer2int(kafkaConfig.transactionalIdExpirationMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionMaxTimeoutMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicPartitions()), Predef$.MODULE$.Short2short(kafkaConfig.transactionTopicReplicationFactor()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicSegmentBytes()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionsLoadBufferSize()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicMinISR()), (String)kafkaConfig.trainsactionTopicPlacementConstraints().map(TransactionCoordinator$::$anonfun$apply$1).getOrElse(TransactionCoordinator$::$anonfun$apply$2), Predef$.MODULE$.Integer2int(kafkaConfig.transactionAbortTimedOutTransactionCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionRemoveExpiredTransactionalIdCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.requestTimeoutMs()));
        TransactionStateManager apply_txnStateManager = new TransactionStateManager(kafkaConfig.brokerId(), scheduler, replicaManager, apply_txnConfig, time, metrics);
        LogContext apply_logContext = new LogContext(new StringBuilder(29).append("[TransactionCoordinator id=").append(kafkaConfig.brokerId()).append("] ").toString());
        TransactionMarkerChannelManager apply_txnMarkerChannelManager = TransactionMarkerChannelManager$.MODULE$.apply(kafkaConfig, metrics, metadataCache, apply_txnStateManager, time, apply_logContext);
        return new TransactionCoordinator(kafkaConfig.brokerId(), apply_txnConfig, scheduler, function0, apply_txnStateManager, apply_txnMarkerChannelManager, time, apply_logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public ProducerIdGenerator producerIdGenerator() {
        return this.producerIdGenerator;
    }

    /*
     * WARNING - void declaration
     */
    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback, BufferSupplier bufferSupplier) {
        Tuple2 tuple2;
        if (transactionalId == null) {
            long producerId = this.producerIdGenerator().generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
            return;
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either<Errors, CoordinatorEpochAndTxnMetadata> either;
            if (None$.MODULE$.equals(x0$1)) {
                long producerId = this.producerIdGenerator().generateProducerId();
                long x$3 = -1L;
                short x$4 = -1;
                short x$5 = -1;
                Empty$ x$7 = Empty$.MODULE$;
                scala.collection.mutable.Set x$8 = Set$.MODULE$.empty();
                long x$9 = $this.time.milliseconds();
                long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
                TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId, producerId, x$3, x$4, x$5, transactionTimeoutMs, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, x$10, x$9);
                either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
            } else {
                throw new MatchError(x0$1);
            }
            return either;
        }).flatMap((Function1 & Serializable & scala.Serializable)existingEpochAndMetadata -> {
            int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
            return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> this.prepareInitProducerIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata, expectedProducerIdAndEpoch));
        });
        if (result instanceof Left) {
            Errors error2 = (Errors)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                Tuple2 tuple22;
                void endTransaction_txnMarkerResult;
                void endTransaction_producerEpoch;
                void endTransaction_isFromClient;
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)error -> {
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                    } else {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    }
                    return BoxedUnit.UNIT;
                };
                boolean bl = false;
                TransactionResult transactionResult = TransactionResult.ABORT;
                short s = newMetadata.producerEpoch();
                long endTransaction_producerId = newMetadata.producerId();
                BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
                if (transactionalId.isEmpty()) {
                    Errors errors;
                    Errors errors2 = errors = Errors.INVALID_REQUEST;
                    Errors errors3 = Errors.NONE;
                    if (errors2 == null ? errors3 != null : !errors2.equals(errors3)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap(arg_0 -> TransactionCoordinator.$anonfun$endTransaction$1(this, endTransaction_producerId, (boolean)endTransaction_isFromClient, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, endTransaction_isEpochFence, transactionalId, arg_0));
                if (endTransaction_preAppendResult instanceof Left) {
                    Errors errors;
                    Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
                    this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TransactionCoordinator.$anonfun$endTransaction$4((TransactionResult)endTransaction_txnMarkerResult, endTransaction_err, transactionalId)));
                    Errors errors4 = errors = endTransaction_err;
                    Errors errors5 = Errors.NONE;
                    if (errors4 == null ? errors5 != null : !errors4.equals(errors5)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                if (endTransaction_preAppendResult instanceof Right && (tuple22 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
                    void endTransaction_responseCallback;
                    int endTransaction_coordinatorEpoch = tuple22._1$mcI$sp();
                    TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple22._2();
                    Function1 & Serializable & scala.Serializable endTransaction_x$4 = arg_0 -> TransactionCoordinator.$anonfun$endTransaction$15$adapted(this, transactionalId, endTransaction_coordinatorEpoch, endTransaction_producerId, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, (Function1)endTransaction_responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence, arg_0);
                    Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
                    this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, bufferSupplier);
                    return;
                }
                throw new MatchError((Object)endTransaction_preAppendResult);
            }
            Function1 & Serializable & scala.Serializable x$14 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata));
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$16 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$14, x$16, bufferSupplier);
            return;
        }
        throw new MatchError((Object)result);
    }

    public BufferSupplier handleInitProducerId$default$5() {
        return BufferSupplier.NO_CACHING;
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (!expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)producerIdAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata)))) {
            return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
        }
        TransactionState transactionState = txnMetadata.state();
        boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
        if (bl) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
            if (bl2) {
                Left left2;
                Right transitMetadataResult;
                Right right;
                if (txnMetadata.isProducerEpochExhausted() && expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, x$2)))) {
                    long newProducerId = this.producerIdGenerator().generateProducerId();
                    right = package$.MODULE$.Right().apply((Object)txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    right = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)expectedProducerIdAndEpoch.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToShort((short)x$3.epoch)), this.time.milliseconds());
                }
                if (transitMetadataResult instanceof Right) {
                    TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (transitMetadataResult instanceof Left) {
                    Errors err = (Errors)((Left)transitMetadataResult).value();
                    left2 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(transitMetadataResult);
                }
                left = left2;
            } else if (Ongoing$.MODULE$.equals(transactionState)) {
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            } else {
                boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                if (bl3) {
                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError((Object)transactionState);
            }
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback, BufferSupplier bufferSupplier) {
        Tuple2 tuple2;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    block8: {
                        block7: {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                        }
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    Ongoing$ ongoing$ = Ongoing$.MODULE$;
                    if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                        return package$.MODULE$.Left().apply((Object)Errors.NONE);
                    }
                    return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, x$6, bufferSupplier);
            return;
        }
        throw new MatchError((Object)result);
    }

    public BufferSupplier handleAddPartitionsToTransaction$default$6() {
        return BufferSupplier.NO_CACHING;
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Elected as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch2).toString());
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Resigned as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback, BufferSupplier bufferSupplier) {
        Tuple2 tuple2;
        boolean endTransaction_isFromClient = true;
        BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (endTransaction_preAppendResult instanceof Left) {
            Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)endTransaction_err);
            return;
        }
        if (endTransaction_preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
            int endTransaction_coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable & scala.Serializable endTransaction_x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Left left;
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    Left<Errors, Nothing$> left;
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                    if (bl) {
                                        left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else {
                                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                        if (bl2) {
                                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                            throw new IllegalStateException(errorMsg);
                                        }
                                        throw new MatchError((Object)transactionState);
                                    }
                                    return left;
                                });
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                            }
                        } else {
                            throw new MatchError(x0$1);
                        }
                        Left left2 = left;
                        return left2;
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, bufferSupplier);
            return;
        }
        throw new MatchError((Object)endTransaction_preAppendResult);
    }

    public BufferSupplier handleEndTransaction$default$6() {
        return BufferSupplier.NO_CACHING;
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function1<Errors, BoxedUnit> responseCallback, BufferSupplier bufferSupplier) {
        Tuple2 tuple2;
        BooleanRef isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (preAppendResult instanceof Left) {
            Errors err = (Errors)((Left)preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)preAppendResult).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Left left;
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    Left<Errors, Nothing$> left;
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                    if (bl) {
                                        left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else {
                                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                        if (bl2) {
                                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                            throw new IllegalStateException(errorMsg);
                                        }
                                        throw new MatchError((Object)transactionState);
                                    }
                                    return left;
                                });
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                            }
                        } else {
                            throw new MatchError(x0$1);
                        }
                        Left left2 = left;
                        return left2;
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$4, x$6, bufferSupplier);
            return;
        }
        throw new MatchError((Object)preAppendResult);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.txnManager.transactionTimeoutSensor().record();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Completed rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString());
            return;
        }
        boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.PRODUCER_FENCED.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("has been cancelled due to error ").append(error).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("failed due to error ").append(error).toString());
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (None$.MODULE$.equals(x0$1)) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
                } else if (x0$1 instanceof Some) {
                    TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                    ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                            return None$.MODULE$;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                            return None$.MODULE$;
                        }
                        return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                    })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                        this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), BufferSupplier.NO_CACHING);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    throw new MatchError(x0$1);
                }
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> (Function1 & Serializable & scala.Serializable)error -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error);
            return BoxedUnit.UNIT;
        }), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        this.txnManager.startup(retrieveTransactionTopicPartitionCount, enableTransactionalIdExpiration);
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdGenerator().shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$4(Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$7(TransactionCoordinator $this, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$2) {
        return x$2.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ void $anonfun$endTransaction$12(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$6, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        if (None$.MODULE$.equals(x0$2)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            return;
        }
        if (x0$2 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$2).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(166).append("The coordinator failed to write an epoch fence transition for producer ").append(transactionalId$4).append(" to the transaction log ").append("with error ").append(error$2).append(". The epoch was increased to ").append(newMetadata$2.producerEpoch()).append(" but not returned to the client").toString());
                return;
            }
        } else {
            throw new MatchError((Object)x0$2);
        }
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$4, int coordinatorEpoch$6, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$4).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (preSendResult instanceof Left) {
                Errors err = (Errors)((Left)preSendResult).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)preSendResult).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)preSendResult);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            this.txnManager.getTransactionState(transactionalId$4).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$endTransaction$15(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$6, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId$4).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                Errors sendTxnMarkersCallback$1_err = (Errors)((Left)sendTxnMarkersCallback$1_preSendResult).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)sendTxnMarkersCallback$1_err);
                return;
            }
            if (sendTxnMarkersCallback$1_preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)sendTxnMarkersCallback$1_preSendResult).value()) != null) {
                TransactionMetadata sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                $this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, sendTxnMarkersCallback$1_txnMetadata, sendTxnMarkersCallback$1_newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)sendTxnMarkersCallback$1_preSendResult);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            $this.txnManager.getTransactionState(transactionalId$4).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$7(TransactionCoordinator $this, TransactionMetadata txnMetadata$6, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, TxnTransitMetadata txnTransitMetadata) {
        $this.endTransaction(txnMetadata$6.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)), BufferSupplier.NO_CACHING);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            ((Option)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), BufferSupplier.NO_CACHING);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            } else if (x0$1 instanceof Some) {
                TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                        return None$.MODULE$;
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                        return None$.MODULE$;
                    }
                    return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), BufferSupplier.NO_CACHING);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, Function0<ProducerIdGenerator> createProducerIdGenerator, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
        this.producerIdGenerator = (ProducerIdGenerator)createProducerIdGenerator.apply();
    }
}

