/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.RetriableException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u000f\u001f\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bQ\u0003A\u0011A+\t\u000fu\u0003!\u0019!C\u0001=\"1!\r\u0001Q\u0001\n}CQa\u0019\u0001\u0005\u0002\u0011DQ! \u0001\u0005\u0002yDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\n\u0003\u001b\u0001\u0011\u0013!C\u0001\u0003\u001fAq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u00111\n\u0001\u0005\n\u00055\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ti\u0006\u0001C\u0005\u0003?Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u0019\tI\t\u0001C\u0005}\n!Bk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJT!a\b\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0013+!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111FL\u0007\u0002Y)\u0011Q\u0006I\u0001\u0006kRLGn]\u0005\u0003_1\u0012q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003eUj\u0011a\r\u0006\u0003i\u0001\naa]3sm\u0016\u0014\u0018B\u0001\u001c4\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0005\u0002:u5\ta$\u0003\u0002<=\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002'I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0011\u0005er\u0014BA \u001f\u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0003U\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\"!\u000f\"\n\u0005\rs\"!\u0006)beRLG/[8o'R\fG/Z'bG\"Lg.Z\u0001\u0007G2LWM\u001c;\u0011\u0005e2\u0015BA$\u001f\u00059!U\r\\3uS>t7\t\\5f]R\f1\u0003^5feR{\u0007/[2NC:\fw-\u001a:PaR\u00042!\n&M\u0013\tYeE\u0001\u0004PaRLwN\u001c\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bQ\u0001^8qS\u000eT!!\u0015\u0011\u0002\tQLWM]\u0005\u0003':\u0013\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u001d1v\u000bW-[7r\u0003\"!\u000f\u0001\t\u000bA:\u0001\u0019A\u0019\t\u000b]:\u0001\u0019\u0001\u001d\t\u000bq:\u0001\u0019A\u001f\t\u000b\u0001;\u0001\u0019A!\t\u000b\u0011;\u0001\u0019A#\t\u000b!;\u0001\u0019A%\u0002)%\u001cH)\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3e+\u0005y\u0006CA\u0013a\u0013\t\tgEA\u0004C_>dW-\u00198\u0002+%\u001cH)\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3eA\u0005!\u0011N\\5u)\r)\u0007n\u001f\t\u0003K\u0019L!a\u001a\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006S*\u0001\rA[\u0001\u0019S:LG/[1m)>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007cA6oa6\tAN\u0003\u0002nM\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=d'aA*fiB\u0011\u0011\u000f\u001f\b\u0003eZ\u0004\"a\u001d\u0014\u000e\u0003QT!!\u001e\u0012\u0002\rq\u0012xn\u001c;?\u0013\t9h%\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<'\u0011\u0015a(\u00021\u0001k\u0003\tJg.\u001b;jC2$v\u000e]5dg&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]\u0006\u0001BO]=U_BL7\rR3mKRLwN\u001c\u000b\u0002K\u0006ARM\\9vKV,Gk\u001c9jGN4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007\u0015\f\u0019\u0001\u0003\u0004\u0002\u00061\u0001\rA[\u0001\u0007i>\u0004\u0018nY:\u0002/I,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cHcA3\u0002\f!A\u0011QA\u0007\u0011\u0002\u0003\u0007!.A\u0011sKN,X.\u001a#fY\u0016$\u0018n\u001c8G_J$v\u000e]5dg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0012)\u001a!.a\u0005,\u0005\u0005U\u0001\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\b'\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\tIBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1CZ1jYJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:$2!ZA\u0015\u0011\u001d\tYc\u0004a\u0001\u0003[\t\u0001B]3qY&\u001c\u0017m\u001d\t\u0005W:\fy\u0003E\u0002:\u0003cI1!a\r\u001f\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b\u0003yi\u0017M]6U_BL7-\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eF\u0003f\u0003s\tY\u0004\u0003\u0004\u0002\u0006A\u0001\rA\u001b\u0005\t\u0003{\u0001B\u00111\u0001\u0002@\u00051!/Z1t_:\u0004B!JA!a&\u0019\u00111\t\u0014\u0003\u0011q\u0012\u0017P\\1nKz\nA$[:U_BL7-\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eF\u0002`\u0003\u0013BQaT\tA\u0002A\f\u0011$[:U_BL7\rR3mKRLwN\\%o!J|wM]3tgR\u0019q,a\u0014\t\u000b=\u0013\u0002\u0019\u00019\u00025%\u001cHk\u001c9jGF+X-^3e+B4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007}\u000b)\u0006C\u0003P'\u0001\u0007\u0001/A\fd_6\u0004H.\u001a;f%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019Q-a\u0017\t\u000f\u0005-B\u00031\u0001\u0002.\u0005Q\u0012n\u001d+pa&\u001cW\t\\5hS\ndWMR8s\t\u0016dW\r^5p]R\u0019q,!\u0019\t\u000b=+\u0002\u0019\u00019\u0002EI,GO]=EK2,G/[8o\r>\u0014\u0018J\\3mS\u001eL'\r\\3SKBd\u0017nY1t)\r)\u0017q\r\u0005\u0007\u0003\u000b1\u0002\u0019\u00016\u0002-\u0005\u001c\u0018P\\2EK2,G/\u001a+jKJ,G\rV8qS\u000e$2!ZA7\u0011\u0015yu\u00031\u0001q\u0003i\u0001(/\u001a9be\u0016\u001cu.\u001c9mKR,G)\u001a7fi\u0016$v\u000e]5d)\r)\u00171\u000f\u0005\u0006\u001fb\u0001\r\u0001]\u0001\u0012M&t\u0017n\u001d5U_BL7\rR3mKR,GcA3\u0002z!)q*\u0007a\u0001a\u0006yqN\u001c+pa&\u001cG)\u001a7fi&|g\u000eF\u0002f\u0003\u007fBa!!\u0002\u001b\u0001\u0004Q\u0017aE8o!\u0006\u0014H/\u001b;j_:$U\r\\3uS>tGcA3\u0002\u0006\"1\u0011qQ\u000eA\u0002)\f\u0011\u0003^8qS\u000e\u001cHk\u001c\"f\t\u0016dW\r^3e\u0003=\u0011Xm];nK\u0012+G.\u001a;j_:\u001c\b")
public class TopicDeletionManager
implements Logging {
    private final KafkaConfig config;
    private final ControllerContext controllerContext;
    private final ReplicaStateMachine replicaStateMachine;
    private final PartitionStateMachine partitionStateMachine;
    public final DeletionClient kafka$controller$TopicDeletionManager$$client;
    private final Option<TierTopicManager> tierTopicManagerOpt;
    private final boolean isDeleteTopicEnabled;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Initializing manager with initial deletions: ").append(initialTopicsToBeDeleted).append(", ").append("initial ineligible deletions: ").append(initialTopicsIneligibleForDeletion).toString());
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.queueTopicDeletion(initialTopicsToBeDeleted);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.controllerContext.topicsToBeDeleted()));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Removing ").append(initialTopicsToBeDeleted).append(" since delete topic is disabled").toString());
        this.kafka$controller$TopicDeletionManager$$client.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq(), this.controllerContext.epochZkVersion());
    }

    public void tryTopicDeletion() {
        if (this.isDeleteTopicEnabled()) {
            this.resumeDeletions();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.queueTopicDeletion(topics);
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (this.isDeleteTopicEnabled() && (topicsToResumeDeletion = (Set)topics.$amp(this.controllerContext.topicsToBeDeleted())).nonEmpty()) {
            this.controllerContext.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
            return;
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (this.isDeleteTopicEnabled() && (replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion failed for replicas ").append(replicasThatFailedToDelete.mkString(",")).append(". Halting deletion for topics ").append(topics).toString());
            this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "replica deletion failure");
            this.resumeDeletions();
            return;
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics, Function0<String> reason) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.controllerContext.topicsToBeDeleted().$amp(topics);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Halted deletion of topics ").append(newTopicsToHaltDeletion.mkString(",")).append(" due to ").append(reason.apply()).toString());
                return;
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.topicsIneligibleForDeletion().contains((Object)topic);
        }
        return true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$);
        }
        return false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.isTopicQueuedUpForDeletion(topic);
        }
        return false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deletion successfully completed for replicas ").append(successfullyDeletedReplicas.mkString(",")).toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.controllerContext.isTopicQueuedUpForDeletion(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic) && !this.controllerContext.topicsWithDeletionBeingCompleted().contains((Object)topic);
    }

    private void retryDeletionForIneligibleReplicas(Set<String> topics) {
        Set failedReplicas = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> $this.controllerContext.replicasInState((String)x$2, ReplicaDeletionIneligible$.MODULE$), Set$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Retrying deletion of topics ").append(topics.mkString(",")).append(" since replicas ").append(failedReplicas.mkString(",")).append(" were not successfully deleted").toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
    }

    private void asyncDeleteTieredTopic(String topic) {
        Set<PartitionAndReplica> replicasForDeletedTopic = this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        TierTopicManager tierTopicManager = (TierTopicManager)this.tierTopicManagerOpt.get();
        Uuid topicId = (Uuid)this.controllerContext.topicIds().apply((Object)topic);
        scala.collection.immutable.Set partitionsForDeletedTopic = ((TraversableOnce)replicasForDeletedTopic.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topicPartition(), Set$.MODULE$.canBuildFrom())).toSet();
        ListBuffer appendResults = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionsForDeletedTopic.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            TopicIdPartition topicIdPartition = new TopicIdPartition(topic, CoreUtils$.MODULE$.toJavaUUID(topicId), partition.partition());
            TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(topicIdPartition, $this.controllerContext.epoch(), UUID.randomUUID());
            return appendResults.$plus$eq(tierTopicManager.addMetadata(deleteInitiate));
        });
        CompletableFuture.allOf((CompletableFuture[])appendResults.toSeq().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))).whenComplete((BiConsumer)new BiConsumer<Void, Throwable>(this, appendResults, topic){
            private final /* synthetic */ TopicDeletionManager $outer;
            private final ListBuffer appendResults$1;
            private final String topic$1;

            public BiConsumer<Void, Throwable> andThen(BiConsumer<? super Void, ? super Throwable> x$1) {
                return BiConsumer.super.andThen(x$1);
            }

            public void accept(Void result, Throwable t) {
                block5: {
                    Object object = new Object();
                    try {
                        if (t != null) {
                            this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(t, this.topic$1);
                            break block5;
                        }
                        ListBuffer results = (ListBuffer)this.appendResults$1.map((Function1 & Serializable & scala.Serializable)appendResult -> {
                            try {
                                return (TierPartitionState.AppendResult)((Object)((Object)appendResult.get()));
                            }
                            catch (Exception e) {
                                $this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(e, $this.topic$1);
                                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                            }
                        }, ListBuffer$.MODULE$.canBuildFrom());
                        if (results.forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$accept$2(x$4)))) {
                            this.$outer.kafka$controller$TopicDeletionManager$$client.completeDeleteTopic(this.topic$1);
                            break block5;
                        }
                        this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(new IllegalStateException(new StringBuilder(18).append("Unexpected result ").append(results).toString()), this.topic$1);
                        return;
                    }
                    catch (NonLocalReturnControl ex) {
                        if (ex.key() == object) {
                            ex.value$mcV$sp();
                            return;
                        }
                        throw ex;
                    }
                }
            }

            public static final /* synthetic */ boolean $anonfun$accept$2(TierPartitionState.AppendResult x$4) {
                TierPartitionState.AppendResult appendResult = x$4;
                TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
                return !(appendResult != null ? !((Object)((Object)appendResult)).equals((Object)((Object)appendResult2)) : appendResult2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.appendResults$1 = appendResults$1;
                this.topic$1 = topic$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1(kafka.controller.TopicDeletionManager$$anon$1 java.lang.Object java.util.concurrent.CompletableFuture ), $anonfun$accept$2$adapted(kafka.tier.state.TierPartitionState$AppendResult )}, serializedLambda);
            }
        });
    }

    private void prepareCompleteDeleteTopic(String topic) {
        this.kafka$controller$TopicDeletionManager$$client.mutePartitionModifications(topic);
        this.controllerContext.topicsWithDeletionBeingCompleted().$plus$eq((Object)topic);
        if (Predef$.MODULE$.Boolean2boolean(this.config.tierFeature())) {
            this.asyncDeleteTieredTopic(topic);
            return;
        }
        this.finishTopicDelete(topic);
    }

    public void finishTopicDelete(String topic) {
        if (this.controllerContext.topicsWithDeletionBeingCompleted().contains((Object)topic)) {
            Set<PartitionAndReplica> replicasForDeletedTopic = this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
            this.kafka$controller$TopicDeletionManager$$client.deleteTopic(topic, this.controllerContext.epochZkVersion());
            this.controllerContext.removeTopic(topic);
            this.controllerContext.topicsWithDeletionBeingCompleted().$minus$eq((Object)topic);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Deletion of topic ").append(topic).append(" successfully completed").toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Attempt to complete deletion for topic ").append(topic).append(", but not being tracked in set ").append($this.controllerContext.topicsWithDeletionBeingCompleted().mkString(",")).toString());
    }

    private void onTopicDeletion(Set<String> topics) {
        Set unseenTopicsForDeletion = topics.diff(this.controllerContext.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1 & Serializable & scala.Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$);
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$);
            this.controllerContext.beginTopicDeletion((Set<String>)unseenTopicsForDeletion);
        }
        this.kafka$controller$TopicDeletionManager$$client.sendMetadataUpdate((Set<TopicPartition>)((Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom())));
        this.onPartitionDeletion(topics);
    }

    private void onPartitionDeletion(Set<String> topicsToBeDeleted) {
        ListBuffer allDeadReplicas = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer allReplicasForDeletionRetry = (ListBuffer)ListBuffer$.MODULE$.empty();
        scala.collection.mutable.Set allTopicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
        topicsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            void var7_7;
            void var6_6;
            Tuple2 tuple2 = $this.controllerContext.replicasForTopic((String)topic).partition((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.controllerContext.isReplicaOnline(r.replica(), r.topicPartition(), this.controllerContext.isReplicaOnline$default$3())));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Set aliveReplicas = (Set)tuple2._1();
            Set deadReplicas = (Set)tuple2._2();
            void aliveReplicas2 = var6_6;
            void deadReplicas2 = var7_7;
            Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controllerContext.replicasInState((String)topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = aliveReplicas2.diff(successfullyDeletedReplicas);
            allDeadReplicas.$plus$plus$eq((TraversableOnce)deadReplicas2);
            allReplicasForDeletionRetry.$plus$plus$eq((TraversableOnce)replicasForDeletionRetry);
            if (deadReplicas2.nonEmpty()) {
                this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TopicDeletionManager.$anonfun$onPartitionDeletion$3((Set)deadReplicas2, topic)));
                return allTopicsIneligibleForDeletion.$plus$eq(topic);
            }
            return BoxedUnit.UNIT;
        });
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allDeadReplicas, ReplicaDeletionIneligible$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, OfflineReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        if (allTopicsIneligibleForDeletion.nonEmpty()) {
            this.markTopicIneligibleForDeletion((Set<String>)allTopicsIneligibleForDeletion, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "offline replicas");
        }
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.controllerContext.topicsToBeDeleted());
        scala.collection.mutable.Set topicsEligibleForRetry = scala.collection.mutable.Set$.MODULE$.empty();
        scala.collection.mutable.Set topicsEligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handling deletion for topics ").append(topicsQueuedForDeletion.mkString(",")).toString());
        }
        topicsQueuedForDeletion.diff(this.controllerContext.topicsWithDeletionBeingCompleted()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            if ($this.controllerContext.areAllReplicasInState((String)topic, ReplicaDeletionSuccessful$.MODULE$)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("All replicas for ").append((String)topic).append(" have been successfully deleted. Preparing to complete topic deletion.").toString());
                this.prepareCompleteDeleteTopic((String)topic);
            } else if (!$this.controllerContext.isAnyReplicaInState((String)topic, ReplicaDeletionStarted$.MODULE$) && $this.controllerContext.isAnyReplicaInState((String)topic, ReplicaDeletionIneligible$.MODULE$)) {
                topicsEligibleForRetry.$plus$eq(topic);
            }
            if (this.isTopicEligibleForDeletion((String)topic)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion of topic ").append((String)topic).append(" (re)started").toString());
                return topicsEligibleForDeletion.$plus$eq(topic);
            }
            return BoxedUnit.UNIT;
        });
        if (topicsEligibleForRetry.nonEmpty()) {
            this.retryDeletionForIneligibleReplicas((Set<String>)topicsEligibleForRetry);
        }
        if (topicsEligibleForDeletion.nonEmpty()) {
            this.onTopicDeletion((Set<String>)topicsEligibleForDeletion);
        }
    }

    public final void kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(Throwable t, String topic$1) {
        boolean bl = t instanceof RetriableException ? true : t.getCause() != null && t.getCause() instanceof RetriableException;
        if (bl) {
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Retrying topic deletion for tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                this.controllerContext.topicsWithDeletionBeingCompleted().$minus$eq((Object)topic$1);
                this.kafka$controller$TopicDeletionManager$$client.retryDeletion();
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Error deleting tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Error deleting tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ String $anonfun$onPartitionDeletion$3(Set deadReplicas$1, String topic$3) {
        return new StringBuilder(33).append("Dead Replicas (").append(deadReplicas$1.mkString(",")).append(") found for topic ").append(topic$3).toString();
    }

    public TopicDeletionManager(KafkaConfig config, ControllerContext controllerContext, ReplicaStateMachine replicaStateMachine, PartitionStateMachine partitionStateMachine, DeletionClient client, Option<TierTopicManager> tierTopicManagerOpt) {
        this.config = config;
        this.controllerContext = controllerContext;
        this.replicaStateMachine = replicaStateMachine;
        this.partitionStateMachine = partitionStateMachine;
        this.kafka$controller$TopicDeletionManager$$client = client;
        this.tierTopicManagerOpt = tierTopicManagerOpt;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[Topic Deletion Manager ").append(config.brokerId()).append("] ").toString());
        this.isDeleteTopicEnabled = Predef$.MODULE$.Boolean2boolean(config.deleteTopicEnable());
    }
}

