/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.apache.kafka.server.http.MetadataServer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u0005x!B,Y\u0011\u0003if!B0Y\u0011\u0003\u0001\u0007\"\u00026\u0002\t\u0003Yg!\u00027\u0002\u0001jk\u0007BCA\t\u0007\tU\r\u0011\"\u0001\u0002\u0014!Q\u0011\u0011E\u0002\u0003\u0012\u0003\u0006I!!\u0006\t\u0015\u0005\r2A!f\u0001\n\u0003\t)\u0003\u0003\u0006\u0002.\r\u0011\t\u0012)A\u0005\u0003OA!\"a\f\u0004\u0005+\u0007I\u0011AA\u0019\u0011)\t)e\u0001B\tB\u0003%\u00111\u0007\u0005\u000b\u0003\u000f\u001a!Q3A\u0005\u0002\u0005%\u0003BCA&\u0007\tE\t\u0015!\u0003\u0002@!Q\u0011QJ\u0002\u0003\u0016\u0004%\t%a\u0014\t\u0015\u0005u3A!E!\u0002\u0013\t\t\u0006\u0003\u0006\u0002`\r\u0011)\u001a!C!\u0003CB!\"!\u001f\u0004\u0005#\u0005\u000b\u0011BA2\u0011)\tYh\u0001BK\u0002\u0013\u0005\u0013Q\u0010\u0005\u000b\u0003\u0017\u001b!\u0011#Q\u0001\n\u0005}\u0004BCAG\u0007\tU\r\u0011\"\u0011\u0002\u0010\"Q\u00111T\u0002\u0003\u0012\u0003\u0006I!!%\t\r)\u001cA\u0011AAO\u0011%\t\u0019lAA\u0001\n\u0003\t)\fC\u0005\u0002H\u000e\t\n\u0011\"\u0001\u0002J\"I\u0011q\\\u0002\u0012\u0002\u0013\u0005\u0011\u0011\u001d\u0005\n\u0003K\u001c\u0011\u0013!C\u0001\u0003OD\u0011\"a;\u0004#\u0003%\t!!<\t\u0013\u0005E8!%A\u0005\u0002\u0005M\b\"CA|\u0007E\u0005I\u0011AA}\u0011%\tipAI\u0001\n\u0003\ty\u0010C\u0005\u0003\u0004\r\t\n\u0011\"\u0001\u0003\u0006!I!\u0011B\u0002\u0002\u0002\u0013\u0005#1\u0002\u0005\n\u0005'\u0019\u0011\u0011!C\u0001\u0003KA\u0011B!\u0006\u0004\u0003\u0003%\tAa\u0006\t\u0013\t\r2!!A\u0005B\t\u0015\u0002\"\u0003B\u001a\u0007\u0005\u0005I\u0011\u0001B\u001b\u0011%\u0011ydAA\u0001\n\u0003\u0012\t\u0005C\u0005\u0003D\r\t\t\u0011\"\u0011\u0003F!I!qI\u0002\u0002\u0002\u0013\u0005#\u0011J\u0004\u000b\u0005\u001b\n\u0011\u0011!E\u00015\n=c!\u00037\u0002\u0003\u0003E\tA\u0017B)\u0011\u0019Qw\u0005\"\u0001\u0003`!I!1I\u0014\u0002\u0002\u0013\u0015#Q\t\u0005\n\u0005C:\u0013\u0011!CA\u0005GB\u0011B!\u001e(\u0003\u0003%\tIa\u001e\t\u0013\t%u%!A\u0005\n\t-\u0005b\u0002B1\u0003\u0011\u0005!Q\u0012\u0005\b\u0005C\nA\u0011AB[\u0011\u001d\u0011\t'\u0001C\u0001\u0007\u007fC\u0011B!\u0019\u0002\u0003\u0003%\ti!3\t\u0013\tU\u0014!!A\u0005\u0002\u000eU\u0007\"\u0003BE\u0003\u0005\u0005I\u0011\u0002BF\r\u0015y\u0006\f\u0011BI\u0011)\u0011\u0019j\rBK\u0002\u0013\u0005\u0011Q\u0005\u0005\u000b\u0005+\u001b$\u0011#Q\u0001\n\u0005\u001d\u0002B\u0003BLg\tU\r\u0011\"\u0001\u0003\u001a\"Q!qU\u001a\u0003\u0012\u0003\u0006IAa'\t\u0015\t%6G!f\u0001\n\u0003\u0011Y\u000b\u0003\u0006\u0003DN\u0012\t\u0012)A\u0005\u0005[C!B!24\u0005+\u0007I\u0011\u0001Bd\u0011)\u0011Yn\rB\tB\u0003%!\u0011\u001a\u0005\u000b\u0005;\u001c$Q3A\u0005\u0002\t}\u0007B\u0003Btg\tE\t\u0015!\u0003\u0003b\"1!n\rC\u0001\u0005SD\u0011B!>4\u0005\u0004%IAa>\t\u0011\r=1\u0007)A\u0005\u0005sDqAa\u00114\t\u0003\u001a\t\u0002\u0003\u0004kg\u0011\u000511\u0003\u0005\u0007UN\"\taa\u000e\t\u000f\r\u001d3\u0007\"\u0001\u0004J!911K\u001a\u0005\u0002\rU\u0003bBB.g\u0011\u00051Q\f\u0005\b\u0007C\u001aD\u0011AB2\u0011\u001d\u00199g\rC\u0001\u0007SB\u0011b!\"4#\u0003%\t!a@\t\u0013\u0005M6'!A\u0005\u0002\r\u001d\u0005\"CAdgE\u0005I\u0011AAq\u0011%\tynMI\u0001\n\u0003\u0019\u0019\nC\u0005\u0002fN\n\n\u0011\"\u0001\u0004\u0018\"I\u00111^\u001a\u0012\u0002\u0013\u000511\u0014\u0005\n\u0003c\u001c\u0014\u0013!C\u0001\u0007?C\u0011B!\u00034\u0003\u0003%\tEa\u0003\t\u0013\tM1'!A\u0005\u0002\u0005\u0015\u0002\"\u0003B\u000bg\u0005\u0005I\u0011ABR\u0011%\u0011\u0019cMA\u0001\n\u0003\u0012)\u0003C\u0005\u00034M\n\t\u0011\"\u0001\u0004(\"I!qH\u001a\u0002\u0002\u0013\u0005#\u0011\t\u0005\n\u0005\u000f\u001a\u0014\u0011!C!\u0007W\u000baA\u0011:pW\u0016\u0014(BA-[\u0003\u001d\u0019G.^:uKJT\u0011aW\u0001\u0006W\u000647.Y\u0002\u0001!\tq\u0016!D\u0001Y\u0005\u0019\u0011%o\\6feN\u0019\u0011!Y4\u0011\u0005\t,W\"A2\u000b\u0003\u0011\fQa]2bY\u0006L!AZ2\u0003\r\u0005s\u0017PU3g!\t\u0011\u0007.\u0003\u0002jG\na1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012!\u0018\u0002\u000b'\u0016\u0014h/\u001a:J]\u001a|7CB\u0002om\u0006-q\r\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006!A.\u00198h\u0015\u0005\u0019\u0018\u0001\u00026bm\u0006L!!\u001e9\u0003\r=\u0013'.Z2u!\r9\u0018qA\u0007\u0002q*\u0011\u0011P_\u0001\nS:$XM\u001d8bYNT!a\u001f?\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002~}\u000611/\u001a:wKJT!aW@\u000b\t\u0005\u0005\u00111A\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0015\u0011aA8sO&\u0019\u0011\u0011\u0002=\u0003;\r{gN\u001a7vK:$\u0018)\u001e;i_JL'0\u001a:TKJ4XM]%oM>\u00042AYA\u0007\u0013\r\tya\u0019\u0002\b!J|G-^2u\u0003=\u0019G.^:uKJ\u0014Vm]8ve\u000e,WCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e}\u000611m\\7n_:LA!a\b\u0002\u001a\ty1\t\\;ti\u0016\u0014(+Z:pkJ\u001cW-\u0001\tdYV\u001cH/\u001a:SKN|WO]2fA\u0005A!M]8lKJLE-\u0006\u0002\u0002(A\u0019!-!\u000b\n\u0007\u0005-2MA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0013\u0015tG\r]8j]R\u001cXCAA\u001a!\u0019\t)$a\u000f\u0002@5\u0011\u0011q\u0007\u0006\u0004\u0003s\u0011\u0018\u0001B;uS2LA!!\u0010\u00028\t!A*[:u!\u0011\t9\"!\u0011\n\t\u0005\r\u0013\u0011\u0004\u0002\t\u000b:$\u0007o\\5oi\u0006QQM\u001c3q_&tGo\u001d\u0011\u0002'%tG/\u001a:Ce>\\WM]#oIB|\u0017N\u001c;\u0016\u0005\u0005}\u0012\u0001F5oi\u0016\u0014(I]8lKJ,e\u000e\u001a9pS:$\b%\u0001\bnKR\fG-\u0019;b'\u0016\u0014h/\u001a:\u0016\u0005\u0005E\u0003\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]C0\u0001\u0003iiR\u0004\u0018\u0002BA.\u0003+\u0012a\"T3uC\u0012\fG/Y*feZ,'/A\bnKR\fG-\u0019;b'\u0016\u0014h/\u001a:!\u0003AAG\u000f\u001e9TKJ4XM\u001d\"j]\u0012,'/\u0006\u0002\u0002dA!\u0011QMA;\u001b\t\t9GC\u0002~\u0003SRA!a\u0016\u0002l)\u00191,!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\nG>tg\r\\;f]RT!!a\u001d\u0002\u0005%|\u0017\u0002BA<\u0003O\u0012QcS1gW\u0006DE\u000f\u001e9TKJ4XM\u001d\"j]\u0012,'/A\tiiR\u00048+\u001a:wKJ\u0014\u0015N\u001c3fe\u0002\n\u0001#Y;eSRdun\u001a)s_ZLG-\u001a:\u0016\u0005\u0005}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015E0A\u0003bk\u0012LG/\u0003\u0003\u0002\n\u0006\r%\u0001E!vI&$Hj\\4Qe>4\u0018\u000eZ3s\u0003E\tW\u000fZ5u\u0019><\u0007K]8wS\u0012,'\u000fI\u0001\b[\u0016$(/[2t+\t\t\t\n\u0005\u0003\u0002\u0014\u0006]UBAAK\u0015\u0011\ti)!\u0007\n\t\u0005e\u0015Q\u0013\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004CCEAP\u0003G\u000b)+a*\u0002*\u0006-\u0016QVAX\u0003c\u00032!!)\u0004\u001b\u0005\t\u0001bBA\t)\u0001\u0007\u0011Q\u0003\u0005\b\u0003G!\u0002\u0019AA\u0014\u0011\u001d\ty\u0003\u0006a\u0001\u0003gAq!a\u0012\u0015\u0001\u0004\ty\u0004C\u0004\u0002NQ\u0001\r!!\u0015\t\u000f\u0005}C\u00031\u0001\u0002d!9\u00111\u0010\u000bA\u0002\u0005}\u0004bBAG)\u0001\u0007\u0011\u0011S\u0001\u0005G>\u0004\u0018\u0010\u0006\n\u0002 \u0006]\u0016\u0011XA^\u0003{\u000by,!1\u0002D\u0006\u0015\u0007\"CA\t+A\u0005\t\u0019AA\u000b\u0011%\t\u0019#\u0006I\u0001\u0002\u0004\t9\u0003C\u0005\u00020U\u0001\n\u00111\u0001\u00024!I\u0011qI\u000b\u0011\u0002\u0003\u0007\u0011q\b\u0005\n\u0003\u001b*\u0002\u0013!a\u0001\u0003#B\u0011\"a\u0018\u0016!\u0003\u0005\r!a\u0019\t\u0013\u0005mT\u0003%AA\u0002\u0005}\u0004\"CAG+A\u0005\t\u0019AAI\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a3+\t\u0005U\u0011QZ\u0016\u0003\u0003\u001f\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\\2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002^\u0006M'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAArU\u0011\t9#!4\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001e\u0016\u0005\u0003g\ti-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005=(\u0006BA \u0003\u001b\fabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0002v*\"\u0011\u0011KAg\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"!a?+\t\u0005\r\u0014QZ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011\tA\u000b\u0003\u0002\u0000\u00055\u0017AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005\u000fQC!!%\u0002N\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0004\u0011\u0007=\u0014y!C\u0002\u0003\u0012A\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00053\u0011y\u0002E\u0002c\u00057I1A!\bd\u0005\r\te.\u001f\u0005\n\u0005C\u0001\u0013\u0011!a\u0001\u0003O\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0014!\u0019\u0011ICa\f\u0003\u001a5\u0011!1\u0006\u0006\u0004\u0005[\u0019\u0017AC2pY2,7\r^5p]&!!\u0011\u0007B\u0016\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t]\"Q\b\t\u0004E\ne\u0012b\u0001B\u001eG\n9!i\\8mK\u0006t\u0007\"\u0003B\u0011E\u0005\u0005\t\u0019\u0001B\r\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0014\u0003!!xn\u0015;sS:<GC\u0001B\u0007\u0003\u0019)\u0017/^1mgR!!q\u0007B&\u0011%\u0011\t#JA\u0001\u0002\u0004\u0011I\"\u0001\u0006TKJ4XM]%oM>\u00042!!)('\u00119#1K4\u0011-\tU#1LA\u000b\u0003O\t\u0019$a\u0010\u0002R\u0005\r\u0014qPAI\u0003?k!Aa\u0016\u000b\u0007\te3-A\u0004sk:$\u0018.\\3\n\t\tu#q\u000b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:DDC\u0001B(\u0003\u0015\t\u0007\u000f\u001d7z)I\tyJ!\u001a\u0003h\t%$1\u000eB7\u0005_\u0012\tHa\u001d\t\u000f\u0005E!\u00061\u0001\u0002\u0016!9\u00111\u0005\u0016A\u0002\u0005\u001d\u0002bBA\u0018U\u0001\u0007\u00111\u0007\u0005\b\u0003\u000fR\u0003\u0019AA \u0011\u001d\tiE\u000ba\u0001\u0003#Bq!a\u0018+\u0001\u0004\t\u0019\u0007C\u0004\u0002|)\u0002\r!a \t\u000f\u00055%\u00061\u0001\u0002\u0012\u00069QO\\1qa2LH\u0003\u0002B=\u0005\u000b\u0003RA\u0019B>\u0005\u007fJ1A! d\u0005\u0019y\u0005\u000f^5p]B\u0019\"M!!\u0002\u0016\u0005\u001d\u00121GA \u0003#\n\u0019'a \u0002\u0012&\u0019!1Q2\u0003\rQ+\b\u000f\\39\u0011%\u00119iKA\u0001\u0002\u0004\ty*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\ta\u000e\u0006\u0005\u0003\u0010\u000e=6\u0011WBZ!\tq6gE\u00034C\u0006-q-\u0001\u0002jI\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0013\u0015tG\rU8j]R\u001cXC\u0001BN!\u0019\u0011IC!(\u0003\"&!!q\u0014B\u0016\u0005\r\u0019V-\u001d\t\u0004=\n\r\u0016b\u0001BS1\nAQI\u001c3Q_&tG/\u0001\u0006f]\u0012\u0004v.\u001b8ug\u0002\nAA]1dWV\u0011!Q\u0016\t\u0006E\nm$q\u0016\t\u0005\u0005c\u0013yL\u0004\u0003\u00034\nm\u0006c\u0001B[G6\u0011!q\u0017\u0006\u0004\u0005sc\u0016A\u0002\u001fs_>$h(C\u0002\u0003>\u000e\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B\t\u0005\u0003T1A!0d\u0003\u0015\u0011\u0018mY6!\u0003!1W-\u0019;ve\u0016\u001cXC\u0001Be!\u0019\u0011YM!5\u0003V6\u0011!Q\u001a\u0006\u0005\u0005\u001f\fI\"A\u0004gK\u0006$XO]3\n\t\tM'Q\u001a\u0002\t\r\u0016\fG/\u001e:fgB!!1\u001aBl\u0013\u0011\u0011IN!4\u0003+M+\b\u000f]8si\u0016$g+\u001a:tS>t'+\u00198hK\u0006Ia-Z1ukJ,7\u000fI\u0001\u0005i\u0006<7/\u0006\u0002\u0003bBA!\u0011\u0017Br\u0005_\u0013y+\u0003\u0003\u0003f\n\u0005'aA'ba\u0006)A/Y4tAQa!q\u0012Bv\u0005[\u0014yO!=\u0003t\"9!1\u0013 A\u0002\u0005\u001d\u0002b\u0002BL}\u0001\u0007!1\u0014\u0005\b\u0005Ss\u0004\u0019\u0001BW\u0011\u001d\u0011)M\u0010a\u0001\u0005\u0013DqA!8?\u0001\u0004\u0011\t/\u0001\u0007f]\u0012\u0004v.\u001b8ug6\u000b\u0007/\u0006\u0002\u0003zBA!1`B\u0001\u0007\u0007\u0011\t+\u0004\u0002\u0003~*!!q B\u0016\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003f\nu\b\u0003BB\u0003\u0007\u0017i!aa\u0002\u000b\t\r%\u0011\u0011D\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0019iaa\u0002\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u001b\u0015tG\rU8j]R\u001cX*\u00199!)\t\u0011y\u000b\u0006\u0007\u0003\u0010\u000eU1qCB\u000e\u0007?\u0019\u0019\u0003C\u0004\u0003\u0014\n\u0003\r!a\n\t\u000f\re!\t1\u0001\u00030\u0006!\u0001n\\:u\u0011\u001d\u0019iB\u0011a\u0001\u0003O\tA\u0001]8si\"91\u0011\u0005\"A\u0002\r\r\u0011\u0001\u00047jgR,g.\u001a:OC6,\u0007bBB\u0013\u0005\u0002\u00071qE\u0001\taJ|Go\\2pYB!1\u0011FB\u001a\u001b\t\u0019YC\u0003\u0003\u0004.\r=\u0012\u0001B1vi\"TAa!\r\u0002\u001a\u0005A1/Z2ve&$\u00180\u0003\u0003\u00046\r-\"\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m)!\u0011yi!\u000f\u0004D\r\u0015\u0003bBB\u001e\u0007\u0002\u00071QH\u0001\u0004E\u0016\u0004\bc\u00010\u0004@%\u00191\u0011\t-\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\"91\u0011E\"A\u0002\r\r\u0001bBB\u0013\u0007\u0002\u00071qE\u0001\u0005]>$W\r\u0006\u0003\u0004L\rE\u0003\u0003BA\f\u0007\u001bJAaa\u0014\u0002\u001a\t!aj\u001c3f\u0011\u001d\u0019\t\u0003\u0012a\u0001\u0007\u0007\tqaZ3u\u001d>$W\r\u0006\u0003\u0004X\re\u0003#\u00022\u0003|\r-\u0003bBB\u0011\u000b\u0002\u000711A\u0001\u000fEJ|7.\u001a:F]\u0012\u0004v.\u001b8u)\u0011\u0019ida\u0018\t\u000f\r\u0005b\t1\u0001\u0004\u0004\u0005AQM\u001c3Q_&tG\u000f\u0006\u0003\u0003\"\u000e\u0015\u0004bBB\u0011\u000f\u0002\u000711A\u0001\ri>\u001cVM\u001d<fe&sgm\u001c\u000b\u000em\u000e-4qNB?\u0007\u007f\u001a\tia!\t\u000f\r5\u0004\n1\u0001\u00030\u0006I1\r\\;ti\u0016\u0014\u0018\n\u001a\u0005\b\u0007cB\u0005\u0019AB:\u0003\u0019\u0019wN\u001c4jOB!1QOB=\u001b\t\u00199H\u0003\u0002~5&!11PB<\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\u00055\u0003\n1\u0001\u0002R!9\u0011q\f%A\u0002\u0005\r\u0004\"CA>\u0011B\u0005\t\u0019AA@\u0011\u001d\ti\t\u0013a\u0001\u0003#\u000ba\u0003^8TKJ4XM]%oM>$C-\u001a4bk2$H%\u000e\u000b\r\u0005\u001f\u001bIia#\u0004\u000e\u000e=5\u0011\u0013\u0005\n\u0005'S\u0005\u0013!a\u0001\u0003OA\u0011Ba&K!\u0003\u0005\rAa'\t\u0013\t%&\n%AA\u0002\t5\u0006\"\u0003Bc\u0015B\u0005\t\u0019\u0001Be\u0011%\u0011iN\u0013I\u0001\u0002\u0004\u0011\t/\u0006\u0002\u0004\u0016*\"!1TAg+\t\u0019IJ\u000b\u0003\u0003.\u00065WCABOU\u0011\u0011I-!4\u0016\u0005\r\u0005&\u0006\u0002Bq\u0003\u001b$BA!\u0007\u0004&\"I!\u0011\u0005*\u0002\u0002\u0003\u0007\u0011q\u0005\u000b\u0005\u0005o\u0019I\u000bC\u0005\u0003\"Q\u000b\t\u00111\u0001\u0003\u001aQ!!qGBW\u0011%\u0011\tCVA\u0001\u0002\u0004\u0011I\u0002C\u0004\u0003\u00146\u0002\r!a\n\t\u000f\t]U\u00061\u0001\u0003\u001c\"9!\u0011V\u0017A\u0002\t5FC\u0003BH\u0007o\u001bIla/\u0004>\"9!1\u0013\u0018A\u0002\u0005\u001d\u0002b\u0002BL]\u0001\u0007!1\u0014\u0005\b\u0005Ss\u0003\u0019\u0001BW\u0011\u001d\u0011)M\fa\u0001\u0005\u0013$\"Ba$\u0004B\u000e\r7QYBd\u0011\u001d\u0011\u0019j\fa\u0001\u0003OAqAa&0\u0001\u0004\u0011Y\nC\u0004\u0003*>\u0002\rA!,\t\u000f\tuw\u00061\u0001\u0003bRa!qRBf\u0007\u001b\u001cym!5\u0004T\"9!1\u0013\u0019A\u0002\u0005\u001d\u0002b\u0002BLa\u0001\u0007!1\u0014\u0005\b\u0005S\u0003\u0004\u0019\u0001BW\u0011\u001d\u0011)\r\ra\u0001\u0005\u0013DqA!81\u0001\u0004\u0011\t\u000f\u0006\u0003\u0004X\u000e}\u0007#\u00022\u0003|\re\u0007#\u00042\u0004\\\u0006\u001d\"1\u0014BW\u0005\u0013\u0014\t/C\u0002\u0004^\u000e\u0014a\u0001V;qY\u0016,\u0004\"\u0003BDc\u0005\u0005\t\u0019\u0001BH\u0001")
public class Broker
implements Product,
scala.Serializable {
    private final int id;
    private final Seq<EndPoint> endPoints;
    private final Option<String> rack;
    private final Features<SupportedVersionRange> features;
    private final scala.collection.immutable.Map<String, String> tags;
    private final scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap;

    public static Option<Tuple5<Object, Seq<EndPoint>, Option<String>, Features<SupportedVersionRange>, scala.collection.immutable.Map<String, String>>> unapply(Broker broker) {
        return Broker$.MODULE$.unapply(broker);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> map) {
        return Broker$.MODULE$.apply(n, seq, option, features, map);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, scala.collection.immutable.Map<String, String> map) {
        return Broker$.MODULE$.apply(n, seq, option, map);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, Features<SupportedVersionRange> features) {
        return Broker$.MODULE$.apply(n, seq, option, features);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option) {
        return Broker$.MODULE$.apply(n, seq, option);
    }

    public int id() {
        return this.id;
    }

    public Seq<EndPoint> endPoints() {
        return this.endPoints;
    }

    public Option<String> rack() {
        return this.rack;
    }

    public Features<SupportedVersionRange> features() {
        return this.features;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap() {
        return this.endPointsMap;
    }

    public String toString() {
        return new StringBuilder(9).append(this.id()).append(" : ").append(this.endPointsMap().values().mkString("(", ",", ")")).append(" : ").append(this.rack().orNull(Predef$.MODULE$.$conforms())).append(" : ").append(this.features()).toString();
    }

    public Node node(ListenerName listenerName) {
        return (Node)this.getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found ").append("for broker ").append(this.id()).toString());
        });
    }

    public Option<Node> getNode(ListenerName listenerName) {
        return this.endPointsMap().get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)endpoint -> new ConfluentNode(this.id(), endpoint.host(), endpoint.port(), (String)this.rack().orNull(Predef$.MODULE$.$conforms()), (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava()));
    }

    public BrokerEndPoint brokerEndPoint(ListenerName listenerName) {
        EndPoint endpoint = this.endPoint(listenerName);
        return new BrokerEndPoint(this.id(), endpoint.host(), endpoint.port());
    }

    public EndPoint endPoint(ListenerName listenerName) {
        return (EndPoint)this.endPointsMap().getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found for broker ").append(this.id()).toString());
        });
    }

    public ConfluentAuthorizerServerInfo toServerInfo(String clusterId, KafkaConfig config, MetadataServer metadataServer, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
        ClusterResource clusterResource = new ClusterResource(clusterId);
        Endpoint interBrokerEndpoint = this.endPoint(config.interBrokerListenerName()).toJava();
        java.util.List brokerEndpoints = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.endPoints().toList().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), List$.MODULE$.canBuildFrom())).asJava();
        return new ServerInfo(clusterResource, this.id(), brokerEndpoints, interBrokerEndpoint, metadataServer, httpServerBinder, auditLogProvider, metrics);
    }

    public AuditLogProvider toServerInfo$default$5() {
        return NoOpAuditLogProvider.INSTANCE;
    }

    public Broker copy(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        return new Broker(id, endPoints, rack, features, tags);
    }

    public int copy$default$1() {
        return this.id();
    }

    public Seq<EndPoint> copy$default$2() {
        return this.endPoints();
    }

    public Option<String> copy$default$3() {
        return this.rack();
    }

    public Features<SupportedVersionRange> copy$default$4() {
        return this.features();
    }

    public scala.collection.immutable.Map<String, String> copy$default$5() {
        return this.tags();
    }

    public String productPrefix() {
        return "Broker";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.id());
            }
            case 1: {
                return this.endPoints();
            }
            case 2: {
                return this.rack();
            }
            case 3: {
                return this.features();
            }
            case 4: {
                return this.tags();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Broker;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.id()), (int)Statics.anyHash(this.endPoints())), (int)Statics.anyHash(this.rack())), (int)Statics.anyHash(this.features())), (int)Statics.anyHash(this.tags())), (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof Broker)) return false;
        boolean bl = true;
        if (!bl) return false;
        Broker broker = (Broker)x$1;
        if (this.id() != broker.id()) return false;
        Seq<EndPoint> seq = this.endPoints();
        Seq<EndPoint> seq2 = broker.endPoints();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<String> option = this.rack();
        Option<String> option2 = broker.rack();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Features<SupportedVersionRange> features = this.features();
        Features<SupportedVersionRange> features2 = broker.features();
        if (features == null) {
            if (features2 != null) {
                return false;
            }
        } else if (!features.equals(features2)) return false;
        scala.collection.immutable.Map<String, String> map = this.tags();
        scala.collection.immutable.Map<String, String> map2 = broker.tags();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!broker.canEqual(this)) return false;
        return true;
    }

    public Broker(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        this.id = id;
        this.endPoints = endPoints;
        this.rack = rack;
        this.features = features;
        this.tags = tags;
        Product.$init$((Product)this);
        this.endPointsMap = ((TraversableOnce)endPoints.map((Function1 & Serializable & scala.Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName()), endPoint), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (this.endPointsMap().size() != endPoints.size()) {
            throw new IllegalArgumentException(new StringBuilder(62).append("There is more than one end point with the same listener name: ").append(endPoints.mkString(",")).toString());
        }
    }

    public Broker(int id, String host, int port, ListenerName listenerName, SecurityProtocol protocol) {
        this(id, (Seq<EndPoint>)new .colon.colon((Object)new EndPoint(host, port, listenerName, protocol), (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, (Features<SupportedVersionRange>)Features.emptySupportedFeatures(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Broker(BrokerEndPoint bep, ListenerName listenerName, SecurityProtocol protocol) {
        this(bep.id(), bep.host(), bep.port(), listenerName, protocol);
    }

    public static class ServerInfo
    implements ConfluentAuthorizerServerInfo,
    Product,
    scala.Serializable {
        private final ClusterResource clusterResource;
        private final int brokerId;
        private final java.util.List<Endpoint> endpoints;
        private final Endpoint interBrokerEndpoint;
        private final MetadataServer metadataServer;
        private final KafkaHttpServerBinder httpServerBinder;
        private final AuditLogProvider auditLogProvider;
        private final Metrics metrics;

        public ClusterResource clusterResource() {
            return this.clusterResource;
        }

        public int brokerId() {
            return this.brokerId;
        }

        public java.util.List<Endpoint> endpoints() {
            return this.endpoints;
        }

        public Endpoint interBrokerEndpoint() {
            return this.interBrokerEndpoint;
        }

        public MetadataServer metadataServer() {
            return this.metadataServer;
        }

        public KafkaHttpServerBinder httpServerBinder() {
            return this.httpServerBinder;
        }

        public AuditLogProvider auditLogProvider() {
            return this.auditLogProvider;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public ServerInfo copy(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, MetadataServer metadataServer, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
            return new ServerInfo(clusterResource, brokerId, endpoints, interBrokerEndpoint, metadataServer, httpServerBinder, auditLogProvider, metrics);
        }

        public ClusterResource copy$default$1() {
            return this.clusterResource();
        }

        public int copy$default$2() {
            return this.brokerId();
        }

        public java.util.List<Endpoint> copy$default$3() {
            return this.endpoints();
        }

        public Endpoint copy$default$4() {
            return this.interBrokerEndpoint();
        }

        public MetadataServer copy$default$5() {
            return this.metadataServer();
        }

        public KafkaHttpServerBinder copy$default$6() {
            return this.httpServerBinder();
        }

        public AuditLogProvider copy$default$7() {
            return this.auditLogProvider();
        }

        public Metrics copy$default$8() {
            return this.metrics();
        }

        public String productPrefix() {
            return "ServerInfo";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.clusterResource();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokerId());
                }
                case 2: {
                    return this.endpoints();
                }
                case 3: {
                    return this.interBrokerEndpoint();
                }
                case 4: {
                    return this.metadataServer();
                }
                case 5: {
                    return this.httpServerBinder();
                }
                case 6: {
                    return this.auditLogProvider();
                }
                case 7: {
                    return this.metrics();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServerInfo;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.clusterResource())), (int)this.brokerId()), (int)Statics.anyHash((Object)this.endpoints())), (int)Statics.anyHash((Object)this.interBrokerEndpoint())), (int)Statics.anyHash((Object)this.metadataServer())), (int)Statics.anyHash((Object)this.httpServerBinder())), (int)Statics.anyHash((Object)this.auditLogProvider())), (int)Statics.anyHash((Object)this.metrics())), (int)8);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ServerInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            ServerInfo serverInfo = (ServerInfo)x$1;
            ClusterResource clusterResource = this.clusterResource();
            ClusterResource clusterResource2 = serverInfo.clusterResource();
            if (clusterResource == null) {
                if (clusterResource2 != null) {
                    return false;
                }
            } else if (!clusterResource.equals(clusterResource2)) return false;
            if (this.brokerId() != serverInfo.brokerId()) return false;
            Collection collection = this.endpoints();
            Collection collection2 = serverInfo.endpoints();
            if (collection == null) {
                if (collection2 != null) {
                    return false;
                }
            } else if (!((Object)collection).equals(collection2)) return false;
            Endpoint endpoint = this.interBrokerEndpoint();
            Endpoint endpoint2 = serverInfo.interBrokerEndpoint();
            if (endpoint == null) {
                if (endpoint2 != null) {
                    return false;
                }
            } else if (!endpoint.equals(endpoint2)) return false;
            MetadataServer metadataServer = this.metadataServer();
            MetadataServer metadataServer2 = serverInfo.metadataServer();
            if (metadataServer == null) {
                if (metadataServer2 != null) {
                    return false;
                }
            } else if (!metadataServer.equals(metadataServer2)) return false;
            KafkaHttpServerBinder kafkaHttpServerBinder = this.httpServerBinder();
            KafkaHttpServerBinder kafkaHttpServerBinder2 = serverInfo.httpServerBinder();
            if (kafkaHttpServerBinder == null) {
                if (kafkaHttpServerBinder2 != null) {
                    return false;
                }
            } else if (!kafkaHttpServerBinder.equals(kafkaHttpServerBinder2)) return false;
            AuditLogProvider auditLogProvider = this.auditLogProvider();
            AuditLogProvider auditLogProvider2 = serverInfo.auditLogProvider();
            if (auditLogProvider == null) {
                if (auditLogProvider2 != null) {
                    return false;
                }
            } else if (!auditLogProvider.equals(auditLogProvider2)) return false;
            Metrics metrics = this.metrics();
            Metrics metrics2 = serverInfo.metrics();
            if (metrics == null) {
                if (metrics2 != null) {
                    return false;
                }
            } else if (!metrics.equals(metrics2)) return false;
            if (!serverInfo.canEqual(this)) return false;
            return true;
        }

        public ServerInfo(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, MetadataServer metadataServer, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
            this.clusterResource = clusterResource;
            this.brokerId = brokerId;
            this.endpoints = endpoints;
            this.interBrokerEndpoint = interBrokerEndpoint;
            this.metadataServer = metadataServer;
            this.httpServerBinder = httpServerBinder;
            this.auditLogProvider = auditLogProvider;
            this.metrics = metrics;
            Product.$init$((Product)this);
        }
    }
}

