/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Map;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_1_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_8_0$;
import kafka.api.KAFKA_0_8_1$;
import kafka.api.KAFKA_0_8_2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV0$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.KAFKA_2_5_IV0$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.api.KAFKA_2_7_IV2$;
import kafka.api.KAFKA_2_8_IV0$;
import kafka.api.KAFKA_2_8_IV1$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ApiVersion$ {
    public static ApiVersion$ MODULE$;
    private final Seq<ApiVersion> allVersions;
    private final scala.collection.immutable.Map<String, ApiVersion> versionMap;
    private final ApiVersion latestVersion;

    static {
        new ApiVersion$();
    }

    public <A extends ApiVersion> Ordering<A> orderingByVersion() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public Seq<ApiVersion> allVersions() {
        return this.allVersions;
    }

    private scala.collection.immutable.Map<String, ApiVersion> versionMap() {
        return this.versionMap;
    }

    public ApiVersion apply(String versionString) {
        Seq versionSegments = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(versionString)).split('.'))).toSeq();
        int numSegments = versionString.startsWith("0.") ? 3 : 2;
        String key = ((TraversableOnce)versionSegments.take(numSegments)).mkString(".");
        return (ApiVersion)this.versionMap().getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(33).append("Version `").append(versionString).append("` is not a valid version").toString());
        });
    }

    public ApiVersion latestVersion() {
        return this.latestVersion;
    }

    public ApiVersion minTierFeatureSupported() {
        return KAFKA_2_4_IV1$.MODULE$;
    }

    public boolean isTruncationOnFetchSupported(ApiVersion version) {
        return version.$greater$eq(KAFKA_2_7_IV1$.MODULE$);
    }

    public ApiVersion minSupportedFor(RecordVersion recordVersion) {
        scala.Serializable serializable;
        if (RecordVersion.V0.equals(recordVersion)) {
            serializable = KAFKA_0_8_0$.MODULE$;
        } else if (RecordVersion.V1.equals(recordVersion)) {
            serializable = KAFKA_0_10_0_IV0$.MODULE$;
        } else if (RecordVersion.V2.equals(recordVersion)) {
            serializable = KAFKA_0_11_0_IV0$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid message format version ").append(recordVersion).toString());
        }
        return serializable;
    }

    public ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, RecordVersion minRecordVersion, Features<SupportedVersionRange> latestSupportedFeatures, Option<NodeApiVersions> controllerApiVersions, ApiMessageType.ListenerType listenerType) {
        return this.apiVersionsResponse(throttleTimeMs, minRecordVersion, latestSupportedFeatures, (Features<FinalizedVersionRange>)Features.emptyFinalizedFeatures(), -1L, controllerApiVersions, listenerType);
    }

    public ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, RecordVersion minRecordVersion, Features<SupportedVersionRange> latestSupportedFeatures, Features<FinalizedVersionRange> finalizedFeatures, long finalizedFeaturesEpoch, Option<NodeApiVersions> controllerApiVersions, ApiMessageType.ListenerType listenerType) {
        ApiVersionsResponseData.ApiVersionCollection apiVersionCollection;
        if (None$.MODULE$.equals(controllerApiVersions)) {
            apiVersionCollection = ApiVersionsResponse.filterApis((RecordVersion)minRecordVersion, (ApiMessageType.ListenerType)listenerType);
        } else if (controllerApiVersions instanceof Some) {
            NodeApiVersions controllerApiVersion = (NodeApiVersions)((Some)controllerApiVersions).value();
            apiVersionCollection = ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)listenerType, (RecordVersion)minRecordVersion, (Map)controllerApiVersion.allSupportedApiVersions());
        } else {
            throw new MatchError(controllerApiVersions);
        }
        return ApiVersionsResponse.createApiVersionsResponse((int)throttleTimeMs, (ApiVersionsResponseData.ApiVersionCollection)apiVersionCollection, latestSupportedFeatures, finalizedFeatures, (long)finalizedFeaturesEpoch);
    }

    private ApiVersion$() {
        MODULE$ = this;
        this.allVersions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ApiVersion[]{KAFKA_0_8_0$.MODULE$, KAFKA_0_8_1$.MODULE$, KAFKA_0_8_2$.MODULE$, KAFKA_0_9_0$.MODULE$, KAFKA_0_10_0_IV0$.MODULE$, KAFKA_0_10_0_IV1$.MODULE$, KAFKA_0_10_1_IV0$.MODULE$, KAFKA_0_10_1_IV1$.MODULE$, KAFKA_0_10_1_IV2$.MODULE$, KAFKA_0_10_2_IV0$.MODULE$, KAFKA_0_11_0_IV0$.MODULE$, KAFKA_0_11_0_IV1$.MODULE$, KAFKA_0_11_0_IV2$.MODULE$, KAFKA_1_0_IV0$.MODULE$, KAFKA_1_1_IV0$.MODULE$, KAFKA_2_0_IV0$.MODULE$, KAFKA_2_0_IV1$.MODULE$, KAFKA_2_1_IV0$.MODULE$, KAFKA_2_1_IV1$.MODULE$, KAFKA_2_1_IV2$.MODULE$, KAFKA_2_2_IV0$.MODULE$, KAFKA_2_2_IV1$.MODULE$, KAFKA_2_3_IV0$.MODULE$, KAFKA_2_3_IV1$.MODULE$, KAFKA_2_4_IV0$.MODULE$, KAFKA_2_4_IV1$.MODULE$, KAFKA_2_5_IV0$.MODULE$, KAFKA_2_6_IV0$.MODULE$, KAFKA_2_7_IV0$.MODULE$, KAFKA_2_7_IV1$.MODULE$, KAFKA_2_7_IV2$.MODULE$, KAFKA_2_8_IV0$.MODULE$, KAFKA_2_8_IV1$.MODULE$}));
        this.versionMap = ((TraversableOnce)this.allVersions().map((Function1 & Serializable & scala.Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.version()), v), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)this.allVersions().groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.shortVersion()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            Seq v = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.last());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        this.latestVersion = (ApiVersion)this.allVersions().last();
    }
}

