/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.MirrorCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.TopicMirrorDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.io.StdIn$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MirrorCommand$
implements Logging {
    public static MirrorCommand$ MODULE$;
    private final SimpleDateFormat formatter;
    private int exitCode;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new MirrorCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private SimpleDateFormat formatter() {
        return this.formatter;
    }

    private int exitCode() {
        return this.exitCode;
    }

    private void exitCode_$eq(int x$1) {
        this.exitCode = x$1;
    }

    public void main(String[] args) {
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(38).append("Error while executing mirror command: ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(MirrorCommand$.$anonfun$main$1(e)));
                }
                this.exitCode_$eq(1);
            }
        }
        finally {
            Exit.exit((int)this.exitCode());
        }
    }

    private ConfluentAdmin createAdminClient(MirrorCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options().valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)AdminClient.create((Properties)props);
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        block19: {
            MirrorCommandOptions opts = new MirrorCommandOptions(args);
            opts.checkArgs();
            try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createAdminClient(opts));){
                try {
                    if (opts.options().has((OptionSpec)opts.listOpt())) {
                        this.listMirrors(opts, client);
                    } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                        this.describeMirrors(opts, client);
                    } else if (opts.options().has((OptionSpec)opts.promoteOpt())) {
                        this.stopMirrors(opts, client, AlterMirrorOp.PROMOTE);
                    } else if (opts.options().has((OptionSpec)opts.failoverOpt())) {
                        this.stopMirrors(opts, client, AlterMirrorOp.FAILOVER);
                    } else if (opts.options().has((OptionSpec)opts.pauseOpt())) {
                        this.pauseMirrors(opts, client, AlterMirrorOp.PAUSE);
                    } else if (opts.options().has((OptionSpec)opts.unpauseOpt())) {
                        this.pauseMirrors(opts, client, AlterMirrorOp.RESUME);
                    }
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        TimeoutException timeoutException = (TimeoutException)throwable;
                        MirrorCommand$.throwAdminCommandFailedException$1("Timed out waiting for results", timeoutException);
                        break block19;
                    }
                    if (throwable instanceof ClusterAuthorizationException) {
                        ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                        MirrorCommand$.throwAdminCommandFailedException$1(clusterAuthorizationException.getMessage(), (Throwable)clusterAuthorizationException);
                        break block19;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private Seq<String> doListMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        ListMirrorsOptions options = new ListMirrorsOptions().includeStopped(opts.includeStopped());
        opts.linkName().foreach((Function1 & Serializable & scala.Serializable)linkName -> options.linkName(Optional.of(linkName)));
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)client.listMirrors(options).result().get()).asScala()).toSeq();
    }

    private void listMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        this.doListMirrors(opts, client).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            Predef$.MODULE$.println((Object)topic);
            return BoxedUnit.UNIT;
        });
    }

    private void describeMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        Seq<String> topics = this.resolveTopics(opts, client);
        DescribeMirrorsOptions options = new DescribeMirrorsOptions();
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(client.describeMirrors((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava(), options).result()).asScala();
        if (result.nonEmpty()) {
            scala.collection.immutable.Set partitions = ((TraversableOnce)result.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                scala.collection.immutable.Set set;
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    try {
                        TopicMirrorDescription desc = (TopicMirrorDescription)((KafkaFuture)x0$1._2()).get();
                        set = ((TraversableOnce)package$.MODULE$.Range().apply(0, desc.numPartitions()).map((Function1 & Serializable & scala.Serializable)part -> MirrorCommand$.$anonfun$describeMirrors$2(topic, BoxesRunTime.unboxToInt((Object)part)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                    }
                    catch (Throwable e) {
                        Predef$.MODULE$.println((Object)new StringBuilder(58).append("Unable to get mirror topic description for mirror topic ").append(topic).append(": ").append(e).toString());
                        set = Predef$.MODULE$.Set().empty();
                    }
                } else {
                    throw new MatchError(null);
                }
                scala.collection.immutable.Set set2 = set;
                return set2;
            }, Iterable$.MODULE$.canBuildFrom())).toSet();
            scala.collection.mutable.Map replicas = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(client.replicaStatus((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)partitions).asJava(), new ReplicaStatusOptions()).result()).asScala();
            result.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                MirrorCommand$.$anonfun$describeMirrors$3(replicas, opts, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        Predef$.MODULE$.println((Object)"No mirror topics found.");
    }

    private void printMirrorTopicInformation(TopicMirrorDescription desc) {
        Predef$.MODULE$.print((Object)new StringBuilder(11).append("\tLinkName: ").append(desc.linkName()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder(9).append("\tLinkId: ").append(desc.linkId()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder(14).append("\tMirrorTopic: ").append(desc.mirrorTopic()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder(8).append("\tState: ").append(desc.state()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder(12).append("\tStateTime: ").append(this.timeToDate(desc.stateTimeMs())).toString());
    }

    private void printMirrorPartitionInformation(ReplicaStatus.MirrorInfo mi, ReplicaStatus leader, int part) {
        Predef$.MODULE$.println();
        Predef$.MODULE$.print((Object)new StringBuilder(12).append("\tPartition: ").append(part).toString());
        long timeSinceLastFetchMs = leader.lastCaughtUpTimeMs() - mi.lastFetchTimeMs();
        Predef$.MODULE$.print((Object)new StringBuilder(8).append("\tState: ").append(mi.state().toString()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder(19).append("\tDestLogEndOffset: ").append(leader.logEndOffset()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder(31).append("\tLastFetchSourceHighWatermark: ").append(mi.lastFetchSourceHighWatermark()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder(23).append("\tTimeSinceLastFetchMs: ").append(timeSinceLastFetchMs).toString());
    }

    private void stopMirrors(MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp stopOp) {
        Seq<String> topics = this.resolveTopics(opts, client);
        AlterMirrorOp alterMirrorOp = stopOp;
        AlterMirrorOp alterMirrorOp2 = AlterMirrorOp.FAILOVER;
        if (!(alterMirrorOp == null ? alterMirrorOp2 != null : !alterMirrorOp.equals(alterMirrorOp2)) || opts.validateOnly()) {
            this.doStopMirrors(topics, opts, client, stopOp);
            return;
        }
        LongRef maxAllowedOffsetLag = LongRef.create((long)-1L);
        LongRef maxAllowedMsLag = LongRef.create((long)-1L);
        if (opts.stopLagRecords().isDefined() && opts.stopLagMs().isDefined()) {
            maxAllowedOffsetLag.elem = BoxesRunTime.unboxToLong((Object)opts.stopLagRecords().get());
            maxAllowedMsLag.elem = BoxesRunTime.unboxToLong((Object)opts.stopLagMs().get());
        } else {
            Predef$.MODULE$.print((Object)"What is the max lag (in records) allowed to promote a mirror topic?\t");
            maxAllowedOffsetLag.elem = StdIn$.MODULE$.readLong();
            Predef$.MODULE$.println();
            Predef$.MODULE$.print((Object)"What is the max lag (in milliseconds) allowed to promote a mirror topic?\t");
            maxAllowedMsLag.elem = StdIn$.MODULE$.readLong();
            Predef$.MODULE$.println();
        }
        Predef$.MODULE$.println((Object)new StringBuilder(53).append("Calculating max offset and ms lag for mirror topics: ").append(topics.mkString("[", ", ", "]")).toString());
        scala.collection.mutable.Map topicToOffsetLag = Map$.MODULE$.empty();
        scala.collection.mutable.Map topicToLagMs = Map$.MODULE$.empty();
        DescribeMirrorsOptions describeOptions = new DescribeMirrorsOptions();
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(client.describeMirrors((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava(), describeOptions).result()).asScala();
        if (result.nonEmpty()) {
            scala.collection.immutable.Set partitions = ((TraversableOnce)result.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                scala.collection.immutable.Set set;
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    try {
                        TopicMirrorDescription desc = (TopicMirrorDescription)((KafkaFuture)x0$1._2()).get();
                        topicToOffsetLag.put((Object)topic, (Object)BoxesRunTime.boxToLong((long)-1L));
                        topicToLagMs.put((Object)topic, (Object)BoxesRunTime.boxToLong((long)-1L));
                        set = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), desc.numPartitions()).map((Function1 & Serializable & scala.Serializable)part -> MirrorCommand$.$anonfun$stopMirrors$2(topic, BoxesRunTime.unboxToInt((Object)part)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                    }
                    catch (Throwable e) {
                        Predef$.MODULE$.println((Object)new StringBuilder(58).append("Unable to get mirror topic description for mirror topic ").append(topic).append(": ").append(e).toString());
                        set = Predef$.MODULE$.Set().empty();
                    }
                } else {
                    throw new MatchError(null);
                }
                scala.collection.immutable.Set set2 = set;
                return set2;
            }, Iterable$.MODULE$.canBuildFrom())).toSet();
            scala.collection.mutable.Map replicas = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(client.replicaStatus((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)partitions).asJava(), new ReplicaStatusOptions()).result()).asScala();
            result.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                MirrorCommand$.$anonfun$stopMirrors$3(replicas, topicToOffsetLag, topicToLagMs, x0$2);
                return BoxedUnit.UNIT;
            });
        } else {
            Predef$.MODULE$.println((Object)"No mirror topics found to calculate lag and offset.");
            this.exitCode_$eq(1);
            Exit.exit((int)this.exitCode());
        }
        Predef$.MODULE$.println((Object)new StringBuilder(70).append("Finished calculating max offset lag and max lag ms for mirror topics: ").append(topics.mkString("[", ", ", "]")).toString());
        scala.collection.mutable.Set violatingTopics = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        topics.foreach((Function1 & Serializable & scala.Serializable)t -> {
            if (topicToOffsetLag.contains(t) && topicToLagMs.contains(t)) {
                long topicOffsetLag = BoxesRunTime.unboxToLong((Object)topicToOffsetLag.apply(t));
                if (BoxesRunTime.unboxToLong((Object)topicToLagMs.apply(t)) > maxAllowedMsLag$1.elem || topicOffsetLag > maxAllowedOffsetLag$1.elem) {
                    return violatingTopics.$plus$eq(t);
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        if (violatingTopics.nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(178).append("Found following mirror topics with greater lag offset and/or lag ms than").append(" specified: ").append(violatingTopics.mkString("[", ", ", "]")).append(". Not proceeding with promote.").append(" If you still wish to promote, use the failover command instead.").toString());
            violatingTopics.foreach((Function1 & Serializable & scala.Serializable)t -> {
                MirrorCommand$.$anonfun$stopMirrors$10(topicToLagMs, topicToOffsetLag, t);
                return BoxedUnit.UNIT;
            });
            this.exitCode_$eq(1);
            Exit.exit((int)this.exitCode());
        }
        this.doStopMirrors(topics, opts, client, stopOp);
    }

    private void doStopMirrors(Seq<String> topics, MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp stopOp) {
        String action = opts.validateOnly() ? "validated" : "scheduled";
        scala.collection.immutable.Map ops = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), (Object)stopOp), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(client.alterMirrors((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)ops).asJava(), options).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$doStopMirrors$2(action, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void pauseMirrors(MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp pauseOp) {
        Seq<String> topics = this.resolveTopics(opts, client);
        AlterMirrorOp alterMirrorOp = pauseOp;
        AlterMirrorOp alterMirrorOp2 = AlterMirrorOp.PAUSE;
        String upperCommand = !(alterMirrorOp != null ? !alterMirrorOp.equals(alterMirrorOp2) : alterMirrorOp2 != null) ? "Pausing" : "Resuming";
        String lowerCommand = upperCommand.toLowerCase(Locale.ROOT);
        String action = opts.validateOnly() ? "validated" : "completed";
        scala.collection.immutable.Map ops = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)pauseOp), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(client.alterMirrors((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)ops).asJava(), options).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$pauseMirrors$2(upperCommand, action, lowerCommand, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<String> resolveTopics(MirrorCommandOptions opts, ConfluentAdmin client) {
        Seq<String> seq;
        Option<Seq<String>> option = opts.topics();
        if (option instanceof Some) {
            seq = (Seq<String>)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            seq = this.doListMirrors(opts, client);
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    public String timeToDate(long timeMs) {
        return this.formatter().format(new Date(timeMs));
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ TopicPartition $anonfun$describeMirrors$2(String topic$1, int part) {
        return new TopicPartition(topic$1, part);
    }

    public static final /* synthetic */ void $anonfun$describeMirrors$3(scala.collection.mutable.Map replicas$1, MirrorCommandOptions opts$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String topic = (String)x0$2._1();
            KafkaFuture future = (KafkaFuture)x0$2._2();
            Predef$.MODULE$.print((Object)new StringBuilder(7).append("Topic: ").append(topic).toString());
            try {
                TopicMirrorDescription desc = (TopicMirrorDescription)future.get();
                MODULE$.printMirrorTopicInformation(desc);
                package$.MODULE$.Range().apply(0, desc.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)part -> {
                    block6: {
                        try {
                            ReplicaStatus leader = (ReplicaStatus)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((List)((KafkaFuture)replicas$1.apply((Object)new TopicPartition(topic, part))).get()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isLeader()))).head();
                            if (!leader.mirrorInfo().isPresent()) {
                                throw new ClusterLinkNotFoundException("Mirror state not associated with the partition");
                            }
                            ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
                            if (opts$2.pendingStoppedOnly()) {
                                ReplicaStatus.MirrorInfo.State state = mi.state();
                                ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
                                if (!(state != null ? !state.equals(state2) : state2 != null)) {
                                    MODULE$.printMirrorPartitionInformation(mi, leader, part);
                                }
                                break block6;
                            }
                            MODULE$.printMirrorPartitionInformation(mi, leader, part);
                            return;
                        }
                        catch (ExecutionException e) {
                            Predef$.MODULE$.print((Object)new StringBuilder(8).append("\tError: ").append(e.getCause()).toString());
                            return;
                        }
                        catch (Throwable e) {
                            Predef$.MODULE$.print((Object)new StringBuilder(8).append("\tError: ").append(e).toString());
                        }
                    }
                });
            }
            catch (ExecutionException e) {
                Predef$.MODULE$.print((Object)new StringBuilder(8).append("\tError: ").append(e.getCause()).toString());
            }
            catch (Throwable e) {
                Predef$.MODULE$.print((Object)new StringBuilder(8).append("\tError: ").append(e).toString());
            }
            Predef$.MODULE$.println();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ TopicPartition $anonfun$stopMirrors$2(String topic$3, int part) {
        return new TopicPartition(topic$3, part);
    }

    public static final /* synthetic */ Object $anonfun$stopMirrors$4(scala.collection.mutable.Map replicas$2, String topic$4, scala.collection.mutable.Map topicToOffsetLag$1, scala.collection.mutable.Map topicToLagMs$1, int part) {
        Object object;
        block5: {
            try {
                ReplicaStatus leader = (ReplicaStatus)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((List)((KafkaFuture)replicas$2.apply((Object)new TopicPartition(topic$4, part))).get()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isLeader()))).head();
                if (leader.mirrorInfo().isPresent()) {
                    ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
                    long timeSinceLastFetchMs = leader.lastCaughtUpTimeMs() - mi.lastFetchTimeMs();
                    long lagOffset = mi.lastFetchSourceHighWatermark() - leader.logEndOffset();
                    if (BoxesRunTime.unboxToLong((Object)topicToOffsetLag$1.getOrElse((Object)topic$4, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) < lagOffset) {
                        topicToOffsetLag$1.put((Object)topic$4, (Object)BoxesRunTime.boxToLong((long)lagOffset));
                    }
                    object = BoxesRunTime.unboxToLong((Object)topicToLagMs$1.getOrElse((Object)topic$4, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) < timeSinceLastFetchMs && BoxesRunTime.unboxToLong((Object)topicToOffsetLag$1.getOrElse((Object)topic$4, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) < lagOffset ? topicToLagMs$1.put((Object)topic$4, (Object)BoxesRunTime.boxToLong((long)timeSinceLastFetchMs)) : BoxedUnit.UNIT;
                    break block5;
                }
                return BoxedUnit.UNIT;
            }
            catch (ExecutionException e) {
                Predef$.MODULE$.println((Object)new StringBuilder(58).append("Error while calculating lag for").append(" mirror topic ").append(topic$4).append(" partition ").append(part).append(": ").append(e.getCause()).toString());
                return BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringBuilder(91).append("Error while calculating lag for mirror topic").append(" ").append(topic$4).append(" partition ").append(part).append(". Mirror partition may have failed.").toString());
                object = BoxedUnit.UNIT;
            }
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$stopMirrors$3(scala.collection.mutable.Map replicas$2, scala.collection.mutable.Map topicToOffsetLag$1, scala.collection.mutable.Map topicToLagMs$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String topic = (String)x0$2._1();
            try {
                TopicMirrorDescription desc = (TopicMirrorDescription)((KafkaFuture)x0$2._2()).get();
                package$.MODULE$.Range().apply(0, desc.numPartitions()).foreach((Function1 & Serializable & scala.Serializable)part -> MirrorCommand$.$anonfun$stopMirrors$4(replicas$2, topic, topicToOffsetLag$1, topicToLagMs$1, BoxesRunTime.unboxToInt((Object)part)));
                return;
            }
            catch (ExecutionException e) {
                Predef$.MODULE$.println((Object)new StringBuilder(52).append("Failed to get mirror description for topic").append(" mirror ").append(topic).append(": ").append(e.getCause()).toString());
                return;
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(52).append("Failed to get mirror description for topic mirror").append(" ").append(topic).append(": ").append(e).toString());
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$stopMirrors$10(scala.collection.mutable.Map topicToLagMs$1, scala.collection.mutable.Map topicToOffsetLag$1, String t) {
        Predef$.MODULE$.println((Object)new StringBuilder(30).append("Max lag ms for mirror topic ").append(t).append(": ").append(topicToLagMs$1.apply((Object)t)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(34).append("Max offset lag for mirror topic ").append(t).append(": ").append(topicToOffsetLag$1.apply((Object)t)).toString());
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$doStopMirrors$2(String action$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                Predef$.MODULE$.println((Object)new StringBuilder(147).append("Request for stopping topic ").append(topic).append("'s mirror was successfully ").append(action$1).append(". Please use").append(" the describe command with the --pending-stopped-only option to monitor progress.").toString());
                return;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println((Object)new StringBuilder(50).append("Error encountered while stopping topic ").append(topic).append("'s mirror: ").append(ex).toString());
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$pauseMirrors$2(String upperCommand$1, String action$2, String lowerCommand$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                Predef$.MODULE$.println((Object)new StringBuilder(36).append(upperCommand$1).append(" topic '").append(topic).append("'s mirror was successfully ").append(action$2).append(".").toString());
                return;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println((Object)new StringBuilder(43).append("Error encountered while ").append(lowerCommand$1).append(" topic '").append(topic).append("'s mirror: ").append(ex).toString());
                return;
            }
        }
        throw new MatchError(null);
    }

    private MirrorCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.exitCode = 0;
    }
}

