/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtils$;
import kafka.admin.ClusterLinkCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.GroupFilterJson$;
import kafka.server.link.GroupFiltersJson;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class ClusterLinkCommand$
implements Logging {
    public static ClusterLinkCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterLinkCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(44).append("Error while executing cluster link command: ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(ClusterLinkCommand$.$anonfun$main$1(e)));
                }
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    private ConfluentAdmin createAdminClient(ClusterLinkCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options().valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)AdminClient.create((Properties)props);
    }

    private scala.collection.immutable.Map<String, String> loadConfigs(ClusterLinkCommandOptions opts) {
        Properties props;
        Properties properties;
        if (opts.options().has(opts.configOpt())) {
            properties = AdminUtils$.MODULE$.parseConfigs(opts.valueOf(opts.configOpt()));
        } else {
            Predef$.MODULE$.require(opts.options().has(opts.configFileOpt()));
            properties = props = Utils.loadProps((String)((String)opts.options().valueOf(opts.configFileOpt())));
        }
        if (props.getProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "false").equals("true")) {
            Option<AclFiltersJson> aclJson;
            String aclJsonString = "";
            if (opts.options().has(opts.aclFiltersJsonFileOpt())) {
                aclJsonString = Utils.readFileAsString((String)opts.valueOf(opts.aclFiltersJsonFileOpt()));
            } else if (opts.options().has(opts.aclFiltersJsonOpt())) {
                aclJsonString = opts.valueOf(opts.aclFiltersJsonOpt());
            }
            if (aclJsonString.trim().isEmpty()) {
                CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, new StringBuilder(175).append(ClusterLinkConfig$.MODULE$.AclSyncEnableProp()).append(" is set to true but the acl filters JSON is not passed in. Please pass in the path to").append(" the JSON file using the --acl-filters-json-file option and rerun the create link command.").toString());
            }
            if ((aclJson = AclJson$.MODULE$.parse(aclJsonString)) instanceof Some) {
                props.put(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclJsonString);
            } else if (None$.MODULE$.equals(aclJson)) {
                CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, new StringBuilder(136).append(ClusterLinkConfig$.MODULE$.AclSyncEnableProp()).append(" is set to true but the JSON file passed").append(" has invalid values. Please put valid values in the JSON file and rerun the").append(" create link command.").toString());
            } else {
                throw new MatchError(aclJson);
            }
        }
        if (props.getProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "false").equals("true")) {
            Option<GroupFiltersJson> offsetJson;
            String offsetJsonString = "";
            if (opts.options().has(opts.consumerGroupFiltersJsonFileOpt())) {
                offsetJsonString = Utils.readFileAsString((String)opts.valueOf(opts.consumerGroupFiltersJsonFileOpt()));
            } else if (opts.options().has(opts.consumerGroupFiltersJsonOpt())) {
                offsetJsonString = opts.valueOf(opts.consumerGroupFiltersJsonOpt());
            }
            if (offsetJsonString.trim().isEmpty()) {
                CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, new StringBuilder(197).append(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).append(" is set to true but the consumer group filters JSON is not passed in. Please pass in the path to").append(" the JSON file using the --consumer-group-filters-json-file option and rerun the create link command.").toString());
            }
            if ((offsetJson = GroupFilterJson$.MODULE$.parse(offsetJsonString)) instanceof Some) {
                props.put(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), offsetJsonString);
            } else if (None$.MODULE$.equals(offsetJson)) {
                CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, new StringBuilder(136).append(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).append(" is set to true but the JSON file passed").append(" has invalid values. Please put valid values in the JSON file and rerun the").append(" create link command.").toString());
            } else {
                throw new MatchError(offsetJson);
            }
        }
        return ((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        block13: {
            ClusterLinkCommandOptions opts = new ClusterLinkCommandOptions(args);
            opts.checkArgs();
            try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createAdminClient(opts));){
                try {
                    if (opts.options().has((OptionSpec)opts.createOpt())) {
                        this.createClusterLink(opts, client);
                    } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                        this.listClusterLinks(opts, client);
                    } else if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                        this.deleteClusterLink(opts, client);
                    }
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        ClusterLinkCommand$.throwAdminCommandFailedException$1("Timed out waiting for results", e);
                        break block13;
                    }
                    if (throwable instanceof ClusterAuthorizationException) {
                        ClusterLinkCommand$.throwAdminCommandFailedException$1(((ClusterAuthorizationException)throwable).getMessage(), e);
                        break block13;
                    }
                    throw e;
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println((Object)"Error while issuing request");
                    throw e;
                }
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void createClusterLink(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        String linkName = opts.valueOf(opts.linkNameOpt());
        Option<String> clusterId = opts.valueAsOption(opts.clusterIdOpt());
        boolean validateOnly = opts.options().has((OptionSpec)opts.validateOnlyOpt());
        boolean excludeValidateLink = opts.options().has((OptionSpec)opts.excludeValidateLinkOpt());
        NewClusterLink clusterLink = new NewClusterLink(linkName, (String)clusterId.orNull(Predef$.MODULE$.$conforms()), (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.loadConfigs(opts)).asJava());
        CreateClusterLinksOptions options = new CreateClusterLinksOptions().validateOnly(validateOnly).validateLink(!excludeValidateLink);
        client.createClusterLinks((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)clusterLink, (List)Nil$.MODULE$)).asJava(), options).all().get();
        String action = validateOnly ? "validated" : "completed";
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Cluster link '").append(linkName).append("' creation successfully ").append(action).append(".").toString());
    }

    private void listClusterLinks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        Option<String> linkName = opts.valueAsOption(opts.linkNameOpt());
        boolean includeTopics = opts.options().has((OptionSpec)opts.includeTopicsOpt());
        ListClusterLinksOptions options = new ListClusterLinksOptions().includeTopics(includeTopics);
        linkName.foreach((Function1 & Serializable & scala.Serializable)ln -> options.linkNames(Optional.of(Collections.singletonList(ln))));
        Iterable result = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)client.listClusterLinks(options).result().get()).asScala();
        if (result.nonEmpty()) {
            result.foreach((Function1 & Serializable & scala.Serializable)cl -> {
                ClusterLinkCommand$.$anonfun$listClusterLinks$2(cl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (linkName instanceof Some) {
            String ln2 = (String)((Some)linkName).value();
            Predef$.MODULE$.println((Object)new StringBuilder(23).append("Link name '").append(ln2).append("' not found.").toString());
            return;
        }
        if (None$.MODULE$.equals(linkName)) {
            Predef$.MODULE$.println((Object)"No cluster links found.");
            return;
        }
        throw new MatchError(linkName);
    }

    private void deleteClusterLink(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        String linkName = opts.valueOf(opts.linkNameOpt());
        boolean validateOnly = opts.options().has((OptionSpec)opts.validateOnlyOpt());
        boolean force = opts.options().has((OptionSpec)opts.forceOpt());
        DeleteClusterLinksOptions options = new DeleteClusterLinksOptions().validateOnly(validateOnly).force(force);
        client.deleteClusterLinks((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)linkName, (List)Nil$.MODULE$)).asJava(), options).all().get();
        String action = validateOnly ? "validated" : "completed";
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Cluster link '").append(linkName).append("' deletion successfully ").append(action).append(".").toString());
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        Predef$.MODULE$.println((Object)message);
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ void $anonfun$listClusterLinks$2(ClusterLinkListing cl) {
        String localClusterId = cl.localClusterId() != null && new StringOps(Predef$.MODULE$.augmentString(cl.localClusterId())).nonEmpty() ? new StringBuilder(22).append(", local cluster ID: '").append(cl.localClusterId()).append("'").toString() : "";
        Predef$.MODULE$.print((Object)new StringBuilder(49).append("Link name: '").append(cl.linkName()).append("', link ID: '").append(cl.linkId()).append("', remote cluster ID: '").append(cl.remoteClusterId()).append("'").append(localClusterId).toString());
        if (cl.topics().isPresent()) {
            Predef$.MODULE$.print((Object)new StringBuilder(10).append(", topics: ").append(cl.topics().get()).toString());
        }
        Predef$.MODULE$.println();
    }

    private ClusterLinkCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

