/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaServer;
import kafka.server.Server;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.utils.Logging$;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.LoggingSignalHandler;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class Kafka$
implements Logging {
    public static Kafka$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new Kafka$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Properties getPropsFromArgs(String[] args) {
        OptionParser optionParser = new OptionParser(false);
        ArgumentAcceptingOptionSpec overrideOpt = optionParser.accepts("override", "Optional property that should override values set in server.properties file").withRequiredArg().ofType(String.class);
        optionParser.accepts("version", "Print version information and exit.");
        if (args.length == 0 || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).contains((Object)"--help")) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, new StringOps(Predef$.MODULE$.augmentString("USAGE: java [options] %s server.properties [--override property=value]*")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.getClass().getCanonicalName())).split('$'))).head()})));
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).contains((Object)"--version")) {
            throw CommandLineUtils$.MODULE$.printVersionAndDie();
        }
        Properties props = Utils.loadProps((String)args[0]);
        if (args.length > 1) {
            OptionSet options = optionParser.parse((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).slice(1, args.length));
            if (options.nonOptionArguments().size() > 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, new StringBuilder(31).append("Found non argument parameters: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(options.nonOptionArguments().toArray())).mkString(",")).toString());
            }
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(options.valuesOf((OptionSpec)overrideOpt)).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2()));
        }
        return props;
    }

    private Server buildServer(Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props, false);
        if (config.requiresZookeeper()) {
            return new KafkaServer(config, Time.SYSTEM, (Option<String>)None$.MODULE$, false);
        }
        BooleanRef resetAnything = BooleanRef.create((boolean)false);
        ((IterableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ClusterLinkEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.TierFeatureProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.TierEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.balancer.enable"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.AuthorizerClassNameProp()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MetricReporterClassesProp()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.KafkaMetricsReporterClassesProp()), (Object)"")}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Kafka$.$anonfun$buildServer$1(props, resetAnything, x0$1);
            return BoxedUnit.UNIT;
        });
        return new KafkaRaftServer(!resetAnything.elem ? config : KafkaConfig$.MODULE$.fromProps(props, false), Time.SYSTEM, (Option<String>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        try {
            void addShutdownHook_shutdownHook;
            void addShutdownHook_name;
            Server server;
            block10: {
                Properties serverProps = this.getPropsFromArgs(args);
                server = this.buildServer(serverProps);
                try {
                    if (!OperatingSystem.IS_WINDOWS && !Java.isIbmJdk()) {
                        new LoggingSignalHandler().register();
                    }
                }
                catch (ReflectiveOperationException e) {
                    if (!this.logger().underlying().isWarnEnabled()) break block10;
                    this.logger().underlying().warn(this.msgWithLogIdent(Kafka$.$anonfun$main$1(e)), (Throwable)e);
                }
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    server.shutdown();
                    return;
                }
                catch (Throwable throwable) {
                    Kafka$ kafka$ = MODULE$;
                    if (kafka$ == null) {
                        throw null;
                    }
                    Kafka$ fatal_this = kafka$;
                    if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
                        fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), fatal_this.msgWithLogIdent(Kafka$.$anonfun$main$4()));
                    }
                    throw Exit$.MODULE$.halt(1, Exit$.MODULE$.halt$default$2());
                }
            };
            String string = "kafka-shutdown-hook";
            if (Exit$.MODULE$ == null) {
                throw null;
            }
            Exit.addShutdownHook((String)addShutdownHook_name, () -> Exit$.$anonfun$addShutdownHook$1((Function0)addShutdownHook_shutdownHook));
            try {
                server.startup();
            }
            catch (Throwable throwable) {
                if (this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
                    this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), this.msgWithLogIdent(Kafka$.$anonfun$main$5()));
                }
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            server.awaitShutdown();
        }
        catch (Throwable e) {
            if (this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
                this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), this.msgWithLogIdent(Kafka$.$anonfun$main$6()), e);
            }
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    public static final /* synthetic */ void $anonfun$buildServer$1(Properties props$1, BooleanRef resetAnything$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            String defaultValue = (String)x0$1._2();
            String requestedValue = props$1.getProperty(key);
            if (requestedValue != null && !requestedValue.equals(defaultValue)) {
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("{} cannot be enabled with KRaft at this time.  Automatically disabling this feature: setting \"{}\" (requested value was {})", new Object[]{key, defaultValue, requestedValue});
                }
                props$1.setProperty(key, defaultValue);
                resetAnything$1.elem = true;
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ String $anonfun$main$1(ReflectiveOperationException e$1) {
        return new StringBuilder(143).append("Failed to register optional signal handler that logs a message when the process is terminated ").append("by a signal. Reason for registration failure is: ").append(e$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$4() {
        return "Halting Kafka.";
    }

    public static final /* synthetic */ String $anonfun$main$5() {
        return "Exiting Kafka.";
    }

    public static final /* synthetic */ String $anonfun$main$6() {
        return "Exiting Kafka due to fatal exception";
    }

    private Kafka$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

