/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$QuotaConfigs$;
import kafka.server.DynamicConfig$User$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.LogLevelConfig;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011]b\u0001B\u001b7\u0001mB\u0001B\u0014\u0001\u0003\u0006\u0004%\ta\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005!\"A1\n\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003W\u0011!\u0019\u0007A!b\u0001\n\u0003!\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011%\u0004!Q1A\u0005\u0002)D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\u0006e\u0002!\ta\u001d\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nmD\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0013A\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005%\u0002\u0001)A\u0005\u0003+A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005]\u0002\u0001)A\u0005\u0003_Aq!!\u000f\u0001\t\u0003\tY\u0004C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002R!A\u0011\u0011\f\u0001!\u0002\u0013\t\u0019\u0006C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\bb\u0002B\b\u0001\u0011\u0005!\u0011\u0003\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0011\u001d\u0011\t\b\u0001C\u0001\u0005gBqAa#\u0001\t\u0013\u0011i\tC\u0004\u00036\u0002!IAa.\t\u000f\t\u0005\u0007\u0001\"\u0003\u0003D\"9!\u0011\u001a\u0001\u0005\n\t-\u0007b\u0002Br\u0001\u0011%!Q\u001d\u0005\b\u0005W\u0004A\u0011\u0002Bw\u0011\u001d\u0011\u0019\u0010\u0001C\u0001\u0005kDqA!@\u0001\t\u0013\u0011y\u0010C\u0004\u0004\u0004\u0001!Ia!\u0002\t\u000f\r\r\u0002\u0001\"\u0001\u0004&!91q\u0005\u0001\u0005\n\r%\u0002bBB\u0018\u0001\u0011%1\u0011\u0007\u0005\b\u0007\u0013\u0002A\u0011BB&\u0011\u001d\u0019y\u0005\u0001C\u0005\u0007#Bqaa\u001a\u0001\t\u0013\u0019I\u0007C\u0004\u0004~\u0001!Iaa \t\u000f\r5\u0006\u0001\"\u0003\u00040\"91q\u0018\u0001\u0005\n\r\u0005\u0007bBBd\u0001\u0011%1\u0011\u001a\u0005\b\u0007\u001f\u0004A\u0011BBi\u0011\u001d\u00199\u000f\u0001C\u0005\u0007SDqaa=\u0001\t\u0003\u0019)\u0010C\u0004\u0005\f\u0001!\t\u0001\"\u0004\t\u000f\u0011\r\u0002\u0001\"\u0001\u0005&\ta\u0011\tZ7j]6\u000bg.Y4fe*\u0011q\u0007O\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003e\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001y\tC\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g\r\u0005\u0002D\r6\tAI\u0003\u0002Fq\u0005)Q\u000f^5mg&\u0011q\t\u0012\u0002\b\u0019><w-\u001b8h!\tIE*D\u0001K\u0015\tY\u0005(A\u0004nKR\u0014\u0018nY:\n\u00055S%!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u000611m\u001c8gS\u001e,\u0012\u0001\u0015\t\u0003#Jk\u0011AN\u0005\u0003'Z\u00121bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004S#\u0001,\u0011\u0005]\u0003W\"\u0001-\u000b\u0005-K&B\u0001.\\\u0003\u0019\u0019w.\\7p]*\u0011\u0011\b\u0018\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014x-\u0003\u0002b1\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005)\u0007CA)g\u0013\t9gGA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003!Q8n\u00117jK:$X#A6\u0011\u00051|W\"A7\u000b\u00059D\u0014A\u0001>l\u0013\t\u0001XNA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\na\u0001P5oSRtD#\u0002;vm^D\bCA)\u0001\u0011\u0015q\u0015\u00021\u0001Q\u0011\u0015Y\u0015\u00021\u0001W\u0011\u0015\u0019\u0017\u00021\u0001f\u0011\u0015I\u0017\u00021\u0001l\u00039!x\u000e]5d!V\u0014x-\u0019;pef,\u0012a\u001f\t\u0004#rt\u0018BA?7\u0005e!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eU;sO\u0006$xN]=\u0011\u0005E{\u0018bAA\u0001m\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)ve\u001e\fGo\u001c:zA\u0005i\u0011\rZ7j]j[7\t\\5f]R,\"!!\u0003\u0011\u00071\fY!C\u0002\u0002\u000e5\u0014Q\"\u00113nS:T6n\u00117jK:$\u0018AD1e[&t'l[\"mS\u0016tG\u000fI\u0001\u0012GJ,\u0017\r^3U_BL7\rU8mS\u000eLXCAA\u000b!\u0015i\u0014qCA\u000e\u0013\r\tIB\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005u\u0011QE\u0007\u0003\u0003?QA!!\t\u0002$\u00051\u0001o\u001c7jGfT!aN.\n\t\u0005\u001d\u0012q\u0004\u0002\u0012\u0007J,\u0017\r^3U_BL7\rU8mS\u000eL\u0018AE2sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds\u0002\n\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\t\ty\u0003E\u0003>\u0003/\t\t\u0004\u0005\u0003\u0002\u001e\u0005M\u0012\u0002BA\u001b\u0003?\u0011\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0003I\tG\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u0011\u00023!\f7\u000fR3mCf,G\rV8qS\u000e|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003{\u00012!PA \u0013\r\t\tE\u0010\u0002\b\u0005>|G.Z1o\u0003Q!WMZ1vYRtU/\u001c)beRLG/[8ogV\u0011\u0011q\t\t\u0004{\u0005%\u0013bAA&}\t\u0019\u0011J\u001c;\u0002+\u0011,g-Y;mi:+X\u000eU1si&$\u0018n\u001c8tA\u0005AB-\u001a4bk2$(+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0005\u0005M\u0003cA\u001f\u0002V%\u0019\u0011q\u000b \u0003\u000bMCwN\u001d;\u00023\u0011,g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\"iJL8i\\7qY\u0016$X\rR3mCf,G\rV8qS\u000e|\u0005/\u001a:bi&|gn\u001d\u000b\u0005\u0003?\n)\u0007E\u0002>\u0003CJ1!a\u0019?\u0005\u0011)f.\u001b;\t\u000f\u0005\u001dt\u00031\u0001\u0002j\u0005)Ao\u001c9jGB!\u00111NA=\u001d\u0011\ti'!\u001e\u0011\u0007\u0005=d(\u0004\u0002\u0002r)\u0019\u00111\u000f\u001e\u0002\rq\u0012xn\u001c;?\u0013\r\t9HP\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]d(\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0007\u0002`\u0005\r\u0015qQAF\u0003\u0003\f)\u000eC\u0004\u0002\u0006b\u0001\r!a\u0012\u0002\u000fQLW.Z8vi\"9\u0011\u0011\u0012\rA\u0002\u0005u\u0012\u0001\u0004<bY&$\u0017\r^3P]2L\bbBAG1\u0001\u0007\u0011qR\u0001\ti>\u001c%/Z1uKBA\u0011\u0011SAL\u0003S\nY*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013 \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\u0006M%aA'baB!\u0011QTA^\u001d\u0011\ty*!.\u000f\t\u0005\u0005\u0016\u0011\u0017\b\u0005\u0003G\u000byK\u0004\u0003\u0002&\u00065f\u0002BAT\u0003WsA!a\u001c\u0002*&\tq,\u0003\u0002^=&\u0011\u0011\bX\u0005\u00035nK1!a-Z\u0003\u001diWm]:bO\u0016LA!a.\u0002:\u000692I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u0003gK\u0016\u0002BA_\u0003\u007f\u0013ab\u0011:fCR\f'\r\\3U_BL7M\u0003\u0003\u00028\u0006e\u0006bBAb1\u0001\u0007\u0011QY\u0001\u001cS:\u001cG.\u001e3f\u0007>tg-[4t\u0003:$W*\u001a;bi\u0006$\u0017\r^1\u0011\u0011\u0005E\u0015qSA5\u0003\u000f\u0004B!!3\u0002P:!\u0011qTAf\u0013\u0011\ti-!/\u00021\r\u0013X-\u0019;f)>\u0004\u0018nY:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002R\u0006M'\u0001F\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019*fgVdGO\u0003\u0003\u0002N\u0006e\u0006bBAl1\u0001\u0007\u0011\u0011\\\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004r!PAn\u0003?\fy&C\u0002\u0002^z\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0011\u0005E\u0015qSA5\u0003C\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003OL\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005-\u0018Q\u001d\u0002\t\u0003BLWI\u001d:pe\u0006aA-\u001a7fi\u0016$v\u000e]5dgRA\u0011qLAy\u0003g\fi\u0010C\u0004\u0002\u0006f\u0001\r!a\u0012\t\u000f\u0005U\u0018\u00041\u0001\u0002x\u00061Ao\u001c9jGN\u0004b!!%\u0002z\u0006%\u0014\u0002BA~\u0003'\u00131aU3u\u0011\u001d\t9.\u0007a\u0001\u0003\u007f\u0004r!PAn\u0005\u0003\ty\u0006\u0005\u0005\u0002\u0012\u0006]\u0015\u0011\u000eB\u0002!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!b\u0001B\u00053\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0003\u000e\t\u001d!AB#se>\u00148/\u0001\tde\u0016\fG/\u001a)beRLG/[8ogRa\u0011q\fB\n\u0005+\u0011iCa\f\u0003@!9\u0011Q\u0011\u000eA\u0002\u0005\u001d\u0003b\u0002B\f5\u0001\u0007!\u0011D\u0001\u000e]\u0016<\b+\u0019:uSRLwN\\:\u0011\r\u0005E%1\u0004B\u0010\u0013\u0011\u0011i\"a%\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003\"\t\u001db\u0002BAP\u0005GIAA!\n\u0002:\u0006Y2I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d*fcV,7\u000f\u001e#bi\u0006LAA!\u000b\u0003,\t)2I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d+pa&\u001c'\u0002\u0002B\u0013\u0003sCq!!#\u001b\u0001\u0004\ti\u0004C\u0004\u00032i\u0001\rAa\r\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\tU\"1H\u0007\u0003\u0005oQ1A!\u000fZ\u0003\u001dqW\r^<pe.LAA!\u0010\u00038\taA*[:uK:,'OT1nK\"9!\u0011\t\u000eA\u0002\u0005e\u0017\u0001C2bY2\u0014\u0017mY6\u0002\u001f\u0011,7o\u0019:jE\u0016\u001cuN\u001c4jON$\u0002Ba\u0012\u0003b\t%$Q\u000e\t\t\u0003#\u000b9J!\u0013\u0003TA!!1\nB(\u001b\t\u0011iE\u0003\u0002O3&!!\u0011\u000bB'\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\u0004BA!\u0016\u0003\\9!\u00111\u001dB,\u0013\u0011\u0011I&!:\u0002/\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm\u001d9p]N,\u0017\u0002\u0002B/\u0005?\u0012aaQ8oM&<'\u0002\u0002B-\u0003KDqAa\u0019\u001c\u0001\u0004\u0011)'A\u000bsKN|WO]2f)>\u001cuN\u001c4jO:\u000bW.Z:\u0011\u0011\u0005E\u0015q\u0013B%\u0005O\u0002R!PA\f\u0003oDqAa\u001b\u001c\u0001\u0004\ti$A\bj]\u000edW\u000fZ3Ts:|g._7t\u0011\u001d\u0011yg\u0007a\u0001\u0003{\tA#\u001b8dYV$W\rR8dk6,g\u000e^1uS>t\u0017\u0001D1mi\u0016\u00148i\u001c8gS\u001e\u001cHC\u0002B;\u0005o\u0012I\t\u0005\u0005\u0002\u0012\u0006]%\u0011JAq\u0011\u001d\u0011I\b\ba\u0001\u0005w\nqaY8oM&<7\u000f\u0005\u0005\u0002\u0012\u0006]%\u0011\nB?!\u0011\u0011yH!\"\u000f\t\u0005\r(\u0011Q\u0005\u0005\u0005\u0007\u000b)/A\nBYR,'oQ8oM&<7OU3rk\u0016\u001cH/\u0003\u0003\u0003^\t\u001d%\u0002\u0002BB\u0003KDq!!#\u001d\u0001\u0004\ti$A\tbYR,'\u000fV8qS\u000e\u001cuN\u001c4jON$\"Ba$\u0003\u0016\ne%1\u0014BX!\u001di$\u0011\u0013B%\u0003CL1Aa%?\u0005\u0019!V\u000f\u001d7fe!9!qS\u000fA\u0002\t%\u0013\u0001\u0003:fg>,(oY3\t\u000f\u0005%U\u00041\u0001\u0002>!9!QT\u000fA\u0002\t}\u0015aC2p]\u001aLw\r\u0015:paN\u0004BA!)\u0003,6\u0011!1\u0015\u0006\u0005\u0005K\u00139+\u0001\u0003vi&d'B\u0001BU\u0003\u0011Q\u0017M^1\n\t\t5&1\u0015\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002BY;\u0001\u0007!1W\u0001\u0011G>tg-[4F]R\u0014\u0018.Z:NCB\u0004\u0002\"!%\u0002\u0018\u0006%\u0014\u0011N\u0001\u0013C2$XM\u001d\"s_.,'oQ8oM&<7\u000f\u0006\u0006\u0003\u0010\ne&1\u0018B_\u0005\u007fCqAa&\u001f\u0001\u0004\u0011I\u0005C\u0004\u0002\nz\u0001\r!!\u0010\t\u000f\tue\u00041\u0001\u0003 \"9!\u0011\u0017\u0010A\u0002\tM\u0016a\u0004;p\u0019><w-\u00192mKB\u0013x\u000e]:\u0015\r\tM&Q\u0019Bd\u0011\u001d\u00119j\ba\u0001\u0005\u0013BqA!( \u0001\u0004\u0011y*\u0001\u000bbYR,'\u000fT8h\u0019\u00164X\r\\\"p]\u001aLwm\u001d\u000b\u0005\u0003?\u0012i\rC\u0004\u0003P\u0002\u0002\rA!5\u0002\u001d\u0005dG/\u001a:D_:4\u0017nZ(qgB1\u0011\u0011\u0013B\u000e\u0005'\u0004BA!6\u0003`6\u0011!q\u001b\u0006\u0005\u00053\u0014Y.A\u0003bI6LgNC\u0002\u0003^n\u000bqa\u00197jK:$8/\u0003\u0003\u0003b\n]'!D!mi\u0016\u00148i\u001c8gS\u001e|\u0005/A\u0006hKR\u0014%o\\6fe&#G\u0003\u0002Bt\u0005S\u0004R!PA\f\u0003\u000fBqAa&\"\u0001\u0004\u0011I%\u0001\u000bwC2LG-\u0019;f\u0007>tg-[4Q_2L7-\u001f\u000b\u0007\u0003?\u0012yO!=\t\u000f\t]%\u00051\u0001\u0003J!9!\u0011\u0017\u0012A\u0002\tM\u0016aF5oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t)\u0019\u0011)Ha>\u0003|\"9!\u0011P\u0012A\u0002\te\b\u0003CAI\u0003/\u0013IE!5\t\u000f\u0005%5\u00051\u0001\u0002>\u00059b/\u00197jI\u0006$X\rT8h\u0019\u00164X\r\\\"p]\u001aLwm\u001d\u000b\u0005\u0003?\u001a\t\u0001C\u0004\u0003P\u0012\u0002\rA!5\u00023A\u0014X\r]1sK&s7M]3nK:$\u0018\r\\\"p]\u001aLwm\u001d\u000b\t\u0003?\u001a9a!\u0003\u0004\f!9!qZ\u0013A\u0002\tE\u0007b\u0002BOK\u0001\u0007!q\u0014\u0005\b\u0007\u001b)\u0003\u0019AB\b\u0003)\u0019wN\u001c4jO.+\u0017p\u001d\t\t\u0003#\u000b9*!\u001b\u0004\u0012A!11CB\u000f\u001d\u0011\u0019)b!\u0007\u000f\t\u0005\u00056qC\u0005\u0003\u001dfKAaa\u0007\u0003N\u0005I1i\u001c8gS\u001e$UMZ\u0005\u0005\u0007?\u0019\tCA\u0005D_:4\u0017nZ&fs*!11\u0004B'\u0003!\u0019\b.\u001e;e_^tGCAA0\u0003Y\u0011Xm]8ve\u000e,g*Y7f)>\u0014%o\\6fe&#G\u0003BA$\u0007WAqa!\f(\u0001\u0004\tI'\u0001\u0007sKN|WO]2f\u001d\u0006lW-\u0001\bce>\\WM]*z]>t\u00170\\:\u0015\t\rM2Q\t\t\u0007\u0007k\u0019y$!\u001b\u000f\t\r]21\b\b\u0005\u0003_\u001aI$C\u0001@\u0013\r\u0019iDP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019\tea\u0011\u0003\t1K7\u000f\u001e\u0006\u0004\u0007{q\u0004bBB$Q\u0001\u0007\u0011\u0011N\u0001\u0005]\u0006lW-A\nce>\\WM\u001d#pGVlWM\u001c;bi&|g\u000e\u0006\u0003\u0002j\r5\u0003bBB$S\u0001\u0007\u0011\u0011N\u0001\u0013G>tg-[4SKN\u0004xN\\:f)f\u0004X\r\u0006\u0003\u0004T\re\u0003\u0003\u0002B+\u0007+JAaa\u0016\u0003`\tQ1i\u001c8gS\u001e$\u0016\u0010]3\t\u000f\rm#\u00061\u0001\u0004^\u0005Q1m\u001c8gS\u001e$\u0016\u0010]3\u0011\u000bu\n9ba\u0018\u0011\t\r\u000541\r\b\u0005\u0005\u0017\u001aI\"\u0003\u0003\u0004f\r\u0005\"\u0001\u0002+za\u0016\fabY8oM&<7+\u001f8p]fl7\u000f\u0006\u0005\u0004l\rM4QOB=!\u0019\u0019)da\u0010\u0004nA!!QKB8\u0013\u0011\u0019\tHa\u0018\u0003\u001b\r{gNZ5h'ftwN\\=n\u0011\u001d\u00199e\u000ba\u0001\u0003SBqaa\u001e,\u0001\u0004\u0019\u0019$\u0001\u0005ts:|g._7t\u0011\u001d\u0019Yh\u000ba\u0001\u0003{\t1\"[:TK:\u001c\u0018\u000e^5wK\u000612M]3bi\u0016$v\u000e]5d\u0007>tg-[4F]R\u0014\u0018\u0010\u0006\u0006\u0004\u0002\u000eU5QUBU\u0007W#baa!\u0004\n\u000e-\u0005\u0003\u0002B+\u0007\u000bKAaa\"\u0003`\tY1i\u001c8gS\u001e,e\u000e\u001e:z\u0011\u001d\u00199\u0005\fa\u0001\u0003SBqa!$-\u0001\u0004\u0019y)A\u0003wC2,X\rE\u0002>\u0007#K1aa%?\u0005\r\te.\u001f\u0005\b\u0007/c\u0003\u0019ABM\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u0004\u001c\u000e\u0005VBABO\u0015\r\u0019y\nO\u0001\u0004Y><\u0017\u0002BBR\u0007;\u0013\u0011\u0002T8h\u0007>tg-[4\t\u000f\r\u001dF\u00061\u0001\u0003 \u0006QAo\u001c9jGB\u0013x\u000e]:\t\u000f\t-D\u00061\u0001\u0002>!9!q\u000e\u0017A\u0002\u0005u\u0012aF2sK\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e,e\u000e\u001e:z)!\u0019\tla.\u0004<\u000euFCBBB\u0007g\u001b)\fC\u0004\u0004H5\u0002\r!!\u001b\t\u000f\r5U\u00061\u0001\u0004\u0010\"91\u0011X\u0017A\u0002\u0005u\u0012a\u00049fe\n\u0013xn[3s\u0007>tg-[4\t\u000f\t-T\u00061\u0001\u0002>!9!qN\u0017A\u0002\u0005u\u0012AE:b]&$\u0018N_3F]RLG/\u001f(b[\u0016$B!!\u001b\u0004D\"91Q\u0019\u0018A\u0002\u0005%\u0014AC3oi&$\u0018PT1nK\u0006!B-Z:b]&$\u0018N_3F]RLG/\u001f(b[\u0016$B!!\u001b\u0004L\"91QZ\u0018A\u0002\u0005%\u0014aE:b]&$\u0018N_3e\u000b:$\u0018\u000e^=OC6,\u0017!H3oi&$\u0018\u0010V8TC:LG/\u001b>fIV\u001bXM]\"mS\u0016tG/\u00133\u0015\t\rM7q\u001b\t\b{\tE5Q[Bk!\u0015i\u0014qCA5\u0011\u001d\u0019I\u000e\ra\u0001\u00077\fa!\u001a8uSRL\b\u0003BBo\u0007Gl!aa8\u000b\u0007\r\u0005\u0018,A\u0003rk>$\u0018-\u0003\u0003\u0004f\u000e}'!E\"mS\u0016tG/U;pi\u0006,e\u000e^5us\u0006!Ro]3s\u00072LWM\u001c;JIR{WI\u001c;jif$baa7\u0004l\u000e=\bbBBwc\u0001\u00071Q[\u0001\u0005kN,'\u000fC\u0004\u0004rF\u0002\ra!6\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\fA\u0003Z3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cH\u0003BB|\t\u0003\u0001\u0002\"!%\u0002\u0018\u000em7\u0011 \t\t\u0003#\u000b9*!\u001b\u0004|B\u0019Qh!@\n\u0007\r}hH\u0001\u0004E_V\u0014G.\u001a\u0005\b\t\u0007\u0011\u0004\u0019\u0001C\u0003\u0003\u00191\u0017\u000e\u001c;feB!1Q\u001cC\u0004\u0013\u0011!Iaa8\u0003#\rc\u0017.\u001a8u#V|G/\u0019$jYR,'/\u0001\u000eiC:$G.\u001a#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7\u000f\u0006\u0005\u0004x\u0012=A1\u0004C\u0010\u0011\u001d!\tb\ra\u0001\t'\tQ\"^:fe\u000e{W\u000e]8oK:$\b#B\u001f\u0002\u0018\u0011U\u0001\u0003BBo\t/IA\u0001\"\u0007\u0004`\nQ2\t\\5f]R\fVo\u001c;b\r&dG/\u001a:D_6\u0004xN\\3oi\"9AQD\u001aA\u0002\u0011M\u0011!E2mS\u0016tG/\u00133D_6\u0004xN\\3oi\"9A\u0011E\u001aA\u0002\u0005u\u0012AB:ue&\u001cG/A\tbYR,'o\u00117jK:$\u0018+^8uCN$b\u0001b\n\u0005*\u0011U\u0002\u0003CAI\u0003/\u001bY.!9\t\u000f\u0011-B\u00071\u0001\u0005.\u00059QM\u001c;sS\u0016\u001c\bCBAI\u00057!y\u0003\u0005\u0003\u0004^\u0012E\u0012\u0002\u0002C\u001a\u0007?\u0014Qc\u00117jK:$\u0018+^8uC\u0006cG/\u001a:bi&|g\u000eC\u0004\u0002\nR\u0002\r!!\u0010")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient adminZkClient;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final int defaultNumPartitions;
    private final short defaultReplicationFactor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().numDelayed() != 0;
    }

    private int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Request key ").append(key.keyLabel()).append(" unblocked ").append(completed).append(" topic requests.").toString());
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequestData.CreatableTopic> toCreate, Map<String, CreateTopicsResponseData.CreatableTopicResult> includeConfigsAndMetatadata, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Buffer metadata = ((TraversableOnce)toCreate.values().map((Function1 & Serializable & scala.Serializable)topic -> {
            try {
                scala.collection.mutable.HashMap hashMap;
                short resolvedReplicationFactor;
                if (this.metadataCache().contains(topic.name())) {
                    throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic.name()).append("' already exists.").toString());
                }
                Iterable nullConfigs = (Iterable)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$3(x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Iterable$.MODULE$.canBuildFrom());
                if (nullConfigs.nonEmpty()) {
                    throw new InvalidRequestException(new StringBuilder(45).append("Null value not supported for topic configs : ").append(nullConfigs.mkString(",")).toString());
                }
                Properties configs = new Properties();
                topic.configs().forEach(entry -> configs.setProperty(entry.name(), entry.value()));
                LogConfig$.MODULE$.validate(configs);
                if (!(topic.numPartitions() == -1 && topic.replicationFactor() == -1 || topic.assignments().isEmpty())) {
                    throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                }
                int resolvedNumPartitions = topic.numPartitions() == -1 ? this.defaultNumPartitions() : topic.numPartitions();
                short s = resolvedReplicationFactor = topic.replicationFactor() == -1 ? this.defaultReplicationFactor() : topic.replicationFactor();
                if (topic.assignments().isEmpty()) {
                    hashMap = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, resolvedNumPartitions, resolvedReplicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                } else {
                    scala.collection.mutable.HashMap assignments = new scala.collection.mutable.HashMap();
                    topic.assignments().forEach(assignment -> assignments.update((Object)BoxesRunTime.boxToInteger((int)assignment.partitionIndex()), ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(assignment.brokerIds()).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(a)), Buffer$.MODULE$.canBuildFrom())));
                    hashMap = assignments;
                }
                scala.collection.mutable.HashMap assignments = hashMap;
                this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> AdminManager.$anonfun$createTopics$8(topic, (Map)assignments)));
                Option<CreateTopicPolicy> option = this.createTopicPolicy();
                if (option instanceof Some) {
                    CreateTopicPolicy policy = (CreateTopicPolicy)((Some)option).value();
                    this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, Seq<Object>>)assignments, configs);
                    Integer numPartitions = topic.assignments().isEmpty() ? Predef$.MODULE$.int2Integer(resolvedNumPartitions) : null;
                    Short replicationFactor = topic.assignments().isEmpty() ? Predef$.MODULE$.short2Short(resolvedReplicationFactor) : null;
                    java.util.Map javaAssignments = topic.assignments().isEmpty() ? null : (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)assignments.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        if (x0$1 != null) {
                            int k = x0$1._1$mcI$sp();
                            Seq v = (Seq)x0$1._2();
                            Object object = CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)v.map((Function1 & Serializable & scala.Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom())).asJava();
                            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(k));
                            if (Predef.ArrowAssoc$.MODULE$ == null) {
                                throw null;
                            }
                        } else {
                            throw new MatchError(null);
                        }
                        Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                        return tuple2;
                    }, scala.collection.Map$.MODULE$.canBuildFrom())).asJava();
                    HashMap javaConfigs = new HashMap();
                    topic.configs().forEach(config -> javaConfigs.put(config.name(), config.value()));
                    policy.validate(new CreateTopicPolicy.RequestMetadata(topic.name(), numPartitions, replicationFactor, javaAssignments, javaConfigs));
                    if (!validateOnly) {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, Seq<Object>>)assignments);
                    }
                } else if (None$.MODULE$.equals(option)) {
                    if (validateOnly) {
                        this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, Seq<Object>>)assignments, configs);
                    } else {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, Seq<Object>>)assignments);
                    }
                } else {
                    throw new MatchError(option);
                }
                Option option2 = includeConfigsAndMetatadata.get((Object)topic.name());
                if (option2 == null) {
                    throw null;
                }
                Option foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    CreateTopicsResponseData.CreatableTopicResult creatableTopicResult = (CreateTopicsResponseData.CreatableTopicResult)foreach_this.get();
                    AdminManager.$anonfun$createTopics$12(this, configs, (Map)assignments, creatableTopicResult);
                }
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)assignments.keySet(), ApiError.NONE);
            }
            catch (TopicExistsException e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Topic creation failed since topic '").append(topic.name()).append("' already exists.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ApiException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ConfigException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause())));
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
        }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$26(x$6)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> {
                if (createTopicMetadata.error().isSuccess() && !validateOnly) {
                    return new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
                }
                return new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
            return;
        }
        DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata, this, responseCallback);
        Buffer delayedCreateKeys = ((TraversableOnce)toCreate.values().map((Function1 & Serializable & scala.Serializable)topic -> new TopicKey(topic.name()), Iterable$.MODULE$.canBuildFrom())).toBuffer();
        this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            try {
                this.adminZkClient().deleteTopic((String)topic);
                return new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                return new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error processing delete topic request for topic ").append((String)topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$7)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    return new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT);
                }
                return new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
            return;
        }
        DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
        Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$8 -> new TopicKey((String)x$8), Set$.MODULE$.canBuildFrom())).toSeq();
        this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
    }

    public void createPartitions(int timeout, Seq<CreatePartitionsRequestData.CreatePartitionsTopic> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        Seq<BrokerMetadata> allBrokers = this.adminZkClient().getBrokerMetadatas(this.adminZkClient().getBrokerMetadatas$default$1(), this.adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Seq$.MODULE$.canBuildFrom());
        Seq metadata = (Seq)newPartitions.map((Function1 & Serializable & scala.Serializable)newPartition -> {
            String topic = newPartition.name();
            try {
                None$ none$;
                Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    void $minus$greater$extension_$this;
                    ReplicaAssignment assignment;
                    if (x0$1 != null) {
                        TopicPartition topicPartition = (TopicPartition)x0$1._1();
                        assignment = (ReplicaAssignment)x0$1._2();
                        if (assignment.isBeingReassigned()) {
                            throw new ReassignmentInProgressException(new StringBuilder(57).append("A partition reassignment is in progress for the topic '").append(topic).append("'.").toString());
                        }
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                    } else {
                        throw new MatchError(null);
                    }
                    Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
                    return tuple2;
                }, scala.collection.Map$.MODULE$.canBuildFrom());
                if (existingAssignment.isEmpty()) {
                    throw new UnknownTopicOrPartitionException(new StringBuilder(28).append("The topic '").append(topic).append("' does not exist.").toString());
                }
                int oldNumPartitions = existingAssignment.size();
                int newNumPartitions = newPartition.count();
                int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                if (numPartitionsIncrement < 0) {
                    throw new InvalidPartitionsException(new StringBuilder(69).append("Topic currently has ").append(oldNumPartitions).append(" partitions, which is higher than the requested ").append(newNumPartitions).append(".").toString());
                }
                if (numPartitionsIncrement == 0) {
                    throw new InvalidPartitionsException(new StringBuilder(30).append("Topic already has ").append(oldNumPartitions).append(" partitions.").toString());
                }
                Option option = Option$.MODULE$.apply((Object)newPartition.assignments());
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                if (map_this.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    java.util.List list = (java.util.List)map_this.get();
                    none$ = new Some((Object)AdminManager.$anonfun$createPartitions$4(allBrokerIds, numPartitionsIncrement, existingAssignment, list));
                }
                Map<Object, Seq<Object>> updatedReplicaAssignment = this.adminZkClient().addPartitions(topic, (Map<Object, ReplicaAssignment>)existingAssignment, allBrokers, newPartition.count(), (Option<Map<Object, Seq<Object>>>)none$, validateOnly);
                return new CreatePartitionsMetadata(topic, (Set<Object>)updatedReplicaAssignment.keySet(), ApiError.NONE);
            }
            catch (AdminOperationException e) {
                return new CreatePartitionsMetadata(topic, (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ApiException e) {
                return new CreatePartitionsMetadata(topic, (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createPartitions$8(x$11)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createPartitionMetadata -> {
                if (createPartitionMetadata.error().isSuccess() && !validateOnly) {
                    return new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
                }
                return new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error());
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
            return;
        }
        DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata, this, callback);
        Seq delayedCreateKeys = (Seq)newPartitions.map((Function1 & Serializable & scala.Serializable)createPartitionTopic -> new TopicKey(createPartitionTopic.name()), Seq$.MODULE$.canBuildFrom());
        this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms, boolean includeDocumentation) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Tuple2 tuple2;
            if (x0$12 != null) {
                ConfigResource resource = (ConfigResource)x0$12._1();
                Option configNames = (Option)x0$12._2();
                try {
                    void $minus$greater$extension_$this;
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.metadataCache().contains(topic)) {
                            Properties topicProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                            Function2 & Serializable & scala.Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, includeDocumentation, (String)name, value);
                            Buffer createResponseConfig$1_configEntries = (Buffer)((MapLike)AdminManager.allConfigs$1(logConfig).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            }, Buffer$.MODULE$.canBuildFrom());
                            config2 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.emptyList());
                        }
                        config = config2;
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        DescribeConfigsResponse.Config config3;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            Function2 & Serializable & scala.Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value);
                            Buffer createResponseConfig$1_configEntries = (Buffer)((MapLike)this.config().dynamicConfig().currentDynamicDefaultConfigs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            }, Buffer$.MODULE$.canBuildFrom());
                            config3 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else if (this.resourceNameToBrokerId(resource.name()) == this.config().brokerId()) {
                            Function2 & Serializable & scala.Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value);
                            Buffer createResponseConfig$1_configEntries = (Buffer)((MapLike)AdminManager.allConfigs$1(this.config()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            }, Buffer$.MODULE$.canBuildFrom());
                            config3 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else {
                            throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" or empty string, but received ").append(resource.name()).toString());
                        }
                        config = config3;
                    } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        if (resource.name() == null || resource.name().isEmpty()) {
                            throw new InvalidRequestException("Broker id must not be empty");
                        }
                        if (this.resourceNameToBrokerId(resource.name()) != this.config().brokerId()) {
                            throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" but received ").append(resource.name()).toString());
                        }
                        Function2 & Serializable & scala.Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable & scala.Serializable)(name, value) -> new DescribeConfigsResponse.ConfigEntry(name, value.toString(), DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, false, false, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
                        Buffer createResponseConfig$1_configEntries = (Buffer)((MapLike)Log4jController$.MODULE$.loggers().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            if (x0$2 == null) {
                                throw new MatchError(null);
                            }
                            String name = (String)x0$2._1();
                            Object value = x0$2._2();
                            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                            return configEntry;
                        }, Buffer$.MODULE$.canBuildFrom());
                        config = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else {
                        throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    }
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)config);
                }
                catch (Throwable e) {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(resource).toString();
                    if (e instanceof ApiException) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    DescribeConfigsResponse.Config config = new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)e), Collections.emptyList());
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)x0$1._2();
                try {
                    Tuple2 tuple22;
                    Iterable nullUpdates = (Iterable)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$alterConfigs$2(x$14)))).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), Iterable$.MODULE$.canBuildFrom());
                    if (nullUpdates.nonEmpty()) {
                        throw new InvalidRequestException(new StringBuilder(31).append("Null value not supported for : ").append(nullUpdates.mkString(",")).toString());
                    }
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), (Object)entry.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Properties configProps = new Properties();
                    ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$alterConfigs$5(x$16)))).foreach((Function1 & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        tuple22 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        tuple22 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple22;
                }
                catch (Throwable throwable) {
                    Tuple2 tuple23;
                    boolean bl = throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException;
                    if (bl) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        ApiError apiError = ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else if (throwable != null) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        Properties configProps = new Properties();
                        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$alterConfigs$8(x$17)))).foreach((Function1 & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(this.toLoggableProps(resource, configProps).mkString(",")).toString();
                        if (throwable instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        }
                        ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw null;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple24 = tuple2;
            return tuple24;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ConfigResource, ApiError> alterTopicConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        String topic = resource.name();
        this.adminZkClient().validateTopicConfig(topic, configProps);
        this.validateConfigPolicy(resource, configEntriesMap);
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updating topic ").append(topic).append(" with new configuration : ").append(this.toLoggableProps(resource, configProps).mkString(",")).toString());
            this.adminZkClient().changeTopicConfig(topic, configProps);
        }
        ApiError apiError = ApiError.NONE;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ConfigResource, ApiError> alterBrokerConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Option<Object> brokerId = this.getBrokerId(resource);
        boolean perBrokerConfig = brokerId.nonEmpty();
        this.config().dynamicConfig().validate(configProps, perBrokerConfig);
        this.validateConfigPolicy(resource, configEntriesMap);
        if (!validateOnly) {
            if (perBrokerConfig) {
                this.config().dynamicConfig().reloadUpdatedFilesWithoutConfigChange(configProps);
            }
            if (perBrokerConfig) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updating broker ").append(brokerId.get()).append(" with new configuration : ").append(this.toLoggableProps(resource, configProps).mkString(",")).toString());
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updating brokers with new configuration : ").append(this.toLoggableProps(resource, configProps).mkString(",")).toString());
            }
            this.adminZkClient().changeBrokerConfig(brokerId, this.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
        }
        ApiError apiError = ApiError.NONE;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    private Map<String, String> toLoggableProps(ConfigResource resource, Properties configProps) {
        return (Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)key, (Object)KafkaConfig$.MODULE$.loggableValue(resource.type(), key, value));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    private void alterLogLevelConfigs(Seq<AlterConfigOp> alterConfigOps) {
        alterConfigOps.foreach((Function1 & Serializable & scala.Serializable)alterConfigOp -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$alterLogLevelConfigs$1(this, alterConfigOp)));
    }

    private Option<Object> getBrokerId(ConfigResource resource) {
        if (resource.name() == null || resource.name().isEmpty()) {
            return None$.MODULE$;
        }
        int id = this.resourceNameToBrokerId(resource.name());
        if (id != this.config().brokerId()) {
            throw new InvalidRequestException(new StringBuilder(46).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(", but received ").append(resource.name()).toString());
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)id));
    }

    private void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Map<ConfigResource, ApiError> incrementalAlterConfigs(Map<ConfigResource, Seq<AlterConfigOp>> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2<ConfigResource, ApiError> tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                Seq alterConfigOps = (Seq)x0$1._2();
                try {
                    Tuple2<ConfigResource, ApiError> tuple22;
                    scala.collection.immutable.Set duplicateKeys = ((scala.collection.immutable.MapLike)alterConfigOps.groupBy((Function1 & Serializable & scala.Serializable)config -> config.configEntry().name()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$incrementalAlterConfigs$3(x0$2)))).keySet();
                    if (duplicateKeys.nonEmpty()) {
                        throw new InvalidRequestException(new StringBuilder(37).append("Error due to duplicate config keys : ").append(duplicateKeys.mkString(",")).toString());
                    }
                    Seq nullUpdates = (Seq)((TraversableLike)alterConfigOps.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$incrementalAlterConfigs$4(entry)))).map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(1).append(entry.opType()).append(":").append(entry.configEntry().name()).toString(), Seq$.MODULE$.canBuildFrom());
                    if (nullUpdates.nonEmpty()) {
                        throw new InvalidRequestException(new StringBuilder(31).append("Null value not supported for : ").append(nullUpdates.mkString(",")).toString());
                    }
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)alterConfigOps.map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.configEntry().name(), (Object)entry.configEntry().value()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        Properties configProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), resource.name());
                        this.prepareIncrementalConfigs((Seq<AlterConfigOp>)alterConfigOps, configProps, LogConfig$.MODULE$.configKeys());
                        tuple22 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        Option<Object> brokerId = this.getBrokerId(resource);
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        Properties persistentProps = perBrokerConfig ? this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), brokerId.get().toString()) : this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default());
                        Properties configProps = this.config().dynamicConfig().fromPersistentProps(persistentProps, perBrokerConfig);
                        this.prepareIncrementalConfigs((Seq<AlterConfigOp>)alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
                        tuple22 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        this.getBrokerId(resource);
                        this.validateLogLevelConfigs((Seq<AlterConfigOp>)alterConfigOps);
                        if (!validateOnly) {
                            this.alterLogLevelConfigs((Seq<AlterConfigOp>)alterConfigOps);
                        }
                        ApiError apiError = ApiError.NONE;
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple22 = new Tuple2<ConfigResource, ApiError>((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple22;
                }
                catch (Throwable throwable) {
                    Tuple2<ConfigResource, ApiError> tuple23;
                    boolean bl = throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException;
                    if (bl) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        ApiError apiError = ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2<ConfigResource, ApiError>((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else if (throwable != null) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(alterConfigOps).toString();
                        if (throwable instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        }
                        ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw null;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2<ConfigResource, ApiError> tuple24 = tuple2;
            return tuple24;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void validateLogLevelConfigs(Seq<AlterConfigOp> alterConfigOps) {
        alterConfigOps.foreach((Function1 & Serializable & scala.Serializable)alterConfigOp -> {
            AdminManager.$anonfun$validateLogLevelConfigs$1(alterConfigOp);
            return BoxedUnit.UNIT;
        });
    }

    private void prepareIncrementalConfigs(Seq<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        alterConfigOps.foreach((Function1 & Serializable & scala.Serializable)alterConfigOp -> {
            Object object;
            String configPropName = alterConfigOp.configEntry().name();
            AlterConfigOp.OpType opType = alterConfigOp.opType();
            if (AlterConfigOp.OpType.SET.equals(opType)) {
                object = configProps.setProperty(alterConfigOp.configEntry().name(), alterConfigOp.configEntry().value());
            } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
                object = configProps.remove(alterConfigOp.configEntry().name());
            } else if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys)) {
                    throw new InvalidRequestException(new StringBuilder(51).append("Config value append is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
                }
                Option option = Option$.MODULE$.apply((Object)configProps.getProperty(alterConfigOp.configEntry().name()));
                if (option == null) {
                    throw null;
                }
                Option orElse_this = option;
                Option option2 = orElse_this.isEmpty() ? Option$.MODULE$.apply((Object)ConfigDef.convertToString((Object)((ConfigDef.ConfigKey)configKeys.apply((Object)configPropName)).defaultValue, (ConfigDef.Type)ConfigDef.Type.LIST)) : orElse_this;
                if (option2 == null) {
                    throw null;
                }
                Object object2 = option2.isEmpty() ? AdminManager.$anonfun$prepareIncrementalConfigs$3() : option2.get();
                List oldValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)object2).split(","))).toList();
                List newValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterConfigOp.configEntry().value().split(","))).toList().$colon$colon$colon(oldValueList);
                object = configProps.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
            } else if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys)) {
                    throw new InvalidRequestException(new StringBuilder(53).append("Config value subtract is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
                }
                Option option = Option$.MODULE$.apply((Object)configProps.getProperty(alterConfigOp.configEntry().name()));
                if (option == null) {
                    throw null;
                }
                Option orElse_this = option;
                Option option3 = orElse_this.isEmpty() ? Option$.MODULE$.apply((Object)ConfigDef.convertToString((Object)((ConfigDef.ConfigKey)configKeys.apply((Object)configPropName)).defaultValue, (ConfigDef.Type)ConfigDef.Type.LIST)) : orElse_this;
                if (option3 == null) {
                    throw null;
                }
                Object object3 = option3.isEmpty() ? AdminManager.$anonfun$prepareIncrementalConfigs$5() : option3.get();
                List newValueList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)object3).split(","))).toList().diff((GenSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterConfigOp.configEntry().value().split(","))).toList());
                object = configProps.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
            } else {
                throw new MatchError((Object)opType);
            }
            return object;
        });
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<CreateTopicPolicy> option = this.createTopicPolicy();
            if (option == null) {
                throw null;
            }
            Option<CreateTopicPolicy> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((CreateTopicPolicy)foreach_this.get()).close();
                return;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<AlterConfigPolicy> option = this.alterConfigPolicy();
            if (option == null) {
                throw null;
            }
            Option<AlterConfigPolicy> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((AlterConfigPolicy)foreach_this.get()).close();
                return;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringOps(resourceName).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config().documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = (ConfigDef.Type)configType.get();
        DescribeConfigsResponse.ConfigType configType2 = ConfigDef.Type.BOOLEAN.equals(type) ? DescribeConfigsResponse.ConfigType.BOOLEAN : (ConfigDef.Type.STRING.equals(type) ? DescribeConfigsResponse.ConfigType.STRING : (ConfigDef.Type.INT.equals(type) ? DescribeConfigsResponse.ConfigType.INT : (ConfigDef.Type.SHORT.equals(type) ? DescribeConfigsResponse.ConfigType.SHORT : (ConfigDef.Type.LONG.equals(type) ? DescribeConfigsResponse.ConfigType.LONG : (ConfigDef.Type.DOUBLE.equals(type) ? DescribeConfigsResponse.ConfigType.DOUBLE : (ConfigDef.Type.LIST.equals(type) ? DescribeConfigsResponse.ConfigType.LIST : (ConfigDef.Type.CLASS.equals(type) ? DescribeConfigsResponse.ConfigType.CLASS : (ConfigDef.Type.PASSWORD.equals(type) ? DescribeConfigsResponse.ConfigType.PASSWORD : DescribeConfigsResponse.ConfigType.UNKNOWN))))))));
        return configType2;
    }

    private List<DescribeConfigsResponse.ConfigSynonym> configSynonyms(String name, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        if (synonyms == null) {
            throw null;
        }
        List foreach_these = synonyms;
        while (!foreach_these.isEmpty()) {
            String string = (String)foreach_these.head();
            AdminManager.maybeAddSynonym$1(map, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these = (List)foreach_these.tail();
        }
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        List foreach_these2 = synonyms;
        while (!foreach_these2.isEmpty()) {
            String string = (String)foreach_these2.head();
            AdminManager.maybeAddSynonym$1(map2, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these2 = (List)foreach_these2.tail();
        }
        List foreach_these3 = synonyms;
        while (!foreach_these3.isEmpty()) {
            String string = (String)foreach_these3.head();
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these3 = (List)foreach_these3.tail();
        }
        List foreach_these4 = synonyms;
        while (!foreach_these4.isEmpty()) {
            String string = (String)foreach_these4.head();
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, string, isSensitive, allSynonyms);
            foreach_these4 = (List)foreach_these4.tail();
        }
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configSynonyms$6(name, s)))).toList();
    }

    /*
     * WARNING - void declaration
     */
    private DescribeConfigsResponse.ConfigEntry createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        Object object;
        None$ none$;
        String string;
        Option<ConfigDef.Type> configEntryType = LogConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            void orNull_ev;
            Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
            if (configEntryType == null) {
                throw null;
            }
            Object object2 = configEntryType.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : configEntryType.get();
            string = ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)object2));
        }
        String valueAsString = string;
        Option option = LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string2 = (String)map_this.get();
            none$ = new Some((Object)this.configSynonyms(string2, this.brokerSynonyms(string2), isSensitive));
        }
        if (none$ == null) {
            throw null;
        }
        Object object3 = none$.isEmpty() ? List$.MODULE$.empty() : none$.get();
        Object list = object3;
        if (!topicProps.containsKey(name)) {
            object = list;
        } else {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            object = (List)list.$plus$colon((Object)configSynonym, List$.MODULE$.canBuildFrom());
        }
        Object allSynonyms = object;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        Object synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava(), dataType, configDocumentation);
    }

    /*
     * WARNING - void declaration
     */
    private DescribeConfigsResponse.ConfigEntry createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        String string;
        List<String> allNames = this.brokerSynonyms(name);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            if (value instanceof String) {
                string2 = (String)value;
            } else {
                void orNull_ev;
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (configEntryType == null) {
                    throw null;
                }
                Object object = configEntryType.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : configEntryType.get();
                string2 = ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)object));
            }
            string = string2;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$22)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava(), dataType, configDocumentation);
    }

    private String sanitizeEntityName(String entityName) {
        String string;
        Option option = Option$.MODULE$.apply((Object)entityName);
        if (None$.MODULE$.equals(option)) {
            string = ConfigEntityName$.MODULE$.Default();
        } else if (option instanceof Some) {
            string = Sanitizer.sanitize((String)((String)((Some)option).value()));
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    private String desanitizeEntityName(String sanitizedEntityName) {
        String string = ConfigEntityName$.MODULE$.Default();
        String string2 = !(string != null ? !string.equals(sanitizedEntityName) : sanitizedEntityName != null) ? null : Sanitizer.desanitize((String)sanitizedEntityName);
        return string2;
    }

    private Tuple2<Option<String>, Option<String>> entityToSanitizedUserClientId(ClientQuotaEntity entity) {
        if (entity.entries().isEmpty()) {
            throw new InvalidRequestException("Invalid empty client quota entity");
        }
        ObjectRef user = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef clientId = ObjectRef.create((Object)None$.MODULE$);
        entity.entries().forEach((entityType, entityName) -> {
            Some sanitizedEntityName = new Some((Object)this.sanitizeEntityName((String)entityName));
            if ("user".equals(entityType)) {
                user$1.elem = sanitizedEntityName;
            } else if ("client-id".equals(entityType)) {
                clientId$1.elem = sanitizedEntityName;
            } else {
                throw new InvalidRequestException(new StringBuilder(36).append("Unhandled client quota entity type: ").append((String)entityType).toString());
            }
            if (entityName != null && entityName.isEmpty()) {
                throw new InvalidRequestException(new StringBuilder(20).append("Empty ").append((String)entityType).append(" not supported").toString());
            }
        });
        return new Tuple2((Object)((Option)user.elem), (Object)((Option)clientId.elem));
    }

    private ClientQuotaEntity userClientIdToEntity(Option<String> user, Option<String> clientId) {
        if (user == null) {
            throw null;
        }
        Object object = user.isEmpty() ? None$.MODULE$ : new Some((Object)AdminManager.$anonfun$userClientIdToEntity$1((String)user.get()));
        if (clientId == null) {
            throw null;
        }
        Object object2 = clientId.isEmpty() ? None$.MODULE$ : new Some((Object)AdminManager.$anonfun$userClientIdToEntity$2((String)clientId.get()));
        return new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)Option$.MODULE$.option2Iterable((Option)object).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)object2), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
    }

    public Map<ClientQuotaEntity, Map<String, Object>> describeClientQuotas(ClientQuotaFilter filter) {
        ObjectRef userComponent = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef clientIdComponent = ObjectRef.create((Object)None$.MODULE$);
        filter.components().forEach(component -> {
            String string = component.entityType();
            if ("user".equals(string)) {
                if (((Option)userComponent$1.elem).isDefined()) {
                    throw new InvalidRequestException("Duplicate user filter component entity type");
                }
                userComponent$1.elem = new Some(component);
                return;
            }
            if ("client-id".equals(string)) {
                if (((Option)clientIdComponent$1.elem).isDefined()) {
                    throw new InvalidRequestException("Duplicate client filter component entity type");
                }
                clientIdComponent$1.elem = new Some(component);
                return;
            }
            if ("".equals(string)) {
                throw new InvalidRequestException("Unexpected empty filter component entity type");
            }
            throw new UnsupportedVersionException(new StringBuilder(35).append("Custom entity type '").append(string).append("' not supported").toString());
        });
        return this.handleDescribeClientQuotas((Option<ClientQuotaFilterComponent>)((Option)userComponent.elem), (Option<ClientQuotaFilterComponent>)((Option)clientIdComponent.elem), filter.strict());
    }

    /*
     * WARNING - void declaration
     */
    public Map<ClientQuotaEntity, Map<String, Object>> handleDescribeClientQuotas(Option<ClientQuotaFilterComponent> userComponent, Option<ClientQuotaFilterComponent> clientIdComponent, boolean strict) {
        Object object;
        scala.collection.immutable.Map clientIdEntries;
        Object object2;
        scala.collection.immutable.Map userEntries;
        Object object3;
        if (userComponent == null) {
            throw null;
        }
        Object object4 = userComponent.isEmpty() ? None$.MODULE$ : AdminManager.toOption$1(((ClientQuotaFilterComponent)userComponent.get()).match());
        if (clientIdComponent == null) {
            throw null;
        }
        Object object5 = clientIdComponent.isEmpty() ? None$.MODULE$ : AdminManager.toOption$1(((ClientQuotaFilterComponent)clientIdComponent.get()).match());
        String sanitizedUser = this.sanitized$1((Option)object4);
        String sanitizedClientId = this.sanitized$1((Option)object5);
        boolean exactUser = AdminManager.wantExact$1(userComponent);
        boolean exactClientId = AdminManager.wantExact$1(clientIdComponent);
        boolean excludeUser = AdminManager.wantExcluded$1(userComponent, strict);
        boolean excludeClientId = AdminManager.wantExcluded$1(clientIdComponent, strict);
        if (exactUser && excludeClientId) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            Properties properties = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.User(), sanitizedUser);
            Object object6 = Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new Some(object4.get()), (Object)None$.MODULE$));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            object3 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        } else {
            object3 = userEntries = !excludeUser && !exactClientId ? (Map)this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.User()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void $minus$greater$extension_$this;
                Properties props;
                if (x0$1 != null) {
                    String name = (String)x0$1._1();
                    props = (Properties)x0$1._2();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new Some((Object)this.desanitizeEntityName(name)), (Object)None$.MODULE$));
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)props);
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom()) : scala.collection.Map$.MODULE$.empty();
        }
        if (excludeUser && exactClientId) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            Properties properties = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId);
            Object object7 = Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some(object5.get())));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            object2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        } else {
            object2 = clientIdEntries = !exactUser && !excludeClientId ? (Map)this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.Client()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                void $minus$greater$extension_$this;
                Properties props;
                if (x0$2 != null) {
                    String name = (String)x0$2._1();
                    props = (Properties)x0$2._2();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)this.desanitizeEntityName(name))));
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)props);
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom()) : scala.collection.Map$.MODULE$.empty();
        }
        if (exactUser && exactClientId) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            Properties properties = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.User(), new StringBuilder(9).append(sanitizedUser).append("/clients/").append(sanitizedClientId).toString());
            Object object8 = Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new Some(object4.get()), (Object)new Some(object5.get())));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            object = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        } else {
            object = !excludeUser && !excludeClientId ? (Map)this.adminZkClient().fetchAllChildEntityConfigs(ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                void $minus$greater$extension_$this;
                Properties props;
                block8: {
                    block5: {
                        String[] components;
                        block7: {
                            String name;
                            block6: {
                                if (x0$3 == null) break block5;
                                name = (String)x0$3._1();
                                props = (Properties)x0$3._2();
                                components = name.split("/");
                                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])components)).size() != 3) break block6;
                                String string = components[1];
                                String string2 = "clients";
                                if (string != null && string.equals(string2)) break block7;
                            }
                            throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected config path: ").append(name).toString());
                        }
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new Some((Object)this.desanitizeEntityName(components[0])), (Object)new Some((Object)this.desanitizeEntityName(components[2]))));
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        break block8;
                    }
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)props);
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom()) : scala.collection.Map$.MODULE$.empty();
        }
        scala.collection.immutable.Map bothEntries = object;
        return ((TraversableOnce)((GenericTraversableTemplate)((MapLike)userEntries.$plus$plus((GenTraversableOnce)clientIdEntries, scala.collection.Map$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)bothEntries).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            None$ none$;
            if (x0$4 == null) throw new MatchError(x0$4);
            Tuple2 tuple2 = (Tuple2)x0$4._1();
            Properties p = (Properties)x0$4._2();
            if (tuple2 == null) throw new MatchError(x0$4);
            Option u = (Option)tuple2._1();
            Option c = (Option)tuple2._2();
            scala.collection.mutable.Map quotaProps = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(p).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$handleDescribeClientQuotas$12(x0$5)));
            if (quotaProps.nonEmpty() && AdminManager.matches$1(userComponent, u, strict) && AdminManager.matches$1(clientIdComponent, c, strict)) {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                Map map = AdminManager.fromProps$1((Map)quotaProps);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)this.userClientIdToEntity((Option<String>)u, (Option<String>)c));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                none$ = new Some((Object)new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y));
                return none$;
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }, Iterable$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ClientQuotaEntity, ApiError> alterClientQuotas(Seq<ClientQuotaAlteration> entries, boolean validateOnly) {
        return ((TraversableOnce)entries.map((Function1 & Serializable & scala.Serializable)entry -> {
            void $minus$greater$extension_$this;
            ApiError apiError;
            try {
                this.alterEntityQuotas$1(entry.entity(), (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(entry.ops()).asScala(), validateOnly);
                apiError = ApiError.NONE;
            }
            catch (Throwable e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error encountered while updating client quotas", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                apiError = ApiError.fromThrowable((Throwable)e);
            }
            ApiError apiError2 = apiError;
            Object object = Predef$.MODULE$.ArrowAssoc((Object)entry.entity());
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)apiError2);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$3(CreateTopicsRequestData.CreateableTopicConfig x$1) {
        return x$1.value() == null;
    }

    public static final /* synthetic */ String $anonfun$createTopics$8(CreateTopicsRequestData.CreatableTopic topic$1, Map assignments$2) {
        return new StringBuilder(28).append("Assignments for topic ").append(topic$1).append(" are ").append(assignments$2).append(" ").toString();
    }

    public static final /* synthetic */ byte $anonfun$createTopics$15(int x$5) {
        return (byte)x$5;
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$16(DescribeConfigsResponse.ConfigEntry entry$1, byte i) {
        DescribeConfigsResponse.ConfigSource configSource = DescribeConfigsResponse.ConfigSource.forId((byte)i);
        DescribeConfigsResponse.ConfigSource configSource2 = entry$1.source();
        return !(configSource != null ? !configSource.equals(configSource2) : configSource2 != null);
    }

    public static final /* synthetic */ byte $anonfun$createTopics$17() {
        return (byte)0;
    }

    public static final /* synthetic */ CreateTopicsResponseData.CreatableTopicResult $anonfun$createTopics$12(AdminManager $this, Properties configs$1, Map assignments$2, CreateTopicsResponseData.CreatableTopicResult result) {
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog($this.config()), configs$1);
        Function2 & Serializable & scala.Serializable createEntry = (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> $this.createTopicConfigEntry(logConfig, configs$1, false, false, (String)x$3, x$4);
        java.util.List topicConfigs = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(logConfig.values()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Option option;
            DescribeConfigsResponse.ConfigEntry entry;
            String k;
            if (x0$2 != null) {
                k = (String)x0$2._1();
                Object v = x0$2._2();
                entry = (DescribeConfigsResponse.ConfigEntry)createEntry.apply((Object)k, v);
                option = ((IterableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DescribeConfigsResponse.ConfigSource.values())).indices().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToByte((byte)AdminManager.$anonfun$createTopics$15(BoxesRunTime.unboxToInt((Object)x$5))), IndexedSeq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$16(entry, BoxesRunTime.unboxToByte((Object)i))));
                if (option == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToByte((byte)AdminManager.$anonfun$createTopics$17()) : getOrElse_this.get();
            byte source = BoxesRunTime.unboxToByte((Object)object);
            CreateTopicsResponseData.CreatableTopicConfigs creatableTopicConfigs = new CreateTopicsResponseData.CreatableTopicConfigs().setName(k).setValue(entry.value()).setIsSensitive(entry.isSensitive()).setReadOnly(entry.isReadOnly()).setConfigSource(source);
            return creatableTopicConfigs;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        result.setConfigs(topicConfigs);
        result.setNumPartitions(assignments$2.size());
        return result.setReplicationFactor((short)((SeqLike)assignments$2.apply((Object)BoxesRunTime.boxToInteger((int)0))).size());
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$26(CreatePartitionsMetadata x$6) {
        return x$6.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$7) {
        Errors errors = x$7.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createPartitions$4(Seq allBrokerIds$1, int numPartitionsIncrement$1, Map existingAssignment$1, java.util.List assignmentMap) {
        Buffer assignments = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(assignmentMap).asScala()).map((Function1 & Serializable & scala.Serializable)createPartitionAssignment -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(createPartitionAssignment.brokerIds()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$10)), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)allBrokerIds$1);
        if (unknownBrokers.nonEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(42).append("Unknown broker(s) in replica assignment: ").append(unknownBrokers.mkString(", ")).append(".").toString());
        }
        if (assignments.size() != numPartitionsIncrement$1) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(66).append("Increasing the number of partitions by ").append(numPartitionsIncrement$1).append(" ").append("but ").append(assignments.size()).append(" assignments provided.").toString());
        }
        return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void $minus$greater$extension_$this;
            Buffer replicas;
            if (x0$2 != null) {
                replicas = (Buffer)x0$2._1();
                int index = x0$2._2$mcI$sp();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(existingAssignment$1.size() + index)));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$8(CreatePartitionsMetadata x$11) {
        return x$11.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$12) {
        return x$12._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return ((scala.collection.mutable.MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$2(x$12)))).$plus$plus((GenTraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$3(Option configNames$1, Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            Set set;
            String configName = (String)x0$1._1();
            if (configNames$1 == null) {
                throw null;
            }
            bl = configNames$1.isEmpty() || (set = (Set)configNames$1.get()).contains((Object)configName);
        } else {
            throw new MatchError(null);
        }
        return bl;
    }

    private static final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
        Buffer configEntries = (Buffer)((MapLike)configs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$2._1();
            Object value = x0$2._2();
            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
            return configEntry;
        }, Buffer$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigs$2(AlterConfigsRequest.ConfigEntry x$14) {
        return x$14.value() == null;
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigs$5(AlterConfigsRequest.ConfigEntry x$16) {
        return x$16.value() != null;
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigs$8(AlterConfigsRequest.ConfigEntry x$17) {
        return x$17.value() != null;
    }

    public static final /* synthetic */ boolean $anonfun$alterLogLevelConfigs$1(AdminManager $this, AlterConfigOp alterConfigOp) {
        boolean bl;
        String loggerName = alterConfigOp.configEntry().name();
        String logLevel = alterConfigOp.configEntry().value();
        AlterConfigOp.OpType opType = alterConfigOp.opType();
        if (AlterConfigOp.OpType.SET.equals(opType)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Updating the log level of ").append(loggerName).append(" to ").append(logLevel).toString());
            bl = Log4jController$.MODULE$.logLevel(loggerName, logLevel);
        } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Unset the log level of ").append(loggerName).toString());
            bl = Log4jController$.MODULE$.unsetLogLevel(loggerName);
        } else {
            throw new IllegalArgumentException(new StringBuilder(40).append("Log level cannot be changed for OpType: ").append(alterConfigOp.opType()).toString());
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$incrementalAlterConfigs$3(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((Seq)x0$2._2()).size() > 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$incrementalAlterConfigs$4(AlterConfigOp entry) {
        if (entry.configEntry().value() == null) {
            AlterConfigOp.OpType opType = entry.opType();
            AlterConfigOp.OpType opType2 = AlterConfigOp.OpType.DELETE;
            if (opType == null ? opType2 != null : !opType.equals(opType2)) {
                return true;
            }
        }
        return false;
    }

    private static final void validateLoggerNameExists$1(String loggerName) {
        if (!Log4jController$.MODULE$.loggerExists(loggerName)) {
            throw new ConfigException(new StringBuilder(23).append("Logger ").append(loggerName).append(" does not exist!").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateLogLevelConfigs$1(AlterConfigOp alterConfigOp) {
        block8: {
            AlterConfigOp.OpType opType;
            block9: {
                block11: {
                    String string;
                    String string2;
                    block10: {
                        String loggerName;
                        block7: {
                            loggerName = alterConfigOp.configEntry().name();
                            opType = alterConfigOp.opType();
                            if (!AlterConfigOp.OpType.SET.equals(opType)) break block7;
                            AdminManager.validateLoggerNameExists$1(loggerName);
                            String logLevel = alterConfigOp.configEntry().value();
                            if (!LogLevelConfig.VALID_LOG_LEVELS.contains(logLevel)) {
                                String validLevelsStr = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(LogLevelConfig.VALID_LOG_LEVELS).asScala()).mkString(", ");
                                throw new ConfigException(new StringBuilder(90).append("Cannot set the log level of ").append(loggerName).append(" to ").append(logLevel).append(" as it is not a supported log level. ").append("Valid log levels are ").append(validLevelsStr).toString());
                            }
                            break block8;
                        }
                        if (!AlterConfigOp.OpType.DELETE.equals(opType)) break block9;
                        AdminManager.validateLoggerNameExists$1(loggerName);
                        string2 = loggerName;
                        string = Log4jController$.MODULE$.ROOT_LOGGER();
                        if (string2 != null) break block10;
                        if (string != null) {
                            return;
                        }
                        break block11;
                    }
                    if (!string2.equals(string)) break block8;
                }
                throw new InvalidRequestException(new StringBuilder(52).append("Removing the log level of the ").append(Log4jController$.MODULE$.ROOT_LOGGER()).append(" logger is not allowed").toString());
            }
            if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.APPEND).append(" operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.SUBTRACT).append(" operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            throw new MatchError((Object)opType);
        }
    }

    private static final boolean listType$1(String configName, Map configKeys) {
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys.apply((Object)configName);
        if (configKey == null) {
            throw new InvalidConfigurationException(new StringBuilder(27).append("Unknown topic config name: ").append(configName).toString());
        }
        ConfigDef.Type type = configKey.type;
        ConfigDef.Type type2 = ConfigDef.Type.LIST;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ String $anonfun$prepareIncrementalConfigs$3() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$prepareIncrementalConfigs$5() {
        return "";
    }

    public static final /* synthetic */ Buffer $anonfun$configSynonyms$1(boolean isSensitive$1, Buffer allSynonyms$1, String name$1, DescribeConfigsResponse.ConfigSource source$1, String value) {
        String configValue = isSensitive$1 ? null : value;
        return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponse.ConfigSynonym(name$1, configValue, source$1));
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        Option option = map.get((Object)name);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return;
        }
        String string = (String)map_this.get();
        new Some((Object)AdminManager.$anonfun$configSynonyms$1(isSensitive$1, allSynonyms$1, name, source, string));
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponse.ConfigSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$22) {
        block3: {
            block2: {
                if (perBrokerConfig$1) break block2;
                DescribeConfigsResponse.ConfigSource configSource = x$22.source();
                DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
                if (configSource != null ? !configSource.equals(configSource2) : configSource2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$userClientIdToEntity$1(String u) {
        void $minus$greater$extension_$this;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"user");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)u);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$userClientIdToEntity$2(String c) {
        void $minus$greater$extension_$this;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"client-id");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)c);
    }

    private static final Option toOption$1(Optional opt) {
        if (opt == null) {
            return None$.MODULE$;
        }
        if (opt.isPresent()) {
            return new Some(opt.get());
        }
        return new Some(null);
    }

    public static final /* synthetic */ String $anonfun$handleDescribeClientQuotas$4() {
        return "";
    }

    private final String sanitized$1(Option name) {
        None$ none$;
        if (name == null) {
            throw null;
        }
        if (name.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string = (String)name.get();
            none$ = new Some((Object)this.sanitizeEntityName(string));
        }
        if (none$ == null) {
            throw null;
        }
        Object object = none$.isEmpty() ? AdminManager.$anonfun$handleDescribeClientQuotas$4() : none$.get();
        return (String)object;
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeClientQuotas$5(ClientQuotaFilterComponent x$23) {
        return x$23.match() != null;
    }

    private static final boolean wantExact$1(Option component) {
        if (component == null) {
            throw null;
        }
        boolean bl = !component.isEmpty() && AdminManager.$anonfun$handleDescribeClientQuotas$5((ClientQuotaFilterComponent)component.get());
        return bl;
    }

    private static final boolean wantExcluded$1(Option component, boolean strict$1) {
        return strict$1 && !component.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeClientQuotas$9(String n$1, String x$24) {
        String string = x$24;
        return !(string != null ? !string.equals(n$1) : n$1 != null);
    }

    private static final boolean matches$1(Option nameComponent, Option name, boolean strict$1) {
        boolean bl;
        if (nameComponent instanceof Some) {
            boolean bl2;
            Option option = AdminManager.toOption$1(((ClientQuotaFilterComponent)((Some)nameComponent).value()).match());
            if (option instanceof Some) {
                String string;
                String n = (String)((Some)option).value();
                if (name == null) {
                    throw null;
                }
                boolean bl3 = !name.isEmpty() && AdminManager.$anonfun$handleDescribeClientQuotas$9(n, string = (String)name.get());
                bl2 = bl3;
            } else if (None$.MODULE$.equals(option)) {
                bl2 = name.isDefined();
            } else {
                throw new MatchError((Object)option);
            }
            bl = bl2;
        } else if (None$.MODULE$.equals(nameComponent)) {
            bl = !name.isDefined() || !strict$1;
        } else {
            throw new MatchError((Object)nameComponent);
        }
        return bl;
    }

    private static final Map fromProps$1(Map props) {
        return (Map)props.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                double d;
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                try {
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    d = new StringOps(value).toDouble();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException(new StringBuilder(49).append("Unexpected client quota configuration value: ").append(key).append(" -> ").append(value).toString());
                }
                double doubleValue = d;
                Double d2 = BoxesRunTime.boxToDouble((double)doubleValue);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)key);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeClientQuotas$12(Tuple2 x0$5) {
        if (x0$5 == null) {
            throw new MatchError(null);
        }
        String key = (String)x0$5._1();
        boolean bl = DynamicConfig$QuotaConfigs$.MODULE$.isQuotaConfig(key);
        return bl;
    }

    public static final /* synthetic */ Object $anonfun$alterClientQuotas$1(Properties props$1, java.util.Map configKeys$2, ClientQuotaAlteration.Op op) {
        Object object;
        Double d = op.value();
        if (d == null) {
            object = props$1.remove(op.key());
        } else {
            Object object2;
            ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys$2.get(op.key());
            if (configKey == null) {
                throw new InvalidRequestException(new StringBuilder(26).append("Invalid configuration key ").append(op.key()).toString());
            }
            ConfigDef.Type type = configKey.type;
            if (ConfigDef.Type.DOUBLE.equals(type)) {
                object2 = props$1.setProperty(op.key(), d.toString());
            } else if (ConfigDef.Type.LONG.equals(type)) {
                double epsilon = 1.0E-6;
                long longValue = (long)(Predef$.MODULE$.Double2double(d) + epsilon);
                double d2 = (double)longValue - Predef$.MODULE$.Double2double(d);
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                if (RichDouble$.MODULE$.abs$extension(d2) > epsilon) {
                    throw new InvalidRequestException(new StringBuilder(35).append("Configuration ").append(op.key()).append(" must be a Long value").toString());
                }
                object2 = props$1.setProperty(op.key(), ((Object)BoxesRunTime.boxToLong((long)longValue)).toString());
            } else {
                throw new IllegalStateException(new StringBuilder(23).append("Unexpected config type ").append(configKey.type).toString());
            }
            object = object2;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private final void alterEntityQuotas$1(ClientQuotaEntity entity, Iterable ops, boolean validateOnly$5) {
        block4: {
            block5: {
                block3: {
                    var4_4 = this.entityToSanitizedUserClientId(entity);
                    if (var4_4 == null) break block3;
                    var5_5 = (Option)var4_4._1();
                    var6_6 = (Option)var4_4._2();
                    if (!(var5_5 instanceof Some)) break block3;
                    user = (String)((Some)var5_5).value();
                    if (!(var6_6 instanceof Some)) break block3;
                    clientId = (String)((Some)var6_6).value();
                    var20_9 = DynamicConfig$User$.MODULE$.configKeys();
                    var19_10 = ConfigType$.MODULE$.User();
                    var18_11 = new StringBuilder(9).append(user).append("/clients/").append(clientId).toString();
                    break block4;
                }
                if (var4_4 == null) break block5;
                var9_12 = (Option)var4_4._1();
                var10_13 = (Option)var4_4._2();
                if (!(var9_12 instanceof Some)) break block5;
                user = (String)((Some)var9_12).value();
                if (!None$.MODULE$.equals(var10_13)) break block5;
                var20_9 = DynamicConfig$User$.MODULE$.configKeys();
                var19_10 = ConfigType$.MODULE$.User();
                var18_11 = user;
                break block4;
            }
            if (var4_4 == null) ** GOTO lbl-1000
            var12_15 = (Option)var4_4._1();
            var13_16 = (Option)var4_4._2();
            if (None$.MODULE$.equals(var12_15) && var13_16 instanceof Some) {
                var20_9 = DynamicConfig$Client$.MODULE$.configKeys();
                var19_10 = ConfigType$.MODULE$.Client();
                var18_11 = (String)((Some)var13_16).value();
            } else lbl-1000:
            // 2 sources

            {
                throw new InvalidRequestException("Invalid empty client quota entity");
            }
        }
        path = var18_11;
        configType = var19_10;
        configKeys = var20_9;
        props = this.adminZkClient().fetchEntityConfig((String)var15_18, (String)var14_17);
        ops.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$alterClientQuotas$1(java.util.Properties java.util.Map org.apache.kafka.common.quota.ClientQuotaAlteration$Op ), (Lorg/apache/kafka/common/quota/ClientQuotaAlteration$Op;)Ljava/lang/Object;)((Properties)props, (java.util.Map)var16_19));
        if (!validateOnly$5) {
            this.adminZkClient().changeConfigs((String)var15_18, (String)var14_17, props);
        }
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.adminZkClient = new AdminZkClient(zkClient);
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
        this.defaultNumPartitions = config.numPartitions();
        this.defaultReplicationFactor = Predef$.MODULE$.int2Integer(config.defaultReplicationFactor()).shortValue();
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$4$adapted(DynamicBrokerConfig dynamicConfig$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(dynamicConfig$1.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$5$adapted(DynamicBrokerConfig dynamicConfig$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(dynamicConfig$1.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$describeConfigs$4$adapted(String configName$1, Set x$13) {
        return BoxesRunTime.boxToBoolean((boolean)x$13.contains((Object)configName$1));
    }

    public static final /* synthetic */ Object $anonfun$shutdown$2$adapted(CreateTopicPolicy x$19) {
        x$19.close();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$shutdown$4$adapted(AlterConfigPolicy x$20) {
        x$20.close();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$handleDescribeClientQuotas$5$adapted(ClientQuotaFilterComponent x$23) {
        return BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$handleDescribeClientQuotas$5(x$23));
    }

    public static final /* synthetic */ Object $anonfun$handleDescribeClientQuotas$9$adapted(String n$1, String x$24) {
        return BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$handleDescribeClientQuotas$9(n$1, x$24));
    }
}

