/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.Socket;
import java.util.Collections;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.AbstractApiVersionsRequestTest;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;
import scala.Predef;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001\u0002\n\u0014\u0001aAQa\t\u0001\u0005\u0002\u0011BQA\n\u0001\u0005R\u001dBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004B\u0001\u0001\u0006I!\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019q\u0005\u0001)A\u0005\t\"9q\n\u0001b\u0001\n#\u0002\u0006BB.\u0001A\u0003%\u0011\u000bC\u0004]\u0001\t\u0007I\u0011\u000b)\t\ru\u0003\u0001\u0015!\u0003R\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015y\u0007\u0001\"\u0011e\u0011\u0015!\b\u0001\"\u0001e\u0011\u0015I\b\u0001\"\u0001e\u0011\u0015Y\b\u0001\"\u0001e\u0011\u0015i\b\u0001\"\u0003\u007f\u0005i\u0019\u0016m\u001d7Ba&4VM]:j_:\u001c(+Z9vKN$H+Z:u\u0015\t!R#\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001a;A\u0011!dG\u0007\u0002'%\u0011Ad\u0005\u0002\u001f\u0003\n\u001cHO]1di\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgR\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\u000b\u0002\u0007\u0005\u0004\u0018.\u0003\u0002#?\tI1+Y:m'\u0016$X\u000f]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\u0007\u0001\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#\u0001\u0015\u0011\u0005%*T\"\u0001\u0016\u000b\u0005-b\u0013\u0001B1vi\"T!!\f\u0018\u0002\u0011M,7-\u001e:jifT!a\f\u0019\u0002\r\r|W.\\8o\u0015\t1\u0012G\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c+\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nA\u0001\\1oO*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003\u0011\u00032!\u0012':\u001b\u00051%BA$I\u0003%IW.\\;uC\ndWM\u0003\u0002J\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014$\u0003\t1K7\u000f^\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000fI\u0001\u0015g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:\u0016\u0003E\u00032AU*V\u001b\u0005Q\u0015B\u0001+K\u0005\u0011\u0019v.\\3\u0011\u0005YKV\"A,\u000b\u0005ak\u0014\u0001B;uS2L!AW,\u0003\u0015A\u0013x\u000e]3si&,7/A\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm\u001d\u0011\u0002)\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t\u0003U\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002\n1B\u0019:pW\u0016\u00148i\\;oiV\t\u0001\r\u0005\u0002SC&\u0011!M\u0013\u0002\u0004\u0013:$\u0018!B:fiV\u0003H#A3\u0011\u0005I3\u0017BA4K\u0005\u0011)f.\u001b;)\u00051I\u0007C\u00016n\u001b\u0005Y'B\u000174\u0003\u0015QWO\\5u\u0013\tq7N\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u0012Q\"\u001d\t\u0003UJL!a]6\u0003\u000b\u00053G/\u001a:\u0002aQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR\u0014UMZ8sKN\u000b7\u000f\u001c%b]\u0012\u001c\b.Y6f%\u0016\fX/Z:uQ\tqa\u000f\u0005\u0002ko&\u0011\u0001p\u001b\u0002\u0005)\u0016\u001cH/A\u0018uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0003\u001a$XM]*bg2D\u0015M\u001c3tQ\u0006\\WMU3rk\u0016\u001cH\u000f\u000b\u0002\u0010m\u0006aC/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHoV5uQVs7/\u001e9q_J$X\r\u001a,feNLwN\u001c\u0015\u0003!Y\f\u0001f]3oIN\u000b7\u000f\u001c%b]\u0012\u001c\b.Y6f%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uKJ+7\u000f]8og\u0016$\"!Z@\t\u000f\u0005\u0005\u0011\u00031\u0001\u0002\u0004\u000511o\\2lKR\u0004B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013i\u0014a\u00018fi&!\u0011QBA\u0004\u0005\u0019\u0019vnY6fi\u0002")
public class SaslApiVersionsRequestTest
extends AbstractApiVersionsRequestTest
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            ApiVersionsResponse apiVersionsResponse = (ApiVersionsResponse)this.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
            this.validateApiVersionsResponse(apiVersionsResponse);
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    @Test
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendSaslHandshakeRequestValidateResponse(socket);
            ApiVersionsResponse response = (ApiVersionsResponse)this.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
            Assert.assertEquals((long)Errors.ILLEGAL_SASL_STATE.code(), (long)response.data.errorCode());
        }
    }

    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
            ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
            Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)apiVersionsResponse.data.errorCode());
            ApiVersionsResponse apiVersionsResponse2 = (ApiVersionsResponse)this.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
            this.validateApiVersionsResponse(apiVersionsResponse2);
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest(new SaslHandshakeRequestData().setMechanism("PLAIN"));
        SaslHandshakeResponse response = (SaslHandshakeResponse)this.sendAndReceive((AbstractRequest)request, socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(SaslHandshakeResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error());
        Assert.assertEquals(Collections.singletonList("PLAIN"), (Object)response.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"PLAIN", (List)Nil$.MODULE$);
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

