/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEb\u0001\u0002#F\u0001)CQ!\u0015\u0001\u0005\u0002ICq!\u0016\u0001C\u0002\u0013%a\u000b\u0003\u0004e\u0001\u0001\u0006Ia\u0016\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019a\u0007\u0001)A\u0005O\"9Q\u000e\u0001b\u0001\n\u0013q\u0007B\u0002:\u0001A\u0003%q\u000eC\u0004t\u0001\u0001\u0007I\u0011\u0001;\t\u000fa\u0004\u0001\u0019!C\u0001s\"1q\u0010\u0001Q!\nUDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!I\u0011Q\u0010\u0001\u0012\u0002\u0013%\u0011q\u0010\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\ty\r\u0001C\u0005\u0003#Dq!a:\u0001\t\u0013\tI\u000fC\u0004\u0003\u001e\u0002!\t!a\u0001\t\u000f\t\u001d\u0006\u0001\"\u0001\u0002\u0004!9!1\u0016\u0001\u0005\u0002\u0005\r\u0001b\u0002BX\u0001\u0011\u0005\u00111\u0001\u0005\b\u0005g\u0003A\u0011AA\u0002\u0011\u001d\u00119\f\u0001C\u0005\u0005sCqA!5\u0001\t\u0003\t\u0019\u0001C\u0004\u0003V\u0002!\t!a\u0001\t\u000f\te\u0007\u0001\"\u0001\u0002\u0004!9!Q\u001c\u0001\u0005\u0002\u0005\r\u0001b\u0002Bq\u0001\u0011\u0005\u00111\u0001\u0005\b\u0005K\u0004A\u0011AA\u0002\u0011\u001d\u0011I\u000f\u0001C\u0001\u0003\u0007AqA!<\u0001\t\u0003\t\u0019\u0001C\u0004\u0003r\u0002!\t!a\u0001\t\u000f\tU\b\u0001\"\u0001\u0002\u0004\u00191\u0011Q\u001f\u0001E\u0003oD!\"!+#\u0005+\u0007I\u0011\u0001B\u0003\u0011)\u00119A\tB\tB\u0003%\u00111\u0016\u0005\u000b\u0003\u0007\u0014#Q3A\u0005\u0002\t\u0015\u0001B\u0003B\u0005E\tE\t\u0015!\u0003\u0002,\"Q!1\u0002\u0012\u0003\u0016\u0004%\tA!\u0004\t\u0015\tU!E!E!\u0002\u0013\u0011y\u0001\u0003\u0006\u0003\u0018\t\u0012)\u001a!C\u0001\u0005\u001bA!B!\u0007#\u0005#\u0005\u000b\u0011\u0002B\b\u0011\u0019\t&\u0005\"\u0001\u0003\u001c!9!Q\u0005\u0012\u0005\u0002\t\u001d\u0002\"\u0003B\u001dE\u0005\u0005I\u0011\u0001B\u001e\u0011%\u0011)EII\u0001\n\u0003\u00119\u0005C\u0005\u0003L\t\n\n\u0011\"\u0001\u0003H!I!Q\n\u0012\u0012\u0002\u0013\u0005!q\n\u0005\n\u0005'\u0012\u0013\u0013!C\u0001\u0005\u001fB\u0011B!\u0016#\u0003\u0003%\tEa\u0016\t\u0011\te#%!A\u0005\u0002QD\u0011Ba\u0017#\u0003\u0003%\tA!\u0018\t\u0013\t\u001d$%!A\u0005B\t%\u0004\"\u0003B<E\u0005\u0005I\u0011\u0001B=\u0011%\u0011\u0019IIA\u0001\n\u0003\u0012)\tC\u0005\u0003\b\n\n\t\u0011\"\u0011\u0003\n\"I!1\u0012\u0012\u0002\u0002\u0013\u0005#QR\u0004\n\u0005s\u0004\u0011\u0011!E\u0005\u0005w4\u0011\"!>\u0001\u0003\u0003EIA!@\t\rE[D\u0011AB\u0006\u0011%\u00119iOA\u0001\n\u000b\u0012I\tC\u0005\u0004\u000em\n\t\u0011\"!\u0004\u0010!I1\u0011D\u001e\u0012\u0002\u0013\u0005!q\n\u0005\n\u00077Y\u0014\u0013!C\u0001\u0005\u001fB\u0011b!\b<\u0003\u0003%\tia\b\t\u0013\r52(%A\u0005\u0002\t=\u0003\"CB\u0018wE\u0005I\u0011\u0001B(\u0005Y\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:UKN$(B\u0001$H\u0003\u0019\u0019XM\u001d<fe*\t\u0001*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0005C\u0001'P\u001b\u0005i%\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002'B\u0011A\u000bA\u0007\u0002\u000b\u0006!A/[7f+\u00059\u0006C\u0001-c\u001b\u0005I&B\u0001.\\\u0003\u0015)H/\u001b7t\u0015\taV,\u0001\u0004d_6lwN\u001c\u0006\u0003\u0011zS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111-\u0017\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#A4\u0011\u0005!TW\"A5\u000b\u0005\u0015\\\u0016BA6j\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0007G>tg-[4\u0016\u0003=\u0004\"\u0001\u00169\n\u0005E,%\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u00048v[\u000e\u000bG\u000e\u001c2bG.\u001cX#A;\u0011\u000513\u0018BA<N\u0005\rIe\u000e^\u0001\u0011]Vl7)\u00197mE\u0006\u001c7n]0%KF$\"A_?\u0011\u00051[\u0018B\u0001?N\u0005\u0011)f.\u001b;\t\u000fyL\u0011\u0011!a\u0001k\u0006\u0019\u0001\u0010J\u0019\u0002\u001b9,XnQ1mY\n\f7m[:!\u0003!!X-\u0019:E_^tG#\u0001>)\u0007-\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti\u0001Y\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003#\tYAA\u0003BMR,'/\u0001\u0005dC2d'-Y2l)\rQ\u0018q\u0003\u0005\b\u00033a\u0001\u0019AA\u000e\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BA\u000f\u0003SqA!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G9\u0015a\u00028fi^|'o[\u0005\u0005\u0003O\t\t#\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\u0005-\u0012Q\u0006\u0002\t%\u0016\u001c\bo\u001c8tK*!\u0011qEA\u0011\u00031\u0011W/\u001b7e%\u0016\fX/Z:u+\u0011\t\u0019$a\u0010\u0015\r\u0005U\u0012QLA8!\u001da\u0015qGA\u001e\u0003/J1!!\u000fN\u0005\u0019!V\u000f\u001d7feA!\u0011QHA \u0019\u0001!q!!\u0011\u000e\u0005\u0004\t\u0019EA\u0001U#\u0011\t)%a\u0013\u0011\u00071\u000b9%C\u0002\u0002J5\u0013qAT8uQ&tw\r\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tfW\u0001\te\u0016\fX/Z:ug&!\u0011QKA(\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\u0003BA\u000f\u00033JA!a\u0017\u0002.\t9!+Z9vKN$\bbBA0\u001b\u0001\u0007\u0011\u0011M\u0001\bEVLG\u000eZ3s!\u0019\t\u0019'!\u001b\u0002<9!\u0011QJA3\u0013\u0011\t9'a\u0014\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLA!a\u001b\u0002n\t9!)^5mI\u0016\u0014(\u0002BA4\u0003\u001fB\u0011\"!\u001d\u000e!\u0003\u0005\r!a\u001d\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005U\u0014\u0011P\u0007\u0003\u0003oR1!a\t\\\u0013\u0011\tY(a\u001e\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002-\t,\u0018\u000e\u001c3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*B!!!\u0002\u0018V\u0011\u00111\u0011\u0016\u0005\u0003g\n)i\u000b\u0002\u0002\bB!\u0011\u0011RAJ\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015!C;oG\",7m[3e\u0015\r\t\t*T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAK\u0003\u0017\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u001d\t\tE\u0004b\u0001\u0003\u0007\n1\"\\1zE\u0016\u0014VmY8sIRIQ/!(\u0002(\u0006\u0005\u0017Q\u0019\u0005\b\u0003?{\u0001\u0019AAQ\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\r!\u00161U\u0005\u0004\u0003K+%AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJDq!!+\u0010\u0001\u0004\tY+\u0001\u0003vg\u0016\u0014\b\u0003BAW\u0003wsA!a,\u00028B\u0019\u0011\u0011W'\u000e\u0005\u0005M&bAA[\u0013\u00061AH]8pizJ1!!/N\u0003\u0019\u0001&/\u001a3fM&!\u0011QXA`\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011X'\t\u000f\u0005\rw\u00021\u0001\u0002,\u0006A1\r\\5f]RLE\rC\u0004\u0002H>\u0001\r!!3\u0002\u000bY\fG.^3\u0011\u00071\u000bY-C\u0002\u0002N6\u0013a\u0001R8vE2,\u0017\u0001\u0003;ie>$H\u000f\\3\u0015\u0017i\f\u0019.!6\u0002X\u0006e\u0017Q\u001c\u0005\b\u0003?\u0003\u0002\u0019AAQ\u0011\u001d\tI\u000b\u0005a\u0001\u0003WCq!a1\u0011\u0001\u0004\tY\u000b\u0003\u0004\u0002\\B\u0001\r!^\u0001\u000fi\"\u0014x\u000e\u001e;mKRKW.Z't\u0011\u001d\ty\u000e\u0005a\u0001\u0003C\f\u0011d\u00195b]:,G\u000e\u00165s_R$H.\u001b8h\u0007\u0006dGNY1dWB1A*a9\u0002\u001ciL1!!:N\u0005%1UO\\2uS>t\u0017'\u0001\tuKN$\u0018+^8uCB\u000b'o]5oORY!0a;\u0002n\nE%Q\u0013BM\u0011\u0015i\u0017\u00031\u0001p\u0011\u001d\ty/\u0005a\u0001\u0003c\fqa\u00197jK:$\u0018\u0007E\u0002\u0002t\nj\u0011\u0001\u0001\u0002\u000b+N,'o\u00117jK:$8C\u0002\u0012L\u0003s\fy\u0010E\u0002M\u0003wL1!!@N\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001\u0014B\u0001\u0013\r\u0011\u0019!\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u0003\u0003W\u000bQ!^:fe\u0002\n\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u0015\r|gNZ5h+N,'/\u0006\u0002\u0003\u0010A)AJ!\u0005\u0002,&\u0019!1C'\u0003\r=\u0003H/[8o\u0003-\u0019wN\u001c4jOV\u001bXM\u001d\u0011\u0002\u001d\r|gNZ5h\u00072LWM\u001c;JI\u0006y1m\u001c8gS\u001e\u001cE.[3oi&#\u0007\u0005\u0006\u0006\u0002r\nu!q\u0004B\u0011\u0005GAq!!+,\u0001\u0004\tY\u000bC\u0004\u0002D.\u0002\r!a+\t\u0013\t-1\u0006%AA\u0002\t=\u0001\"\u0003B\fWA\u0005\t\u0019\u0001B\b\u0003]\u0019\u0018M\\5uSj,GmQ8oM&<7\t\\5f]RLE-\u0006\u0002\u0003*A)AJ!\u0005\u0003,A!!Q\u0006B\u001c\u001b\t\u0011yC\u0003\u0003\u00032\tM\u0012\u0001\u00027b]\u001eT!A!\u000e\u0002\t)\fg/Y\u0005\u0005\u0003{\u0013y#\u0001\u0003d_BLHCCAy\u0005{\u0011yD!\u0011\u0003D!I\u0011\u0011V\u0017\u0011\u0002\u0003\u0007\u00111\u0016\u0005\n\u0003\u0007l\u0003\u0013!a\u0001\u0003WC\u0011Ba\u0003.!\u0003\u0005\rAa\u0004\t\u0013\t]Q\u0006%AA\u0002\t=\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0013RC!a+\u0002\u0006\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005#RCAa\u0004\u0002\u0006\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003,\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B0\u0005K\u00022\u0001\u0014B1\u0013\r\u0011\u0019'\u0014\u0002\u0004\u0003:L\bb\u0002@5\u0003\u0003\u0005\r!^\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u000e\t\u0007\u0005[\u0012\u0019Ha\u0018\u000e\u0005\t=$b\u0001B9\u001b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tU$q\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003|\t\u0005\u0005c\u0001'\u0003~%\u0019!qP'\u0003\u000f\t{w\u000e\\3b]\"AaPNA\u0001\u0002\u0004\u0011y&\u0001\u0005iCND7i\u001c3f)\u0005)\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003|\t=\u0005\u0002\u0003@:\u0003\u0003\u0005\rAa\u0018\t\u000f\tM\u0015\u00031\u0001\u0002r\u000691\r\\5f]R\u0014\u0004b\u0002BL#\u0001\u0007\u0011\u0011_\u0001\re\u0006tGm\\7DY&,g\u000e\u001e\u0005\b\u00057\u000b\u0002\u0019AAy\u0003M!WMZ1vYR\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0003a!Xm\u001d;DY&,g\u000e^%e#V|G/\u0019)beNLgn\u001a\u0015\u0004%\t\u0005\u0006\u0003BA\u0005\u0005GKAA!*\u0002\f\t!A+Z:u\u0003Q!Xm\u001d;Vg\u0016\u0014\u0018+^8uCB\u000b'o]5oO\"\u001a1C!)\u00029Q,7\u000f^+tKJ\u001cE.[3oi&#\u0017+^8uCB\u000b'o]5oO\"\u001aAC!)\u0002YQ,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8h/&$\b\u000eR3gCVdGo\u00117jK:$\u0018\nZ)v_R\f\u0007fA\u000b\u0003\"\u0006!D/Z:u+N,'o\u00117jK:$\u0018+^8uCB\u000b'o]5oO&#w+\u001b;i\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1)\u0007Y\u0011\t+\u0001\u0006dQ\u0016\u001c7.U;pi\u0006$RB\u001fB^\u0005{\u0013yL!1\u0003L\n5\u0007bBAP/\u0001\u0007\u0011\u0011\u0015\u0005\b\u0003S;\u0002\u0019AAV\u0011\u001d\t\u0019m\u0006a\u0001\u0003WCqAa1\u0018\u0001\u0004\u0011)-A\u0007fqB,7\r^3e\u0005>,h\u000e\u001a\t\u0004\u0019\n\u001d\u0017b\u0001Be\u001b\n!Aj\u001c8h\u0011\u0019\t9m\u0006a\u0001k\"9!qZ\fA\u0002\tm\u0014AD3ya\u0016\u001cG\u000f\u00165s_R$H.Z\u00016i\u0016\u001cHoR3u\u001b\u0006Dh+\u00197vK&s\u0017+^8uC^Kg\u000eZ8x/&$\bNT8o\t\u00164\u0017-\u001e7u#V|G/Y,j]\u0012|w\u000fK\u0002\u0019\u0005C\u000b\u0001\u0005^3tiN+G/\u00118e%\u0016lwN^3EK\u001a\fW\u000f\u001c;Vg\u0016\u0014\u0018+^8uC\"\u001a\u0011D!)\u00023Q,7\u000f^*fi\u0006sGMU3n_Z,Wk]3s#V|G/\u0019\u0015\u00045\t\u0005\u0016a\b;fgR\u001cV\r^!oIJ+Wn\u001c<f+N,'o\u00117jK:$\u0018+^8uC\"\u001a1D!)\u00023Q,7\u000f^)v_R\f7i\u001c8gS\u001e\u0004&/Z2fI\u0016t7-\u001a\u0015\u00049\t\u0005\u0016A\u0005;fgR\fVo\u001c;b-&|G.\u0019;j_:D3!\bBQ\u0003\r\"Xm\u001d;SKF,Xm\u001d;QKJ\u001cWM\u001c;bO\u0016\fVo\u001c;b-&|G.\u0019;j_:D3A\bBQ\u0003q!Xm\u001d;FqBL'/\u001a+ie>$H\u000f\\3US6,7+\u001a8t_JD3a\bBQ\u0003Y!Xm\u001d;FqBL'/Z)v_R\f7+\u001a8t_J\u001c\bf\u0001\u0011\u0003\"\u0006AB/Z:u\u00072LWM\u001c;JI:{GoU1oSRL'0\u001a3)\u0007\u0005\u0012\t+\u0001\u0006Vg\u0016\u00148\t\\5f]R\u00042!a=<'\u0015Y$q`A\u0000!9\u0019\taa\u0002\u0002,\u0006-&q\u0002B\b\u0003cl!aa\u0001\u000b\u0007\r\u0015Q*A\u0004sk:$\u0018.\\3\n\t\r%11\u0001\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001B~\u0003\u0015\t\u0007\u000f\u001d7z))\t\tp!\u0005\u0004\u0014\rU1q\u0003\u0005\b\u0003Ss\u0004\u0019AAV\u0011\u001d\t\u0019M\u0010a\u0001\u0003WC\u0011Ba\u0003?!\u0003\u0005\rAa\u0004\t\u0013\t]a\b%AA\u0002\t=\u0011aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\"\r%\u0002#\u0002'\u0003\u0012\r\r\u0002c\u0003'\u0004&\u0005-\u00161\u0016B\b\u0005\u001fI1aa\nN\u0005\u0019!V\u000f\u001d7fi!I11F!\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e")
public class ClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public void callback(RequestChannel.Response response) {
        if (response instanceof RequestChannel.StartThrottlingResponse) {
            return;
        }
        if (response instanceof RequestChannel.EndThrottlingResponse) {
            this.numCallbacks_$eq(this.numCallbacks() + 1);
            return;
        }
        throw new MatchError((Object)response);
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return quotaManager.maybeRecordAndGetThrottleTimeMs(new RequestChannel.Session(principal, null), clientId, value, this.time().milliseconds());
    }

    /*
     * WARNING - void declaration
     */
    private void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        void var7_7;
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        quotaManager.throttle((RequestChannel.Request)var7_7, throttleTimeMs, channelThrottlingCallback);
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder(33).append("Default producer quota should be ").append(config.quotaBytesPerSecondDefault()).toString(), (double)config.quotaBytesPerSecondDefault(), (double)clientMetrics.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assert.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(Long.MAX_VALUE, numFullQuotaWindows + 1, ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        ClientQuotaManager quotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assert.assertEquals((double)Double.MAX_VALUE, (double)quotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assert.assertEquals((double)(10 * numFullQuotaWindows), (double)quotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(quotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(quotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(quotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(quotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(quotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(quotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(quotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(quotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(quotaManager, "userE", "client1", 3000L, 2500, false);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(quotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(quotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(quotaManager, "userF", "client5", 1000L, 800, true);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(quotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(quotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(quotaManager, "userG", "client5", 2000L, 0, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(quotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(quotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(quotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(quotaManager, "userA", "client1", 10000L, 6000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client6", 8000L, 0, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(quotaManager, "userA", "client6", 11000L, 8500, false);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            void var10_9;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, 10);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testQuotaViolation$1(this, clientMetrics, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int sleepTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            Function1 & Serializable & scala.Serializable throttle_channelThrottlingCallback = (Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            };
            Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            RequestChannel.Request throttle_request = (RequestChannel.Request)tuple2._2();
            clientMetrics.throttle((RequestChannel.Request)var10_9, sleepTime, (Function1)throttle_channelThrottlingCallback);
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)sleepTime);
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            int n2 = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range2 = RichInt$.MODULE$.until$extension0(n2, 10);
            if (range2 == null) {
                throw null;
            }
            Range foreach$mVc$sp_this2 = range2;
            if (!foreach$mVc$sp_this2.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testQuotaViolation$3(this, clientMetrics, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
                }
            }
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 0.0));
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRequestPercentageQuotaViolation() {
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Request", ""));
        try {
            void var10_9;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, 10);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$1(this, quotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(67.1));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            Function1 & Serializable & scala.Serializable throttle_channelThrottlingCallback = (Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            };
            Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            RequestChannel.Request throttle_request = (RequestChannel.Request)tuple2._2();
            quotaManager.throttle((RequestChannel.Request)var10_9, throttleTime, (Function1)throttle_channelThrottlingCallback);
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            int n2 = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range2 = RichInt$.MODULE$.until$extension0(n2, 11);
            if (range2 == null) {
                throw null;
            }
            Range foreach$mVc$sp_this2 = range2;
            if (!foreach$mVc$sp_this2.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$3(this, quotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
                }
            }
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(500.0)));
            int n3 = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range3 = RichInt$.MODULE$.until$extension0(n3, 10);
            if (range3 == null) {
                throw null;
            }
            Range foreach$mVc$sp_this3 = range3;
            if (!foreach$mVc$sp_this3.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this3.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$4(this, quotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this3.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this3.step();
                }
            }
            this.time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        String clientId = "client@#$%";
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testQuotaViolation$1(ClientQuotaManagerTest $this, ClientQuotaManager clientMetrics$1, int _) {
        Assert.assertEquals((long)0L, (long)$this.maybeRecord(clientMetrics$1, "ANONYMOUS", "unknown", 400.0));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testQuotaViolation$3(ClientQuotaManagerTest $this, ClientQuotaManager clientMetrics$1, int _) {
        $this.maybeRecord(clientMetrics$1, "ANONYMOUS", "unknown", 400.0);
        $this.time().sleep(1000L);
    }

    private static final double millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$1(ClientQuotaManagerTest $this, ClientRequestQuotaManager quotaManager$1, int _) {
        Assert.assertEquals((long)0L, (long)$this.maybeRecord((ClientQuotaManager)quotaManager$1, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0)));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$3(ClientQuotaManagerTest $this, ClientRequestQuotaManager quotaManager$1, int _) {
        $this.maybeRecord((ClientQuotaManager)quotaManager$1, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$4(ClientQuotaManagerTest $this, ClientRequestQuotaManager quotaManager$1, int _) {
        $this.time().sleep(1000L);
        Assert.assertEquals((long)1000L, (long)$this.maybeRecord((ClientQuotaManager)quotaManager$1, "ANONYMOUS", "test-client", 0.0));
    }

    public class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            Option<String> option = this.configClientId();
            if (option == null) {
                throw null;
            }
            Option<String> map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)UserClient.$anonfun$sanitizedConfigClientId$1((String)map_this.get()));
            return object;
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof UserClient)) return false;
            if (((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ String $anonfun$sanitizedConfigClientId$1(String x) {
            String string = x;
            String string2 = ConfigEntityName$.MODULE$.Default();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return ConfigEntityName$.MODULE$.Default();
            }
            return Sanitizer.sanitize((String)x);
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

