/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogUtils$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.RollParams;
import kafka.server.FetchDataInfo;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004G\u0001\u0001\u0006Ia\u000f\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019!\u0006\u0001)A\u0005\u0013\"IQ\u000b\u0001a\u0001\u0002\u0004%\tA\u0016\u0005\n?\u0002\u0001\r\u00111A\u0005\u0002\u0001D\u0011B\u001a\u0001A\u0002\u0003\u0005\u000b\u0015B,\t\u000b\u001d\u0004A\u0011\u00015\t\u000fm\u0004\u0011\u0013!C\u0001y\"I\u0011q\u0002\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!a\u0016\u0001\t\u0003\t9\u0005C\u0004\u0002b\u0001!\t!a\u0012\t\u000f\u0005-\u0004\u0001\"\u0001\u0002H!9\u0011q\u000e\u0001\u0005\u0002\u0005\u001d\u0003bBA:\u0001\u0011\u0005\u0011q\t\u0005\b\u0003o\u0002A\u0011AA$\u0011\u001d\tY\b\u0001C\u0001\u0003\u000fBq!a \u0001\t\u0003\t9\u0005C\u0004\u0002\u0004\u0002!\t!a\u0012\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002H!9\u00111\u0012\u0001\u0005\u0002\u0005\u001d\u0003bBAH\u0001\u0011\u0005\u0011q\t\u0005\b\u0003'\u0003A\u0011AA$\u0011\u001d\t9\n\u0001C\u0001\u0003\u000fBq!a'\u0001\t\u0003\t9\u0005C\u0004\u0002 \u0002!I!!)\t\u0011\u0005%\u0007!%A\u0005\nqD\u0001\"a3\u0001#\u0003%I\u0001 \u0005\n\u0003\u001b\u0004\u0011\u0013!C\u0005\u0003\u001fDq!a5\u0001\t\u0003\t9\u0005C\u0004\u0002X\u0002!\t!a\u0012\t\r\u001d\u0004A\u0011BAn\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003\u000fBq!a>\u0001\t\u0003\t9\u0005C\u0004\u0002|\u0002!\t!a\u0012\t\u000f\u0005}\b\u0001\"\u0001\u0002H\tqAj\\4TK\u001elWM\u001c;UKN$(B\u0001\u0016,\u0003\rawn\u001a\u0006\u0002Y\u0005)1.\u00194lC\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011!K\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005Y\u0004C\u0001\u001fE\u001b\u0005i$B\u0001 @\u0003\u0019\u0019w.\\7p]*\u0011A\u0006\u0011\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014x-\u0003\u0002F{\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u0011M,w-\\3oiN,\u0012!\u0013\t\u0004\u0015>\u000bV\"A&\u000b\u00051k\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u001dF\n!bY8mY\u0016\u001cG/[8o\u0013\t\u00016JA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u0001\u001dS\u0013\t\u0019\u0016F\u0001\u0006M_\u001e\u001cVmZ7f]R\f\u0011b]3h[\u0016tGo\u001d\u0011\u0002\r1|w\rR5s+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\tIwNC\u0001]\u0003\u0011Q\u0017M^1\n\u0005yK&\u0001\u0002$jY\u0016\f!\u0002\\8h\t&\u0014x\fJ3r)\t\tG\r\u0005\u00021E&\u00111-\r\u0002\u0005+:LG\u000fC\u0004f\u000f\u0005\u0005\t\u0019A,\u0002\u0007a$\u0013'A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001b\r\u0014X-\u0019;f'\u0016<W.\u001a8u)\u0011\t\u0016N\\:\t\u000b)L\u0001\u0019A6\u0002\r=4gm]3u!\t\u0001D.\u0003\u0002nc\t!Aj\u001c8h\u0011\u001dy\u0017\u0002%AA\u0002A\f!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgB\u0011\u0001']\u0005\u0003eF\u00121!\u00138u\u0011\u001d!\u0018\u0002%AA\u0002U\fA\u0001^5nKB\u0011a/_\u0007\u0002o*\u0011\u00010P\u0001\u0006kRLGn]\u0005\u0003u^\u0014A\u0001V5nK\u000692M]3bi\u0016\u001cVmZ7f]R$C-\u001a4bk2$HEM\u000b\u0002{*\u0012\u0001O`\u0016\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C;oG\",7m[3e\u0015\r\tI!M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0014)\u0012QO`\u0001\be\u0016\u001cwN\u001d3t)\u0019\tI\"!\n\u0002(A!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 u\naA]3d_J$\u0017\u0002BA\u0012\u0003;\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\b\"\u00026\r\u0001\u0004Y\u0007bBA\u000b\u0019\u0001\u0007\u0011\u0011\u0006\t\u0006a\u0005-\u0012qF\u0005\u0004\u0003[\t$A\u0003\u001fsKB,\u0017\r^3e}A!\u0011\u0011GA \u001d\u0011\t\u0019$a\u000f\u0011\u0007\u0005U\u0012'\u0004\u0002\u00028)\u0019\u0011\u0011H\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\ti$M\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0012'A\u0003tKR,\b\u000fF\u0001bQ\ri\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\"\u0002\u000b),h.\u001b;\n\t\u0005U\u0013q\n\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d3po:D3ADA.!\u0011\ti%!\u0018\n\t\u0005}\u0013q\n\u0002\u0006\u0003\u001a$XM]\u0001\u0017i\u0016\u001cHOU3bI>sW)\u001c9usN+w-\\3oi\"\u001aq\"!\u001a\u0011\t\u00055\u0013qM\u0005\u0005\u0003S\nyE\u0001\u0003UKN$\u0018!\u0007;fgR\u0014V-\u00193CK\u001a|'/\u001a$jeN$xJ\u001a4tKRD3\u0001EA3\u0003E!Xm\u001d;SK\u0006$\u0017I\u001a;fe2\u000b7\u000f\u001e\u0015\u0004#\u0005\u0015\u0014a\u0004;fgR\u0014V-\u00193Ge>lw)\u00199)\u0007I\t)'\u0001\u0007uKN$HK];oG\u0006$X\rK\u0002\u0014\u0003K\n\u0001\u0004^3tiR\u0013XO\\2bi\u0016,U\u000e\u001d;z'\u0016<W.\u001a8uQ\r!\u0012QM\u00017i\u0016\u001cHOU3m_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e]!oI:+\u0007\u0010^(gMN,G/\u00114uKJ$&/\u001e8dCRLwN\u001c\u0015\u0004+\u0005\u0015\u0014\u0001\u0005;fgR$&/\u001e8dCR,g)\u001e7mQ\r1\u0012QM\u0001\u001ai\u0016\u001cHOR5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000fK\u0002\u0018\u0003K\n\u0011\u0004^3ti:+\u0007\u0010^(gMN,GoQ1mGVd\u0017\r^5p]\"\u001a\u0001$!\u001a\u0002-Q,7\u000f^\"iC:<WMR5mKN+hMZ5yKND3!GA3\u0003u!Xm\u001d;SK\u000e|g/\u001a:z\r&DXm]\"peJ,\b\u000f^%oI\u0016D\bf\u0001\u000e\u0002f\u0005YB/Z:u%\u0016\u001cwN^3s)J\fgn]1di&|g.\u00138eKbD3aGA3\u0003y!Xm\u001d;SK\u000e|g/\u001a:z%\u0016\u0014W/\u001b7eg\u0016\u0003xn\u00195DC\u000eDW\rK\u0002\u001d\u0003K\nQ\"\u001a8e)bt'+Z2pe\u0012\u001cH\u0003EA\r\u0003G\u000bi+!-\u0002<\u0006u\u0016\u0011YAc\u0011\u001d\t)+\ba\u0001\u0003O\u000b\u0011cY8oiJ|GNU3d_J$G+\u001f9f!\u0011\tY\"!+\n\t\u0005-\u0016Q\u0004\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007BBAX;\u0001\u00071.\u0001\u0006qe>$WoY3s\u0013\u0012Dq!a-\u001e\u0001\u0004\t),A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004a\u0005]\u0016bAA]c\t)1\u000b[8si\")!.\ba\u0001W\"A\u0011qX\u000f\u0011\u0002\u0003\u0007\u0001/\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\t\u0003\u0007l\u0002\u0013!a\u0001a\u0006\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\t\u0003\u000fl\u0002\u0013!a\u0001W\u0006IA/[7fgR\fW\u000e]\u0001\u0018K:$G\u000b\u001f8SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIU\nq#\u001a8e)bt'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0002/\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012:TCAAiU\tYg0A\u0011uKN$(+Z2pm\u0016\u0014\u0018PR5yKN\u001cuN\u001d:vaR$\u0016.\\3J]\u0012,\u0007\u0010K\u0002\"\u0003K\na\u0004^3tiJ+7m\u001c<fef<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3)\u0007\t\n)\u0007F\u0005R\u0003;\f\t/a;\u0002p\"1\u0011q\\\u0012A\u0002-\f!BY1tK>3gm]3u\u0011\u001d\t\u0019o\ta\u0001\u0003K\f\u0011CZ5mK\u0006c'/Z1es\u0016C\u0018n\u001d;t!\r\u0001\u0014q]\u0005\u0004\u0003S\f$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003[\u001c\u0003\u0019\u00019\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u000f\u0005E8\u00051\u0001\u0002f\u0006Y\u0001O]3bY2|7-\u0019;f\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"Le.\u001b;GS2,7+\u001b>f\u0003B\u0004XM\u001c3NKN\u001c\u0018mZ3)\u0007\u0011\n)'A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]&$h)\u001b7f'&TXm\u00117fCJ\u001c\u0006.\u001e;e_^t\u0007fA\u0013\u0002f\u0005q3\u000f[8vY\u0012$&/\u001e8dCR,WI^3o\u0013\u001a|eMZ:fiB{\u0017N\u001c;t)>\fu)\u00199J]RCW\rT8hQ\r1\u0013QM\u0001\u0013i\u0016\u001cH/\u00119qK:$gI]8n\r&dW\rK\u0002(\u0003K\u0002")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @Before
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        FetchDataInfo read = seg.read(40L, 300, seg.read$default$3(), seg.read$default$4());
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read(41L, 300, seg.read$default$3(), seg.read$default$4()).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        FetchDataInfo read = seg.read(52L, 200, seg.read$default$3(), seg.read$default$4());
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 30);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogSegmentTest.$anonfun$testTruncate$1(this, offset, seg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$1 = 0L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        long x$4 = 0L;
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$4, x$6, (Time)time);
        Assert.assertEquals((long)0L, (long)seg.timeIndex().sizeInBytes());
        Assert.assertEquals((long)0L, (long)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assert.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.timeIndex().isFull());
        Assert.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assert.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assert.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numMessages);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogSegmentTest.$anonfun$testReloadLargestTimestampAndNextOffsetAfterTruncation$1(this, seg, offset, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString(), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)"Should have 0 time indexes", (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)"Largest timestamp should be 400", (long)400L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$1 = 40L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assert.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assert.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)seg.timeIndex().isFull());
        Assert.assertFalse((boolean)seg.offsetIndex().isFull());
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, 1024, seg.read$default$3(), seg.read$default$4()));
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        int n = 40;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 50);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, (long)(foreach$mVc$sp_i * 10), (long)foreach$mVc$sp_i, this.records(foreach$mVc$sp_i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(foreach$mVc$sp_i).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assert.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assert.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.lazyOffsetIndex().file();
        File timeIndexFile = seg.lazyTimeIndex().file();
        Assert.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assert.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assert.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        Assert.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyOffsetIndex().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyTimeIndex().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        seg.lazyOffsetIndex().get();
        Assert.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
        seg.lazyTimeIndex().get();
        Assert.assertTrue((boolean)seg.lazyTimeIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 100);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, -1L, -1L, this.records(foreach$mVc$sp_i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)foreach$mVc$sp_i)).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        File indexFile = seg.lazyOffsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, 100);
        if (range2 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this2 = range2;
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryFixesCorruptIndex$2(seg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(10, 10L, 5, -1L)})), producerEpoch, 0, -1L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRecoveryRebuildsEpochCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public void write(Seq<EpochEntry> epochs) {
                this.epochs_$eq((Seq<EpochEntry>)epochs.toVector());
            }

            public Seq<EpochEntry> read() {
                return this.epochs();
            }
            {
                this.epochs = (Seq)Seq$.MODULE$.empty();
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> seg.readNextOffset(), checkpoint);
        seg.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(107L, -1L, 106L, MemoryRecords.withRecords((long)106L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(109L, -1L, 108L, MemoryRecords.withRecords((long)108L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(111L, -1L, 110L, MemoryRecords.withRecords((long)110L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), (Option)new Some((Object)cache));
        Assert.assertEquals((Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)})), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 100);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, (long)(foreach$mVc$sp_i * 10), (long)foreach$mVc$sp_i, this.records(foreach$mVc$sp_i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)foreach$mVc$sp_i)).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        File timeIndexFile = seg.lazyTimeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, 100);
        if (range2 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this2 = range2;
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryFixesCorruptTimeIndex$2(seg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 10);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryWithCorruptMessage$1(this, messagesAppended, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        File tempDir = TestUtils$.MODULE$.tempDir();
        Tuple2[] tuple2Array = new Tuple2[3];
        Integer n = BoxesRunTime.boxToInteger((int)10);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n2 = BoxesRunTime.boxToInteger((int)1000);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n3 = BoxesRunTime.boxToInteger((int)0);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        File tempDir = TestUtils$.MODULE$.tempDir();
        Tuple2[] tuple2Array = new Tuple2[3];
        Integer n = BoxesRunTime.boxToInteger((int)10);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n2 = BoxesRunTime.boxToInteger((int)1000);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n3 = BoxesRunTime.boxToInteger((int)0);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, false, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200, segReopen.read$default$3(), segReopen.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size);
        Assert.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000, seg.read$default$3(), seg.read$default$4());
        Assert.assertEquals((long)offset, (long)((RecordBatch)log.records().batches().iterator().next()).baseOffset());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(log.records().batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)Log$.MODULE$.logFile(tempDir, 0L, Log$.MODULE$.logFile$default$3()));
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)bytesAppended);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assert.assertEquals((long)(sizeAfterOverflow - sizeBeforeOverflow), (long)overflowBytesAppended);
        Assert.assertEquals((long)overflowBytesAppended, (long)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    public static final /* synthetic */ void $anonfun$testTruncate$1(LogSegmentTest $this, IntRef offset$2, LogSegment seg$1, int _) {
        MemoryRecords ms1 = $this.records(offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        seg$1.append((long)offset$2.elem, -1L, -1L, ms1);
        MemoryRecords ms2 = $this.records(offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        seg$1.append((long)(offset$2.elem + 1), -1L, -1L, ms2);
        FetchDataInfo read = seg$1.read((long)offset$2.elem, 10000, seg$1.read$default$3(), seg$1.read$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
        seg$1.truncateTo((long)(offset$2.elem + 1));
        FetchDataInfo read2 = seg$1.read((long)offset$2.elem, 10000, seg$1.read$default$3(), seg$1.read$default$4());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
        TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
        ++offset$2.elem;
    }

    public static final /* synthetic */ void $anonfun$testReloadLargestTimestampAndNextOffsetAfterTruncation$1(LogSegmentTest $this, LogSegment seg$2, IntRef offset$3, int _) {
        seg$2.append((long)offset$3.elem, (long)offset$3.elem, (long)offset$3.elem, $this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
        ++offset$3.elem;
    }

    public static final /* synthetic */ void $anonfun$testRecoveryFixesCorruptIndex$2(LogSegment seg$4, int i) {
        long x$1 = i;
        int x$2 = 1;
        boolean x$3 = true;
        long x$4 = seg$4.read$default$3();
        Iterable records = seg$4.read(x$1, x$2, x$4, x$3).records().records();
        Assert.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryFixesCorruptTimeIndex$2(LogSegment seg$6, int i) {
        Assert.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10)), (long)seg$6.findOffsetByTimestamp$default$2()).get()).offset);
        if (i < 99) {
            Assert.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)seg$6.findOffsetByTimestamp$default$2()).get()).offset);
        }
    }

    public static final /* synthetic */ void $anonfun$testRecoveryWithCorruptMessage$1(LogSegmentTest $this, int messagesAppended$1, int _) {
        LogSegment seg = $this.createSegment(0L, $this.createSegment$default$2(), $this.createSegment$default$3());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, messagesAppended$1);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, -1L, -1L, $this.records(foreach$mVc$sp_i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)foreach$mVc$sp_i)).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended$1);
        int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
        TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
        seg.recover(new ProducerStateManager($this.topicPartition(), $this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(n2, offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList());
        seg.deleteIfExists();
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private static final MemoryRecords records$2(long offset, int size) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size])});
    }
}

