/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.LogSegment;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\r\u001a\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006o\u0001!\t\u0001\u000f\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\t\u0005\u0001)A\u0005{!9!\t\u0001b\u0001\n\u0003a\u0004BB\"\u0001A\u0003%Q\bC\u0004E\u0001\t\u0007I\u0011A#\t\r%\u0003\u0001\u0015!\u0003G\u0011\u001dQ\u0005A1A\u0005\u0002-Caa\u0014\u0001!\u0002\u0013a\u0005b\u0002)\u0001\u0005\u0004%\t\u0001\u0010\u0005\u0007#\u0002\u0001\u000b\u0011B\u001f\t\u000bI\u0003A\u0011I*\t\u000f\u0005\u0004!\u0019!C\u0001E\"1!\u000e\u0001Q\u0001\n\rDQa\u001b\u0001\u0005\u00021DQa\u001e\u0001\u0005\naDq!!\u0004\u0001\t\u0013\tyaB\u0004\u0002FeA\t!a\u0012\u0007\raI\u0002\u0012AA%\u0011\u00199D\u0003\"\u0001\u0002R!9\u00111\u000b\u000b\u0005\u0002\u0005U\u0003bBA5)\u0011\u0005\u0011Q\u000b\u0002\u001d\u0019><7\t\\3b]\u0016\u0014H*Y4J]R,wM]1uS>tG+Z:u\u0015\tQ2$A\u0002m_\u001eT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001qd\t\t\u0003A\u0005j\u0011!G\u0005\u0003Ee\u0011\u0011%\u00112tiJ\f7\r\u001e'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgR\u0004\"\u0001J\u0014\u000e\u0003\u0015R!AJ\u000e\u0002\u000bU$\u0018\u000e\\:\n\u0005!*#a\u0002'pO\u001eLgnZ\u0001\u0015G>l\u0007O]3tg&|gnQ8eK\u000et\u0015-\\3\u0011\u0005-\"dB\u0001\u00173!\ti\u0003'D\u0001/\u0015\tyS$\u0001\u0004=e>|GO\u0010\u0006\u0002c\u0005)1oY1mC&\u00111\u0007M\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024a\u00051A(\u001b8jiz\"\"!\u000f\u001e\u0011\u0005\u0001\u0002\u0001\"B\u0015\u0003\u0001\u0004Q\u0013!C7t!\u0016\u0014\bj\\;s+\u0005i\u0004C\u0001 @\u001b\u0005\u0001\u0014B\u0001!1\u0005\rIe\u000e^\u0001\u000b[N\u0004VM\u001d%pkJ\u0004\u0013\u0001E7j]\u000e{W\u000e]1di&|g\u000eT1h\u0003Ei\u0017N\\\"p[B\f7\r^5p]2\u000bw\rI\u0001\u0005i&lW-F\u0001G!\t!s)\u0003\u0002IK\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\tdY\u0016\fg.\u001a:CC\u000e\\wJ\u001a4NgV\tA\n\u0005\u0002?\u001b&\u0011a\n\r\u0002\u0005\u0019>tw-A\tdY\u0016\fg.\u001a:CC\u000e\\wJ\u001a4Ng\u0002\n1b]3h[\u0016tGoU5{K\u0006a1/Z4nK:$8+\u001b>fA\u0005)1m\u001c3fGV\tA\u000b\u0005\u0002V?6\taK\u0003\u0002X1\u00061!/Z2pe\u0012T!!\u0017.\u0002\r\r|W.\\8o\u0015\ta2L\u0003\u0002];\u00061\u0011\r]1dQ\u0016T\u0011AX\u0001\u0004_J<\u0017B\u00011W\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003\r\u00042A\u00103g\u0013\t)\u0007GA\u0003BeJ\f\u0017\u0010\u0005\u0002hQ6\t\u0001,\u0003\u0002j1\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003-\u0019G.Z1oKJ$Vm\u001d;\u0015\u00035\u0004\"A\u00108\n\u0005=\u0004$\u0001B+oSRD#\u0001E9\u0011\u0005I,X\"A:\u000b\u0005Ql\u0016!\u00026v]&$\u0018B\u0001<t\u0005\u0011!Vm\u001d;\u0002\u0017I,\u0017\r\u001a$s_6dun\u001a\u000b\u0004s\u0006\u0015\u0001c\u0001>~\u007f6\t1P\u0003\u0002}a\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005y\\(\u0001C%uKJ\f'\r\\3\u0011\u000by\n\t!P\u001f\n\u0007\u0005\r\u0001G\u0001\u0004UkBdWM\r\u0005\u00075E\u0001\r!a\u0002\u0011\u0007\u0001\nI!C\u0002\u0002\fe\u00111\u0001T8h\u0003%9(/\u001b;f\tV\u00048\u000f\u0006\u0007\u0002\u0012\u0005]\u00111DA\u0010\u0003C\t\u0019\u0003\u0005\u0003{\u0003'y\u0018bAA\u000bw\n\u00191+Z9\t\r\u0005e!\u00031\u0001>\u0003\u001dqW/\\&fsNDa!!\b\u0013\u0001\u0004i\u0014a\u00028v[\u0012+\bo\u001d\u0005\u00075I\u0001\r!a\u0002\t\u000bI\u0013\u0002\u0019\u0001+\t\r\u0005\u0015\"\u00031\u0001M\u0003%!\u0018.\\3ti\u0006l\u0007\u000fK\u0004\u0001\u0003S\t)$a\u000e\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\ft\u0003\u0019\u0011XO\u001c8fe&!\u00111GA\u0017\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010t\u0003\u001d\u0011XO\u001c8feNLA!a\u0011\u0002>\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012\fA\u0004T8h\u00072,\u0017M\\3s\u0019\u0006<\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f\u0005\u0002!)M\u0019A#a\u0013\u0011\u0007y\ni%C\u0002\u0002PA\u0012a!\u00118z%\u00164GCAA$\u00031yg.\u001a)be\u0006lW\r^3s+\t\t9\u0006\u0005\u0004\u0002Z\u0005\r\u0014qM\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!Q\u000f^5m\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA3\u00037\u0012!bQ8mY\u0016\u001cG/[8o!\rqDMK\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bfA\f\u0002nA!\u0011qNAA\u001d\u0011\t\t(! \u000f\t\u0005M\u00141\u0010\b\u0005\u0003k\nIHD\u0002.\u0003oJ\u0011AX\u0005\u0003ivK1!a\u0010t\u0013\u0011\ty(!\u0010\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\t\u0019)!\"\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0002\u0000\u0005u\u0002")
public class LogCleanerLagIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements Logging {
    private final String compressionCodecName;
    private final int msPerHour;
    private final int minCompactionLag;
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int minCompactionLag() {
        return this.minCompactionLag;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    @Override
    public CompressionType codec() {
        return CompressionType.forName((String)this.compressionCodecName);
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$22 = this.cleanerBackOffMs();
        long x$3 = this.minCompactionLag();
        int x$4 = this.segmentSize();
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        int x$7 = this.makeCleaner$default$5();
        int x$8 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$5, x$6, x$22, x$7, x$3, x$8, x$4, x$9, x$10, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log, this.codec(), T0);
        long startSizeBlock0 = log.size();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("total log size at T0: ").append(startSizeBlock0).toString());
        LogSegment activeSegAtT0 = log.activeSegment();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("active segment at T0 has base offset: ").append(activeSegAtT0.baseOffset()).toString());
        int sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("log size up to base offset of active segment at T0: ").append(sizeUpToActiveSegmentAtT0).toString());
        this.cleaner().startup();
        this.time().sleep(this.minCompactionLag() / 2);
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assert.assertEquals((String)"There should be no cleaning until the compaction lag has passed", (long)startSizeBlock0, (long)log.size());
        this.time().sleep(this.minCompactionLag() / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log, this.codec(), T1), Seq$.MODULE$.canBuildFrom());
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$122 = new TopicPartition("log", 0);
        long x$13 = activeSegAtT0.baseOffset();
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$122, x$13, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends1.toMap(Predef$.MODULE$.$conforms()), (Object)read1.toMap(Predef$.MODULE$.$conforms()));
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("after cleaning the compacted size up to active segment at T0: ").append(compactedSize).toString());
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstBlock1SegmentBaseOffset).append(", but lastCleaned=").append(lastCleaned).toString(), (lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(90).append("log should have been compacted: size up to offset of active segment at T0=").append(sizeUpToActiveSegmentAtT0).append(" compacted size=").append(compactedSize).toString(), (sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            String string = TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int key = new StringOps(string).toInt();
            String string2 = TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int value = new StringOps(string2).toInt();
            Integer n = BoxesRunTime.boxToInteger((int)value);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log, CompressionType codec, long timestamp) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (Seq)RichInt$.MODULE$.until$extension0(n, numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerLagIntegrationTest.$anonfun$writeDups$1(this, numKeys, log, codec, timestamp, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(LogCleanerLagIntegrationTest $this, Log log$1, CompressionType codec$1, long timestamp$1, int key) {
        int count = $this.counter();
        byte[] x$1 = ((Object)BoxesRunTime.boxToInteger((int)$this.counter())).toString().getBytes();
        byte[] x$3 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        $this.incCounter();
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(LogCleanerLagIntegrationTest $this, int numKeys$1, Log log$1, CompressionType codec$1, long timestamp$1, int _) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(n, numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerLagIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, timestamp$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerLagIntegrationTest(String compressionCodecName) {
        this.compressionCodecName = compressionCodecName;
        Logging.$init$((Logging)this);
        this.msPerHour = 3600000;
        this.minCompactionLag = 1 * this.msPerHour();
        Assert.assertTrue((String)"compactionLag must be divisible by 2 for this test", (this.minCompactionLag() % 2 == 0 ? 1 : 0) != 0);
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 512;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

