/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.OngoingReassignmentState;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PartitionStateStore;
import kafka.cluster.Replica;
import kafka.cluster.SimpleAssignmentState;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import unit.kafka.cluster.AbstractPartitionTest;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001B\u001a5\u0001eBQA\u0011\u0001\u0005\u0002\rCQA\u0012\u0001\u0005\u0002\u001dCQa\u0016\u0001\u0005\u0002\u001dCQ!\u0017\u0001\u0005\u0002\u001dCQa\u0017\u0001\u0005\u0002\u001dCQ!\u0018\u0001\u0005\u0002\u001dCQa\u0018\u0001\u0005\u0002\u001dCQ!\u0019\u0001\u0005\u0002\u001dCQa\u0019\u0001\u0005\u0002\u001dCQ!\u001a\u0001\u0005\u0002\u001dCQa\u001a\u0001\u0005\u0002\u001dCQ!\u001b\u0001\u0005\u0002\u001dCQa\u001b\u0001\u0005\u0002\u001dCQ!\u001c\u0001\u0005\u0002\u001dCQa\u001c\u0001\u0005\u0002\u001dCQ!\u001d\u0001\u0005\u0002\u001dCQa\u001d\u0001\u0005\nQD\u0011\"a\u0005\u0001#\u0003%I!!\u0006\t\r\u0005-\u0002\u0001\"\u0001H\u0011\u0019\ty\u0003\u0001C\u0001\u000f\"1\u00111\u0007\u0001\u0005\u0002\u001dCa!a\u000e\u0001\t\u00039\u0005BBA\u001e\u0001\u0011\u0005q\t\u0003\u0004\u0002@\u0001!\ta\u0012\u0005\u0007\u0003\u0007\u0002A\u0011A$\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u00111\u0013\u0005\b\u0003/\u0003A\u0011AAM\u0011\u0019\ty\n\u0001C\u0001\u000f\"1\u00111\u0015\u0001\u0005\u0002\u001dCa!a*\u0001\t\u00039\u0005BBAV\u0001\u0011\u0005q\t\u0003\u0004\u00020\u0002!\ta\u0012\u0005\u0007\u0003g\u0003A\u0011A$\t\r\u0005]\u0006\u0001\"\u0001H\u0011\u0019\tY\f\u0001C\u0001\u000f\"1\u0011q\u0018\u0001\u0005\u0002\u001dCa!a1\u0001\t\u00039\u0005BBAd\u0001\u0011\u0005q\t\u0003\u0004\u0002L\u0002!\ta\u0012\u0005\u0007\u0003\u001f\u0004A\u0011A$\t\r\u0005M\u0007\u0001\"\u0001H\u0011\u0019\t9\u000e\u0001C\u0001\u000f\"9\u00111\u001c\u0001\u0005\n\u0005ugABAt\u0001\u0011\tI\u000f\u0003\u0006\u0002\b5\u0012\t\u0011)A\u0005\u0003\u0013A!\"a;.\u0005\u0003\u0005\u000b\u0011BAw\u0011)\tI0\fB\u0001B\u0003%\u00111 \u0005\u0007\u00056\"\tAa\u0004\t\u000f\tmQ\u0006\"\u0011\u0003\u001e\ti\u0001+\u0019:uSRLwN\u001c+fgRT!!\u000e\u001c\u0002\u000f\rdWo\u001d;fe*\tq'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0004CA\u001eA\u001b\u0005a$BA\u001b>\u0015\t9dHC\u0001@\u0003\u0011)h.\u001b;\n\u0005\u0005c$!F!cgR\u0014\u0018m\u0019;QCJ$\u0018\u000e^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0003\"!\u0012\u0001\u000e\u0003Q\nq\u0004^3ti6\u000b7.\u001a'fC\u0012,'/\u00169eCR,7/\u00129pG\"\u001c\u0015m\u00195f)\u0005A\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%\u0001B+oSRD#AA(\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016!\u00026v]&$(\"\u0001+\u0002\u0007=\u0014x-\u0003\u0002W#\n!A+Z:u\u0003I\"Xm\u001d;NC.,G*Z1eKJ$u.Z:O_R,\u0006\u000fZ1uK\u0016\u0003xn\u00195DC\u000eDWMR8s\u001f2$gi\u001c:nCR\u001c\bFA\u0002P\u0003!\"Xm\u001d;NCf\u0014WMU3qY\u0006\u001cWmQ;se\u0016tGoV5uQ\u001a+H/\u001e:f%\u0016\u0004H.[2bQ\t!q*A\u0017uKN$X*Y6f\r>dGn\\<fe^KG\u000f[,ji\"4u\u000e\u001c7po\u0016\u0014\u0018\t\u001d9f]\u0012\u0014VmY8sIND#!B(\u0002yQ,7\u000f^'bs\n,'+\u001a9mC\u000e,7)\u001e:sK:$x+\u001b;i\rV$XO]3SKBd\u0017nY1ES\u001a4WM]3oi\n\u000b7/Z(gMN,Go\u001d\u0015\u0003\r=\u000bq\u0006^3ti\u001a+Go\u00195PM\u001a\u001cX\r^*oCB\u001c\bn\u001c;Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014H*Z1eKJD#aB(\u0002cQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001cf.\u00199tQ>$X\t]8dQZ\u000bG.\u001b3bi&|gNR8s\r>dGn\\<fe\"\u0012\u0001bT\u0001,i\u0016\u001cHo\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\u0012\u0011bT\u0001.i\u0016\u001cHo\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\bF\u0001\u0006P\u0003\u0019\"Xm\u001d;SK\u0006$'+Z2pe\u0012,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0003\u0017=\u000b\u0001\u0006^3tiJ+\u0017\r\u001a*fG>\u0014H-\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe\u001a{G\u000e\\8xKJD#\u0001D(\u0002gQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR4uN\u001d+j[\u0016\u001cH/Y7q\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'\u000fT3bI\u0016\u0014\bFA\u0007P\u0003U\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$hi\u001c:US6,7\u000f^1na\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d$pY2|w/\u001a:)\u00059y\u0015\u0001\u000b;fgR4U\r^2i\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r^%oG2,H-Z:MK\u0006$WM]#q_\u000eD\u0007FA\bP\u0003\u0015\"Xm\u001d;N_:|Go\u001c8jG>3gm]3ug\u00063G/\u001a:MK\u0006$WM]\"iC:<W\r\u000b\u0002\u0011\u001f\u000692/\u001a;vaB\u000b'\u000f^5uS>tw+\u001b;i\u001b>\u001c7n\u001d\u000b\u0006kbl\u0018Q\u0001\t\u0003\u000bZL!a\u001e\u001b\u0003\u0013A\u000b'\u000f^5uS>t\u0007\"B=\u0012\u0001\u0004Q\u0018a\u00037fC\u0012,'/\u00129pG\"\u0004\"!S>\n\u0005qT%aA%oi\")a0\u0005a\u0001\u007f\u0006A\u0011n\u001d'fC\u0012,'\u000fE\u0002J\u0003\u0003I1!a\u0001K\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0002\u0012!\u0003\u0005\r!!\u0003\u0002\u00071|w\r\u0005\u0003\u0002\f\u0005=QBAA\u0007\u0015\r\t9AN\u0005\u0005\u0003#\tiAA\u0002M_\u001e\f\u0011e]3ukB\u0004\u0016M\u001d;ji&|gnV5uQ6{7m[:%I\u00164\u0017-\u001e7uIM*\"!a\u0006+\t\u0005%\u0011\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0005&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0005}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qC/Z:u\u0003B\u0004XM\u001c3SK\u000e|'\u000fZ:Bg\u001a{G\u000e\\8xKJ\u0014U\r\\8x\u0019><7\u000b^1si>3gm]3uQ\t\u0019r*A\u000fuKN$H*[:u\u001f\u001a47/\u001a;Jg>d\u0017\r^5p]2+g/\u001a7tQ\t!r*\u0001\buKN$x)\u001a;SKBd\u0017nY1)\u0005Uy\u0015a\u000e;fgR\f\u0005\u000f]3oIJ+7m\u001c:egR{gi\u001c7m_^,'oV5uQ:{'+\u001a9mS\u000e\fG\u000b\u001b:poN,\u0005pY3qi&|g\u000e\u000b\u0002\u0017\u001f\u0006!C/Z:u\u001b\u0006\\WMR8mY><XM],ji\"tu\u000eT3bI\u0016\u0014\u0018\nZ\"iC:<W\r\u000b\u0002\u0018\u001f\u00069E/Z:u\r>dGn\\<fe\u0012{Wm\u001d(pi*{\u0017N\\%T%VsG/\u001b7DCV<\u0007\u000e^+q)>|eMZ:fi^KG\u000f[5o\u0007V\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u000b\u0002\u0019\u001f\u0006\u0011C/Z:u\t\u0016d\u0017-_3e\r\u0016$8\r[!gi\u0016\u0014\u0018\t\u001d9f]\u0012\u0014VmY8sIND#!G(\u0002\u001b\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3t)!\tY%!\u0019\u0002\u0004\u00065\u0005\u0003BA'\u0003;j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0007e\u0016\u001cwN\u001d3\u000b\t\u0005U\u0013qK\u0001\u0007G>lWn\u001c8\u000b\u0007]\nIFC\u0002\u0002\\M\u000ba!\u00199bG\",\u0017\u0002BA0\u0003\u001f\u0012Q\"T3n_JL(+Z2pe\u0012\u001c\bbBA25\u0001\u0007\u0011QM\u0001\be\u0016\u001cwN\u001d3t!\u0019\t9'a\u001e\u0002~9!\u0011\u0011NA:\u001d\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8q\u00051AH]8pizJ\u0011aS\u0005\u0004\u0003kR\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003s\nYH\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t)H\u0013\t\u0005\u0003\u001b\ny(\u0003\u0003\u0002\u0002\u0006=#\u0001D*j[BdWMU3d_J$\u0007bBAC5\u0001\u0007\u0011qQ\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bcA%\u0002\n&\u0019\u00111\u0012&\u0003\t1{gn\u001a\u0005\t\u0003\u001fS\u0002\u0013!a\u0001u\u0006!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"\fqc\u0019:fCR,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U%f\u0001>\u0002\u001a\u0005Q2M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYJ+7m\u001c:egR1\u00111JAN\u0003;Cq!a\u0019\u001d\u0001\u0004\t)\u0007C\u0004\u0002\u0006r\u0001\r!a\"\u0002\u0019Q,7\u000f^!u\u001b&t\u0017j\u001d:)\u0005uy\u0015\u0001\b;fgR,\u0006\u000fZ1uK\u001a{G\u000e\\8xKJ4U\r^2i'R\fG/\u001a\u0015\u0003==\u000b\u0001\u0003^3ti&\u001b(/\u0012=qC:\u001c\u0018n\u001c8)\u0005}y\u0015a\b;fgRL5O\u001d(pi\u0016C\b/\u00198eK\u0012Le-\u00169eCR,g)Y5mg\"\u0012\u0001eT\u0001\u0013i\u0016\u001cH/T1zE\u0016\u001c\u0006N]5oW&\u001b(\u000f\u000b\u0002\"\u001f\u0006yC/Z:u'\"|W\u000f\u001c3O_R\u001c\u0006N]5oW&\u001b(/\u00134Qe\u00164\u0018n\\;t\r\u0016$8\r[%t\u0007\u0006,x\r\u001b;Va\"\u0012!eT\u00011i\u0016\u001cHo\u00155pk2$gj\u001c;TQJLgn[%te&3gi\u001c7m_^,'oQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\u0005\rz\u0015!\b;fgRL5O\u001d(piNC'/\u001e8l\u0013\u001a,\u0006\u000fZ1uK\u001a\u000b\u0017\u000e\\:)\u0005\u0011z\u0015A\u000b;fgR,6/Z\"iK\u000e\\\u0007o\\5oiR{\u0017J\\5uS\u0006d\u0017N_3IS\u001eDw+\u0019;fe6\f'o\u001b\u0015\u0003K=\u000bq\u0003^3ti\u0006#G-\u00118e%\u0016lwN^3NKR\u0014\u0018nY:)\u0005\u0019z\u0015!\f;fgR,f\u000eZ3s%\u0016\u0004H.[2bi\u0016$\u0007+\u0019:uSRLwN\\:D_J\u0014Xm\u0019;TK6\fg\u000e^5dg\"\u0012qeT\u0001\u001bi\u0016\u001cH/\u00169eCR,\u0017i]:jO:lWM\u001c;B]\u0012L5O\u001d\u0015\u0003Q=\u000bQ\u0003^3ti2{wmQ8oM&<gj\u001c;ESJ$\u0018\u0010\u000b\u0002*\u001f\u0006\u0001C/Z:u\u0019><7i\u001c8gS\u001e$\u0015N\u001d;z\u0003N$v\u000e]5d+B$\u0017\r^3eQ\tQs*A\u0011uKN$Hj\\4D_:4\u0017n\u001a#jeRL\u0018i\u001d\"s_.,'/\u00169eCR,G\r\u000b\u0002,\u001f\u0006Y1/Z3e\u0019><G)\u0019;b)\u001dA\u0015q\\Aq\u0003KDq!a\u0002-\u0001\u0004\tI\u0001\u0003\u0004\u0002d2\u0002\rA_\u0001\u000b]Vl'+Z2pe\u0012\u001c\b\"B=-\u0001\u0004Q(aB*m_^dunZ\n\u0004[\u0005%\u0011\u0001C7pG.$\u0016.\\3\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cT1!a=7\u0003\u0015)H/\u001b7t\u0013\u0011\t90!=\u0003\u00115{7m\u001b+j[\u0016\fq\"\u00199qK:$7+Z7ba\"|'/\u001a\t\u0005\u0003{\u0014Y!\u0004\u0002\u0002\u0000*!!\u0011\u0001B\u0002\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005\u000b\u00119!\u0001\u0003vi&d'B\u0001B\u0005\u0003\u0011Q\u0017M^1\n\t\t5\u0011q \u0002\n'\u0016l\u0017\r\u001d5pe\u0016$\u0002B!\u0005\u0003\u0016\t]!\u0011\u0004\t\u0004\u0005'iS\"\u0001\u0001\t\u000f\u0005\u001d\u0011\u00071\u0001\u0002\n!9\u00111^\u0019A\u0002\u00055\bbBA}c\u0001\u0007\u00111`\u0001\u0011CB\u0004XM\u001c3Bg\u001a{G\u000e\\8xKJ$BAa\b\u0003&A!\u00111\u0002B\u0011\u0013\u0011\u0011\u0019#!\u0004\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t\u0019G\ra\u0001\u0003\u0017\u0002")
public class PartitionTest
extends AbstractPartitionTest {
    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Option option = partition.leaderLogIfLocal();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((Log)map_this.get()).logEndOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)object);
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        int leaderEpoch = 8;
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = KAFKA_0_10_2_IV0$.MODULE$.shortVersion();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> logConfig;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Option option = partition.leaderLogIfLocal();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((Log)map_this.get()).logEndOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)object2);
        Assert.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Thread thread1 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                Partition qual$1 = this.$outer.partition();
                boolean x$1 = qual$1.removeFutureLocalReplica$default$1();
                qual$1.removeFutureLocalReplica(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread thread2 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                this.$outer.partition().maybeReplaceCurrentWithFutureReplica();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().futureLog());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeFollowerWithWithFollowerAppendRecords() {
        Semaphore appendSemaphore = new Semaphore(0);
        MockTime mockTime = new MockTime();
        this.partition_$eq(new Partition(this, mockTime, appendSemaphore){
            private final /* synthetic */ PartitionTest $outer;
            private final MockTime mockTime$1;
            private final Semaphore appendSemaphore$1;

            public Log createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints) {
                Log log = super.createLog(isNew, isFutureReplica, offsetCheckpoints);
                return new SlowLog(this.$outer, log, this.mockTime$1, this.appendSemaphore$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mockTime$1 = mockTime$1;
                this.appendSemaphore$1 = appendSemaphore$1;
                super($outer.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), $outer.brokerId(), (Time)$outer.time(), $outer.stateStore(), $outer.delayedOperations(), $outer.metadataCache(), $outer.logManager());
            }
        });
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        Thread appendThread = new Thread(this){
            private final /* synthetic */ PartitionTest $outer;

            public void run() {
                MemoryRecords records = this.$outer.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 0L, this.$outer.createRecords$default$3());
                this.$outer.partition().appendRecordsToFollowerOrFutureReplica(records, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        appendThread.start();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!appendSemaphore.hasQueuedThreads()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PartitionTest.$anonfun$testMakeFollowerWithWithFollowerAppendRecords$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        Assert.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
        appendSemaphore.release();
        appendThread.join();
        Assert.assertEquals((long)2L, (long)this.partition().localLogOrException().logEndOffset());
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)this.partition().leaderReplicaIdOpt().get()));
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Log currentLog = (Log)this.partition().log().get();
        currentLog.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())}), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        currentLog.roll(currentLog.roll$default$1());
        currentLog.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())}), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (int)0);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        this.partition().futureLocalLogOrException().appendAsFollower(builder.build());
        Assert.assertTrue((boolean)this.partition().maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Option timestampAndOffsetOpt = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3()).fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assert.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)timestampAndOffset.leaderEpoch);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block67: {
            block69: {
                block68: {
                    block66: {
                        block63: {
                            block65: {
                                block64: {
                                    block62: {
                                        controllerEpoch = 3;
                                        leader = this.brokerId();
                                        follower1 = this.brokerId() + 1;
                                        follower2 = this.brokerId() + 2;
                                        replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2}));
                                        isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
                                        leaderEpoch = 8;
                                        batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        v0 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
                                        var68_10 = List$.MODULE$.canBuildFrom();
                                        var67_11 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)();
                                        if (replicas == null) {
                                            throw null;
                                        }
                                        if (map_bf == List$.MODULE$.ReusableCBF()) {
                                            if (replicas == Nil$.MODULE$) {
                                                var73_12 /* !! */  = Nil$.MODULE$;
                                            } else {
                                                map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                                for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                    map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                    map_t.tl_$eq((List)map_nx);
                                                    map_t = map_nx;
                                                }
                                                var73_12 /* !! */  = map_h;
                                            }
                                        } else {
                                            var73_12 /* !! */  = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
                                        }
                                        leaderState = v0.setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)var73_12 /* !! */ ).asJava()).setIsNew(true);
                                        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints()));
                                        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)this.partition().getLeaderEpoch());
                                        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
                                        this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                        Assert.assertEquals((String)"Expected leader's HW not move", (long)this.partition().localLogOrException().logStartOffset(), (long)this.partition().localLogOrException().highWatermark());
                                        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader, leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower2, follower1})), 1))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        Assert.assertEquals((long)2L, (long)this.partition().localLogOrException().highWatermark());
                                        var11_18 = false;
                                        var12_19 = null;
                                        var13_20 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                        if (!(var13_20 instanceof Right)) ** GOTO lbl-1000
                                        var11_18 = true;
                                        var12_19 = (Right)var13_20;
                                        var14_21 = (Option)var12_19.value();
                                        if (var14_21 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var14_21).value();
                                            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                        } else if (var11_18 && None$.MODULE$.equals(var16_23 = (Option)var12_19.value())) {
                                            Assert.fail((String)"Should have seen some offsets");
                                        } else if (var13_20 instanceof Left) {
                                            Assert.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var13_20);
                                        }
                                        var17_24 = false;
                                        var18_25 = null;
                                        var19_26 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var19_26 instanceof Right)) ** GOTO lbl-1000
                                        var17_24 = true;
                                        var18_25 = (Right)var19_26;
                                        var20_27 = (Option)var18_25.value();
                                        if (var20_27 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var20_27).value();
                                            Assert.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                        } else if (var17_24 && None$.MODULE$.equals(var22_29 = (Option)var18_25.value())) {
                                            Assert.fail((String)"Should have seen some offsets");
                                        } else if (var19_26 instanceof Left) {
                                            Assert.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var19_26);
                                        }
                                        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                        v1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(4);
                                        var75_30 = List$.MODULE$.canBuildFrom();
                                        map_f = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)();
                                        if (map_bf == List$.MODULE$.ReusableCBF()) {
                                            if (replicas == Nil$.MODULE$) {
                                                var80_32 /* !! */  = Nil$.MODULE$;
                                            } else {
                                                map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                                for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                    map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                    map_t.tl_$eq((List)map_nx);
                                                    map_t = map_nx;
                                                }
                                                var80_32 /* !! */  = map_h;
                                            }
                                        } else {
                                            var80_32 /* !! */  = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
                                        }
                                        followerState = v1.setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)var80_32 /* !! */ ).asJava()).setIsNew(false);
                                        Assert.assertTrue((boolean)this.partition().makeFollower(followerState, this.offsetCheckpoints()));
                                        v2 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(5);
                                        var82_38 = List$.MODULE$.canBuildFrom();
                                        map_f = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)();
                                        if (map_bf == List$.MODULE$.ReusableCBF()) {
                                            if (replicas == Nil$.MODULE$) {
                                                var87_40 /* !! */  = Nil$.MODULE$;
                                            } else {
                                                map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                                for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                    map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                    map_t.tl_$eq((List)map_nx);
                                                    map_t = map_nx;
                                                }
                                                var87_40 /* !! */  = map_h;
                                            }
                                        } else {
                                            var87_40 /* !! */  = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
                                        }
                                        newLeaderState = v2.setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)var87_40 /* !! */ ).asJava()).setIsNew(false);
                                        Assert.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints()));
                                        var25_46 = false;
                                        var26_47 = null;
                                        var27_48 = false;
                                        var28_49 = null;
                                        var29_50 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var29_50 instanceof Right)) break block62;
                                        var25_46 = true;
                                        var26_47 = (Right)var29_50;
                                        if (!((Option)var26_47.value() instanceof Some)) break block62;
                                        Assert.fail((String)"Should have failed with OffsetNotAvailable");
                                        break block63;
                                    }
                                    if (!var25_46 || !None$.MODULE$.equals(var30_51 = (Option)var26_47.value())) break block64;
                                    Assert.fail((String)"Should have seen an error");
                                    break block63;
                                }
                                if (!(var29_50 instanceof Left)) break block65;
                                var27_48 = true;
                                var28_49 = (Left)var29_50;
                                if ((ApiException)var28_49.value() instanceof OffsetNotAvailableException) break block63;
                            }
                            if (var27_48 && (e = (ApiException)var28_49.value()) != null) {
                                Assert.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(e).toString());
                            } else {
                                throw new MatchError((Object)var29_50);
                            }
                        }
                        var32_53 = false;
                        var33_54 = null;
                        var34_55 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                        if (!(var34_55 instanceof Right)) ** GOTO lbl-1000
                        var32_53 = true;
                        var33_54 = (Right)var34_55;
                        var35_56 = (Option)var33_54.value();
                        if (var35_56 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var35_56).value();
                            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        } else if (var32_53 && None$.MODULE$.equals(var37_58 = (Option)var33_54.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var34_55 instanceof Left && (e = (ApiException)((Left)var34_55).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var34_55);
                        }
                        var39_60 = false;
                        var40_61 = null;
                        var41_62 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var41_62 instanceof Right)) ** GOTO lbl-1000
                        var39_60 = true;
                        var40_61 = (Right)var41_62;
                        var42_63 = (Option)var40_61.value();
                        if (var42_63 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var42_63).value();
                            Assert.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        } else if (var39_60 && None$.MODULE$.equals(var44_65 = (Option)var40_61.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var41_62 instanceof Left && (e = (ApiException)((Left)var41_62).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var41_62);
                        }
                        var46_67 = false;
                        var47_68 = null;
                        var48_69 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var48_69 instanceof Right)) ** GOTO lbl-1000
                        var46_67 = true;
                        var47_68 = (Right)var48_69;
                        var49_70 = (Option)var47_68.value();
                        if (var49_70 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var49_70).value();
                            Assert.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                            Assert.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        } else if (var46_67 && None$.MODULE$.equals(var51_72 = (Option)var47_68.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var48_69 instanceof Left && (e = (ApiException)((Left)var48_69).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var48_69);
                        }
                        var53_74 = false;
                        var54_75 = null;
                        var55_76 = false;
                        var56_77 = null;
                        var57_78 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var57_78 instanceof Right)) break block66;
                        var53_74 = true;
                        var54_75 = (Right)var57_78;
                        if (!((Option)var54_75.value() instanceof Some)) break block66;
                        Assert.fail((String)"Should have failed");
                        break block67;
                    }
                    if (!var53_74 || !None$.MODULE$.equals(var58_79 = (Option)var54_75.value())) break block68;
                    Assert.fail((String)"Should have failed");
                    break block67;
                }
                if (!(var57_78 instanceof Left)) break block69;
                var55_76 = true;
                var56_77 = (Left)var57_78;
                if ((ApiException)var56_77.value() instanceof OffsetNotAvailableException) break block67;
            }
            if (var55_76 && (e = (ApiException)var56_77.value()) != null) {
                Assert.fail((String)new StringBuilder(50).append("Should have seen OffsetNotAvailableException, saw ").append(e).toString());
            } else {
                throw new MatchError((Object)var57_78);
            }
        }
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader, leaderEpoch + 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower2, follower1})), 5))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        var60_81 = false;
        var61_82 = null;
        var62_83 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
        if (!(var62_83 instanceof Right)) ** GOTO lbl-1000
        var60_81 = true;
        var61_82 = (Right)var62_83;
        var63_84 = (Option)var61_82.value();
        if (var63_84 instanceof Some) {
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var63_84).value();
            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
        } else if (var60_81 && None$.MODULE$.equals(var65_86 = (Option)var61_82.value())) {
            Assert.fail((String)"Should have seen some offsets");
        } else if (var62_83 instanceof Left && (e = (ApiException)((Left)var62_83).value()) != null) {
            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
        } else {
            throw new MatchError((Object)var62_83);
        }
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
            Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        } else {
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId() + 1).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
            Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        return qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Log log = this.partition().localLogOrException();
        long initialLogStartOffset = 5L;
        this.partition().truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)log.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 3L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)initialLogStartOffset, (long)log.logEndOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), newLogStartOffset, this.createRecords$default$3());
        this.partition().appendRecordsToFollowerOrFutureReplica(records, false);
        Assert.assertEquals((String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)7L, (long)log.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)newLogStartOffset, (long)log.logStartOffset());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 7:", (long)8L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)log.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 3L, this.createRecords$default$3());
            return this.partition().appendRecordsToFollowerOrFutureReplica(records2, false);
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)8L, (long)log.logEndOffset());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 8:", (long)9L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)log.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), 0L);
        this.partition().appendRecordsToLeader(records, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        ((Log)this.partition().log().get()).updateHighWatermark(1L);
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
    }

    @Test
    public void testGetReplica() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().log());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.partition().localLogOrException(), ClassTag$.MODULE$.apply(NotLeaderOrFollowerException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 0L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(NotLeaderOrFollowerException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        this.partition().makeFollower(partitionState, this.offsetCheckpoints());
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        Assert.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava());
        Assert.assertFalse((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints()));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
        long lastOffsetOfFirstBatch = this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0).lastOffset();
        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        Assert.assertEquals((String)"Expected leader's HW not move", (long)this.partition().localLogOrException().logStartOffset(), (long)((Log)this.partition().log().get()).highWatermark());
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)((Log)this.partition().log().get()).highWatermark());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(followerState, this.offsetCheckpoints());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints()));
        long currentLeaderEpochStartOffset = this.partition().localLogOrException().logEndOffset();
        this.partition().appendRecordsToLeader(batch3, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader, leaderEpoch + 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower2, follower1})), 1))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFetchAfterAppendRecords() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicaIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, 5).map((Function1 & Serializable & scala.Serializable)i -> PartitionTest.$anonfun$testDelayedFetchAfterAppendRecords$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq logs = (IndexedSeq)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
            LogManager qual$1 = this.logManager();
            Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> logConfig;
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            return qual$1.getOrCreateLog(tp, (Function0)x$2, x$3, x$4);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ListBuffer partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            TopicPartition tp = log.topicPartition();
            DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
            Partition partition = new Partition(tp, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), delayedOperations, this.metadataCache(), this.logManager());
            delayedOperations.checkAndCompleteFetch();
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
                int anotherPartition = (tp.partition() + 1) % topicPartitions.size();
                return ((Partition)partitions.apply(anotherPartition)).fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true);
            });
            partition.setLog(log, false);
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicaIds).setZkVersion(1).setReplicas(replicaIds).setIsNew(true);
            partition.makeLeader(leaderState, this.offsetCheckpoints());
            return partitions.$plus$eq((Object)partition);
        });
        AtomicBoolean done = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(topicPartitions.size() + 1);
        try {
            try {
                void foreach_f;
                void map_bf;
                void map_f;
                executor.submit(() -> {
                    while (!done.get()) {
                        void foreach_f;
                        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$3 -> {
                            x$3.maybeShrinkIsr();
                            return BoxedUnit.UNIT;
                        };
                        if (partitions == null) {
                            throw null;
                        }
                        partitions.underlying().foreach((Function1)foreach_f);
                    }
                });
                CanBuildFrom canBuildFrom = ListBuffer$.MODULE$.canBuildFrom();
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)partition -> executor.submit(() -> {
                    int n = 1;
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 10000);
                    if (inclusive == null) {
                        throw null;
                    }
                    Range.Inclusive foreach_this = inclusive;
                    if (!foreach_this.isEmpty()) {
                        int foreach_i = foreach_this.start();
                        while (true) {
                            partition.appendRecordsToLeader(this.createRecords$1(0L), (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                            if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                            foreach_i += foreach_this.step();
                        }
                    }
                });
                if (partitions == null) {
                    throw null;
                }
                ListBuffer futures = (ListBuffer)TraversableLike.map$((TraversableLike)partitions, (Function1)map_f, (CanBuildFrom)map_bf);
                Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS);
                if (futures == null) {
                    throw null;
                }
                futures.underlying().foreach((Function1)foreach_f);
                done.set(true);
            }
            catch (TimeoutException e) {
                String allThreads = TestUtils$.MODULE$.allThreadStackTraces();
                Assert.fail((String)new StringBuilder(53).append("Test timed out with exception ").append(e).append(", thread stack traces: ").append(allThreads).toString());
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(records).asJava()))), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(records).asJava()))), (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)Nil$.MODULE$)).asJava();
        int leaderEpoch = 8;
        Assert.assertFalse((boolean)this.partition().isAtMinIsr());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertTrue((boolean)this.partition().isAtMinIsr());
    }

    @Test
    public void testUpdateFollowerFetchState() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 6, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        long initializeTimeMs = this.time().milliseconds();
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L);
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(6L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L);
        Assert.assertEquals((long)this.time().milliseconds(), (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)6L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrExpansion() {
        Object object;
        void map_bf;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testIsrExpansion$2(BoxesRunTime.unboxToInt((Object)x));
        if (replicas == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (replicas == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testIsrExpansion$2(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testIsrExpansion$2(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(leaderAndIsrPartitionState.setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setIsNew(true), this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), 1);
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testIsrNotExpandedIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), 1);
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)None$.MODULE$);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeShrinkIsr() {
        Object object;
        void map_bf;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testMaybeShrinkIsr$2(BoxesRunTime.unboxToInt((Object)x));
        if (replicas == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (replicas == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testMaybeShrinkIsr$2(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testMaybeShrinkIsr$2(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(leaderAndIsrPartitionState.setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setIsNew(true), this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), 1);
        Mockito.when((Object)this.stateStore().shrinkIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp() {
        Object object;
        void map_bf;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$2(BoxesRunTime.unboxToInt((Object)x));
        if (replicas == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (replicas == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$2(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$2(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(leaderAndIsrPartitionState.setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setIsNew(true), this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(5000L);
        long firstFetchTimeMs = this.time().milliseconds();
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, firstFetchTimeMs, 10L);
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)5L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)5L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(5001L);
        this.seedLogData(log, 5, leaderEpoch);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 15L);
        Assert.assertEquals((long)firstFetchTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd() {
        Object object;
        void map_bf;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$2(BoxesRunTime.unboxToInt((Object)x));
        if (replicas == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (replicas == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$2(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$2(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(leaderAndIsrPartitionState.setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setIsNew(true), this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L);
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(10001L);
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
    }

    @Test
    public void testIsrNotShrunkIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(10001L);
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), 1);
        Mockito.when((Object)this.stateStore().shrinkIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)None$.MODULE$);
        this.partition().maybeShrinkIsr();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testUseCheckpointToInitializeHighWatermark() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        this.seedLogData(log, 6, 5);
        Mockito.when((Object)this.offsetCheckpoints().fetch(this.logDir1().getAbsolutePath(), this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)4L)));
        int controllerEpoch = 3;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertEquals((long)4L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAddAndRemoveMetrics() {
        boolean bl;
        block2: {
            .colon.colon forall_these = new .colon.colon((Object)"UnderReplicated", (List)new .colon.colon((Object)"UnderMinIsr", (List)new .colon.colon((Object)"InSyncReplicasCount", (List)new .colon.colon((Object)"ReplicasCount", (List)new .colon.colon((Object)"LastStableOffsetLag", (List)new .colon.colon((Object)"AtMinIsr", (List)Nil$.MODULE$))))));
            while (!forall_these.isEmpty()) {
                if (!PartitionTest.$anonfun$testAddAndRemoveMetrics$3((String)forall_these.head())) {
                    bl = false;
                    break block2;
                }
                forall_these = (LinearSeqOptimized)forall_these.tail();
            }
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        Partition$.MODULE$.removeMetrics(this.topicPartition());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$4(x$8))));
    }

    @Test
    public void testUnderReplicatedPartitionsCorrectSemantics() {
        int controllerEpoch = 3;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertTrue((boolean)this.partition().isUnderReplicated());
        leaderState = leaderState.setIsr(replicas);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    @Test
    public void testUpdateAssignmentAndIsr() {
        TopicPartition topicPartition = new TopicPartition("test", 1);
        Partition partition = new Partition(topicPartition, 1000L, ApiVersion$.MODULE$.latestVersion(), 0, (Time)new SystemTime(), (PartitionStateStore)Mockito.mock(PartitionStateStore.class), (DelayedOperations)Mockito.mock(DelayedOperations.class), (MetadataCache)Mockito.mock(MetadataCache.class), (LogManager)Mockito.mock(LogManager.class));
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        Set isr = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        Seq adding = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}));
        Seq removing = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        partition.updateAssignmentAndIsr(replicas, isr, adding, removing);
        Assert.assertTrue((String)"The assignmentState is not OngoingReassignmentState", (boolean)(partition.assignmentState() instanceof OngoingReassignmentState));
        Assert.assertEquals((Object)replicas, (Object)partition.assignmentState().replicas());
        Assert.assertEquals((Object)isr, (Object)partition.inSyncReplicaIds());
        Assert.assertEquals((Object)adding, (Object)((OngoingReassignmentState)partition.assignmentState()).addingReplicas());
        Assert.assertEquals((Object)removing, (Object)((OngoingReassignmentState)partition.assignmentState()).removingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition.remoteReplicas().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()), Iterable$.MODULE$.canBuildFrom()));
        Seq replicas2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        Set isr2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        partition.updateAssignmentAndIsr(replicas2, isr2, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        Assert.assertTrue((String)"The assignmentState is not SimpleAssignmentState", (boolean)(partition.assignmentState() instanceof SimpleAssignmentState));
        Assert.assertEquals((Object)replicas2, (Object)partition.assignmentState().replicas());
        Assert.assertEquals((Object)isr2, (Object)partition.inSyncReplicaIds());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Object)partition.remoteReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Iterable$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testLogConfigNotDirty() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore())).fetchTopicConfig();
    }

    @Test
    public void testLogConfigDirtyAsTopicUpdated() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(invocation -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsTopicUpdated$1(this, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore(), (VerificationMode)Mockito.times((int)2))).fetchTopicConfig();
    }

    @Test
    public void testLogConfigDirtyAsBrokerUpdated() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(invocation -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsBrokerUpdated$1(this, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore(), (VerificationMode)Mockito.times((int)2))).fetchTopicConfig();
    }

    private void seedLogData(Log log, int numRecords, int leaderEpoch) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                PartitionTest.$anonfun$seedLogData$1(leaderEpoch, log, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    public static final /* synthetic */ String $anonfun$testMakeFollowerWithWithFollowerAppendRecords$2() {
        return "follower log append is not called.";
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$1) {
        try {
            partition$1.fetchOffsetSnapshot(currentLeaderEpoch, true);
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$2) {
        try {
            partition$2.fetchOffsetSnapshot(currentLeaderEpoch, fetchOnlyLeader);
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$3) {
        EpochEndOffset endOffset = partition$3.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$5) {
        try {
            partition$5.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$6) {
        try {
            partition$6.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$7) {
        try {
            partition$7.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final void updateFollowerFetchState$1(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation) {
        try {
            return package$.MODULE$.Right().apply((Object)this.partition().fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(this.partition().getLeaderEpoch())), true));
        }
        catch (ApiException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final void updateFollowerFetchState$2(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    public static final /* synthetic */ TopicPartition $anonfun$testDelayedFetchAfterAppendRecords$1(int i) {
        return new TopicPartition("test-topic", i);
    }

    private final MemoryRecords createRecords$1(long baseOffset) {
        .colon.colon records = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)records).asJava()))), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)0);
        .colon.colon foreach_these = records;
        while (!foreach_these.isEmpty()) {
            SimpleRecord simpleRecord = (SimpleRecord)foreach_these.head();
            builder.append(simpleRecord);
            foreach_these = (List)foreach_these.tail();
        }
        return builder.build();
    }

    public static final /* synthetic */ Integer $anonfun$testIsrExpansion$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMaybeShrinkIsr$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$1(String metric$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.getName();
        if (string == null) {
            if (metric$1 != null) {
                return false;
            }
        } else if (!string.equals(metric$1)) return false;
        String string2 = metricName.getType();
        String string3 = "Partition";
        if (string2 == null) return false;
        if (!string2.equals(string3)) return false;
        return true;
    }

    public static final /* synthetic */ Metric $anonfun$testAddAndRemoveMetrics$2(Tuple2 x$6) {
        return (Metric)x$6._2();
    }

    private static final Option getMetric$1(String metric) {
        Option option = ((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$1(metric, x0$1)))).headOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)PartitionTest.$anonfun$testAddAndRemoveMetrics$2((Tuple2)map_this.get()));
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$3(String x$7) {
        return PartitionTest.getMetric$1(x$7).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$4(MetricName x$8) {
        String string = x$8.getType();
        String string2 = "Partition";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsTopicUpdated$1(PartitionTest $this, InvocationOnMock invocation) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().topicConfigUpdated($this.topicPartition().topic());
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsBrokerUpdated$1(PartitionTest $this, InvocationOnMock invocation) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().brokerConfigUpdated();
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1(int leaderEpoch$2, Log log$1, int i) {
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch$2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(1).append("k").append(i).toString().getBytes(), new StringBuilder(1).append("v").append(i).toString().getBytes())});
        return log$1.appendAsLeader(records, leaderEpoch$2, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
    }

    public static final /* synthetic */ Object $anonfun$testMakeLeaderUpdatesEpochCache$2$adapted(Log x$1) {
        return BoxesRunTime.boxToLong((long)x$1.logEndOffset());
    }

    public static final /* synthetic */ Object $anonfun$testMakeLeaderDoesNotUpdateEpochCacheForOldFormats$2$adapted(Log x$2) {
        return BoxesRunTime.boxToLong((long)x$2.logEndOffset());
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Object $anonfun$testAddAndRemoveMetrics$3$adapted(String x$7) {
        return BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$3(x$7));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1$adapted(int leaderEpoch$2, Log log$1, Object i) {
        return PartitionTest.$anonfun$seedLogData$1(leaderEpoch$2, log$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testDelayedFetchAfterAppendRecords$11$adapted(PartitionTest $this, Partition partition$9, Object x$4) {
        return partition$9.appendRecordsToLeader($this.createRecords$1(0L), (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
    }

    public class SlowLog
    extends Log {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionTest $outer;

        public LogAppendInfo appendAsFollower(MemoryRecords records) {
            this.appendSemaphore.acquire();
            return super.appendAsFollower(records);
        }

        public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionTest $outer, Log log, MockTime mockTime, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(log.dir(), log.config(), log.logStartOffset(), log.recoveryPoint(), (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), log.time(), log.maxProducerIdExpirationMs(), log.producerIdExpirationCheckIntervalMs(), log.topicPartition(), log.producerStateManager(), new LogDirFailureChannel(1));
        }
    }
}

