/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001\u0002\u0013&\u0001)B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\u0001\u0002!\t!\u0011\u0005\ba\u0002\t\n\u0011\"\u0001r\u0011\u001da\b!%A\u0005\u0002uD\u0001b \u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011!\tI\u0003AI\u0001\n\u0003i\b\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gA\u0011\"a\u0015\u0001#\u0003%\t!!\u0001\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004\"CA8\u0001E\u0005I\u0011BA\u0001\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!a\u001e\u0001\t\u0003\tI\bC\u0005\u0002$\u0002\t\n\u0011\"\u0001\u0002&\"I\u0011\u0011\u0016\u0001\u0012\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003_\u0003\u0011\u0013!C\u0001\u0003\u0003Aq!!-\u0001\t\u0013\t\u0019\fC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAu\u0001\u0011\u0005\u00111\u001e\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\tY\u0010\u0001C\u0001\u0003{DqAa\u0001\u0001\t\u0003\u0011)\u0001C\u0004\u0003\u0004\u0001!\tA!\u0004\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0014\u0001\u0011\u0005!\u0011\u0006\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oAqAa\u000f\u0001\t\u0003\u0011i\u0004C\u0004\u0002\b\u0002!\tA!\u0012\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0015\t1s%\u0001\u0002{W*\t\u0001&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Y\u0013\u0007\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VM\u001a\t\u0003eUj\u0011a\r\u0006\u0003i\u001d\nQ!\u001e;jYNL!AN\u001a\u0003\u000f1{wmZ5oO\u0006A!p[\"mS\u0016tG\u000f\u0005\u0002:u5\tQ%\u0003\u0002<K\ti1*\u00194lCj[7\t\\5f]R\fa\u0001P5oSRtDC\u0001 @!\tI\u0004\u0001C\u00038\u0005\u0001\u0007\u0001(A\u0006de\u0016\fG/\u001a+pa&\u001cGc\u0002\"F%^K6m\u001b\t\u0003Y\rK!\u0001R\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006\r\u000e\u0001\raR\u0001\u0006i>\u0004\u0018n\u0019\t\u0003\u0011>s!!S'\u0011\u0005)kS\"A&\u000b\u00051K\u0013A\u0002\u001fs_>$h(\u0003\u0002O[\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tqU\u0006C\u0003T\u0007\u0001\u0007A+\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\"\u0001L+\n\u0005Yk#aA%oi\")\u0001l\u0001a\u0001)\u0006\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000fi\u001b\u0001\u0013!a\u00017\u0006YAo\u001c9jG\u000e{gNZ5h!\ta\u0016-D\u0001^\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ev\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d!7\u0001%AA\u0002\u0015\fQB]1dW\u0006;\u0018M]3N_\u0012,\u0007C\u00014j\u001b\u00059'B\u00015(\u0003\u0015\tG-\\5o\u0013\tQwMA\u0007SC\u000e\\\u0017i^1sK6{G-\u001a\u0005\bY\u000e\u0001\n\u00111\u0001n\u00035\u0019'/Z1uKR{\u0007/[2JIB\u0011AF\\\u0005\u0003_6\u0012qAQ8pY\u0016\fg.A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003IT#aW:,\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0013Ut7\r[3dW\u0016$'BA=.\u0003)\tgN\\8uCRLwN\\\u0005\u0003wZ\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIU*\u0012A \u0016\u0003KN\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u0004)\u0012Qn]\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000f\u0006\u0004\u0002\n\u0005m\u0011Q\u0004\t\u0007\u0003\u0017\t\t\"!\u0006\u000e\u0005\u00055!bAA\b[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0011Q\u0002\u0002\u0004'\u0016\f\bc\u00014\u0002\u0018%\u0019\u0011\u0011D4\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\"9Am\u0002I\u0001\u0002\u0004)\u0007\"CA\u0010\u000fA\u0005\t\u0019AA\u0011\u0003)\u0011'o\\6fe2K7\u000f\u001e\t\u0006Y\u0005\r\u0012qE\u0005\u0004\u0003Ki#AB(qi&|g\u000eE\u0003\u0002\f\u0005EA+\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000fJ\u0019\u00029\u001d,GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0006\u0016\u0004\u0003C\u0019\u0018!G2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$\u0012BQA\u001b\u0003o\tY$!\u0015\t\u000b\u0019S\u0001\u0019A$\t\r\u0005e\"\u00021\u0001\\\u0003\u0019\u0019wN\u001c4jO\"9\u0011Q\b\u0006A\u0002\u0005}\u0012A\u00079beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bcBA\u0006\u0003\u0003\"\u0016QI\u0005\u0005\u0003\u0007\niAA\u0002NCB\u0004B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017:\u0013AC2p]R\u0014x\u000e\u001c7fe&!\u0011qJA%\u0005E\u0011V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0005\bY*\u0001\n\u00111\u0001n\u0003\r\u001a'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\n1C^1mS\u0012\fG/\u001a+pa&\u001c7I]3bi\u0016$rAQA-\u00037\ni\u0006C\u0003G\u0019\u0001\u0007q\tC\u0004\u0002>1\u0001\r!a\u0010\t\r\u0005eB\u00021\u0001\\\u0003u9(/\u001b;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$H#\u0003\"\u0002d\u0005\u0015\u0014\u0011NA7\u0011\u00151U\u00021\u0001H\u0011\u001d\t9'\u0004a\u0001\u0003\u007f\t\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u0019\tY'\u0004a\u0001[\u0006A\u0011n]+qI\u0006$X\rC\u0004m\u001bA\u0005\t\u0019A7\u0002O]\u0014\u0018\u000e^3U_BL7\rU1si&$\u0018n\u001c8BgNLwM\\7f]R$C-\u001a4bk2$H\u0005N\u0001\fI\u0016dW\r^3U_BL7\rF\u0002C\u0003kBQAR\bA\u0002\u001d\u000bQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003EA \u0003w\ni(!!\u0002\u0006\u0006%\u0015QRAI\u0011\u00151\u0005\u00031\u0001H\u0011\u001d\ty\b\u0005a\u0001\u0003\u007f\t!#\u001a=jgRLgnZ!tg&<g.\\3oi\"9\u00111\u0011\tA\u0002\u0005%\u0011AC1mY\n\u0013xn[3sg\"A\u0011q\u0011\t\u0011\u0002\u0003\u0007A+A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\n\u0003O\u0002\u0002\u0013!a\u0001\u0003\u0017\u0003R\u0001LA\u0012\u0003\u007fA\u0001\"a$\u0011!\u0003\u0005\r!\\\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\b\u0003'\u0003\u0002\u0019AAK\u00039!x\u000e]5d!2\f7-Z7f]R\u0004R\u0001LA\u0012\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;;\u0013AB2p[6|g.\u0003\u0003\u0002\"\u0006m%A\u0004+pa&\u001c\u0007\u000b\\1dK6,g\u000e^\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIQ*\"!a*+\u0005Q\u001b\u0018aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tiKK\u0002\u0002\fN\fq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001c\u00023Y\fG.\u001b3bi\u0016\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u000b\b\u0005\u0006U\u0016qWA^\u0011\u001d\t9\u0007\u0006a\u0001\u0003\u007fAa!!/\u0015\u0001\u0004!\u0016!G3ya\u0016\u001cG/\u001a3SKBd\u0017nY1uS>tg)Y2u_JDq!!0\u0015\u0001\u0004\ty,\u0001\nbm\u0006LG.\u00192mK\n\u0013xn[3s\u0013\u0012\u001c\b\u0003\u0002%\u0002BRK1!a1R\u0005\r\u0019V\r^\u0001\fa\u0006\u00148/\u001a\"s_.,'\u000f\u0006\u0003\u0002J\u0006-\u0007\u0003\u0002\u0017\u0002$QCa!!4\u0016\u0001\u00049\u0015A\u00022s_.,'/A\u0007dQ\u0006tw-Z\"p]\u001aLwm\u001d\u000b\b\u0005\u0006M\u0017q[An\u0011\u0019\t)N\u0006a\u0001\u000f\u0006QQM\u001c;jif$\u0016\u0010]3\t\r\u0005eg\u00031\u0001H\u0003))g\u000e^5us:\u000bW.\u001a\u0005\u0007\u0003;4\u0002\u0019A.\u0002\u000f\r|gNZ5hg\u0006!2\r[1oO\u0016\u001cE.[3oi&#7i\u001c8gS\u001e$RAQAr\u0003ODa!!:\u0018\u0001\u00049\u0015!E:b]&$\u0018N_3e\u00072LWM\u001c;JI\"1\u0011Q\\\fA\u0002m\u000bad\u00195b]\u001e,Wk]3s\u001fJ,6/\u001a:DY&,g\u000e^%e\u0007>tg-[4\u0015\u000b\t\u000bi/!=\t\r\u0005=\b\u00041\u0001H\u0003M\u0019\u0018M\\5uSj,G-\u00128uSRLh*Y7f\u0011\u0019\ti\u000e\u0007a\u00017\u0006\u0019b/\u00197jI\u0006$X\rV8qS\u000e\u001cuN\u001c4jOR)!)a>\u0002z\")a)\u0007a\u0001\u000f\"1\u0011Q\\\rA\u0002m\u000b\u0011c\u00195b]\u001e,Gk\u001c9jG\u000e{gNZ5h)\u0015\u0011\u0015q B\u0001\u0011\u00151%\u00041\u0001H\u0011\u0019\tiN\u0007a\u00017\u0006\u00112\r[1oO\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0015\u0011%q\u0001B\u0006\u0011\u001d\u0011Ia\u0007a\u0001\u0003O\tqA\u0019:pW\u0016\u00148\u000f\u0003\u0004\u0002^n\u0001\ra\u0017\u000b\u0006\u0005\n=!\u0011\u0003\u0005\b\u0003\u001bd\u0002\u0019AAe\u0011\u0019\ti\u000e\ba\u00017\u0006!b/\u00197jI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$2A\u0011B\f\u0011\u0019\ti.\ba\u00017\u0006\u00112\r[1oO\u0016,e\u000e^5us\u000e{gNZ5h)\u001d\u0011%Q\u0004B\u0011\u0005KAaAa\b\u001f\u0001\u00049\u0015A\u0004:p_R,e\u000e^5usRK\b/\u001a\u0005\u0007\u0005Gq\u0002\u0019A$\u0002/\u0019,H\u000e\\*b]&$\u0018N_3e\u000b:$\u0018\u000e^=OC6,\u0007BBAo=\u0001\u00071,A\tgKR\u001c\u0007.\u00128uSRL8i\u001c8gS\u001e$Ra\u0017B\u0016\u0005[AaAa\b \u0001\u00049\u0005BBAx?\u0001\u0007q)\u0001\nhKR\fE\u000e\u001c+pa&\u001c7i\u001c8gS\u001e\u001cHC\u0001B\u001a!\u0019\tY!!\u0011H7\u0006)b-\u001a;dQ\u0006cG.\u00128uSRL8i\u001c8gS\u001e\u001cH\u0003\u0002B\u001a\u0005sAa!!6\"\u0001\u00049\u0015A\u00074fi\u000eD\u0017\t\u001c7DQ&dG-\u00128uSRL8i\u001c8gS\u001e\u001cHC\u0002B\u001a\u0005\u007f\u0011\t\u0005\u0003\u0004\u0003 \t\u0002\ra\u0012\u0005\u0007\u0005\u0007\u0012\u0003\u0019A$\u0002\u001f\rD\u0017\u000e\u001c3F]RLG/\u001f+za\u0016$BAa\u0012\u0003JA1\u00111BA!\u000fRCqAa\u0013$\u0001\u0004\u0011i%\u0001\u0004u_BL7m\u001d\t\u0005\u0011\u0006\u0005w\t")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean createTopicId) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map replicaAssignment = (Map)AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty())));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.createTopicWithAssignment(topic, topicConfig, (Map<Object, ReplicaAssignment>)replicaAssignment, createTopicId);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        None$ none$;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        if (brokerList == null) {
            throw null;
        }
        if (brokerList.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Seq seq = (Seq)brokerList.get();
            none$ = new Some((Object)AdminZkClient.$anonfun$getBrokerMetadatas$1(allBrokers, seq));
        }
        if (none$ == null) {
            throw null;
        }
        Object object = none$.isEmpty() ? allBrokers : none$.get();
        Object brokers = object;
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode2 != null ? !rackAwareMode2.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()), Seq$.MODULE$.canBuildFrom()));
        return (Seq)seq.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, ReplicaAssignment> partitionReplicaAssignment, boolean createTopicId) {
        this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, false, createTopicId);
    }

    public boolean createTopicWithAssignment$default$4() {
        return false;
    }

    public void validateTopicCreate(String topic, Map<Object, ReplicaAssignment> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Set<String> allTopics = this.zkClient.getAllTopicsInCluster();
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Set collidingTopics = (Set)allTopics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$2(x$4)), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$3(x$5)), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of observers");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)assignment -> {
            AdminZkClient.$anonfun$validateTopicCreate$4(partitionReplicaAssignment, assignment);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((TraversableOnce)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean createTopicId) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int partitionId = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (!isUpdate) {
                None$ topicIdOpt = createTopicId ? new Some((Object)UUID.randomUUID()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<UUID>)topicIdOpt, (Map<TopicPartition, ReplicaAssignment>)assignment);
            } else {
                Map<String, UUID> topicIds = this.zkClient.getTopicIdsForTopics((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                this.zkClient.setTopicAssignment(topic, (Option<UUID>)topicIds.get((Object)topic), (Map<TopicPartition, ReplicaAssignment>)assignment, this.zkClient.setTopicAssignment$default$4());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = "Updated path %s with %s for replica assignment";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment}));
            });
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                String string = "topic %s is already marked for deletion";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, ReplicaAssignment> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, boolean validateOnly, Option<TopicPlacement> topicPlacement) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        if (replicaAssignment == null) {
            throw null;
        }
        if (!replicaAssignment.isEmpty()) {
            Map map = (Map)replicaAssignment.get();
            this.validateReplicaAssignment((Map<Object, ReplicaAssignment>)map, existingAssignmentPartition0.size(), (Set<Object>)((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Seq$.MODULE$.canBuildFrom())).toSet());
        }
        Object object = replicaAssignment.isEmpty() ? AdminZkClient.$anonfun$addPartitions$4(allBrokers, existingAssignmentPartition0, topicPlacement, partitionsToAdd, existingAssignment) : replicaAssignment.get();
        Map proposedAssignmentForNewPartitions = (Map)object;
        Map proposedAssignment = existingAssignment.$plus$plus((GenTraversableOnce)proposedAssignmentForNewPartitions);
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Creating ").append(partitionsToAdd).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(proposedAssignmentForNewPartitions).append(".").toString());
            this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)proposedAssignment, true, this.writeTopicPartitionAssignment$default$4());
        }
        return proposedAssignment;
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, ReplicaAssignment>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    private void validateReplicaAssignment(Map<Object, ReplicaAssignment> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, x0$1);
            return BoxedUnit.UNIT;
        });
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new scala.Serializable(null, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, ReplicaAssignment>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)x1._2();
                    if (assignment.replicas().size() != this.expectedReplicationFactor$1) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        Integer n = BoxesRunTime.boxToInteger((int)assignment.replicas().size());
                        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition));
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        object = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, ReplicaAssignment> x1) {
                boolean bl = x1 != null && ((ReplicaAssignment)x1._2()).replicas().size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$2)), (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$3)), Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$4)), Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        None$ none$;
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            try {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(broker).toInt()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
            }
            none$ = some;
        }
        return none$;
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(49).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.Topic()).append(", ").append(ConfigType$.MODULE$.Client()).append(", ").append(ConfigType$.MODULE$.Broker()).toString());
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            String string = "Topic \"%s\" does not exist.";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminOperationException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        if (broker == null) {
            throw null;
        }
        Object object = broker.isEmpty() ? None$.MODULE$ : new Some((Object)AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)broker.get())));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? ConfigEntityName$.MODULE$.Default() : object.get();
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)object2, configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Object> numPartitions(Set<String> topics) {
        return (Map)this.zkClient.getPartitionsForTopics(topics).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            Seq partitions = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitions.size()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$getBrokerMetadatas$1(Seq allBrokers$1, Seq brokerIds) {
        return (Seq)allBrokers$1.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))));
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$2(ReplicaAssignment x$4) {
        return x$4.replicas().size();
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$3(ReplicaAssignment x$5) {
        return x$5.observers().size();
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$4(Map partitionReplicaAssignment$2, ReplicaAssignment assignment) {
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
        if (assignment.observers().size() != assignment.observers().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(38).append("Duplicate observers assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$8) {
        return x$8.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Map $anonfun$addPartitions$4(Seq allBrokers$2, Seq existingAssignmentPartition0$1, Option topicPlacement$1, int partitionsToAdd$1, Map existingAssignment$1) {
        int startIndex = package$.MODULE$.max(0, allBrokers$2.indexWhere((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$addPartitions$5(existingAssignmentPartition0$1, x$8))));
        return Observer$.MODULE$.getReplicaAssignment((Seq<BrokerMetadata>)allBrokers$2, (Option<TopicPlacement>)topicPlacement$1, partitionsToAdd$1, existingAssignmentPartition0$1.size(), startIndex, existingAssignment$1.size());
    }

    public static final /* synthetic */ void $anonfun$validateReplicaAssignment$1(Set availableBrokerIds$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int partitionId = x0$1._1$mcI$sp();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$1._2();
            if (assignment.replicas().isEmpty()) {
                throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
            }
            if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
                throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(assignment.replicas().mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
            }
            if (!assignment.replicas().toSet().subsetOf((GenSet)availableBrokerIds$1)) {
                throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(assignment.replicas().mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
            }
        } else {
            throw new MatchError(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int partitionId = x0$2._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$3) {
        void var1_1;
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        int partitionId = x0$3._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$4) {
        void var1_1;
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        int rf = x0$4._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$9) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$9)).toString();
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        Seq entityNames = this.zkClient.getAllEntitiesWithConfig(string);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            seq = (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(rootPath)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)rootPath);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$addPartitions$2$adapted(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        $this.validateReplicaAssignment((Map<Object, ReplicaAssignment>)proposedReplicaAssignment, existingAssignmentPartition0$1.size(), (Set<Object>)((TraversableOnce)allBrokers$2.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Seq$.MODULE$.canBuildFrom())).toSet());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2$adapted(Object x$9) {
        return AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$9));
    }
}

