/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeletionTask$
implements Logging {
    public static DeletionTask$ MODULE$;
    private final int FencedSegmentDeleteDelayMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new DeletionTask$();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Option<Meter> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    @Override
    public String loggerName() {
        return DeletionTask.class.getName();
    }

    public int FencedSegmentDeleteDelayMs() {
        return this.FencedSegmentDeleteDelayMs;
    }

    public long getDelayFromLogConfig(Option<AbstractLog> log) {
        if (log == null) {
            throw null;
        }
        Object object = log.isEmpty() ? None$.MODULE$ : new Some((Object)DeletionTask$.$anonfun$getDelayFromLogConfig$1((AbstractLog)log.get()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long((Long)object.get())));
        if (object2 == null) {
            throw null;
        }
        Object object3 = object2.isEmpty() ? BoxesRunTime.boxToLong((long)DeletionTask$.$anonfun$getDelayFromLogConfig$3()) : object2.get();
        return BoxesRunTime.unboxToLong((Object)object3);
    }

    public Future<BoxedUnit> writeDeletionInitiatedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, TierObjectStore.ObjectMetadata segment, ExecutionContext ec) {
        TierSegmentDeleteInitiate marker = new TierSegmentDeleteInitiate(segment.topicIdPartition(), leaderEpoch, segment.objectId());
        return this.writeMarker(tierTopicAppender, leaderEpoch, marker, ec);
    }

    public Future<BoxedUnit> writeDeletionCompletedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, TierObjectStore.ObjectMetadata objectMetadata, ExecutionContext ec) {
        TierSegmentDeleteComplete marker = new TierSegmentDeleteComplete(objectMetadata.topicIdPartition(), leaderEpoch, objectMetadata.objectId());
        return this.writeMarker(tierTopicAppender, leaderEpoch, marker, ec);
    }

    public Future<BoxedUnit> writePartitionDeletionCompletedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ExecutionContext ec) {
        TierPartitionDeleteComplete marker = new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID());
        return this.writeMarker(tierTopicAppender, leaderEpoch, marker, ec);
    }

    public Future<BoxedUnit> writeMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, AbstractTierMetadata marker, ExecutionContext ec) {
        return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(marker))).map((Function1 & Serializable & scala.Serializable)appendResult -> {
            DeletionTask$.$anonfun$writeMarker$1(marker, appendResult);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public static final /* synthetic */ Long $anonfun$getDelayFromLogConfig$1(AbstractLog x$10) {
        return x$10.config().fileDeleteDelayMs();
    }

    public static final /* synthetic */ long $anonfun$getDelayFromLogConfig$3() {
        return 0L;
    }

    public static final /* synthetic */ String $anonfun$writeMarker$2(AbstractTierMetadata marker$1) {
        return new StringBuilder(23).append("Successfully completed ").append(marker$1).toString();
    }

    public static final /* synthetic */ String $anonfun$writeMarker$3(AbstractTierMetadata marker$1) {
        return new StringBuilder(63).append("Stopping state machine for ").append(marker$1.topicIdPartition()).append(" as attempt to transition was fenced").toString();
    }

    public static final /* synthetic */ void $anonfun$writeMarker$1(AbstractTierMetadata marker$1, TierPartitionState.AppendResult appendResult) {
        if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult)) {
            DeletionTask$ deletionTask$ = MODULE$;
            if (deletionTask$ == null) {
                throw null;
            }
            DeletionTask$ debug_this = deletionTask$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(DeletionTask$.$anonfun$writeMarker$2(marker$1)));
                return;
            }
        } else {
            if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult)) {
                DeletionTask$ deletionTask$ = MODULE$;
                if (deletionTask$ == null) {
                    throw null;
                }
                DeletionTask$ info_this = deletionTask$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(DeletionTask$.$anonfun$writeMarker$3(marker$1)));
                }
                throw new TierArchiverFencedException(marker$1.topicIdPartition());
            }
            throw new IllegalStateException(new StringBuilder(31).append("Unexpected append result for ").append(marker$1.topicIdPartition()).append(": ").append((Object)appendResult).toString());
        }
    }

    private DeletionTask$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.FencedSegmentDeleteDelayMs = 600000;
    }

    public static final /* synthetic */ Object $anonfun$getDelayFromLogConfig$2$adapted(Long x) {
        return BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x));
    }
}

