/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.UploadableSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFatalException;
import kafka.tier.exceptions.TierArchiverFatalException$;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.AwaitPermission$;
import scala.concurrent.BlockContext$;
import scala.concurrent.CanAwait;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ArchiveTask$
implements Logging {
    public static ArchiveTask$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ArchiveTask$();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    public ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics) {
        return new ArchiveTask(ctx, topicIdPartition, new BeforeLeader(leaderEpoch), archiverMetrics);
    }

    public Future<BeforeUpload> establishLeadership(BeforeLeader state, TopicIdPartition topicIdPartition, TierTopicAppender tierTopicAppender, ExecutionContext ec) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.becomeArchiver(topicIdPartition, state.leaderEpoch()))))).flatMap((Function1 & Serializable & scala.Serializable)x -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return x;
        }, ec).map((Function1 & Serializable & scala.Serializable)result -> {
            if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(result)) {
                ArchiveTask$ archiveTask$ = MODULE$;
                if (archiveTask$ == null) {
                    throw null;
                }
                ArchiveTask$ info_this = archiveTask$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(ArchiveTask$.$anonfun$establishLeadership$4(topicIdPartition)));
                }
            } else {
                if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(result)) {
                    throw new NotTierablePartitionException(topicIdPartition);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(result)) {
                    throw new TierArchiverFencedException(topicIdPartition);
                }
                throw new TierArchiverFatalException(new StringBuilder(21).append("Unknown AppendResult ").append(result).toString(), TierArchiverFatalException$.MODULE$.$lessinit$greater$default$2());
            }
            BeforeUpload beforeUpload = new BeforeUpload(state.leaderEpoch());
            return beforeUpload;
        }, ec);
    }

    /*
     * WARNING - void declaration
     */
    public Future<ArchiveTaskState> maybeInitiateUpload(BeforeUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, ExecutionContext ec) {
        void apply_body;
        Future$ future$ = Future$.MODULE$;
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            Option<AbstractLog> option = replicaManager.getLog(topicIdPartition.topicPartition());
            if (option == null) {
                throw null;
            }
            Option<AbstractLog> flatMap_this = option;
            if (flatMap_this.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                AbstractLog abstractLog = (AbstractLog)flatMap_this.get();
                none$ = ArchiveTask$.$anonfun$maybeInitiateUpload$2(state, topicIdPartition, abstractLog);
            }
            if (None$.MODULE$.equals(none$)) {
                ArchiveTask$ archiveTask$ = MODULE$;
                if (archiveTask$ == null) {
                    throw null;
                }
                ArchiveTask$ debug_this = archiveTask$;
                if (debug_this.logger().underlying().isDebugEnabled()) {
                    debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(ArchiveTask$.$anonfun$maybeInitiateUpload$3(topicIdPartition)));
                }
                Future$ future$ = Future$.MODULE$;
                Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> state;
                if (future$ != null) void apply_body;
                return future$.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), ec);
                throw null;
            }
            if (!(none$ instanceof Some)) throw new MatchError((Object)none$);
            Tuple2 tuple2 = (Tuple2)((Some)none$).value();
            if (tuple2 == null) throw new MatchError((Object)none$);
            AbstractLog log = (AbstractLog)tuple2._1();
            LogSegment logSegment = (LogSegment)tuple2._2();
            if (log == null) throw new MatchError((Object)none$);
            if (logSegment == null) throw new MatchError((Object)none$);
            UploadableSegment segment = MODULE$.uploadableSegment(log, logSegment, topicIdPartition);
            if (log.isDeleted()) {
                throw new NotTierablePartitionException(topicIdPartition);
            }
            TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), logSegment.baseOffset(), segment.nextOffset() - 1L, logSegment.largestTimestamp(), logSegment.size(), segment.leaderEpochStateOpt().isDefined(), segment.abortedTxnIndexOpt().isDefined(), segment.producerStateOpt().isDefined());
            long startTime = time.milliseconds();
            return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadInitiate))))).flatMap((Function1 & Serializable & scala.Serializable)x -> {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return x;
            }, ec).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                    ArchiveTask$ archiveTask$ = MODULE$;
                    if (archiveTask$ == null) {
                        throw null;
                    }
                    ArchiveTask$ info_this = archiveTask$;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent(ArchiveTask$.$anonfun$maybeInitiateUpload$8(uploadInitiate, topicIdPartition, time, startTime)));
                    }
                } else {
                    if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                        throw new NotTierablePartitionException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                        throw new TierArchiverFencedException(topicIdPartition);
                    }
                    throw new MatchError((Object)x0$1);
                }
                Upload upload = new Upload(state.leaderEpoch(), uploadInitiate, segment);
                return upload;
            }, ec);
        };
        if (future$ == null) {
            throw null;
        }
        return future$.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), ec).flatMap((Function1 & Serializable & scala.Serializable)x -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return x;
        }, ec);
    }

    /*
     * WARNING - void declaration
     */
    public Future<AfterUpload> upload(Upload state, TopicIdPartition topicIdPartition, Time time, TierObjectStore tierObjectStore, ExecutionContext ec) {
        void apply_body;
        Future$ future$ = Future$.MODULE$;
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
            void blocking_body;
            UploadableSegment uploadableSegment = state.uploadableSegment();
            TierSegmentUploadInitiate uploadInitiate = state.uploadInitiate();
            TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadableSegment.abortedTxnIndexOpt().isDefined());
            Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
                long startTime = time.milliseconds();
                try {
                    tierObjectStore.putSegment(metadata, uploadableSegment.logSegmentFile(), uploadableSegment.offsetIndex(), uploadableSegment.timeIndex(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.producerStateOpt())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.abortedTxnIndexOpt())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.leaderEpochStateOpt())));
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        if (!MODULE$.segmentFilesExist(state.uploadableSegment())) {
                            throw new ArchiveTask.SegmentDeletedException(new StringBuilder(33).append("Segment ").append(uploadableSegment.logSegmentFile().getAbsolutePath()).append(" of ").append(topicIdPartition).append(" deleted when tiering").toString(), exception);
                        }
                    }
                    throw throwable;
                }
                ArchiveTask$ archiveTask$ = MODULE$;
                if (archiveTask$ == null) {
                    throw null;
                }
                ArchiveTask$ info_this = archiveTask$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(ArchiveTask$.$anonfun$upload$3(topicIdPartition, time, startTime)));
                }
                return new AfterUpload(state.leaderEpoch(), uploadInitiate, state.uploadableSegment().uploadedSize());
            };
            if (package$.MODULE$ == null) {
                throw null;
            }
            return (AfterUpload)BlockContext$.MODULE$.current().blockOn((Function0)blocking_body, (CanAwait)AwaitPermission$.MODULE$);
        };
        if (future$ == null) {
            throw null;
        }
        return future$.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), ec);
    }

    public Future<BeforeUpload> finalizeUpload(AfterUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, Option<Meter> byteRateMetric, ExecutionContext ec) {
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(state.uploadInitiate());
        long startTime = time.milliseconds();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadComplete))))).flatMap((Function1 & Serializable & scala.Serializable)x -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return x;
        }, ec).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                ArchiveTask$ archiveTask$ = MODULE$;
                if (archiveTask$ == null) {
                    throw null;
                }
                ArchiveTask$ info_this = archiveTask$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(ArchiveTask$.$anonfun$finalizeUpload$4(uploadComplete, topicIdPartition, time, startTime)));
                }
                if (byteRateMetric == null) {
                    throw null;
                }
                if (!byteRateMetric.isEmpty()) {
                    Meter meter = (Meter)byteRateMetric.get();
                    meter.mark(state.uploadedSize());
                }
            } else {
                if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                    throw new NotTierablePartitionException(topicIdPartition);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                    throw new TierArchiverFencedException(topicIdPartition);
                }
                throw new MatchError((Object)x0$1);
            }
            BeforeUpload beforeUpload = new BeforeUpload(state.leaderEpoch());
            return beforeUpload;
        }, ec);
    }

    public UploadableSegment uploadableSegment(AbstractLog log, LogSegment logSegment, TopicIdPartition topicIdPartition) {
        try {
            return log.createUploadableSegment(logSegment);
        }
        catch (NoSuchFileException e) {
            throw new ArchiveTask.SegmentDeletedException(new StringBuilder(33).append("Segment ").append(logSegment).append(" of ").append(topicIdPartition).append(" deleted when tiering").toString(), e);
        }
    }

    private boolean segmentFilesExist(UploadableSegment uploadableSegment) {
        boolean bl;
        block3: {
            LinearSeqOptimized linearSeqOptimized = uploadableSegment.allFiles();
            if (linearSeqOptimized == null) {
                throw null;
            }
            LinearSeqOptimized forall_these = linearSeqOptimized;
            while (!forall_these.isEmpty()) {
                if (!((File)forall_these.head()).exists()) {
                    bl = false;
                    break block3;
                }
                forall_these = (LinearSeqOptimized)forall_these.tail();
            }
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$establishLeadership$4(TopicIdPartition topicIdPartition$1) {
        return new StringBuilder(27).append("established leadership for ").append(topicIdPartition$1).toString();
    }

    public static final /* synthetic */ Option $anonfun$maybeInitiateUpload$2(BeforeUpload state$2, TopicIdPartition topicIdPartition$2, AbstractLog log) {
        if (log.tierPartitionState().tierEpoch() != state$2.leaderEpoch()) {
            throw new TierArchiverFencedException(topicIdPartition$2);
        }
        return log.tierableLogSegments().collectFirst((PartialFunction)new scala.Serializable(log){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$1;

            public final <A1 extends LogSegment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 != null ? new Tuple2((Object)this.log$1, x1) : function1.apply(null);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogSegment x1) {
                boolean bl = x1 != null;
                return bl;
            }
            {
                this.log$1 = log$1;
            }
        });
    }

    public static final /* synthetic */ String $anonfun$maybeInitiateUpload$3(TopicIdPartition topicIdPartition$2) {
        return new StringBuilder(91).append("Transitioning back to BeforeUpload for ").append(topicIdPartition$2).append(" as log has moved or no tierable segments were found").toString();
    }

    public static final /* synthetic */ String $anonfun$maybeInitiateUpload$8(TierSegmentUploadInitiate uploadInitiate$1, TopicIdPartition topicIdPartition$2, Time time$2, long startTime$1) {
        return new StringBuilder(75).append("Completed UploadInitiate(objectId: ").append(uploadInitiate$1.messageId()).append(", baseOffset: ").append(uploadInitiate$1.baseOffset()).append(",").append(" endOffset: ").append(uploadInitiate$1.endOffset()).append("]) for ").append(topicIdPartition$2).append(" in ").append(time$2.milliseconds() - startTime$1).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$upload$3(TopicIdPartition topicIdPartition$3, Time time$3, long startTime$2) {
        return new StringBuilder(27).append("Uploaded segment for ").append(topicIdPartition$3).append(" in ").append(time$3.milliseconds() - startTime$2).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$finalizeUpload$4(TierSegmentUploadComplete uploadComplete$1, TopicIdPartition topicIdPartition$4, Time time$4, long startTime$3) {
        return new StringBuilder(38).append("Finalized UploadComplete(").append(uploadComplete$1.messageId()).append(") ").append("for ").append(topicIdPartition$4).append(" in ").append(time$4.milliseconds() - startTime$3).append(" ms").toString();
    }

    private ArchiveTask$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$segmentFilesExist$1$adapted(File x$2) {
        return BoxesRunTime.boxToBoolean((boolean)x$2.exists());
    }

    public static final /* synthetic */ Object $anonfun$finalizeUpload$5$adapted(AfterUpload state$4, Meter x$1) {
        x$1.mark(state$4.uploadedSize());
        return BoxedUnit.UNIT;
    }
}

