/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.util.HashMap;
import java.util.Map;
import kafka.log.Log;
import kafka.tier.store.TierObjectStore;

public class TierObjectStoreUtils {
    private static final String LOG_DATA_PREFIX = "0";

    public static String keyPath(TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType fileType) {
        return "0/" + objectMetadata.objectIdAsBase64() + "/" + objectMetadata.topicIdPartition().topicIdAsBase64() + "/" + objectMetadata.topicIdPartition().partition() + "/" + Log.filenamePrefixFromOffset(objectMetadata.baseOffset()) + "_" + objectMetadata.tierEpoch() + "_v" + objectMetadata.version() + "." + fileType.suffix();
    }

    public static Map<String, String> createSegmentMetadata(TierObjectStore.ObjectMetadata objectMetadata, String clusterId, int brokerId) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("metadata_version", Integer.toString(objectMetadata.version()));
        metadata.put("topic", objectMetadata.topicIdPartition().topic());
        metadata.put("cluster_id", clusterId);
        metadata.put("broker_id", Integer.toString(brokerId));
        return metadata;
    }
}

