/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.utils.CoreUtils;

public interface TierObjectStore {
    public TierObjectStoreResponse getObject(ObjectMetadata var1, FileType var2, Integer var3, Integer var4) throws IOException;

    default public TierObjectStoreResponse getObject(ObjectMetadata objectMetadata, FileType fileType, Integer byteOffsetStart) throws IOException {
        return this.getObject(objectMetadata, fileType, byteOffsetStart, null);
    }

    default public TierObjectStoreResponse getObject(ObjectMetadata objectMetadata, FileType fileType) throws IOException {
        return this.getObject(objectMetadata, fileType, null);
    }

    public void putSegment(ObjectMetadata var1, File var2, File var3, File var4, Optional<File> var5, Optional<ByteBuffer> var6, Optional<File> var7) throws TierObjectStoreRetriableException, IOException;

    public void deleteSegment(ObjectMetadata var1) throws IOException;

    public void close();

    public static class ObjectMetadata {
        private static final int CURRENT_VERSION = 0;
        private final int version;
        private final TopicIdPartition topicIdPartition;
        private final UUID objectId;
        private final int tierEpoch;
        private final long baseOffset;
        private final boolean hasAbortedTxns;

        public ObjectMetadata(TopicIdPartition topicIdPartition, UUID objectId, int tierEpoch, long baseOffset, boolean hasAbortedTxns) {
            this.version = 0;
            this.topicIdPartition = topicIdPartition;
            this.objectId = objectId;
            this.tierEpoch = tierEpoch;
            this.baseOffset = baseOffset;
            this.hasAbortedTxns = hasAbortedTxns;
        }

        public ObjectMetadata(TierObjectMetadata metadata) {
            this.version = metadata.version();
            this.topicIdPartition = metadata.topicIdPartition();
            this.objectId = metadata.objectId();
            this.tierEpoch = metadata.tierEpoch();
            this.baseOffset = metadata.baseOffset();
            this.hasAbortedTxns = metadata.hasAbortedTxns();
        }

        public int version() {
            return this.version;
        }

        public TopicIdPartition topicIdPartition() {
            return this.topicIdPartition;
        }

        public UUID objectId() {
            return this.objectId;
        }

        public String objectIdAsBase64() {
            return CoreUtils.uuidToBase64(this.objectId());
        }

        public int tierEpoch() {
            return this.tierEpoch;
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public boolean hasAbortedTxns() {
            return this.hasAbortedTxns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectMetadata that = (ObjectMetadata)o;
            return this.tierEpoch == that.tierEpoch && this.baseOffset == that.baseOffset && Objects.equals(this.topicIdPartition, that.topicIdPartition) && Objects.equals(this.objectId, that.objectId) && this.hasAbortedTxns == that.hasAbortedTxns;
        }

        public int hashCode() {
            return Objects.hash(this.topicIdPartition, this.objectId, this.tierEpoch, this.baseOffset, this.hasAbortedTxns);
        }

        public String toString() {
            return "ObjectMetadata(topic=" + this.topicIdPartition + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", tierEpoch=" + this.tierEpoch + ", startOffset=" + this.baseOffset + ", hasAbortedTxns=" + this.hasAbortedTxns + ')';
        }
    }

    public static enum FileType {
        SEGMENT("segment"),
        OFFSET_INDEX("offset-index"),
        TIMESTAMP_INDEX("timestamp-index"),
        TRANSACTION_INDEX("transaction-index"),
        PRODUCER_STATE("producer-state"),
        EPOCH_STATE("epoch-state");

        private final String suffix;

        public String suffix() {
            return this.suffix;
        }

        private FileType(String suffix) {
            this.suffix = suffix;
        }
    }
}

