/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AutoAbortingS3InputStream
extends InputStream {
    private final S3ObjectInputStream innerInputStream;
    private final long autoAbortSize;
    private long bytesRead = 0L;
    private long totalBytes;
    private boolean exception = false;

    AutoAbortingS3InputStream(S3ObjectInputStream innerInputStream, long autoAbortSize, long totalBytes) {
        this.innerInputStream = innerInputStream;
        this.autoAbortSize = autoAbortSize;
        this.totalBytes = totalBytes;
    }

    @Override
    public int read() throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            int read = this.innerInputStream.read();
            ++this.bytesRead;
            return read;
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            int read = this.innerInputStream.read(b);
            this.bytesRead += (long)read;
            return read;
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            int read = this.innerInputStream.read(b, off, len);
            this.bytesRead += (long)read;
            return read;
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }

    private long remainingBytes() {
        return this.totalBytes - this.bytesRead;
    }

    @Override
    public void close() {
        boolean shouldAbort;
        boolean bl = shouldAbort = this.exception || this.remainingBytes() > this.autoAbortSize;
        if (shouldAbort) {
            this.innerInputStream.abort();
        } else {
            try {
                byte[] skipBuf = new byte[1024];
                while (this.innerInputStream.read(skipBuf, 0, skipBuf.length) > 0) {
                }
                this.innerInputStream.close();
            }
            catch (IOException ignored) {
                this.innerInputStream.abort();
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            return this.innerInputStream.available();
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            long skipped = this.innerInputStream.skip(n);
            this.bytesRead += skipped;
            return skipped;
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }
}

