/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import org.slf4j.Logger;

class ReplicationMaterializationListener {
    private final Logger log;
    private final TopicIdPartition topicIdPartition;
    private final CompletableFuture<TierObjectMetadata> promise;
    private final long offsetToMaterialize;

    ReplicationMaterializationListener(Logger log, TopicIdPartition topicIdPartition, long offsetToMaterialize) {
        this.log = log;
        this.topicIdPartition = topicIdPartition;
        this.offsetToMaterialize = offsetToMaterialize;
        this.promise = new CompletableFuture();
    }

    Future<TierObjectMetadata> promise() {
        return this.promise;
    }

    synchronized void complete(TierObjectMetadata lastFlushedSegment) {
        if (!this.promise.isDone()) {
            this.log.info("Completing {} successfully. lastFlushedSegment: {}", (Object)this, (Object)lastFlushedSegment);
            this.promise.complete(lastFlushedSegment);
        }
    }

    synchronized void completeExceptionally(Exception e) {
        if (!this.promise.isDone()) {
            this.log.info("Completing {} exceptionally", (Object)this, (Object)e);
            this.promise.completeExceptionally(e);
        }
    }

    boolean canComplete(TierObjectMetadata lastMaterializedSegment) {
        return lastMaterializedSegment.endOffset() >= this.offsetToMaterialize;
    }

    public String toString() {
        return "ReplicationMaterializationListener(topicIdPartition: " + this.topicIdPartition + ", offsetToMaterialize: " + this.offsetToMaterialize + ")";
    }
}

