/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.SegmentUploadInitiate;

public class TierSegmentUploadInitiate
extends AbstractTierSegmentMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 60;
    private final TopicIdPartition topicIdPartition;
    private final SegmentUploadInitiate metadata;

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long baseOffset, long endOffset, long maxTimestamp, int size, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState) {
        FlatBufferBuilder builder = new FlatBufferBuilder(60).forceDefaults(true);
        SegmentUploadInitiate.startSegmentUploadInitiate(builder);
        SegmentUploadInitiate.addVersion(builder, (byte)0);
        SegmentUploadInitiate.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        SegmentUploadInitiate.addObjectId(builder, objectIdOffset);
        SegmentUploadInitiate.addBaseOffset(builder, baseOffset);
        SegmentUploadInitiate.addEndOffsetDelta(builder, (int)(endOffset - baseOffset));
        SegmentUploadInitiate.addMaxTimestamp(builder, maxTimestamp);
        SegmentUploadInitiate.addSize(builder, size);
        SegmentUploadInitiate.addHasEpochState(builder, hasEpochState);
        SegmentUploadInitiate.addHasAbortedTxns(builder, hasAbortedTxns);
        SegmentUploadInitiate.addHasProducerState(builder, hasProducerState);
        int entryId = SegmentUploadInitiate.endSegmentUploadInitiate(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentUploadInitiate.getRootAsSegmentUploadInitiate(builder.dataBuffer());
    }

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, SegmentUploadInitiate metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE;
    }

    public long baseOffset() {
        return this.metadata.baseOffset();
    }

    public long endOffset() {
        return this.metadata.baseOffset() + (long)this.metadata.endOffsetDelta();
    }

    public long maxTimestamp() {
        return this.metadata.maxTimestamp();
    }

    public int size() {
        return this.metadata.size();
    }

    public boolean hasEpochState() {
        return this.metadata.hasEpochState();
    }

    public boolean hasAbortedTxns() {
        return this.metadata.hasAbortedTxns();
    }

    public boolean hasProducerState() {
        return this.metadata.hasProducerState();
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentUploadInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.objectId().mostSignificantBits(), this.metadata.objectId().leastSignificantBits());
    }

    public String toString() {
        return "TierSegmentUploadInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", baseOffset=" + this.baseOffset() + ", endOffset=" + this.endOffset() + ", maxTimestamp=" + this.maxTimestamp() + ", size=" + this.size() + ", hasEpochState=" + this.hasEpochState() + ", hasAbortedTxns=" + this.hasAbortedTxns() + ", hasProducerState=" + this.hasProducerState() + ")";
    }
}

