/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.TierMetadataDeserializationException;
import kafka.tier.serdes.InitLeader;
import kafka.tier.serdes.PartitionDeleteComplete;
import kafka.tier.serdes.PartitionDeleteInitiate;
import kafka.tier.serdes.SegmentDeleteComplete;
import kafka.tier.serdes.SegmentDeleteInitiate;
import kafka.tier.serdes.SegmentUploadComplete;
import kafka.tier.serdes.SegmentUploadInitiate;
import kafka.tier.serdes.TierKafkaKey;
import kafka.utils.CoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTierMetadata {
    private static final Logger log = LoggerFactory.getLogger(AbstractTierMetadata.class);
    private static final int KEY_INITIAL_LENGTH = 200;
    private static final int TYPE_LENGTH = 1;

    public byte[] serializeKey() {
        FlatBufferBuilder builder = new FlatBufferBuilder(200);
        int topicNameOffset = builder.createString((CharSequence)this.topicIdPartition().topic());
        int topicIdOffset = kafka.tier.serdes.UUID.createUUID(builder, this.topicIdPartition().topicId().getMostSignificantBits(), this.topicIdPartition().topicId().getLeastSignificantBits());
        TierKafkaKey.startTierKafkaKey(builder);
        TierKafkaKey.addTopicId(builder, topicIdOffset);
        TierKafkaKey.addPartition(builder, this.topicIdPartition().topicPartition().partition());
        TierKafkaKey.addTopicName(builder, topicNameOffset);
        int entryId = TierKafkaKey.endTierKafkaKey(builder);
        builder.finish(entryId);
        ByteBuffer buffer = builder.dataBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public byte[] serializeValue() {
        ByteBuffer payload = this.payloadBuffer();
        ByteBuffer buf = ByteBuffer.allocate(payload.remaining() + 1);
        buf.put(TierRecordType.toByte(this.type()));
        buf.put(payload);
        return buf.array();
    }

    public static byte getTypeId(byte[] value) {
        return value[0];
    }

    public static TopicIdPartition deserializeKey(byte[] key) {
        return AbstractTierMetadata.deserializeKey(ByteBuffer.wrap(key));
    }

    public static TopicIdPartition deserializeKey(ByteBuffer key) {
        TierKafkaKey tierKey = TierKafkaKey.getRootAsTierKafkaKey(key);
        return new TopicIdPartition(tierKey.topicName(), new UUID(tierKey.topicId().mostSignificantBits(), tierKey.topicId().leastSignificantBits()), tierKey.partition());
    }

    public static Optional<AbstractTierMetadata> deserialize(byte[] key, byte[] value) throws TierMetadataDeserializationException {
        try {
            return AbstractTierMetadata.deserialize(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
        }
        catch (Exception e) {
            throw new TierMetadataDeserializationException(String.format("Deserialization error [%s]", e.getMessage()), e);
        }
    }

    public static Optional<AbstractTierMetadata> deserialize(ByteBuffer key, ByteBuffer value) throws TierMetadataDeserializationException {
        TopicIdPartition topicIdPartition = AbstractTierMetadata.deserializeKey(key);
        TierRecordType type = TierRecordType.toType(value.get());
        switch (type) {
            case InitLeader: {
                InitLeader initLeader = InitLeader.getRootAsInitLeader(value);
                return Optional.of(new TierTopicInitLeader(topicIdPartition, initLeader));
            }
            case SegmentUploadInitiate: {
                SegmentUploadInitiate uploadInitiate = SegmentUploadInitiate.getRootAsSegmentUploadInitiate(value);
                return Optional.of(new TierSegmentUploadInitiate(topicIdPartition, uploadInitiate));
            }
            case SegmentUploadComplete: {
                SegmentUploadComplete uploadComplete = SegmentUploadComplete.getRootAsSegmentUploadComplete(value);
                return Optional.of(new TierSegmentUploadComplete(topicIdPartition, uploadComplete));
            }
            case SegmentDeleteInitiate: {
                SegmentDeleteInitiate deleteInitiate = SegmentDeleteInitiate.getRootAsSegmentDeleteInitiate(value);
                return Optional.of(new TierSegmentDeleteInitiate(topicIdPartition, deleteInitiate));
            }
            case SegmentDeleteComplete: {
                SegmentDeleteComplete deleteComplete = SegmentDeleteComplete.getRootAsSegmentDeleteComplete(value);
                return Optional.of(new TierSegmentDeleteComplete(topicIdPartition, deleteComplete));
            }
            case PartitionDeleteInitiate: {
                PartitionDeleteInitiate partitionDeleteInitiate = PartitionDeleteInitiate.getRootAsPartitionDeleteInitiate(value);
                return Optional.of(new TierPartitionDeleteInitiate(topicIdPartition, partitionDeleteInitiate));
            }
            case PartitionDeleteComplete: {
                PartitionDeleteComplete partitionDeleteComplete = PartitionDeleteComplete.getRootAsPartitionDeleteComplete(value);
                return Optional.of(new TierPartitionDeleteComplete(topicIdPartition, partitionDeleteComplete));
            }
        }
        log.debug("Unknown tier metadata type with ID {}. Ignoring record.", (Object)type);
        return Optional.empty();
    }

    public abstract TierRecordType type();

    public abstract TopicIdPartition topicIdPartition();

    public abstract ByteBuffer payloadBuffer();

    public abstract int tierEpoch();

    public abstract UUID messageId();

    public String messageIdAsBase64() {
        return CoreUtils.uuidToBase64(this.messageId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTierMetadata that = (AbstractTierMetadata)o;
        return this.type().equals((Object)that.type()) && this.topicIdPartition().equals(that.topicIdPartition()) && this.payloadBuffer().equals(that.payloadBuffer());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type(), this.topicIdPartition(), this.payloadBuffer()});
    }
}

