/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.ArrayList;
import java.util.List;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierReplicaManager {
    private static final Logger log = LoggerFactory.getLogger(TierReplicaManager.class);
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public synchronized void becomeLeader(TierPartitionState tierPartitionState, int leaderEpoch) {
        if (tierPartitionState.isTieringEnabled()) {
            log.debug("Firing becomeLeader listeners for tiered topic {}", tierPartitionState.topicIdPartition());
            this.changeListeners.forEach(listener -> listener.onBecomeLeader(tierPartitionState.topicIdPartition().get(), leaderEpoch));
        }
    }

    public synchronized void becomeFollower(TierPartitionState tierPartitionState) {
        if (tierPartitionState.isTieringEnabled()) {
            log.debug("Firing becomeFollower listeners for tiered topic {}", tierPartitionState.topicIdPartition());
            this.changeListeners.forEach(listener -> listener.onBecomeFollower(tierPartitionState.topicIdPartition().get()));
        }
    }

    public synchronized void delete(TopicIdPartition topicIdPartition) {
        log.debug("Firing onDelete listeners for tiered topic {}", (Object)topicIdPartition);
        this.changeListeners.forEach(listener -> listener.onDelete(topicIdPartition));
    }

    public synchronized void addListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public static interface ChangeListener {
        public void onBecomeLeader(TopicIdPartition var1, int var2);

        public void onBecomeFollower(TopicIdPartition var1);

        public void onDelete(TopicIdPartition var1);
    }
}

