/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.ReplicaManager;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.DeletionState;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.InProgressDeletion$;
import kafka.tier.MaterializationComplete$;
import kafka.tier.TierDeletedPartitionsCoordinator$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}r!B\u0017/\u0011\u0003\u0019d!B\u001b/\u0011\u00031\u0004\"B\u001f\u0002\t\u0003q\u0004bB \u0002\u0005\u0004%\t\u0001\u0011\u0005\u0007\t\u0006\u0001\u000b\u0011B!\u0007\tUr\u0003!\u0012\u0005\t%\u0016\u0011\t\u0011)A\u0005'\"Aa+\u0002B\u0001B\u0003%q\u000b\u0003\u0005^\u000b\t\u0005\t\u0015!\u0003_\u0011!!WA!A!\u0002\u0013)\u0007\u0002\u00035\u0006\u0005\u0003\u0005\u000b\u0011B5\t\u0011Q,!\u0011!Q\u0001\nUDa!P\u0003\u0005\u0002\u0005\r\u0001\"CA\n\u000b\t\u0007I\u0011BA\u000b\u0011!\t)#\u0002Q\u0001\n\u0005]\u0001bCA\u0014\u000b\u0001\u0007\t\u0019!C\u0005\u0003SA1\"!\r\u0006\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y\u0011qH\u0003A\u0002\u0003\u0005\u000b\u0015BA\u0016\u0011-\t\t%\u0002a\u0001\u0002\u0004%I!a\u0011\t\u0017\u0005=T\u00011AA\u0002\u0013%\u0011\u0011\u000f\u0005\f\u0003?*\u0001\u0019!A!B\u0013\t)\u0005C\u0005\u0002~\u0015\u0001\r\u0011\"\u0003\u0002\u0000!I\u0011\u0011Q\u0003A\u0002\u0013%\u00111\u0011\u0005\b\u0003\u000f+\u0001\u0015)\u0003f\u0011!\tI)\u0002a\u0001\n\u0013\u0001\u0005\"CAF\u000b\u0001\u0007I\u0011BAG\u0011\u001d\t\t*\u0002Q!\n\u0005C!\"a%\u0006\u0005\u0004%\tALAK\u0011!\ti+\u0002Q\u0001\n\u0005]\u0005bBAX\u000b\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003g+A\u0011AA[\u0011\u001d\tY,\u0002C\u0001\u0003{Cq!!1\u0006\t\u0003\t\u0019\rC\u0004\u0002H\u0016!\t!!-\t\u000f\u0005%W\u0001\"\u0003\u00022\"9\u00111Z\u0003\u0005\n\u0005E\u0006bBAg\u000b\u0011%\u0011\u0011\u0017\u0005\t\u0003\u001f,A\u0011\u0001\u0018\u0002R\"A\u0011\u0011`\u0003\u0005\u00029\n\t\f\u0003\u0005\u0002|\u0016!\tALAY\u0011!\ti0\u0002C\u0001]\u0005}\b\u0002\u0003B\t\u000b\u0011\u0005aFa\u0005\t\u000f\teQ\u0001\"\u0003\u0003\u001c!9!1E\u0003\u0005\n\t\u0015\u0002b\u0002B\u0019\u000b\u0011%!1G\u0001!)&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'O\u0003\u00020a\u0005!A/[3s\u0015\u0005\t\u0014!B6bM.\f7\u0001\u0001\t\u0003i\u0005i\u0011A\f\u0002!)&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'o\u0005\u0002\u0002oA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001a\u0002/5\u000b\u00070\u00138Qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u001cX#A!\u0011\u0005a\u0012\u0015BA\":\u0005\rIe\u000e^\u0001\u0019\u001b\u0006D\u0018J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]N\u00043\u0003B\u00038\r2\u0003\"a\u0012&\u000e\u0003!S!!\u0013\u0019\u0002\u000bU$\u0018\u000e\\:\n\u0005-C%a\u0002'pO\u001eLgn\u001a\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001fB\nq!\\3ue&\u001c7/\u0003\u0002R\u001d\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bCA$U\u0013\t)\u0006JA\u0005TG\",G-\u001e7fe\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u0001-\\\u001b\u0005I&B\u0001.1\u0003\u0019\u0019XM\u001d<fe&\u0011A,\u0017\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003E!\u0018.\u001a:U_BL7mQ8ogVlWM\u001d\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C:\nQ\u0001^8qS\u000eL!a\u00191\u0003#QKWM\u001d+pa&\u001c7i\u001c8tk6,'/A\u0010uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:J]R,'O^1m\u001bN\u0004\"\u0001\u000f4\n\u0005\u001dL$\u0001\u0002'p]\u001e\fQ\u0002^5fe:\u000bW.Z:qC\u000e,\u0007C\u00016r\u001d\tYw\u000e\u0005\u0002ms5\tQN\u0003\u0002oe\u00051AH]8pizJ!\u0001]\u001d\u0002\rA\u0013X\rZ3g\u0013\t\u00118O\u0001\u0004TiJLgn\u001a\u0006\u0003af\nA\u0001^5nKB\u0011ao`\u0007\u0002o*\u0011\u0011\n\u001f\u0006\u0003sj\faaY8n[>t'BA\u0019|\u0015\taX0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0006\u0019qN]4\n\u0007\u0005\u0005qO\u0001\u0003US6,GCDA\u0003\u0003\u000f\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0003i\u0015AQA\u0015\u0007A\u0002MCQA\u0016\u0007A\u0002]CQ!\u0018\u0007A\u0002yCQ\u0001\u001a\u0007A\u0002\u0015DQ\u0001\u001b\u0007A\u0002%DQ\u0001\u001e\u0007A\u0002U\fQ\u0002^5feR{\u0007/[2OC6,WCAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tA\u0001\\1oO*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-C\u0002s\u00037\ta\u0002^5feR{\u0007/[2OC6,\u0007%\u0001\u0005mSN$XM\\3s+\t\tY\u0003E\u00025\u0003[I1!a\f/\u0005}!U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"iC:<W\rT5ti\u0016tWM]\u0001\rY&\u001cH/\u001a8fe~#S-\u001d\u000b\u0005\u0003k\tY\u0004E\u00029\u0003oI1!!\u000f:\u0005\u0011)f.\u001b;\t\u0013\u0005u\u0002#!AA\u0002\u0005-\u0012a\u0001=%c\u0005IA.[:uK:,'\u000fI\u0001\u0010G>|'\u000fZ5oCR|'\u000fV1tWV\u0011\u0011Q\t\u0019\u0005\u0003\u000f\nY\u0006\u0005\u0004\u0002J\u0005M\u0013qK\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005E\u0013qD\u0001\u0005kRLG.\u0003\u0003\u0002V\u0005-#aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0011\t\u0005e\u00131\f\u0007\u0001\t-\ti\u0006FA\u0001\u0002\u0003\u0015\t!!\u0019\u0003\u0007}#\u0013'\u0001\td_>\u0014H-\u001b8bi>\u0014H+Y:lAE!\u00111MA5!\rA\u0014QM\u0005\u0004\u0003OJ$a\u0002(pi\"Lgn\u001a\t\u0004q\u0005-\u0014bAA7s\t\u0019\u0011I\\=\u0002'\r|wN\u001d3j]\u0006$xN\u001d+bg.|F%Z9\u0015\t\u0005U\u00121\u000f\u0005\n\u0003{\u0019\u0012\u0011!a\u0001\u0003k\u0002D!a\u001e\u0002|A1\u0011\u0011JA*\u0003s\u0002B!!\u0017\u0002|\u0011a\u0011QLA:\u0003\u0003\u0005\tQ!\u0001\u0002b\u0005YB.Y:u\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c\u0005.Z2l\u001bN,\u0012!Z\u0001 Y\u0006\u001cH\u000fR3mKR,G\rU1si&$\u0018n\u001c8DQ\u0016\u001c7.T:`I\u0015\fH\u0003BA\u001b\u0003\u000bC\u0001\"!\u0010\u0017\u0003\u0003\u0005\r!Z\u0001\u001dY\u0006\u001cH\u000fR3mKR,G\rU1si&$\u0018n\u001c8DQ\u0016\u001c7.T:!\u00035qW/\\%o!J|wM]3tg\u0006\tb.^7J]B\u0013xn\u001a:fgN|F%Z9\u0015\t\u0005U\u0012q\u0012\u0005\t\u0003{I\u0012\u0011!a\u0001\u0003\u0006qa.^7J]B\u0013xn\u001a:fgN\u0004\u0013\u0001F5n[&<'/\u0019;fIB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002\u0018B9\u0011\u0011TAR\u0003\u0006\u001dVBAAN\u0015\u0011\ti*a(\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011U\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002&\u0006m%aA'baB\u0019A'!+\n\u0007\u0005-fF\u0001\u000fJ[6LwM]1uK\u0012$\u0016.\u001a:U_BL7\rU1si&$\u0018n\u001c8\u0002+%lW.[4sCR,G\rU1si&$\u0018n\u001c8tA\u000591\u000f^1siV\u0004HCAA\u001b\u0003EA\u0017M\u001c3mK&kW.[4sCRLwN\u001c\u000b\u0005\u0003k\t9\f\u0003\u0004\u0002:z\u0001\r!Q\u0001\u0015i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00133\u0002!!\fg\u000e\u001a7f\u000b6LwM]1uS>tG\u0003BA\u001b\u0003\u007fCa!!/ \u0001\u0004\t\u0015\u0001\u0005:fO&\u001cH/\u001a:MSN$XM\\3s)\u0011\t)$!2\t\u000f\u0005\u001d\u0002\u00051\u0001\u0002,\u0005A1\u000f[;uI><h.\u0001\u0004e_^{'o[\u0001\u0016M&tG\rR3mKR,G\rU1si&$\u0018n\u001c8t\u0003=i\u0017m[3Ue\u0006t7/\u001b;j_:\u001c\u0018\u0001G2pY2,7\r\u001e#fY\u0016$X\r\u001a)beRLG/[8ogRA\u00111[As\u0003c\f)\u0010\u0005\u00049\u0003+,\u0017\u0011\\\u0005\u0004\u0003/L$A\u0002+va2,'\u0007\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\u0011\ty.a\b\u0002\u00079Lw.\u0003\u0003\u0002d\u0006u'A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u0011q]\u0013A\u0002\u0005%\u0018A\u0005;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!a;\u0002n6\t\u00010C\u0002\u0002pb\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002t\u0016\u0002\r!Z\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0002x\u0016\u0002\r!!7\u0002\u001f\u0005dGn\\2bi\u0016$')\u001e4gKJ\f\u0011$\\1zE\u0016\u0014UmZ5o\u001b\u0006$XM]5bY&T\u0018\r^5p]\u0006\u0011R.Y=cK\n+w-\u001b8EK2,G/[8o\u0003q!(/Y2l\u0013:LG/[1uKB\u000b'\u000f^5uS>tG)\u001a7fi\u0016$\u0002\"!\u000e\u0003\u0002\t\r!Q\u0002\u0005\u0007\u0003sC\u0003\u0019A!\t\u000f\t\u0015\u0001\u00061\u0001\u0003\b\u0005\u0001B-\u001a7fi\u0016$\u0007+\u0019:uSRLwN\u001c\t\u0004i\t%\u0011b\u0001B\u0006]\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0005\u001fA\u0003\u0019A3\u0002\r=4gm]3u\u0003q!(/Y2l\u0007>l\u0007\u000f\\3uKB\u000b'\u000f^5uS>tG)\u001a7fi\u0016$b!!\u000e\u0003\u0016\t]\u0001BBA]S\u0001\u0007\u0011\tC\u0004\u0003\u0006%\u0002\rAa\u0002\u0002#U\u0004H-\u0019;f'R\f'\u000f^(gMN,G\u000f\u0006\u0004\u00026\tu!q\u0004\u0005\u0007\u0003sS\u0003\u0019A!\t\r\t\u0005\"\u00061\u0001f\u00039qWm^*uCJ$xJ\u001a4tKR\fq\u0004^5feR{\u0007/[2QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5Q_NLG/[8o+\t\u00119\u0003E\u0004k\u0005S\tIOa\u000b\n\u0007\u0005\u00156\u000f\u0005\u00039\u0005[)\u0017b\u0001B\u0018s\t1q\n\u001d;j_:\f\u0001cY1oG\u0016d\u0017J\u001c)s_\u001e\u0014Xm]:\u0015\t\u0005U\"Q\u0007\u0005\b\u0005oa\u0003\u0019\u0001B\u001d\u0003IIg\u000e\u0015:pOJ,7o\u001d#fY\u0016$\u0018n\u001c8\u0011\u0007Q\u0012Y$C\u0002\u0003>9\u0012!#\u00138Qe><'/Z:t\t\u0016dW\r^5p]\u0002")
public class TierDeletedPartitionsCoordinator
implements KafkaMetricsGroup {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TierTopicConsumer tierTopicConsumer;
    private final long tierDeletedPartitionsIntervalMs;
    private final Time time;
    private final String tierTopicName;
    private DeletedPartitionsChangeListener listener;
    private ScheduledFuture<?> coordinatorTask;
    private long lastDeletedPartitionCheckMs;
    private int kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress;
    private final scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int MaxInProgressPartitions() {
        return TierDeletedPartitionsCoordinator$.MODULE$.MaxInProgressPartitions();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private DeletedPartitionsChangeListener listener() {
        return this.listener;
    }

    private void listener_$eq(DeletedPartitionsChangeListener x$1) {
        this.listener = x$1;
    }

    private ScheduledFuture<?> coordinatorTask() {
        return this.coordinatorTask;
    }

    private void coordinatorTask_$eq(ScheduledFuture<?> x$1) {
        this.coordinatorTask = x$1;
    }

    private long lastDeletedPartitionCheckMs() {
        return this.lastDeletedPartitionCheckMs;
    }

    private void lastDeletedPartitionCheckMs_$eq(long x$1) {
        this.lastDeletedPartitionCheckMs = x$1;
    }

    public int kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() {
        return this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress;
    }

    private void kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq(int x$1) {
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress = x$1;
    }

    public scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions() {
        return this.immigratedPartitions;
    }

    public void startup() {
        this.coordinatorTask_$eq(this.scheduler.schedule("tier-deleted-partition-task", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.doWork(), 100L, Math.min(60000L, this.tierDeletedPartitionsIntervalMs), TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - void declaration
     */
    public void handleImmigration(int tierTopicPartitionId) {
        synchronized (this) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            ImmigratedTierTopicPartition immigratedTierTopicPartition = new ImmigratedTierTopicPartition();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            scala.collection.mutable.Map cfr_ignored_0 = (scala.collection.mutable.Map)this.immigratedPartitions().$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y));
            return;
        }
    }

    public synchronized void handleEmigration(int tierTopicPartitionId) {
        Option option = this.immigratedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ImmigratedTierTopicPartition immigratedTierTopicPartition = (ImmigratedTierTopicPartition)foreach_this.get();
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$1(this, immigratedTierTopicPartition);
            return;
        }
    }

    public void registerListener(DeletedPartitionsChangeListener listener) {
        this.listener_$eq(listener);
    }

    public void shutdown() {
        this.coordinatorTask().cancel(false);
        this.removeMetrics$1();
    }

    private void doWork() {
        try {
            long now = this.time.hiResClockMs();
            if (this.lastDeletedPartitionCheckMs() == 0L || now - this.lastDeletedPartitionCheckMs() >= this.tierDeletedPartitionsIntervalMs) {
                this.findDeletedPartitions();
                this.lastDeletedPartitionCheckMs_$eq(now);
            }
            this.makeTransitions();
            return;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught exception in work loop", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    private void findDeletedPartitions() {
        ObjectRef allocatedBuffer = ObjectRef.create((Object)ByteBuffer.allocate(10000));
        this.tierTopicPartitionsWithPosition().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$findDeletedPartitions$1(this, allocatedBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void makeTransitions() {
        this.maybeBeginMaterialization();
        this.maybeBeginDeletion();
    }

    public Tuple2<Object, ByteBuffer> collectDeletedPartitions(TopicPartition tierTopicPartition, long startOffset, ByteBuffer allocatedBuffer) {
        Tuple2 tuple2;
        ByteBuffer buffer = allocatedBuffer;
        Option<AbstractLog> option = this.replicaManager.getLog(tierTopicPartition);
        if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            long lastOffset = log.highWatermark();
            LongRef currentOffset = LongRef.create((long)startOffset);
            while (currentOffset.elem < lastOffset) {
                MemoryRecords memoryRecords;
                AbstractFetchDataInfo abstractFetchDataInfo = log.read(currentOffset.elem, buffer.capacity(), FetchHighWatermark$.MODULE$, true, false);
                if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                    throw new IllegalStateException(new StringBuilder(44).append("Unexpected tiered segment for tier topic in ").append(tierTopicPartition).toString());
                }
                FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                Records records = fetchDataInfo.records();
                if (records instanceof MemoryRecords) {
                    memoryRecords = (MemoryRecords)records;
                } else if (records instanceof FileRecords) {
                    FileRecords fileRecords = (FileRecords)records;
                    buffer.clear();
                    if (buffer.capacity() < fileRecords.sizeInBytes()) {
                        buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
                    }
                    fileRecords.readInto(buffer, 0);
                    memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                } else {
                    throw new MatchError((Object)records);
                }
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memoryRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$1(this, tierTopicPartition, currentOffset, batch);
                    return BoxedUnit.UNIT;
                });
                lastOffset = Math.min(lastOffset, log.highWatermark());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Processed messages in ").append(tierTopicPartition).append(" from offset ").append(startOffset).append(" to ").append(currentOffset$1.elem).toString());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)currentOffset.elem), (Object)buffer);
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)startOffset), (Object)buffer);
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    public synchronized void maybeBeginMaterialization() {
        Iterator immigratedPartitionIt = this.immigratedPartitions().iterator();
        scala.collection.mutable.Map newDeletions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (this.capacity$1() > 0 && immigratedPartitionIt.hasNext()) {
            Tuple2 tuple2 = (Tuple2)immigratedPartitionIt.next();
            if (tuple2 != null) {
                int tierTopicPartitionId = tuple2._1$mcI$sp();
                ImmigratedTierTopicPartition partitionState = (ImmigratedTierTopicPartition)tuple2._2();
                if (!partitionState.inProgressDeletions().isEmpty()) continue;
                scala.collection.mutable.Map<TopicIdPartition, Object> pendingDeletions = partitionState.pendingDeletions();
                List toDelete = ((TraversableOnce)pendingDeletions.take(this.capacity$1())).toList();
                if (toDelete == null) {
                    throw null;
                }
                List foreach_these = toDelete;
                while (!foreach_these.isEmpty()) {
                    Tuple2 tuple22 = (Tuple2)foreach_these.head();
                    TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$1(this, tierTopicPartitionId, partitionState, newDeletions, pendingDeletions, tuple22);
                    foreach_these = (List)foreach_these.tail();
                }
                continue;
            }
            throw new MatchError(null);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Beginning tier partition state materialization for ").append(newDeletions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicIdPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom())).toString());
        this.tierTopicConsumer.register((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(newDeletions).asJava());
    }

    public synchronized void maybeBeginDeletion() {
        this.immigratedPartitions().values().foreach((Function1 & Serializable & scala.Serializable)immigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$1(this, immigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackInitiatePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition, long offset) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Processing InitiateDelete for ").append(deletedPartition).append(" at offset ").append(offset).toString());
        Option option = this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ImmigratedTierTopicPartition immigratedTierTopicPartition = (ImmigratedTierTopicPartition)foreach_this.get();
            TierDeletedPartitionsCoordinator.$anonfun$trackInitiatePartitionDelete$2(deletedPartition, offset, immigratedTierTopicPartition);
        }
    }

    public synchronized void trackCompletePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Processing CompleteDelete for ").append(deletedPartition).toString());
        Option option = this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ImmigratedTierTopicPartition immigratedTierTopicPartition = (ImmigratedTierTopicPartition)foreach_this.get();
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$2(this, deletedPartition, immigratedTierTopicPartition);
            return;
        }
    }

    private synchronized void updateStartOffset(int tierTopicPartitionId, long newStartOffset) {
        Option option = this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ImmigratedTierTopicPartition immigratedTierTopicPartition = (ImmigratedTierTopicPartition)foreach_this.get();
            immigratedTierTopicPartition.lastReadOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)newStartOffset)));
            return;
        }
    }

    private synchronized scala.collection.immutable.Map<TopicPartition, Option<Object>> tierTopicPartitionsWithPosition() {
        return ((TraversableOnce)this.immigratedPartitions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                int tierTopicPartitionId = x0$1._1$mcI$sp();
                ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$1._2();
                Option<Object> option = immigratedPartition.lastReadOffset();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.tierTopicName(), tierTopicPartitionId));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void cancelInProgress(InProgressDeletion inProgressDeletion) {
        this.listener().stopPartitionDeletion(inProgressDeletion.topicIdPartition());
        inProgressDeletion.stopMaterialization();
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq(this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() - 1);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Cancelling segment deletion for ").append(inProgressDeletion.topicIdPartition()).append(" on partition emigration").toString());
        $this.cancelInProgress(inProgressDeletion);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition emigratedPartition) {
        emigratedPartition.inProgressDeletions().values().foreach((Function1 & Serializable & scala.Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    private final void removeMetrics$1() {
        this.removeMetric("TierNumInProgressPartitionDeletions", this.removeMetric$default$2());
        this.removeMetric("TierNumQueuedPartitionDeletions", this.removeMetric$default$2());
    }

    public static final /* synthetic */ long $anonfun$findDeletedPartitions$2() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$findDeletedPartitions$1(TierDeletedPartitionsCoordinator $this, ObjectRef allocatedBuffer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var8_8;
            void var6_7;
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            Option startOffsetOpt = (Option)x0$1._2();
            if (startOffsetOpt == null) {
                throw null;
            }
            Object object = startOffsetOpt.isEmpty() ? BoxesRunTime.boxToLong((long)TierDeletedPartitionsCoordinator.$anonfun$findDeletedPartitions$2()) : startOffsetOpt.get();
            Tuple2<Object, ByteBuffer> tuple2 = $this.collectDeletedPartitions(tierTopicPartition, BoxesRunTime.unboxToLong((Object)object), (ByteBuffer)allocatedBuffer$1.elem);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long endOffset = tuple2._1$mcJ$sp();
            ByteBuffer buffer = (ByteBuffer)tuple2._2();
            $this.updateStartOffset(tierTopicPartition.partition(), (long)var6_7);
            allocatedBuffer$1.elem = var8_8;
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$3(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record$1, AbstractTierMetadata x0$1) {
        if (x0$1 instanceof TierPartitionDeleteInitiate) {
            TierPartitionDeleteInitiate tierPartitionDeleteInitiate = (TierPartitionDeleteInitiate)x0$1;
            $this.trackInitiatePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteInitiate.topicIdPartition(), record$1.offset());
            return;
        }
        if (x0$1 instanceof TierPartitionDeleteComplete) {
            TierPartitionDeleteComplete tierPartitionDeleteComplete = (TierPartitionDeleteComplete)x0$1;
            $this.trackCompletePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteComplete.topicIdPartition());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$2(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(AbstractTierMetadata.deserialize(record.key(), record.value())));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            AbstractTierMetadata abstractTierMetadata = (AbstractTierMetadata)foreach_this.get();
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$3($this, tierTopicPartition$1, record, abstractTierMetadata);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$1(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, LongRef currentOffset$1, MutableRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$2($this, tierTopicPartition$1, record);
            return BoxedUnit.UNIT;
        });
        currentOffset$1.elem = batch.nextOffset();
    }

    private final int capacity$1() {
        return TierDeletedPartitionsCoordinator$.MODULE$.MaxInProgressPartitions() - this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeBeginMaterialization$1(TierDeletedPartitionsCoordinator $this, int tierTopicPartitionId$1, ImmigratedTierTopicPartition partitionState$1, scala.collection.mutable.Map newDeletions$1, scala.collection.mutable.Map pendingDeletions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void $minus$greater$extension_$this;
            void $minus$greater$extension_$this2;
            TopicIdPartition partitionToDelete = (TopicIdPartition)x0$1._1();
            long deleteInitiateOffset = x0$1._2$mcJ$sp();
            InProgressDeletion inProgressDeletion = new InProgressDeletion(tierTopicPartitionId$1, partitionToDelete, deleteInitiateOffset, $this.tierTopicConsumer, InProgressDeletion$.MODULE$.$lessinit$greater$default$5(), InProgressDeletion$.MODULE$.$lessinit$greater$default$6(), InProgressDeletion$.MODULE$.$lessinit$greater$default$7());
            Object object = Predef$.MODULE$.ArrowAssoc((Object)partitionToDelete);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            partitionState$1.inProgressDeletions().$plus$eq(new Tuple2((Object)$minus$greater$extension_$this2, (Object)inProgressDeletion));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)partitionToDelete);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            newDeletions$1.$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)inProgressDeletion));
            pendingDeletions$1.remove((Object)partitionToDelete);
            $this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq($this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() + 1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        DeletionState deletionState = inProgressDeletion.deletionState();
        if (MaterializationComplete$.MODULE$.equals(deletionState)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Beginning segment deletion for ").append(inProgressDeletion.topicIdPartition()).toString());
            inProgressDeletion.awaitDeleteComplete();
            $this.listener().initiatePartitionDeletion(inProgressDeletion.topicIdPartition(), inProgressDeletion.allTieredObjects());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition immigratedPartition) {
        immigratedPartition.inProgressDeletions().values().foreach((Function1 & Serializable & scala.Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$trackInitiatePartitionDelete$2(TopicIdPartition deletedPartition$1, long offset$1, ImmigratedTierTopicPartition tierTopicPartition) {
        if (!tierTopicPartition.inProgressDeletions().contains((Object)deletedPartition$1)) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Long l = BoxesRunTime.boxToLong((long)offset$1);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)deletedPartition$1);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return tierTopicPartition.pendingDeletions().$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$3(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, InProgressDeletion inProgress) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Completed deleting segments for ").append(deletedPartition$2).toString());
        $this.cancelInProgress(inProgress);
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$2(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        immigratedTierTopicPartition.pendingDeletions().$minus$eq((Object)deletedPartition$2);
        Option option = immigratedTierTopicPartition.inProgressDeletions().remove((Object)deletedPartition$2);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            InProgressDeletion inProgressDeletion = (InProgressDeletion)foreach_this.get();
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$3($this, deletedPartition$2, inProgressDeletion);
            return;
        }
    }

    public TierDeletedPartitionsCoordinator(Scheduler scheduler, ReplicaManager replicaManager, TierTopicConsumer tierTopicConsumer, long tierDeletedPartitionsIntervalMs, String tierNamespace, Time time) {
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.tierTopicConsumer = tierTopicConsumer;
        this.tierDeletedPartitionsIntervalMs = tierDeletedPartitionsIntervalMs;
        this.time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.tierTopicName = TierTopic.topicName(tierNamespace);
        this.lastDeletedPartitionCheckMs = 0L;
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress = 0;
        this.immigratedPartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("TierNumInProgressPartitionDeletions", new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("TierNumQueuedPartitionDeletions", new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.immigratedPartitions().values().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$1(x$1)), scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }

            public static final /* synthetic */ long $anonfun$value$1(ImmigratedTierTopicPartition x$1) {
                return x$1.pendingDeletions().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.tier.ImmigratedTierTopicPartition )}, serializedLambda);
            }
        }, this.newGauge$default$3());
    }

    public static final /* synthetic */ Object $anonfun$handleEmigration$1$adapted(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition emigratedPartition) {
        TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$1($this, emigratedPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maybeBeginMaterialization$1$adapted(TierDeletedPartitionsCoordinator $this, int tierTopicPartitionId$1, ImmigratedTierTopicPartition partitionState$1, scala.collection.mutable.Map newDeletions$1, scala.collection.mutable.Map pendingDeletions$1, Tuple2 x0$1) {
        TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$1($this, tierTopicPartitionId$1, partitionState$1, newDeletions$1, pendingDeletions$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$trackCompletePartitionDelete$2$adapted(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$2($this, deletedPartition$2, immigratedTierTopicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$updateStartOffset$1$adapted(long newStartOffset$1, ImmigratedTierTopicPartition x$4) {
        x$4.lastReadOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)newStartOffset$1)));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$collectDeletedPartitions$3$adapted(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record$1, AbstractTierMetadata x0$1) {
        TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$3($this, tierTopicPartition$1, record$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$trackCompletePartitionDelete$3$adapted(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, InProgressDeletion inProgress) {
        TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$3($this, deletedPartition$2, inProgress);
        return BoxedUnit.UNIT;
    }
}

