/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001\u0002\u000e\u001c\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\tC\u0003J\u0001\u0011\u0005!\nC\u0004Q\u0001\t\u0007I\u0011B)\t\ry\u0003\u0001\u0015!\u0003S\u0011\u001dy\u0006\u00011A\u0005\n\u0001Dq\u0001\u001c\u0001A\u0002\u0013%Q\u000e\u0003\u0004t\u0001\u0001\u0006K!\u0019\u0005\u0006i\u0002!\t!\u001e\u0005\u0006y\u0002!\t! \u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u0013Bq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002(!9\u00111\r\u0001\u0005\n\u0005%\u0003bBA3\u0001\u0011%\u0011q\r\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3\u000b\u0005qi\u0012!B3q_\u000eD'B\u0001\u0010 \u0003\u0019\u0019XM\u001d<fe*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003U5j\u0011a\u000b\u0006\u0003Y}\tQ!\u001e;jYNL!AL\u0016\u0003\u000f1{wmZ5oO\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u0019:\u001b\u0005\u0011$BA\u001a5\u0003\u0019\u0019w.\\7p]*\u0011\u0001%\u000e\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014x-\u0003\u0002;e\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u00047pO\u0016sGm\u00144gg\u0016$\bc\u0001\u0013>\u007f%\u0011a(\n\u0002\n\rVt7\r^5p]B\u0002\"\u0001\n!\n\u0005\u0005+#\u0001\u0002'p]\u001e\f!b\u00195fG.\u0004x.\u001b8u!\t!u)D\u0001F\u0015\t1U$A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018B\u0001%F\u0005UaU-\u00193fe\u0016\u0003xn\u00195DQ\u0016\u001c7\u000e]8j]R\fa\u0001P5oSRtD\u0003B&N\u001d>\u0003\"\u0001\u0014\u0001\u000e\u0003mAQa\f\u0003A\u0002ABQa\u000f\u0003A\u0002qBQA\u0011\u0003A\u0002\r\u000bA\u0001\\8dWV\t!\u000b\u0005\u0002T96\tAK\u0003\u0002V-\u0006)An\\2lg*\u0011q\u000bW\u0001\u000bG>t7-\u001e:sK:$(BA-[\u0003\u0011)H/\u001b7\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0016\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006)An\\2lA\u00051Q\r]8dQN,\u0012!\u0019\t\u0004E\u001eLW\"A2\u000b\u0005\u0011,\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003M\u0016\n!bY8mY\u0016\u001cG/[8o\u0013\tA7MA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u0001'k\u0013\tY7D\u0001\u0006Fa>\u001c\u0007.\u00128uef\f!\"\u001a9pG\"\u001cx\fJ3r)\tq\u0017\u000f\u0005\u0002%_&\u0011\u0001/\n\u0002\u0005+:LG\u000fC\u0004s\u0011\u0005\u0005\t\u0019A1\u0002\u0007a$\u0013'A\u0004fa>\u001c\u0007n\u001d\u0011\u0002\t\u0019LG.Z\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u0011PW\u0001\u0003S>L!a\u001f=\u0003\t\u0019KG.Z\u0001\u0007CN\u001c\u0018n\u001a8\u0015\t9t\u0018Q\u0001\u0005\u00069-\u0001\ra \t\u0004I\u0005\u0005\u0011bAA\u0002K\t\u0019\u0011J\u001c;\t\r\u0005\u001d1\u00021\u0001@\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0002#Q\u0014XO\\2bi\u0016\fe\u000eZ!qa\u0016tG\rF\u0002o\u0003\u001bAa!a\u0004\r\u0001\u0004I\u0017!D3oiJLHk\\!qa\u0016tG-\u0001\u0005o_:,U\u000e\u001d;z+\t\t)\u0002E\u0002%\u0003/I1!!\u0007&\u0005\u001d\u0011un\u001c7fC:\f1\u0002\\1uKN$X\t]8dQV\u0011\u0011q\u0004\t\u0005I\u0005\u0005r0C\u0002\u0002$\u0015\u0012aa\u00149uS>t\u0017!D3be2LWm\u001d;F]R\u0014\u00180\u0006\u0002\u0002*A!A%!\tj\u00031)g\u000eZ(gMN,GOR8s)\u0011\ty#!\u000e\u0011\u000b\u0011\n\td` \n\u0007\u0005MRE\u0001\u0004UkBdWM\r\u0005\u0007\u0003o\u0001\u0002\u0019A@\u0002\u001dI,\u0017/^3ti\u0016$W\t]8dQ\u0006yAO];oG\u0006$XM\u0012:p[\u0016sG\rF\u0002o\u0003{Aa!a\u0010\u0012\u0001\u0004y\u0014!C3oI>3gm]3u\u0003E!(/\u001e8dCR,gI]8n'R\f'\u000f\u001e\u000b\u0004]\u0006\u0015\u0003BBA\u0004%\u0001\u0007q(A\u0007dY\u0016\f'/\u00118e\r2,8\u000f\u001b\u000b\u0002]\u0006)1\r\\3be\u0006)1\r\\8oKR\u00191*!\u0015\t\r\u0005MS\u00031\u0001D\u00035qWm^\"iK\u000e\\\u0007o\\5oi\u0006aQ\r]8dQ\u0016sGO]5fgV\u0011\u0011\u0011\f\t\u0006\u00037\ni&[\u0007\u0002K&\u0019\u0011qL3\u0003\u0007M+\u0017/A\u0006mCR,7\u000f^#oiJL\u0018!\u00024mkND\u0017\u0001\u0006<bY&$\u0017\r^3B]\u0012l\u0015-\u001f2f/\u0006\u0014h\u000eF\u0002o\u0003SBa!a\u001b\u001a\u0001\u0004I\u0017!B3oiJL\b")
public class LeaderEpochFileCache
implements Logging {
    private final TopicPartition topicPartition;
    private final Function0<Object> logEndOffset;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private ArrayBuffer<EpochEntry> epochs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ArrayBuffer<EpochEntry> epochs() {
        return this.epochs;
    }

    private void epochs_$eq(ArrayBuffer<EpochEntry> x$1) {
        this.epochs = x$1;
    }

    public File file() {
        return this.checkpoint.file();
    }

    /*
     * WARNING - void declaration
     */
    public void assign(int epoch, long startOffset) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$assign$1(this, epoch, startOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void truncateAndAppend(EpochEntry entryToAppend) {
        void var4_4;
        void var3_3;
        this.validateAndMaybeWarn(entryToAppend);
        Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateAndAppend$1(entryToAppend, entry)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ArrayBuffer retainedEpochs = (ArrayBuffer)tuple2._1();
        ArrayBuffer removedEpochs = (ArrayBuffer)tuple2._2();
        void retainedEpochs2 = var3_3;
        void removedEpochs2 = var4_4;
        this.epochs_$eq((ArrayBuffer<EpochEntry>)((ArrayBuffer)retainedEpochs2.$colon$plus((Object)entryToAppend, ArrayBuffer$.MODULE$.canBuildFrom())));
        if (removedEpochs2.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entryToAppend).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
            return;
        }
        if (removedEpochs2.size() > 1 || ((EpochEntry)removedEpochs2.head()).startOffset() != entryToAppend.startOffset()) {
            this.warn((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$truncateAndAppend$3(this, entryToAppend, (ArrayBuffer)removedEpochs2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean nonEmpty() {
        boolean bl;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$nonEmpty$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Option<Object> latestEpoch() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$latestEpoch$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Option<EpochEntry> earliestEntry() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$earliestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch) {
        Tuple2 tuple2;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            tuple2 = LeaderEpochFileCache.$anonfun$endOffsetFor$1(this, requestedEpoch);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromEnd(long endOffset) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromEnd$1(this, endOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromStart(long startOffset) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromStart$1(this, startOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clearAndFlush() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clearAndFlush$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clear() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clear$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public LeaderEpochFileCache clone(LeaderEpochCheckpoint newCheckpoint) {
        LeaderEpochFileCache leaderEpochFileCache;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            leaderEpochFileCache = LeaderEpochFileCache.$anonfun$clone$1(this, newCheckpoint);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return leaderEpochFileCache;
    }

    public Seq<EpochEntry> epochEntries() {
        return this.epochs();
    }

    private Option<EpochEntry> latestEntry() {
        return this.epochs().lastOption();
    }

    private void flush() {
        this.checkpoint.write((Seq<EpochEntry>)this.epochs());
    }

    private void validateAndMaybeWarn(EpochEntry entry) {
        if (entry.epoch() < 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        Option<EpochEntry> option = this.latestEntry();
        if (option == null) {
            throw null;
        }
        Option<EpochEntry> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            EpochEntry epochEntry = (EpochEntry)foreach_this.get();
            LeaderEpochFileCache.$anonfun$validateAndMaybeWarn$1(this, entry, epochEntry);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$assign$1(LeaderEpochFileCache $this, int epoch$1, long startOffset$1) {
        EpochEntry lastEntry;
        if ($this.epochs().isEmpty() ? true : (lastEntry = (EpochEntry)$this.epochs().last()).epoch() != epoch$1 || startOffset$1 < lastEntry.startOffset()) {
            $this.truncateAndAppend(new EpochEntry(epoch$1, startOffset$1));
            $this.flush();
        }
    }

    public static final /* synthetic */ boolean $anonfun$truncateAndAppend$1(EpochEntry entryToAppend$1, EpochEntry entry) {
        return entry.epoch() < entryToAppend$1.epoch() && entry.startOffset() < entryToAppend$1.startOffset();
    }

    public static final /* synthetic */ String $anonfun$truncateAndAppend$3(LeaderEpochFileCache $this, EpochEntry entryToAppend$1, ArrayBuffer removedEpochs$1) {
        return new StringBuilder(88).append("New epoch entry ").append(entryToAppend$1).append(" caused truncation of conflicting entries ").append(removedEpochs$1).append(". ").append("Cache now contains ").append($this.epochs().size()).append(" entries.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$nonEmpty$1(LeaderEpochFileCache $this) {
        return $this.epochs().nonEmpty();
    }

    public static final /* synthetic */ Option $anonfun$latestEpoch$1(LeaderEpochFileCache $this) {
        Option option = $this.epochs().lastOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((EpochEntry)map_this.get()).epoch()));
        return object;
    }

    public static final /* synthetic */ Option $anonfun$earliestEntry$1(LeaderEpochFileCache $this) {
        return $this.epochs().headOption();
    }

    public static final /* synthetic */ boolean $anonfun$endOffsetFor$2(int requestedEpoch$1, EpochEntry e) {
        return e.epoch() > requestedEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$3(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(103).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$endOffsetFor$1(LeaderEpochFileCache $this, int requestedEpoch$1) {
        void var2_7;
        Tuple2.mcIJ.sp sp2;
        if (requestedEpoch$1 == -1) {
            sp2 = new Tuple2.mcIJ.sp(-1, -1L);
        } else if ($this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch$1))) {
            sp2 = new Tuple2.mcIJ.sp(requestedEpoch$1, $this.logEndOffset.apply$mcJ$sp());
        } else {
            void var5_4;
            void var4_3;
            Tuple2 tuple2 = $this.epochs().partition((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$endOffsetFor$2(requestedEpoch$1, e)));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ArrayBuffer subsequentEpochs = (ArrayBuffer)tuple2._1();
            ArrayBuffer previousEpochs = (ArrayBuffer)tuple2._2();
            void subsequentEpochs2 = var4_3;
            void previousEpochs2 = var5_4;
            sp2 = subsequentEpochs2.isEmpty() ? new Tuple2.mcIJ.sp(-1, -1L) : (previousEpochs2.isEmpty() ? new Tuple2.mcIJ.sp(requestedEpoch$1, ((EpochEntry)subsequentEpochs2.head()).startOffset()) : new Tuple2.mcIJ.sp(((EpochEntry)previousEpochs2.last()).epoch(), ((EpochEntry)subsequentEpochs2.head()).startOffset()));
        }
        Tuple2.mcIJ.sp epochAndOffset = sp2;
        $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$3($this, requestedEpoch$1, (Tuple2)epochAndOffset)));
        return var2_7;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$4) {
        return x$4.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$5) {
        return x$5.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ String $anonfun$truncateFromEnd$4(LeaderEpochFileCache $this, ArrayBuffer subsequentEntries$1, long endOffset$1) {
        return new StringBuilder(97).append("Cleared entries ").append(subsequentEntries$1).append(" from epoch cache after ").append("truncating to end offset ").append(endOffset$1).append(", leaving ").append($this.epochs().size()).append(" entries in the cache.").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$truncateFromEnd$1(LeaderEpochFileCache $this, long endOffset$1) {
        if (endOffset$1 >= 0L) {
            EpochEntry epochEntry;
            Option<EpochEntry> option = $this.latestEntry();
            if (option == null) {
                throw null;
            }
            Option<EpochEntry> exists_this = option;
            boolean bl = !exists_this.isEmpty() && LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset$1, epochEntry = (EpochEntry)exists_this.get());
            if (bl) {
                void var5_7;
                void var4_6;
                Tuple2 tuple2 = $this.epochs().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, x$5)));
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                ArrayBuffer subsequentEntries = (ArrayBuffer)tuple2._1();
                ArrayBuffer previousEntries = (ArrayBuffer)tuple2._2();
                void subsequentEntries2 = var4_6;
                void previousEntries2 = var5_7;
                $this.epochs_$eq((ArrayBuffer<EpochEntry>)previousEntries2);
                $this.flush();
                $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$truncateFromEnd$4($this, (ArrayBuffer)subsequentEntries2, endOffset$1)));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$2, EpochEntry x$7) {
        return x$7.startOffset() > startOffset$2;
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$2, ArrayBuffer subsequentEntries$2, ArrayBuffer previousEntries$1, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$2);
        $this.epochs_$eq((ArrayBuffer<EpochEntry>)((ArrayBuffer)subsequentEntries$2.$plus$colon((Object)updatedFirstEntry, ArrayBuffer$.MODULE$.canBuildFrom())));
        $this.flush();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Cleared entries ").append(previousEntries$1).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").append("truncating to start offset ").append(startOffset$2).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$truncateFromStart$1(LeaderEpochFileCache $this, long startOffset$2) {
        if ($this.epochs().nonEmpty()) {
            void var5_4;
            void var4_3;
            Tuple2 tuple2 = $this.epochs().partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$2, x$7)));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ArrayBuffer subsequentEntries = (ArrayBuffer)tuple2._1();
            ArrayBuffer previousEntries = (ArrayBuffer)tuple2._2();
            void subsequentEntries2 = var4_3;
            void previousEntries2 = var5_4;
            Option option = previousEntries2.lastOption();
            if (option == null) {
                throw null;
            }
            Option foreach_this = option;
            if (!foreach_this.isEmpty()) {
                EpochEntry epochEntry = (EpochEntry)foreach_this.get();
                LeaderEpochFileCache.$anonfun$truncateFromStart$3($this, startOffset$2, (ArrayBuffer)subsequentEntries2, (ArrayBuffer)previousEntries2, epochEntry);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$clearAndFlush$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this.flush();
    }

    public static final /* synthetic */ void $anonfun$clear$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
    }

    public static final /* synthetic */ LeaderEpochFileCache $anonfun$clone$1(LeaderEpochFileCache $this, LeaderEpochCheckpoint newCheckpoint$1) {
        newCheckpoint$1.write((Seq<EpochEntry>)$this.epochs());
        return new LeaderEpochFileCache($this.topicPartition, $this.logEndOffset, newCheckpoint$1);
    }

    public static final /* synthetic */ void $anonfun$validateAndMaybeWarn$1(LeaderEpochFileCache $this, EpochEntry entry$1, EpochEntry latest) {
        if (entry$1.epoch() < latest.epoch()) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(143).append("Received leader epoch assignment ").append(entry$1).append(" which has an epoch less than the epoch ").append("of the latest entry ").append(latest).append(". This implies messages have arrived out of order.").toString());
            return;
        }
        if (entry$1.startOffset() < latest.startOffset()) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(171).append("Received leader epoch assignment ").append(entry$1).append(" which has a starting offset which is less than ").append("the starting offset of the latest entry ").append(latest).append(". This implies messages have arrived out of order.").toString());
        }
    }

    public LeaderEpochFileCache(TopicPartition topicPartition, Function0<Object> logEndOffset, LeaderEpochCheckpoint checkpoint) {
        this.topicPartition = topicPartition;
        this.logEndOffset = logEndOffset;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.lock = new ReentrantReadWriteLock();
        this.epochs = (ArrayBuffer)CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Seq<EpochEntry> read = $this.checkpoint.read();
            return new ArrayBuffer(read.size()).$plus$plus$eq(read);
        });
    }

    public static final /* synthetic */ Object $anonfun$validateAndMaybeWarn$1$adapted(LeaderEpochFileCache $this, EpochEntry entry$1, EpochEntry latest) {
        LeaderEpochFileCache.$anonfun$validateAndMaybeWarn$1($this, entry$1, latest);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$latestEpoch$2$adapted(EpochEntry x$2) {
        return BoxesRunTime.boxToInteger((int)x$2.epoch());
    }

    public static final /* synthetic */ Object $anonfun$truncateFromEnd$2$adapted(long endOffset$1, EpochEntry x$4) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset$1, x$4));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$3$adapted(LeaderEpochFileCache $this, long startOffset$2, ArrayBuffer subsequentEntries$2, ArrayBuffer previousEntries$1, EpochEntry firstBeforeStartOffset) {
        LeaderEpochFileCache.$anonfun$truncateFromStart$3($this, startOffset$2, subsequentEntries$2, previousEntries$1, firstBeforeStartOffset);
        return BoxedUnit.UNIT;
    }
}

