/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.EndPoint;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType;
import kafka.server.QuotaType$AlterLogDirsReplication$;
import kafka.server.QuotaType$Fetch$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$LeaderReplication$;
import kafka.server.QuotaType$Produce$;
import kafka.server.QuotaType$Request$;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class QuotaFactory$
implements Logging {
    public static QuotaFactory$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new QuotaFactory$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix) {
        Option clientQuotaCallback = Option$.MODULE$.apply(cfg.getConfiguredInstance(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), ClientQuotaCallback.class));
        None$ activeTenantsManager = this.isMultiTenant(cfg) ? Option$.MODULE$.apply((Object)new ActiveTenantsManager(metrics, time, BrokerBackpressureConfig$.MODULE$.DefaultActiveWindowMs())) : None$.MODULE$;
        return new QuotaFactory.QuotaManagers(new ClientQuotaManager(this.clientFetchConfig(cfg), metrics, QuotaType$Fetch$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager), new ClientQuotaManager(this.clientProduceConfig(cfg), metrics, QuotaType$Produce$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager), new ClientRequestQuotaManager(this.clientRequestConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$LeaderReplication$.MODULE$, time), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$FollowerReplication$.MODULE$, time), new ReplicationQuotaManager(this.alterLogDirsReplicationConfig(cfg), metrics, QuotaType$AlterLogDirsReplication$.MODULE$, time), (Option<ClientQuotaCallback>)clientQuotaCallback);
    }

    public ClientQuotaManagerConfig clientProduceConfig(KafkaConfig cfg) {
        if (!BoxesRunTime.equalsNumObject((Number)cfg.producerQuotaBytesPerSecondDefault(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)) && this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(this.msgWithLogIdent(QuotaFactory$.$anonfun$clientProduceConfig$1()));
        }
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.producerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()), this.brokerBackpressureConfig(cfg, QuotaType$Produce$.MODULE$));
    }

    public ClientQuotaManagerConfig clientFetchConfig(KafkaConfig cfg) {
        if (!BoxesRunTime.equalsNumObject((Number)cfg.consumerQuotaBytesPerSecondDefault(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)) && this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(this.msgWithLogIdent(QuotaFactory$.$anonfun$clientFetchConfig$1()));
        }
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.consumerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()), this.brokerBackpressureConfig(cfg, QuotaType$Fetch$.MODULE$));
    }

    public ClientQuotaManagerConfig clientRequestConfig(KafkaConfig cfg) {
        int x$1 = Predef$.MODULE$.Integer2int(cfg.numQuotaSamples());
        int x$2 = Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds());
        BrokerBackpressureConfig x$3 = this.brokerBackpressureConfig(cfg, QuotaType$Request$.MODULE$);
        long x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ClientQuotaManagerConfig(x$4, x$1, x$2, x$3);
    }

    public ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg) {
        int x$1 = Predef$.MODULE$.Integer2int(cfg.numReplicationQuotaSamples());
        int x$2 = Predef$.MODULE$.Integer2int(cfg.replicationQuotaWindowSizeSeconds());
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ReplicationQuotaManagerConfig(x$3, x$1, x$2);
    }

    public ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        int x$1 = Predef$.MODULE$.Integer2int(cfg.numAlterLogDirsReplicationQuotaSamples());
        int x$2 = Predef$.MODULE$.Integer2int(cfg.alterLogDirsReplicationQuotaWindowSizeSeconds());
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ReplicationQuotaManagerConfig(x$3, x$1, x$2);
    }

    public boolean isMultiTenant(KafkaConfig cfg) {
        Option option = Option$.MODULE$.apply((Object)cfg.originalsStrings().get(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp()));
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((String)map_this.get()).toString());
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? QuotaFactory$.$anonfun$isMultiTenant$2() : object.get();
        return ((String)object2).contains("io.confluent.kafka.multitenant.quota.TenantQuotaCallback");
    }

    public boolean backpressureEnabledInConfig(KafkaConfig cfg, QuotaType quotaType) {
        if (this.isMultiTenant(cfg)) {
            String string;
            Option option = Option$.MODULE$.apply((Object)cfg.getString("confluent.backpressure.types"));
            if (option == null) {
                throw null;
            }
            Option exists_this = option;
            boolean bl = !exists_this.isEmpty() && QuotaFactory$.$anonfun$backpressureEnabledInConfig$1(quotaType, string = (String)exists_this.get());
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public BrokerBackpressureConfig brokerBackpressureConfig(KafkaConfig cfg, QuotaType quotaType) {
        Seq seq;
        boolean backpressureEnabled = this.backpressureEnabledInConfig(cfg, quotaType);
        if (QuotaType$Request$.MODULE$.equals(quotaType)) {
            Option option = Option$.MODULE$.apply((Object)cfg.getString("confluent.multitenant.listener.names"));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)CoreUtils$.MODULE$.parseCsvList((String)map_this.get()));
            if (object == null) {
                throw null;
            }
            Object object2 = object.isEmpty() ? QuotaFactory$.$anonfun$brokerBackpressureConfig$2() : object.get();
            Seq listeners = (Seq)((TraversableLike)object2).filter((Function1 & Serializable & scala.Serializable)listenerName -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$brokerBackpressureConfig$3(cfg, listenerName)));
            if (listeners.isEmpty() && backpressureEnabled && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(QuotaFactory$.$anonfun$brokerBackpressureConfig$5()));
            }
            seq = listeners;
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        double x$3 = Predef$.MODULE$.Integer2int(cfg.queuedMaxRequests());
        long x$4 = BrokerBackpressureConfig$.MODULE$.apply$default$2();
        return new BrokerBackpressureConfig(backpressureEnabled, x$4, (Seq<String>)seq, x$3);
    }

    public static final /* synthetic */ String $anonfun$clientProduceConfig$1() {
        return new StringBuilder(109).append(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp()).append(" has been deprecated in 0.11.0.0 and will be removed in a future release. Use dynamic quota defaults instead.").toString();
    }

    public static final /* synthetic */ String $anonfun$clientFetchConfig$1() {
        return new StringBuilder(109).append(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp()).append(" has been deprecated in 0.11.0.0 and will be removed in a future release. Use dynamic quota defaults instead.").toString();
    }

    public static final /* synthetic */ String $anonfun$isMultiTenant$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$backpressureEnabledInConfig$2(QuotaType quotaType$1, String backpressureType) {
        String string = backpressureType;
        String string2 = quotaType$1.toString().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$backpressureEnabledInConfig$1(QuotaType quotaType$1, String backpressureTypeProp) {
        return CoreUtils$.MODULE$.parseCsvList(backpressureTypeProp).exists((Function1 & Serializable & scala.Serializable)backpressureType -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$backpressureEnabledInConfig$2(quotaType$1, backpressureType)));
    }

    public static final /* synthetic */ Seq $anonfun$brokerBackpressureConfig$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$brokerBackpressureConfig$4(String listenerName$1, EndPoint endpoint) {
        String string = endpoint.listenerName().value();
        return !(string != null ? !string.equals(listenerName$1) : listenerName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$brokerBackpressureConfig$3(KafkaConfig cfg$1, String listenerName) {
        return cfg$1.advertisedListeners().exists((Function1 & Serializable & scala.Serializable)endpoint -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$brokerBackpressureConfig$4(listenerName, endpoint)));
    }

    public static final /* synthetic */ String $anonfun$brokerBackpressureConfig$5() {
        return "Invalid multitenant listener names provided in config. Request backpressure will be disabled";
    }

    private QuotaFactory$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$backpressureEnabledInConfig$1$adapted(QuotaType quotaType$1, String backpressureTypeProp) {
        return BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$backpressureEnabledInConfig$1(quotaType$1, backpressureTypeProp));
    }
}

