/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsReporter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class KafkaServer$ {
    public static KafkaServer$ MODULE$;
    private final long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    private final String MULTI_TENANT_AUTHORIZER_CLASS_NAME;

    static {
        new KafkaServer$();
    }

    public Time $lessinit$greater$default$2() {
        return Time.SYSTEM;
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Seq<KafkaMetricsReporter> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> copyKafkaConfigToLog(KafkaConfig kafkaConfig) {
        void var2_2;
        HashMap<String, Object> logProps = new HashMap<String, Object>();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), kafkaConfig.logSegmentBytes());
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), kafkaConfig.logRollTimeMillis());
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), kafkaConfig.logRollTimeJitterMillis());
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), kafkaConfig.logIndexSizeMaxBytes());
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), kafkaConfig.logFlushIntervalMessages());
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), kafkaConfig.logFlushIntervalMs());
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), kafkaConfig.logRetentionBytes());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.long2Long(kafkaConfig.logRetentionTimeMillis()));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), kafkaConfig.messageMaxBytes());
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), kafkaConfig.logIndexIntervalBytes());
        logProps.put(LogConfig$.MODULE$.DeleteRetentionMsProp(), kafkaConfig.logCleanerDeleteRetentionMs());
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), kafkaConfig.logCleanerMinCompactionLagMs());
        logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), kafkaConfig.logCleanerMaxCompactionLagMs());
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), kafkaConfig.logDeleteDelayMs());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), kafkaConfig.logCleanerMinCleanRatio());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), kafkaConfig.logCleanupPolicy());
        logProps.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), kafkaConfig.minInSyncReplicas());
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), kafkaConfig.compressionType());
        logProps.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), kafkaConfig.uncleanLeaderElectionEnable());
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), kafkaConfig.logPreAllocateEnable());
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), kafkaConfig.logMessageFormatVersion().version());
        logProps.put(LogConfig$.MODULE$.MessageTimestampTypeProp(), kafkaConfig.logMessageTimestampType().name);
        logProps.put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Predef$.MODULE$.long2Long(kafkaConfig.logMessageTimestampDifferenceMaxMs()));
        logProps.put(LogConfig$.MODULE$.MessageDownConversionEnableProp(), Predef$.MODULE$.boolean2Boolean(kafkaConfig.logMessageDownConversionEnable()));
        logProps.put(LogConfig$.MODULE$.TierEnableProp(), kafkaConfig.tierEnable());
        logProps.put(LogConfig$.MODULE$.TierLocalHotsetBytesProp(), kafkaConfig.tierLocalHotsetBytes());
        logProps.put(LogConfig$.MODULE$.TierLocalHotsetMsProp(), kafkaConfig.tierLocalHotsetMs());
        logProps.put(LogConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp(), kafkaConfig.tierSegmentHotsetRollMinBytes());
        logProps.put(LogConfig$.MODULE$.PreferTierFetchMsProp(), kafkaConfig.preferTierFetchMs());
        logProps.put(LogConfig$.MODULE$.SegmentSpeculativePrefetchEnableProp(), kafkaConfig.segmentSpeculativePrefetchEnable());
        logProps.put(LogConfig$.MODULE$.AppendRecordInterceptorClassesProp(), kafkaConfig.getList(KafkaConfig$.MODULE$.AppendRecordInterceptorClassesProp()));
        logProps.computeIfAbsent("confluent.schema.registry.url", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.schema.registry.url");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.basic.auth.credentials.source", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.basic.auth.credentials.source");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.basic.auth.user.info", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public Object apply(String t) {
                void orNull_ev;
                Option option = Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.basic.auth.user.info"));
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)anon.3.$anonfun$apply$1((Password)map_this.get()));
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (object == null) {
                    throw null;
                }
                Object object2 = object.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : object.get();
                return object2;
            }

            public static final /* synthetic */ String $anonfun$apply$1(Password x$1) {
                return x$1.value();
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(org.apache.kafka.common.config.types.Password )}, serializedLambda);
            }
        });
        logProps.computeIfAbsent("confluent.bearer.auth.credentials.source", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.bearer.auth.credentials.source");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.bearer.auth.token", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public Object apply(String t) {
                void orNull_ev;
                Option option = Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.bearer.auth.token"));
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)anon.5.$anonfun$apply$2((Password)map_this.get()));
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (object == null) {
                    throw null;
                }
                Object object2 = object.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : object.get();
                return object2;
            }

            public static final /* synthetic */ String $anonfun$apply$2(Password x$2) {
                return x$2.value();
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$2(org.apache.kafka.common.config.types.Password )}, serializedLambda);
            }
        });
        logProps.computeIfAbsent("confluent.ssl.protocol", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.protocol");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.keystore.type", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.keystore.type");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.keystore.location", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.keystore.location");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.keystore.password", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public Object apply(String t) {
                void orNull_ev;
                Option option = Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.ssl.keystore.password"));
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)anon.9.$anonfun$apply$3((Password)map_this.get()));
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (object == null) {
                    throw null;
                }
                Object object2 = object.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : object.get();
                return object2;
            }

            public static final /* synthetic */ String $anonfun$apply$3(Password x$3) {
                return x$3.value();
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$3(org.apache.kafka.common.config.types.Password )}, serializedLambda);
            }
        });
        logProps.computeIfAbsent("confluent.ssl.key.password", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public Object apply(String t) {
                void orNull_ev;
                Option option = Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.ssl.key.password"));
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)anon.10.$anonfun$apply$4((Password)map_this.get()));
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (object == null) {
                    throw null;
                }
                Object object2 = object.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : object.get();
                return object2;
            }

            public static final /* synthetic */ String $anonfun$apply$4(Password x$4) {
                return x$4.value();
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$4(org.apache.kafka.common.config.types.Password )}, serializedLambda);
            }
        });
        logProps.computeIfAbsent("confluent.ssl.truststore.type", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.truststore.type");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.truststore.location", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Object apply(String t) {
                return this.kafkaConfig$1.getString("confluent.ssl.truststore.location");
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        });
        logProps.computeIfAbsent("confluent.ssl.truststore.password", new Function<String, Object>(kafkaConfig){
            private final KafkaConfig kafkaConfig$1;

            public <V> Function<V, Object> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Object, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public Object apply(String t) {
                void orNull_ev;
                Option option = Option$.MODULE$.apply((Object)this.kafkaConfig$1.getPassword("confluent.ssl.truststore.password"));
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)anon.13.$anonfun$apply$5((Password)map_this.get()));
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (object == null) {
                    throw null;
                }
                Object object2 = object.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : object.get();
                return object2;
            }

            public static final /* synthetic */ String $anonfun$apply$5(Password x$5) {
                return x$5.value();
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$5(org.apache.kafka.common.config.types.Password )}, serializedLambda);
            }
        });
        return var2_2;
    }

    public void augmentWithKafkaConfig(Map<String, Object> logProps, KafkaConfig kafkaConfig) {
        if (kafkaConfig != null) {
            logProps.put("confluent.schema.registry.max.cache.size", kafkaConfig.getInt("confluent.schema.registry.max.cache.size"));
            logProps.put("confluent.schema.registry.max.retries", kafkaConfig.getInt("confluent.schema.registry.max.retries"));
            logProps.put("confluent.schema.registry.retries.wait.ms", kafkaConfig.getInt("confluent.schema.registry.retries.wait.ms"));
            logProps.put("confluent.missing.id.query.range", kafkaConfig.getInt("confluent.missing.id.query.range"));
            logProps.put("confluent.missing.id.cache.ttl.sec", kafkaConfig.getLong("confluent.missing.id.cache.ttl.sec"));
            logProps.put("confluent.missing.schema.cache.ttl.sec", kafkaConfig.getLong("confluent.missing.schema.cache.ttl.sec"));
        }
    }

    public MetricConfig metricConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public Option<ZKClientConfig> zkClientConfigFromKafkaConfig(KafkaConfig config, boolean forceZkSslClientEnable) {
        if (!config.zkSslClientEnable() && !forceZkSslClientEnable) {
            return None$.MODULE$;
        }
        ZKClientConfig clientConfig = new ZKClientConfig();
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "true");
        Option<String> option = config.zkClientCnxnSocketClassName();
        if (option == null) {
            throw null;
        }
        Option<String> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            String string = (String)foreach_this.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkClientCnxnSocketProp(), string);
        }
        Option<String> option2 = config.zkSslKeyStoreLocation();
        if (option2 == null) {
            throw null;
        }
        Option<String> foreach_this2 = option2;
        if (!foreach_this2.isEmpty()) {
            String string = (String)foreach_this2.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp(), string);
        }
        Option<Password> option3 = config.zkSslKeyStorePassword();
        if (option3 == null) {
            throw null;
        }
        Option<Password> foreach_this3 = option3;
        if (!foreach_this3.isEmpty()) {
            Password password = (Password)foreach_this3.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp(), password.value());
        }
        Option<String> option4 = config.zkSslKeyStoreType();
        if (option4 == null) {
            throw null;
        }
        Option<String> foreach_this4 = option4;
        if (!foreach_this4.isEmpty()) {
            String string = (String)foreach_this4.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp(), string);
        }
        Option<String> option5 = config.zkSslTrustStoreLocation();
        if (option5 == null) {
            throw null;
        }
        Option<String> foreach_this5 = option5;
        if (!foreach_this5.isEmpty()) {
            String string = (String)foreach_this5.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp(), string);
        }
        Option<Password> option6 = config.zkSslTrustStorePassword();
        if (option6 == null) {
            throw null;
        }
        Option<Password> foreach_this6 = option6;
        if (!foreach_this6.isEmpty()) {
            Password password = (Password)foreach_this6.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp(), password.value());
        }
        Option<String> option7 = config.zkSslTrustStoreType();
        if (option7 == null) {
            throw null;
        }
        Option<String> foreach_this7 = option7;
        if (!foreach_this7.isEmpty()) {
            String string = (String)foreach_this7.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp(), string);
        }
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslProtocolProp(), config.ZkSslProtocol());
        Option<List<String>> option8 = config.ZkSslEnabledProtocols();
        if (option8 == null) {
            throw null;
        }
        Option<List<String>> foreach_this8 = option8;
        if (!foreach_this8.isEmpty()) {
            List list = (List)foreach_this8.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp(), list);
        }
        Option<List<String>> option9 = config.ZkSslCipherSuites();
        if (option9 == null) {
            throw null;
        }
        Option<List<String>> foreach_this9 = option9;
        if (!foreach_this9.isEmpty()) {
            List list = (List)foreach_this9.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslCipherSuitesProp(), list);
        }
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp(), config.ZkSslEndpointIdentificationAlgorithm());
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslCrlEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable())).toString());
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslOcspEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable())).toString());
        return new Some((Object)clientConfig);
    }

    public boolean zkClientConfigFromKafkaConfig$default$2() {
        return false;
    }

    public long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS() {
        return this.MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    }

    public String MULTI_TENANT_AUTHORIZER_CLASS_NAME() {
        return this.MULTI_TENANT_AUTHORIZER_CLASS_NAME;
    }

    private KafkaServer$() {
        MODULE$ = this;
        this.MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS = 120000L;
        this.MULTI_TENANT_AUTHORIZER_CLASS_NAME = "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer";
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$1$adapted(ZKClientConfig clientConfig$1, String x$6) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkClientCnxnSocketProp(), x$6);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$2$adapted(ZKClientConfig clientConfig$1, String x$7) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp(), x$7);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$3$adapted(ZKClientConfig clientConfig$1, Password x) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp(), x.value());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$4$adapted(ZKClientConfig clientConfig$1, String x$8) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp(), x$8);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$5$adapted(ZKClientConfig clientConfig$1, String x$9) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp(), x$9);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$6$adapted(ZKClientConfig clientConfig$1, Password x) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp(), x.value());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$7$adapted(ZKClientConfig clientConfig$1, String x$10) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp(), x$10);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$8$adapted(ZKClientConfig clientConfig$1, List x$11) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp(), x$11);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$9$adapted(ZKClientConfig clientConfig$1, List x$12) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslCipherSuitesProp(), x$12);
        return BoxedUnit.UNIT;
    }
}

