/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.RequestChannel;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tq\u0001\u0011)\u0019!C\u0001s!AQ\b\u0001B\u0001B\u0003%!\b\u0003\u0005?\u0001\t\u0015\r\u0011\"\u0001@\u0011!1\u0005A!A!\u0002\u0013\u0001\u0005\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\t\u00111\u0003!\u0011!Q\u0001\n%C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t5\u0002\u0011\t\u0011)A\u0005u!A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003]\u0011!\u0001\u0004A!b\u0001\n\u0013A\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u000b=\u0004A\u0011\u00019\t\u000fm\u0004!\u0019!C\u0005y\"9\u00111\u0003\u0001!\u0002\u0013i\b\"CA\u000b\u0001\t\u0007I\u0011BA\f\u0011!\ty\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\t\t\u0005\u0001Q\u0001\n\u0005U\u0002\"CA\"\u0001\t\u0007I\u0011AA#\u0011!\ti\u0006\u0001Q\u0001\n\u0005\u001d\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t)\b\u0001C\u0001\u0003o\u0012qcS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u000b\u0005qi\u0012AB:feZ,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u0011([A\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0016\u000e\u0003%R!AK\u000f\u0002\u000bU$\u0018\u000e\\:\n\u00051J#a\u0002'pO\u001eLgn\u001a\t\u0003]Ej\u0011a\f\u0006\u0003au\tq!\\3ue&\u001c7/\u0003\u00023_\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\r\r|gNZ5h!\t)d'D\u0001\u001c\u0013\t94DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u00032s_.,'/\u00133\u0016\u0003i\u0002\"AI\u001e\n\u0005q\u001a#aA%oi\u0006I!M]8lKJLE\rI\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%BA\"\u001e\u0003\u001dqW\r^<pe.L!!\u0012\"\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0003ba&\u001cX#A%\u0011\u0005UR\u0015BA&\u001c\u0005%Y\u0015MZ6b\u0003BL7/A\u0003ba&\u001c\b%\u0001\u0003uS6,\u0007CA(Y\u001b\u0005\u0001&B\u0001\u0016R\u0015\t\u00116+\u0001\u0004d_6lwN\u001c\u0006\u0003=QS!!\u0016,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0016aA8sO&\u0011\u0011\f\u0015\u0002\u0005)&lW-\u0001\u0006ok6$\u0006N]3bIN\fqD]3rk\u0016\u001cH\u000fS1oI2,'/\u0011<h\u0013\u0012dW-T3ue&\u001cg*Y7f!\tiFM\u0004\u0002_EB\u0011qlI\u0007\u0002A*\u0011\u0011mH\u0001\u0007yI|w\u000e\u001e \n\u0005\r\u001c\u0013A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!aY\u0012\u0002-1|w-\u00118e)\"\u0014X-\u00193OC6,\u0007K]3gSb,\u0012!\u001b\t\u0003U2l\u0011a\u001b\u0006\u0003aEK!!\\6\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u000bcJ\u001cH/\u001e<xqfT\bCA\u001b\u0001\u0011\u0015\u0019d\u00021\u00015\u0011\u0015Ad\u00021\u0001;\u0011\u0015qd\u00021\u0001A\u0011\u00159e\u00021\u0001J\u0011\u0015ie\u00021\u0001O\u0011\u0015Qf\u00021\u0001;\u0011\u0015Yf\u00021\u0001]\u0011\u00159g\u00021\u0001]\u0011\u0015\u0001d\u00021\u0001j\u00039!\bN]3bIB{w\u000e\\*ju\u0016,\u0012! \t\u0004}\u0006=Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0007CR|W.[2\u000b\t\u0005\u0015\u0011qA\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0005\u0003\u0017\tA!\u001e;jY*\u0011\u0011QB\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0012}\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018a\u0004;ie\u0016\fG\rU8pYNK'0\u001a\u0011\u0002%\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM]\u000b\u0003\u00033\u0001B!a\u0007\u0002,5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003d_J,'b\u0001\u0019\u0002$)!\u0011QEA\u0014\u0003\u0019I\u0018-\\7fe*\u0011\u0011\u0011F\u0001\u0004G>l\u0017\u0002BA\u0017\u0003;\u0011Q!T3uKJ\f1#Y4he\u0016<\u0017\r^3JI2,W*\u001a;fe\u0002\n1\u0004\u001e5sK\u0006$\u0007o\\8m\u0007\u0006\u0004\u0018mY5usN+gn]8s\u001fB$XCAA\u001b!\u0015\u0011\u0013qGA\u001e\u0013\r\tId\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007)\fi$C\u0002\u0002@-\u0014aaU3og>\u0014\u0018\u0001\b;ie\u0016\fG\r]8pY\u000e\u000b\u0007/Y2jif\u001cVM\\:pe>\u0003H\u000fI\u0001\neVtg.\u00192mKN,\"!a\u0012\u0011\r\u0005%\u00131KA,\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003#\u001a\u0013AC2pY2,7\r^5p]&!\u0011QKA&\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007U\nI&C\u0002\u0002\\m\u00111cS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\f!B];o]\u0006\u0014G.Z:!\u00035\u0019'/Z1uK\"\u000bg\u000e\u001a7feR!\u00111MA5!\r\u0011\u0013QM\u0005\u0004\u0003O\u001a#\u0001B+oSRDa!a\u001b\u0018\u0001\u0004Q\u0014AA5e\u0003A\u0011Xm]5{KRC'/Z1e!>|G\u000e\u0006\u0003\u0002d\u0005E\u0004BBA:1\u0001\u0007!(A\u0004oK^\u001c\u0016N_3\u0002\u0011MDW\u000f\u001e3po:$\"!a\u0019")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final KafkaApis apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final Metrics metrics;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final Option<Sensor> threadpoolCapacitySensorOpt;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public KafkaApis apis() {
        return this.apis;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    private Option<Sensor> threadpoolCapacitySensorOpt() {
        return this.threadpoolCapacitySensorOpt;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        RequestLogFilter requestLogFilter = this.config.newRequestLogFilter();
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), requestLogFilter, this.apis(), this.time));
        KafkaThread.daemon((String)new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString(), (Runnable)((Runnable)this.runnables().apply(id))).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(currentSize, newSize);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    this.createHandler(foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i != foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) {
                        foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                        continue;
                    }
                    break;
                }
            }
        } else if (newSize < currentSize) {
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, currentSize - newSize);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach$mVc$sp_this = inclusive;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    KafkaRequestHandlerPool.$anonfun$resizeThreadPool$3(this, currentSize, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
        }
        this.threadPoolSize().set(newSize);
        Option<Sensor> option = this.threadpoolCapacitySensorOpt();
        if (option == null) {
            throw null;
        }
        Option<Sensor> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            Sensor sensor = (Sensor)foreach_this.get();
            sensor.record(100.0 * (double)newSize);
            return;
        }
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shut down completely");
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$3(KafkaRequestHandlerPool $this, int currentSize$1, int i) {
        ((KafkaRequestHandler)$this.runnables().remove(currentSize$1 - i)).stop();
    }

    public KafkaRequestHandlerPool(KafkaConfig config, int brokerId, RequestChannel requestChannel, KafkaApis apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix, Metrics metrics) {
        None$ none$;
        this.config = config;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        this.metrics = metrics;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS, this.newMeter$default$4());
        String string = requestHandlerAvgIdleMetricName;
        String string2 = "RequestHandlerAvgIdlePercent";
        if (string != null && string.equals(string2)) {
            Sensor sensor = metrics.sensor("TotalIoThreadsPercentage");
            sensor.add(ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(metrics), (MeasurableStat)new Value());
            sensor.record(100.0 * (double)numThreads);
            none$ = new Some((Object)sensor);
        } else {
            none$ = None$.MODULE$;
        }
        this.threadpoolCapacitySensorOpt = none$;
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numThreads);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.createHandler(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public static final /* synthetic */ Object $anonfun$resizeThreadPool$4$adapted(int newSize$1, Sensor sensor) {
        sensor.record(100.0 * (double)newSize$1);
        return BoxedUnit.UNIT;
    }
}

