/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.log.LogCleaner$;
import kafka.log.LogManager$;
import kafka.network.SocketServer$;
import kafka.server.DynamicBackpressure$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.DynamicLogConfig$;
import kafka.server.DynamicThreadPool$;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class DynamicBrokerConfig$ {
    public static DynamicBrokerConfig$ MODULE$;
    private final scala.collection.mutable.Set<String> DynamicSecurityConfigs;
    private final scala.collection.mutable.Set<String> AllDynamicConfigs;
    private final Set<String> ClusterLevelListenerConfigs;
    private final scala.collection.mutable.Set<String> PerBrokerConfigs;
    private final Set<String> ListenerMechanismConfigs;
    private final Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    private final Regex ListenerConfigRegex;
    private final scala.collection.mutable.Set<String> DynamicPasswordConfigs;

    static {
        new DynamicBrokerConfig$();
    }

    public scala.collection.mutable.Set<String> DynamicSecurityConfigs() {
        return this.DynamicSecurityConfigs;
    }

    public scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return this.AllDynamicConfigs;
    }

    private Set<String> ClusterLevelListenerConfigs() {
        return this.ClusterLevelListenerConfigs;
    }

    private scala.collection.mutable.Set<String> PerBrokerConfigs() {
        return this.PerBrokerConfigs;
    }

    private Set<String> ListenerMechanismConfigs() {
        return this.ListenerMechanismConfigs;
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs() {
        return this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    }

    public Regex ListenerConfigRegex() {
        return this.ListenerConfigRegex;
    }

    private scala.collection.mutable.Set<String> DynamicPasswordConfigs() {
        return this.DynamicPasswordConfigs;
    }

    public boolean isPasswordConfig(String name) {
        return this.DynamicPasswordConfigs().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(x$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
        if (!(string != null ? !string.equals(name) : name != null)) {
            bl3 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.LogRollTimeHoursProp();
            bl3 = !(string2 != null ? !string2.equals(name) : name != null);
        }
        if (bl3) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$));
        }
        String string3 = KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp();
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            bl2 = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp();
            bl2 = !(string4 != null ? !string4.equals(name) : name != null);
        }
        if (bl2) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), (List)Nil$.MODULE$));
        }
        String string5 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
        if (string5 == null) {
            if (name == null) return new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushIntervalMsProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), (List)Nil$.MODULE$));
        } else if (string5.equals(name)) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushIntervalMsProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), (List)Nil$.MODULE$));
        }
        String string6 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
        if (!(string6 != null ? !string6.equals(name) : name != null)) {
            bl = true;
        } else {
            String string7 = KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp();
            if (!(string7 != null ? !string7.equals(name) : name != null)) {
                bl = true;
            } else {
                String string8 = KafkaConfig$.MODULE$.LogRetentionTimeHoursProp();
                bl = !(string8 != null ? !string8.equals(name) : name != null);
            }
        }
        if (bl) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), (List)Nil$.MODULE$)));
        }
        Option option = this.ListenerConfigRegex().unapplySeq((CharSequence)name);
        if (option.isEmpty()) return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        if (option.get() == null) return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        if (((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
        if (!matchListenerOverride) return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        Option mechanismConfig = this.ListenerMechanismConfigs().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)baseName.endsWith(x$1)));
        if (mechanismConfig == null) {
            throw null;
        }
        Object object = mechanismConfig.isEmpty() ? baseName : mechanismConfig.get();
        return new .colon.colon((Object)name, (List)new .colon.colon((Object)((String)object), (List)Nil$.MODULE$));
    }

    public void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Cannot update these configs dynamically");
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
        this.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
        if (!perBrokerConfig) {
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
        }
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$perBrokerConfigs(Properties props) {
        Set configNames = ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet();
        return ((SetLike)configNames.intersect(this.PerBrokerConfigs())).$plus$plus((GenTraversableOnce)configNames.filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)this.perBrokerListenerConfig$1(name))));
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(Properties props) {
        return (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)this.DynamicSecurityConfigs().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)props.containsKey(x$1)));
    }

    public void kafka$server$DynamicBrokerConfig$$validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String string = (String)x0$1._1();
                String v = (String)x0$1._2();
                Option option = MODULE$.ListenerConfigRegex().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return baseProps.put(baseName, v);
                }
            }
            if (x0$1 == null) throw new MatchError(null);
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            return baseProps.put(k, v);
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    public void addDynamicConfigs(ConfigDef configDef) {
        KafkaConfig$.MODULE$.configKeys().filterKeys((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.$anonfun$addDynamicConfigs$1(elem))).values().foreach((Function1 & Serializable & scala.Serializable)config -> configDef.define(config.name, config.type, config.defaultValue, config.validator, config.importance, config.documentation, config.group, config.orderInGroup, config.width, config.displayName, config.dependents, config.recommender));
    }

    public java.util.Map<String, String> dynamicConfigUpdateModes() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)this.AllDynamicConfigs().map((Function1 & Serializable & scala.Serializable)name -> {
            void $minus$greater$extension_$this;
            String mode = MODULE$.PerBrokerConfigs().contains(name) ? "per-broker" : "cluster-wide";
            Object object = Predef$.MODULE$.ArrowAssoc(name);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)mode);
        }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public Properties resolveVariableConfigs(Properties propsOriginal) {
        void var2_2;
        Properties props = new Properties();
        AbstractConfig config = new AbstractConfig(new ConfigDef(), (java.util.Map)propsOriginal, false);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.$anonfun$resolveVariableConfigs$1(x$2)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object value;
            String key;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    key = (String)x0$1._1();
                    value = x0$1._2();
                    if (key != null && value != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            Object object = props.put(key, value);
            return object;
        });
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$DynamicPasswordConfigs$1(Tuple2 x$1) {
        ConfigDef.Type type = ((ConfigDef.ConfigKey)x$1._2()).type;
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    private static final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final boolean perBrokerListenerConfig$1(String name) {
        boolean bl;
        Option option = this.ListenerConfigRegex().unapplySeq((CharSequence)name);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
            bl = !this.ClusterLevelListenerConfigs().contains((Object)baseName);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$addDynamicConfigs$1(String elem) {
        return MODULE$.AllDynamicConfigs().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$resolveVariableConfigs$1(Tuple2 x$2) {
        return !((String)x$2._1()).startsWith("config.providers");
    }

    private DynamicBrokerConfig$() {
        MODULE$ = this;
        this.DynamicSecurityConfigs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
        this.AllDynamicConfigs = this.DynamicSecurityConfigs().$plus$plus(LogCleaner$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicThreadPool$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MetricReporterClassesProp()}))).$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(SocketServer$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicBackpressure$.MODULE$.ReconfigurableConfigs()).$plus$plus(LogManager$.MODULE$.ReconfigurableConfigs());
        this.ClusterLevelListenerConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MaxConnectionsProp()}));
        this.PerBrokerConfigs = this.DynamicSecurityConfigs().$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$minus$minus(this.ClusterLevelListenerConfigs());
        this.ListenerMechanismConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.SaslJaasConfigProp(), KafkaConfig$.MODULE$.SaslLoginCallbackHandlerClassProp(), KafkaConfig$.MODULE$.SaslLoginClassProp(), KafkaConfig$.MODULE$.SaslServerCallbackHandlerClassProp(), KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp()}));
        this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.truststore.location"}));
        String string = "listener\\.name\\.[^.]*\\.(.*)";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.ListenerConfigRegex = new StringOps(string).r();
        Set passwordConfigs = ((MapLike)KafkaConfig$.MODULE$.configKeys().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.$anonfun$DynamicPasswordConfigs$1(x$1)))).keySet();
        this.DynamicPasswordConfigs = (scala.collection.mutable.Set)this.AllDynamicConfigs().intersect((GenSet)passwordConfigs);
    }
}

