/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.ReplicaManager;
import kafka.tier.TierTimestampAndOffset;
import kafka.tier.fetcher.PendingOffsetForTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0003\u0007\u0001#!Ia\u0003\u0001B\u0001B\u0003%q#\b\u0005\t=\u0001\u0011\t\u0011)A\u0005?!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u000b%\u0004A\u0011\u00016\t\u000bI\u0004A\u0011I:\t\u000bQ\u0004A\u0011I;\t\u000bY\u0004A\u0011I;\u0003%\u0011+G.Y=fI2K7\u000f^(gMN,Go\u001d\u0006\u0003\u001b9\taa]3sm\u0016\u0014(\"A\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011\u0001D\u0005\u0003+1\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u000f\u0011,G.Y=NgB\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t!Aj\u001c8h\u0013\t1B#A\ngKR\u001c\u0007n\u00148ms\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0005\u0002\u0019A%\u0011\u0011%\u0007\u0002\b\u0005>|G.Z1o\u0003)awnY1m\u0019&\u001cHo\u001d\t\u0005I%Zc'D\u0001&\u0015\t1s%\u0001\u0003vi&d'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002-i5\tQF\u0003\u0002/_\u000511m\\7n_:T!a\u0004\u0019\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0005\u0003k5\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002\u0019oeJ!\u0001O\r\u0003\r=\u0003H/[8o!\tQDJ\u0004\u0002<\u0013:\u0011Ah\u0012\b\u0003{\u0019s!AP#\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"\u0011\u0003\u0019a$o\\8u}%\t1'\u0003\u00022e%\u0011q\u0002M\u0005\u0003]=J!\u0001S\u0017\u0002\rI,7m\u001c:e\u0013\tQ5*A\u0006GS2,'+Z2pe\u0012\u001c(B\u0001%.\u0013\tieJ\u0001\fGS2,G+[7fgR\fW\u000e]!oI>3gm]3u\u0015\tQ5*A\u0004qK:$\u0017N\\4\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016a\u00024fi\u000eDWM\u001d\u0006\u0003+:\tA\u0001^5fe&\u0011qK\u0015\u0002\u001a!\u0016tG-\u001b8h\u001f\u001a47/\u001a;G_J$\u0016.\\3ti\u0006l\u0007/\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005MQ\u0016BA.\r\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\taq\u0006MZ\u0005\u0003?f\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u0005$7FN\u0007\u0002E*\u00111-G\u0001\u000bG>dG.Z2uS>t\u0017BA3c\u0005\ri\u0015\r\u001d\t\u00031\u001dL!\u0001[\r\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f-dWN\\8qcB\u00111\u0003\u0001\u0005\u0006-\u001d\u0001\ra\u0006\u0005\u0006=\u001d\u0001\ra\b\u0005\u0006E\u001d\u0001\ra\t\u0005\u0006\u001f\u001e\u0001\r\u0001\u0015\u0005\u00061\u001e\u0001\r!\u0017\u0005\u00069\u001e\u0001\r!X\u0001\fiJL8i\\7qY\u0016$X\rF\u0001 \u00031yg.\u0012=qSJ\fG/[8o)\u00051\u0017AC8o\u0007>l\u0007\u000f\\3uK\u0002")
public class DelayedListOffsets
extends DelayedOperation {
    private final boolean fetchOnlyFromLeader;
    private final HashMap<TopicPartition, Option<FileRecords.FileTimestampAndOffset>> localLists;
    private final PendingOffsetForTimestamp pending;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, Option<FileRecords.FileTimestampAndOffset>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.localLists).asScala()).$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.pending.tierTimestampAndOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            TierTimestampAndOffset timestampAndOffset = (TierTimestampAndOffset)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)tp, (Object)new Some((Object)timestampAndOffset));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Object object;
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                Option timestampAndOffset = (Option)x0$2._2();
                try {
                    Partition partition = $this.replicaManager.getPartitionOrException(tp, $this.fetchOnlyFromLeader);
                    Optional leaderEpoch = ((FileRecords.TimestampAndOffset)timestampAndOffset.get()).leaderEpoch();
                    object = partition.localLogWithEpochOrException(leaderEpoch, $this.fetchOnlyFromLeader);
                }
                catch (Exception e) {
                    $this.pending.completeExceptionally(tp, e);
                    object = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        });
        if (this.pending.isDone()) {
            return this.forceComplete();
        }
        return false;
    }

    @Override
    public void onExpiration() {
        this.pending.cancel();
    }

    @Override
    public void onComplete() {
        scala.collection.mutable.Map tierResponses = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.pending.tierTimestampAndOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            TierTimestampAndOffset tierTimestampAndOffset = (TierTimestampAndOffset)x0$1._2();
            Option timestampAndOffset = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.pending.results().getOrDefault(topicPartition, Optional.of(new FileRecords.FileTimestampAndOffset(tierTimestampAndOffset.timestamp, tierTimestampAndOffset.leaderEpoch(), (Exception)((Object)Errors.REQUEST_TIMED_OUT.exception()))))));
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)timestampAndOffset);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.localLists).asScala()).$plus$plus((GenTraversableOnce)tierResponses));
    }

    public DelayedListOffsets(long delayMs, boolean fetchOnlyFromLeader, HashMap<TopicPartition, Option<FileRecords.FileTimestampAndOffset>> localLists, PendingOffsetForTimestamp pending, ReplicaManager replicaManager, Function1<Map<TopicPartition, Option<FileRecords.FileTimestampAndOffset>>, BoxedUnit> responseCallback) {
        this.fetchOnlyFromLeader = fetchOnlyFromLeader;
        this.localLists = localLists;
        this.pending = pending;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

