/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.BrokerBackpressureMetrics$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.QuotaType$Request$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestThrottleType;
import kafka.server.ThreadUsageMetrics$;
import kafka.server.ThreadUsageSensors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0012%\u0001%B\u0001B\f\u0001\u0003\u0006\u0004%Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001BC\u0002\u0013%Q\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u00037\u0011!\u0019\u0005A!b\u0001\n\u0013!\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tM\u0002\u0011\t\u0011)A\u0005O\")1\u000e\u0001C\u0001Y\"9A\u000f\u0001b\u0001\n\u0013)\bBB=\u0001A\u0003%a\u000fC\u0004{\u0001\u0001\u0007I\u0011B>\t\u0011}\u0004\u0001\u0019!C\u0005\u0003\u0003Aq!!\u0004\u0001A\u0003&A\u0010C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0001\u0002\u0012!A\u0011\u0011\u0004\u0001!\u0002\u0013\t\u0019\u0002C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002\u001e!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005]\u0004\u0001\"\u0015\u0002z!9\u0011Q\u0011\u0001\u0005R\u0005\u001d\u0005bBAN\u0001\u0011%\u0011Q\u0014\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCa!a+\u0001\t\u0003Z\bbBAW\u0001\u0011%\u0011q\u0016\u0005\t\u0003\u0003\u0004A\u0011\u000b\u0013\u0002D\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d'!G\"mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJT!!\n\u0014\u0002\rM,'O^3s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0017\u000e\u0003\u0011J!!\f\u0013\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\u0001\u0007G>tg-[4\u0016\u0003A\u0002\"aK\u0019\n\u0005I\"#\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013aB7fiJL7m]\u000b\u0002mA\u0011q\u0007Q\u0007\u0002q)\u0011A'\u000f\u0006\u0003um\naaY8n[>t'BA\u0014=\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005C$aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%:\u0003\u0015)H/\u001b7t\u0013\tQuI\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\tquK\u0004\u0002P+B\u0011\u0001kU\u0007\u0002#*\u0011!\u000bK\u0001\u0007yI|w\u000e\u001e \u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0002\rA\u0013X\rZ3g\u0013\tA\u0016L\u0001\u0004TiJLgn\u001a\u0006\u0003-N\u000bQ\"];pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007c\u0001/^?6\t1+\u0003\u0002_'\n1q\n\u001d;j_:\u0004\"\u0001\u00193\u000e\u0003\u0005T!AY2\u0002\u000bE,x\u000e^1\u000b\u0005\u0015Z\u0014BA3b\u0005M\u0019E.[3oiF+x\u000e^1DC2d'-Y2l\u0003Q\t7\r^5wKR+g.\u00198ug6\u000bg.Y4feB\u0019A,\u00185\u0011\u0005-J\u0017B\u00016%\u0005Q\t5\r^5wKR+g.\u00198ug6\u000bg.Y4fe\u00061A(\u001b8jiz\"r!\u001c8paF\u00148\u000f\u0005\u0002,\u0001!)aF\u0003a\u0001a!)AG\u0003a\u0001m!)1I\u0003a\u0001\u000b\")AJ\u0003a\u0001\u001b\")!L\u0003a\u00017\")aM\u0003a\u0001O\u0006\u0011B\u000f\u001b:fC\u0012,6/Y4f'\u0016t7o\u001c:t+\u00051\bCA\u0016x\u0013\tAHE\u0001\nUQJ,\u0017\rZ+tC\u001e,7+\u001a8t_J\u001c\u0018a\u0005;ie\u0016\fG-V:bO\u0016\u001cVM\\:peN\u0004\u0013a\u00057bgRd\u0015.\\5u\u0007>\u0014(/Z2uS>tW#\u0001?\u0011\u0005qk\u0018B\u0001@T\u0005\u0019!u.\u001e2mK\u00069B.Y:u\u0019&l\u0017\u000e^\"peJ,7\r^5p]~#S-\u001d\u000b\u0005\u0003\u0007\tI\u0001E\u0002]\u0003\u000bI1!a\u0002T\u0005\u0011)f.\u001b;\t\u0011\u0005-a\"!AA\u0002q\f1\u0001\u001f\u00132\u0003Qa\u0017m\u001d;MS6LGoQ8se\u0016\u001cG/[8oA\u0005\tR.\u0019=UQJ|G\u000f\u001e7f)&lW-T:\u0016\u0005\u0005M\u0001c\u0001/\u0002\u0016%\u0019\u0011qC*\u0003\t1{gnZ\u0001\u0013[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001b\b%\u0001\u0007fq\u0016l\u0007\u000f^*f]N|'/\u0006\u0002\u0002 A\u0019q'!\t\n\u0007\u0005\r\u0002H\u0001\u0004TK:\u001cxN]\u0001\u0018]>tW\t_3naR\u001c\u0015\r]1dSRL8+\u001a8t_J\f\u0011D]3d_J$W\t_3naRtU\r^<pe.$\u0006N]3bIRA\u00111AA\u0016\u0003_\t\u0019\u0004\u0003\u0004\u0002.Q\u0001\r\u0001`\u0001\u0006m\u0006dW/\u001a\u0005\u0007\u0003c!\u0002\u0019A'\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\u000f\u0005UB\u00031\u0001\u0002\u0014\u00051A/[7f\u001bN\fAC]3d_J$W\t_3naRLu\u000e\u00165sK\u0006$GCBA\u0002\u0003w\ti\u0004\u0003\u0004\u0002.U\u0001\r\u0001 \u0005\b\u0003k)\u0002\u0019AA\n\u0003U\u0011X-\\8wK2K7\u000f^3oKJlU\r\u001e:jGN$B!a\u0001\u0002D!1\u0011\u0011\u0007\fA\u00025\u000bq$\\1zE\u0016\u0014VmY8sI\u0006sGmR3u)\"\u0014x\u000e\u001e;mKRKW.Z't)\u0011\tI%a\u0014\u0011\u0007q\u000bY%C\u0002\u0002NM\u00131!\u00138u\u0011\u001d\t\tf\u0006a\u0001\u0003'\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002V\u0005\u0005d\u0002BA,\u0003;j!!!\u0017\u000b\u0007\u0005mc%A\u0004oKR<xN]6\n\t\u0005}\u0013\u0011L\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t\u0019'!\u001a\u0003\u000fI+\u0017/^3ti*!\u0011qLA-\u0003Ei\u0017-\u001f2f%\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f\u001e\u000b\u0005\u0003\u0007\tY\u0007C\u0004\u0002Ra\u0001\r!a\u0015\u0002'\t\f7m\u001b9sKN\u001cXO]3F]\u0006\u0014G.\u001a3\u0016\u0005\u0005E\u0004c\u0001/\u0002t%\u0019\u0011QO*\u0003\u000f\t{w\u000e\\3b]\u0006aA\u000f\u001b:piRdW\rV5nKR!\u00111CA>\u0011\u001d\tiH\u0007a\u0001\u0003\u007f\nAb\u00197jK:$X*\u001a;sS\u000e\u00042aNAA\u0013\r\t\u0019\t\u000f\u0002\f\u0017\u000647.Y'fiJL7-\u0001\u000bdY&,g\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0005\u0003\u0013\u000b\t\n\u0005\u0003\u0002\f\u00065U\"A\u001d\n\u0007\u0005=\u0015H\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016Dq!a%\u001c\u0001\u0004\t)*A\brk>$\u0018-T3ue&\u001cG+Y4t!\u0015q\u0015qS'N\u0013\r\tI*\u0017\u0002\u0004\u001b\u0006\u0004\u0018\u0001E3yK6\u0004H/T3ue&\u001cg*Y7f+\t\tI)\u0001\tfq\u0016l\u0007\u000f^*f]N|'OT1nKV\tQ*A\toC:|7\u000fV8QKJ\u001cWM\u001c;bO\u0016$2\u0001`AT\u0011\u001d\tIK\ba\u0001\u0003'\tQA\\1o_N\f1cZ3u\u0005J|7.\u001a:Rk>$\u0018\rT5nSR\f!C]3d_J$g*\u001a;x_J\\Wk]1hKRQ\u00111AAY\u0003g\u000b),a0\t\r\u00055\u0002\u00051\u0001}\u0011\u0019\t\t\u0004\ta\u0001\u001b\"9\u0011q\u0017\u0011A\u0002\u0005e\u0016\u0001\u0004;ie>$H\u000f\\3UsB,\u0007cA\u0016\u0002<&\u0019\u0011Q\u0018\u0013\u0003'I+\u0017/^3tiRC'o\u001c;uY\u0016$\u0016\u0010]3\t\u000f\u0005U\u0002\u00051\u0001\u0002\u0014\u00051R\u000f\u001d3bi\u0016\u0014%o\\6feF+x\u000e^1MS6LG\u000f\u0006\u0002\u0002\u0004\u00051R\u000f\u001d3bi\u0016\fEM[;ti\u0016$7)\u00199bG&$\u0018\u0010F\u0002}\u0003\u0013Da!a3#\u0001\u0004a\u0018A\u00052s_.,'OU3rk\u0016\u001cH\u000fT5nSR\u0004")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final ThreadUsageSensors threadUsageSensors;
    private double lastLimitCorrection;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private ThreadUsageSensors threadUsageSensors() {
        return this.threadUsageSensors;
    }

    private double lastLimitCorrection() {
        return this.lastLimitCorrection;
    }

    private void lastLimitCorrection_$eq(double x$1) {
        this.lastLimitCorrection = x$1;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics()));
    }

    public void recordExemptNetworkThread(double value, String listenerName, long timeMs) {
        this.exemptSensor().record(value, timeMs);
        this.recordNetworkUsage(value, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    public void recordExemptIoThread(double value, long timeMs) {
        this.exemptSensor().record(value, timeMs);
    }

    public void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors().removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        if (request.apiRemoteCompleteTimeNanos() == -1L) {
            request.apiRemoteCompleteTimeNanos_$eq(this.time().nanoseconds());
        }
        long currentTimeMs = this.time().milliseconds();
        double reqIoThreadPercentage = this.nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, currentTimeMs, this.threadUsageSensors().recordIoThreadUsage$default$3());
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, currentTimeMs, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> {
                this.recordNoThrottle(this.getOrCreateQuotaSensors(request.session(), request.header().clientId()), this.nanosToPercentage(timeNanos));
                this.recordNetworkUsage(this.nanosToPercentage(timeNanos), listenerName, NonExemptRequest$.MODULE$, this.time().milliseconds());
            }));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), reqIoThreadPercentage, currentTimeMs);
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNetworkUsage(this.nanosToPercentage(timeNanos), listenerName, NonExemptRequest$.MODULE$, this.time().milliseconds())));
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = this.time().milliseconds();
        double reqIoThreadPercentage = this.nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, currentTimeMs, this.threadUsageSensors().recordIoThreadUsage$default$3());
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordExemptNetworkThread(this.nanosToPercentage(timeNanos), listenerName, this.time().milliseconds())));
            this.recordExemptIoThread(reqIoThreadPercentage, currentTimeMs);
            return;
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNetworkUsage(this.nanosToPercentage(timeNanos), listenerName, ExemptRequest$.MODULE$, this.time().milliseconds())));
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig() && this.dynamicBackpressureConfig().tenantEndpointListenerNames().nonEmpty();
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric) {
        return package$.MODULE$.min(super.throttleTime(clientMetric), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return new StringBuilder(7).append("exempt-").append(QuotaType$Request$.MODULE$).toString();
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    @Override
    public double getBrokerQuotaLimit() {
        Option metricOpt = Option$.MODULE$.apply((Object)this.metrics().metric(BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics())));
        double d = metricOpt instanceof Some ? BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue()) : Double.MAX_VALUE;
        return d;
    }

    private void recordNetworkUsage(double value, String listenerName, RequestThrottleType throttleType, long timeMs) {
        this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, this.threadUsageSensors().recordNetworkThreadUsage$default$4());
        if (this.quotasEnabled() && NonExemptRequest$.MODULE$.equals(throttleType)) {
            this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            return;
        }
    }

    @Override
    public void updateBrokerQuotaLimit() {
        Seq<String> tenantEndpointsListenerNames = this.dynamicBackpressureConfig().tenantEndpointListenerNames();
        if (this.quotasEnabled() && tenantEndpointsListenerNames.nonEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            double ioThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), ThreadUsageMetrics$.MODULE$.ioThreadsUsage$default$2());
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            double networkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, ThreadUsageMetrics$.MODULE$.networkThreadsUsage$default$3());
            double nonExemptIoThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics$.MODULE$.ioThreadsCapacity(this.metrics()));
            double nonExemptNetworkThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics$.MODULE$.networkThreadsCapacity(this.metrics(), tenantEndpointsListenerNames));
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptIoThreadLimit + nonExemptNetworkThreadLimit : package$.MODULE$.min(networkThreadUsage, nonExemptNetworkThreadLimit) + package$.MODULE$.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
        }
    }

    public double updateAdjustedCapacity(double brokerRequestLimit) {
        double d;
        double queueSize = RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p95");
        double minCap = BrokerBackpressureConfig$.MODULE$.DefaultMinRequestQuotaLimit();
        if (queueSize >= this.dynamicBackpressureConfig().queueSizeCap()) {
            double maxAdjustmentLimit = package$.MODULE$.max(brokerRequestLimit - minCap, 0.0);
            d = this.lastLimitCorrection() < maxAdjustmentLimit ? this.lastLimitCorrection() + BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment() : this.lastLimitCorrection();
        } else {
            d = package$.MODULE$.max(0.0, this.lastLimitCorrection() - BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment());
        }
        this.lastLimitCorrection_$eq(d);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("queueSize(p95)=").append(queueSize).append(",  lastLimitCorrection=").append(this.lastLimitCorrection()).toString());
        return package$.MODULE$.max(brokerRequestLimit - this.lastLimitCorrection(), minCap);
    }

    private static final double nonExemptThreadUsageLimit$1(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - exemptUsage;
        double minNonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        return package$.MODULE$.max(nonExemptCapacity, minNonExemptCapacity);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback, activeTenantsManager);
        this.threadUsageSensors = new ThreadUsageSensors(metrics, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds());
        this.lastLimitCorrection = 0.0;
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

