/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}u!B1c\u0011\u00039g!B5c\u0011\u0003Q\u0007\"B9\u0002\t\u0003\u0011\bbB:\u0002\u0005\u0004%I\u0001\u001e\u0005\u0007q\u0006\u0001\u000b\u0011B;\t\u000fe\f!\u0019!C\u0005u\"9\u0011qA\u0001!\u0002\u0013Y\b\u0002CA\u0005\u0003\t\u0007I\u0011\u0002>\t\u000f\u0005-\u0011\u0001)A\u0005w\"A\u0011QB\u0001C\u0002\u0013%!\u0010C\u0004\u0002\u0010\u0005\u0001\u000b\u0011B>\t\u0011\u0005E\u0011A1A\u0005\niDq!a\u0005\u0002A\u0003%1\u0010\u0003\u0005\u0002\u0016\u0005\u0011\r\u0011\"\u0003{\u0011\u001d\t9\"\u0001Q\u0001\nmD\u0001\"!\u0007\u0002\u0005\u0004%IA\u001f\u0005\b\u00037\t\u0001\u0015!\u0003|\u0011!\ti\"\u0001b\u0001\n\u0013Q\bbBA\u0010\u0003\u0001\u0006Ia\u001f\u0005\t\u0003C\t!\u0019!C\u0005u\"9\u00111E\u0001!\u0002\u0013Y\b\u0002CA\u0013\u0003\t\u0007I\u0011\u0002>\t\u000f\u0005\u001d\u0012\u0001)A\u0005w\"A\u0011\u0011F\u0001C\u0002\u0013%!\u0010C\u0004\u0002,\u0005\u0001\u000b\u0011B>\t\u0011\u00055\u0012A1A\u0005\niDq!a\f\u0002A\u0003%1\u0010C\u0005\u00022\u0005\u0011\r\u0011\"\u0003\u00024!A\u00111H\u0001!\u0002\u0013\t)\u0004C\u0005\u0002>\u0005\u0011\r\u0011\"\u0003\u00024!A\u0011qH\u0001!\u0002\u0013\t)\u0004C\u0005\u0002B\u0005\u0011\r\u0011\"\u0003\u00024!A\u00111I\u0001!\u0002\u0013\t)\u0004C\u0005\u0002F\u0005\u0011\r\u0011\"\u0001\u0002H!A\u0011qM\u0001!\u0002\u0013\tI\u0005C\u0005\u0002j\u0005\u0011\r\u0011\"\u0001\u0002H!A\u00111N\u0001!\u0002\u0013\tI\u0005C\u0004\u0002n\u0005!\t!a\u001c\t\u000f\u00055\u0014\u0001\"\u0001\u0002 \"9\u0011\u0011W\u0001\u0005\n\u0005M\u0006bBAl\u0003\u0011%\u0011\u0011\u001c\u0005\t\u0003G\fA\u0011\u00012\u0002f\"A\u0011\u0011_\u0001\u0005\u0002\t\f\u0019\u0010C\u0004\u0002|\u0006!I!!@\t\u0013\t-\u0011!%A\u0005\n\t5\u0001b\u0002B\u0012\u0003\u0011%!Q\u0005\u0005\n\u0005c\t\u0011\u0013!C\u0001\u0005g1Q!\u001b2\u0001\u0005oA!B!\u00120\u0005\u000b\u0007I\u0011\u0001B$\u0011)\u0011\tf\fB\u0001B\u0003%!\u0011\n\u0005\u000b\u0005'z#\u00111A\u0005\u0002\tU\u0003B\u0003B,_\t\u0005\r\u0011\"\u0001\u0003Z!Q!qL\u0018\u0003\u0002\u0003\u0006K!a%\t\u0015\t%tF!b\u0001\n\u0003\t\u0019\u0004\u0003\u0006\u0003l=\u0012\t\u0011)A\u0005\u0003kAa!]\u0018\u0005\u0002\t5\u0004\"\u0003B<_\t\u0007I\u0011\u0002B=\u0011!\u0011Yh\fQ\u0001\n\u0005\u0005\u0007\"\u0003B?_\u0001\u0007I\u0011\u0002B@\u0011%\u0011\ti\fa\u0001\n\u0013\u0011\u0019\t\u0003\u0005\u0003\b>\u0002\u000b\u0015BAi\u0011%\u0011Ii\fa\u0001\n\u0013\u0011y\bC\u0005\u0003\f>\u0002\r\u0011\"\u0003\u0003\u000e\"A!\u0011S\u0018!B\u0013\t\t\u000eC\u0005\u0003\u0014>\u0012\r\u0011\"\u0003\u0003\u0016\"A!\u0011V\u0018!\u0002\u0013\u00119\nC\u0005\u0003,>\u0012\r\u0011\"\u0003\u0003\u0016\"A!QV\u0018!\u0002\u0013\u00119\nC\u0004\u00030>\"\tA!-\t\u000f\t\u0005w\u0006\"\u0001\u0003D\"9!\u0011Z\u0018\u0005\u0002\t-\u0007b\u0002Bh_\u0011\u0005!q\u0010\u0005\b\u0005#|C\u0011\u0001Bj\u0011\u001d\u0011yn\fC\u0001\u0005CDqAa90\t\u0013\u0011)\u000f\u0003\u0005\u0003p>\"\tA\u0019By\u0011\u001d\u00119p\fC\u0005\u0005sDqaa\u00010\t\u0003\u0019)\u0001C\u0004\u0004\n=\"\taa\u0003\t\u000f\rUq\u0006\"\u0001\u0004\u0018!91QE\u0018\u0005\u0002\r\u001d\u0002bBB\u001f_\u0011\u00051q\b\u0005\b\u0007\u000bzC\u0011AB$\u0011\u001d\u0019ie\fC\u0001\u0007\u001fBqa!\u00160\t\u0003\u00199\u0006C\u0004\u0004Z=\"\tAa3\t\u000f\rms\u0006\"\u0001\u0003L\"91QL\u0018\u0005\u0002\r}\u0003bBB2_\u0011%1Q\r\u0005\b\u0007SzC\u0011AB,\u0011\u001d\u0019Yg\fC\u0001\u0007[Bqa!\u001f0\t\u0003\u0019Y\bC\u0004\u0002r>\"\taa \t\u000f\r-u\u0006\"\u0003\u0004\u000e\"91qR\u0018\u0005\n\r5\u0005\u0002CAr_\u0011\u0005!m!%\t\u000f\t\rr\u0006\"\u0001\u0004\u0014\u0006!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJT!a\u00193\u0002\u00071|wMC\u0001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001[\u0001\u000e\u0003\t\u0014A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148CA\u0001l!\taw.D\u0001n\u0015\u0005q\u0017!B:dC2\f\u0017B\u00019n\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aZ\u0001\u0018!J|G-^2feNs\u0017\r]:i_R4VM]:j_:,\u0012!\u001e\t\u0003YZL!a^7\u0003\u000bMCwN\u001d;\u00021A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$h+\u001a:tS>t\u0007%\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0005!!.\u0019<b\u0013\r\t)! \u0002\u0007'R\u0014\u0018N\\4\u0002\u001bY+'o]5p]\u001aKW\r\u001c3!\u0003!\u0019%o\u0019$jK2$\u0017!C\"sG\u001aKW\r\u001c3!\u0003=\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0017\u0001\u0005)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3!\u0003Ea\u0015m\u001d;TKF,XM\\2f\r&,G\u000eZ\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007%\u0001\nQe>$WoY3s\u000bB|7\r\u001b$jK2$\u0017a\u0005)s_\u0012,8-\u001a:Fa>\u001c\u0007NR5fY\u0012\u0004\u0013a\u0004'bgR|eMZ:fi\u001aKW\r\u001c3\u0002!1\u000b7\u000f^(gMN,GOR5fY\u0012\u0004\u0013\u0001E(gMN,G\u000fR3mi\u00064\u0015.\u001a7e\u0003EyeMZ:fi\u0012+G\u000e^1GS\u0016dG\rI\u0001\u000f)&lWm\u001d;b[B4\u0015.\u001a7e\u0003=!\u0016.\\3ti\u0006l\u0007OR5fY\u0012\u0004\u0013\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG-A\u000bQe>$WoY3s\u000b:$(/[3t\r&,G\u000e\u001a\u0011\u0002+\r{wN\u001d3j]\u0006$xN]#q_\u000eDg)[3mI\u000612i\\8sI&t\u0017\r^8s\u000bB|7\r\u001b$jK2$\u0007%\u0001\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG-A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\rI\u0001\u000e-\u0016\u00148/[8o\u001f\u001a47/\u001a;\u0016\u0005\u0005U\u0002c\u00017\u00028%\u0019\u0011\u0011H7\u0003\u0007%sG/\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\u0002\u0013\r\u00138m\u00144gg\u0016$\u0018AC\"sG>3gm]3uA\u0005)\u0002K]8ek\u000e,'/\u00128ue&,7o\u00144gg\u0016$\u0018A\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:PM\u001a\u001cX\r\u001e\u0011\u00027A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$XI\u001c;ssN\u001b\u0007.Z7b+\t\tI\u0005\u0005\u0003\u0002L\u0005\rTBAA'\u0015\u0011\ty%!\u0015\u0002\u000bQL\b/Z:\u000b\t\u0005M\u0013QK\u0001\taJ|Go\\2pY*!\u0011qKA-\u0003\u0019\u0019w.\\7p]*\u0019Q-a\u0017\u000b\t\u0005u\u0013qL\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0014aA8sO&!\u0011QMA'\u0005\u0019\u00196\r[3nC\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0013\u0001\u0006)jINs\u0017\r]:i_Rl\u0015\r]*dQ\u0016l\u0017-A\u000bQS\u0012\u001cf.\u00199tQ>$X*\u00199TG\",W.\u0019\u0011\u0002\u0019I,\u0017\rZ*oCB\u001c\bn\u001c;\u0015\t\u0005E\u0014q\u0012\t\u0007\u0003g\n\u0019)!#\u000f\t\u0005U\u0014q\u0010\b\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111\u00104\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0017bAAA[\u00069\u0001/Y2lC\u001e,\u0017\u0002BAC\u0003\u000f\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003k\u0007c\u00015\u0002\f&\u0019\u0011Q\u00122\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\b\u0003#+\u0003\u0019AAJ\u0003\u00111\u0017\u000e\\3\u0011\t\u0005U\u00151T\u0007\u0003\u0003/S1!!'\u0000\u0003\tIw.\u0003\u0003\u0002\u001e\u0006]%\u0001\u0002$jY\u0016$B!!\u001d\u0002\"\"9\u00111\u0015\u0014A\u0002\u0005\u0015\u0016A\u00022vM\u001a,'\u000f\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tYk`\u0001\u0004]&|\u0017\u0002BAX\u0003S\u0013!BQ=uK\n+hMZ3s\u000359(/\u001b;f':\f\u0007o\u001d5piR1\u0011QWA^\u0003{\u00032\u0001\\A\\\u0013\r\tI,\u001c\u0002\u0005+:LG\u000fC\u0004\u0002\u0012\u001e\u0002\r!a%\t\u000f\u0005}v\u00051\u0001\u0002B\u00069QM\u001c;sS\u0016\u001c\b\u0003CAb\u0003\u001b\f\t.!#\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\fq!\\;uC\ndWMC\u0002\u0002L6\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty-!2\u0003\u00075\u000b\u0007\u000fE\u0002m\u0003'L1!!6n\u0005\u0011auN\\4\u0002\u001d%\u001c8K\\1qg\"|GOR5mKR!\u00111\\Aq!\ra\u0017Q\\\u0005\u0004\u0003?l'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003#C\u0003\u0019AAJ\u0003Ea\u0017n\u001d;T]\u0006\u00048\u000f[8u\r&dWm\u001d\u000b\u0005\u0003O\fi\u000f\u0005\u0004\u0002t\u0005%\u00181S\u0005\u0005\u0003W\f9IA\u0002TKFDq!a<*\u0001\u0004\t\u0019*A\u0002eSJ\fQ\u0003Z3mKR,7K\\1qg\"|Go\u001d\"fM>\u0014X\r\u0006\u0004\u00026\u0006U\u0018q\u001f\u0005\b\u0003_T\u0003\u0019AAJ\u0011\u001d\tIP\u000ba\u0001\u0003#\faa\u001c4gg\u0016$\u0018a\u00053fY\u0016$Xm\u00158baNDw\u000e\u001e$jY\u0016\u001cHCBA[\u0003\u007f\u0014\t\u0001C\u0004\u0002p.\u0002\r!a%\t\u0013\t\r1\u0006%AA\u0002\t\u0015\u0011!\u00039sK\u0012L7-\u0019;f!\u001da'qAAi\u00037L1A!\u0003n\u0005%1UO\\2uS>t\u0017'A\u000feK2,G/Z*oCB\u001c\bn\u001c;GS2,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yA\u000b\u0003\u0003\u0006\tE1F\u0001B\n!\u0011\u0011)Ba\b\u000e\u0005\t]!\u0002\u0002B\r\u00057\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tuQ.\u0001\u0006b]:|G/\u0019;j_:LAA!\t\u0003\u0018\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+Mt\u0017\r]:i_R4\u0015\u000e\\3G_J|eMZ:fiR1!q\u0005B\u0017\u0005_\u0001R\u0001\u001cB\u0015\u0003'K1Aa\u000bn\u0005\u0019y\u0005\u000f^5p]\"9\u0011q^\u0017A\u0002\u0005M\u0005bBA}[\u0001\u0007\u0011\u0011[\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tU\"\u0006BA\u001b\u0005#\u0019BaL6\u0003:A!!1\bB!\u001b\t\u0011iDC\u0002\u0003@\u0011\fQ!\u001e;jYNLAAa\u0011\u0003>\t9Aj\\4hS:<\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0005\u0013\u0002BAa\u0013\u0003N5\u0011\u0011QK\u0005\u0005\u0005\u001f\n)F\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\na\u0001\\8h\t&\u0014XCAAJ\u0003)awn\u001a#je~#S-\u001d\u000b\u0005\u0003k\u0013Y\u0006C\u0005\u0003^M\n\t\u00111\u0001\u0002\u0014\u0006\u0019\u0001\u0010J\u0019\u0002\u000f1|w\rR5sA!\u001aAGa\u0019\u0011\u00071\u0014)'C\u0002\u0003h5\u0014\u0001B^8mCRLG.Z\u0001\u001a[\u0006D\bK]8ek\u000e,'/\u00133FqBL'/\u0019;j_:l5/\u0001\u000enCb\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001b\b\u0005\u0006\u0005\u0003p\tE$1\u000fB;!\tAw\u0006C\u0004\u0003F]\u0002\rA!\u0013\t\u000f\tMs\u00071\u0001\u0002\u0014\"I!\u0011N\u001c\u0011\u0002\u0003\u0007\u0011QG\u0001\naJ|G-^2feN,\"!!1\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b%A\u0007mCN$X*\u00199PM\u001a\u001cX\r^\u000b\u0003\u0003#\f\u0011\u0003\\1ti6\u000b\u0007o\u00144gg\u0016$x\fJ3r)\u0011\t)L!\"\t\u0013\tu3(!AA\u0002\u0005E\u0017A\u00047bgRl\u0015\r](gMN,G\u000fI\u0001\u000fY\u0006\u001cHo\u00158ba>3gm]3u\u0003Ia\u0017m\u001d;T]\u0006\u0004xJ\u001a4tKR|F%Z9\u0015\t\u0005U&q\u0012\u0005\n\u0005;r\u0014\u0011!a\u0001\u0003#\fq\u0002\\1tiNs\u0017\r](gMN,G\u000fI\u0001\f_:<w.\u001b8h)bt7/\u0006\u0002\u0003\u0018BA!\u0011\u0014BP\u0003#\u0014\u0019+\u0004\u0002\u0003\u001c*\u0019!QT@\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005C\u0013YJA\u0004Ue\u0016,W*\u00199\u0011\u0007!\u0014)+C\u0002\u0003(\n\u00141\u0002\u0016=o\u001b\u0016$\u0018\rZ1uC\u0006aqN\\4pS:<G\u000b\u001f8tA\u0005\u0001RO\u001c:fa2L7-\u0019;fIRChn]\u0001\u0012k:\u0014X\r\u001d7jG\u0006$X\r\u001a+y]N\u0004\u0013a\u00054jeN$XK\\:uC\ndWm\u00144gg\u0016$XC\u0001BZ!\u0015a'\u0011\u0006B[!\u0011\u00119L!0\u000e\u0005\te&b\u0001B^I\u000611/\u001a:wKJLAAa0\u0003:\n\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0002-=t\u0007*[4i/\u0006$XM]7be.,\u0006\u000fZ1uK\u0012$B!!.\u0003F\"9!qY#A\u0002\u0005E\u0017!\u00045jO\"<\u0016\r^3s[\u0006\u00148.\u0001\u000bgSJ\u001cH/\u00168eK\u000eLG-\u001a3PM\u001a\u001cX\r^\u000b\u0003\u0005\u001b\u0004R\u0001\u001cB\u0015\u0003#\fA\"\\1q\u000b:$wJ\u001a4tKR\fq\"Y2uSZ,\u0007K]8ek\u000e,'o]\u000b\u0003\u0005+\u0004\u0002Ba6\u0003^\u0006E\u0017\u0011R\u0007\u0003\u00053TAAa7\u0002J\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u001f\u0014I.A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005m\u0017\u0001\u00057pC\u00124%o\\7T]\u0006\u00048\u000f[8u)\u0019\t)La:\u0003l\"9!\u0011\u001e&A\u0002\u0005E\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005[T\u0005\u0019AAi\u0003-\u0019WO\u001d:f]R$\u0016.\\3\u0002#1|\u0017\r\u001a)s_\u0012,8-\u001a:F]R\u0014\u0018\u0010\u0006\u0003\u00026\nM\bb\u0002B{\u0017\u0002\u0007\u0011\u0011R\u0001\u0006K:$(/_\u0001\u0012SN\u0004&o\u001c3vG\u0016\u0014X\t\u001f9je\u0016$GCBAn\u0005w\u0014y\u0010C\u0004\u0003~2\u0003\r!!5\u0002\u001b\r,(O]3oiRKW.Z't\u0011\u001d\u0019\t\u0001\u0014a\u0001\u0003\u0013\u000bQ\u0002\u001d:pIV\u001cWM]*uCR,\u0017A\u0006:f[>4X-\u0012=qSJ,G\r\u0015:pIV\u001cWM]:\u0015\t\u0005U6q\u0001\u0005\b\u0005{l\u0005\u0019AAi\u0003E!(/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a\u000b\t\u0003k\u001biaa\u0004\u0004\u0014!9!\u0011\u001e(A\u0002\u0005E\u0007bBB\t\u001d\u0002\u0007\u0011\u0011[\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0005{t\u0005\u0019AAi\u0003a\u0011X\r\\8bI\u001a\u0013x.\u001c+jKJ,Gm\u00158baNDw\u000e\u001e\u000b\u000b\u0003k\u001bIba\u0007\u0004\u001e\r\u0005\u0002b\u0002Bu\u001f\u0002\u0007\u0011\u0011\u001b\u0005\b\u0005[|\u0005\u0019AAi\u0011\u001d\u0019yb\u0014a\u0001\u0003K\u000bab\u001d8baNDw\u000e\u001e\"vM\u001a,'\u000fC\u0004\u0004$=\u0003\r!!5\u0002\u001dMt\u0017\r]:i_R|eMZ:fi\u0006i\u0001O]3qCJ,W\u000b\u001d3bi\u0016$ba!\u000b\u00040\rM\u0002c\u00015\u0004,%\u00191Q\u00062\u0003%A\u0013x\u000eZ;dKJ\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0007c\u0001\u0006\u0019AAi\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\b\u0007k\u0001\u0006\u0019AB\u001c\u0003\u0019y'/[4j]B\u0019\u0001n!\u000f\n\u0007\rm\"M\u0001\u0007BaB,g\u000eZ(sS\u001eLg.\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003k\u001b\t\u0005C\u0004\u0004DE\u0003\ra!\u000b\u0002\u0015\u0005\u0004\b/\u001a8e\u0013:4w.\u0001\nva\u0012\fG/Z'ba\u0016sGm\u00144gg\u0016$H\u0003BA[\u0007\u0013Bqaa\u0013S\u0001\u0004\t\t.\u0001\u0006mCN$xJ\u001a4tKR\f\u0011\u0002\\1ti\u0016sGO]=\u0015\t\rE31\u000b\t\u0006Y\n%\u0012\u0011\u0012\u0005\b\u0007c\u0019\u0006\u0019AAi\u00031!\u0018m[3T]\u0006\u00048\u000f[8u)\t\t),\u0001\u000bmCR,7\u000f^*oCB\u001c\bn\u001c;PM\u001a\u001cX\r^\u0001\u0015_2$Wm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\u0002\u0019Q\u0014XO\\2bi\u0016DU-\u00193\u0015\t\u0005U6\u0011\r\u0005\b\u0005S<\u0006\u0019AAi\u0003y\u0011X-\\8wKVs'/\u001a9mS\u000e\fG/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u00026\u000e\u001d\u0004bBA}1\u0002\u0007\u0011\u0011[\u0001\tiJ,hnY1uK\u0006\u0001B.Y:u'R\f'\r\\3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003#\u001cy\u0007C\u0004\u0004ri\u0003\raa\u001d\u0002\u0019\r|W\u000e\u001d7fi\u0016$G\u000b\u001f8\u0011\u0007!\u001c)(C\u0002\u0004x\t\u0014AbQ8na2,G/\u001a3Uq:\f1bY8na2,G/\u001a+y]R!\u0011QWB?\u0011\u001d\u0019\th\u0017a\u0001\u0007g\"B!!.\u0004\u0002\"9\u0011\u0011 /A\u0002\u0005E\u0007f\u0001/\u0004\u0006B!!1HBD\u0013\u0011\u0019II!\u0010\u0003\u0015QD'/Z1eg\u00064W-\u0001\npY\u0012,7\u000f^*oCB\u001c\bn\u001c;GS2,WC\u0001B\u0014\u0003Ia\u0017\r^3tiNs\u0017\r]:i_R4\u0015\u000e\\3\u0016\u0005\u0005\u001dH\u0003\u0002B\u0014\u0007+Cq!!?a\u0001\u0004\t\t\u000eK\u00020\u00073\u0003BAa\u000f\u0004\u001c&!1Q\u0014B\u001f\u00055qwN\u001c;ie\u0016\fGm]1gK\u0002")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(ByteBuffer byteBuffer) {
        return ProducerStateManager$.MODULE$.readSnapshot(byteBuffer);
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    public Option<LogOffsetMetadata> firstUnstableOffset() {
        Option option = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ProducerStateManager.$anonfun$firstUnstableOffset$1((Map.Entry)map_this.get()));
        Option option2 = Option$.MODULE$.apply(this.ongoingTxns().firstEntry());
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object2 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)ProducerStateManager.$anonfun$firstUnstableOffset$2((Map.Entry)map_this2.get()));
        if (object.isEmpty()) {
            return object2;
        }
        if (object2.isEmpty()) {
            return object;
        }
        if (((LogOffsetMetadata)object2.get()).messageOffset() < ((LogOffsetMetadata)object.get()).messageOffset()) {
            return object2;
        }
        return object;
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        Option option = Option$.MODULE$.apply(this.ongoingTxns().firstEntry());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1((Map.Entry)map_this.get())));
        return object;
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        Option<File> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            File file = (File)((Some)option).value();
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(file).append("'").toString());
                ((Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTime, producerEntry)))).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    this.loadProducerEntry(entry);
                    return BoxedUnit.UNIT;
                });
                this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                this.lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(file).append("': ").append(e.getMessage()).toString());
                Files.deleteIfExists(file.toPath());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        Option<Object> option = entry.currentTxnFirstOffset();
        if (option == null) {
            throw null;
        }
        Option<Object> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            Object object = foreach_this.get();
            ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)object));
            return;
        }
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, BoxesRunTime.unboxToLong((Object)x0$1), x1$1)));
    }

    /*
     * WARNING - void declaration
     */
    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        void kafka$log$ProducerStateManager$$deleteSnapshotFiles_predicate;
        void kafka$log$ProducerStateManager$$deleteSnapshotFiles_dir;
        ProducerStateManager$ producerStateManager$ = ProducerStateManager$.MODULE$;
        JFunction1.mcZJ.sp & Serializable & scala.Serializable intersect = (JFunction1.mcZJ.sp & Serializable & scala.Serializable)snapOffset -> snapOffset > logEndOffset || snapOffset <= logStartOffset;
        File file = this.logDir();
        if (producerStateManager$ == null) {
            throw null;
        }
        ((IterableLike)producerStateManager$.listSnapshotFiles((File)kafka$log$ProducerStateManager$$deleteSnapshotFiles_dir).filter(arg_0 -> ProducerStateManager$.$anonfun$deleteSnapshotFiles$1$adapted((Function1)kafka$log$ProducerStateManager$$deleteSnapshotFiles_predicate, arg_0))).foreach(ProducerStateManager$::$anonfun$deleteSnapshotFiles$2$adapted);
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
            return;
        }
        this.truncateHead(logStartOffset);
    }

    public void reloadFromTieredSnapshot(long logStartOffset, long currentTime, ByteBuffer snapshotBuffer, long snapshotOffset) {
        if (this.activeProducers().nonEmpty()) {
            throw new IllegalStateException("expected producer state to be fully truncated before reloading tiered snapshot");
        }
        try {
            Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshotBuffer).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$reloadFromTieredSnapshot$1(this, currentTime, producerEntry)));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("restored state for ").append(loadedProducers.size()).append(" producers from tiered storage").toString());
            loadedProducers.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                this.loadProducerEntry(entry);
                return BoxedUnit.UNIT;
            });
            this.lastMapOffset_$eq(snapshotOffset);
            return;
        }
        catch (CorruptSnapshotException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to load producer snapshot from buffer: ").append(e.getMessage()).toString());
            throw e;
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin) {
        Option<ProducerStateEntry> option = this.lastEntry(producerId);
        if (option == null) {
            throw null;
        }
        Option<ProducerStateEntry> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? ProducerStateEntry$.MODULE$.empty(producerId) : getOrElse_this.get();
        ProducerStateEntry currentEntry = (ProducerStateEntry)object;
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append("for partition ").append(this.topicPartition()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            ((ProducerStateEntry)((Some)option).value()).update(updatedEntry);
        } else if (None$.MODULE$.equals(option)) {
            this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        List list = appendInfo.startedTransactions();
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            TxnMetadata txnMetadata = (TxnMetadata)foreach_these.head();
            ProducerStateManager.$anonfun$update$2(this, txnMetadata);
            foreach_these = (List)foreach_these.tail();
        }
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.lastMapOffset() > this.lastSnapOffset()) {
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.lastMapOffset());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Writing producer snapshot at offset ").append(this.lastMapOffset()).toString());
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        Option<File> option = this.latestSnapshotFile();
        if (option == null) {
            throw null;
        }
        Option<File> map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile((File)map_this.get())));
        return object;
    }

    public Option<Object> oldestSnapshotOffset() {
        Option<File> option = this.oldestSnapshotFile();
        if (option == null) {
            throw null;
        }
        Option<File> map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile((File)map_this.get())));
        return object;
    }

    public void truncateHead(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.deleteSnapshotsBefore(logStartOffset);
        Option<Object> option = this.latestSnapshotOffset();
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToLong((long)logStartOffset) : getOrElse_this.get();
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)object));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            long l;
            Option<Object> lastOffset = iterator.next().getValue().lastOffset();
            if (lastOffset == null) {
                throw null;
            }
            boolean bl = !lastOffset.isEmpty() && ProducerStateManager.$anonfun$removeUnreplicatedTransactions$1(offset, l = BoxesRunTime.unboxToLong((Object)lastOffset.get()));
            if (!bl) continue;
            iterator.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(0L);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        Option nextIncompleteTxn = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.ongoingTxns().values()).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$8)));
        if (nextIncompleteTxn == null) {
            throw null;
        }
        Object object = nextIncompleteTxn.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$2((TxnMetadata)nextIncompleteTxn.get())));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$3(completedTxn)) : object.get();
        return BoxesRunTime.unboxToLong((Object)object2);
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        if (files.nonEmpty()) {
            return new Some(files.minBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$));
        }
        return None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        if (files.nonEmpty()) {
            return new Some(files.maxBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$));
        }
        return None$.MODULE$;
    }

    public Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public Option<File> snapshotFileForOffset(long offset) {
        return ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$snapshotFileForOffset(this.logDir(), offset);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$firstUnstableOffset$1(Map.Entry x$4) {
        return ((TxnMetadata)x$4.getValue()).firstOffset();
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$firstUnstableOffset$2(Map.Entry x$5) {
        return ((TxnMetadata)x$5.getValue()).firstOffset();
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTime$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, long x0$1, ProducerStateEntry x1$1) {
        ProducerStateEntry lastEntry = x1$1;
        return !$this.isProducerExpired(currentTimeMs$1, lastEntry);
    }

    public static final /* synthetic */ boolean $anonfun$reloadFromTieredSnapshot$1(ProducerStateManager $this, long currentTime$2, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$2, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$update$2(ProducerStateManager $this, TxnMetadata txn) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), txn);
    }

    public static final /* synthetic */ boolean $anonfun$removeUnreplicatedTransactions$1(long offset$4, long x$7) {
        return x$7 < offset$4;
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$8) {
        return x$8.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$9) {
        return x$9.firstOffset().messageOffset();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$3(CompletedTxn completedTxn$1) {
        return completedTxn$1.lastOffset() + 1L;
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }

    public static final /* synthetic */ Object $anonfun$firstUndecidedOffset$1$adapted(Map.Entry x$6) {
        return BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6));
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1$adapted(ProducerStateManager $this, long producerId$1, Object offset) {
        return ProducerStateManager.$anonfun$loadProducerEntry$1($this, producerId$1, BoxesRunTime.unboxToLong((Object)offset));
    }

    public static final /* synthetic */ Object $anonfun$latestSnapshotOffset$1$adapted(File file) {
        return BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file));
    }

    public static final /* synthetic */ Object $anonfun$oldestSnapshotOffset$1$adapted(File file) {
        return BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file));
    }

    public static final /* synthetic */ Object $anonfun$lastStableOffset$2$adapted(TxnMetadata x$9) {
        return BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$2(x$9));
    }
}

